/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.criteria;

import com.isomorphic.criteria.AdvancedCriteria;
import com.isomorphic.criteria.CanParseCriterion;
import com.isomorphic.criteria.Criterion;
import com.isomorphic.criteria.DefaultOperators;
import com.isomorphic.criteria.Operator;
import com.isomorphic.criteria.SimpleCriteria;
import com.isomorphic.criteria.SubqueryResolver;
import com.isomorphic.criteria.criterion.CustomCriterion;
import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSRequestSubqueryResolver;
import com.isomorphic.log.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;

public class Evaluator {
    public static Logger log = new Logger(Evaluator.class.getName());
    private Map<String, Operator> customOperators;
    protected AdvancedCriteria advancedCriteria;
    protected SimpleCriteria simpleCriteria;
    protected Criterion criterion;
    protected String textMatchStyle;
    protected SubqueryResolver subqueryResolver;

    public Evaluator() {
    }

    public Evaluator(Object criteria, String textMatchStyle) {
        if (criteria == null) {
            log.warn("null criteria supplied to new Evaluator()");
            return;
        }
        if (criteria instanceof SimpleCriteria) {
            this.simpleCriteria = (SimpleCriteria)criteria;
            this.textMatchStyle = textMatchStyle;
        } else if (criteria instanceof Map) {
            this.simpleCriteria = new SimpleCriteria((Map)criteria);
            this.textMatchStyle = textMatchStyle;
        } else if (criteria instanceof AdvancedCriteria) {
            this.advancedCriteria = (AdvancedCriteria)criteria;
        } else if (criteria instanceof Criterion) {
            this.criterion = (Criterion)criteria;
        } else {
            throw new IllegalArgumentException("unrecognized criteria provided to new Evaluator(): " + criteria.getClass().getName());
        }
    }

    public Evaluator(Object criteria, String textMatchStyle, SubqueryResolver resolver) {
        this(criteria, textMatchStyle);
        this.subqueryResolver = resolver;
    }

    public void setSubqueryResolver(SubqueryResolver resolver) {
        this.subqueryResolver = resolver;
    }

    public void addSearchOperator(Operator op) {
        if (this.customOperators == null) {
            this.customOperators = new HashMap<String, Operator>();
        }
        if (this.customOperators.containsValue(op)) {
            log.warn("Attempted to add existing operator " + op.getID() + " - replacing");
        } else if (this.customOperators.containsKey(op.getID())) {
            log.warn("Two different operators have the same ID " + op.getID() + " - replacing.");
        }
        this.customOperators.put(op.getID(), op);
    }

    Operator getSearchOperator(String id) {
        Operator object = DefaultOperators.getDefaultOperatorMap().get(id);
        if (object == null && this.customOperators != null) {
            object = this.customOperators.get(id);
        }
        return object;
    }

    public boolean valuesMatchCriteria(Map values) throws Exception {
        if (this.simpleCriteria != null) {
            return this.valuesMatchCriteria(values, this.simpleCriteria, this.textMatchStyle);
        }
        if (this.advancedCriteria != null) {
            return this.valuesMatchCriteria(values, this.advancedCriteria);
        }
        if (this.criterion != null) {
            return this.evaluateCriterion(values, this.criterion);
        }
        throw new IllegalStateException("No criteria was supplied to constructor");
    }

    public boolean valuesMatchCriteria(Map values, SimpleCriteria sc, String textMatchStyle) throws Exception {
        return sc.valuesMatchCriteria(values, textMatchStyle);
    }

    public boolean valuesMatchCriteria(Map values, AdvancedCriteria ac) throws Exception {
        return this.evaluateCriterion(values, ac.criteria);
    }

    public boolean evaluateCriterion(Map values, Criterion criterion) throws Exception {
        if (criterion == null) {
            throw new Exception("Null criterion found (Invalid operator ID probably used)");
        }
        if (AdvancedCriteria.hasACSCriterion(criterion, null)) {
            if (this.subqueryResolver != null) {
                Map<String, Object> criteriaMap = AdvancedCriteria.toCollections(criterion);
                AdvancedCriteria.resolveSubqueries(criteriaMap, this.subqueryResolver);
                Criterion resolved = Evaluator.parseCriterion(criteriaMap);
                return this.evaluateCriterion(values, resolved);
            }
            throw new Exception("Criterion contains a fieldQuery or valueQuery clause.  Such criteria cannot be directly evaluated without a SubqueryResolver.  Either call AdvancedCriteria.resolveSubqueries() first, use the Evaluator(criteria, textMatchStyle, resolver) constructor, or attach the criteria to a DSRequest and execute() it");
        }
        Operator operator = this.getSearchOperator(criterion.getOperatorId());
        if (operator == null) {
            throw new Exception("No operator for id=" + criterion.getOperatorId());
        }
        try {
            return operator.condition(values, criterion, this);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static AdvancedCriteria parseAdvancedCriteria(Map rawCriteria) {
        return new AdvancedCriteria(Evaluator.parseCriterion(rawCriteria));
    }

    public static Criterion parseCriterion(Map rawCriteria) {
        Object objOperator;
        if (!rawCriteria.containsKey("operator") && (rawCriteria.containsKey("fieldName") || rawCriteria.containsKey("fieldQuery"))) {
            rawCriteria.put("operator", "equals");
            if (!rawCriteria.containsKey("value") && !rawCriteria.containsKey("valueQuery")) {
                rawCriteria.put("value", true);
            }
        }
        if (!rawCriteria.containsKey("operator") && rawCriteria.containsKey("criteria")) {
            rawCriteria.put("operator", "and");
        }
        String operatorId = (objOperator = rawCriteria.get("operator")) == null ? null : String.valueOf(objOperator);
        Map<String, Operator> operators = DefaultOperators.getDefaultOperatorMap();
        Operator operator = operators.get(operatorId);
        if (operator != null && operator instanceof CanParseCriterion) {
            return ((CanParseCriterion)((Object)operator)).parseCriterion(rawCriteria);
        }
        log.warn("Unrecognized operator \"" + operatorId + "\", treating as a CustomCriterion.");
        return new CustomCriterion(operatorId, rawCriteria);
    }

    public List<Map> filterRecords(List<Map> records) throws Exception {
        return this.filterRecordsInternal(records);
    }

    public List<Map> filterRecords(List<Map> records, BasicDataSource parentDS) throws Exception {
        Criterion crit;
        if (this.subqueryResolver == null && this.advancedCriteria != null && parentDS != null && AdvancedCriteria.hasACSCriterion(crit = this.advancedCriteria.asCriterion(), null)) {
            this.subqueryResolver = new DSRequestSubqueryResolver(parentDS);
        }
        return this.filterRecordsInternal(records);
    }

    private List<Map> filterRecordsInternal(List<Map> records) throws Exception {
        Criterion crit;
        if (this.subqueryResolver != null && this.advancedCriteria != null && AdvancedCriteria.hasACSCriterion(crit = this.advancedCriteria.asCriterion(), null)) {
            Map<String, Object> criteriaMap = AdvancedCriteria.toCollections(crit);
            AdvancedCriteria.resolveSubqueries(criteriaMap, this.subqueryResolver);
            Criterion resolved = Evaluator.parseCriterion(criteriaMap);
            this.advancedCriteria = new AdvancedCriteria(resolved);
            this.subqueryResolver = null;
        }
        ArrayList<Map> filtered = new ArrayList<Map>();
        for (Map record : records) {
            if (!this.valuesMatchCriteria(record)) continue;
            filtered.add(record);
        }
        return filtered;
    }

    public static Object getPathValue(Map values, String fieldPath) {
        if (!fieldPath.contains(".")) {
            return values.get(fieldPath);
        }
        String[] path = fieldPath.split("\\.");
        Map object = values;
        for (String pathPart : path) {
            object = object.get(pathPart);
        }
        return object;
    }

    public static String getPathValueAsString(Map values, String fieldPath) {
        return ObjectUtils.toString((Object)Evaluator.getPathValue(values, fieldPath));
    }
}

