/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.criteria;

import com.isomorphic.criteria.Criterion;
import com.isomorphic.criteria.DefaultOperators;
import com.isomorphic.criteria.Evaluator;
import com.isomorphic.criteria.Operator;
import com.isomorphic.criteria.OperatorBase;
import com.isomorphic.criteria.SubqueryResolver;
import com.isomorphic.criteria.criterion.AndCriterion;
import com.isomorphic.criteria.criterion.CustomCriterion;
import com.isomorphic.criteria.criterion.LogicalCriterion;
import com.isomorphic.criteria.criterion.NotCriterion;
import com.isomorphic.criteria.criterion.OrCriterion;
import com.isomorphic.criteria.criterion.RangeCriterion;
import com.isomorphic.criteria.criterion.SetCriterion;
import com.isomorphic.criteria.criterion.SimpleCriterion;
import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.date.DateUtil;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.ObjectUtils;

public class AdvancedCriteria {
    protected static Logger log = new Logger(AdvancedCriteria.class);
    public static final String CONSTRUCTOR_NAME = "AdvancedCriteria";
    Criterion criteria;
    Boolean strictSQLFiltering = null;

    public AdvancedCriteria(Criterion _criteria) {
        Map criteriaMap;
        this.criteria = _criteria;
        if (this.criteria instanceof Map && (criteriaMap = (Map)((Object)this.criteria)).get("strictSQLFiltering") != null) {
            this.strictSQLFiltering = (Boolean)criteriaMap.get("strictSQLFiltering");
        }
    }

    public AdvancedCriteria(Operator operator, Criterion ... criteria) {
        this(operator.getID(), criteria);
    }

    public AdvancedCriteria(String operator, Criterion ... criteria) {
        this.criteria = criteria.length == 1 ? (operator.equals(DefaultOperators.Not.getID()) ? new NotCriterion(criteria) : criteria[0]) : (operator.equals(DefaultOperators.And.getID()) ? new AndCriterion(criteria) : (operator.equals(DefaultOperators.Or.getID()) ? new OrCriterion(criteria) : (operator.equals(DefaultOperators.Not.getID()) ? new NotCriterion(criteria) : new LogicalCriterion(operator, criteria))));
    }

    public Object getFieldValue(String fieldName) {
        Criterion criterion = this.getFieldCriterion(fieldName);
        if (criterion != null) {
            try {
                if (criterion instanceof SetCriterion) {
                    return ((SetCriterion)criterion).getValues();
                }
                return criterion.getValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public Criterion getFieldCriterion(String fieldName) {
        return this.getFieldCriterion(fieldName, this.criteria);
    }

    public Criterion getFieldCriterion(String fieldName, Criterion criteria) {
        if (criteria instanceof LogicalCriterion) {
            LogicalCriterion lc = (LogicalCriterion)criteria;
            if (lc.getCriteria() != null) {
                for (Criterion c : lc.getCriteria()) {
                    Criterion res = this.getFieldCriterion(fieldName, c);
                    if (res == null) continue;
                    return res;
                }
            }
        } else if (criteria != null && criteria.getFieldName() != null && criteria.getFieldName().equals(fieldName)) {
            return criteria;
        }
        return null;
    }

    public boolean removeFieldCriterion(String fieldName) {
        return this.removeFieldCriterion(fieldName, this.criteria);
    }

    public boolean removeFieldCriterion(String fieldName, Criterion criteria) {
        if (criteria instanceof LogicalCriterion) {
            LogicalCriterion lc = (LogicalCriterion)criteria;
            if (lc.getCriteria() != null) {
                Iterator<Criterion> ic = lc.getCriteria().iterator();
                while (ic.hasNext()) {
                    Criterion c = ic.next();
                    boolean shouldRemove = this.removeFieldCriterion(fieldName, c);
                    if (!shouldRemove) continue;
                    ic.remove();
                    return true;
                }
            }
        } else if (criteria != null && criteria.getFieldName() != null && criteria.getFieldName().equals(fieldName)) {
            return true;
        }
        return false;
    }

    public void convertRelativeDates() {
        this.convertRelativeDates((Date)null);
    }

    public void convertRelativeDates(DataSource ds) {
        this.convertRelativeDates(null, ds);
    }

    public void convertRelativeDates(Date baseDate) {
        this.criteria = DataSource.convertRelativeDates(this.criteria, baseDate, null);
    }

    public void convertRelativeDates(Date baseDate, DataSource ds) {
        this.criteria = DataSource.convertRelativeDates(this.criteria, baseDate, ds);
    }

    public void convertRelativeDates(Date baseDate, DataSource ds, boolean useEmbeddedTZ) {
        this.criteria = DataSource.convertRelativeDates(this.criteria, baseDate, ds, useEmbeddedTZ);
    }

    public static boolean hasRelativeDates(Object criteriaObject) {
        if (criteriaObject != null) {
            if (criteriaObject instanceof List) {
                for (Object l : (List)criteriaObject) {
                    if (!AdvancedCriteria.hasRelativeDates(l)) continue;
                    return true;
                }
            } else if (criteriaObject instanceof Map) {
                Map criteriaMap = (Map)criteriaObject;
                if (criteriaMap.containsKey("criteria")) {
                    Iterator i = DataTools.makeListIfSingle(criteriaMap.get("criteria")).iterator();
                    while (i.hasNext()) {
                        if (!AdvancedCriteria.hasRelativeDates(i.next())) continue;
                        return true;
                    }
                } else {
                    if (DateUtil.isRelativeDate(criteriaMap.get("value"))) {
                        return true;
                    }
                    if (DateUtil.isRelativeDate(criteriaMap.get("start"))) {
                        return true;
                    }
                    if (DateUtil.isRelativeDate(criteriaMap.get("end"))) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public void setStrictSQLFiltering(Boolean strictSQLFiltering) {
        this.strictSQLFiltering = strictSQLFiltering;
    }

    public Boolean getStrictSQLFiltering() {
        return this.strictSQLFiltering;
    }

    public static AdvancedCriteria decodeClientCriteria(String clientCriteria) throws Exception {
        return AdvancedCriteria.fromCollections(JSTranslater.get().fromJS(clientCriteria));
    }

    public Set<Criterion> getFieldCriterions(String fieldName) {
        return this.getFieldCriterions(fieldName, this.criteria, new HashSet<Criterion>());
    }

    public Set<Criterion> getFieldCriterions(String fieldName, Criterion criteria, Set<Criterion> resultAccumulator) {
        if (criteria instanceof LogicalCriterion) {
            LogicalCriterion lc = (LogicalCriterion)criteria;
            if (lc.getCriteria() != null) {
                for (Criterion c : lc.getCriteria()) {
                    this.getFieldCriterions(fieldName, c, resultAccumulator);
                }
            }
        } else if (criteria.getFieldName() != null && fieldName.equals(criteria.getFieldName())) {
            resultAccumulator.add(criteria);
        }
        return resultAccumulator;
    }

    public Map<String, Object> getCriteriaAsMap() {
        if (this.criteria == null) {
            return null;
        }
        Operator o = DefaultOperators.getDefaultOperatorMap().get(this.criteria.getOperatorId());
        if (o instanceof OperatorBase) {
            Map<String, Object> result = ((OperatorBase)o).convertToMap(this.criteria);
            result.put("_constructor", CONSTRUCTOR_NAME);
            if (this.getStrictSQLFiltering() != null) {
                result.put("strictSQLFiltering", this.getStrictSQLFiltering());
            }
            return result;
        }
        if (this.criteria instanceof CustomCriterion) {
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>((Map)((Object)this.criteria));
            result.put("_constructor", CONSTRUCTOR_NAME);
            if (this.getStrictSQLFiltering() != null) {
                result.put("strictSQLFiltering", this.getStrictSQLFiltering());
            }
            return result;
        }
        return null;
    }

    public static boolean isAdvancedCriteria(Map<String, Object> criteriaMap) {
        return AdvancedCriteria.isAdvancedCriteria(criteriaMap, null);
    }

    public static boolean isAdvancedCriteria(Map<String, Object> criteriaMap, DataSource dataSource) {
        Object subFieldName;
        Object criterion;
        if (criteriaMap == null || criteriaMap.isEmpty()) {
            return false;
        }
        String constructor = (String)criteriaMap.get("_constructor");
        if (CONSTRUCTOR_NAME.equals(constructor)) {
            return true;
        }
        String operator = (String)criteriaMap.get("operator");
        Operator searchOp = null;
        if (operator != null) {
            searchOp = dataSource != null ? dataSource.getEvaluator().getSearchOperator(operator) : DefaultOperators.getDefaultOperatorMap().get(operator);
        }
        boolean returnVal = false;
        List subCriteria = DataTools.makeListIfSingle(criteriaMap.get("criteria"));
        if (subCriteria.size() > 0 && (criterion = subCriteria.get(0)) instanceof Map && (subFieldName = ((Map)criterion).get("fieldName")) instanceof String && !"".equals(subFieldName)) {
            returnVal = true;
        }
        String fieldName = (String)criteriaMap.get("fieldName");
        if (!returnVal) {
            if (dataSource != null && dataSource.getField(fieldName) != null && searchOp != null) {
                returnVal = true;
            } else if (dataSource != null && (dataSource.getField("fieldName") != null || dataSource.getField("operator") != null)) {
                returnVal = false;
            } else if (fieldName != null && operator != null && searchOp != null) {
                boolean operatorRequiresValue = true;
                if (searchOp instanceof OperatorBase) {
                    operatorRequiresValue = ((OperatorBase)searchOp).isRequiresValue();
                }
                if (!operatorRequiresValue) {
                    returnVal = true;
                } else if (criteriaMap.containsKey("value")) {
                    returnVal = true;
                }
            } else if (dataSource != null && dataSource.getField(fieldName) != null && operator == null && criteriaMap.get("value") == null) {
                returnVal = true;
            } else if (operator != null && ("and".equals(operator.trim()) || "or".equals(operator.trim()))) {
                returnVal = true;
            }
        }
        if (!returnVal) {
            if (operator != null && searchOp != null && criteriaMap.get("fieldQuery") != null) {
                returnVal = true;
            } else if (operator != null && searchOp != null && criteriaMap.get("valueQuery") != null) {
                returnVal = true;
            }
        }
        if (returnVal) {
            log.info("Criteria object:" + DataTools.prettyPrint(criteriaMap) + " not explicitly marked as AdvancedCriteria but treating as Advanced based on format.");
        }
        return returnVal;
    }

    public static Map<String, Object> getFlattenedFieldValueMap(final Map<String, Object> criteriaPart) {
        HashMap<String, Object> fieldValueMap = new HashMap<String, Object>();
        if (!AdvancedCriteria.isAdvancedCriteria(criteriaPart)) {
            return fieldValueMap;
        }
        Object object = criteriaPart.get("criteria");
        if (object == null) {
            object = new ArrayList(){
                {
                    this.add(criteriaPart);
                }
            };
        }
        if (object instanceof List) {
            List objects = (List)object;
            for (Object listObject : objects) {
                if (!(listObject instanceof Map)) continue;
                Map objectMap = (Map)listObject;
                String fieldName = String.valueOf(objectMap.get("fieldName"));
                if (fieldName != null) {
                    if (fieldValueMap.containsKey(fieldName)) continue;
                    fieldValueMap.put(ObjectUtils.toString((Object)fieldName), objectMap.get("value"));
                    continue;
                }
                if (!CONSTRUCTOR_NAME.equalsIgnoreCase(String.valueOf(objectMap.get("_constructor")))) continue;
                for (Map.Entry<String, Object> entry : AdvancedCriteria.getFlattenedFieldValueMap(objectMap).entrySet()) {
                    if (fieldValueMap.containsKey(entry.getKey())) continue;
                    fieldValueMap.put(entry.getKey(), entry.getValue());
                }
            }
        }
        return fieldValueMap;
    }

    public static Map<String, Object> getCriteriaAsMap(Criterion criterion) {
        Operator o = DefaultOperators.getDefaultOperatorMap().get(criterion.getOperatorId());
        if (o instanceof OperatorBase) {
            return ((OperatorBase)o).convertToMap(criterion);
        }
        if (criterion instanceof CustomCriterion) {
            return new LinkedHashMap<String, Object>((Map)((Object)criterion));
        }
        return null;
    }

    public static Boolean isFieldComparisonOperator(String operator) {
        return operator != null && (operator.equals("equalsField") || operator.equals("notEqualField") || operator.equals("greaterThanField") || operator.equals("greaterOrEqualField") || operator.equals("lessThanField") || operator.equals("lessOrEqualField") || operator.equals("containsField") || operator.equals("iContainsField") || operator.equals("startsWithField") || operator.equals("iStartsWithField") || operator.equals("endsWithField") || operator.equals("iEndsWithField") || operator.equals("iEqualsField") || operator.equals("notContainsField") || operator.equals("iNotContainsField") || operator.equals("notStartsWithField") || operator.equals("iNotStartsWithField") || operator.equals("notEndsWithField") || operator.equals("iNotEndsWithField") || operator.equals("iNotEqualField"));
    }

    public static AdvancedCriteria fromCollections(Object criteria) {
        return AdvancedCriteria.fromCollections(criteria, DefaultOperators.Equals.getID());
    }

    public static AdvancedCriteria fromCollections(Object criteria, String operator) {
        return AdvancedCriteria.fromCollections(criteria, operator, null);
    }

    public static AdvancedCriteria fromCollections(Object criteria, OperatorBase operator) {
        return AdvancedCriteria.fromCollections(criteria, operator.getID(), null);
    }

    public static AdvancedCriteria fromCollections(Object criteria, OperatorBase operator, DSRequest req) {
        return AdvancedCriteria.fromCollections(criteria, operator.getID(), req);
    }

    public static AdvancedCriteria fromCollections(Object criteria, String operator, DSRequest req) {
        ArrayList l = null;
        if (criteria instanceof List) {
            l = (ArrayList)criteria;
        } else if (criteria instanceof Collection) {
            l = new ArrayList((Collection)criteria);
        }
        if (l != null) {
            if (l.size() == 0) {
                return null;
            }
            if (l.size() == 1) {
                return DataSource.parseAdvancedCriteria((Map)l.get(0));
            }
            HashMap<String, Object> advCritMap = new HashMap<String, Object>();
            advCritMap.put("_constructor", CONSTRUCTOR_NAME);
            if (operator != null && (DefaultOperators.Or.getID().equals(operator) || DefaultOperators.And.getID().equals(operator))) {
                advCritMap.put("operator", operator);
            } else {
                advCritMap.put("operator", DefaultOperators.And.getID());
            }
            advCritMap.put("criteria", l);
            return DataSource.parseAdvancedCriteria(advCritMap);
        }
        if (criteria instanceof Map) {
            Map criteriaMap = (Map)criteria;
            String constructor = (String)criteriaMap.get("_constructor");
            if (CONSTRUCTOR_NAME.equals(constructor)) {
                return DataSource.parseAdvancedCriteria(criteriaMap);
            }
            ArrayList c = new ArrayList();
            BasicDataSource ds = null;
            if (req != null) {
                try {
                    ds = (BasicDataSource)req.getDataSource();
                }
                catch (Exception e) {
                    log.warn((Object)"Exception converting criteria", e);
                }
            }
            for (Object key : criteriaMap.keySet()) {
                HashMap<String, Object> critMap = new HashMap<String, Object>();
                HashMap<String, Object> innerCritMap = null;
                String overriddenOperator = null;
                Object value = criteriaMap.get(key);
                List valueList = null;
                if (value instanceof List) {
                    valueList = (List)value;
                    if (valueList.size() > 1) {
                        innerCritMap = new HashMap<String, Object>();
                        innerCritMap.put("operator", DefaultOperators.Or.getID());
                        ArrayList innerCritList = new ArrayList();
                        innerCritMap.put("criteria", innerCritList);
                        for (Object listValue : valueList) {
                            overriddenOperator = AdvancedCriteria.getOperator(key, ds, listValue, operator);
                            HashMap<String, Object> innerCriterion = new HashMap<String, Object>();
                            innerCriterion.put("operator", overriddenOperator);
                            innerCriterion.put("fieldName", key);
                            innerCriterion.put("value", listValue);
                            innerCritList.add(innerCriterion);
                        }
                        c.add(innerCritMap);
                        continue;
                    }
                    if (valueList.size() > 0) {
                        value = valueList.get(0);
                    } else {
                        log.warn("Encountered empty list as the value for key '" + String.valueOf(key) + "' in simple criteria.  Ignoring this criterion.");
                        continue;
                    }
                }
                overriddenOperator = AdvancedCriteria.getOperator(key, ds, value, operator);
                critMap.put("operator", overriddenOperator);
                critMap.put("fieldName", key);
                critMap.put("value", value);
                c.add(critMap);
            }
            HashMap<String, Object> advCritMap = new HashMap<String, Object>();
            advCritMap.put("_constructor", CONSTRUCTOR_NAME);
            if (operator != null && (DefaultOperators.Or.getID().equals(operator) || DefaultOperators.And.getID().equals(operator))) {
                advCritMap.put("operator", operator);
            } else {
                advCritMap.put("operator", DefaultOperators.And.getID());
            }
            advCritMap.put("criteria", c);
            return DataSource.parseAdvancedCriteria(advCritMap);
        }
        return null;
    }

    public static Map<String, Object> toCollections(Criterion criterion) {
        return AdvancedCriteria.getCriteriaAsMap(criterion);
    }

    private static String getOperator(Object fieldName, BasicDataSource ds, Object value, String baseOperator) {
        if (ds != null) {
            DSField field = ds.getField((String)fieldName);
            if (field != null) {
                try {
                    String type = ds.getSimpleBaseType(field.getType());
                    if (!("text".equals(type) || ("integer".equals(type) || "float".equals(type)) && value instanceof String)) {
                        return DefaultOperators.Equals.getID();
                    }
                }
                catch (Exception e) {
                    log.warn((Object)"Exception converting criteria", e);
                }
            }
        } else {
            return DefaultOperators.Equals.getID();
        }
        return baseOperator;
    }

    public void addCriteria(Criterion criterion) {
        if (this.criteria == null) {
            this.criteria = new AndCriterion(criterion);
        } else if (this.criteria instanceof AndCriterion) {
            List<Criterion> listCriteria = ((AndCriterion)this.criteria).getCriteria();
            listCriteria.add(criterion);
        } else {
            AndCriterion c = new AndCriterion(criterion);
            List<Criterion> listCriteria = c.getCriteria();
            listCriteria.add(this.criteria);
            this.criteria = c;
        }
    }

    public void addCriteria(String field, OperatorBase operator, Object start, Object end) {
        if (!(operator.getID().equals(DefaultOperators.Between.getID()) || operator.getID().equals(DefaultOperators.BetweenInclusive.getID()) || operator.getID().equals(DefaultOperators.IBetween.getID()) || operator.getID().equals(DefaultOperators.IBetweenInclusive.getID()))) {
            throw new IllegalArgumentException("The passed operator may only be of the type that takes a start and end value such as \"between\" etc.");
        }
        this.addCriteria(new RangeCriterion(field, operator.getID(), (Comparable)start, (Comparable)end));
    }

    public void addCriteria(String field, OperatorBase operator, Object value) {
        if (operator.getID().equals(DefaultOperators.Between.getID()) || operator.getID().equals(DefaultOperators.BetweenInclusive.getID()) || operator.getID().equals(DefaultOperators.IBetween.getID()) || operator.getID().equals(DefaultOperators.IBetweenInclusive.getID())) {
            throw new IllegalArgumentException("The passed operator may only be of the type that takes a singular value such as \"and\" etc. ");
        }
        this.addCriteria(new SimpleCriterion(field, operator, value));
    }

    public Criterion asCriterion() {
        return this.criteria;
    }

    public List<Map> filter(List<Map> unfiltered) throws Exception {
        Evaluator eval = new Evaluator(this, null);
        ArrayList<Map> filtered = new ArrayList<Map>();
        for (Map record : unfiltered) {
            if (!eval.valuesMatchCriteria(record)) continue;
            filtered.add(record);
        }
        return filtered;
    }

    public String toString() {
        return "AdvancedCriteria:[" + String.valueOf(this.criteria) + "]";
    }

    public static boolean hasFieldQueryCriterion(AdvancedCriteria ac) {
        return AdvancedCriteria.hasACSCriterion(ac.asCriterion(), true);
    }

    public static boolean hasValueQueryCriterion(AdvancedCriteria ac) {
        return AdvancedCriteria.hasACSCriterion(ac.asCriterion(), false);
    }

    public static boolean hasACSCriterion(Criterion criterion, Boolean fieldQuery) {
        boolean hasValueQuery;
        if (criterion == null) {
            return false;
        }
        if (criterion instanceof LogicalCriterion) {
            List<Criterion> criterions = ((LogicalCriterion)criterion).getCriteria();
            for (int i = 0; i < criterions.size(); ++i) {
                if (!AdvancedCriteria.hasACSCriterion(criterions.get(i), fieldQuery)) continue;
                return true;
            }
            return false;
        }
        boolean hasFieldQuery = criterion.getFieldQuery() != null;
        boolean bl = hasValueQuery = criterion.getValueQuery() != null;
        return fieldQuery == null ? hasFieldQuery || hasValueQuery : (fieldQuery != false ? hasFieldQuery : hasValueQuery);
    }

    public static void applySubqueryShortcuts(Map criteria) throws Exception {
        if (!AdvancedCriteria.isAdvancedCriteria(criteria)) {
            return;
        }
        if (criteria.containsKey("criteria")) {
            ArrayList subCrit;
            Object subCritObj = criteria.get("criteria");
            if (subCritObj instanceof List) {
                subCrit = (ArrayList)subCritObj;
            } else if (subCritObj instanceof Map) {
                subCrit = new ArrayList();
                subCrit.add(subCritObj);
            } else {
                throw new Exception("While trying to preprocess subquery shortcuts, encountered a property named 'criteria' that is neither a List nor a Map.  Unable to proceed");
            }
            for (int i = 0; i < subCrit.size(); ++i) {
                AdvancedCriteria.applySubqueryShortcuts((Map)subCrit.get(i));
            }
        } else {
            String fieldName = (String)criteria.get("fieldName");
            if (fieldName != null && fieldName.indexOf(46) != -1) {
                String[] elements = fieldName.split("\\!");
                if (elements.length > 1) {
                    fieldName = elements[1];
                }
                elements = fieldName.split("\\.");
                HashMap<String, String> fieldQuery = new HashMap<String, String>();
                fieldQuery.put("dataSource", elements[0]);
                fieldQuery.put("queryOutput", elements[1]);
                criteria.put("fieldQuery", fieldQuery);
                criteria.remove("fieldName");
                log.debug("Replaced shortcut reference '" + fieldName + "' with the corresponding fieldQuery");
            }
        }
    }

    public static void resolveSubqueries(Map criteria, SubqueryResolver resolver) throws Exception {
        AdvancedCriteria.resolveSubqueries(criteria, resolver, null, false);
    }

    public static void resolveSubqueries(Map criteria, SubqueryResolver resolver, boolean skipEmbedded) throws Exception {
        AdvancedCriteria.resolveSubqueries(criteria, resolver, null, skipEmbedded);
    }

    public static void resolveSubqueries(Map criteria, SubqueryResolver resolver, Map separationTracking) throws Exception {
        AdvancedCriteria.resolveSubqueries(criteria, resolver, separationTracking, false);
    }

    private static void resolveSubqueries(Map criteria, SubqueryResolver resolver, Map separationTracking, boolean skipEmbedded) throws Exception {
        if (!AdvancedCriteria.isAdvancedCriteria(criteria)) {
            return;
        }
        if (criteria.containsKey("criteria")) {
            ArrayList subCrit;
            Object subCritObj = criteria.get("criteria");
            if (subCritObj instanceof List) {
                subCrit = (ArrayList)subCritObj;
            } else if (subCritObj instanceof Map) {
                subCrit = new ArrayList();
                subCrit.add(subCritObj);
            } else {
                throw new Exception("While trying to resolve criteria subqueries, encountered a property named 'criteria' that is neither a List nor a Map.  Unable to proceed");
            }
            ArrayList trackingList = null;
            if (separationTracking != null) {
                trackingList = new ArrayList();
                separationTracking.put("criteria", trackingList);
            }
            for (int i = 0; i < subCrit.size(); ++i) {
                HashMap subTracking = trackingList != null ? new HashMap() : null;
                AdvancedCriteria.resolveSubqueries((Map)subCrit.get(i), resolver, subTracking, skipEmbedded);
                if (trackingList == null) continue;
                trackingList.add(subTracking);
            }
        } else {
            boolean shouldSkip;
            Map subquery;
            boolean isSubQuery = false;
            Map fieldQueryResults = null;
            Map valueQueryResults = null;
            if (criteria.containsKey("fieldName")) {
                if (criteria.containsKey("fieldQuery")) {
                    log.warn("Criterion specifies both 'fieldName' and 'fieldQuery'.  These properties are mutually exclusive: dropping 'fieldQuery'");
                    criteria.remove("fieldQuery");
                }
                if (criteria.containsKey("fieldStaticValue")) {
                    log.warn("Criterion specifies both 'fieldName' and 'fieldStaticValue'.  These properties are mutually exclusive: dropping 'fieldStaticValue'");
                    criteria.remove("fieldStaticValue");
                }
            } else if (criteria.containsKey("fieldQuery")) {
                if (criteria.containsKey("fieldStaticValue")) {
                    log.warn("Criterion specifies both 'fieldQuery' and 'fieldStaticValue'.  These properties are mutually exclusive: dropping 'fieldStaticValue'");
                    criteria.remove("fieldStaticValue");
                }
                if ((subquery = (Map)criteria.get("fieldQuery")) != null) {
                    boolean bl = shouldSkip = skipEmbedded && Boolean.FALSE.equals(subquery.get("_shouldSeparate"));
                    if (!shouldSkip) {
                        fieldQueryResults = resolver.resolveSubquery(subquery, true);
                        isSubQuery = fieldQueryResults != null;
                    }
                }
            } else if (criteria.containsKey("fieldStaticValue")) {
                if (!"inSet".equals(criteria.get("operator")) && !"notInSet".equals(criteria.get("operator"))) {
                    log.warn("Criterion specifies a 'fieldStaticValue' but the criterion operator is " + String.valueOf(criteria.get("operator")) + ".  fieldStaticValue only makes sense for the inSet and notInSet operators");
                    return;
                }
                if (!criteria.containsKey("valueQuery")) {
                    return;
                }
            } else if (!criteria.containsKey("valueQuery")) {
                log.warn("Criterion does not specify 'fieldName', 'fieldQuery' or 'fieldStaticValue' - one (and only one) of those properties is required");
                return;
            }
            if (criteria.containsKey("value")) {
                if (criteria.containsKey("valueQuery")) {
                    log.warn("Criterion specifies both 'value' and 'valueQuery'.  These properties are mutually exclusive: dropping 'valueQuery'");
                    criteria.remove("valueQuery");
                }
            } else {
                subquery = (Map)criteria.get("valueQuery");
                if (subquery != null) {
                    boolean bl = shouldSkip = skipEmbedded && Boolean.FALSE.equals(subquery.get("_shouldSeparate"));
                    if (!shouldSkip) {
                        valueQueryResults = resolver.resolveSubquery(subquery, false);
                        if (!isSubQuery) {
                            boolean bl2 = isSubQuery = valueQueryResults != null;
                        }
                    }
                }
            }
            if (!isSubQuery) {
                boolean vqSep;
                Map fq = criteria.containsKey("fieldQuery") ? (Map)criteria.get("fieldQuery") : null;
                Map vq = criteria.containsKey("valueQuery") ? (Map)criteria.get("valueQuery") : null;
                boolean fqSep = fq != null && Boolean.TRUE.equals(fq.get("_shouldSeparate"));
                boolean bl = vqSep = vq != null && Boolean.TRUE.equals(vq.get("_shouldSeparate"));
                if (fq != null && vq != null && fqSep != vqSep) {
                    if (fqSep && !vqSep) {
                        if (Boolean.TRUE.equals(vq.get("canEmbedSQL"))) {
                            String msg = "Criterion has fieldQuery marked for separation but valueQuery is explicitly marked canEmbedSQL:true. Cannot combine a separated subquery with an explicitly embedded one.";
                            log.warn(msg);
                            throw new Exception(msg);
                        }
                        vq.put("_shouldSeparate", true);
                        vqSep = true;
                    } else if (vqSep && !fqSep) {
                        if (Boolean.TRUE.equals(fq.get("canEmbedSQL"))) {
                            String msg = "Criterion has valueQuery marked for separation but fieldQuery is explicitly marked canEmbedSQL:true. Cannot combine a separated subquery with an explicitly embedded one.";
                            log.warn(msg);
                            throw new Exception(msg);
                        }
                        fq.put("_shouldSeparate", true);
                        fqSep = true;
                    }
                }
                if (separationTracking != null) {
                    if (fq != null) {
                        separationTracking.put("fieldQuery", fqSep);
                    }
                    if (vq != null) {
                        separationTracking.put("valueQuery", vqSep);
                    }
                }
                return;
            }
            if (fieldQueryResults != null && valueQueryResults == null && criteria.get("valueQuery") != null || valueQueryResults != null && fieldQueryResults == null && criteria.get("fieldQuery") != null) {
                Map subquery2;
                String msg = "We encountered an AdvancedCriteria with both a 'fieldQuery' and a 'valueQuery'.  The " + (valueQueryResults == null ? "field" : "value") + "Query was separated from the outer query (scan the client docs for 'fieldQuery' for the rules around this) but the " + (valueQueryResults == null ? "value" : "field") + "Query was not.  We can only process both subqueries in SQL, or both as separated subqueries - combining the two in a single criterion is not supported.  ";
                Map map = subquery2 = fieldQueryResults == null ? (Map)criteria.get("fieldQuery") : (Map)criteria.get("valueQuery");
                if (Boolean.TRUE.equals(subquery2.get("canEmbedSQL"))) {
                    msg = msg + "The " + (valueQueryResults == null ? "value" : "field") + "Query is explicitly marked 'canEmbedSQL:true' so we are not going to try separating it.  Cannot continue with subquery processing";
                    log.warn(msg);
                    throw new Exception(msg);
                }
                msg = msg + "So we are going to mark the " + (valueQueryResults == null ? "value" : "field") + "Query for separation and try again";
                log.warn(msg);
                subquery2.put("canEmbedSQL", false);
                boolean retryIsFieldQuery = fieldQueryResults == null;
                Map results = resolver.resolveSubquery(subquery2, retryIsFieldQuery);
                if (results == null) {
                    msg = "Attempt to manually separate a '" + (valueQueryResults == null ? "value" : "field") + "Query' so it is in line with a previously separated '" + (valueQueryResults == null ? "field" : "value") + "Query' did not succeed - the " + (valueQueryResults == null ? "value" : "field") + "Query is still embedded, or returned a null response.  Cannot continue with subquery processing";
                    log.warn(msg);
                    throw new Exception(msg);
                }
                if (valueQueryResults == null) {
                    valueQueryResults = results;
                } else {
                    fieldQueryResults = results;
                }
            }
            if (separationTracking != null) {
                if (criteria.containsKey("fieldQuery")) {
                    separationTracking.put("fieldQuery", fieldQueryResults != null);
                }
                if (criteria.containsKey("valueQuery")) {
                    separationTracking.put("valueQuery", valueQueryResults != null);
                }
            }
            AdvancedCriteria.collapseSubqueryResults(criteria, fieldQueryResults, valueQueryResults);
        }
    }

    private static void collapseSubqueryResults(Map criteria, Map fieldQueryResults, Map valueQueryResults) throws Exception {
        boolean isMultiRVal = false;
        boolean isSetRVal = false;
        List rvals = null;
        Object rval = null;
        String rvalOutputField = null;
        if (valueQueryResults != null) {
            rvals = (List)valueQueryResults.get("records");
            rvalOutputField = (String)valueQueryResults.get("subqueryOutputField");
            if (rvalOutputField == null) {
                rval = AdvancedCriteria.getRVal(rvals, null, null, null);
            } else {
                Operator operator = DefaultOperators.getDefaultOperatorMap().get(criteria.get("operator"));
                if ("inSet".equals(operator) || "notInSet".equals(operator)) {
                    isSetRVal = true;
                    ArrayList set = new ArrayList();
                    for (int i = 0; i < rvals.size(); ++i) {
                        set.add(((Map)rvals.get(i)).get(rvalOutputField));
                    }
                    rval = set;
                } else {
                    boolean bl = isMultiRVal = rvals.size() > 1;
                    if (!isMultiRVal) {
                        rval = AdvancedCriteria.getRVal(rvals, null, rvalOutputField, rvalOutputField);
                    }
                }
            }
        } else {
            rval = criteria.get("value");
        }
        if (fieldQueryResults != null) {
            String rvalIdField;
            HashSet set = new HashSet();
            List records = (List)fieldQueryResults.get("records");
            String subqueryOutputField = (String)fieldQueryResults.get("subqueryOutputField");
            String comparisonField = (String)fieldQueryResults.get("fromFieldName");
            String string = rvalIdField = valueQueryResults == null ? null : (String)valueQueryResults.get("fromFieldName");
            if (isMultiRVal && records != null && records.size() != 0 && records.size() != rvals.size()) {
                Object comparisonValue = ((Map)records.get(0)).get(comparisonField);
                Object emptyValue = comparisonValue instanceof Number ? new Integer(0) : (comparisonValue instanceof Date ? new Date(0L) : "");
                for (int i = 0; i < rvals.size(); ++i) {
                    Map record = DataTools.find(records, comparisonField, ((Map)rvals.get(i)).get(rvalIdField));
                    if (record != null) continue;
                    HashMap<String, Object> newRec = new HashMap<String, Object>();
                    newRec.put(comparisonField, ((Map)rvals.get(i)).get(rvalIdField));
                    newRec.put(subqueryOutputField, emptyValue);
                    records.add(newRec);
                }
            }
            if (subqueryOutputField == null) {
                log.warn("No 'subqueryOutputField' was returned by separated subquery processing, cannot continue");
            } else {
                HashMap<String, Object> dynamicCrit = new HashMap<String, Object>(criteria);
                dynamicCrit.put("fieldName", subqueryOutputField);
                dynamicCrit.put("value", rval);
                dynamicCrit.remove("fieldQuery");
                dynamicCrit.remove("valueQuery");
                log.debug("fieldQuery retrieved " + records.size() + " records.  We will now filter them with the criterion: " + String.valueOf(dynamicCrit) + (isMultiRVal ? " (there are multiple values in this criterion; they will be set each time through the filtering loop)" : ""));
                Criterion c = Evaluator.parseCriterion(dynamicCrit);
                Evaluator e = new Evaluator(c, null);
                for (int i = 0; i < records.size(); ++i) {
                    Map record = (Map)records.get(i);
                    if (isMultiRVal) {
                        rval = AdvancedCriteria.getRVal(rvals, record.get(comparisonField), rvalIdField, rvalOutputField);
                        dynamicCrit.put("value", rval);
                        c = Evaluator.parseCriterion(dynamicCrit);
                        if (c == null) continue;
                        e = new Evaluator(c, null);
                    }
                    if (e.valuesMatchCriteria(record)) {
                        set.add(record.get(comparisonField));
                        log.debug("Row with id " + String.valueOf(record.get(comparisonField)) + " matches the criteria because its value for " + subqueryOutputField + " was " + String.valueOf(record.get(subqueryOutputField)));
                        continue;
                    }
                    log.debug("Excluded row with id " + String.valueOf(record.get(comparisonField)) + " because its value for " + subqueryOutputField + " was " + String.valueOf(record.get(subqueryOutputField)) + ", which fails to match the criteria");
                }
                log.debug("Post-filter, there are " + set.size() + " records in the fieldQuery results");
                criteria.put("fieldName", fieldQueryResults.get("toFieldName"));
                if ("notExists".equals(criteria.get("operator"))) {
                    criteria.put("operator", "notInSet");
                } else {
                    criteria.put("operator", "inSet");
                }
                criteria.put("value", set);
            }
        } else if (isMultiRVal) {
            criteria.put("value", AdvancedCriteria.getMultiRValSet(rvals, rvalOutputField));
        } else {
            criteria.put("value", rval);
        }
        criteria.remove("fieldQuery");
        criteria.remove("valueQuery");
    }

    static Object getRVal(List<Map> rvals, Object idValue, String rvalIdField, String rvalSummaryFunctionField) throws Exception {
        Object candidateValue;
        if (rvals == null || rvals.size() == 0) {
            log.warn("Null or empty rvals collection, returning null");
            return null;
        }
        Number rtnValue = null;
        int end = rvals.size();
        if (idValue == null) {
            end = 1;
        }
        for (int i = 0; i < end; ++i) {
            if (idValue != null && !idValue.equals(rvals.get(i).get(rvalIdField))) continue;
            if (rvalSummaryFunctionField != null) {
                rtnValue = (Number)rvals.get(i).get(rvalSummaryFunctionField);
                continue;
            }
            Map record = rvals.get(i);
            if (record == null || record.isEmpty()) continue;
            rtnValue = (Number)record.values().iterator().next();
        }
        if (rtnValue == null && rvals != null && rvals.size() > 0 && (candidateValue = rvals.get(0).get(rvalSummaryFunctionField)) != null && candidateValue instanceof Number) {
            if (candidateValue instanceof AtomicInteger) {
                rtnValue = new AtomicInteger(0);
            } else if (candidateValue instanceof AtomicLong) {
                rtnValue = new AtomicLong(0L);
            } else {
                try {
                    Constructor<?> cons = candidateValue.getClass().getConstructor(String.class);
                    if (cons != null) {
                        rtnValue = cons.newInstance("0");
                    }
                }
                catch (Exception e) {
                    log.warn((Object)("Caught Exception trying to create an instance of " + String.valueOf(candidateValue.getClass())), e);
                }
            }
        }
        log.info("Returning " + String.valueOf(rtnValue) + " for field " + rvalIdField + " with id " + String.valueOf(idValue));
        return rtnValue;
    }

    static Set getMultiRValSet(List<Map> rvals, String rvalIdField) {
        HashSet rtnValue = new HashSet();
        for (int i = 0; i < rvals.size(); ++i) {
            rtnValue.add(rvals.get(i).get(rvalIdField));
        }
        return rtnValue;
    }
}

