/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.examples.spring;

import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.examples.SupplyItem;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;
import org.hibernate.query.criteria.HibernateCriteriaBuilder;

public class SupplyItemDao {
    Logger log = new Logger(SupplyItemDao.class.getName());
    private SessionFactory sessionFactory;

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public DSResponse fetch(DSRequest dsRequest) throws Exception {
        this.log.info((Object)"procesing DMI fetch operation");
        DSResponse dsResponse = new DSResponse(dsRequest == null ? (DataSource)null : dsRequest.getDataSource());
        Session hibernateSession = this.sessionFactory.getCurrentSession();
        String itemName = (String)dsRequest.getFieldValue((Object)"itemName");
        long startRow = (int)dsRequest.getStartRow();
        long endRow = (int)dsRequest.getEndRow();
        HibernateCriteriaBuilder criteriaBuilder = hibernateSession.getCriteriaBuilder();
        CriteriaQuery countQuery = criteriaBuilder.createQuery(Long.class);
        Root root = countQuery.from(SupplyItem.class);
        Predicate itemNamePredicate = null;
        if (itemName != null) {
            itemNamePredicate = criteriaBuilder.like((Expression)root.get("itemName"), "%" + itemName + "%");
            countQuery.where((Expression)itemNamePredicate);
        }
        countQuery.select((Selection)criteriaBuilder.count((Expression)root));
        Long rowCount = (Long)hibernateSession.createQuery(countQuery).getSingleResult();
        long totalRows = rowCount != null ? rowCount : 0L;
        endRow = Math.min(endRow, totalRows);
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(SupplyItem.class);
        root = criteriaQuery.from(SupplyItem.class);
        if (itemName != null) {
            criteriaQuery.where((Expression)itemNamePredicate);
        }
        Query query = hibernateSession.createQuery(criteriaQuery);
        query.setFirstResult((int)startRow);
        query.setMaxResults((int)(endRow - startRow));
        List matchingItems = query.getResultList();
        dsResponse.setData((Object)matchingItems);
        dsResponse.setStartRow(startRow);
        dsResponse.setEndRow(endRow);
        dsResponse.setTotalRows(totalRows);
        return dsResponse;
    }

    public DSResponse add(DSRequest dsRequest, SupplyItem item) throws Exception {
        this.log.info((Object)"procesing DMI add operation");
        DSResponse dsResponse = new DSResponse();
        Session hibernateSession = this.sessionFactory.getCurrentSession();
        hibernateSession.saveOrUpdate((Object)item);
        dsResponse.setData((Object)item);
        return dsResponse;
    }

    public DSResponse update(DSRequest dsRequest, Map newValues) throws Exception {
        this.log.info((Object)"procesing DMI update operation");
        DSResponse dsResponse = new DSResponse();
        Serializable id = (Serializable)dsRequest.getFieldValue((Object)"itemID");
        Session hibernateSession = this.sessionFactory.getCurrentSession();
        SupplyItem item = (SupplyItem)hibernateSession.get(SupplyItem.class, (Object)id);
        this.log.warn((Object)("fetched item: " + DataTools.prettyPrint((Object)item)));
        DataTools.setProperties((Map)newValues, (Object)item);
        this.log.warn((Object)("Saving record: " + DataTools.prettyPrint((Object)item)));
        hibernateSession.saveOrUpdate((Object)item);
        dsResponse.setData((Object)item);
        return dsResponse;
    }

    public SupplyItem remove(SupplyItem item) throws Exception {
        this.log.info((Object)"procesing DMI remove operation");
        Session hibernateSession = this.sessionFactory.getCurrentSession();
        hibernateSession.delete((Object)item);
        return item;
    }
}

