/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.spring;

import com.isomorphic.log.Logger;
import com.isomorphic.servlet.DataSourceLoader;
import com.isomorphic.servlet.FeatureExplorerRPC;
import com.isomorphic.servlet.FileDownload;
import com.isomorphic.servlet.HttpProxyServlet;
import com.isomorphic.servlet.IDACall;
import com.isomorphic.servlet.ProjectLoaderServlet;
import com.isomorphic.servlet.RESTHandler;
import com.isomorphic.servlet.ScreenLoaderServlet;
import jakarta.servlet.Servlet;
import java.util.Arrays;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;

@Configuration
public class SmartClientSpringBootServletConfig {
    private Logger log;

    public SmartClientSpringBootServletConfig() {
        System.out.println("SmartClientSpringBootServletConfig loaded at: " + System.currentTimeMillis());
    }

    @Bean
    @ConditionalOnMissingBean(name={"CustomIDACallServlet"})
    @ConditionalOnProperty(name={"smartclient.idacall-servlet.enabled"}, havingValue="true", matchIfMissing=true)
    @DependsOn(value={"SmartClientSpringBootServletContextInitializer"})
    public ServletRegistrationBean<IDACall> IDACallServlet() {
        this.log("Mapping an instance of IDACall to '/isomorphic/IDACall'");
        return new ServletRegistrationBean((Servlet)new IDACall(), new String[]{"/isomorphic/IDACall/*"});
    }

    @Bean
    @ConditionalOnMissingBean(name={"CustomRESTHandlerServlet"})
    @ConditionalOnProperty(name={"smartclient.resthandler-servlet.enabled"}, havingValue="true", matchIfMissing=true)
    @DependsOn(value={"SmartClientSpringBootServletContextInitializer"})
    public ServletRegistrationBean<RESTHandler> RESTHandlerServlet() {
        this.log("Mapping an instance of RESTHandler to '/isomorphic/RESTHandler'");
        return new ServletRegistrationBean((Servlet)new RESTHandler(), new String[]{"/isomorphic/RESTHandler/*"});
    }

    @Bean
    @ConditionalOnMissingBean(name={"CustomDataSourceLoaderServlet"})
    @ConditionalOnProperty(name={"smartclient.datasourceloader-servlet.enabled"}, havingValue="true", matchIfMissing=true)
    @DependsOn(value={"SmartClientSpringBootServletContextInitializer"})
    public ServletRegistrationBean<DataSourceLoader> DataSourceLoaderServlet() {
        this.log("Mapping an instance of DataSourceLoader to '/isomorphic/DataSourceLoader'");
        System.out.println("Mapping an instance of DataSourceLoader to '/isomorphic/DataSourceLoader'");
        return new ServletRegistrationBean((Servlet)new DataSourceLoader(), new String[]{"/isomorphic/DataSourceLoader"});
    }

    @Bean
    @ConditionalOnMissingBean(name={"CustomProjectLoaderServlet"})
    @ConditionalOnProperty(name={"smartclient.projectloader-servlet.enabled"}, havingValue="true", matchIfMissing=true)
    @DependsOn(value={"SmartClientSpringBootServletContextInitializer"})
    public ServletRegistrationBean<ProjectLoaderServlet> ProjectLoaderServlet() {
        this.log("Mapping an instance of ProjectLoader to '/isomorphic/ProjectLoader'");
        return new ServletRegistrationBean((Servlet)new ProjectLoaderServlet(), new String[]{"/isomorphic/projectLoader"});
    }

    @Bean
    @ConditionalOnMissingBean(name={"CustomScreenLoaderServlet"})
    @ConditionalOnProperty(name={"smartclient.screenloader-servlet.enabled"}, havingValue="true", matchIfMissing=true)
    @DependsOn(value={"SmartClientSpringBootServletContextInitializer"})
    public ServletRegistrationBean<ScreenLoaderServlet> ScreenLoaderServlet() {
        this.log("Mapping an instance of ScreenLoader to '/isomorphic/ScreenLoader'");
        return new ServletRegistrationBean((Servlet)new ScreenLoaderServlet(), new String[]{"/isomorphic/screenLoader"});
    }

    @Bean
    @ConditionalOnMissingBean(name={"CustomHttpProxyServlet"})
    @ConditionalOnProperty(name={"smartclient.httpproxy-servlet.enabled"}, havingValue="true", matchIfMissing=true)
    @DependsOn(value={"SmartClientSpringBootServletContextInitializer"})
    public ServletRegistrationBean<HttpProxyServlet> HttpProxyServlet() {
        this.log("Mapping an instance of HttpProxyServlet to '/isomorphic/HttpProxy'");
        return new ServletRegistrationBean((Servlet)new HttpProxyServlet(), new String[]{"/isomorphic/HttpProxy/*"});
    }

    @Bean
    @ConditionalOnMissingBean(name={"CustomFileDownloadServlet"})
    @ConditionalOnProperty(name={"smartclient.filedownload-servlet.enabled"}, havingValue="true", matchIfMissing=true)
    @DependsOn(value={"SmartClientSpringBootServletContextInitializer"})
    public ServletRegistrationBean<FileDownload> FileDownloadServlet() {
        this.log("Mapping an instance of FileDownload to '/isomorphic/skins', etc");
        ServletRegistrationBean registration = new ServletRegistrationBean();
        registration.setServlet((Servlet)new FileDownload());
        registration.setUrlMappings(Arrays.asList("/isomorphic/skins/*", "/isomorphic/locales/*", "/isomorphic/system/helpers/fonts/*", "/isomorphic/system/reference/skin/*", "/isomorphic/system/reference/exampleImages/*", "/isomorphic/system/reference/inlineExamples/*", "/docs/images/*"));
        return registration;
    }

    private void log(String message) {
        if (this.log == null) {
            this.log = new Logger(this.getClass().getName());
        }
        this.log.info((Object)message);
    }

    @Bean
    @ConditionalOnProperty(name={"smartclient.featureexplorerrpc-servlet.enabled"}, havingValue="true", matchIfMissing=false)
    @DependsOn(value={"SmartClientSpringBootServletContextInitializer"})
    public ServletRegistrationBean<FeatureExplorerRPC> FeatureExplorerRPCServlet() {
        this.log("Mapping an instance of FeatureExplorerRPC to '/isomorphic/FeatureExplorerRPC/*'");
        System.out.println("Mapping an instance of FeatureExplorerRPC to '/isomorphic/FeatureExplorerRPC/*'");
        return new ServletRegistrationBean((Servlet)new FeatureExplorerRPC(), new String[]{"/isomorphic/FeatureExplorerRPC/*"});
    }
}

