# DataBound Component Methods

[← Back to API Index](../reference.md)

---

## KB Topic: DataBound Component Methods

### Description
An Action Method initiates an orchestrated client-server flow that stores or retrieves data and updates one or more components.

For example, the [editor.saveData()](../classes/DynamicForm.md#method-dynamicformsavedata) Action Method saves the record currently being edited in the form, transparently handling the trip to the server, standard error conditions such as validation errors (whether the validation error happens on the client or server), and update of client-side caches.

Action Methods are available on DataBoundComponents.

### Related

- [Calendar.fetchData](../classes/Calendar.md#method-calendarfetchdata)
- [Calendar.filterData](../classes/Calendar.md#method-calendarfilterdata)
- [ListGrid.fetchData](../classes/ListGrid_2.md#method-listgridfetchdata)
- [ListGrid.exportData](../classes/ListGrid_2.md#method-listgridexportdata)
- [ListGrid.filterData](../classes/ListGrid_2.md#method-listgridfilterdata)
- [ListGrid.fetchRelatedData](../classes/ListGrid_2.md#method-listgridfetchrelateddata)
- [ListGrid.clearCriteria](../classes/ListGrid_2.md#method-listgridclearcriteria)
- [ListGrid.getCriteria](../classes/ListGrid_2.md#method-listgridgetcriteria)
- [ListGrid.setCriteria](../classes/ListGrid_2.md#method-listgridsetcriteria)
- [ListGrid.invalidateCache](../classes/ListGrid_2.md#method-listgridinvalidatecache)
- [ListGrid.refreshData](../classes/ListGrid_2.md#method-listgridrefreshdata)
- [ListGrid.willFetchData](../classes/ListGrid_2.md#method-listgridwillfetchdata)
- [ListGrid.addData](../classes/ListGrid_2.md#method-listgridadddata)
- [ListGrid.updateData](../classes/ListGrid_2.md#method-listgridupdatedata)
- [ListGrid.removeSelectedData](../classes/ListGrid_2.md#method-listgridremoveselecteddata)
- [TreeGrid.fetchData](../classes/TreeGrid.md#method-treegridfetchdata)
- [TreeGrid.filterData](../classes/TreeGrid.md#method-treegridfilterdata)
- [TileGrid.exportData](../classes/TileGrid.md#method-tilegridexportdata)
- [DetailViewer.exportData](../classes/DetailViewer.md#method-detailviewerexportdata)
- [FacetChart.fetchData](../classes/FacetChart.md#method-facetchartfetchdata)
- [FacetChart.fetchRelatedData](../classes/FacetChart.md#method-facetchartfetchrelateddata)
- [FacetChart.invalidateCache](../classes/FacetChart.md#method-facetchartinvalidatecache)
- [DataBoundComponent.exportData](../classes/DataBoundComponent.md#method-databoundcomponentexportdata)
- [DataBoundComponent.willFetchData](../classes/DataBoundComponent.md#method-databoundcomponentwillfetchdata)
- [DynamicForm.editNewRecord](../classes/DynamicForm.md#method-dynamicformeditnewrecord)
- [DynamicForm.editRecord](../classes/DynamicForm.md#method-dynamicformeditrecord)
- [DynamicForm.editSelectedData](../classes/DynamicForm.md#method-dynamicformeditselecteddata)
- [DynamicForm.submit](../classes/DynamicForm.md#method-dynamicformsubmit)
- [DynamicForm.saveData](../classes/DynamicForm.md#method-dynamicformsavedata)
- [DynamicForm.fetchData](../classes/DynamicForm.md#method-dynamicformfetchdata)
- [DynamicForm.filterData](../classes/DynamicForm.md#method-dynamicformfilterdata)
- [ValuesManager.editNewRecord](../classes/ValuesManager.md#method-valuesmanagereditnewrecord)
- [ValuesManager.editRecord](../classes/ValuesManager.md#method-valuesmanagereditrecord)
- [ValuesManager.editSelectedData](../classes/ValuesManager.md#method-valuesmanagereditselecteddata)
- [ValuesManager.saveData](../classes/ValuesManager.md#method-valuesmanagersavedata)
- [ValuesManager.submit](../classes/ValuesManager.md#method-valuesmanagersubmit)
- [ValuesManager.filterData](../classes/ValuesManager.md#method-valuesmanagerfilterdata)
- [ValuesManager.fetchData](../classes/ValuesManager.md#method-valuesmanagerfetchdata)
- [DetailViewer.viewSelectedData](../classes/DetailViewer.md#method-detailviewerviewselecteddata)
- [HTMLFlow.fetchRelatedData](../classes/HTMLFlow.md#method-htmlflowfetchrelateddata)
- [DynamicForm.viewSelectedData](../classes/DynamicForm.md#method-dynamicformviewselecteddata)
- [DynamicForm.fetchRelatedData](../classes/DynamicForm.md#method-dynamicformfetchrelateddata)
- [DetailViewer.fetchRelatedData](../classes/DetailViewer.md#method-detailviewerfetchrelateddata)
- [ListGrid.removeData](../classes/ListGrid_2.md#method-listgridremovedata)
- [TileGrid.fetchData](../classes/TileGrid.md#method-tilegridfetchdata)
- [TileGrid.filterData](../classes/TileGrid.md#method-tilegridfilterdata)
- [TileGrid.invalidateCache](../classes/TileGrid.md#method-tilegridinvalidatecache)
- [TileGrid.removeSelectedData](../classes/TileGrid.md#method-tilegridremoveselecteddata)
- [TileGrid.viewSelectedData](../classes/TileGrid.md#method-tilegridviewselecteddata)
- [TileGrid.loadAllRecords](../classes/TileGrid.md#method-tilegridloadallrecords)
- [TileGrid.addData](../classes/TileGrid.md#method-tilegridadddata)
- [TileGrid.removeData](../classes/TileGrid.md#method-tilegridremovedata)
- [ColumnTree.fetchData](../classes/ColumnTree.md#method-columntreefetchdata)
- [ColumnTree.filterData](../classes/ColumnTree.md#method-columntreefilterdata)
- [DataBoundComponent.autoFetchData](../classes/DataBoundComponent.md#attr-databoundcomponentautofetchdata)

### See Also

- [DataBoundComponent](../reference.md#interface-databoundcomponent)

---
