# SavedSearchForm Documentation

[← Back to API Index](../reference.md)

---

## Class: SavedSearchForm

*Inherits from:* [DynamicForm](DynamicForm.md#class-dynamicform)

### Description
Simple [DynamicForm](DynamicForm.md#class-dynamicform) wrapper for a [SavedSearchItem](SavedSearchItem.md#class-savedsearchitem).

This provides a standalone UI for creating, editing and applying saved searches for a [target](SavedSearchItem.md#attr-savedsearchitemtargetcomponent) using the [SavedSearches](SavedSearches.md#class-savedsearches) system.

Note that a [SavedSearchItem](SavedSearchItem.md#class-savedsearchitem) may also be used directly by embedding it into any DynamicForm.

---
## Attr: SavedSearchForm.savedSearchItem

### Description
Automatically generated [SavedSearchItem](SavedSearchItem.md#class-savedsearchitem) for this form.

This may be customized using the [autoChild subsystem](../kb_topics/autoChildUsage.md#kb-topic-using-autochildren).

**Flags**: IR

---
## Attr: SavedSearchForm.hint

### Description
If set this property will override [SavedSearchItem.hint](SavedSearchItem.md#attr-savedsearchitemhint) on the automatically generated [SavedSearchItem](SavedSearchItem.md#class-savedsearchitem).

### Groups

- i18nMessages

**Flags**: IR

---
## Attr: SavedSearchForm.markAsDefaultHoverText

### Description
If set this property will override [SavedSearchItem.markAsDefaultHoverText](SavedSearchItem.md#attr-savedsearchitemmarkasdefaulthovertext) on the automatically generated [SavedSearchItem](SavedSearchItem.md#class-savedsearchitem).

### Groups

- i18nMessages

**Flags**: IR

---
## Attr: SavedSearchForm.overflow

### Description
SavedSearchForms are sized to fit their single item by default

**Flags**: IRW

---
## Attr: SavedSearchForm.newRecordValues

### Description
If set this property will override [SavedSearchItem.adminRole](SavedSearchItem.md#attr-savedsearchitemadminrole) on the automatically generated [SavedSearchItem](SavedSearchItem.md#class-savedsearchitem).

**Flags**: IR

---
## Attr: SavedSearchForm.addSearchIcon

### Description
If set this property will override [SavedSearchItem.addSearchIcon](SavedSearchItem.md#attr-savedsearchitemaddsearchicon) on the automatically generated [SavedSearchItem](SavedSearchItem.md#class-savedsearchitem).

**Flags**: IR

---
## Attr: SavedSearchForm.removeSearchHoverText

### Description
If set this property will override [SavedSearchItem.removeSearchHoverText](SavedSearchItem.md#attr-savedsearchitemremovesearchhovertext) on the automatically generated [SavedSearchItem](SavedSearchItem.md#class-savedsearchitem).

### Groups

- i18nMessages

**Flags**: IR

---
## Attr: SavedSearchForm.adminRole

### Description
If set this property will override [SavedSearchItem.adminRole](SavedSearchItem.md#attr-savedsearchitemadminrole) on the automatically generated [SavedSearchItem](SavedSearchItem.md#class-savedsearchitem).

**Flags**: IR

---
## Attr: SavedSearchForm.title

### Description
If set this property will override [SavedSearchItem.title](SavedSearchItem.md#attr-savedsearchitemtitle) on the automatically generated [SavedSearchItem](SavedSearchItem.md#class-savedsearchitem).

### Groups

- i18nMessages

**Flags**: IR

---
## Attr: SavedSearchForm.confirmRemovalMessage

### Description
If set this property will override [SavedSearchItem.confirmRemovalMessage](SavedSearchItem.md#attr-savedsearchitemconfirmremovalmessage) on the automatically generated [SavedSearchItem](SavedSearchItem.md#class-savedsearchitem).

### Groups

- i18nMessages

**Flags**: IR

---
## Attr: SavedSearchForm.saveDefaultSearch

### Description
If set this property will override [SavedSearchItem.saveDefaultSearch](SavedSearchItem.md#attr-savedsearchitemsavedefaultsearch) on the automatically generated [SavedSearchItem](SavedSearchItem.md#class-savedsearchitem).

**Flags**: IR

---
## Attr: SavedSearchForm.copySearchHoverText

### Description
If set this property will override [SavedSearchItem.copySearchHoverText](SavedSearchItem.md#attr-savedsearchitemcopysearchhovertext) on the automatically generated [SavedSearchItem](SavedSearchItem.md#class-savedsearchitem).

### Groups

- i18nMessages

**Flags**: IR

---
## Attr: SavedSearchForm.canEditSearch

### Description
If set this property will override [SavedSearchItem.canEditSearch](SavedSearchItem.md#attr-savedsearchitemcaneditsearch) on the automatically generated [SavedSearchItem](SavedSearchItem.md#class-savedsearchitem).

**Flags**: IR

---
## Attr: SavedSearchForm.canAddSearch

### Description
If set this property will override [SavedSearchItem.canAddSearch](SavedSearchItem.md#attr-savedsearchitemcanaddsearch) on the automatically generated [SavedSearchItem](SavedSearchItem.md#class-savedsearchitem).

**Flags**: IR

---
## Attr: SavedSearchForm.canCopySearch

### Description
If set this property will override [SavedSearchItem.canCopySearch](SavedSearchItem.md#attr-savedsearchitemcancopysearch) on the automatically generated [SavedSearchItem](SavedSearchItem.md#class-savedsearchitem).

### Groups

- i18nMessages

**Flags**: IR

---
## Attr: SavedSearchForm.targetEditsCriteria

### Description
If set this property will override [SavedSearchItem.targetEditsCriteria](SavedSearchItem.md#attr-savedsearchitemtargeteditscriteria) on the automatically generated [SavedSearchItem](SavedSearchItem.md#class-savedsearchitem).

**Flags**: IR

---
## Attr: SavedSearchForm.canRemoveSearch

### Description
If set this property will override [SavedSearchItem.canRemoveSearch](SavedSearchItem.md#attr-savedsearchitemcanremovesearch) on the automatically generated [SavedSearchItem](SavedSearchItem.md#class-savedsearchitem).

**Flags**: IR

---
## Attr: SavedSearchForm.offlineStorageKey

### Description
If set this property will override [SavedSearchItem.offlineStorageKey](SavedSearchItem.md#attr-savedsearchitemofflinestoragekey) on the automatically generated [SavedSearchItem](SavedSearchItem.md#class-savedsearchitem).

**Flags**: IR

---
## Attr: SavedSearchForm.canModifyProperty

### Description
If set this property will override [SavedSearchItem.canModifyProperty](SavedSearchItem.md#attr-savedsearchitemcanmodifyproperty) on the automatically generated [SavedSearchItem](SavedSearchItem.md#class-savedsearchitem).

**Flags**: IR

---
## Attr: SavedSearchForm.numCols

### Description
SavedSearchForms show a single column by default

**Flags**: IRW

---
## Attr: SavedSearchForm.height

### Description
SavedSearchForms are sized to fit their single item by default

**Flags**: IRW

---
## Attr: SavedSearchForm.storedState

### Description
If set this property will override [SavedSearchItem.storedState](SavedSearchItem.md#attr-savedsearchitemstoredstate) on the automatically generated [SavedSearchItem](SavedSearchItem.md#class-savedsearchitem).

**Flags**: IR

---
## Attr: SavedSearchForm.editSearchHoverText

### Description
If set this property will override [SavedSearchItem.editSearchHoverText](SavedSearchItem.md#attr-savedsearchitemeditsearchhovertext) on the automatically generated [SavedSearchItem](SavedSearchItem.md#class-savedsearchitem).

### Groups

- i18nMessages

**Flags**: IR

---
## Attr: SavedSearchForm.targetDataSource

### Description
If set this property will override [SavedSearchItem.targetDataSource](SavedSearchItem.md#attr-savedsearchitemtargetdatasource) on the automatically generated [SavedSearchItem](SavedSearchItem.md#class-savedsearchitem).

**Flags**: IR

---
## Attr: SavedSearchForm.addSearchValue

### Description
If set this property will override [SavedSearchItem.addSearchValue](SavedSearchItem.md#attr-savedsearchitemaddsearchvalue) on the automatically generated [SavedSearchItem](SavedSearchItem.md#class-savedsearchitem).

**Flags**: IR

---
## Attr: SavedSearchForm.confirmRemoval

### Description
If set this property will override [SavedSearchItem.confirmRemoval](SavedSearchItem.md#attr-savedsearchitemconfirmremoval) on the automatically generated [SavedSearchItem](SavedSearchItem.md#class-savedsearchitem).

**Flags**: IR

---
## Attr: SavedSearchForm.saveLastSearch

### Description
If set this property will override [SavedSearchItem.saveLastSearch](SavedSearchItem.md#attr-savedsearchitemsavelastsearch) on the automatically generated [SavedSearchItem](SavedSearchItem.md#class-savedsearchitem).

**Flags**: IR

---
## Attr: SavedSearchForm.targetComponent

### Description
If set this property will override [SavedSearchItem.targetComponent](SavedSearchItem.md#attr-savedsearchitemtargetcomponent) on the automatically generated [SavedSearchItem](SavedSearchItem.md#class-savedsearchitem).

**Flags**: IR

---
## Method: SavedSearchForm.searchChanged

### Description
Event fired whenever a user changes the currently selected saved search, modifies a saved search or adds a new saved search.

If a [SavedSearchForm.targetComponent](#attr-savedsearchformtargetcomponent) has been specified, `searchChanged` automatically applies the new search to the `targetComponent` unless the event is cancelled by returning false.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| newCriteria | [Criteria](../reference_2.md#type-criteria) | false | — | new criteria |
| searchData | [String](#type-string) | false | — | search data |

### Returns

`[boolean](../reference.md#type-boolean)` — whether to automatically apply the search to the [SavedSearchForm.targetComponent](#attr-savedsearchformtargetcomponent)

---
## Method: SavedSearchForm.setTargetComponent

### Description
Changes the [SavedSearchForm.targetComponent](#attr-savedsearchformtargetcomponent) to the passed in newTargetComponent.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| newTargetComponent | [DataBoundComponent](#type-databoundcomponent) | false | — | the newTargetComponent |

---
