# Operators Documentation

[← Back to API Index](../reference.md)

---

## Class: Operators

### Description
The Operators class provides a collection of class-level properties that can be used to modify the descriptions associated with the logical [Operator](../reference.md#object-operator)s used in [AdvancedCriteria](../reference.md#object-advancedcriteria). This is primarily intended for internationalization.

To add or override an operator's description, use Operators.[addClassProperties()](Class.md#classmethod-classaddclassproperties). For example:

`Operators.addClassProperties({lessOrEqualTitle: "Less than or equal to"});`

---
## ClassAttr: Operators.isNullTitle

### Description
Title for the "isNull" operator

### Groups

- i18nMessages

**Flags**: IR

---
## ClassAttr: Operators.regexpTitle

### Description
Title for the "regexp" operator

### Groups

- i18nMessages

**Flags**: IR

---
## ClassAttr: Operators.iEqualsTitle

### Description
Title for the "iEquals" operator

### Groups

- i18nMessages

**Flags**: IR

---
## ClassAttr: Operators.notStartsWithTitle

### Description
Title for the "notStartsWith" operator

### Groups

- i18nMessages

**Flags**: IR

---
## ClassAttr: Operators.iNotEqualFieldTitle

### Description
Title for the "iNotEqualField" operator

### Groups

- i18nMessages

**Flags**: IR

---
## ClassAttr: Operators.lessThanFieldTitle

### Description
Title for the "lessThanField" operator

### Groups

- i18nMessages

**Flags**: IR

---
## ClassAttr: Operators.endsWithFieldTitle

### Description
Title for the "endsWithField" operator

### Groups

- i18nMessages

**Flags**: IR

---
## ClassAttr: Operators.betweenInclusiveTitle

### Description
Title for the "betweenInclusive" operator

### Groups

- i18nMessages

**Flags**: IR

---
## ClassAttr: Operators.notTitle

### Description
Title for the "not" operator

### Groups

- i18nMessages

**Flags**: IR

---
## ClassAttr: Operators.iStartsWithTitle

### Description
Title for the "iStartsWith" operator

### Groups

- i18nMessages

**Flags**: IR

---
## ClassAttr: Operators.valueRangeUsageHint

### Description
The default usage description for operators with [valueType](../reference_2.md#type-operatorvaluetype) "valueRange". A usage hint can also be set directly on a [specific operator](Operator.md#attr-operatorusagehint).

### Groups

- i18nMessages

**Flags**: IR

---
## ClassAttr: Operators.matchesPatternTitle

### Description
Title for the "matchesPattern" operator

### Groups

- i18nMessages

**Flags**: IR

---
## ClassAttr: Operators.iEndsWithFieldTitle

### Description
Title for the "iEndsWithField" operator

### Groups

- i18nMessages

**Flags**: IR

---
## ClassAttr: Operators.iNotContainsTitle

### Description
Title for the "iNotContains" operator

### Groups

- i18nMessages

**Flags**: IR

---
## ClassAttr: Operators.containsTitle

### Description
Title for the "contains" operator

### Groups

- i18nMessages

**Flags**: IR

---
## ClassAttr: Operators.equalsTitle

### Description
Title for the "equals" operator

### Groups

- i18nMessages

**Flags**: IR

---
## ClassAttr: Operators.iNotEndsWithFieldTitle

### Description
Title for the "iNotEndsWithField" operator

### Groups

- i18nMessages

**Flags**: IR

---
## ClassAttr: Operators.iNotStartsWithFieldTitle

### Description
Title for the "iNotStartsWithField" operator

### Groups

- i18nMessages

**Flags**: IR

---
## ClassAttr: Operators.notStartsWithFieldTitle

### Description
Title for the "notStartsWithField" operator

### Groups

- i18nMessages

**Flags**: IR

---
## ClassAttr: Operators.fieldTypeUsageHint

### Description
The default usage description for operators with [valueType](../reference_2.md#type-operatorvaluetype) "fieldType". A usage hint can also be set directly on a [specific operator](Operator.md#attr-operatorusagehint).

### Groups

- i18nMessages

**Flags**: IR

---
## ClassAttr: Operators.iNotEqualTitle

### Description
Title for the "iNotEqual" operator

### Groups

- i18nMessages

**Flags**: IR

---
## ClassAttr: Operators.startsWithFieldTitle

### Description
Title for the "startsWithField" operator

### Groups

- i18nMessages

**Flags**: IR

---
## ClassAttr: Operators.notEndsWithFieldTitle

### Description
Title for the "notEndsWithField" operator

### Groups

- i18nMessages

**Flags**: IR

---
## ClassAttr: Operators.iEndsWithTitle

### Description
Title for the "iEndsWith" operator

### Groups

- i18nMessages

**Flags**: IR

---
## ClassAttr: Operators.endsWithTitle

### Description
Title for the "endsWith" operator

### Groups

- i18nMessages

**Flags**: IR

---
## ClassAttr: Operators.iNotStartsWithTitle

### Description
Title for the "iNotStartsWith" operator

### Groups

- i18nMessages

**Flags**: IR

---
## ClassAttr: Operators.notBlankTitle

### Description
Title for the "notBlank" operator

### Groups

- i18nMessages

**Flags**: IR

---
## ClassAttr: Operators.orTitle

### Description
Title for the "or" operator

### Groups

- i18nMessages

**Flags**: IR

---
## ClassAttr: Operators.betweenTitle

### Description
Title for the "between" operator

### Groups

- i18nMessages

**Flags**: IR

---
## ClassAttr: Operators.iNotContainsFieldTitle

### Description
Title for the "iNotContainsField" operator

### Groups

- i18nMessages

**Flags**: IR

---
## ClassAttr: Operators.iContainsPatternTitle

### Description
Title for the "iContainsPattern" operator

### Groups

- i18nMessages

**Flags**: IR

---
## ClassAttr: Operators.greaterOrEqualFieldTitle

### Description
Title for the "greaterOrEqualField" operator

### Groups

- i18nMessages

**Flags**: IR

---
## ClassAttr: Operators.notContainsTitle

### Description
Title for the "notContains" operator

### Groups

- i18nMessages

**Flags**: IR

---
## ClassAttr: Operators.andTitle

### Description
Title for the "and" operator

### Groups

- i18nMessages

**Flags**: IR

---
## ClassAttr: Operators.lessOrEqualFieldTitle

### Description
Title for the "lessOrEqualField" operator

### Groups

- i18nMessages

**Flags**: IR

---
## ClassAttr: Operators.iContainsTitle

### Description
Title for the "iContains" operator

### Groups

- i18nMessages

**Flags**: IR

---
## ClassAttr: Operators.startsWithTitle

### Description
Title for the "startsWith" operator

### Groups

- i18nMessages

**Flags**: IR

---
## ClassAttr: Operators.notNullTitle

### Description
Title for the "notNull" operator

### Groups

- i18nMessages

**Flags**: IR

---
## ClassAttr: Operators.notInSetTitle

### Description
Title for the "notInSet" operator

### Groups

- i18nMessages

**Flags**: IR

---
## ClassAttr: Operators.iStartsWithFieldTitle

### Description
Title for the "iStartsWithField" operator

### Groups

- i18nMessages

**Flags**: IR

---
## ClassAttr: Operators.noDataSourceDescription

### Description
Human-readable description of an object, such as a [Criterion](../reference_2.md#object-criterion), where there is no [DataSource](DataSource.md#class-datasource) available for context.

### Groups

- i18nMessages

**Flags**: IR

---
## ClassAttr: Operators.fieldNameUsageHint

### Description
The default usage description for operators with [valueType](../reference_2.md#type-operatorvaluetype) "fieldName". A usage hint can also be set directly on a [specific operator](Operator.md#attr-operatorusagehint).

### Groups

- i18nMessages

**Flags**: IR

---
## ClassAttr: Operators.valueSetUsageHint

### Description
The default usage description for operators with [valueType](../reference_2.md#type-operatorvaluetype) "valueSet". A usage hint can also be set directly on a [specific operator](Operator.md#attr-operatorusagehint).

### Groups

- i18nMessages

**Flags**: IR

---
## ClassAttr: Operators.aiFilterDescriptionPrefix

### Description
—

### Groups

- i18nMessages

**Flags**: RW

---
## ClassAttr: Operators.iregexpTitle

### Description
Title for the "iregexp" operator

### Groups

- i18nMessages

**Flags**: IR

---
## ClassAttr: Operators.notEqualFieldTitle

### Description
Title for the "notEqualField" operator

### Groups

- i18nMessages

**Flags**: IR

---
## ClassAttr: Operators.containsPatternTitle

### Description
Title for the "containsPattern" operator

### Groups

- i18nMessages

**Flags**: IR

---
## ClassAttr: Operators.iContainsFieldTitle

### Description
Title for the "iContainsField" operator

### Groups

- i18nMessages

**Flags**: IR

---
## ClassAttr: Operators.greaterOrEqualTitle

### Description
Title for the "greaterOrEqual" operator

### Groups

- i18nMessages

**Flags**: IR

---
## ClassAttr: Operators.iMatchesPatternTitle

### Description
Title for the "iMatchesPattern" operator

### Groups

- i18nMessages

**Flags**: IR

---
## ClassAttr: Operators.aiFilterTitle

### Description
Title for the "aiFilter" operator

### Groups

- i18nMessages

**Flags**: RW

---
## ClassAttr: Operators.iBetweenInclusiveTitle

### Description
Title for the "iBetweenInclusive" operator

### Groups

- i18nMessages

**Flags**: IR

---
## ClassAttr: Operators.iNotEndsWithTitle

### Description
Title for the "iNotEndsWith" operator

### Groups

- i18nMessages

**Flags**: IR

---
## ClassAttr: Operators.lessOrEqualTitle

### Description
Title for the "lessOrEqual" operator

### Groups

- i18nMessages

**Flags**: IR

---
## ClassAttr: Operators.equalsFieldTitle

### Description
Title for the "equalsField" operator

### Groups

- i18nMessages

**Flags**: IR

---
## ClassAttr: Operators.greaterThanFieldTitle

### Description
Title for the "greaterThanField" operator

### Groups

- i18nMessages

**Flags**: IR

---
## ClassAttr: Operators.iStartsWithPatternTitle

### Description
Title for the "iStartsWithPattern" operator

### Groups

- i18nMessages

**Flags**: IR

---
## ClassAttr: Operators.notEqualTitle

### Description
Title for the "notEqual" operator

### Groups

- i18nMessages

**Flags**: IR

---
## ClassAttr: Operators.notEndsWithTitle

### Description
Title for the "notEndsWith" operator

### Groups

- i18nMessages

**Flags**: IR

---
## ClassAttr: Operators.notContainsFieldTitle

### Description
Title for the "notContainsField" operator

### Groups

- i18nMessages

**Flags**: IR

---
## ClassAttr: Operators.inSetTitle

### Description
Title for the "inSet" operator

### Groups

- i18nMessages

**Flags**: IR

---
## ClassAttr: Operators.lessThanTitle

### Description
Title for the "lessThan" operator

### Groups

- i18nMessages

**Flags**: IR

---
## ClassAttr: Operators.isBlankTitle

### Description
Title for the "isBlank" operator

### Groups

- i18nMessages

**Flags**: IR

---
## ClassAttr: Operators.containsFieldTitle

### Description
Title for the "containsField" operator

### Groups

- i18nMessages

**Flags**: IR

---
## ClassAttr: Operators.endsWithPatternTitle

### Description
Title for the "endsWithPattern" operator

### Groups

- i18nMessages

**Flags**: IR

---
## ClassAttr: Operators.iEqualsFieldTitle

### Description
Title for the "iEqualsField" operator

### Groups

- i18nMessages

**Flags**: IR

---
## ClassAttr: Operators.iBetweenTitle

### Description
Title for the "iBetween" operator

### Groups

- i18nMessages

**Flags**: IR

---
## ClassAttr: Operators.iEndsWithPatternTitle

### Description
Title for the "iEndsWithPattern" operator

### Groups

- i18nMessages

**Flags**: IR

---
## ClassAttr: Operators.startsWithPatternTitle

### Description
Title for the "startsWithPattern" operator

### Groups

- i18nMessages

**Flags**: IR

---
## ClassAttr: Operators.greaterThanTitle

### Description
Title for the "greaterThan" operator

### Groups

- i18nMessages

**Flags**: IR

---
