# HeaderLevel Documentation

[← Back to API Index](../reference.md)

---

## Attr: HeaderLevel.headerWidth

### Description
If set, the width for each of the spans in this headerLevel. Note that this setting only has an effect on the innermost headerLevel.

**Flags**: IR

---
## Attr: HeaderLevel.unit

### Description
Unit of time shown at this level of header.

**Flags**: IR

---
## Attr: HeaderLevel.titles

### Description
Optional sparse array of titles for the spans on this headerLevel. If a given span in this headerLevel has a corresponding entry in this array, it will be used as the span's title.

If not specified, default titles are generated (eg "Q1" for unit "quarter") and then passed into the [formatter function](#method-headerleveltitleformatter), if one has been installed, for further customization.

**Flags**: IR

---
## Method: HeaderLevel.titleFormatter

### Description
An optional function for providing formatted HTML for the title of a given span in this HeaderLevel. If unset, Timelines use the [titles array](#attr-headerleveltitles), if one is set, or generate default titles based on the unit-type and date-range.

Note that this method will not run for spans in this headerLevel that have a non-null entry in the [titles](#attr-headerleveltitles) array.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| headerLevel | [HeaderLevel](#type-headerlevel) | false | — | a reference to this headerLevel |
| startDate | [Date](#type-date) | false | — | the start of the date-range covered by this span in this level |
| endDate | [Date](#type-date) | false | — | the end of the date-range covered by this span in this level - may be null |
| defaultValue | [String](#type-string) | false | — | the default title as generated by the Timeline |
| viewer | [Calendar](#type-calendar) | false | — | a reference to the Calendar or Timeline |

### Returns

`[HTMLString](../reference.md#type-htmlstring)` — The formatted title for the values passed in

---
