# DMI Documentation

[← Back to API Index](../reference.md)

---

## Class: DMI

### Description
Static singleton class with APIs for [Direct Method Invocation](../kb_topics/dmiOverview.md#kb-topic-direct-method-invocation) of server side methods when running the SmartClient java server.

---
## ClassMethod: DMI.call

### Description
Calls a server-side DMI method. At a minimum, you need to specify the appID ([.app.xml file](../kb_topics/applicationDeclaration.md#kb-topic-application-declaration-files)), [ServerObject.className](ServerObject.md#attr-serverobjectclassname) or [ServerObject.ID](ServerObject.md#attr-serverobjectid) and methodName to call. Arguments and callback are optional. There are two ways to invoke this method:
```
 DMI.call(appID, className, methodName, 
          arg1, arg2 ...argN, callback);
 
```
or:
```
 DMI.call({
     appID: appID,
     className: className,
     methodName: methodName,
     arguments: [arg1, arg2, ...argN], //optional
     callback: callback, //optional
     requestParams: requestProps // optional
 });
 
```
If you use the first signature, you must either specify a callback or if you don't want a callback, pass a `null` as the last argument. The second signature allows you to specify requestParams that are applied to the [RPCRequest](../reference.md#object-rpcrequest) generated by this DMI call. This allows you to override some defaults - for example to suppress the "Contacting Server" prompt, change it's text; change the timeout or set any other property settable on [RPCRequest](../reference.md#object-rpcrequest).

Arguments to be passed to the server method may be specified. If present, each argument will be serialized into JSON, sent to the server and translated to an equivalent Java object to be passed into the method. The translation follows the same rules as for data passed to the server as part of a standard [RPCRequest](RPCRequest.md#attr-rpcrequestdata).  
For example if a server side method has the signature

```
 someMethod(String title, Map overrides);
 
```
a DMI call to that method would could pass in a standard String and JavaScript object - for example:
```
 isc.DMI.call({
     appID: "someApp",
     className: "com.smartclient.demo.MyClass",
     methodName: "someMethod",
     arguments: ["Title String", {field1:"Value 1", field2:"Value 2"}]
 });
 
```

Note that you can use the [loadDMIStubsTag](../kb_topics/loadDMIStubsTag.md#kb-topic-isomorphicloaddmistubs) tag to bind all methods of `ServerObjects` defined in a given .app.xml file and call methods on them directly.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| appID | [String](#type-string)|[Object](../reference.md#type-object) | false | — | the appID (.app.xml file to look in) or comprehensive request object as documented above. |
| className | [String](#type-string) | false | — | [ServerObject.className](ServerObject.md#attr-serverobjectclassname) or [ServerObject.ID](ServerObject.md#attr-serverobjectid) |
| methodName | [String](#type-string) | false | — | the name of the method to call on the serverObject |
| args | [Any](#type-any) | false | — | The next N-1 params specify arguments to the server-side method. |
| callback | [RPCCallback](#type-rpccallback) | false | — | The callback of the response. If you do not want a callback, you must specify a `null` value for this parameter when using the first signature (documented above). |

### Returns

`[RPCRequest](#type-rpcrequest)` — the RPCRequest that was sent to the server.

---
## ClassMethod: DMI.getURL

### Description
Returns a URL to a server-side DMI method. At a minimum, you need to specify the appID ([.app.xml file](../kb_topics/applicationDeclaration.md#kb-topic-application-declaration-files)), [ServerObject.className](ServerObject.md#attr-serverobjectclassname) or [ServerObject.ID](ServerObject.md#attr-serverobjectid) and methodName to call. Arguments are optional. There are two ways to invoke this method:
```
 DMI.getURL(appID, className, methodName, 
          arg1, arg2 ...argN);
 
```
or:
```
 DMI.getURL({
     appID: appID,
     className: className,
     methodName: methodName,
     arguments: [arg1, arg2, ...argN], //optional
     requestParams: requestProps // optional
 });
 
```
The second signature allows you to specify requestParams that are applied to the [RPCRequest](../reference.md#object-rpcrequest) generated by this DMI call.

Note that because the entirety of the request is encoded in the URL, there is an inherent limitation on the amount of data that you can send viat he criteria argument to the server. The actual length depends on your server configuration and other factors such as the size of cookies (if any) being sent to the server and other HTTP headers in use. Conservatively, assume that you have about 2 kilobytes to work with.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| appID | [String](#type-string)|[Object](../reference.md#type-object) | false | — | the appID (.app.xml file to look in) or comprehensive request object as documented above. |
| className | [String](#type-string) | false | — | [ServerObject.className](ServerObject.md#attr-serverobjectclassname) or [ServerObject.ID](ServerObject.md#attr-serverobjectid) |
| methodName | [String](#type-string) | false | — | the name of the method to call on the serverObject |
| args | [Any](#type-any) | true | — | The next N-1 params specify arguments to the server-side method. |

### Returns

`[String](#type-string)` — a URL that targets the specified DMI

---
