
var grid = isc.ListGrid.create({
    width: "100%", height: "100%",
    dataSource: "worldDS", dataFetchMode: "local", autoFetchData: true,
    sortField: "countryName",
    implicitCriteria: {
        _constructor: "AdvancedCriteria",
        fieldName: "continent",
        operator: "inSet",
        value: ["North America", "Australia/Oceania"]
    },

    filterViaAIMode: "AIDE"
});

var exampleFilterDescriptions = [
    "in the Northern Hemisphere",
    "Spanish is one of the official languages",
    "in the Caribbean"
];

isc.VLayout.create({
    width: "100%", height: "100%",
    membersMargin: 15,
    members: [
        isc.DynamicForm.create({
            ID: "form",
            width: 600,
            items: [
                {
                    name: "dsSelector",
                    editorType: "SelectItem",
                    required: true,
                    title: "DataSource",
                    valueMap: ["ScienceStudies","worldDS"],
                    defaultValue: "ScienceStudies",
                    changed : function (form, item, value) {
                        if (value == "ScienceStudies") {
                            scienceStudiesLayout.show();
                            worldLayout.hide();

                        } else {
                            scienceStudiesLayout.hide();
                            worldLayout.show();
                        }
                    }
                }
           ]
        }),
        isc.VLayout.create({
            ID: "scienceStudiesLayout",
            width: "100%",
            height: "100%",
            membersMargin: 10,
            members: [
                isc.HLayout.create({
                    width: "*",
                    members: [
                        isc.IButton.create({
                            title: "IV Pump Safety",
                            width: 200,
                            prompt: "Show some studies focused on infusion device safety—alarm performance, interface usability, error reduction, and patient risk mitigation",
                            click : function () {
                                var prompt = "Select only those abstracts that specifically relate to IV Pump Safety."
                                lgScienceStudies.filterViaAI(prompt);
                            }
                        }),
                        isc.IButton.create({
                            title: "Gene Therapy Delivery",
                            width: 200,
                            prompt: "Show some studies demonstrating significant clinical outcomes—patient recovery, practice guideline updates, or treatment advances in infusion therapy",
                            click : function () {
                                var prompt = "Select only those abstracts that specifically relate to Gene Therapy delivery.";
                                lgScienceStudies.filterViaAI(prompt);
                            }
                        }),
                        isc.IButton.create({
                          title:"Custom Prompt",
                          click: function () {
                              lgScienceStudies.showAIFilterWindow();
                          }
                        }),
                    ],
                    membersMargin: 10
                }),
                isc.ListGrid.create({
                    ID: "lgScienceStudies",
                    width: "100%", height: "100%",
                    dataSource: "ScienceStudies", 
                    autoFetchData: true,
                    filterViaAIMode: "AIDE",
                    sortField: "Title",
                    fields: [
                        {name:"Study_ID", width:150},
                        {name:"Title", width:150, showHover:true, hoverWidth:300},
                        {name:"Authors", width:150},
                        {name:"Journal", width:150},
                        {name:"Year", width:150},
                        {name:"Abstract", width:"*", showHover:true, hoverWidth:500}
                    ]
                })
            ]
        }),
        isc.VLayout.create({
            ID: "worldLayout",
            width: "100%",
            height: "100%",
            visibility: "hidden",
            members: [
                isc.HLayout.create({
                    width: "100%",
                    height: "*",
                    members: [isc.Label.create({height: "30", contents: "Examples: ", autoFit: true})].concat(exampleFilterDescriptions.map(function (exampleFilterDescription) {
                        return isc.IButton.create({
                            title: "\"" + exampleFilterDescription + "\"",
                            prompt: exampleFilterDescription,
                            autoFit: true,
                            click : function () {
                                grid.filterViaAI(exampleFilterDescription);
                            }
                        });
                    })).concat(
                      isc.IButton.create({
                        title:"Custom Prompt",
                        click: function () {
                            grid.showAIFilterWindow();
                        }
                      })
                    ),
                    membersMargin: 6
                }),
                grid
            ],
            membersMargin: 12
        })
    ]
});

