/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.criteria.AdvancedCriteria;
import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.datasource.ProvidesAdditionalFields;
import com.isomorphic.log.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UnionDataSource
extends BasicDataSource
implements ProvidesAdditionalFields {
    protected static Logger log = new Logger(UnionDataSource.class.getName());
    protected List<BasicDataSource> unionOf = new ArrayList<BasicDataSource>();
    protected Map<String, Map> unionFieldsConfig;
    protected List<DSField> unionFields;
    protected Map<String, Map<String, String>> renamedFields = new HashMap<String, Map<String, String>>();
    protected List<String> operationUnionFields = null;
    protected UnionDataSource sqlUnionDS;
    protected boolean allSql = false;

    public List<BasicDataSource> getUnionOf() {
        return this.unionOf;
    }

    @Override
    public DSResponse executeFetch(DSRequest req) throws Exception {
        req.setAttribute("unionDataSource", this);
        ArrayList subLists = new ArrayList();
        int totalRecords = 0;
        int sqlCount = 0;
        for (int i = 0; i < this.unionOf.size(); ++i) {
            if (!this.isSQLDataSource(this.unionOf.get(i))) continue;
            ++sqlCount;
        }
        boolean usedSQLUnionDS = false;
        if (sqlCount > 1) {
            HashMap<String, Object> sqlDsConfig = new HashMap<String, Object>((Map<String, Object>)((Object)this.getConfig()));
            sqlDsConfig.put("ID", this.getID() + "_sqlHandler");
            sqlDsConfig.put("_forceSQLUnionDataSource", true);
            sqlDsConfig.put("_unionDataSourceAllSql", false);
            this.sqlUnionDS = (UnionDataSource)DataSource.fromConfig(sqlDsConfig, new DSRequest());
            DSRequest workReq = this.createMemberDSRequest(this.sqlUnionDS, req);
            workReq.cacheDataSourceInstance(this.sqlUnionDS.getName(), this.sqlUnionDS);
            subLists.add(new HashSet(workReq.execute().getRecords()));
            usedSQLUnionDS = true;
        }
        for (int i = 0; i < this.unionOf.size(); ++i) {
            BasicDataSource memberDs = this.unionOf.get(i);
            if (this.sqlUnionDS != null && this.isSQLDataSource(memberDs)) continue;
            if (memberDs instanceof UnionDataSource) {
                HashSet recSet;
                DSRequest subReq = new DSRequest(memberDs, "fetch");
                subReq.setCriteria(req.getCriteria());
                subReq.setTextMatchStyle(req.getTextMatchStyle());
                subReq.setAttribute("unionMode", true);
                subReq.setAttribute("unionDataSource", this);
                subReq.setAttribute("unionParentRequest", req);
                subReq.setOutputs(this.getUnionFieldNames(req));
                UnionDataSource unionDs = (UnionDataSource)memberDs;
                DSResponse subResp = unionDs.processUnionDataSource(unionDs, subReq);
                List recList = subResp.getRecords();
                totalRecords = (int)((long)totalRecords + subResp.getTotalRows());
                HashSet hashSet = recSet = recList == null ? new HashSet() : new HashSet(recList);
                if (recSet.size() != recList.size()) {
                    totalRecords += recSet.size() - recList.size();
                }
                subLists.add(recSet);
                continue;
            }
            DSRequest workReq = this.createMemberDSRequest(memberDs, req);
            DSResponse subResp = workReq.execute();
            List subList = subResp.getRecords();
            if (!this.isSQLDataSource(memberDs)) {
                this.transformRecords(subList, (DataSource)memberDs, workReq);
            }
            totalRecords = (int)((long)totalRecords + subResp.getTotalRows());
            HashSet recSet = new HashSet(subList);
            if (recSet.size() != subList.size()) {
                totalRecords += recSet.size() - subList.size();
            }
            subLists.add(recSet);
        }
        HashSet completeSet = new HashSet();
        int listSize = 0;
        for (int i = 0; i < subLists.size(); ++i) {
            listSize += ((Set)subLists.get(i)).size();
            completeSet.addAll((Collection)subLists.get(i));
        }
        if (listSize != completeSet.size()) {
            totalRecords += completeSet.size() - totalRecords;
        }
        subLists = null;
        ArrayList completeList = new ArrayList(completeSet);
        completeSet = null;
        DSResponse resp = new DSResponse(completeList);
        resp.setTotalRows(totalRecords);
        resp.setStartRow(req.getStartRow());
        resp.setEndRow(req.getStartRow() + (long)completeList.size());
        req.applyManualSort(resp, true);
        if (Boolean.TRUE.equals(req.getRPCManager().getAttribute("notifySQLUnionDSFlag"))) {
            resp.setStatus(99);
        }
        return resp;
    }

    protected List<Map> normalizeSortBy(DSRequest req) {
        ArrayList<Map> normalized = new ArrayList<Map>();
        List inboundSortBy = req.getSortByFields();
        inboundSortBy = this.getSortByFields(inboundSortBy);
        for (String field : inboundSortBy) {
            boolean desc = false;
            if (field.startsWith("-")) {
                field = field.substring(1);
                desc = true;
            }
            HashMap<String, Object> sortSpec = new HashMap<String, Object>();
            sortSpec.put("fieldName", field);
            sortSpec.put("descending", desc);
            normalized.add(sortSpec);
        }
        return normalized;
    }

    @Override
    public void init(Map theConfig, DSRequest dsRequest) throws Exception {
        this.initUnionDataSource(theConfig, dsRequest);
        super.init(theConfig, dsRequest);
        this.unionFields = new ArrayList<DSField>(this.getFields());
    }

    private void initUnionDataSource(Map theConfig, DSRequest dsRequest) throws Exception {
        String[] unionDsNamesArr = ((String)theConfig.get("unionOf")).split(",");
        HashSet<String> unionDsNames = new HashSet<String>(Arrays.asList(unionDsNamesArr));
        for (String unionDsName : unionDsNames) {
            unionDsName = unionDsName.trim();
            DataSource workDs = null;
            if (dsRequest != null) {
                workDs = dsRequest.getCachedDataSourceInstance(unionDsName);
            }
            if (workDs == null) {
                workDs = DataSourceManager.get(unionDsName);
                if (dsRequest != null) {
                    dsRequest.cacheDataSourceInstance(unionDsName, workDs);
                }
            }
            if (workDs == null) {
                log.warn("ERROR: \"union\" dataSource \"" + String.valueOf(theConfig.get("ID")) + "\" specifies unknown dataSource \"" + unionDsName + "\" in its \"unionOf\" property.  Bailing...");
                return;
            }
            this.unionOf.add((BasicDataSource)workDs);
        }
        String unionFieldsStr = (String)theConfig.get("unionFields");
        this.unionFieldsConfig = new LinkedHashMap<String, Map>();
        this.applyUnionedFieldOverrides(theConfig);
        if (unionFieldsStr != null) {
            List fields = (List)theConfig.get("fields");
            String[] unionFieldsArr = unionFieldsStr.split(",");
            block1: for (int i = 0; i < unionFieldsArr.length; ++i) {
                Object workField;
                String unionFieldName = unionFieldsArr[i].trim();
                boolean skipDsLookup = false;
                for (int k = 0; k < fields.size(); ++k) {
                    workField = (Map)fields.get(k);
                    if (!unionFieldName.equals(workField.get("name"))) continue;
                    if (!this.unionFieldsConfig.containsKey(workField.get("name"))) {
                        this.addContributingDS((Map)workField, (String)theConfig.get("ID"));
                        this.unionFieldsConfig.put((String)workField.get("name"), (Map)workField);
                    }
                    skipDsLookup = true;
                    break;
                }
                if (skipDsLookup) continue;
                for (int j = 0; j < this.unionOf.size(); ++j) {
                    workField = this.unionOf.get(j).getField(unionFieldName);
                    if (workField == null) continue;
                    if (this.unionFieldsConfig.containsKey(((DSField)workField).get("name"))) continue block1;
                    this.addContributingDS((Map)workField, this.unionOf.get(j).getName());
                    this.unionFieldsConfig.put(((DSField)workField).getName(), (Map)workField);
                    continue block1;
                }
            }
        } else {
            this.buildUnionFieldsConfig(theConfig);
            this.applyDefaultUnionFieldsStrategy(theConfig);
        }
    }

    public void buildUnionFieldsConfig(Map theConfig) {
        int i;
        List<DSField> work = this.unionOf.get(0).getFields();
        Map<String, Map> fields = this.unionFieldsConfig;
        for (i = 0; i < work.size(); ++i) {
            Map field = (Map)((Object)work.get(i));
            Map renamed = this.getRenamedFieldConfig(this.unionOf.get(0), field);
            if (renamed != null) {
                this.addContributingDS(renamed, (String)theConfig.get("ID"));
                fields.put((String)renamed.get("name"), renamed);
                continue;
            }
            this.addContributingDS(field, this.unionOf.get(0).getName());
            fields.put((String)field.get("name"), field);
        }
        for (i = 1; i < this.unionOf.size(); ++i) {
            work = this.unionOf.get(i).getFields();
            for (int j = 0; j < work.size(); ++j) {
                Map baseField;
                Map otherField = (Map)((Object)work.get(j));
                Map renamed = this.getRenamedFieldConfig(this.unionOf.get(i), otherField);
                if (renamed != null) {
                    otherField = renamed;
                }
                if ((baseField = fields.get(otherField.get("name"))) == null) {
                    this.addContributingDS(otherField, this.unionOf.get(i).getName());
                    fields.put((String)otherField.get("name"), otherField);
                    continue;
                }
                if (!this.getSimpleBaseType((String)baseField.get("type")).equals(this.getSimpleBaseType((String)otherField.get("type")))) {
                    log.warn("Building unionFieldsConfig for DataSource '" + String.valueOf(theConfig.get("ID")) + "', field '" + String.valueOf(baseField.get("name")) + "' has type '" + String.valueOf(baseField.get("type")) + "' in sub-DS '" + String.valueOf(((List)baseField.get("_contributingDataSources")).get(0)) + "', but type '" + String.valueOf(otherField.get("type")) + "' in sub-DS '" + this.unionOf.get(i).getName() + "'. Removing field from the union");
                    fields.remove(baseField.get("name"));
                    continue;
                }
                this.addContributingDS(baseField, this.unionOf.get(i).getName());
            }
        }
    }

    public void addContributingDS(Map field, String dsName) {
        List work;
        if (dsName == null) {
            return;
        }
        if (!field.containsKey("_contributingDataSources")) {
            field.put("_contributingDataSources", new ArrayList());
        }
        if (!(work = (List)field.get("_contributingDataSources")).contains(dsName)) {
            work.add(dsName);
        }
    }

    public String getFirstContributingDS(Map field) {
        if (!field.containsKey("_contributingDataSources")) {
            return null;
        }
        return (String)((List)field.get("_contributingDataSources")).get(0);
    }

    public void applyDefaultUnionFieldsStrategy(Map theConfig) {
        String strategy = (String)theConfig.get("defaultUnionFieldsStrategy");
        if (strategy == null) {
            strategy = "matching";
        }
        if (strategy.equals("all")) {
            return;
        }
        Iterator<String> i = this.unionFieldsConfig.keySet().iterator();
        while (i.hasNext()) {
            Map fieldConfig = this.unionFieldsConfig.get(i.next());
            int dataSources = ((List)fieldConfig.get("_contributingDataSources")).size();
            if (dataSources == 1) {
                i.remove();
                continue;
            }
            if (dataSources >= this.unionOf.size() || !strategy.equals("intersect")) continue;
            i.remove();
        }
    }

    public void applyUnionedFieldOverrides(Map theConfig) {
        List<Map> fields = null;
        if (theConfig.get("fields") instanceof Map) {
            fields = new ArrayList();
            Map fieldDef = (Map)theConfig.get("fields");
            Iterator i = fieldDef.keySet().iterator();
            while (i.hasNext()) {
                fields.add((Map)fieldDef.get(i.next()));
            }
        } else {
            fields = (List)theConfig.get("fields");
        }
        if (fields == null) {
            return;
        }
        for (int i = 0; i < fields.size(); ++i) {
            Map field = (Map)fields.get(i);
            String fieldUnionOf = (String)field.get("unionOf");
            String unionedFieldType = null;
            boolean skip = false;
            if (fieldUnionOf == null) continue;
            String[] fqFieldNames = fieldUnionOf.split(",");
            if (fqFieldNames.length < 1) {
                log.warn("Union DataSource '" + this.getName() + "', field '" + String.valueOf(field.get("name")) + "' declares the 'unionOf' property, but it is not well-formed.  Must be of the form 'dsName.fieldName{,dsName.fieldName},...'. Ignoring this field.");
                continue;
            }
            for (int j = 0; j < fqFieldNames.length; ++j) {
                String[] work = fqFieldNames[j].trim().split("\\.");
                if (work.length != 2) {
                    log.warn("Union DataSource '" + String.valueOf(theConfig.get("ID")) + "', field '" + String.valueOf(field.get("name")) + "' declares the following sub-field in its 'unionOf' property: '" + fqFieldNames[j].trim() + "'. This is not well-formed - must be of the form 'dsName.fieldName'.  Ignoring this field.");
                    skip = true;
                    break;
                }
                String dsName = work[0];
                String fldName = work[1];
                DataSource validDs = null;
                for (int k = 0; k < this.unionOf.size(); ++k) {
                    if (!this.unionOf.get(k).getName().equals(dsName)) continue;
                    validDs = this.unionOf.get(k);
                    break;
                }
                if (validDs == null) {
                    log.warn("Union DataSource '" + String.valueOf(theConfig.get("ID")) + "', field '" + String.valueOf(field.get("name")) + "' declares the following sub-field in its 'unionOf' property: '" + fqFieldNames[j].trim() + "', but dataSource '" + dsName + "' is not declared in the dataSource's 'unionOf' property. Ignoring this field.");
                    skip = true;
                    break;
                }
                if (!validDs.getFieldNames().contains(fldName)) {
                    log.warn("Union DataSource '" + String.valueOf(theConfig.get("ID")) + "', field '" + String.valueOf(field.get("name")) + "' declares the following sub-field in its 'unionOf' property: '" + fqFieldNames[j].trim() + "', but dataSource '" + dsName + "' has no field named '" + fldName + "'.  Ignoring this field.");
                    skip = true;
                    break;
                }
                if (field.get("type") == null) {
                    field.put("type", ((BasicDataSource)validDs).getField(fldName).get("type"));
                }
                if (j == 0) {
                    unionedFieldType = (String)field.get("type");
                } else if (!unionedFieldType.equals(((BasicDataSource)validDs).getField(fldName).get("type"))) {
                    log.warn("Union DataSource '" + String.valueOf(theConfig.get("ID")) + "', field '" + String.valueOf(field.get("name")) + "' declares the following sub-field in its 'unionOf' property: '" + fqFieldNames[j].trim() + "', but that sub-field is not the same type as other sub-fields in the union.  Omitting this unioned field.");
                    skip = true;
                    break;
                }
                if (this.renamedFields.get(dsName) == null) {
                    this.renamedFields.put(dsName, new HashMap());
                }
                this.renamedFields.get(dsName).put((String)field.get("name"), fldName);
            }
            if (skip) continue;
            this.unionFieldsConfig.put((String)field.get("name"), field);
        }
    }

    public Map getRenamedFieldConfig(DataSource ds, Map field) {
        if (ds == null || field == null) {
            return null;
        }
        return this.getRenamedFieldConfig(ds.getName(), field);
    }

    public Map getRenamedFieldConfig(String dsName, Map field) {
        if (dsName == null || field == null) {
            return null;
        }
        Map<String, String> fieldRenames = this.renamedFields.get(dsName);
        if (fieldRenames == null) {
            return null;
        }
        for (String unionFieldName : fieldRenames.keySet()) {
            String subDsFieldName = fieldRenames.get(unionFieldName);
            if (!field.get("name").equals(subDsFieldName)) continue;
            return this.unionFieldsConfig.get(unionFieldName);
        }
        return null;
    }

    public DSField getRenamedField(DataSource ds, DSField field) {
        return this.getRenamedField(ds, field, null);
    }

    public DSField getRenamedField(DataSource ds, DSField field, DSRequest req) {
        DSRequest unionParentRequest;
        UnionDataSource unionParentDS;
        if (ds == null || field == null) {
            return null;
        }
        DSField renamed = null;
        Map<String, String> fieldRenames = this.renamedFields.get(ds.getName());
        if (fieldRenames != null) {
            for (String unionFieldName : fieldRenames.keySet()) {
                String subDsFieldName = fieldRenames.get(unionFieldName);
                if (!field.getName().equals(subDsFieldName)) continue;
                renamed = this.getField(unionFieldName);
                break;
            }
        }
        if (renamed == null && req != null && req.getAttribute("unionParentRequest") != null && (unionParentDS = (UnionDataSource)(unionParentRequest = (DSRequest)req.getAttribute("unionParentRequest")).getAttribute("unionDataSource")) != null) {
            renamed = unionParentDS.getRenamedField(this, field, unionParentRequest);
        }
        return renamed;
    }

    public String getOriginalFieldName(DataSource ds, String fieldName) {
        return this.getOriginalFieldName(ds.getName(), fieldName);
    }

    public String getOriginalFieldName(DataSource ds, String fieldName, DSRequest req) {
        return this.getOriginalFieldName(ds.getName(), fieldName, req);
    }

    public String getOriginalFieldName(String dsName, String fieldName) {
        return this.getOriginalFieldName(dsName, fieldName, null);
    }

    public String getOriginalFieldName(String dsName, String fieldName, DSRequest req) {
        String renamedAgain;
        DSRequest unionParentRequest;
        UnionDataSource unionParentDS;
        String original = null;
        if (this.renamedFields.get(dsName) != null) {
            original = this.renamedFields.get(dsName).get(fieldName);
        }
        if ((original == null || original.equals(fieldName)) && req != null && req.getAttribute("unionParentRequest") != null && (unionParentDS = (UnionDataSource)(unionParentRequest = (DSRequest)req.getAttribute("unionParentRequest")).getAttribute("unionDataSource")) != null && (original = unionParentDS.getOriginalFieldName(this, fieldName, unionParentRequest)) != null && (renamedAgain = this.renamedFields.get(dsName).get(original)) != null) {
            original = renamedAgain;
        }
        return original;
    }

    public Object convertCriteria(Map inputCriteria, DataSource ds, DSRequest req) {
        if (req.getIsAdvancedCriteria(inputCriteria)) {
            return this.convertAdvancedCriteria(inputCriteria, ds);
        }
        HashMap result = new HashMap();
        for (String fieldName : inputCriteria.keySet()) {
            String convertedFieldName = this.getOriginalFieldName(ds, fieldName);
            if (convertedFieldName == null) {
                convertedFieldName = fieldName;
            }
            result.put(convertedFieldName, inputCriteria.get(fieldName));
        }
        return result;
    }

    public AdvancedCriteria convertAdvancedCriteria(Map inputCriteria, DataSource ds) {
        return AdvancedCriteria.fromCollections(this.convertCriterion(inputCriteria, ds));
    }

    private Map convertCriterion(Map criterion, DataSource ds) {
        HashMap convertedCriterion = new HashMap();
        convertedCriterion.put("operator", criterion.get("operator"));
        if (criterion.containsKey("_constructor")) {
            convertedCriterion.put("_constructor", criterion.get("_constructor"));
        }
        if (criterion.get("criteria") != null) {
            List criteria = (List)criterion.get("criteria");
            ArrayList<Map> convertedCriteria = new ArrayList<Map>();
            convertedCriterion.put("criteria", convertedCriteria);
            for (int i = 0; i < criteria.size(); ++i) {
                convertedCriteria.add(this.convertCriterion((Map)criteria.get(i), ds));
            }
        } else {
            String fieldName = (String)criterion.get("fieldName");
            String convertedFieldName = this.getOriginalFieldName(ds, fieldName);
            convertedCriterion.put("fieldName", convertedFieldName != null ? convertedFieldName : fieldName);
            convertedCriterion.put("value", criterion.get("value"));
        }
        return convertedCriterion;
    }

    @Override
    public Map<String, Map> getAdditionalFields() {
        DataTypeMap declaredFields = this.dsConfig.getMap("fields");
        HashMap<String, Map> additionalFields = new HashMap<String, Map>();
        for (String fieldName : this.unionFieldsConfig.keySet()) {
            Map unionField = this.unionFieldsConfig.get(fieldName);
            String dsName = this.getFirstContributingDS(unionField);
            if (declaredFields.get(fieldName) != null || this.getRenamedFieldConfig(dsName, unionField) != null) continue;
            Map fieldDef = this.unionFieldsConfig.get(fieldName);
            additionalFields.put(fieldName, fieldDef);
        }
        return additionalFields;
    }

    @Override
    public DSResponse execute(DSRequest req) throws Exception {
        this.operationUnionFields = this.deriveOperationUnionFields(req);
        return super.execute(req);
    }

    public List<String> deriveOperationUnionFields(DSRequest req) throws Exception {
        block7: {
            block6: {
                DataTypeMap op;
                UnionDataSource parent;
                if (req != null && Boolean.TRUE.equals(req.getAttribute("unionMode")) && (parent = (UnionDataSource)req.getAttribute("unionDataSource")) != null && parent != this) {
                    this.operationUnionFields = parent.deriveOperationUnionFields(req);
                    if (this.operationUnionFields != null) {
                        return this.operationUnionFields;
                    }
                }
                if ((op = this.getOperationBinding(req)) == null) break block6;
                String unionFieldsStr = op.getString("unionFields");
                if (unionFieldsStr != null) {
                    this.operationUnionFields = new ArrayList<String>();
                    String[] work = unionFieldsStr.split(",");
                    for (int i = 0; i < work.length; ++i) {
                        this.operationUnionFields.add(work[i].trim());
                    }
                } else {
                    this.operationUnionFields = null;
                }
                break block7;
            }
            String unionFieldsStr = this.getConfig().getString("unionFields");
            if (unionFieldsStr == null) break block7;
            log.debug("DataSource-level unionFields delcaration found, applying it via 'operationUnionFields'");
            this.operationUnionFields = new ArrayList<String>();
            String[] work = unionFieldsStr.split(",");
            for (int i = 0; i < work.length; ++i) {
                this.operationUnionFields.add(work[i].trim());
            }
        }
        return this.operationUnionFields;
    }

    public List<String> getUnionFieldNames(DSRequest parentDsRequest) {
        DSRequest nextRequest;
        UnionDataSource nextDs;
        if (this.operationUnionFields != null && this.operationUnionFields.size() > 0) {
            return this.operationUnionFields;
        }
        if (parentDsRequest != null && parentDsRequest.getAttribute("unionParentRequest") != null && (nextDs = (UnionDataSource)(nextRequest = (DSRequest)parentDsRequest.getAttribute("unionParentRequest")).getAttribute("unionDataSource")) != null) {
            return nextDs.getUnionFieldNames(nextRequest);
        }
        return this.getFieldNames();
    }

    public DSField getUnionField(String fieldName, DSRequest parentDsRequest) {
        DSRequest nextRequest;
        UnionDataSource nextDs;
        if (parentDsRequest != null && parentDsRequest.getAttribute("unionParentRequest") != null && (nextDs = (UnionDataSource)(nextRequest = (DSRequest)parentDsRequest.getAttribute("unionParentRequest")).getAttribute("unionDataSource")) != null) {
            return nextDs.getUnionField(fieldName, nextRequest);
        }
        return this.getField(fieldName);
    }

    protected DSResponse processUnionDataSource(UnionDataSource thisUnionDs, DSRequest parentDsRequest) throws Exception {
        HashSet result = new HashSet();
        int totalRows = 0;
        for (BasicDataSource subDs : thisUnionDs.getUnionOf()) {
            if (subDs instanceof UnionDataSource) {
                DSRequest dummyReq = new DSRequest(subDs, "fetch");
                dummyReq.setAttribute("unionMode", true);
                dummyReq.setAttribute("unionDataSource", thisUnionDs);
                dummyReq.setAttribute("unionParentRequest", parentDsRequest);
                UnionDataSource subUnionDs = (UnionDataSource)subDs;
                DSResponse subResp = thisUnionDs.processUnionDataSource(subUnionDs, dummyReq);
                totalRows = (int)((long)totalRows + subResp.getTotalRows());
                Set subList = (Set)subResp.getData();
                thisUnionDs.transformRecords(subList, (DataSource)subUnionDs, dummyReq);
                int prev = result.size();
                result.addAll(subList);
                if (result.size() == prev + subList.size()) continue;
                totalRows += result.size() - (prev + subList.size());
                continue;
            }
            DSRequest subReq = thisUnionDs.createMemberDSRequest(subDs, parentDsRequest);
            DSResponse subResp = subReq.execute();
            totalRows = (int)((long)totalRows + subResp.getTotalRows());
            List subList = subResp.getRecords();
            if (!this.isSQLDataSource(subDs)) {
                thisUnionDs.transformRecords(subList, (DataSource)subDs, subReq);
            }
            int prev = result.size();
            result.addAll(subList);
            if (result.size() == prev + subList.size()) continue;
            totalRows += result.size() - (prev + subList.size());
        }
        DSResponse resp = new DSResponse(result);
        resp.setDataSource(thisUnionDs);
        resp.setTotalRows(totalRows);
        resp.setStartRow(parentDsRequest.getStartRow());
        long endRow = parentDsRequest.getEndRow();
        if (endRow >= 0L && endRow <= parentDsRequest.getStartRow() + (long)result.size()) {
            resp.setEndRow(parentDsRequest.getEndRow());
        } else {
            resp.setEndRow(parentDsRequest.getStartRow() + (long)result.size());
        }
        return resp;
    }

    protected DSRequest createMemberDSRequest(BasicDataSource memberDs, DSRequest parentReq) {
        DSRequest workReq = new DSRequest(memberDs, "fetch");
        HashMap rawCriteria = new HashMap((Map)parentReq.getRawCriteria());
        workReq.setCriteria(parentReq.getIsAdvancedCriteria() ? rawCriteria : parentReq.getCriteria());
        try {
            workReq.setCriteria(parentReq.getPreAggregationCriteria(workReq.getCriteria()));
        }
        catch (Exception e) {
            log.warn("Caught exception trying to derive pre-aggregation criteria for a UnionDataSource member DS.  The UnionDS is " + parentReq.getDataSourceName() + ", the member DS is " + memberDs.getID() + ". Continuing anyway - results may not be as expected.  The criteria map that failed is: " + String.valueOf(rawCriteria) + ".  The error was: " + e.getMessage());
        }
        workReq.setCriteria(this.convertCriteria(workReq.getCriteria(), memberDs, workReq));
        if (!parentReq.getIsAdvancedCriteria()) {
            workReq.setTextMatchStyle(parentReq.getTextMatchStyle());
        }
        workReq.setOutputs(this.getUnionFieldNames(parentReq));
        workReq.setStartRow(parentReq.getStartRow());
        workReq.setEndRow(parentReq.getStartRow());
        workReq.setAttribute("enforceOutputsFieldOrder", true);
        workReq.setAttribute("unionMode", true);
        workReq.setAttribute("unionDataSource", this);
        workReq.setAttribute("unionParentRequest", parentReq);
        return workReq;
    }

    public boolean isSQLDataSource(DataSource ds) {
        return ds == null ? false : ds.isSQLDataSource();
    }

    protected Set<Map> transformRecords(Set<Map> records, DataSource ds, DSRequest req) {
        this.transformRecords(records.iterator(), ds, req);
        return records;
    }

    protected List<Map> transformRecords(List<Map> records, DataSource ds, DSRequest req) {
        this.transformRecords(records.iterator(), ds, req);
        return records;
    }

    protected void transformRecords(Iterator<Map> i, DataSource ds, DSRequest req) {
        while (i.hasNext()) {
            Map record = i.next();
            for (String fieldName : this.getUnionFieldNames(req)) {
                String originalName;
                if (!fieldName.equals(originalName = this.getOriginalFieldName(ds, fieldName, req)) && originalName != null) {
                    record.put(fieldName, record.get(originalName));
                    record.remove(originalName);
                    continue;
                }
                if (record.containsKey(fieldName)) continue;
                record.put(fieldName, null);
            }
        }
    }

    @Override
    public boolean canJoinIncludedFields() {
        return true;
    }
}

