{ "jsonrpc": "2.0", "id": 2, "result": { "tools": [{ "annotations": { "title": "Add review comment to the requester's latest pending pull request review", "readOnlyHint": false }, "description": "Add review comment to the requester's latest pending pull request review. A pending review needs to already exist to call this (check with the user if not sure).", "inputSchema": { "properties": { "body": { "description": "The text of the review comment", "type": "string" }, "line": { "description": "The line of the blob in the pull request diff that the comment applies to. For multi-line comments, the last line of the range", "type": "number" }, "owner": { "description": "Repository owner", "type": "string" }, "path": { "description": "The relative path to the file that necessitates a comment", "type": "string" }, "pullNumber": { "description": "Pull request number", "type": "number" }, "repo": { "description": "Repository name", "type": "string" }, "side": { "description": "The side of the diff to comment on. LEFT indicates the previous state, RIGHT indicates the new state", "enum": ["LEFT", "RIGHT"], "type": "string" }, "startLine": { "description": "For multi-line comments, the first line of the range that the comment applies to", "type": "number" }, "startSide": { "description": "For multi-line comments, the starting side of the diff that the comment applies to. LEFT indicates the previous state, RIGHT indicates the new state", "enum": ["LEFT", "RIGHT"], "type": "string" }, "subjectType": { "description": "The level at which the comment is targeted", "enum": ["FILE", "LINE"], "type": "string" } }, "required": ["owner", "repo", "pullNumber", "path", "body", "subjectType"], "type": "object" }, "name": "add_comment_to_pending_review" }, { "annotations": { "title": "Add comment to issue", "readOnlyHint": false }, "description": "Add a comment to a specific issue in a GitHub repository.", "inputSchema": { "properties": { "body": { "description": "Comment content", "type": "string" }, "issue_number": { "description": "Issue number to comment on", "type": "number" }, "owner": { "description": "Repository owner", "type": "string" }, "repo": { "description": "Repository name", "type": "string" } }, "required": ["owner", "repo", "issue_number", "body"], "type": "object" }, "name": "add_issue_comment" }, { "annotations": { "title": "Add sub-issue", "readOnlyHint": false }, "description": "Add a sub-issue to a parent issue in a GitHub repository.", "inputSchema": { "properties": { "issue_number": { "description": "The number of the parent issue", "type": "number" }, "owner": { "description": "Repository owner", "type": "string" }, "replace_parent": { "description": "When true, replaces the sub-issue's current parent issue", "type": "boolean" }, "repo": { "description": "Repository name", "type": "string" }, "sub_issue_id": { "description": "The ID of the sub-issue to add. ID is not the same as issue number", "type": "number" } }, "required": ["owner", "repo", "issue_number", "sub_issue_id"], "type": "object" }, "name": "add_sub_issue" }, { "annotations": { "title": "Assign Copilot to issue", "readOnlyHint": false, "idempotentHint": true }, "description": "Assign Copilot to a specific issue in a GitHub repository.\n\nThis tool can help with the following outcomes:\n- a Pull Request created with source code changes to resolve the issue\n\n\nMore information can be found at:\n- https://docs.github.com/en/copilot/using-github-copilot/using-copilot-coding-agent-to-work-on-tasks/about-assigning-tasks-to-copilot\n", "inputSchema": { "properties": { "issueNumber": { "description": "Issue number", "type": "number" }, "owner": { "description": "Repository owner", "type": "string" }, "repo": { "description": "Repository name", "type": "string" } }, "required": ["owner", "repo", "issueNumber"], "type": "object" }, "name": "assign_copilot_to_issue" }, { "annotations": { "title": "Cancel workflow run", "readOnlyHint": false }, "description": "Cancel a workflow run", "inputSchema": { "properties": { "owner": { "description": "Repository owner", "type": "string" }, "repo": { "description": "Repository name", "type": "string" }, "run_id": { "description": "The unique identifier of the workflow run", "type": "number" } }, "required": ["owner", "repo", "run_id"], "type": "object" }, "name": "cancel_workflow_run" }, { "annotations": { "title": "Create and submit a pull request review without comments", "readOnlyHint": false }, "description": "Create and submit a review for a pull request without review comments.", "inputSchema": { "properties": { "body": { "description": "Review comment text", "type": "string" }, "commitID": { "description": "SHA of commit to review", "type": "string" }, "event": { "description": "Review action to perform", "enum": ["APPROVE", "REQUEST_CHANGES", "COMMENT"], "type": "string" }, "owner": { "description": "Repository owner", "type": "string" }, "pullNumber": { "description": "Pull request number", "type": "number" }, "repo": { "description": "Repository name", "type": "string" } }, "required": ["owner", "repo", "pullNumber", "body", "event"], "type": "object" }, "name": "create_and_submit_pull_request_review" }, { "annotations": { "title": "Create branch", "readOnlyHint": false }, "description": "Create a new branch in a GitHub repository", "inputSchema": { "properties": { "branch": { "description": "Name for new branch", "type": "string" }, "from_branch": { "description": "Source branch (defaults to repo default)", "type": "string" }, "owner": { "description": "Repository owner", "type": "string" }, "repo": { "description": "Repository name", "type": "string" } }, "required": ["owner", "repo", "branch"], "type": "object" }, "name": "create_branch" }, { "annotations": { "title": "Create Gist", "readOnlyHint": false }, "description": "Create a new gist", "inputSchema": { "properties": { "content": { "description": "Content for simple single-file gist creation", "type": "string" }, "description": { "description": "Description of the gist", "type": "string" }, "filename": { "description": "Filename for simple single-file gist creation", "type": "string" }, "public": { "default": false, "description": "Whether the gist is public", "type": "boolean" } }, "required": ["filename", "content"], "type": "object" }, "name": "create_gist" }, { "annotations": { "title": "Open new issue", "readOnlyHint": false }, "description": "Create a new issue in a GitHub repository.", "inputSchema": { "properties": { "assignees": { "description": "Usernames to assign to this issue", "items": { "type": "string" }, "type": "array" }, "body": { "description": "Issue body content", "type": "string" }, "labels": { "description": "Labels to apply to this issue", "items": { "type": "string" }, "type": "array" }, "milestone": { "description": "Milestone number", "type": "number" }, "owner": { "description": "Repository owner", "type": "string" }, "repo": { "description": "Repository name", "type": "string" }, "title": { "description": "Issue title", "type": "string" }, "type": { "description": "Type of this issue", "type": "string" } }, "required": ["owner", "repo", "title"], "type": "object" }, "name": "create_issue" }, { "annotations": { "title": "Create or update file", "readOnlyHint": false }, "description": "Create or update a single file in a GitHub repository. If updating, you must provide the SHA of the file you want to update. Use this tool to create or update a file in a GitHub repository remotely; do not use it for local file operations.", "inputSchema": { "properties": { "branch": { "description": "Branch to create/update the file in", "type": "string" }, "content": { "description": "Content of the file", "type": "string" }, "message": { "description": "Commit message", "type": "string" }, "owner": { "description": "Repository owner (username or organization)", "type": "string" }, "path": { "description": "Path where to create/update the file", "type": "string" }, "repo": { "description": "Repository name", "type": "string" }, "sha": { "description": "Required if updating an existing file. The blob SHA of the file being replaced.", "type": "string" } }, "required": ["owner", "repo", "path", "content", "message", "branch"], "type": "object" }, "name": "create_or_update_file" }, { "annotations": { "title": "Create pending pull request review", "readOnlyHint": false }, "description": "Create a pending review for a pull request. Call this first before attempting to add comments to a pending review, and ultimately submitting it. A pending pull request review means a pull request review, it is pending because you create it first and submit it later, and the PR author will not see it until it is submitted.", "inputSchema": { "properties": { "commitID": { "description": "SHA of commit to review", "type": "string" }, "owner": { "description": "Repository owner", "type": "string" }, "pullNumber": { "description": "Pull request number", "type": "number" }, "repo": { "description": "Repository name", "type": "string" } }, "required": ["owner", "repo", "pullNumber"], "type": "object" }, "name": "create_pending_pull_request_review" }, { "annotations": { "title": "Open new pull request", "readOnlyHint": false }, "description": "Create a new pull request in a GitHub repository.", "inputSchema": { "properties": { "base": { "description": "Branch to merge into", "type": "string" }, "body": { "description": "PR description", "type": "string" }, "draft": { "description": "Create as draft PR", "type": "boolean" }, "head": { "description": "Branch containing changes", "type": "string" }, "maintainer_can_modify": { "description": "Allow maintainer edits", "type": "boolean" }, "owner": { "description": "Repository owner", "type": "string" }, "repo": { "description": "Repository name", "type": "string" }, "title": { "description": "PR title", "type": "string" } }, "required": ["owner", "repo", "title", "head", "base"], "type": "object" }, "name": "create_pull_request" }, { "annotations": { "title": "Perform task with GitHub Copilot coding agent", "readOnlyHint": false }, "description": "Delegate a task to GitHub Copilot coding agent to perform in the background. The agent will create a pull request with the implementation. You should use this tool if the user asks to create a pull request to perform a specific task, or if the user asks Copilot to do something.", "inputSchema": { "properties": { "base_ref": { "description": "Git reference (e.g., branch) that the agent will start its work from. If not specified, defaults to the repository's default branch", "type": "string" }, "owner": { "description": "Repository owner. You can guess the owner, but confirm it with the user before proceeding.", "type": "string" }, "problem_statement": { "description": "Detailed description of the task to be performed (e.g., 'Implement a feature that does X', 'Fix bug Y', etc.)", "type": "string" }, "repo": { "description": "Repository name. You can guess the repository name, but confirm it with the user before proceeding.", "type": "string" }, "title": { "description": "Title for the pull request that will be created", "type": "string" } }, "required": ["owner", "repo", "problem_statement", "title"], "type": "object" }, "name": "create_pull_request_with_copilot" }, { "annotations": { "title": "Create repository", "readOnlyHint": false }, "description": "Create a new GitHub repository in your account", "inputSchema": { "properties": { "autoInit": { "description": "Initialize with README", "type": "boolean" }, "description": { "description": "Repository description", "type": "string" }, "name": { "description": "Repository name", "type": "string" }, "private": { "description": "Whether repo should be private", "type": "boolean" } }, "required": ["name"], "type": "object" }, "name": "create_repository" }, { "annotations": { "title": "Delete file", "readOnlyHint": false, "destructiveHint": true }, "description": "Delete a file from a GitHub repository", "inputSchema": { "properties": { "branch": { "description": "Branch to delete the file from", "type": "string" }, "message": { "description": "Commit message", "type": "string" }, "owner": { "description": "Repository owner (username or organization)", "type": "string" }, "path": { "description": "Path to the file to delete", "type": "string" }, "repo": { "description": "Repository name", "type": "string" } }, "required": ["owner", "repo", "path", "message", "branch"], "type": "object" }, "name": "delete_file" }, { "annotations": { "title": "Delete the requester's latest pending pull request review", "readOnlyHint": false }, "description": "Delete the requester's latest pending pull request review. Use this after the user decides not to submit a pending review, if you don't know if they already created one then check first.", "inputSchema": { "properties": { "owner": { "description": "Repository owner", "type": "string" }, "pullNumber": { "description": "Pull request number", "type": "number" }, "repo": { "description": "Repository name", "type": "string" } }, "required": ["owner", "repo", "pullNumber"], "type": "object" }, "name": "delete_pending_pull_request_review" }, { "annotations": { "title": "Delete workflow logs", "readOnlyHint": false, "destructiveHint": true }, "description": "Delete logs for a workflow run", "inputSchema": { "properties": { "owner": { "description": "Repository owner", "type": "string" }, "repo": { "description": "Repository name", "type": "string" }, "run_id": { "description": "The unique identifier of the workflow run", "type": "number" } }, "required": ["owner", "repo", "run_id"], "type": "object" }, "name": "delete_workflow_run_logs" }, { "annotations": { "title": "Dismiss notification", "readOnlyHint": false }, "description": "Dismiss a notification by marking it as read or done", "inputSchema": { "properties": { "state": { "description": "The new state of the notification (read/done)", "enum": ["read", "done"], "type": "string" }, "threadID": { "description": "The ID of the notification thread", "type": "string" } }, "required": ["threadID"], "type": "object" }, "name": "dismiss_notification" }, { "annotations": { "title": "Download workflow artifact", "readOnlyHint": true }, "description": "Get download URL for a workflow run artifact", "inputSchema": { "properties": { "artifact_id": { "description": "The unique identifier of the artifact", "type": "number" }, "owner": { "description": "Repository owner", "type": "string" }, "repo": { "description": "Repository name", "type": "string" } }, "required": ["owner", "repo", "artifact_id"], "type": "object" }, "name": "download_workflow_run_artifact" }, { "annotations": { "title": "Fork repository", "readOnlyHint": false }, "description": "Fork a GitHub repository to your account or specified organization", "inputSchema": { "properties": { "organization": { "description": "Organization to fork to", "type": "string" }, "owner": { "description": "Repository owner", "type": "string" }, "repo": { "description": "Repository name", "type": "string" } }, "required": ["owner", "repo"], "type": "object" }, "name": "fork_repository" }, { "annotations": { "title": "Get code scanning alert", "readOnlyHint": true }, "description": "Get details of a specific code scanning alert in a GitHub repository.", "inputSchema": { "properties": { "alertNumber": { "description": "The number of the alert.", "type": "number" }, "owner": { "description": "The owner of the repository.", "type": "string" }, "repo": { "description": "The name of the repository.", "type": "string" } }, "required": ["owner", "repo", "alertNumber"], "type": "object" }, "name": "get_code_scanning_alert" }, { "annotations": { "title": "Get commit details", "readOnlyHint": true }, "description": "Get details for a commit from a GitHub repository", "inputSchema": { "properties": { "owner": { "description": "Repository owner", "type": "string" }, "page": { "description": "Page number for pagination (min 1)", "minimum": 1, "type": "number" }, "perPage": { "description": "Results per page for pagination (min 1, max 100)", "maximum": 100, "minimum": 1, "type": "number" }, "repo": { "description": "Repository name", "type": "string" }, "sha": { "description": "Commit SHA, branch name, or tag name", "type": "string" } }, "required": ["owner", "repo", "sha"], "type": "object" }, "name": "get_commit" }, { "annotations": { "title": "Get dependabot alert", "readOnlyHint": true }, "description": "Get details of a specific dependabot alert in a GitHub repository.", "inputSchema": { "properties": { "alertNumber": { "description": "The number of the alert.", "type": "number" }, "owner": { "description": "The owner of the repository.", "type": "string" }, "repo": { "description": "The name of the repository.", "type": "string" } }, "required": ["owner", "repo", "alertNumber"], "type": "object" }, "name": "get_dependabot_alert" }, { "annotations": { "title": "Get discussion", "readOnlyHint": true }, "description": "Get a specific discussion by ID", "inputSchema": { "properties": { "discussionNumber": { "description": "Discussion Number", "type": "number" }, "owner": { "description": "Repository owner", "type": "string" }, "repo": { "description": "Repository name", "type": "string" } }, "required": ["owner", "repo", "discussionNumber"], "type": "object" }, "name": "get_discussion" }, { "annotations": { "title": "Get discussion comments", "readOnlyHint": true }, "description": "Get comments from a discussion", "inputSchema": { "properties": { "after": { "description": "Cursor for pagination. Use the endCursor from the previous page's PageInfo for GraphQL APIs.", "type": "string" }, "discussionNumber": { "description": "Discussion Number", "type": "number" }, "owner": { "description": "Repository owner", "type": "string" }, "perPage": { "description": "Results per page for pagination (min 1, max 100)", "maximum": 100, "minimum": 1, "type": "number" }, "repo": { "description": "Repository name", "type": "string" } }, "required": ["owner", "repo", "discussionNumber"], "type": "object" }, "name": "get_discussion_comments" }, { "annotations": { "title": "Get file or directory contents", "readOnlyHint": true }, "description": "Get the contents of a file or directory from a GitHub repository", "inputSchema": { "properties": { "owner": { "description": "Repository owner (username or organization)", "type": "string" }, "path": { "default": "/", "description": "Path to file/directory (directories must end with a slash '/')", "type": "string" }, "ref": { "description": "Accepts optional git refs such as `refs/tags/{tag}`, `refs/heads/{branch}` or `refs/pull/{pr_number}/head`", "type": "string" }, "repo": { "description": "Repository name", "type": "string" }, "sha": { "description": "Accepts optional commit SHA. If specified, it will be used instead of ref", "type": "string" } }, "required": ["owner", "repo"], "type": "object" }, "name": "get_file_contents" }, { "annotations": { "title": "Get a global security advisory", "readOnlyHint": true }, "description": "Get a global security advisory", "inputSchema": { "properties": { "ghsaId": { "description": "GitHub Security Advisory ID (format: GHSA-xxxx-xxxx-xxxx).", "type": "string" } }, "required": ["ghsaId"], "type": "object" }, "name": "get_global_security_advisory" }, { "annotations": { "title": "Get issue details", "readOnlyHint": true }, "description": "Get details of a specific issue in a GitHub repository.", "inputSchema": { "properties": { "issue_number": { "description": "The number of the issue", "type": "number" }, "owner": { "description": "The owner of the repository", "type": "string" }, "repo": { "description": "The name of the repository", "type": "string" } }, "required": ["owner", "repo", "issue_number"], "type": "object" }, "name": "get_issue" }, { "annotations": { "title": "Get issue comments", "readOnlyHint": true }, "description": "Get comments for a specific issue in a GitHub repository.", "inputSchema": { "properties": { "issue_number": { "description": "Issue number", "type": "number" }, "owner": { "description": "Repository owner", "type": "string" }, "page": { "description": "Page number for pagination (min 1)", "minimum": 1, "type": "number" }, "perPage": { "description": "Results per page for pagination (min 1, max 100)", "maximum": 100, "minimum": 1, "type": "number" }, "repo": { "description": "Repository name", "type": "string" } }, "required": ["owner", "repo", "issue_number"], "type": "object" }, "name": "get_issue_comments" }, { "annotations": { "title": "Get job logs", "readOnlyHint": true }, "description": "Download logs for a specific workflow job or efficiently get all failed job logs for a workflow run", "inputSchema": { "properties": { "failed_only": { "description": "When true, gets logs for all failed jobs in run_id", "type": "boolean" }, "job_id": { "description": "The unique identifier of the workflow job (required for single job logs)", "type": "number" }, "owner": { "description": "Repository owner", "type": "string" }, "repo": { "description": "Repository name", "type": "string" }, "return_content": { "description": "Returns actual log content instead of URLs", "type": "boolean" }, "run_id": { "description": "Workflow run ID (required when using failed_only)", "type": "number" }, "tail_lines": { "default": 500, "description": "Number of lines to return from the end of the log", "type": "number" } }, "required": ["owner", "repo"], "type": "object" }, "name": "get_job_logs" }, { "annotations": { "title": "Get latest release", "readOnlyHint": true }, "description": "Get the latest release in a GitHub repository", "inputSchema": { "properties": { "owner": { "description": "Repository owner", "type": "string" }, "repo": { "description": "Repository name", "type": "string" } }, "required": ["owner", "repo"], "type": "object" }, "name": "get_latest_release" }, { "annotations": { "title": "Get my user profile", "readOnlyHint": true }, "description": "Get details of the authenticated GitHub user. Use this when a request is about the user's own profile for GitHub. Or when information is missing to build other tool calls.", "inputSchema": { "properties": {}, "type": "object" }, "name": "get_me" }, { "annotations": { "title": "Get notification details", "readOnlyHint": true }, "description": "Get detailed information for a specific GitHub notification, always call this tool when the user asks for details about a specific notification, if you don't know the ID list notifications first.", "inputSchema": { "properties": { "notificationID": { "description": "The ID of the notification", "type": "string" } }, "required": ["notificationID"], "type": "object" }, "name": "get_notification_details" }, { "annotations": { "title": "Get pull request details", "readOnlyHint": true }, "description": "Get details of a specific pull request in a GitHub repository.", "inputSchema": { "properties": { "owner": { "description": "Repository owner", "type": "string" }, "pullNumber": { "description": "Pull request number", "type": "number" }, "repo": { "description": "Repository name", "type": "string" } }, "required": ["owner", "repo", "pullNumber"], "type": "object" }, "name": "get_pull_request" }, { "annotations": { "title": "Get pull request comments", "readOnlyHint": true }, "description": "Get comments for a specific pull request.", "inputSchema": { "properties": { "owner": { "description": "Repository owner", "type": "string" }, "pullNumber": { "description": "Pull request number", "type": "number" }, "repo": { "description": "Repository name", "type": "string" } }, "required": ["owner", "repo", "pullNumber"], "type": "object" }, "name": "get_pull_request_comments" }, { "annotations": { "title": "Get pull request diff", "readOnlyHint": true }, "description": "Get the diff of a pull request.", "inputSchema": { "properties": { "owner": { "description": "Repository owner", "type": "string" }, "pullNumber": { "description": "Pull request number", "type": "number" }, "repo": { "description": "Repository name", "type": "string" } }, "required": ["owner", "repo", "pullNumber"], "type": "object" }, "name": "get_pull_request_diff" }, { "annotations": { "title": "Get pull request files", "readOnlyHint": true }, "description": "Get the files changed in a specific pull request.", "inputSchema": { "properties": { "owner": { "description": "Repository owner", "type": "string" }, "page": { "description": "Page number for pagination (min 1)", "minimum": 1, "type": "number" }, "perPage": { "description": "Results per page for pagination (min 1, max 100)", "maximum": 100, "minimum": 1, "type": "number" }, "pullNumber": { "description": "Pull request number", "type": "number" }, "repo": { "description": "Repository name", "type": "string" } }, "required": ["owner", "repo", "pullNumber"], "type": "object" }, "name": "get_pull_request_files" }, { "annotations": { "title": "Get pull request reviews", "readOnlyHint": true }, "description": "Get reviews for a specific pull request.", "inputSchema": { "properties": { "owner": { "description": "Repository owner", "type": "string" }, "pullNumber": { "description": "Pull request number", "type": "number" }, "repo": { "description": "Repository name", "type": "string" } }, "required": ["owner", "repo", "pullNumber"], "type": "object" }, "name": "get_pull_request_reviews" }, { "annotations": { "title": "Get pull request status checks", "readOnlyHint": true }, "description": "Get the status of a specific pull request.", "inputSchema": { "properties": { "owner": { "description": "Repository owner", "type": "string" }, "pullNumber": { "description": "Pull request number", "type": "number" }, "repo": { "description": "Repository name", "type": "string" } }, "required": ["owner", "repo", "pullNumber"], "type": "object" }, "name": "get_pull_request_status" }, { "annotations": { "title": "Get a release by tag name", "readOnlyHint": true }, "description": "Get a specific release by its tag name in a GitHub repository", "inputSchema": { "properties": { "owner": { "description": "Repository owner", "type": "string" }, "repo": { "description": "Repository name", "type": "string" }, "tag": { "description": "Tag name (e.g., 'v1.0.0')", "type": "string" } }, "required": ["owner", "repo", "tag"], "type": "object" }, "name": "get_release_by_tag" }, { "annotations": { "title": "Get secret scanning alert", "readOnlyHint": true }, "description": "Get details of a specific secret scanning alert in a GitHub repository.", "inputSchema": { "properties": { "alertNumber": { "description": "The number of the alert.", "type": "number" }, "owner": { "description": "The owner of the repository.", "type": "string" }, "repo": { "description": "The name of the repository.", "type": "string" } }, "required": ["owner", "repo", "alertNumber"], "type": "object" }, "name": "get_secret_scanning_alert" }, { "annotations": { "title": "Get tag details", "readOnlyHint": true }, "description": "Get details about a specific git tag in a GitHub repository", "inputSchema": { "properties": { "owner": { "description": "Repository owner", "type": "string" }, "repo": { "description": "Repository name", "type": "string" }, "tag": { "description": "Tag name", "type": "string" } }, "required": ["owner", "repo", "tag"], "type": "object" }, "name": "get_tag" }, { "annotations": { "title": "Get team members", "readOnlyHint": true }, "description": "Get member usernames of a specific team in an organization. Limited to organizations accessible with current credentials", "inputSchema": { "properties": { "org": { "description": "Organization login (owner) that contains the team.", "type": "string" }, "team_slug": { "description": "Team slug", "type": "string" } }, "required": ["org", "team_slug"], "type": "object" }, "name": "get_team_members" }, { "annotations": { "title": "Get teams", "readOnlyHint": true }, "description": "Get details of the teams the user is a member of. Limited to organizations accessible with current credentials", "inputSchema": { "properties": { "user": { "description": "Username to get teams for. If not provided, uses the authenticated user.", "type": "string" } }, "type": "object" }, "name": "get_teams" }, { "annotations": { "title": "Get workflow run", "readOnlyHint": true }, "description": "Get details of a specific workflow run", "inputSchema": { "properties": { "owner": { "description": "Repository owner", "type": "string" }, "repo": { "description": "Repository name", "type": "string" }, "run_id": { "description": "The unique identifier of the workflow run", "type": "number" } }, "required": ["owner", "repo", "run_id"], "type": "object" }, "name": "get_workflow_run" }, { "annotations": { "title": "Get workflow run logs", "readOnlyHint": true }, "description": "Download logs for a specific workflow run (EXPENSIVE: downloads ALL logs as ZIP. Consider using get_job_logs with failed_only=true for debugging failed jobs)", "inputSchema": { "properties": { "owner": { "description": "Repository owner", "type": "string" }, "repo": { "description": "Repository name", "type": "string" }, "run_id": { "description": "The unique identifier of the workflow run", "type": "number" } }, "required": ["owner", "repo", "run_id"], "type": "object" }, "name": "get_workflow_run_logs" }, { "annotations": { "title": "Get workflow usage", "readOnlyHint": true }, "description": "Get usage metrics for a workflow run", "inputSchema": { "properties": { "owner": { "description": "Repository owner", "type": "string" }, "repo": { "description": "Repository name", "type": "string" }, "run_id": { "description": "The unique identifier of the workflow run", "type": "number" } }, "required": ["owner", "repo", "run_id"], "type": "object" }, "name": "get_workflow_run_usage" }, { "annotations": { "title": "List branches", "readOnlyHint": true }, "description": "List branches in a GitHub repository", "inputSchema": { "properties": { "owner": { "description": "Repository owner", "type": "string" }, "page": { "description": "Page number for pagination (min 1)", "minimum": 1, "type": "number" }, "perPage": { "description": "Results per page for pagination (min 1, max 100)", "maximum": 100, "minimum": 1, "type": "number" }, "repo": { "description": "Repository name", "type": "string" } }, "required": ["owner", "repo"], "type": "object" }, "name": "list_branches" }, { "annotations": { "title": "List code scanning alerts", "readOnlyHint": true }, "description": "List code scanning alerts in a GitHub repository.", "inputSchema": { "properties": { "owner": { "description": "The owner of the repository.", "type": "string" }, "ref": { "description": "The Git reference for the results you want to list.", "type": "string" }, "repo": { "description": "The name of the repository.", "type": "string" }, "severity": { "description": "Filter code scanning alerts by severity", "enum": ["critical", "high", "medium", "low", "warning", "note", "error"], "type": "string" }, "state": { "default": "open", "description": "Filter code scanning alerts by state. Defaults to open", "enum": ["open", "closed", "dismissed", "fixed"], "type": "string" }, "tool_name": { "description": "The name of the tool used for code scanning.", "type": "string" } }, "required": ["owner", "repo"], "type": "object" }, "name": "list_code_scanning_alerts" }, { "annotations": { "title": "List commits", "readOnlyHint": true }, "description": "Get list of commits of a branch in a GitHub repository. Returns at least 30 results per page by default, but can return more if specified using the perPage parameter (up to 100).", "inputSchema": { "properties": { "author": { "description": "Author username or email address to filter commits by", "type": "string" }, "owner": { "description": "Repository owner", "type": "string" }, "page": { "description": "Page number for pagination (min 1)", "minimum": 1, "type": "number" }, "perPage": { "description": "Results per page for pagination (min 1, max 100)", "maximum": 100, "minimum": 1, "type": "number" }, "repo": { "description": "Repository name", "type": "string" }, "sha": { "description": "Commit SHA, branch or tag name to list commits of. If not provided, uses the default branch of the repository. If a commit SHA is provided, will list commits up to that SHA.", "type": "string" } }, "required": ["owner", "repo"], "type": "object" }, "name": "list_commits" }, { "annotations": { "title": "List dependabot alerts", "readOnlyHint": true }, "description": "List dependabot alerts in a GitHub repository.", "inputSchema": { "properties": { "owner": { "description": "The owner of the repository.", "type": "string" }, "repo": { "description": "The name of the repository.", "type": "string" }, "severity": { "description": "Filter dependabot alerts by severity", "enum": ["low", "medium", "high", "critical"], "type": "string" }, "state": { "default": "open", "description": "Filter dependabot alerts by state. Defaults to open", "enum": ["open", "fixed", "dismissed", "auto_dismissed"], "type": "string" } }, "required": ["owner", "repo"], "type": "object" }, "name": "list_dependabot_alerts" }, { "annotations": { "title": "List discussion categories", "readOnlyHint": true }, "description": "List discussion categories with their id and name, for a repository or organisation.", "inputSchema": { "properties": { "owner": { "description": "Repository owner", "type": "string" }, "repo": { "description": "Repository name. If not provided, discussion categories will be queried at the organisation level.", "type": "string" } }, "required": ["owner"], "type": "object" }, "name": "list_discussion_categories" }, { "annotations": { "title": "List discussions", "readOnlyHint": true }, "description": "List discussions for a repository or organisation.", "inputSchema": { "properties": { "after": { "description": "Cursor for pagination. Use the endCursor from the previous page's PageInfo for GraphQL APIs.", "type": "string" }, "category": { "description": "Optional filter by discussion category ID. If provided, only discussions with this category are listed.", "type": "string" }, "direction": { "description": "Order direction.", "enum": ["ASC", "DESC"], "type": "string" }, "orderBy": { "description": "Order discussions by field. If provided, the 'direction' also needs to be provided.", "enum": ["CREATED_AT", "UPDATED_AT"], "type": "string" }, "owner": { "description": "Repository owner", "type": "string" }, "perPage": { "description": "Results per page for pagination (min 1, max 100)", "maximum": 100, "minimum": 1, "type": "number" }, "repo": { "description": "Repository name. If not provided, discussions will be queried at the organisation level.", "type": "string" } }, "required": ["owner"], "type": "object" }, "name": "list_discussions" }, { "annotations": { "title": "List Gists", "readOnlyHint": true }, "description": "List gists for a user", "inputSchema": { "properties": { "page": { "description": "Page number for pagination (min 1)", "minimum": 1, "type": "number" }, "perPage": { "description": "Results per page for pagination (min 1, max 100)", "maximum": 100, "minimum": 1, "type": "number" }, "since": { "description": "Only gists updated after this time (ISO 8601 timestamp)", "type": "string" }, "username": { "description": "GitHub username (omit for authenticated user's gists)", "type": "string" } }, "type": "object" }, "name": "list_gists" }, { "annotations": { "title": "List global security advisories", "readOnlyHint": true }, "description": "List global security advisories from GitHub.", "inputSchema": { "properties": { "affects": { "description": "Filter advisories by affected package or version (e.g. \"package1,package2@1.0.0\").", "type": "string" }, "cveId": { "description": "Filter by CVE ID.", "type": "string" }, "cwes": { "description": "Filter by Common Weakness Enumeration IDs (e.g. [\"79\", \"284\", \"22\"]).", "items": { "type": "string" }, "type": "array" }, "ecosystem": { "description": "Filter by package ecosystem.", "enum": ["actions", "composer", "erlang", "go", "maven", "npm", "nuget", "other", "pip", "pub", "rubygems", "rust"], "type": "string" }, "ghsaId": { "description": "Filter by GitHub Security Advisory ID (format: GHSA-xxxx-xxxx-xxxx).", "type": "string" }, "isWithdrawn": { "description": "Whether to only return withdrawn advisories.", "type": "boolean" }, "modified": { "description": "Filter by publish or update date or date range (ISO 8601 date or range).", "type": "string" }, "published": { "description": "Filter by publish date or date range (ISO 8601 date or range).", "type": "string" }, "severity": { "description": "Filter by severity.", "enum": ["unknown", "low", "medium", "high", "critical"], "type": "string" }, "type": { "default": "reviewed", "description": "Advisory type.", "enum": ["reviewed", "malware", "unreviewed"], "type": "string" }, "updated": { "description": "Filter by update date or date range (ISO 8601 date or range).", "type": "string" } }, "type": "object" }, "name": "list_global_security_advisories" }, { "annotations": { "title": "List available issue types", "readOnlyHint": true }, "description": "List supported issue types for repository owner (organization).", "inputSchema": { "properties": { "owner": { "description": "The organization owner of the repository", "type": "string" } }, "required": ["owner"], "type": "object" }, "name": "list_issue_types" }, { "annotations": { "title": "List issues", "readOnlyHint": true }, "description": "List issues in a GitHub repository. For pagination, use the 'endCursor' from the previous response's 'pageInfo' in the 'after' parameter.", "inputSchema": { "properties": { "after": { "description": "Cursor for pagination. Use the endCursor from the previous page's PageInfo for GraphQL APIs.", "type": "string" }, "direction": { "description": "Order direction. If provided, the 'orderBy' also needs to be provided.", "enum": ["ASC", "DESC"], "type": "string" }, "labels": { "description": "Filter by labels", "items": { "type": "string" }, "type": "array" }, "orderBy": { "description": "Order issues by field. If provided, the 'direction' also needs to be provided.", "enum": ["CREATED_AT", "UPDATED_AT", "COMMENTS"], "type": "string" }, "owner": { "description": "Repository owner", "type": "string" }, "perPage": { "description": "Results per page for pagination (min 1, max 100)", "maximum": 100, "minimum": 1, "type": "number" }, "repo": { "description": "Repository name", "type": "string" }, "since": { "description": "Filter by date (ISO 8601 timestamp)", "type": "string" }, "state": { "description": "Filter by state, by default both open and closed issues are returned when not provided", "enum": ["OPEN", "CLOSED"], "type": "string" } }, "required": ["owner", "repo"], "type": "object" }, "name": "list_issues" }, { "annotations": { "title": "List notifications", "readOnlyHint": true }, "description": "Lists all GitHub notifications for the authenticated user, including unread notifications, mentions, review requests, assignments, and updates on issues or pull requests. Use this tool whenever the user asks what to work on next, requests a summary of their GitHub activity, wants to see pending reviews, or needs to check for new updates or tasks. This tool is the primary way to discover actionable items, reminders, and outstanding work on GitHub. Always call this tool when asked what to work on next, what is pending, or what needs attention in GitHub.", "inputSchema": { "properties": { "before": { "description": "Only show notifications updated before the given time (ISO 8601 format)", "type": "string" }, "filter": { "description": "Filter notifications to, use default unless specified. Read notifications are ones that have already been acknowledged by the user. Participating notifications are those that the user is directly involved in, such as issues or pull requests they have commented on or created.", "enum": ["default", "include_read_notifications", "only_participating"], "type": "string" }, "owner": { "description": "Optional repository owner. If provided with repo, only notifications for this repository are listed.", "type": "string" }, "page": { "description": "Page number for pagination (min 1)", "minimum": 1, "type": "number" }, "perPage": { "description": "Results per page for pagination (min 1, max 100)", "maximum": 100, "minimum": 1, "type": "number" }, "repo": { "description": "Optional repository name. If provided with owner, only notifications for this repository are listed.", "type": "string" }, "since": { "description": "Only show notifications updated after the given time (ISO 8601 format)", "type": "string" } }, "type": "object" }, "name": "list_notifications" }, { "annotations": { "title": "List org repository security advisories", "readOnlyHint": true }, "description": "List repository security advisories for a GitHub organization.", "inputSchema": { "properties": { "direction": { "description": "Sort direction.", "enum": ["asc", "desc"], "type": "string" }, "org": { "description": "The organization login.", "type": "string" }, "sort": { "description": "Sort field.", "enum": ["created", "updated", "published"], "type": "string" }, "state": { "description": "Filter by advisory state.", "enum": ["triage", "draft", "published", "closed"], "type": "string" } }, "required": ["org"], "type": "object" }, "name": "list_org_repository_security_advisories" }, { "annotations": { "title": "List pull requests", "readOnlyHint": true }, "description": "List pull requests in a GitHub repository. If the user specifies an author, then DO NOT use this tool and use the search_pull_requests tool instead.", "inputSchema": { "properties": { "base": { "description": "Filter by base branch", "type": "string" }, "direction": { "description": "Sort direction", "enum": ["asc", "desc"], "type": "string" }, "head": { "description": "Filter by head user/org and branch", "type": "string" }, "owner": { "description": "Repository owner", "type": "string" }, "page": { "description": "Page number for pagination (min 1)", "minimum": 1, "type": "number" }, "perPage": { "description": "Results per page for pagination (min 1, max 100)", "maximum": 100, "minimum": 1, "type": "number" }, "repo": { "description": "Repository name", "type": "string" }, "sort": { "description": "Sort by", "enum": ["created", "updated", "popularity", "long-running"], "type": "string" }, "state": { "description": "Filter by state", "enum": ["open", "closed", "all"], "type": "string" } }, "required": ["owner", "repo"], "type": "object" }, "name": "list_pull_requests" }, { "annotations": { "title": "List releases", "readOnlyHint": true }, "description": "List releases in a GitHub repository", "inputSchema": { "properties": { "owner": { "description": "Repository owner", "type": "string" }, "page": { "description": "Page number for pagination (min 1)", "minimum": 1, "type": "number" }, "perPage": { "description": "Results per page for pagination (min 1, max 100)", "maximum": 100, "minimum": 1, "type": "number" }, "repo": { "description": "Repository name", "type": "string" } }, "required": ["owner", "repo"], "type": "object" }, "name": "list_releases" }, { "annotations": { "title": "List repository security advisories", "readOnlyHint": true }, "description": "List repository security advisories for a GitHub repository.", "inputSchema": { "properties": { "direction": { "description": "Sort direction.", "enum": ["asc", "desc"], "type": "string" }, "owner": { "description": "The owner of the repository.", "type": "string" }, "repo": { "description": "The name of the repository.", "type": "string" }, "sort": { "description": "Sort field.", "enum": ["created", "updated", "published"], "type": "string" }, "state": { "description": "Filter by advisory state.", "enum": ["triage", "draft", "published", "closed"], "type": "string" } }, "required": ["owner", "repo"], "type": "object" }, "name": "list_repository_security_advisories" }, { "annotations": { "title": "List secret scanning alerts", "readOnlyHint": true }, "description": "List secret scanning alerts in a GitHub repository.", "inputSchema": { "properties": { "owner": { "description": "The owner of the repository.", "type": "string" }, "repo": { "description": "The name of the repository.", "type": "string" }, "resolution": { "description": "Filter by resolution", "enum": ["false_positive", "wont_fix", "revoked", "pattern_edited", "pattern_deleted", "used_in_tests"], "type": "string" }, "secret_type": { "description": "A comma-separated list of secret types to return. All default secret patterns are returned. To return generic patterns, pass the token name(s) in the parameter.", "type": "string" }, "state": { "description": "Filter by state", "enum": ["open", "resolved"], "type": "string" } }, "required": ["owner", "repo"], "type": "object" }, "name": "list_secret_scanning_alerts" }, { "annotations": { "title": "List sub-issues", "readOnlyHint": true }, "description": "List sub-issues for a specific issue in a GitHub repository.", "inputSchema": { "properties": { "issue_number": { "description": "Issue number", "type": "number" }, "owner": { "description": "Repository owner", "type": "string" }, "page": { "description": "Page number for pagination (default: 1)", "type": "number" }, "per_page": { "description": "Number of results per page (max 100, default: 30)", "type": "number" }, "repo": { "description": "Repository name", "type": "string" } }, "required": ["owner", "repo", "issue_number"], "type": "object" }, "name": "list_sub_issues" }, { "annotations": { "title": "List tags", "readOnlyHint": true }, "description": "List git tags in a GitHub repository", "inputSchema": { "properties": { "owner": { "description": "Repository owner", "type": "string" }, "page": { "description": "Page number for pagination (min 1)", "minimum": 1, "type": "number" }, "perPage": { "description": "Results per page for pagination (min 1, max 100)", "maximum": 100, "minimum": 1, "type": "number" }, "repo": { "description": "Repository name", "type": "string" } }, "required": ["owner", "repo"], "type": "object" }, "name": "list_tags" }, { "annotations": { "title": "List workflow jobs", "readOnlyHint": true }, "description": "List jobs for a specific workflow run", "inputSchema": { "properties": { "filter": { "description": "Filters jobs by their completed_at timestamp", "enum": ["latest", "all"], "type": "string" }, "owner": { "description": "Repository owner", "type": "string" }, "page": { "description": "Page number for pagination (min 1)", "minimum": 1, "type": "number" }, "perPage": { "description": "Results per page for pagination (min 1, max 100)", "maximum": 100, "minimum": 1, "type": "number" }, "repo": { "description": "Repository name", "type": "string" }, "run_id": { "description": "The unique identifier of the workflow run", "type": "number" } }, "required": ["owner", "repo", "run_id"], "type": "object" }, "name": "list_workflow_jobs" }, { "annotations": { "title": "List workflow artifacts", "readOnlyHint": true }, "description": "List artifacts for a workflow run", "inputSchema": { "properties": { "owner": { "description": "Repository owner", "type": "string" }, "page": { "description": "Page number for pagination (min 1)", "minimum": 1, "type": "number" }, "perPage": { "description": "Results per page for pagination (min 1, max 100)", "maximum": 100, "minimum": 1, "type": "number" }, "repo": { "description": "Repository name", "type": "string" }, "run_id": { "description": "The unique identifier of the workflow run", "type": "number" } }, "required": ["owner", "repo", "run_id"], "type": "object" }, "name": "list_workflow_run_artifacts" }, { "annotations": { "title": "List workflow runs", "readOnlyHint": true }, "description": "List workflow runs for a specific workflow", "inputSchema": { "properties": { "actor": { "description": "Returns someone's workflow runs. Use the login for the user who created the workflow run.", "type": "string" }, "branch": { "description": "Returns workflow runs associated with a branch. Use the name of the branch.", "type": "string" }, "event": { "description": "Returns workflow runs for a specific event type", "enum": ["branch_protection_rule", "check_run", "check_suite", "create", "delete", "deployment", "deployment_status", "discussion", "discussion_comment", "fork", "gollum", "issue_comment", "issues", "label", "merge_group", "milestone", "page_build", "public", "pull_request", "pull_request_review", "pull_request_review_comment", "pull_request_target", "push", "registry_package", "release", "repository_dispatch", "schedule", "status", "watch", "workflow_call", "workflow_dispatch", "workflow_run"], "type": "string" }, "owner": { "description": "Repository owner", "type": "string" }, "page": { "description": "Page number for pagination (min 1)", "minimum": 1, "type": "number" }, "perPage": { "description": "Results per page for pagination (min 1, max 100)", "maximum": 100, "minimum": 1, "type": "number" }, "repo": { "description": "Repository name", "type": "string" }, "status": { "description": "Returns workflow runs with the check run status", "enum": ["queued", "in_progress", "completed", "requested", "waiting"], "type": "string" }, "workflow_id": { "description": "The workflow ID or workflow file name", "type": "string" } }, "required": ["owner", "repo", "workflow_id"], "type": "object" }, "name": "list_workflow_runs" }, { "annotations": { "title": "List workflows", "readOnlyHint": true }, "description": "List workflows in a repository", "inputSchema": { "properties": { "owner": { "description": "Repository owner", "type": "string" }, "page": { "description": "Page number for pagination (min 1)", "minimum": 1, "type": "number" }, "perPage": { "description": "Results per page for pagination (min 1, max 100)", "maximum": 100, "minimum": 1, "type": "number" }, "repo": { "description": "Repository name", "type": "string" } }, "required": ["owner", "repo"], "type": "object" }, "name": "list_workflows" }, { "annotations": { "title": "Manage notification subscription", "readOnlyHint": false }, "description": "Manage a notification subscription: ignore, watch, or delete a notification thread subscription.", "inputSchema": { "properties": { "action": { "description": "Action to perform: ignore, watch, or delete the notification subscription.", "enum": ["ignore", "watch", "delete"], "type": "string" }, "notificationID": { "description": "The ID of the notification thread.", "type": "string" } }, "required": ["notificationID", "action"], "type": "object" }, "name": "manage_notification_subscription" }, { "annotations": { "title": "Manage repository notification subscription", "readOnlyHint": false }, "description": "Manage a repository notification subscription: ignore, watch, or delete repository notifications subscription for the provided repository.", "inputSchema": { "properties": { "action": { "description": "Action to perform: ignore, watch, or delete the repository notification subscription.", "enum": ["ignore", "watch", "delete"], "type": "string" }, "owner": { "description": "The account owner of the repository.", "type": "string" }, "repo": { "description": "The name of the repository.", "type": "string" } }, "required": ["owner", "repo", "action"], "type": "object" }, "name": "manage_repository_notification_subscription" }, { "annotations": { "title": "Mark all notifications as read", "readOnlyHint": false }, "description": "Mark all notifications as read", "inputSchema": { "properties": { "lastReadAt": { "description": "Describes the last point that notifications were checked (optional). Default: Now", "type": "string" }, "owner": { "description": "Optional repository owner. If provided with repo, only notifications for this repository are marked as read.", "type": "string" }, "repo": { "description": "Optional repository name. If provided with owner, only notifications for this repository are marked as read.", "type": "string" } }, "type": "object" }, "name": "mark_all_notifications_read" }, { "annotations": { "title": "Merge pull request", "readOnlyHint": false }, "description": "Merge a pull request in a GitHub repository.", "inputSchema": { "properties": { "commit_message": { "description": "Extra detail for merge commit", "type": "string" }, "commit_title": { "description": "Title for merge commit", "type": "string" }, "merge_method": { "description": "Merge method", "enum": ["merge", "squash", "rebase"], "type": "string" }, "owner": { "description": "Repository owner", "type": "string" }, "pullNumber": { "description": "Pull request number", "type": "number" }, "repo": { "description": "Repository name", "type": "string" } }, "required": ["owner", "repo", "pullNumber"], "type": "object" }, "name": "merge_pull_request" }, { "annotations": { "title": "Push files to repository", "readOnlyHint": false }, "description": "Push multiple files to a GitHub repository in a single commit", "inputSchema": { "properties": { "branch": { "description": "Branch to push to", "type": "string" }, "files": { "description": "Array of file objects to push, each object with path (string) and content (string)", "items": { "additionalProperties": false, "properties": { "content": { "description": "file content", "type": "string" }, "path": { "description": "path to the file", "type": "string" } }, "required": ["path", "content"], "type": "object" }, "type": "array" }, "message": { "description": "Commit message", "type": "string" }, "owner": { "description": "Repository owner", "type": "string" }, "repo": { "description": "Repository name", "type": "string" } }, "required": ["owner", "repo", "branch", "files", "message"], "type": "object" }, "name": "push_files" }, { "annotations": { "title": "Remove sub-issue", "readOnlyHint": false }, "description": "Remove a sub-issue from a parent issue in a GitHub repository.", "inputSchema": { "properties": { "issue_number": { "description": "The number of the parent issue", "type": "number" }, "owner": { "description": "Repository owner", "type": "string" }, "repo": { "description": "Repository name", "type": "string" }, "sub_issue_id": { "description": "The ID of the sub-issue to remove. ID is not the same as issue number", "type": "number" } }, "required": ["owner", "repo", "issue_number", "sub_issue_id"], "type": "object" }, "name": "remove_sub_issue" }, { "annotations": { "title": "Reprioritize sub-issue", "readOnlyHint": false }, "description": "Reprioritize a sub-issue to a different position in the parent issue's sub-issue list.", "inputSchema": { "properties": { "after_id": { "description": "The ID of the sub-issue to be prioritized after (either after_id OR before_id should be specified)", "type": "number" }, "before_id": { "description": "The ID of the sub-issue to be prioritized before (either after_id OR before_id should be specified)", "type": "number" }, "issue_number": { "description": "The number of the parent issue", "type": "number" }, "owner": { "description": "Repository owner", "type": "string" }, "repo": { "description": "Repository name", "type": "string" }, "sub_issue_id": { "description": "The ID of the sub-issue to reprioritize. ID is not the same as issue number", "type": "number" } }, "required": ["owner", "repo", "issue_number", "sub_issue_id"], "type": "object" }, "name": "reprioritize_sub_issue" }, { "annotations": { "title": "Request Copilot review", "readOnlyHint": false }, "description": "Request a GitHub Copilot code review for a pull request. Use this for automated feedback on pull requests, usually before requesting a human reviewer.", "inputSchema": { "properties": { "owner": { "description": "Repository owner", "type": "string" }, "pullNumber": { "description": "Pull request number", "type": "number" }, "repo": { "description": "Repository name", "type": "string" } }, "required": ["owner", "repo", "pullNumber"], "type": "object" }, "name": "request_copilot_review" }, { "annotations": { "title": "Rerun failed jobs", "readOnlyHint": false }, "description": "Re-run only the failed jobs in a workflow run", "inputSchema": { "properties": { "owner": { "description": "Repository owner", "type": "string" }, "repo": { "description": "Repository name", "type": "string" }, "run_id": { "description": "The unique identifier of the workflow run", "type": "number" } }, "required": ["owner", "repo", "run_id"], "type": "object" }, "name": "rerun_failed_jobs" }, { "annotations": { "title": "Rerun workflow run", "readOnlyHint": false }, "description": "Re-run an entire workflow run", "inputSchema": { "properties": { "owner": { "description": "Repository owner", "type": "string" }, "repo": { "description": "Repository name", "type": "string" }, "run_id": { "description": "The unique identifier of the workflow run", "type": "number" } }, "required": ["owner", "repo", "run_id"], "type": "object" }, "name": "rerun_workflow_run" }, { "annotations": { "title": "Run workflow", "readOnlyHint": false }, "description": "Run an Actions workflow by workflow ID or filename", "inputSchema": { "properties": { "inputs": { "description": "Inputs the workflow accepts", "properties": {}, "type": "object" }, "owner": { "description": "Repository owner", "type": "string" }, "ref": { "description": "The git reference for the workflow. The reference can be a branch or tag name.", "type": "string" }, "repo": { "description": "Repository name", "type": "string" }, "workflow_id": { "description": "The workflow ID (numeric) or workflow file name (e.g., main.yml, ci.yaml)", "type": "string" } }, "required": ["owner", "repo", "workflow_id", "ref"], "type": "object" }, "name": "run_workflow" }, { "annotations": { "title": "Search code", "readOnlyHint": true }, "description": "Fast and precise code search across ALL GitHub repositories using GitHub's native search engine. Best for finding exact symbols, functions, classes, or specific code patterns.", "inputSchema": { "properties": { "order": { "description": "Sort order for results", "enum": ["asc", "desc"], "type": "string" }, "page": { "description": "Page number for pagination (min 1)", "minimum": 1, "type": "number" }, "perPage": { "description": "Results per page for pagination (min 1, max 100)", "maximum": 100, "minimum": 1, "type": "number" }, "query": { "description": "Search query using GitHub's powerful code search syntax. Examples: 'content:Skill language:Java org:github', 'NOT is:archived language:Python OR language:go', 'repo:github/github-mcp-server'. Supports exact matching, language filters, path filters, and more.", "type": "string" }, "sort": { "description": "Sort field ('indexed' only)", "type": "string" } }, "required": ["query"], "type": "object" }, "name": "search_code" }, { "annotations": { "title": "Search issues", "readOnlyHint": true }, "description": "Search for issues in GitHub repositories using issues search syntax already scoped to is:issue", "inputSchema": { "properties": { "order": { "description": "Sort order", "enum": ["asc", "desc"], "type": "string" }, "owner": { "description": "Optional repository owner. If provided with repo, only issues for this repository are listed.", "type": "string" }, "page": { "description": "Page number for pagination (min 1)", "minimum": 1, "type": "number" }, "perPage": { "description": "Results per page for pagination (min 1, max 100)", "maximum": 100, "minimum": 1, "type": "number" }, "query": { "description": "Search query using GitHub issues search syntax", "type": "string" }, "repo": { "description": "Optional repository name. If provided with owner, only issues for this repository are listed.", "type": "string" }, "sort": { "description": "Sort field by number of matches of categories, defaults to best match", "enum": ["comments", "reactions", "reactions-+1", "reactions--1", "reactions-smile", "reactions-thinking_face", "reactions-heart", "reactions-tada", "interactions", "created", "updated"], "type": "string" } }, "required": ["query"], "type": "object" }, "name": "search_issues" }, { "annotations": { "title": "Search organizations", "readOnlyHint": true }, "description": "Find GitHub organizations by name, location, or other organization metadata. Ideal for discovering companies, open source foundations, or teams.", "inputSchema": { "properties": { "order": { "description": "Sort order", "enum": ["asc", "desc"], "type": "string" }, "page": { "description": "Page number for pagination (min 1)", "minimum": 1, "type": "number" }, "perPage": { "description": "Results per page for pagination (min 1, max 100)", "maximum": 100, "minimum": 1, "type": "number" }, "query": { "description": "Organization search query. Examples: 'microsoft', 'location:california', 'created:\u003e=2025-01-01'. Search is automatically scoped to type:org.", "type": "string" }, "sort": { "description": "Sort field by category", "enum": ["followers", "repositories", "joined"], "type": "string" } }, "required": ["query"], "type": "object" }, "name": "search_orgs" }, { "annotations": { "title": "Search pull requests", "readOnlyHint": true }, "description": "Search for pull requests in GitHub repositories using issues search syntax already scoped to is:pr", "inputSchema": { "properties": { "order": { "description": "Sort order", "enum": ["asc", "desc"], "type": "string" }, "owner": { "description": "Optional repository owner. If provided with repo, only pull requests for this repository are listed.", "type": "string" }, "page": { "description": "Page number for pagination (min 1)", "minimum": 1, "type": "number" }, "perPage": { "description": "Results per page for pagination (min 1, max 100)", "maximum": 100, "minimum": 1, "type": "number" }, "query": { "description": "Search query using GitHub pull request search syntax", "type": "string" }, "repo": { "description": "Optional repository name. If provided with owner, only pull requests for this repository are listed.", "type": "string" }, "sort": { "description": "Sort field by number of matches of categories, defaults to best match", "enum": ["comments", "reactions", "reactions-+1", "reactions--1", "reactions-smile", "reactions-thinking_face", "reactions-heart", "reactions-tada", "interactions", "created", "updated"], "type": "string" } }, "required": ["query"], "type": "object" }, "name": "search_pull_requests" }, { "annotations": { "title": "Search repositories", "readOnlyHint": true }, "description": "Find GitHub repositories by name, description, readme, topics, or other metadata. Perfect for discovering projects, finding examples, or locating specific repositories across GitHub.", "inputSchema": { "properties": { "page": { "description": "Page number for pagination (min 1)", "minimum": 1, "type": "number" }, "perPage": { "description": "Results per page for pagination (min 1, max 100)", "maximum": 100, "minimum": 1, "type": "number" }, "query": { "description": "Repository search query. Examples: 'machine learning in:name stars:\u003e1000 language:python', 'topic:react', 'user:facebook'. Supports advanced search syntax for precise filtering.", "type": "string" } }, "required": ["query"], "type": "object" }, "name": "search_repositories" }, { "annotations": { "title": "Search users", "readOnlyHint": true }, "description": "Find GitHub users by username, real name, or other profile information. Useful for locating developers, contributors, or team members.", "inputSchema": { "properties": { "order": { "description": "Sort order", "enum": ["asc", "desc"], "type": "string" }, "page": { "description": "Page number for pagination (min 1)", "minimum": 1, "type": "number" }, "perPage": { "description": "Results per page for pagination (min 1, max 100)", "maximum": 100, "minimum": 1, "type": "number" }, "query": { "description": "User search query. Examples: 'john smith', 'location:seattle', 'followers:\u003e100'. Search is automatically scoped to type:user.", "type": "string" }, "sort": { "description": "Sort users by number of followers or repositories, or when the person joined GitHub.", "enum": ["followers", "repositories", "joined"], "type": "string" } }, "required": ["query"], "type": "object" }, "name": "search_users" }, { "annotations": { "title": "Submit the requester's latest pending pull request review", "readOnlyHint": false }, "description": "Submit the requester's latest pending pull request review, normally this is a final step after creating a pending review, adding comments first, unless you know that the user already did the first two steps, you should check before calling this.", "inputSchema": { "properties": { "body": { "description": "The text of the review comment", "type": "string" }, "event": { "description": "The event to perform", "enum": ["APPROVE", "REQUEST_CHANGES", "COMMENT"], "type": "string" }, "owner": { "description": "Repository owner", "type": "string" }, "pullNumber": { "description": "Pull request number", "type": "number" }, "repo": { "description": "Repository name", "type": "string" } }, "required": ["owner", "repo", "pullNumber", "event"], "type": "object" }, "name": "submit_pending_pull_request_review" }, { "annotations": { "title": "Update Gist", "readOnlyHint": false }, "description": "Update an existing gist", "inputSchema": { "properties": { "content": { "description": "Content for the file", "type": "string" }, "description": { "description": "Updated description of the gist", "type": "string" }, "filename": { "description": "Filename to update or create", "type": "string" }, "gist_id": { "description": "ID of the gist to update", "type": "string" } }, "required": ["gist_id", "filename", "content"], "type": "object" }, "name": "update_gist" }, { "annotations": { "title": "Edit issue", "readOnlyHint": false }, "description": "Update an existing issue in a GitHub repository.", "inputSchema": { "properties": { "assignees": { "description": "New assignees", "items": { "type": "string" }, "type": "array" }, "body": { "description": "New description", "type": "string" }, "issue_number": { "description": "Issue number to update", "type": "number" }, "labels": { "description": "New labels", "items": { "type": "string" }, "type": "array" }, "milestone": { "description": "New milestone number", "type": "number" }, "owner": { "description": "Repository owner", "type": "string" }, "repo": { "description": "Repository name", "type": "string" }, "state": { "description": "New state", "enum": ["open", "closed"], "type": "string" }, "title": { "description": "New title", "type": "string" }, "type": { "description": "New issue type", "type": "string" } }, "required": ["owner", "repo", "issue_number"], "type": "object" }, "name": "update_issue" }, { "annotations": { "title": "Edit pull request", "readOnlyHint": false }, "description": "Update an existing pull request in a GitHub repository.", "inputSchema": { "properties": { "base": { "description": "New base branch name", "type": "string" }, "body": { "description": "New description", "type": "string" }, "draft": { "description": "Mark pull request as draft (true) or ready for review (false)", "type": "boolean" }, "maintainer_can_modify": { "description": "Allow maintainer edits", "type": "boolean" }, "owner": { "description": "Repository owner", "type": "string" }, "pullNumber": { "description": "Pull request number to update", "type": "number" }, "repo": { "description": "Repository name", "type": "string" }, "reviewers": { "description": "GitHub usernames to request reviews from", "items": { "type": "string" }, "type": "array" }, "state": { "description": "New state", "enum": ["open", "closed"], "type": "string" }, "title": { "description": "New title", "type": "string" } }, "required": ["owner", "repo", "pullNumber"], "type": "object" }, "name": "update_pull_request" }, { "annotations": { "title": "Update pull request branch", "readOnlyHint": false }, "description": "Update the branch of a pull request with the latest changes from the base branch.", "inputSchema": { "properties": { "expectedHeadSha": { "description": "The expected SHA of the pull request's HEAD ref", "type": "string" }, "owner": { "description": "Repository owner", "type": "string" }, "pullNumber": { "description": "Pull request number", "type": "number" }, "repo": { "description": "Repository name", "type": "string" } }, "required": ["owner", "repo", "pullNumber"], "type": "object" }, "name": "update_pull_request_branch" }] } }
