/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.autotest;

import com.isomorphic.autotest.TestRunner;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.devenv.DevUtil;
import com.isomorphic.io.ISCFile;
import com.isomorphic.log.Logger;
import com.isomorphic.mail.MailMessage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class Utils {
    private static final String RESULT_VIEWER = "http://wrath.isomorphic.com:41080/tools/selenium/testResultViewer.jsp";
    private static Logger log = new Logger(Utils.class.getName());
    private static final String GOOGLE_HTTP_URL = "http://code.google.com";
    private static final String GOOGLE_URL_REGEX = "https?://code\\.google\\.com";
    private static final String OVERLAY_PATH_REGEXP = "[^\\n]*isomorphic\\/SOURCE_OVERLAY\\/(ISC_\\d+_BRANCH)[^\\n]*";
    private static final String CVSSPAM_BRANCH_REGEXP = "(?ms)^.*\\n<tr class[^\\n]*>Commit in <b>(?:[^\\n]*isomorphic\\/SOURCE_OVERLAY\\/(ISC_\\d+_BRANCH)[^\\n]*|[^\\n]*)<\\/b>[^\\n]* on (\\w+)<\\/";

    public static int getMaximumReportLength() {
        String res = System.getenv("DETAILS_REPORT_MAX_LENGTH");
        return res == null ? 0 : Integer.parseInt(res);
    }

    public static String getMyInstanceId() {
        return System.getenv("MY_AWS_INSTANCE_ID");
    }

    public static String getTestName(String testUrl, String basePath) {
        int qaInd;
        int n = qaInd = basePath != null ? testUrl.indexOf(basePath) : -1;
        if (qaInd >= 0) {
            return testUrl.substring(qaInd + basePath.length() + 1);
        }
        URI uri = URI.create(testUrl);
        return uri.getPath();
    }

    public static void outputHelp(String cmdLineSyntax, Options options) {
        Utils.outputHelp(cmdLineSyntax, options, null);
    }

    public static void outputHelp(String cmdLineSyntax, Options options, String error) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.setWidth(80);
        formatter.setSyntaxPrefix("usage:");
        formatter.printHelp(" " + cmdLineSyntax, "", options, (String)(error != null ? "\nError: " + error : ""));
    }

    public static boolean equalsOrBothNull(String s1, String s2) {
        if (null == s1) {
            return null == s2;
        }
        return s1.equals(s2);
    }

    public static void sleep(int milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static boolean isCvsSpam(String commitSpam) {
        return commitSpam.toLowerCase().indexOf("<html>") == 0;
    }

    public static String getModifiedFilesFromCvsSpam(String cvsSpam) throws Exception {
        String nextLine;
        StringBuilder modifiedFiles = new StringBuilder();
        BufferedReader br = new BufferedReader(new StringReader(cvsSpam));
        while ((nextLine = br.readLine()) != null) {
            String committedUrl;
            if (!nextLine.contains("href=\"#file") || !StringUtils.isNotEmpty((CharSequence)(committedUrl = StringUtils.substringBetween((String)nextLine, (String)"http://", (String)"?rev=")))) continue;
            modifiedFiles.append("http://").append(committedUrl).append(" , ");
        }
        IOUtils.closeQuietly((Reader)br);
        int length = modifiedFiles.length();
        if (length > 2) {
            modifiedFiles.setLength(length - 3);
        }
        return modifiedFiles.toString();
    }

    public static String getCommitBranchFromCvsSpam(String cvsSpam) throws Exception {
        Pattern branchPattern = Pattern.compile(CVSSPAM_BRANCH_REGEXP);
        Matcher branchMatcher = branchPattern.matcher(cvsSpam);
        if (!branchMatcher.find()) {
            throw new RuntimeException("Unable to resolve branch from cvsspam");
        }
        String overlayBranch = branchMatcher.group(1);
        if (overlayBranch != null) {
            try {
                DataTypeMap branchConf = DevUtil.branchConf(overlayBranch);
                if (branchConf.getBoolean((Object)"overlay", false)) {
                    return overlayBranch;
                }
                log.warn((Object)("Not treating this commit as against branch " + overlayBranch + " because it's not configured to allow source overlay"));
            }
            catch (Exception e) {
                log.error((Object)("Unexpected branch " + overlayBranch + " for source overlay; has it been registered as a valid branch in DevConfig.pm?"));
            }
        }
        return branchMatcher.group(2);
    }

    public static String getModifiedFilesFromCommitSpam(String commitSpam) throws Exception {
        return Utils.getModifiedFilesFromCvsSpam(commitSpam);
    }

    public static String getSmartClientVersionToReport(String branch) {
        String version = DevUtil.branchConf(branch).getString((Object)"versionToReport");
        return version != null ? version : DevUtil.branchConf(branch).getString((Object)"scVersion");
    }

    public static String getSubjectBaseAndSetFromFieldForEmail(MailMessage msg, String mode, String suiteName, String branch, String target) {
        String version = branch != null ? Utils.getSmartClientVersionToReport(branch) : null;
        msg.setFrom(mode.toLowerCase() + "test" + (String)(null != suiteName ? "." + suiteName : "") + "@isomorphic.com");
        return "[" + (String)(null != version ? version + " " : "") + mode + "Test" + (String)(null != suiteName ? "/" + suiteName : "") + (String)(null != target ? " " + target : "") + "] ";
    }

    public static void dumpStringToFile(String fileName, String content) {
        Utils.dumpStringsToFile(fileName, new String[]{content});
    }

    public static void dumpStringsToFile(String fileName, String[] content) {
        try {
            BufferedWriter file = new BufferedWriter(new FileWriter(fileName, true));
            for (int i = 0; i < content.length; ++i) {
                file.write(content[i]);
            }
            file.close();
        }
        catch (Exception e) {
            log.error((Object)("Error during write to file " + fileName), (Throwable)e);
        }
    }

    public static boolean matchRegExp(String pattern, InputStream input) {
        Scanner scanner = new Scanner(input);
        return scanner.findWithinHorizon(pattern, 0) != null;
    }

    public static boolean matchRegExp(String pattern, String input) {
        return Utils.matchRegExp(Pattern.compile(pattern), input);
    }

    public static boolean matchRegExp(Pattern pattern, String input) {
        if (input != null) {
            return pattern.matcher(input).find();
        }
        return false;
    }

    public static String addURLArgument(String location, String variableAssignment) {
        if (variableAssignment.length() == 0) {
            return location;
        }
        String operator = location.indexOf("?") >= 0 ? "&" : "?";
        return location + operator + variableAssignment;
    }

    public static String getCurrentMethodName() {
        StackTraceElement[] stackTraceElements = new Throwable().getStackTrace();
        return stackTraceElements[1].getMethodName();
    }

    protected static boolean isLocalFileAccessAllowed(String browser) {
        return false;
    }

    protected static String getSeleniumFilePath(String fileName, int serverPort) {
        return "http://localhost:" + serverPort + "/selenium-server/tests/" + fileName;
    }

    protected static String getUnqualifiedFileName(String path, boolean excludeSuffix) {
        String name = path.replaceFirst("^(?:[^\\\\\\/]*[\\\\\\/])*(.*)$", "$1");
        return excludeSuffix ? name.replaceFirst("^([^.]*).*$", "$1") : name;
    }

    protected static String linkify(String branch, Date batchStartTime, String suiteName, String testFile, boolean hidePass, String color) {
        Object result = "<a href=\"http://wrath.isomorphic.com:41080/tools/selenium/testResultViewer.jsp";
        result = (String)result + "?branch=" + branch;
        result = (String)result + "&batch=" + batchStartTime.getTime();
        result = (String)result + "&suite=" + TestRunner.getSuiteNameAsUrlParameter(suiteName);
        if (testFile != null) {
            result = (String)result + "&testFile=" + URLEncoder.encode(testFile);
        }
        if (hidePass) {
            result = (String)result + "&hidePass=true";
        }
        return (String)result + "\" style=\"color:" + color + ";\">";
    }

    protected static boolean isUnqualifiedFilename(String path) {
        return path.indexOf("/") < 0 && path.indexOf(".") >= 0;
    }

    private static List<String> find(String testRootPath, String glob) {
        List files = ISCFile.find((String)testRootPath, (boolean)true, (String)glob);
        return files != null ? files : new ArrayList();
    }

    private static List<String> ffind(String testRootPath, String pattern) {
        List files = ISCFile.ffind((String)testRootPath, (boolean)true, (String)pattern);
        return files != null ? files : new ArrayList();
    }

    protected static List<String> getFilesMatchingRegExs(String testRootPath, String[] userRegExs, String suiteRegEx) {
        ArrayList<String> files;
        String rootRegEx = testRootPath.replaceAll("([()\\[{*.+^$\\?|])", "\\\\$1");
        if (userRegExs != null) {
            files = new ArrayList();
            for (int i = 0; i < userRegExs.length; ++i) {
                String pattern = "(?=^" + rootRegEx + ".*" + userRegExs[i] + ")(?=" + suiteRegEx + ")";
                List<String> fileGroup = Utils.ffind(testRootPath, pattern);
                Collections.sort(fileGroup);
                files.addAll(fileGroup);
            }
        } else {
            files = Utils.ffind(testRootPath, suiteRegEx);
            Collections.sort(files);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("getFilesMatchingRegExs() found the following files:\n\t" + StringUtils.join(files, (String)"\n\t")));
        }
        return files;
    }

    protected static List<String> getFilesSpecifiedByPath(String testRootPath, String[] paths, String suiteRegEx) {
        Matcher matcher = Pattern.compile(suiteRegEx).matcher("");
        ArrayList<String> files = new ArrayList<String>();
        if (paths != null) {
            for (int i = 0; i < paths.length; ++i) {
                String path = paths[i];
                List<String> allFilesInPath = Utils.isUnqualifiedFilename(path) ? Utils.find(testRootPath, path) : Utils.find(testRootPath + "/" + path, "*");
                ArrayList<String> suiteFiles = new ArrayList<String>();
                for (String file : allFilesInPath) {
                    if (!matcher.reset(file).find()) continue;
                    suiteFiles.add(file);
                }
                Collections.sort(suiteFiles);
                files.addAll(suiteFiles);
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("getFilesSpecifiedByPath() found the following files:\n\t" + StringUtils.join(files, (String)"\n\t")));
        }
        return files;
    }

    protected static String getBatchLogFromSystemIn(String eofIndicator) throws Exception {
        String nextLine;
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        StringBuilder content = new StringBuilder();
        while ((nextLine = br.readLine()) != null) {
            content.append(nextLine).append("\n");
            if (eofIndicator == null || !nextLine.contains(eofIndicator)) continue;
            break;
        }
        return content.toString();
    }

    protected static String getCvsSpamFromSystemIn() throws Exception {
        return Utils.getBatchLogFromSystemIn("</html>");
    }

    protected static String execCommandAndReturnStdOut(String[] command) throws Exception {
        String line;
        ProcessBuilder builder = new ProcessBuilder(Arrays.asList(command));
        Map<String, String> environ = builder.environment();
        String perl5Lib = System.getenv("GLOBAL_DEVENV_BASE") + "/lib/perl";
        environ.put("PERL5LIB", perl5Lib + ":" + System.getenv("PERL5LIB"));
        Process process = builder.start();
        InputStream is = process.getInputStream();
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(isr);
        StringBuffer buffer = new StringBuffer();
        while ((line = br.readLine()) != null) {
            buffer.append(line + "\n");
        }
        return buffer.toString();
    }

    protected static String getCanonicalDate(String cvsDate, String timezone, int offsetSeconds) {
        try {
            String epochSeconds = Utils.execCommandAndReturnStdOut(new String[]{"/bin/date", "+%s", "-d", "TZ=\"" + timezone + "\" " + cvsDate}).trim();
            return Utils.execCommandAndReturnStdOut(new String[]{"/bin/date", "-d", "@" + (Integer.parseInt(epochSeconds) + offsetSeconds)}).trim();
        }
        catch (Exception e) {
            log.error((Object)("Unable to canonicalize date " + cvsDate));
            return cvsDate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String clipTextField(String dataSourceName, String fieldName, String text) throws Exception {
        DataSource dataSource = DataSourceManager.get((String)dataSourceName);
        try {
            Long length;
            DSField field;
            if (dataSource != null && text != null && (field = dataSource.getField(fieldName)) != null && (length = field.getLength()) != null && length < (long)text.length()) {
                String string = text.substring(0, length.intValue());
                return string;
            }
        }
        finally {
            DataSourceManager.free((DataSource)dataSource);
        }
        return text;
    }

    public static Integer getJavaProcessID() {
        String processName = ManagementFactory.getRuntimeMXBean().getName();
        if (!processName.contains("@")) {
            return null;
        }
        try {
            String processID = processName.substring(0, processName.indexOf("@"));
            return Integer.parseInt(processID);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.out.println("Usage: java com.isomorphic.autotest.Utils <cvsSpamFilename>");
            System.exit(1);
        }
        String fileName = args[0];
        File file = new File(fileName);
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            String line;
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
            String fileContent = sb.toString();
            String branch = Utils.getCommitBranchFromCvsSpam(fileContent);
            System.out.println("CvsSpam is for Branch: '" + branch + "'");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

