/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.autotest;

import com.isomorphic.autotest.TestRunner;
import com.isomorphic.autotest.TestRunnerLauncher;
import com.isomorphic.autotest.Utils;
import com.isomorphic.log.Logger;
import com.isomorphic.webdriver.ByScLocator;
import com.isomorphic.webdriver.SmartClientChromeDriver;
import com.isomorphic.webdriver.SmartClientEdgeDriver;
import com.isomorphic.webdriver.SmartClientFirefoxDriver;
import com.isomorphic.webdriver.SmartClientIEDriver;
import com.isomorphic.webdriver.SmartClientWebDriver;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.SystemUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.firefox.FirefoxOptions;

public class TestRunnerWebDriver {
    private static final Logger log = new Logger(TestRunnerWebDriver.class.getName());
    private static final String tmpDir = System.getenv("TMP_DIR") != null ? System.getenv("TMP_DIR") : "/tmp";
    private static final int DRIVER_TIMEOUT = 60;
    private static final int N_DRIVER_ATTEMPTS = 5;
    private static int activeDrivers;
    private String browserURL;
    private String browserStartCommand;
    private boolean browserMaximized;
    private SmartClientWebDriver driver;
    private Dimension lastSize;

    public TestRunnerWebDriver(String browserStartCommand) {
        this.browserStartCommand = browserStartCommand;
    }

    public TestRunnerWebDriver(String browserStartCommand, String browserURL) {
        this(browserStartCommand);
        this.browserURL = browserURL;
    }

    SmartClientWebDriver getSmartClientWebDriver() {
        return this.driver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSmartClientWebDriver() {
        for (int i = 0; i < 5; ++i) {
            try {
                ExecutorService executor = Executors.newSingleThreadExecutor();
                Future<SmartClientWebDriver> future = executor.submit(new SmartClientWebDriverCreator());
                try {
                    this.driver = future.get(60L, TimeUnit.SECONDS);
                    return;
                }
                catch (java.util.concurrent.TimeoutException e) {
                    future.cancel(true);
                }
                finally {
                    executor.shutdownNow();
                }
            }
            catch (InterruptedException | ExecutionException e) {
                log.error((Object)"Hit exception trying to create a SmartClientWebDriver", (Throwable)e);
            }
            Utils.sleep(5000);
        }
        throw new RuntimeException("Unable to create SmartClientWebDriver after 5 attempts.  Cannot proceed.");
    }

    private void killLastWebDriverProcessTree() {
        TestRunnerLauncher l = (TestRunnerLauncher)TestRunner.getConfiguration();
        if (!(this.driver instanceof SmartClientFirefoxDriver) || l.getWebDriverLegacyMode() || !SystemUtils.IS_OS_LINUX) {
            return;
        }
        Integer javaPID = Utils.getJavaProcessID();
        if (javaPID == null) {
            return;
        }
        String base = System.getenv("GLOBAL_DEVENV_BASE");
        if (base == null) {
            return;
        }
        String[] killCommand = new String[]{"/bin/bash", base + "/bin/killLastNamedChild", "" + javaPID, "geckodriver", "" + activeDrivers};
        try {
            Runtime.getRuntime().exec(killCommand).waitFor();
        }
        catch (IOException | InterruptedException e) {
            log.warn((Object)"Caught exception while waiting for exec to complete", (Throwable)e);
        }
    }

    public void start() {
        this.createSmartClientWebDriver();
        this.driver.setBaseUrl(this.browserURL);
        ++activeDrivers;
    }

    public void stop() {
        if (this.driver != null) {
            this.driver.quit();
            this.driver = null;
        }
        this.browserMaximized = false;
        --activeDrivers;
    }

    public void abort() {
        this.killLastWebDriverProcessTree();
        this.driver = null;
    }

    public void captureScreenshot(String filename) {
        try {
            Utils.sleep(3000);
            File tmpFile = (File)this.driver.getScreenshotAs(OutputType.FILE);
            FileUtils.copyFile((File)tmpFile, (File)new File(filename));
        }
        catch (IOException e) {
            log.error((Object)"Hit exception while trying to capture a screen shot", (Throwable)e);
        }
    }

    public void grab() {
        this.captureScreenshot(tmpDir + "/browser-final.png");
        try {
            Runtime.getRuntime().exec("timeout 60 showFirefoxBrowserConsole.sh").waitFor();
        }
        catch (Exception e) {
            log.error((Object)"Hit exception while trying to bring up the Firefox Console", (Throwable)e);
        }
        this.captureScreenshot(tmpDir + "/error-console.png");
    }

    public String getEval(String javaScript) {
        return this.driver.getEval(javaScript);
    }

    public String getEvalWithTry(String javaScript) {
        return this.getEvalWithTry(javaScript, "null");
    }

    public String getEvalWithTry(String javaScript, String fallbackValue) {
        try {
            return this.driver.getEval(javaScript, fallbackValue);
        }
        catch (Exception e) {
            log.error((Object)("getEvalWithTry(" + javaScript + ") failed"), (Throwable)e);
            return "null";
        }
    }

    public Object getAsyncEval(String javaScript, Object ... args) {
        return this.driver.executeAsyncScript(javaScript, args);
    }

    public Object getAsyncEvalWithTry(String javaScript, Object ... args) {
        try {
            return this.getAsyncEval(javaScript, args);
        }
        catch (Exception e) {
            log.error((Object)("getAsyncEvalWithTry(" + javaScript + ") failed"), (Throwable)e);
            return null;
        }
    }

    public boolean waitForJSToSucceed(String jsQuery, int timeoutInSeconds) {
        jsQuery = "try { " + (String)jsQuery + "; } catch(notUsed) { null; }";
        return this.driver.waitForCondition((String)jsQuery, (long)timeoutInSeconds);
    }

    public boolean evalAsBoolean(String javaScript) {
        return Boolean.parseBoolean(this.getEval(javaScript));
    }

    public boolean getBrowserMaximized() {
        return this.browserMaximized;
    }

    public void setBrowserMaximization(boolean maximize) {
        WebDriver.Window window = this.driver.manage().window();
        if (maximize) {
            this.lastSize = window.getSize();
            window.maximize();
        } else {
            if (this.lastSize != null) {
                window.setSize(this.lastSize);
            }
            this.lastSize = null;
        }
        this.browserMaximized = maximize;
    }

    public void open(String url) {
        log.info((Object)("Opening URL: " + url));
        try {
            this.driver.get(url, false);
        }
        catch (Exception e) {
            log.error((Object)("Failed to open url " + url), (Throwable)e);
        }
    }

    public void click(String locator, int timeoutInSeconds) {
        By by = ByScLocator.scLocator((String)locator);
        if (!this.driver.waitForElementClickable(by, (long)timeoutInSeconds)) {
            throw new TimeoutException("Timed out trying to click " + locator);
        }
        this.driver.click(by);
    }

    public String getHtmlSource() {
        return this.driver.getPageSource();
    }

    public boolean waitForElementPresent(String locator, int timeoutInSeconds) {
        return this.driver.waitForElementPresent(ByScLocator.scLocator((String)locator), (long)timeoutInSeconds);
    }

    public boolean waitForElementClickable(String locator, int timeoutInSeconds) {
        return this.driver.waitForElementClickable(ByScLocator.scLocator((String)locator), (long)timeoutInSeconds);
    }

    public void clearDeveloperConsoleMessages() {
        String javascript = "selenium.browserbot.getCurrentWindow().isc.Log.clear()";
        this.getEvalWithTry(javascript);
    }

    public String getDeveloperConsoleMessages() {
        String messageArray = "selenium.browserbot.getCurrentWindow().isc.Log.getMessages()";
        return this.getEvalWithTry(messageArray + ".join('\\n')");
    }

    private class SmartClientWebDriverCreator
    implements Callable<SmartClientWebDriver> {
        private SmartClientWebDriverCreator() {
        }

        @Override
        public SmartClientWebDriver call() {
            String[] browserTokens = TestRunnerWebDriver.this.browserStartCommand.split("\\s+", 2);
            String browserType = browserTokens[0].trim();
            String browserPath = null;
            if (browserTokens.length > 1) {
                browserPath = browserTokens[1].trim();
            }
            TestRunnerLauncher l = (TestRunnerLauncher)TestRunner.getConfiguration();
            switch (browserType) {
                case "*firefox": {
                    log.info((Object)"Creating a SmartClientFirefoxDriver");
                    if (browserPath != null) {
                        FirefoxOptions options = new FirefoxOptions();
                        options.setLegacy(l.getWebDriverLegacyMode());
                        options.setBinary(browserPath);
                        return new SmartClientFirefoxDriver(options);
                    }
                    FirefoxOptions options = new FirefoxOptions();
                    options.setLegacy(l.getWebDriverLegacyMode());
                    return new SmartClientFirefoxDriver(options);
                }
                case "*googlechrome": {
                    log.info((Object)"Creating a SmartClientChromeDriver");
                    if (browserPath != null) {
                        ChromeOptions options = new ChromeOptions();
                        options.setBinary(browserPath);
                        return new SmartClientChromeDriver(options);
                    }
                    return new SmartClientChromeDriver();
                }
                case "*iexplore": {
                    log.info((Object)"Creating a SmartClientIEDriver");
                    if (browserPath != null) {
                        log.warn((Object)"Path not supported for Internet Explorer!");
                    }
                    return new SmartClientIEDriver();
                }
                case "*msedge": {
                    log.info((Object)"Creating a SmartClientEdgeDriver");
                    if (browserPath != null) {
                        log.warn((Object)"Path not supported for MS Edge!");
                    }
                    return new SmartClientEdgeDriver();
                }
            }
            throw new UnsupportedOperationException("Unsupported browser: " + browserType + " with path: " + browserPath);
        }
    }
}

