/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.messaging;

import com.isomorphic.messaging.MessagingConnectionHandler;
import com.isomorphic.servlet.BaseServlet;
import com.isomorphic.servlet.RequestContext;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

public class MessagingServlet
extends BaseServlet {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Object contentType;
        boolean eventStream = "true".equals(request.getParameter("eventStream"));
        boolean disconnectUponConnect = "true".equals(request.getParameter("disconnectUponConnect"));
        request.setAttribute("isc_dontCompress", (Object)"RealtimeMessaging responses cannot be compressed");
        String encoding = this.getServletConfig().getInitParameter("encoding");
        if (encoding == null) {
            encoding = "UTF-8";
        }
        Object object = contentType = eventStream ? "text/event-stream" : "text/html";
        if (eventStream) {
            contentType = (String)contentType + ";charset=UTF-8";
            response.setContentType((String)contentType);
        } else if (!"none".equalsIgnoreCase(encoding)) {
            request.setCharacterEncoding(encoding);
            contentType = (String)contentType + ";charset=" + encoding;
            response.setContentType((String)contentType);
        } else {
            response.setContentType((String)contentType);
        }
        MessagingConnectionHandler handler = null;
        try {
            RequestContext context = RequestContext.instance((Servlet)this, (HttpServletRequest)request, (HttpServletResponse)response);
            context.setContentType((String)contentType);
            handler = new MessagingConnectionHandler(context);
            handler.eventStream = eventStream;
            handler.disconnectUponConnect = disconnectUponConnect;
            handler.process();
        }
        catch (Throwable t) {
            this.handleError(response, t);
        }
        finally {
            if (handler != null) {
                handler.cleanup();
            }
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }
}

