/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.base;

import com.isomorphic.base.Config;
import com.isomorphic.base.ReflectionArgument;
import com.isomorphic.base.VersionSafeChecker;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.js.JSONFilter;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.IDoNotAdapt;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections4.list.SetUniqueList;
import org.apache.commons.lang3.ArrayUtils;

public class Reflection {
    private static final String initializerMethodName = "_initialize";
    private static Logger log = new Logger(Reflection.class.getName());
    private static Map reflectionCache = new ConcurrentHashMap();
    private static Map<String, String> classNameShorthands = new HashMap<String, String>(){
        {
            this.put("Long", "java.lang.Long");
            this.put("Integer", "java.lang.Integer");
            this.put("Short", "java.lang.Short");
            this.put("Byte", "java.lang.Byte");
            this.put("Double", "java.lang.Double");
            this.put("Float", "java.lang.Float");
            this.put("AtomicInteger", "java.util.concurrent.atomic.AtomicInteger");
            this.put("AtomicLong", "java.util.concurrent.atomic.AtomicLong");
            this.put("Date", "java.util.Date");
            this.put("BigInteger", "java.math.BigInteger");
            this.put("BigDecimal", "java.math.BigDecimal");
            this.put("DateTime", "org.joda.time.DateTime");
            this.put("DateMidnight", "org.joda.time.DateMidnight");
            this.put("LocalDateTime", "java.time.LocalDateTime");
            this.put("LocalDate", "java.time.LocalDate");
            this.put("LocalTime", "java.time.LocalTime");
        }
    };
    private static final String CACHE_GLOBAL = "global";
    private static final String CACHE_CLASSLOADER = "classloader";
    private static final String CACHE_JDK = "jdk";
    private static final String CACHE_OFF = "off";
    private static ConcurrentHashMap<String, Class<?>> classNameCache = new ConcurrentHashMap();
    private static final ConcurrentHashMap<ClassLoader, ConcurrentHashMap<String, Class<?>>> loaderClassNameCache = new ConcurrentHashMap();
    public static long directLookupLapse = 0L;
    public static long directLookupFailedLapse = 0L;
    public static long singleMethodLapse = 0L;
    public static long multiMethodLapse = 0L;
    public static long directLookupFailures = 0L;
    public static long findMethodCalls = 0L;
    private static Map<Class, List<Class>> implementedInterfacesCache = new ConcurrentHashMap<Class, List<Class>>();

    public static Class classForName(String name) throws ClassNotFoundException {
        Class<Object> clazz;
        String classCacheMode;
        ConcurrentHashMap<String, Class<Object>> cache = null;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Object className = name;
        String shortcut = classNameShorthands.get(name);
        if (shortcut != null) {
            className = shortcut;
        }
        if (CACHE_CLASSLOADER.equalsIgnoreCase(classCacheMode = (String)Config.getProperty("reflection.classCache")) || classCacheMode == null) {
            if (cl != null) {
                cache = loaderClassNameCache.get(cl);
                if (cache == null) {
                    cache = new ConcurrentHashMap();
                    loaderClassNameCache.put(cl, cache);
                }
            } else {
                cache = classNameCache;
            }
        } else if (CACHE_JDK.equalsIgnoreCase(classCacheMode)) {
            if (className != null && ((String)className).startsWith("java.")) {
                cache = classNameCache;
            }
        } else if (CACHE_GLOBAL.equalsIgnoreCase(classCacheMode)) {
            cache = classNameCache;
        }
        if (cache != null && (clazz = cache.get(className)) != null) {
            return clazz;
        }
        try {
            clazz = Reflection._classForName((String)className, cl);
            if (cache != null) {
                cache.put((String)className, clazz);
            }
            return clazz;
        }
        catch (Exception e) {
            if (className != null && !((String)className).contains(".")) {
                className = "java.lang." + (String)className;
                if (cache == null && CACHE_JDK.equalsIgnoreCase(classCacheMode)) {
                    cache = classNameCache;
                }
                if (cache != null && (clazz = cache.get(className)) != null) {
                    return clazz;
                }
                clazz = Reflection._classForName((String)className, cl);
                if (cache != null) {
                    cache.put((String)className, clazz);
                }
                return clazz;
            }
            throw e;
        }
    }

    private static Class _classForName(String name, ClassLoader cl) throws ClassNotFoundException {
        try {
            return Class.forName(name, true, cl);
        }
        catch (Exception e) {
            return Class.forName(name);
        }
    }

    public static Throwable getRealTargetException(Throwable ite) {
        if (ite instanceof InvocationTargetException) {
            return Reflection.getRealTargetException(((InvocationTargetException)ite).getTargetException());
        }
        return ite;
    }

    public static Object instantiateClass(String className) throws Exception {
        return Reflection.instantiateClass(className, null, null);
    }

    public static Object instantiateClass(String className, Object ... initArgs) throws Exception {
        return Reflection.instantiateClass(className, null, initArgs);
    }

    public static Object instantiateClass(String className, Class[] initArgTypes, Object[] initArgs) throws Exception {
        Map classCache = Reflection.getClassCache(className);
        return Reflection.newInstance((Class)classCache.get("ClassObject"), initArgTypes, initArgs);
    }

    public static Object instantiateInnerClass(String className, Object enclosingInstance, Class[] initArgTypes, Object[] initArgs) throws Exception {
        Map classCache = Reflection.getClassCache(className);
        return Reflection.newInstance((Class)classCache.get("ClassObject"), initArgTypes, initArgs, enclosingInstance);
    }

    public static <T> T newInstance(Class<T> clazz) throws Exception {
        return Reflection.newInstance(clazz, (Class[])null, null);
    }

    public static <T> T newInstance(String className, Object ... initArgs) throws Exception {
        return Reflection.newInstance(className, null, initArgs);
    }

    public static <T> T newInstance(String className, Class[] initArgTypes, Object ... initArgs) throws Exception {
        try {
            return Reflection.newInstance(Reflection.classForName(className), initArgTypes, initArgs);
        }
        catch (ClassCastException e) {
            e = new ClassCastException("Instantiation of class: " + className + " threw a ClassCastException - Are you sure the expected class is the same as what was instantiated?");
            e.fillInStackTrace();
            throw e;
        }
    }

    public static <T> T newInstance(Class<T> clazz, Class[] initArgTypes, Object[] initArgs) throws Exception {
        return Reflection.newInstance(clazz, initArgTypes, initArgs, null);
    }

    public static <T> T newInstance(Class<T> clazz, Class[] initArgTypes, Object[] initArgs, Object enclosingInstance) throws Exception {
        try {
            if (initArgs == null) {
                if (enclosingInstance == null) {
                    return clazz.newInstance();
                }
                Constructor<T> constructor = clazz.getDeclaredConstructor(enclosingInstance.getClass());
                return constructor.newInstance(enclosingInstance);
            }
            if (initArgTypes == null) {
                initArgTypes = Reflection.lookupTypes(initArgs);
            }
            return clazz.getConstructor(initArgTypes).newInstance(initArgs);
        }
        catch (IllegalAccessException iae) {
            iae = new IllegalAccessException("Instantiation of class: " + clazz.getName() + " threw an IllegalAccessException - either the class or its zero-argument constructor is not accessible");
            iae.fillInStackTrace();
            throw iae;
        }
        catch (InstantiationException ie) {
            ie = new InstantiationException("Instantiation of class: " + clazz.getName() + " threw an InstantiationException - most likely cause is the class represents an abstract class, an interface, an array class, a primitive type, or void; or the class has no zero-argument constructor.");
            ie.fillInStackTrace();
            throw ie;
        }
        catch (ExceptionInInitializerError eiie) {
            eiie = new ExceptionInInitializerError("Instantiation of class: " + clazz.getName() + " threw an ExceptionInInitializerError - most likely cause is a failure to initialize the class (check your static initializers). Root cause: " + eiie.getCause().toString());
            eiie.fillInStackTrace();
            throw eiie;
        }
        catch (SecurityException se) {
            se = new SecurityException("Instantiation of class: " + clazz.getName() + " threw a SecurityException - most likely cause is that there is no permissio nto create a new instance of this class - error: " + se.toString());
            se.fillInStackTrace();
            throw se;
        }
    }

    private static Map populateClassCache(String className) throws Exception {
        return Reflection.populateClassCache(Reflection.classForName(className));
    }

    private static Map populateClassCache(Class classObject) throws Exception {
        HashMap<String, Serializable> classCache = new HashMap<String, Serializable>();
        classCache.put("ClassObject", classObject);
        reflectionCache.put(classObject, classCache);
        HashMap methodCache = new HashMap();
        classCache.put("methods", methodCache);
        Method[] classMethods = classObject.getMethods();
        for (int ii = 0; ii < classMethods.length; ++ii) {
            Method method = classMethods[ii];
            Reflection.addMethodToCache(method, methodCache);
        }
        return classCache;
    }

    private static void addMethodToCache(Method method, Map methodCache) throws Exception {
        String methodName = method.getName();
        Object value = methodCache.get(methodName);
        if (value == null) {
            methodCache.put(methodName, method);
        } else if (value instanceof Method) {
            HashMap argCache = new HashMap();
            methodCache.put(methodName, argCache);
            Reflection.addMethodToCache((Method)value, methodCache);
            Reflection.addMethodToCache(method, methodCache);
        } else if (value instanceof Map) {
            Map argCache = (Map)value;
            Integer numArgs = method.getParameterTypes().length;
            Object argValue = argCache.get(numArgs);
            if (argValue == null) {
                argCache.put(numArgs, method);
            } else if (argValue instanceof Method) {
                ArrayList<Method> argList = new ArrayList<Method>();
                argList.add(method);
                argList.add((Method)argValue);
            } else if (argValue instanceof List) {
                ((List)argValue).add(method);
            }
        }
    }

    private static Class[] lookupTypes(Object ... args) {
        if (args == null) {
            return null;
        }
        Class[] result = new Class[args.length];
        for (int ii = 0; ii < args.length; ++ii) {
            result[ii] = args[ii] == null ? null : args[ii].getClass();
        }
        return result;
    }

    public static Method findMethod(String methodName) throws Exception {
        int index = methodName.lastIndexOf(46);
        return Reflection.findMethod(methodName.substring(0, index), methodName.substring(index + 1));
    }

    public static Method findMethod(String className, String methodName) throws Exception {
        return Reflection.findMethod(Reflection.classForName(className), methodName, new Class[0]);
    }

    public static Method findMethod(Object instance, String methodName) throws Exception {
        return Reflection.findMethod(instance.getClass(), methodName, new Class[0]);
    }

    public static Method findMethod(String className, String methodName, Class ... methodArgs) throws Exception {
        return Reflection.findMethod(Reflection.classForName(className), methodName, methodArgs);
    }

    public static Method findMethod(Class classObj, String methodName, Class ... methodArgs) throws Exception {
        return Reflection.findMethod(classObj, methodName, methodArgs, true);
    }

    public static Method findNonPublicMethod(String className, String methodName, Class[] methodArgs) throws Exception {
        return Reflection.findMethod(Reflection.classForName(className), methodName, methodArgs, false);
    }

    public static Method findMethod(Class classObject, String methodName, Class[] methodArgs, boolean publicOnly) throws Exception {
        ++findMethodCalls;
        long nanos = System.nanoTime();
        String className = classObject.getName();
        Map classCache = Reflection.getClassCache(classObject);
        Map methodCache = (Map)classCache.get("methods");
        Method directLookup = null;
        try {
            directLookup = publicOnly ? classObject.getMethod(methodName, methodArgs) : classObject.getDeclaredMethod(methodName, methodArgs);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (directLookup != null) {
            return directLookup;
        }
        Object value = methodCache.get(methodName);
        if (value == null) {
            String message = "Method " + methodName + " not found on class " + className;
            throw new NoSuchMethodException(message);
        }
        if (value instanceof Method) {
            return (Method)value;
        }
        if (value instanceof Map) {
            Object argValue = ((Map)value).get(methodArgs.length);
            if (argValue == null) {
                String message = "Method " + methodName + " exists on " + className + " but with a different number of parameters - you passed in " + methodArgs.length;
                throw new NoSuchMethodException(message);
            }
            if (argValue instanceof Method) {
                return (Method)argValue;
            }
            if (argValue instanceof List) {
                String message = "Method " + className + "." + methodName + " is overloaded with the same number of parameters (" + methodArgs.length + ") - this is not supported.";
                throw new Exception(message);
            }
            String message = "Shouldn't happen: reflectionCache is corrupt - method lookup by param number returned object type: " + methodName;
            throw new Exception(message);
        }
        String message = "Shouldn't happen: reflectionCache is corrupt - method lookup returned object type: " + methodName;
        throw new Exception(message);
    }

    private static Map getClassCache(String className) throws Exception {
        return Reflection.getClassCache(Reflection.classForName(className));
    }

    private static Map getClassCache(Class classObject) throws Exception {
        Map classCache = (Map)reflectionCache.get(classObject);
        if (classCache == null) {
            classCache = Reflection.populateClassCache(classObject);
        }
        return classCache;
    }

    public static Object invokeMethod(Object classInstance, String methodName) throws Exception {
        return Reflection.invokeMethod(classInstance, methodName, new Object[0]);
    }

    public static Object invokeMethod(Object classInstance, String methodName, Object ... params) throws Exception {
        try {
            Method method = Reflection.findMethod(classInstance.getClass(), methodName, Reflection.lookupTypes(params));
            return Reflection._invokeMethod(method, classInstance, params);
        }
        catch (InvocationTargetException ite) {
            Throwable throwable = Reflection.getRealTargetException(ite);
            if (throwable instanceof Exception) {
                throw (Exception)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            log.error("invokeMethod() for method '" + methodName + "' caught a throwable that is neither an Exception nor an Error. Repackaging and re-throwing as an Error");
            Error error = new Error(throwable.getMessage());
            error.fillInStackTrace();
            throw error;
        }
    }

    public static Object _invokeMethod(Method method, Object obj, Object ... args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (!method.isAccessible()) {
            try {
                method.setAccessible(true);
            }
            catch (SecurityException e) {
                log.debug("Unable to set accessible bit on: " + method.getDeclaringClass().getName() + "." + method.getName());
            }
        }
        return method.invoke(obj, args);
    }

    public static Object invokeStaticMethod(String className, String methodName) throws Exception {
        Object[] params = new Object[]{};
        return Reflection.invokeStaticMethod(className, methodName, params);
    }

    public static Object invokeStaticMethod(String className, String methodName, Object ... params) throws Exception {
        return Reflection.invokeStaticMethod(className, methodName, false, params);
    }

    public static Object invokeNonVisibleStaticMethod(String className, String methodName, Object ... params) throws Exception {
        return Reflection.invokeStaticMethod(className, methodName, true, params);
    }

    public static Object invokeStaticMethod(String className, String methodName, boolean makeVisible, Object ... params) throws Exception {
        try {
            Method method;
            if (!makeVisible) {
                method = Reflection.findMethod(className, methodName, Reflection.lookupTypes(params));
            } else {
                method = Reflection.findNonPublicMethod(className, methodName, Reflection.lookupTypes(params));
                method.setAccessible(true);
            }
            return Reflection._invokeMethod(method, null, params);
        }
        catch (InvocationTargetException ite) {
            Throwable throwable = Reflection.getRealTargetException(ite);
            if (throwable instanceof Exception) {
                throw (Exception)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            log.error("invokeStaticMethod() for method '" + methodName + "' caught a throwable that is neither an Exception or an Error. Repackaging and re-throwing as an Error");
            Error error = new Error(throwable.getMessage());
            error.fillInStackTrace();
            throw error;
        }
    }

    private static String getFormattedParamTypes(Object[] params) {
        Object result = "";
        if (params == null || params.length == 0) {
            return "(empty parameter list)";
        }
        for (int ii = 0; ii < params.length; ++ii) {
            result = (String)result + (params[ii] != null ? params[ii].getClass().getName() : "null");
            if (ii + 1 >= params.length) continue;
            result = (String)result + ", ";
        }
        return result;
    }

    private static String getFormattedMethodSignature(Method method) {
        if (method == null) {
            return null;
        }
        String result = method.getReturnType().getName() + " " + method.getDeclaringClass().getName() + "." + method.getName() + "(";
        Class<?>[] paramTypes = method.getParameterTypes();
        for (int ii = 0; ii < paramTypes.length; ++ii) {
            result = result + paramTypes[ii].getName();
            if (ii + 1 >= paramTypes.length) continue;
            result = result + ", ";
        }
        result = result + ")";
        Class<?>[] exceptionTypes = method.getExceptionTypes();
        if (exceptionTypes.length > 0) {
            result = result + " throws ";
            for (int ii = 0; ii < exceptionTypes.length; ++ii) {
                result = result + exceptionTypes[ii].getName();
                if (ii + 1 >= exceptionTypes.length) continue;
                result = result + ", ";
            }
        }
        return result;
    }

    public static Object adaptArgsAndInvoke(Object instance, Method method, ReflectionArgument[] requiredArgs) throws Exception {
        return Reflection.adaptArgsAndInvoke(instance, method, requiredArgs, null, null, null);
    }

    public static Object adaptArgsAndInvoke(Object instance, Method method, ReflectionArgument[] requiredArgs, ReflectionArgument[] optionalArgs) throws Exception {
        return Reflection.adaptArgsAndInvoke(instance, method, requiredArgs, optionalArgs, null, null);
    }

    public static Object adaptArgsAndInvoke(Object instance, Method method, ReflectionArgument[] requiredArgs, ReflectionArgument[] optionalArgs, DataSource dataSource, DSRequest dsRequest) throws Exception {
        ArrayList<Object> methodArgs = new ArrayList<Object>();
        if (optionalArgs == null) {
            optionalArgs = new ReflectionArgument[]{};
        }
        if (requiredArgs == null) {
            requiredArgs = new ReflectionArgument[]{};
        }
        log.debug("adaptArgsAndInvoke:\n\n " + method.toString() + "\n\nrequiredArgs: " + Reflection.typesAsString(requiredArgs) + " optionalArgs: " + Reflection.typesAsString(optionalArgs));
        int requiredArgIndex = 0;
        List<Class<?>> parameterTypes = Arrays.asList(method.getParameterTypes());
        List genericParamTypes = VersionSafeChecker.getGenericParameterTypes(method);
        for (int i = 0; i < parameterTypes.size(); ++i) {
            Class<Object> paramType = parameterTypes.get(i);
            VersionSafeChecker.GenericParameterNode genericParamInfo = (VersionSafeChecker.GenericParameterNode)genericParamTypes.get(i);
            if (genericParamInfo != null && genericParamInfo.getClassByIndex(0) == paramType) {
                genericParamInfo = genericParamInfo.getChildNode();
            }
            Exception requiredAdaptException = null;
            ReflectionArgument reqArg = null;
            if (requiredArgIndex < requiredArgs.length) {
                reqArg = requiredArgs[requiredArgIndex];
                boolean assignedRequiredArg = false;
                try {
                    if (reqArg.getValue() == null) {
                        boolean optionalArgMatch = false;
                        for (int k = 0; k < optionalArgs.length; ++k) {
                            if (!paramType.isAssignableFrom(optionalArgs[k].getType()) || paramType.isAssignableFrom(Object.class)) continue;
                            optionalArgMatch = true;
                            break;
                        }
                        if (optionalArgMatch) {
                            log.debug("not assigning null value to optional arg slot: " + paramType.getName());
                        } else {
                            methodArgs.add(null);
                            assignedRequiredArg = true;
                        }
                    } else {
                        methodArgs.add(Reflection.adaptValue(paramType, genericParamInfo, reqArg, optionalArgs, dataSource, null, null, null, dsRequest));
                        assignedRequiredArg = true;
                    }
                    if (assignedRequiredArg) {
                        if (log.isDebugEnabled()) {
                            log.debug("Successfully adapted required arg type: " + (reqArg.getType() == null ? "null" : reqArg.getType().getName()) + " to type: " + paramType.getName());
                        }
                        ++requiredArgIndex;
                        continue;
                    }
                }
                catch (Exception e) {
                    if (log.isDebugEnabled()) {
                        Class type = requiredArgs[requiredArgIndex].getType();
                        log.debug("Failed to adapt required arg type: " + (type == null ? "null" : type.getName()) + " to type: " + paramType.getName() + ". Error string: " + e.toString() + " in " + e.getStackTrace()[0].toString());
                    }
                    requiredAdaptException = e;
                }
            }
            boolean assignedOptionalArg = false;
            for (int j = 0; j < optionalArgs.length; ++j) {
                ReflectionArgument optionalArg = optionalArgs[j];
                try {
                    methodArgs.add(Reflection.adaptValue(paramType, genericParamInfo, optionalArg, optionalArgs, dataSource, null, null, null, dsRequest));
                    assignedOptionalArg = true;
                    if (!log.isDebugEnabled()) break;
                    log.debug("Successfully adapted optional arg type: " + optionalArg.getType().getName() + " to type: " + paramType.getName());
                    break;
                }
                catch (Exception e) {
                    if (e.getClass() == Exception.class) continue;
                    log.warn("Exception occurred attempting to map arguments: " + e.toString() + " in " + (log.isDebugEnabled() ? DataTools.getStackTrace(e) : e.getStackTrace()[0].toString()));
                    continue;
                }
            }
            if (assignedOptionalArg) continue;
            Object typeName = paramType.getName();
            VersionSafeChecker.GenericParameterNode work = genericParamInfo;
            if (work != null && work.getChildNode() != null) {
                work = work.getChildNode();
            }
            if (work != null) {
                Class klass;
                typeName = (String)typeName + "<";
                int j = 0;
                while ((klass = work.getClassByIndex(j++)) != null) {
                    if (j > 1) {
                        typeName = (String)typeName + ", ";
                    }
                    typeName = (String)typeName + klass.getCanonicalName();
                }
                typeName = (String)typeName + ">";
            }
            String errorString = "Unable to assign a required or optional argument to slot #" + (i + 1) + " taking type: " + (String)typeName + " of method:\n\n" + method.toString() + "\n\nNo remaining optional arguments match this type";
            errorString = reqArg != null ? errorString + ".  The next required argument passed by the client was of type: " + (reqArg.getType() == null ? "null" : reqArg.getType().getName()) + "." : errorString + " and all required arguments passed by the client have already been assigned.";
            if (optionalArgs.length == 0) {
                errorString = errorString + "  Note that no optional arguments were available for this assignment, likely because your method definition in your .app.xml file specifies explicit methodArguments.  Please check to make sure this methodArguments declaration matches your method signature.";
            }
            errorString = errorString + "\n\n";
            throw new Exception(errorString);
        }
        Object[] args = DataTools.listToArray(methodArgs);
        log.debug("method takes: " + parameterTypes.size() + " args.  I've assembled: " + methodArgs.size() + " args");
        log.debug("invoking method:\n" + Reflection.getFormattedMethodSignature(method) + "\n\nwith arg types: " + Reflection.getFormattedParamTypes(args));
        return Reflection._invokeMethod(method, instance, args);
    }

    private static String typesAsString(Class[] classes) {
        ArrayList<String> result = new ArrayList<String>();
        if (classes == null) {
            return ((Object)result).toString();
        }
        for (int i = 0; i < classes.length; ++i) {
            result.add(classes[i].getName());
        }
        return ((Object)result).toString();
    }

    private static String typesAsString(ReflectionArgument[] args) {
        ArrayList<String> result = new ArrayList<String>();
        if (args == null) {
            return ((Object)result).toString();
        }
        for (int i = 0; i < args.length; ++i) {
            String className = args[i].getClassName();
            result.add(className == null ? "null" : className);
        }
        return ((Object)result).toString();
    }

    public static Object adaptValue(Class targetType, VersionSafeChecker.GenericParameterNode targetGenericInfo, ReflectionArgument arg, ReflectionArgument[] optionalArgs, DataSource dataSource, Class javaClass, Class javaCollectionClass, Class javaKeyClass, DSRequest dsRequest) throws Exception {
        Class<?> argType = arg.getType();
        String argTypeName = argType == null ? "null" : argType.getName();
        Object argValue = arg.getValue();
        String targetTypeName = targetType.getName();
        if (dataSource != null && !Collection.class.isAssignableFrom(targetType)) {
            dataSource._clearConvertedProperties();
        }
        if (argType == null && argValue == null) {
            return null;
        }
        log.debug("checking whether type: " + argTypeName + " fulfills type: " + targetTypeName);
        if (JSONFilter.class.isAssignableFrom(targetType)) {
            Class<?> realTarget = argValue instanceof Collection ? (javaCollectionClass != null ? javaCollectionClass : ArrayList.class) : (javaClass != null ? javaClass : Object.class);
            ReflectionArgument subArg = new ReflectionArgument(argValue.getClass(), argValue, true, true);
            Object subObj = Reflection.adaptValue(realTarget, targetGenericInfo, subArg, optionalArgs, dataSource, javaClass, javaCollectionClass, javaKeyClass, dsRequest);
            return new JSONFilter(subObj, dataSource, true);
        }
        if ((Collection.class.isAssignableFrom(targetType) || Map.class.isAssignableFrom(targetType)) && !IDoNotAdapt.class.isAssignableFrom(targetType)) {
            if (optionalArgs != null) {
                for (int i = 0; i < optionalArgs.length; ++i) {
                    Class optionalType = optionalArgs[i].getType();
                    if (optionalType != argType || optionalArgs[i].allowTypeConversion()) continue;
                    throw new Exception(argTypeName + " not adaptable to: " + targetTypeName);
                }
            }
            Iterator<Object> i = null;
            Object newArgValue = javaCollectionClass != null ? javaCollectionClass.newInstance() : (targetType.isInterface() || Modifier.isAbstract(targetType.getModifiers()) ? (targetType.isAssignableFrom(argValue.getClass()) ? argValue.getClass().newInstance() : (Map.class.isAssignableFrom(targetType) ? new LinkedHashMap() : (List.class.isAssignableFrom(targetType) ? new ArrayList() : (Set.class.isAssignableFrom(targetType) ? new HashSet() : (VersionSafeChecker.is5() && Queue.class.isAssignableFrom(targetType) ? new LinkedList() : (Collection.class.isAssignableFrom(targetType) ? new ArrayList() : argValue.getClass().newInstance())))))) : targetType.newInstance());
            Object key = null;
            Class keyClass = Object.class;
            Class<?> valueClass = null;
            if (Collection.class.isAssignableFrom(targetType)) {
                Collection<Object> c;
                Map map;
                if (argValue instanceof Map && (map = (Map)argValue).size() == 1) {
                    Iterator mapi = map.entrySet().iterator();
                    Map.Entry mape = mapi.next();
                    if (mape.getValue() instanceof Collection) {
                        argValue = mape.getValue();
                        argType = argValue.getClass();
                        argTypeName = argType.getName();
                    } else if (mape.getValue() instanceof Map) {
                        argValue = new ArrayList();
                        ((List)argValue).add(mape.getValue());
                        argType = argValue.getClass();
                        argTypeName = argType.getName();
                    }
                }
                if (argValue != null && argValue.getClass().isArray()) {
                    if (argValue instanceof boolean[]) {
                        argValue = ArrayUtils.toObject((boolean[])((boolean[])argValue));
                    } else if (argValue instanceof char[]) {
                        argValue = ArrayUtils.toObject((char[])((char[])argValue));
                    } else if (argValue instanceof byte[]) {
                        argValue = ArrayUtils.toObject((byte[])((byte[])argValue));
                    } else if (argValue instanceof double[]) {
                        argValue = ArrayUtils.toObject((double[])((double[])argValue));
                    } else if (argValue instanceof float[]) {
                        argValue = ArrayUtils.toObject((float[])((float[])argValue));
                    } else if (argValue instanceof int[]) {
                        argValue = ArrayUtils.toObject((int[])((int[])argValue));
                    } else if (argValue instanceof short[]) {
                        argValue = ArrayUtils.toObject((short[])((short[])argValue));
                    } else if (argValue instanceof long[]) {
                        argValue = ArrayUtils.toObject((long[])((long[])argValue));
                    }
                }
                if (argValue instanceof Object[]) {
                    c = new ArrayList<Object>();
                    Collections.addAll(c, (Object[])argValue);
                    argValue = c;
                }
                if (targetGenericInfo != null && (valueClass = targetGenericInfo.getClassByIndex(0)).isAssignableFrom(argType)) {
                    c = null;
                    if (!(targetType.isPrimitive() || VersionSafeChecker.isEnum(targetType) || targetType.isInterface() || Modifier.isAbstract(targetType.getModifiers()))) {
                        try {
                            c = (Collection)targetType.getConstructor(new Class[0]).newInstance(new Object[0]);
                        }
                        catch (Exception mapi) {
                            // empty catch block
                        }
                    }
                    if (c == null) {
                        c = List.class.isAssignableFrom(targetType) ? new ArrayList() : (Set.class.isAssignableFrom(targetType) ? new HashSet() : (Queue.class.isAssignableFrom(targetType) ? new LinkedList() : new ArrayList()));
                    }
                    c.add(argValue);
                    argValue = c;
                }
                i = ((Collection)argValue).iterator();
            } else if (Collection.class.isAssignableFrom(argType) && Map.class.isAssignableFrom(targetType)) {
                if (((Collection)argValue).size() == 1) {
                    argValue = ((Collection)argValue).iterator().next();
                    argType = argValue.getClass();
                    argTypeName = argType.getName();
                    i = ((Map)argValue).keySet().iterator();
                }
            } else {
                i = ((Map)argValue).keySet().iterator();
                if (targetGenericInfo != null) {
                    keyClass = targetGenericInfo.getClassByIndex(0);
                    valueClass = targetGenericInfo.getClassByIndex(1);
                }
            }
            if (javaClass != null) {
                valueClass = javaClass;
            }
            if (javaKeyClass != null) {
                keyClass = javaKeyClass;
            }
            boolean resetValueClass = false;
            if (valueClass == null) {
                resetValueClass = true;
            }
            while (i.hasNext()) {
                Object value = null;
                if (resetValueClass) {
                    valueClass = null;
                }
                if (Collection.class.isAssignableFrom(targetType)) {
                    value = i.next();
                } else {
                    key = i.next();
                    value = ((Map)argValue).get(key);
                }
                if (valueClass == null && value != null) {
                    valueClass = value.getClass();
                }
                Object newValue = null;
                if (value != null) {
                    ReflectionArgument subArg = new ReflectionArgument(value.getClass(), value, true, true);
                    newValue = Reflection.adaptValue(valueClass, targetGenericInfo == null ? null : targetGenericInfo.getChildNode(), subArg, optionalArgs, dataSource, javaClass, javaCollectionClass, javaKeyClass, dsRequest);
                }
                Object newKey = key;
                if (keyClass != Object.class) {
                    ReflectionArgument subArg = new ReflectionArgument(key.getClass(), key, true, true);
                    newKey = Reflection.adaptValue(keyClass, targetGenericInfo == null ? null : targetGenericInfo.getChildNode(), subArg, optionalArgs, dataSource, null, null, null, dsRequest);
                }
                if (Collection.class.isAssignableFrom(targetType)) {
                    ((Collection)newArgValue).add(newValue);
                    continue;
                }
                ((Map)newArgValue).put(newKey, newValue);
            }
            return newArgValue;
        }
        if (targetType.isAssignableFrom(argType)) {
            if (!VersionSafeChecker.is5()) {
                if (javaClass != null) {
                    log.warn("Unable to apply a specified 'javaClass' property: this feature requires a JVM 1.5 or later");
                }
                return argValue;
            }
            return javaClass == null ? argType.cast(argValue) : javaClass.cast(argValue);
        }
        if (arg.allowBeanConversion() && !Map.class.isAssignableFrom(argType) || VersionSafeChecker.isEnum(targetType)) {
            Object translatedValue = javaClass != null ? DataTools.convertType(javaClass, argValue) : DataTools.convertType(targetType, argValue);
            return translatedValue;
        }
        if (arg.allowBeanConversion() && Map.class.isAssignableFrom(argType)) {
            if (optionalArgs != null) {
                for (int i = 0; i < optionalArgs.length; ++i) {
                    Class optionalType = optionalArgs[i].getType();
                    if (optionalType != targetType) continue;
                    throw new Exception(argTypeName + " not adaptable to: " + targetTypeName);
                }
            }
            log.debug("Converting Map arg to bean of type: " + targetTypeName);
            if (argValue == null) {
                log.debug("Assigning null value to bean: " + targetTypeName);
                return null;
            }
            Object beanInstance = null;
            try {
                beanInstance = Reflection.newInstance(javaClass == null ? targetType : javaClass);
            }
            catch (Exception e) {
                Throwable rte = Reflection.getRealTargetException(e);
                log.warn("Failed to convert Map arg to bean of type: " + targetTypeName + " - because instantiation of " + targetTypeName + " threw the following Exception: " + rte.toString());
                throw e;
            }
            Map map = (Map)argValue;
            Map newArgMap = (Map)argValue.getClass().newInstance();
            Map<String, PropertyDescriptor> props = DataTools.getPropertyDescriptors(beanInstance);
            for (Object key : map.keySet()) {
                Object value;
                Object newArgValue = value = map.get(key);
                String subFieldType = null;
                Class subJavaClass = null;
                Class subJavaCollectionClass = null;
                Class subJavaKeyClass = null;
                String subFieldName = key.toString();
                if (dataSource != null && subFieldName != null) {
                    try {
                        DSField field = dataSource.getField(subFieldName);
                        if (field != null) {
                            subJavaClass = dataSource._getPropertyJavaClass(subFieldName, field, value);
                            String typeName = field.getProperty("javaCollectionClass");
                            if (typeName != null) {
                                subJavaCollectionClass = Reflection.classForName(typeName);
                            }
                            if ((typeName = field.getProperty("javaKeyClass")) != null) {
                                subJavaKeyClass = Reflection.classForName(typeName);
                            }
                        }
                    }
                    catch (Exception e) {
                        log.warn(e.getClass().getName() + " " + e.getMessage() + " encountered whilst trying to derive Java classes from override class names for DataSource '" + dataSource.getName() + "', field name '" + subFieldName + "'");
                    }
                }
                if (value instanceof Collection || value instanceof Map) {
                    PropertyDescriptor pd = props.get(key);
                    VersionSafeChecker.GenericParameterNode type = null;
                    ReflectionArgument ra = null;
                    boolean readMethod = true;
                    if (pd != null) {
                        DSField subField;
                        Method method = pd.getReadMethod();
                        if (method != null) {
                            type = VersionSafeChecker.getGenericReturnType(method);
                            ra = new ReflectionArgument(value.getClass(), value, true, true);
                        } else {
                            readMethod = false;
                            method = pd.getWriteMethod();
                            if (method != null) {
                                List paramTypes = VersionSafeChecker.getGenericParameterTypes(method);
                                type = (VersionSafeChecker.GenericParameterNode)paramTypes.get(0);
                                ra = new ReflectionArgument(value.getClass(), value, true, true);
                            }
                        }
                        if (dataSource != null && (subFieldName = key.toString()) != null && (subField = dataSource.getField(subFieldName)) != null) {
                            subFieldType = subField.getType();
                        }
                        DataSource subDataSource = subFieldType == null ? null : DataSourceManager.get(subFieldType, dsRequest);
                        newArgValue = Reflection.adaptValue(readMethod ? method.getReturnType() : method.getParameterTypes()[0], type == null ? null : type.getChildNode(), ra, optionalArgs, subDataSource, subJavaClass, subJavaCollectionClass, subJavaKeyClass, dsRequest);
                    }
                }
                newArgMap.put(key, newArgValue);
            }
            try {
                if (dataSource != null) {
                    return dataSource.setProperties(newArgMap, beanInstance, dsRequest, false);
                }
                return DataTools.setProperties(newArgMap, beanInstance, dataSource);
            }
            catch (Exception e) {
                Throwable rte = Reflection.getRealTargetException(e);
                String error = "Failed to convert Map arg to bean of type: " + targetTypeName + " - because bean population via DataTools.setProperties() threw the following Exception: " + rte.toString();
                if (rte instanceof IllegalArgumentException || rte instanceof ClassCastException) {
                    error = error + ". Maybe you have overridden an automatic binding by setting property 'javaClass' on a DataSourceField to an incorrect class (ie, a class that cannot be cast to the type that the setter function actually takes)?";
                }
                log.warn(error);
                throw e;
            }
        }
        if (arg.allowTypeConversion()) {
            log.debug("trying convertType");
            return DataTools.convertType(targetType, argValue);
        }
        throw new Exception(argTypeName + " not adaptable to: " + targetTypeName);
    }

    public static boolean methodTakesArgType(Method method, Class type) throws Exception {
        Class<?>[] parameterTypes = method.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (parameterTypes[i] != type) continue;
            return true;
        }
        return false;
    }

    public static List getBeanFields(String className) throws Exception {
        Class classObj = Reflection.classForName(className);
        Map<String, PropertyDescriptor> propertyDescriptors = DataTools.getPropertyDescriptors(classObj);
        ArrayList fields = new ArrayList();
        for (String propertyName : propertyDescriptors.keySet()) {
            PropertyDescriptor propertyDescriptor;
            Class<?> type;
            if ("class".equals(propertyName) || (type = (propertyDescriptor = propertyDescriptors.get(propertyName)).getPropertyType()) == null) continue;
            String typeName = type.getName();
            String fieldType = null;
            Map<Object, String> valueMap = null;
            if (VersionSafeChecker.isEnum(propertyDescriptor.getPropertyType())) {
                fieldType = "enum";
                valueMap = Reflection.getEnumValues(propertyDescriptor.getPropertyType(), false);
            }
            if (String.class.isAssignableFrom(type) || Character.class.isAssignableFrom(type) || "char".equals(typeName)) {
                fieldType = "text";
            } else if (Boolean.class.isAssignableFrom(type) || "boolean".equals(typeName)) {
                fieldType = "boolean";
            } else if (Time.class.isAssignableFrom(type)) {
                fieldType = "time";
            } else if (Timestamp.class.isAssignableFrom(type)) {
                fieldType = "datetime";
            } else if (Date.class.isAssignableFrom(type) || Calendar.class.isAssignableFrom(type)) {
                fieldType = "date";
            } else if (Byte.class.isAssignableFrom(type) || "byte".equals(typeName) || Short.class.isAssignableFrom(type) || "short".equals(typeName) || Integer.class.isAssignableFrom(type) || "int".equals(typeName) || Long.class.isAssignableFrom(type) || "long".equals(typeName) || BigInteger.class.isAssignableFrom(type)) {
                fieldType = "integer";
            } else if (Float.class.isAssignableFrom(type) || "float".equals(typeName) || Double.class.isAssignableFrom(type) || "double".equals(typeName) || BigDecimal.class.isAssignableFrom(type) || Number.class.isAssignableFrom(type)) {
                fieldType = "float";
            } else if (File.class.isAssignableFrom(type)) {
                fieldType = "binary";
            }
            HashMap<String, Object> field = new HashMap<String, Object>();
            field.put("name", propertyName);
            if (fieldType == null) {
                fieldType = new String(typeName);
                field.put("unknownType", Boolean.TRUE);
            }
            field.put("type", fieldType);
            if (valueMap != null) {
                field.put("valueMap", valueMap);
            }
            fields.add(field);
        }
        return fields;
    }

    public static <E extends Enum<E>> Map<Object, String> getEnumValues(Class<E> type, boolean ordinalKey) {
        return Reflection.getEnumValues(type, ordinalKey ? "ordinal" : "name");
    }

    public static <E extends Enum<E>> Map<Object, String> getEnumValues(Class<E> type, String enumTranslateStrategy) {
        LinkedHashMap<Object, String> valueList = new LinkedHashMap<Object, String>();
        Enum[] enumConstants = (Enum[])type.getEnumConstants();
        if (enumConstants != null) {
            for (Enum value : enumConstants) {
                Object key = null;
                key = "ordinal".equalsIgnoreCase(enumTranslateStrategy) ? Integer.valueOf(value.ordinal()) : ("string".equalsIgnoreCase(enumTranslateStrategy) ? value.toString() : value.name());
                String stringValue = value.toString();
                if (stringValue.equals(value.name())) {
                    try {
                        type.getDeclaredMethod("toString", new Class[0]);
                    }
                    catch (NoSuchMethodException nsme) {
                        stringValue = DataTools.deriveTitleFromName(stringValue);
                    }
                }
                valueList.put(key, stringValue);
            }
        }
        return valueList;
    }

    public static String getCaller(boolean withMethodName) {
        return Reflection.getCaller(new Exception(), 2, withMethodName);
    }

    public static String getCaller(int level, boolean withMethodName) {
        return Reflection.getCaller(new Exception(), level + 1, withMethodName);
    }

    public static String getCaller(Throwable t, int level, boolean withMethodName) {
        StackTraceElement stackTraceElement = t.getStackTrace()[level];
        if (withMethodName) {
            return stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName();
        }
        return stackTraceElement.getClassName();
    }

    public static List<Class> getAllImplementedInterfaces(Object obj) {
        return Reflection.getAllImplementedInterfaces(obj.getClass());
    }

    public static List<Class> getAllImplementedInterfaces(Class c) {
        if (c == null) {
            return new ArrayList<Class>();
        }
        SetUniqueList result = implementedInterfacesCache.get(c);
        if (result == null) {
            result = SetUniqueList.setUniqueList(new ArrayList());
            result.addAll(Reflection.getAllImplementedInterfaces(c.getSuperclass()));
            List<Class<?>> interfaces = Arrays.asList(c.getInterfaces());
            for (Class<?> i : interfaces) {
                result.addAll(Reflection.getAllImplementedInterfaces(i));
            }
            result.addAll(interfaces);
            implementedInterfacesCache.put(c, (List<Class>)result);
        }
        return result;
    }

    public static Object proxyWrap(Object obj, InvocationHandler handler) {
        Class[] interfaces = Reflection.getAllImplementedInterfaces(obj).toArray(new Class[0]);
        return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), interfaces, handler);
    }
}

