# Skinning / Theming

[← Back to API Index](../reference.md)

---

## KB Topic: Skinning / Theming

### Description
Skinning (aka "theming" or "branding") is the process of modifying SmartClient's default look and feel to match the desired look and feel for your application. SmartClient supports an extremely powerful and simple skinning system that allows designers with a basic grasp of CSS and JSON to skin any SmartClient component.

See the [Skin Editor overview](skinEditor.md#kb-topic-skin-editor) for information about the most modern approach to skinning a SmartClient application.

#### Basics

*   SmartClient components create their visual appearance by dynamically generating HTML, within the browser, using JavaScript.
*   the HTML generated by SmartClient components contains CSS style names and URLs to images
*   SmartClient components can be skinned by replacing the CSS styles and images that the components use by default, or by setting properties on components to configure them to use new CSS styles and new image URLs.
*   You can change the appearance of an individual SmartClient component by passing properties to [create()](../classes/Class.md#classmethod-classcreate), or you can skin all components of the same class at once, by using [addProperties()](../classes/Class.md#classmethod-classaddproperties) and [changeDefaults()](../classes/Class.md#classmethod-classchangedefaults) to change the defaults for the class.
*   CSS is used to control details of appearance such as fonts, borders and background colors and gradients, but component properties are used to control layout and positioning of components. See [CSSStyleName](../reference.md#type-cssstylename) for more details about correct usage.
*   A "skin" consists of:
    *   `skin_styles.css` - a CSS stylesheet containing all CSS styles used by SmartClient components
    *   `images/` - a directory tree of images organized by component
    *   `load_skin.js` - a JavaScript file that loads the CSS stylesheet, applies the images and modifies any other component or framework default settings required for the skin
*   The example skins that come with SmartClient are in `smartclientSDK/isomorphic/skins`. The standard directory layout for a skin is:
    ```
            skin_styles.css
            load_skin.js
            images/
                Actions/
                    add.png 
                    ...
                ListGrid/
                    sort_ascending.png
                    ...
                Tab/
                ... other directories containing
                    component or shared media ...
     
    ```
    
*   A skin is loaded via a `<SCRIPT SRC=>` tag that loads load\_skin.js, or, if using the SmartClient server, by specifying the "skin" property of the [loadISCTag](loadISCTag.md#kb-topic-isomorphicloadisc). load\_skin.js loads the stylesheet and sets the CSS styleNames and media URLs that SmartClient components will use.
*   **Some skins also provide Sass templates for easier customization via variables - see the [Custom Sass Skinning](customSassSkins.md#kb-topic-customizing-sass-based-skins) discussion**

#### CSS3 mode

SmartClient can make use of CSS3 features to render user interface component details such as rounded corners, gradients and drop-shadows. Prior to the wide adoption of CSS3 by browsers such UI details could only be achieved by writing out HTML structures including images.  
Using images is a less efficient approach - it leads to a more complex DOM structure and increased server load to retrieve media.

SmartClient's most recent builtin skins (the Flat series, comprising **Tahoe**, **Stratus**, **Twilight** and **Obsidian**), will always rely on CSS3 features for certain appearance details. If loaded in a browser with no CSS3 support (such as Internet Explorer 8), developers can expect to see some degradation in appearance (lack of certain drop-shadows, rounded edges becoming square, etc).

Three of SmartClient's other most commonly used skins, **Enterprise**, **EnterpriseBlue** and **Graphite** will conditionally make use of CSS3 features. These skins have a "CSS3 mode" in which many images required by the skin are replaced with CSS3 settings that appear nearly identical to the image-based appearance.

For these skins, CSS3 mode is automatically used in modern browsers such as Firefox, Chrome, Safari, IE 9 in standards mode, and IE 10+.  
Internet Explorer version 8 and earlier does not have sufficient CSS support to create a close match to the existing image-based skin, so CSS3 mode is not enabled by default. If CSS3 mode is manually enabled for IE when not automatically enabled, this will result in a degraded appearance that is similar across IE6, 7, and 8: rounded elements such as tabs will become square, and backgrounds will have lower quality if not disappear.

To override the default decision on whether to use CSS3 support, set the JavaScript global variable `isc_css3Mode` before any of the SmartClient libraries are loaded. For example:

```
   <script>isc_css3Mode = "on";</script>
 
```

Possible settings are:

*   "supported" :  
    _(default setting)_ CSS3 mode will be used for browsers that fully support it (including rounded edges and full gradient support)
*   "off" :  
    CSS3 mode will never be used
*   "on" :  
    CSS3 mode will be used for all browsers

For more control than the above settings provide, you can create a custom skin based on one of the above Flat skins and modify load\_skin.js - whether CSS3 mode is used is controlled by a JavaScript variable `useCSS3` defined in this file.

#### Changing Density

SmartClient provides APIs that allow the general spaciousness of an application to be increased beyond the design of the loaded skin. You can see the feature in use in our [online showcase](https:\\www.smartclient.com\showcase), by loading a sample and picking options from the `Density` picker shown above it.

The `Density` mechanism effectively zooms the application, by calling [Canvas.resizeFonts](../classes/Canvas.md#classmethod-canvasresizefonts) and [Canvas.resizeControls](../classes/Canvas.md#classmethod-canvasresizecontrols), APIs which uniformly alter the sizes of fonts in the skin's CSS-styles, and the heights of most builtin widgets, by the pixel amounts passed to them. These calls must be made after the skin is loaded, but before any components have been created.

You can apply any amounts you wish, to get your desired look - the Densities available in the online Showcases are achieved with the following calls to `resizeFonts` and `resizeControls`:

| Density | Settings |
|---|---|
| Dense | resizeFonts(0) & resizeControls(0) |
| Compact | resizeFonts(1) & resizeControls(2) |
| Medium | resizeFonts(2) & resizeControls(4) |
| Expanded | resizeFonts(2) & resizeControls(6) |
| Spacious | resizeFonts(3) & resizeControls(10) |

#### Spriting

SmartClient also makes use of a CSS technique known as "spriting" to improve performance when rendering certain user interface images. This technique improves performance when rendering a number of small images within an application. Instead of loading a separate image file for each element, this technique involves creating a single composite image file consisting of smaller images sewn together, and using css background-sizing and offset to display the desired portion of this larger image within elements on a page.

This reduces the overall file size for the media as the combined image's size will typically be significantly less than the sum of the sizes of the smaller images. It also allows the browser to issue a single HTTP request for the composite image instead of separate requests for each image element showing parts of this composite image.  
For example, the up and down arrow images of a [SpinnerItem](../classes/SpinnerItem.md#class-spinneritem) in the normal, "Focused", and "Disabled" states can be combined into one image. The file size of the combined image is typically ~65% smaller than the sum of the file sizes of the 6 constituent images, and a single HTTP request provides media for all 6 states.

Spriting typically results in reduced load times and eliminates noticeable delays in changes of component appearance while the browser downloads a required image. It is natively supported in all browsers.

One consideration when using spriting is how to handle images being rendered at different sizes on the page. Simply increasing the size of an element using CSS to display a portion of a larger background image will not change the scale of that image - instead more of the image will be revealed to the user. This can result in visual glitches, for example, the user may be able to see other sprited elements from the larger background image.  
If the "native" size of the image sprite is known as well as the desired rendered size scaling can be achieved. For SmartClient image attributes that support the special [sprited image URL](../reference.md#type-scspriteconfig) format, this can be specified, allowing the image to be rendered at various sizes.

Our `Flat series` of skins (**Tahoe**, **Stratus**, **Twilight** and **Obsidian**) make use of the sprite-URL capability to ensure that sprited images appear correctly regardless of the size at which they are being drawn.  
The **Enterprise**, **EnterpriseBlue**, and **Graphite** skins also support spriting of user interface images, but do so via settings embedded in the css applied to certain elements instead of using the sprite-URL capability. As such if certain component metrics (such as the height of a component or padding) are changed, then the image sprites may no longer work. In this case, spriting can be disabled by setting the JavaScript global variable `isc_spriting` to "off" before any of the SmartClient libraries are loaded. For example:

```
   <script>isc_spriting = "off";</script>
 
```
Possible settings are:

*   "supported" :  
    _(default setting)_ Spriting will be used in browsers that fully support it
*   "off" :  
    Spriting will not be used

**_Note - it is also possible to arrange arbitrary SVG graphics into a format which the framework can treat as a sprite_**, despite SVG not being images in the traditional sense. SVG graphics scale perfectly and, in the sprite format, can be re-used and re-colored at runtime without server trips, sizable DOM modifications or flickering. See the [SVG Symbols overview](svgSymbols.md#kb-topic-svg-symbols-overview) for more information.

#### Modifying Skins
#### Skin Editor
To create new skins and easily make bulk changes to details like colors and fonts, see our [Skin Editor](skinEditor.md#kb-topic-skin-editor) tool, which can be accessed online, or locally in your environment if you have a [Pro or better](https://www.smartclient.com/product/) license.

#### Manually
To modify a skin, first create a copy of one of the skins that comes with the SmartClient SDK, then modify the copy. Full instructions are provided in Chapter 9 of the *QuickStart Guide*.

For the most modern skins (**Tahoe**, **Stratus**, **Twilight** and **Obsidian**), the recommended approach is to use the [Skin Editor](skinEditor.md#kb-topic-skin-editor) tool, which provides UI for the majority of the skin CSS and takes advantage of the Sass templates provided with those skins. You can also manually affect the Sass templates - see the [Custom Sass Skinning](customSassSkins.md#kb-topic-customizing-sass-based-skins) discussion for more detail on leveraging that mechanism to customize a skin.

#### Locating Skinning Properties

**Starting from the name of the component**

Given a SmartClient component that you want to skin, use the search feature of the SmartClient Reference to locate it, and open the "Instance APIs" tab:

*   for properties that set CSS styles, look for properties whose name includes "style", eg [Button.baseStyle](../classes/Button.md#attr-buttonbasestyle)
*   for properties that control URLs to media, look for properties whose name includes "src", "image" or "icon", such as [Img.src](../classes/Img.md#attr-imgsrc)
*   for subcomponents that also support skinning, look for properties that are documented as being ["AutoChildren"](autoChildUsage.md#kb-topic-using-autochildren) and check the reference for the type of the AutoChild for settable properties. For example, [Window.minimizeButton](../classes/Window.md#attr-windowminimizebutton) is an ImgButton and therefore supports [ImgButton.src](../classes/ImgButton.md#attr-imgbuttonsrc).

**TIP**: the Instance APIs tab allows you to search within just the current class, limit the display to just properties or methods, and sort by type.

**Starting from a running example**

Open the Developer Console and use the Watch Tab to locate the component or subcomponent you want to skin, then locate it in the documentation, as above.

If you don't find the component in the documentation, it may be a custom component specific to your organization. To find the base SmartClient component for a component named "MyComponent", use the following code to find out the name of the superclass:

```
     isc.MyComponent.getSuperClass().getClassName()
 
```
Repeat this until you arrive at a SmartClient built-in class. You can execute this code in the "Eval JS" area of the Results pane of the Developer Console.

Specific browsers offer alternate approaches to quickly discover the images or style names being used for a part of a SmartClient component's appearance:

*   the Firefox browser offers a dialog via Tools->"Page Info" that gives a manifest of media used in the page.
*   the [Firebug](http://www.getfirebug.com/) extension for Firefox has an "Inspect" feature that allows you to see the HTML, CSS and media in use for a given area of the screen
*   right clicking (option-click on a Mac) on an image and choosing "Properties" shows a dialog that provides the image URL in most browsers. Tips:
    *   if a SmartClient component is showing text over an image, right-click at the very edge of the underlying image to get image properties rather than information about the text label
    *   on some browsers, in order to see the full image URL, you may need to drag select the partial URL of the image shown in the properties dialog

#### Image URLs in SmartClient

Properties that refer to images by URL, such as [Img.src](../classes/Img.md#attr-imgsrc) and [Button.icon](../classes/Button.md#attr-buttonicon), are specially interpreted in SmartClient to allow for simpler and more uniform image URLs, and to allow applications to be restructured more easily.

Unlike the URL used with an HTML `<IMG>` element, the image URL passed to a SmartClient component is not assumed to be relative to the current page. See [SCImgURL](../reference.md#type-scimgurl) for a full explanation of the default application image directory, and the meaning of the "\[SKIN\]" prefix.

#### Specifying Image URLs

Default image URLs for SmartClient components are specified in `load_skin.js` via JavaScript, using calls to [Class.addProperties](../classes/Class.md#classmethod-classaddproperties) and [Class.changeDefaults](../classes/Class.md#classmethod-classchangedefaults). For example, the `load_skin.js` file from the "Enterprise" skin includes the following code to establish the media used by [Window.minimizeButton](../classes/Window.md#attr-windowminimizebutton):

```
    isc.Window.changeDefaults("minimizeButtonDefaults", {
         src:"[SKIN]/Window/minimize.png"
    });
 
```

#### Specifying Image Sizes

Many SmartClient components must know some image sizes in advance, in order to allow those components to autosize to data or content.

For example, the [ImgTab](../classes/ImgTab.md#class-imgtab)s used in [TabSet](../classes/TabSet.md#class-tabset)s are capable of automatically sizing to a variable length [Tab.title](../classes/Tab.md#attr-tabtitle). To make this possible, SmartClient must know the sizes of the images used as "endcaps" on each tab in advance.

Like image URLs, image sizes are specified in `load_skin.js`. The following code sample establishes the default size of the "endcaps" for tabs, by setting a default value for [ImgTab.capSize](../classes/ImgTab.md#attr-imgtabcapsize):

```
     isc.ImgTab.addProperties({
         capSize:4
     })
 
```

#### Statefulness and Suffixes

Some components or areas within components, including buttons and the cells within a grid, are "stateful", meaning that they can be in one of a set of states each of which has a distinct visual appearance.

Stateful components switch the CSS styles or image URLs they are using as they transition from state to state, appending state information as suffixes on the style names or URL. See [Img.src](../classes/Img.md#attr-imgsrc) and [Button.baseStyle](../classes/Button.md#attr-buttonbasestyle) for details and examples.

SmartClient has built-in logic to manage a series of state transitions, such as:

*   "rollover": showing a different appearance when the mouse is over a component
*   "button down": showing a different appearance when the mouse is pressed over a component
*   "disabled": showing a different appearance when a component cannot be interacted with
*   "selected": showing one of a set of components in a different state to indicate selection

Flags on some components, such as [ImgButton.showRollOver](../classes/ImgButton.md#attr-imgbuttonshowrollover), allow you to control whether the component will switch CSS style or image URL when the component transitions into a given state.

#### StretchImg: 3-segment stretchable images

A [StretchImg](../classes/StretchImg.md#class-stretchimg) is a SmartClient component that renders out a compound image composed of 3 image files: two fixed-size end-cap images and a stretchable center segment. Like stateful components, the names of each image segment is appended to the image URL as a suffix. See [StretchImg.src](../classes/StretchImg.md#attr-stretchimgsrc) for details.

#### EdgedCanvas

Similar to a StretchImg, an [EdgedCanvas](../classes/EdgedCanvas.md#class-edgedcanvas) provides an image-based decorative edge around and/or behind another component, with up to 9 segments (a 3x3 grid). Decorative edges can be added to any component by setting [showEdges:true](../classes/Canvas.md#attr-canvasshowedges). EdgedCanvas is also used to construct drop-shadows, which can be enabled on any component via [showShadow:true](../classes/Canvas.md#attr-canvasshowshadow).

#### Multiple looks for the same component type

In some cases you need to create two variations in appearance for a component with the same behavior. For example, you may want to create a specialized Window, called "PaletteWindow", that behaves like a normal Window but has a very compact look & feel. To create a separately skinnable component for PaletteWindow, use [isc.defineClass](../classes/isc.md#staticmethod-iscdefineclass). For example:

```
    isc.defineClass("PaletteWindow", "Window");
    isc.PaletteWindow.addProperties({
        showFooter:false,
        ...
    })
 
```

#### Limitations

In most cases, using newer CSS features such as CSS3 prefix attribute selectors or CSS3 pseudo-classes in a skin will just work, provided the browser supports those CSS features. However, in some cases, SmartClient needs to be able to extract style information from CSS style declarations. For this reason, only single class name selectors are officially supported (e.g. `.myButton, .myButtonDown`) and @-rules are not supported.

---
