# FileLoader Documentation

[← Back to API Index](../reference.md)

---

## ClassAttr: FileLoader.addVersionToLoadTags

### Description
By default we add the version to the URL. Using this attribute you can turn this feature off. The parameter name used for this can be set via [versionParamName](#classattr-fileloaderversionparamname).

Note that if you are using [cache()](#classmethod-fileloadercache) to pre-cache the Smartclient framework and in your application code use manual script tags to load the framework files you will have to call [Page.setAddVersionToSkinCSS](Page.md#classmethod-pagesetaddversiontoskincss) before loading the skin in order to get the skins stylesheet to have a cache-busting parameter appended to its url.

It is recommended to use [load()](#classmethod-fileloaderload) if you plan on using [cache()](#classmethod-fileloadercache) for pre-caching as this will ensure that the loaded files and their urls will be consistent provided the FileLoader configuration is the same for both pages.

### See Also

- [FileLoader.versionParamName](#classattr-fileloaderversionparamname)
- [FileLoader.cache](#classmethod-fileloadercache)
- [FileLoader.load](#classmethod-fileloaderload)
- [Page.setAddVersionToSkinCSS](Page.md#classmethod-pagesetaddversiontoskincss)

**Flags**: RW

---
## ClassAttr: FileLoader.modulesDir

### Description
Path to module files (ISC\_Core.js et al) relative to the isomorphicDir (see [FileLoader overview](../reference_2.md#object-fileloader)).

Does not normally need to be set for SmartClient. If using Smart GWT, set to "modules/".

**Flags**: IR

---
## ClassAttr: FileLoader.defaultModules

### Description
Default list of modules for [FileLoader.load](#classmethod-fileloaderload)/[FileLoader.cache](#classmethod-fileloadercache) to use if none are provided by the user.

### See Also

- [FileLoader.cache](#classmethod-fileloadercache)
- [FileLoader.load](#classmethod-fileloaderload)

**Flags**: RW

---
## ClassAttr: FileLoader.versionParamName

### Description
Name of the query parameter to use for version-specific cache-busting. This will be used by [FileLoader.addVersionToLoadTags](#classattr-fileloaderaddversiontoloadtags).

Also remember that both [load()](#classmethod-fileloaderload) and [cache()](#classmethod-fileloadercache) uses this so if you change it for one remember to change it for the other to not get inconsistencies in the url's generated by FileLoader.

### See Also

- [FileLoader.addVersionToLoadTags](#classattr-fileloaderaddversiontoloadtags)
- [FileLoader.cache](#classmethod-fileloadercache)
- [FileLoader.load](#classmethod-fileloaderload)

**Flags**: RW

---
## ClassAttr: FileLoader.loadingIndicatorSettings

### Description
Settings to control the default appearance of the [loading indicator](#classmethod-fileloadershowloadingindicator).

The default configuration for this object has the following attribute values:

*   [image](LoadingIndicatorSettings.md#attr-loadingindicatorsettingsimage) : "\[SKIN\]loading.gif"
*   [imageWidth](LoadingIndicatorSettings.md#attr-loadingindicatorsettingsimagewidth) : 16
*   [imageHeight](LoadingIndicatorSettings.md#attr-loadingindicatorsettingsimageheight) : 16
*   [message](LoadingIndicatorSettings.md#attr-loadingindicatorsettingsmessage) : null
*   [style](LoadingIndicatorSettings.md#attr-loadingindicatorsettingsstyle) : "loadingIndicator"
*   [textStyle](LoadingIndicatorSettings.md#attr-loadingindicatorsettingstextstyle) : "loadingIndicatorText"
*   [imageStyle](LoadingIndicatorSettings.md#attr-loadingindicatorsettingsimagestyle) : "loadingIndicatorImage"
*   [zIndex](LoadingIndicatorSettings.md#attr-loadingindicatorsettingszindex) : 1000000000

To change or add attributes we recommend using [Class.changeDefaults](Class.md#classmethod-classchangedefaults). Developers may also pass an explicit [LoadingIndicatorSettings](../reference.md#object-loadingindicatorsettings) configuration object to [FileLoader.showLoadingIndicator](#classmethod-fileloadershowloadingindicator) to override these settings at runtime.

Note that the FileLoader is meant to be very tiny, so that it can be inserted into a context like a plain HTML login page and start loading SmartClient resources & your application code in the background. For this reason, the image used by this attribute does not support SVG symbols via the +link{@group:svgSymbols, SVG spriting system}, because that would require additional framework code to be loaded in advance.

However, if you want an animated SVG loadingIndicator, you can do so with a regular .svg file and some CSS to animate it. For example, you could download FontAwesome's "spinner-solid.svg" and then apply and animate it with code like this below. Note that AI systems such as ChatGPT can help with generating keyframes for different animation effects.

```
 // CSS
 .spinner {
     width: 30px;
     height: 30px;
 }

 .spinner img {
     width: 100%;
     height: 100%;
     animation: spin 2s linear infinite;
 }

 @keyframes spin {
     0% {
         transform: rotate(0deg);
     }
     100% {
         transform: rotate(360deg);
     }
 }
 
 JS
 
 // apply animated CSS style, spinner-solid.svg icon and sizes for the SVG
 isc.FileLoader.changeDefaults("loadingIndicatorSettings", {
     style: "spinner",
     image: "spinner-solid.svg",
     imageWidth: 30,
     imageHeight: 30
 });
 
 // to test
 isc.FileLoader.showLoadingIndicator();
 
```

### Groups

- loadingIndicator

**Flags**: IRWA

---
## ClassAttr: FileLoader.defaultSkin

### Description
Default skin for [FileLoader.load](#classmethod-fileloaderload)/[FileLoader.cache](#classmethod-fileloadercache) to use if one is not provided by the user.

### See Also

- [FileLoader.cache](#classmethod-fileloadercache)
- [FileLoader.load](#classmethod-fileloaderload)

**Flags**: RW

---
## ClassMethod: FileLoader.loadISC

### Description
The same as calling [FileLoader.load](#classmethod-fileloaderload), which has a slightly more convenient signature.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| skin | [String](#type-string) | true | — | The `skin` provided to [FileLoader.load](#classmethod-fileloaderload) |
| modules | [String](#type-string)|[Array](#type-array) | true | — | The `modules` provided to [FileLoader.load](#classmethod-fileloaderload) |
| onload | [String](#type-string)|[Function](#type-function) | true | — | The `onload` provided to [FileLoader.load](#classmethod-fileloaderload) |
| showLoadingIndicator | [Boolean](#type-boolean)|[LoadingIndicatorSettings](#type-loadingindicatorsettings) | true | — | The `showLoadingIndicator` provided to [FileLoader.load](#classmethod-fileloaderload) |

---
## ClassMethod: FileLoader.cacheShadows

### Description
Caches a set of shadow images at various depths. For example this code:
```
 isc.FileLoader.cacheShadows("/isomorphic/skins/SmartClient/images/shared/shadows", "5");
 
```
Will cause the following images to be cached:
```
 /isomorphic/skins/SmartClient/images/shared/shadows/ds5_TL.png
 /isomorphic/skins/SmartClient/images/shared/shadows/ds5_T.png
 /isomorphic/skins/SmartClient/images/shared/shadows/ds5_TR.png
 /isomorphic/skins/SmartClient/images/shared/shadows/ds5_L.png
 /isomorphic/skins/SmartClient/images/shared/shadows/ds5_R.png
 /isomorphic/skins/SmartClient/images/shared/shadows/ds5_BL.png
 /isomorphic/skins/SmartClient/images/shared/shadows/ds5_B.png
 /isomorphic/skins/SmartClient/images/shared/shadows/ds5_BR.png
 
```

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| baseDir | [String](#type-string) | false | — | Base directory containing the shadow images. |
| depths | [String](#type-string)|[Array](#type-array) | false | — | List of depths to load. These values corresponds to the Canvas attribute [Canvas.shadowDepth](Canvas.md#attr-canvasshadowdepth). This can either be a string with comma separated depths or an Array of depths. |
| baseShadowImage | [String](#type-string) | true | — | Name of the base shadow image from which list of URLs is generated. If not specified, this defaults to "ds.png". |
| onload | [String](#type-string)|[Function](#type-function) | true | — | Optional code to execute when the last of the specified URLs has completed caching. |

---
## ClassMethod: FileLoader.load

### Description
Loads the specified SmartClient modules and skin in defer mode. Calling this method is equivalent to using the `loadISC` JSP tag with `defer="true"`.

If SmartClient modules are already loaded they will not be loaded a second time - the onload callback will fire regardless.  
Similarly if a skin has already been loaded, a call to load() will not attempt to reload the same skin. If a new skin was specified, it will be applied over the top of the current skin, but developers should be aware this may lead to unpredictable appearance.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| onload | [String](#type-string)|[Function](#type-function) | true | — | Optional code to execute when all specified modules and skin have loaded. |
| showLoadingIndicator | [Boolean](#type-boolean)|[LoadingIndicatorSettings](#type-loadingindicatorsettings) | true | — | This parameter will cause the [loading indicator](#classmethod-fileloadershowloadingindicator) to be displayed while the load is in progress, then automatically dismissed when load completes.  
May be specified as simple boolean `true` value or a [configuration block](../reference.md#object-loadingindicatorsettings) for the loading indicator. |
| skin | [String](#type-string) | true | — | Name of the skin to load. If not specified, the skin specified by the default [FileLoader.defaultSkin](#classattr-fileloaderdefaultskin) will be used. Instead of a skin name, you can specify a skinDir - this works just like [Page.setSkinDir](Page.md#classmethod-pagesetskindir) - the skin assumed to be a skinDir if there's at least one forward slash (/) in the name.  
To suppress loading a skin, this parameter may be passed as an explicit empty string. |
| modules | [String](#type-string)|[Array](#type-array) | true | — | List of modules to load. If not specified, the list of modules specified by the default [FileLoader.defaultModules](#classattr-fileloaderdefaultmodules) will be used. You can specify modules as e.g: "Core,Foundation" or as \["Core","Foundation"\].  
Note that FileLoader does not enforce module dependencies or load order.  
If you're loading a subset of the default set of modules, ensure you include them in the order specified by [FileLoader.defaultModules](#classattr-fileloaderdefaultmodules). If you're including additional optional modules, see [loadingOptionalModules](../kb_topics/loadingOptionalModules.md#kb-topic-loading-optional-modules), for module dependencies. |

### See Also

- [FileLoader.addVersionToLoadTags](#classattr-fileloaderaddversiontoloadtags)
- [FileLoader.versionParamName](#classattr-fileloaderversionparamname)
- [Page.setAddVersionToSkinCSS](Page.md#classmethod-pagesetaddversiontoskincss)

---
## ClassMethod: FileLoader.cacheStretchImgStates

### Description
Caches a set of state stretch images derived from a base image. This is useful for caching a set of images for a single component. For example this code:
```
 isc.FileLoader.cacheStretchImgStates("/isomorphic/skins/SmartClient/images/button/button.png",
                                      "Down,Over");
 
```
Will cause the following images to be cached:
```
 /isomorphic/skins/SmartClient/images/button/button_start.png
 /isomorphic/skins/SmartClient/images/button/button_stretch.png
 /isomorphic/skins/SmartClient/images/button/button_end.png
 /isomorphic/skins/SmartClient/images/button/button_Down_start.png
 /isomorphic/skins/SmartClient/images/button/button_Down_stretch.png
 /isomorphic/skins/SmartClient/images/button/button_Down_end.png
 /isomorphic/skins/SmartClient/images/button/button_Over_start.png
 /isomorphic/skins/SmartClient/images/button/button_Over_stretch.png
 /isomorphic/skins/SmartClient/images/button/button_Over_end.png
 
```

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| baseURLs | [String](#type-string)|[Array](#type-array) | false | — | List of base image URLs from which stateful names are to be derived. This can either be a string with comma separated baseURLs or an Array of baseURLs. |
| states | [String](#type-string)|[Array](#type-array) | true | — | List of states to load. If none specified, The following default list will be used: "Down,Over,Selected,Selected\_Down,Selected\_Over". This can either be a string with comma separated states or an Array of states |
| pieces | [String](#type-string)|[Array](#type-array) | true | — | List of StretchImg pieces to cache. If not specified, the following list will be used: "start,stretch,end". This can either be a string with comma separated piece names or an Array of piece names. |
| onload | [String](#type-string)|[Function](#type-function) | true | — | Optional code to execute when the last of the specified URLs has completed caching. |

### See Also

- [FileLoader.cacheImgStates](#classmethod-fileloadercacheimgstates)

---
## ClassMethod: FileLoader.cacheFiles

### Description
Caches the specified list of files.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| URLs | [String](#type-string)|[Array](#type-array) | false | — | List of URLs to cache. These may point to image, js, or css files. This can either be a string with comma separated URLs or an Array of URLs. |
| onload | [String](#type-string)|[Function](#type-function) | true | — | Optional callback to execute when the last of the specified files has been cached. |
| type | [String](#type-string) | true | — | Specifies the type of the files referenced by the URLs. Valid values are: "js", "css", and "image". If not specified, the type is auto-derived from the file extension. If a type cannot be derived, the cache directive for that specific URL will be ignored and an error will be logged to the Developer Console. You must specify a type if you use a non-standard extension for your file - for example if you use a JSP or a servlet with no extension to generate images. |

---
## ClassMethod: FileLoader.cacheImgStates

### Description
Caches a set of state images derived from a base image. This is useful for caching a set of images for a single component. For example this code:
```
 isc.FileLoader.cacheImgStates("/isomorphic/skins/SmartClient/images/TreeGrid/opener.png",
                               "closed,opening,opened");
 
```
Will cause the following images to be cached:
```
 /isomorphic/skins/SmartClient/images/TreeGrid/opener_closed.png
 /isomorphic/skins/SmartClient/images/TreeGrid/opener_opening.png
 /isomorphic/skins/SmartClient/images/TreeGrid/opener_opened.png
 
```

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| baseURLs | [String](#type-string)|[Array](#type-array) | false | — | List of base image URLs from which stateful names are to be derived. This can either be a string with comma separated baseURLs or an Array of baseURLs. |
| states | [String](#type-string)|[Array](#type-array) | true | — | List of states to load. If none specified, The following default list will be used: "Down,Over,Selected,Selected\_Down,Selected\_Over". This can either be a string with comma separated states or an Array of states. |
| onload | [String](#type-string)|[Function](#type-function) | true | — | Optional code to execute when the last of the specified URLs has completed caching. |

### See Also

- [FileLoader.cacheStretchImgStates](#classmethod-fileloadercachestretchimgstates)

---
## ClassMethod: FileLoader.loadJSFiles

### Description
Loads the specified JS files into the context of the current page.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| URLs | [String](#type-string)|[Array](#type-array) | false | — | List of URLs pointing to JS files to load. This can either be a string with comma separated URLs or an Array of URLs. |
| onload | [String](#type-string)|[Function](#type-function) | true | — | Optional code to execute when the last of the specified URLs has completed loading. |

---
## ClassMethod: FileLoader.moduleIsLoaded

### Description
Checks to see whether a specified module has been loaded. Note that it isn't usually necessary to check before calling [load](#classmethod-fileloaderload), as load will ignore requests to load an already loaded module or skin.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| modules | [String](#type-string)|[Array of String](#type-array-of-string) | true | — | The name of module or modules to check for, with the 'ISC\_' prefix or without. Defaults to [FileLoader.defaultModules](#classattr-fileloaderdefaultmodules). |

### Returns

`[boolean](../reference.md#type-boolean)` — True when the specified modules have been loaded. False otherwise.

---
## ClassMethod: FileLoader.loadLocale

### Description
Loads the specified locale in defer mode.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| locale | [String](#type-string) | true | — | Name of the locale to load. |
| onload | [String](#type-string)|[Function](#type-function) | true | — | Optional code to execute when all specified locale has loaded. |

---
## ClassMethod: FileLoader.cacheISC

### Description
The same as calling [FileLoader.cache](#classmethod-fileloadercache), which has a slightly more convenient signature.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| skin | [String](#type-string) | true | — | The `skin` provided to [FileLoader.cache](#classmethod-fileloadercache) |
| modules | [String](#type-string)|[Array](#type-array) | true | — | The `modules` provided to [FileLoader.cache](#classmethod-fileloadercache) |
| onload | [String](#type-string)|[Function](#type-function) | true | — | The `callback` provided to [FileLoader.cache](#classmethod-fileloadercache) |

---
## ClassMethod: FileLoader.ensureLoaded

### Description
Loads the FileLoader into the page if it has not already been loaded. Whether the FileLoader is loaded or not, the callback fires.

The purpose of this method is to enable a canonical way of loading/caching code and assets. As follows:

```
 isc.FileLoader.ensureLoaded(function () {
     isc.FileLoader.loadModules(["DataBinding", "SomethingElse"]);
     isc.FileLoader.loadJSFiles("/my/precious.js", function () {
         isc.Log.logWarn("All necessary assets loaded!");
     });
 });
 
```

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| callback | [Callback](../reference.md#type-callback) | false | — | Callback to fire when FileLoader has loaded. |

---
## ClassMethod: FileLoader.loadModules

### Description
Loads the specified SmartClient modules into the context of the current page.  
This call is idempotent in that duplicate module loads are automatically suppressed (no request is issued) and your specified onload callback will still fire.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| modules | [String](#type-string)|[Array](#type-array) | false | — | List of SmartClient modules to load. This can either be a string with comma separated module names or an Array of module names. |
| onload | [String](#type-string)|[Function](#type-function) | true | — | Optional code to execute when the last of the specified modules has completed loading. |

---
## ClassMethod: FileLoader.showLoadingIndicator

### Description
Show a loading indicator on the page. This consists of an icon and an optional message in a styled, absolutely positioned element on the page.

The default configuration is set in [FileLoader.loadingIndicatorSettings](#classattr-fileloaderloadingindicatorsettings). The default image is `"loading.gif"` from the skin `images` subdirectory.

The default configuration specifies the following CSS styles:

*   "loadingIndicator" (css class applied to element as a whole)
*   "loadingIndicatorImage" (css class for the image element)
*   "loadingIndicatorText" (css class for the element containing the message)

The following default class declarations (also available as "loading.css" under the `helpers` subdirectory) use the default style names to center the image and text vertically and horizontally within the indicator's specified rect.

```
 .loadingIndicator {
     background-color:#e2e2e2;
     display:flex;
     justify-content:center;
     align-items:center;
 }
 .loadingIndicatorImage {
     padding:8px;
 }
 .loadingIndicatorText {
   color: #282828;
   font-family: calibri, Sans-Serif;
   font-size: 12px;
   padding: 8px;
 }
 
```

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| config | [LoadingIndicatorSettings](#type-loadingindicatorsettings) | true | — | Optional configuration for the loading indicator. If specified these attributes will be applied on top of the [default settings](#classattr-fileloaderloadingindicatorsettings). |

### Groups

- loadingIndicator

### See Also

- [FileLoader.loadingIndicatorSettings](#classattr-fileloaderloadingindicatorsettings)
- [FileLoader.hideLoadingIndicator](#classmethod-fileloaderhideloadingindicator)

---
## ClassMethod: FileLoader.hideLoadingIndicator

### Description
Hide the loading indicator displayed by [FileLoader.showLoadingIndicator](#classmethod-fileloadershowloadingindicator)

### Groups

- loadingIndicator

---
## ClassMethod: FileLoader.cache

### Description
Caches the specified SmartClient modules and skin. Calling this method is equivalent to using the `loadISC` JSP tag with `cacheOnly="true"`.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| onload | [String](#type-string)|[Function](#type-function) | true | — | Optional code to execute when all specified modules and skin have been cached. |
| skin | [String](#type-string) | true | — | Name of the skin to load. If not specified, the skin specified by the default [FileLoader.defaultSkin](#classattr-fileloaderdefaultskin) will be used. Instead of a skin name, you can specify a skinDir - this works just like [Page.setSkinDir](Page.md#classmethod-pagesetskindir) - the skin assumed to be a skinDir if there's at least one forward slash (/) in the name. |
| modules | [String](#type-string)|[List](#type-list) | true | — | List of modules to load. If not specified, the list of modules specified by the default [FileLoader.defaultModules](#classattr-fileloaderdefaultmodules) will be used. You can specify modules as "Core,Foundation" or as \["Core", "Foundation"\] |

### See Also

- [FileLoader.addVersionToLoadTags](#classattr-fileloaderaddversiontoloadtags)
- [FileLoader.versionParamName](#classattr-fileloaderversionparamname)
- [Page.setAddVersionToSkinCSS](Page.md#classmethod-pagesetaddversiontoskincss)

---
## ClassMethod: FileLoader.cacheLocale

### Description
Caches the specified locale.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| locale | [String](#type-string) | true | — | Name of the locale to cache.. |
| onload | [String](#type-string)|[Function](#type-function) | true | — | Optional code to execute when all specified locale has been cached.. |

---
## ClassMethod: FileLoader.cacheModules

### Description
Caches the specified SmartClient modules.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| modules | [String](#type-string)|[Array](#type-array) | false | — | List of SmartClient modules to cache. This can either be a string with comma separated module names or an Array of module names. |
| onload | [String](#type-string)|[Function](#type-function) | true | — | Optional code to execute when the last of the specified modules has been cached. |

---
## ClassMethod: FileLoader.cacheEdgeImages

### Description
Caches a set of edge images derived from a base image. For example this code:
```
 isc.FileLoader.cacheEdgeImages("/isomorphic/skins/SmartClient/images/edges/rounded/frame/A3B2CC/6.png");
 
```
Will cause the following images to be cached:
```
 /isomorphic/skins/SmartClient/images/edges/rounded/frame/A3B2CC/6_TL.png
 /isomorphic/skins/SmartClient/images/edges/rounded/frame/A3B2CC/6_T.png
 /isomorphic/skins/SmartClient/images/edges/rounded/frame/A3B2CC/6_TR.png
 /isomorphic/skins/SmartClient/images/edges/rounded/frame/A3B2CC/6_L.png
 /isomorphic/skins/SmartClient/images/edges/rounded/frame/A3B2CC/6_R.png
 /isomorphic/skins/SmartClient/images/edges/rounded/frame/A3B2CC/6_BL.png
 /isomorphic/skins/SmartClient/images/edges/rounded/frame/A3B2CC/6_B.png
 /isomorphic/skins/SmartClient/images/edges/rounded/frame/A3B2CC/6_BR.png
 
```

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| baseURLs | [String](#type-string)|[Array](#type-array) | false | — | List of base image URLs from which position-specific edge names are to be derived. This can either be a string with comma separated baseURLs or an Array of baseURLs. |
| showCenter | [Boolean](#type-boolean) | true | — | If true, also causes the center image to be cached. Default is false. |
| edges | [String](#type-string)|[Array](#type-array) | true | — | List of edges to load. If none specified, The following default list will be used: "TL,T,TR,L,R,BL,B,BR". The list of valid values is the set of extensions specified by [EdgedCanvas.edgeImage](EdgedCanvas.md#attr-edgedcanvasedgeimage). This can either be a string with comma separated edge extension or an Array of edge extensions. |
| colors | [String](#type-string)|[Array](#type-array) | true | — | List of colors to cache. If not specified, no color is specified. The list of valid colors are those that you have specified as [EdgedCanvas.edgeColor](EdgedCanvas.md#attr-edgedcanvasedgecolor). This can either be a string with comma separated colors or an Array of colors. |
| onload | [String](#type-string)|[Function](#type-function) | true | — | Optional code to execute when the last of the specified URLs has completed caching. |

---
