var addDemographicsButton,
    aiDemographicsFieldName = "aiDemographics",
    addReligionsButton,
    aiReligionsFieldName = "aiReligions",
    addLandmarkButton,
    aiLandmarkFieldName = "aiLandmark";

var grid = isc.ListGrid.create({
    autoDraw: false,
    width: "100%", height: "100%",
    dataSource: "worldDS",
    fields:[
        {name:"countryCode", title:"Code", width:70},
        {name:"countryName", width:235},
        {name:"independence", title:"Nationhood", width:125},
        {name:"population", width:125},
        {name:"gdp", width:125}
    ],
    initialCriteria: {
        "continent": "South America"
    },
    initialSort: [{
        property: "countryName",
        direction: "ascending"
    }],
    autoFetchData: true, dataFetchMode: "paged",
    autoFitData: "horizontal",
    autoFitWidthApproach: "both",
    minFieldWidth: 70,
    wrapCells: true,
    fixedRecordHeights: false,

    canAddAISummaryFields: true,

    // To display the hover when an AI-generated field's value is being computed, or an error
    // occurs during that asynchronous computation, we need canHover:true and showHover:true.
    canHover: true,
    showHover: true,
    showClippedValuesOnHover: true,
    cellHover : function (record, rowNum, colNum) {
        if (this.cellValueIsClipped(rowNum, colNum)) return;
        var field = this.getField(colNum);
        if (this.isValuePendingAsyncOrAsyncError(record, field)) return;
        return false;
    },
    cellHoverHTML : function (record, rowNum, colNum) {
        var field = this.getField(colNum);
        // Customize the hover contents if the value for a cell is being computed.
        if (this.isValuePendingAsync(record, field)) {
            return "This value for " + record.countryName + " is being computed.";
        }
        // Otherwise (if an error occurred trying to calculate a value, or a value is clipped)
        // defer to the standard cellHoverHTML() implementation.
        return this.Super("cellHoverHTML", arguments);
    },

    userRemovedField : function (field) {
        if (field.name == aiDemographicsFieldName) {
            addDemographicsButton.enable();
        } else if (field.name == aiReligionsFieldName) {
            addReligionsButton.enable();
        } else if (field.name == aiLandmarkFieldName) {
            addLandmarkButton.enable();
        }
        // The "Custom Prompt" button is always enabled.
    }
});

function addAISummaryField(fieldProps, aiFieldPrompt, listGrid) {
    var fields = listGrid.getFields();
    // Duplicate the array because the result of getFields() must be treated as read-only.
    fields = fields.duplicate();

    var existingIndex = fields.findIndex("name", fieldProps.name);
    if (existingIndex >= 0) fields.removeAt(existingIndex);

    fieldProps = isc.addProperties({
        width: 180,
        wrap: true,
        showHover: true
    }, fieldProps);
    fieldProps.aiFieldPrompt = aiFieldPrompt;
    fields.addAt(fieldProps, existingIndex < 0 ? fields.length : existingIndex);
    listGrid.setFields(fields);
}



var buttonsLayout = isc.HStack.create({
    autoDraw: false,
    height: "*",
    membersMargin: 8,
    members: [
        addDemographicsButton = isc.Button.create({
            autoDraw: false,
            autoFit: true,
            title: "Add Demographics",
            prompt: "A 2-4 sentence demographic and economic description of the country",
            click : function () {
                addAISummaryField({name:aiDemographicsFieldName, title:"Demographics Summary", width:"*", minWidth: 300},
                                  this.prompt, grid);
                this.disable();
            }
        }),
        addReligionsButton = isc.Button.create({
            autoDraw: false,
            autoFit: true,
            title: "Add Religions",
            prompt: "Most common religions, as a comma-separated list",
            click : function () {
                addAISummaryField({name:aiReligionsFieldName, title:"Common Religions"},
                                  this.prompt, grid);
                this.disable();
            }
        }),
        addLandmarkButton = isc.Button.create({
            autoDraw: false,
            autoFit: true,
            title: "Add Landmark",
            prompt: "Most famous landmark",
            click : function () {
                addAISummaryField({name:aiLandmarkFieldName, title:"Famous Landmark"},
                                  this.prompt, grid);
                this.disable();
            }
        }),
        isc.IButton.create({
          title:"Custom Prompt",
          click: function () {
              grid.addAISummaryField();
          }
        })
    ]
});

isc.VLayout.create({
    width: "100%", height: "100%",
    membersMargin: 15,
    members: [
        isc.DynamicForm.create({
            ID: "form",
            width: 600,
            items: [
                {
                    name: "dsSelector",
                    editorType: "SelectItem",
                    required: true,
                    title: "DataSource",
                    valueMap: ["UserIssues","ScienceStudies","worldDS"],
                    defaultValue: "UserIssues",
                    changed : function (form, item, value) {
                        if (value == "UserIssues") {
                            scienceStudiesLayout.hide();
                            userIssuesLayout.show();
                            worldLayout.hide();
                        } else if (value == "ScienceStudies") {
                            scienceStudiesLayout.show();
                            userIssuesLayout.hide();
                            worldLayout.hide();
                        } else {
                            scienceStudiesLayout.hide();
                            userIssuesLayout.hide();
                            worldLayout.show();
                        }
                    }
                }
           ]
        }),
        isc.VLayout.create({
            ID: "scienceStudiesLayout",
            width: "100%",
            height: "100%",
            membersMargin: 10,
            visibility: "hidden",
            members: [
                isc.HLayout.create({
                    ID: "buttonLayoutScience",
                    width: "*",
                    members: [
                      isc.IButton.create({
                          title: "Sort by Relevance to IV Pump Safety",
                          width: 260,
                          prompt: "Read each Abstract and assign it an importance score from 1 (least) to 10 (most) based on its relevance to IV Pump Safety",
                          click : function () {
                              addAISummaryField({name: "relevance", title: "Relevance", width: 175, type: "integer"}, 
                                                        this.prompt, lgScienceStudies);

                              lgScienceStudies.setSort([{
                                  property: "relevance",
                                  direction: "descending"
                              }, {
                                  property: "Study_ID",
                                  direction: "ascending"
                              }]);
                          }
                      }),
                      isc.IButton.create({
                        title:"Custom Prompt",
                        click: function () {
                            lgScienceStudies.addAISummaryField();
                        }
                      })
                    ],
                    membersMargin: 10
                }),
                isc.ListGrid.create({
                    ID: "lgScienceStudies",
                    width: "100%", height: "100%",
                    dataSource: "ScienceStudies", 
                    autoFetchData: true,
                    sortViaAIMode: "hybrid",
                    fields: [
                        {name:"Study_ID", width:150},
                        {name:"Title", width:150, showHover:true, hoverWidth:300},
                        {name:"Authors", width:150},
                        {name:"Journal", width:150},
                        {name:"Year", width:150},
                        {name:"Abstract", width:"*", showHover:true, hoverWidth:500}
                    ],
                    canAddAISummaryFields: true
                })
            ]
        }),
        isc.VLayout.create({
            ID: "userIssuesLayout",
            width: "100%", height: "100%",
            membersMargin: 15,
            members: [
                isc.HLayout.create({
                    ID: "buttonLayout",
                    width: "*",
                    members: [
                        isc.IButton.create({
                            title: "Urgency",
                            prompt: "Assess the urgency to the Department of the reported issue",
                            width: 150,
                            click : function () {
                                addAISummaryField({name: "urgencyLevel", title: "Urgency Level", width: 175},
                                                  this.prompt, lgIssues);

                                lgIssues.setSort([{
                                    property: "urgencyLevel",
                                    direction: "ascending"
                                }, {
                                    property: "Issue_ID",
                                    direction: "ascending"
                                }]);
                            }
                        }),
                        isc.IButton.create({
                            title: "Impact",
                            width: 150,
                            prompt: "Select the issue category based on its impact: Critical (threatens core functions/safety), High (major disruptions needing immediate attention), Moderate (manageable disruptions), or Low (minimal effect on operations)",
                            click : function () {
                                addAISummaryField({name: "impactLevel", title: "Impact Level", width: 175}, 
                                                  this.prompt, lgIssues);

                                lgIssues.setSort([{
                                    property: "impactLevel",
                                    direction: "ascending"
                                }, {
                                    property: "Issue_ID",
                                    direction: "ascending"
                                }]);
                            }
                        }),
                        isc.IButton.create({
                          title:"Custom Prompt",
                          click: function () {
                              lgIssues.addAISummaryField();
                          }
                        })
                    ],
                    membersMargin: 10
                }),
                isc.ListGrid.create({
                    ID: "lgIssues",
                    width: "100%", height: "100%",
                    dataSource: "UserIssues", 
                    autoFetchData: true,
                    fields: [
                        {name:"Issue_ID", width:235},
                        {name:"Reported_By", width:125},
                        {name:"Department", width:235},
                        {name:"Category", width:235},
                        {name:"Issue_Description", width:235}
                    ],
                    sortViaAIMode: "hybrid",
                    canAddAISummaryFields: true
                })
            ]
        }),
        isc.VLayout.create({
            ID: "worldLayout",
            visibility: "hidden",
            width: "100%",
            height: "100%",
            membersMargin: 10,
            members: [buttonsLayout, grid]
        })
    ]
});






if (isc.AI._spoofedAIGeneratedFieldsAIDEResponses) isc.AI.removeSpoofedResponses(isc.AI._spoofedAIGeneratedFieldsAIDEResponses);
isc.AI.addSpoofedResponses(isc.AI._spoofedAIGeneratedFieldsAIDEResponses = [{
    matchesPrompt : function (prompt) {
        return prompt.contains("a request to supplement the data in records from a DataSource") &&
                prompt.contains("data-record index") &&
                /The supplemental information requested for each record is:\s+most famous landmark\s+The records specified below are from the DataSource with the following description:/i.test(prompt);
    },
    makeAIResponse : function (aiRequest, aiEngine) {
        var mostFamousLandmarksByCountryName = {
            "Argentina": "Obelisco de Buenos Aires",
            "Bolivia": "Salar de Uyuni",
            "Brazil": "Christ the Redeemer",
            "Chile": "Easter Island",
            "Colombia": "The Gold Museum",
            "Ecuador": "The Middle of the World Monument",
            "Guyana": "Kaieteur Falls",
            "Paraguay": "The Grand Chaco",
            "Peru": "Machu Picchu",
            "Suriname": "The Saint Peter and Paul Cathedral",
            "Uruguay": "Montevideo Metropolitan Cathedral",
            "Venezuela": "Angel Falls"
        };

        var prompt = aiEngine.makePromptText(aiRequest),
            records = isc.AI._extractJsonResult(prompt, "[", "]"),
            results = [];
        for (var i = 0; i < records.length; ++i) {
            var record = records[i];
            results.push(mostFamousLandmarksByCountryName[record["countryName"]]);
        }
        return {
            type: "success",
            message: {content: {result: results}}
        };
    }
}, {
    matchesPrompt : function (prompt) {
        return prompt.contains("This is a request to gather information about a request to supplement") &&
                /The supplemental data requested for each record is:\s*<supplemental-data-description>\s*most populous city\s*<\/supplemental-data-description>\s*Note: In the supplemental-data-description, ignore directions to/i.test(prompt);
    },
    value: {
        valueClass: "general",
        relevantFieldNames: ["countryName"]
    }
}, {
    matchesPrompt : function (prompt) {
        return prompt.contains("a request to supplement the data in records from a DataSource") &&
                prompt.contains("data-record index") &&
                /The supplemental information requested for each record is:\s+most populous city\s+The records specified below are from the DataSource with the following description:/i.test(prompt);
    },
    makeAIResponse : function (aiRequest, aiEngine) {
        var mostPopulousCityByCountryName = {
            "Argentina": "Buenos Aires",
            "Bolivia": "La Paz",
            "Brazil": "São Paulo",
            "Chile": "Santiago",
            "Colombia": "Bogotá",
            "Ecuador": "Quito",
            "Guyana": "Georgetown",
            "Paraguay": "Asunción",
            "Peru": "Lima",
            "Suriname": "Paramaribo",
            "Uruguay": "Montevideo",
            "Venezuela": "Caracas"
        };

        var prompt = aiEngine.makePromptText(aiRequest),
            records = isc.AI._extractJsonResult(prompt, "[", "]"),
            results = [];
        for (var i = 0; i < records.length; ++i) {
            var record = records[i];
            results.push(mostPopulousCityByCountryName[record["countryName"]]);
        }
        return {
            type: "success",
            message: {content: {result: results}}
        };
    }
}]);

