/*

  SmartClient Ajax RIA system
  Version SNAPSHOT_v15.0d_2025-12-01/EVAL Deployment (2025-12-01)

  Copyright 2000 and beyond Isomorphic Software, Inc. All rights reserved.
  "SmartClient" is a trademark of Isomorphic Software, Inc.

  LICENSE NOTICE
     INSTALLATION OR USE OF THIS SOFTWARE INDICATES YOUR ACCEPTANCE OF
     ISOMORPHIC SOFTWARE LICENSE TERMS. If you have received this file
     without an accompanying Isomorphic Software license file, please
     contact licensing@isomorphic.com for details. Unauthorized copying and
     use of this software is a violation of international copyright law.

  DEVELOPMENT ONLY - DO NOT DEPLOY
     This software is provided for evaluation, training, and development
     purposes only. It may include supplementary components that are not
     licensed for deployment. The separate DEPLOY package for this release
     contains SmartClient components that are licensed for deployment.

  PROPRIETARY & PROTECTED MATERIAL
     This software contains proprietary materials that are protected by
     contract and intellectual property law. You are expressly prohibited
     from attempting to reverse engineer this software or modify this
     software for human readability.

  CONTACT ISOMORPHIC
     For more information regarding license rights and restrictions, or to
     report possible license violations, please contact Isomorphic Software
     by email (licensing@isomorphic.com) or web (www.isomorphic.com).

*/

if(window.isc&&window.isc.module_Core&&!window.isc.module_AI){isc.module_AI=1;isc._moduleStart=isc._AI_start=(isc.timestamp?isc.timestamp():new Date().getTime());if(isc._moduleEnd&&(!isc.Log||(isc.Log && isc.Log.logIsDebugEnabled('loadTime')))){isc._pTM={ message:'AI load/parse time: ' + (isc._moduleStart-isc._moduleEnd) + 'ms', category:'loadTime'};
if(isc.Log && isc.Log.logDebug)isc.Log.logDebug(isc._pTM.message,'loadTime');
else if(isc._preLog)isc._preLog[isc._preLog.length]=isc._pTM;
else isc._preLog=[isc._pTM]}isc.definingFramework=true;isc.helpDocuments=isc.helpDocuments||{};
isc.aiHelpDocuments=isc.aiHelpDocuments||(isc.Browser._supportsObjectCreate?Object.create(isc.helpDocuments):{});
isc.registerHelpDocument=function(ID,partialHelpDocument,helpDocumentRegistry){
    if(!helpDocumentRegistry)helpDocumentRegistry=isc.helpDocuments;
    if(ID in helpDocumentRegistry){
        return;
    }
    var helpDocument=isc.addPropertiesWithAssign({ID:ID},partialHelpDocument);
    helpDocumentRegistry[ID]=helpDocument;
    if(!isc.Browser._supportsObjectCreate){
        if(helpDocumentRegistry===isc.helpDocuments&&
            !Object.hasOwn(isc.aiHelpDocuments,ID))
        {
            isc.aiHelpDocuments[ID]=helpDocument;
        }
    }
};
isc.registerHelpDocuments=function(partialHelpDocumentByID,helpDocumentRegistry){
    for(var ID in partialHelpDocumentByID){
        var partialHelpDocument=partialHelpDocumentByID[ID];
        if(!isc.isAn.Object(partialHelpDocument)||!("content"in partialHelpDocument)){
            continue;
        }
        isc.registerHelpDocument(ID,partialHelpDocument,helpDocumentRegistry);
    }
};
isc.defineClass("HelpDocumentRegistryUtil");
isc.A=isc.HelpDocumentRegistryUtil;
isc.B=isc._allFuncs;
isc.C=isc.B._maxIndex;
isc.D=isc._funcClasses;
isc.D[isc.C]=isc.A.Class;
isc.B.push(isc.A.collectHelpDocuments=function isc_c_HelpDocumentRegistryUtil_collectHelpDocuments(ID,helpDocumentRegistry,_helpDocuments,__dependentHelpDocument){
        if(!helpDocumentRegistry)helpDocumentRegistry=isc.helpDocuments;
        var helpDocument=helpDocumentRegistry[ID];
        if(helpDocument&&(!_helpDocuments||!_helpDocuments.contains(helpDocument))){
            if(!_helpDocuments){
                _helpDocuments=[helpDocument];
            }else{
                _helpDocuments.addAt(helpDocument,_helpDocuments.indexOf(__dependentHelpDocument));
            }
            var dependencies=helpDocument.dependencies;
            if(dependencies){
                if(!isc.isAn.Array(dependencies))dependencies=[dependencies];
                for(var i=0;i<dependencies.length;++i){
                    var dep=dependencies[i];
                    this.collectHelpDocuments(dep,helpDocumentRegistry,_helpDocuments,helpDocument);
                }
            }
        }
        return _helpDocuments;
    }
);
isc.B._maxIndex=isc.C+1;

isc.registerHelpDocuments({
    "JavaScript":{
        topic:"JavaScript",
        content:
            "When generating JavaScript source code, assume that the JavaScript interpreter "+
            "only supports ECMAScript 5. Do not use newer language features such as:\n"+
            "* `let` or `const`\n"+
            "* arrow, async, or generator functions\n"+
            "* ES6 classes or modules\n"+
            "* spread, exponentiation, or nullish coalescing operators\n"+
            "* `for`...`of`\n"+
            "* Promises\n"+
            "\n"+
            "Treat \"let\", \"const\", \"catch\", and \"finally\" as invalid JavaScript identifiers.\n"+
            "\n"+
            "Furthermore, assume that the code will run in a very basic web browser environment "+
            "that only supports HTML 4.",
        format:"Markdown"
    },
    "ComponentActions":{
        topic:"Component Actions",
        content:
            "A Component Action declaratively represents an action to take, typically a method invocation on a target.\n"+
            "\n"+
            "## Single method invocation\n"+
            "Invocation of a single method may be represented with an object containing the following properties:\n"+
            "* \"target\" (string): The name of a component in the current UI to invoke a method on.\n"+
            "* \"name\" (string): The name of the method to invoke.\n"+
            "\n"+
            "For these actions, arguments to the method you specify,if any, will be added later.\n\n"+
            "Example 1: grid1 can show it's records in a separate form1 when grid-records are clicked by "+
            "setting the grid's recordClick event to this action:\n"+
            "```\n{\n"+
            "  \"target\": \"form1\",\n"+
            "  \"name\": \"editSelectedData\"\n"+
            "}\n```\n",
        format:"Markdown"
    },
    "class:Canvas:eventMethods":{
        topic:"Canvas events",
        content:
            "The following event methods are available on the Canvas class, as well as the classes that extend Canvas:\n"+
            "\n"+
            "## Mouse-related events\n"+
            "\n"+
            "* \"mouseOver\": Fired when the mouse enters the component.\n"+
            "* \"mouseOut\": Fired when the mouse leaves the component.\n"+
            "* \"mouseMove\": Fired when the mouse moves within the component.\n"+
            "* \"mouseDown\": Fired when the left mouse button is pressed on the component.\n"+
            "* \"mouseStillDown\": Repeating notification method for the left mouse button being held down on the component.\n"+
            "* \"mouseUp\": Fired when the left mouse button is released on the component.\n"+
            "* \"click\": Fired when the left mouse button is clicked (pressed and then released) on the component.\n"+
            "* \"doubleClick\": Fired when the left mouse button is clicked twice in rapid succession (within \"doubleClickDelay\" by default) on the component.\n"+
            "* \"rightMouseDown\": Fired when the right mouse button is pressed on the component.\n"+
            "* \"showContextMenu\": Fired when the right mouse button is clicked on the component.\n"+
            "* \"mouseWheel\": Fired when the mouse wheel is actuated on the component.\n"+
            "\n"+
            "## Drag-and-drop-related events\n"+
            "\n"+
            "* \"dragStart\"\n"+
            "* \"dragMove\"\n"+
            "* \"dragStop\"\n"+
            "* \"dragRepositionStart\"\n"+
            "* \"dragRepositionMove\"\n"+
            "* \"dragRepositionStop\"\n"+
            "* \"dragResizeStart\"\n"+
            "* \"dragResizeMove\"\n"+
            "* \"dragResizeStop\"\n"+
            "* \"willAcceptDrop\"\n"+
            "* \"dropOver\"\n"+
            "* \"dropOut\"\n"+
            "* \"dropMove\"\n"+
            "* \"drop\"\n"+
            "\n"+
            "## Keyboard-related events\n"+
            "\n"+
            "* \"keyDown\": Fired when a key is pressed while the component has keyboard focus.\n"+
            "* \"keyUp\": Fired when a key is released while the component has keyboard focus.\n"+
            "* \"keyPress\": Fired when a key is pressed and then released while the component has keyboard focus.\n"+
            "\n"+
            "## Miscellaneous events\n"+
            "\n"+
            "* \"initComplete\": Fired after initWidget(), when initialization of the component is complete.\n"+
            "* \"drawn\": Fired when the component has been drawn into the page.\n"+
            "* \"focusChanged\": Fired when the component receives or loses keyboard focus.\n"+
            "* \"visibilityChanged\": Fired when the component becomes visible or hidden.\n"+
            "* \"hover\": Fired when the mouse is hovered over the component.\n"+
            "* \"hoverHidden\": Fired whenever the hover shown in response to handleHover() is hidden.\n"+
            "* \"parentMoved\": Fired when an ancestor-of-the-component's position changes.\n"+
            "* \"parentResized\": Fired when the interior size of the parent changes.\n"+
            "* \"resized\": Fired when the component's size changes.\n"+
            "* \"scrolled\": Fired when the component is scrolled.\n"+
            "* \"ruleContextChanged\"",
        format:"Markdown"
    },
    "interface:DataBoundComponent":{
        topic:"DataBoundComponent interface",
        content:
            "DataBoundComponent is an interface implemented by several UI components that connects (or \"binds\") the component to a data source, to load, display, and update data—one or more records—in the data source automatically. Examples include grids (ListGrid), forms (DynamicForm), trees (TreeGrid), and charts (FacetChart). It handles the basic responsibilities of fetching data, tracking changes, and saving edits back to the server for the components that implement the interface.\n"+
            "\n"+
            "## Fields\n"+
            "The \"fields\" attribute of a DBC is an array of DBCField objects that specifies which properties of records to present, in what order, and how each field should behave and look in the DBC. The basic DBCField attributes are:\n"+
            "* \"name\" (string): Name of the field. Typically, this is the name of a field of the data source. The name must be unique within the DBC as well as a valid JavaScript identifier.\n"+
            "* \"title\" (HTML string): A displayable title for the field.\n"+
            "* \"type\" (string): Type of the field.\n"+
            "* \"multiple\" (boolean): If set to `true`, then the field is array-valued.\n"+
            "* \"required\" (boolean): If set to `true`, then records are required to have a value for the field.\n"+
            "\n"+
            "Depending on the specific DBC (like ListGrid, DynamicForm, etc.), there are additional field attributes (e.g., validators, picklists, icons) to further configure the behavior and appearance of the field in the DBC.\n"+
            "\n"+
            "When both \"fields\" and \"dataSource\" are set on the DBC, any fields in \"fields\" with the same name as a data source field inherit the properties of the corresponding DataSourceField object. This allows you to centralize data model information in the data source, but customize the presentation and order of data source fields on a per-component basis.\n"+
            "\n"+
            "By default, only fields mentioned in \"fields\" are presented in the DBC. The \"useAllDataSourceFields\" attribute of the DBC can be set to `true` to present all fields from the data source, with the DBC's \"fields\" acting as field-by-field overrides and/or additional fields.\n"+
            "\n"+
            "If \"dataSource\" is set on the DBC, but not \"fields\", then all of the data source's fields become fields of the DBC.\n"+
            "\n"+
            "After a DBC has been created, the setFields([newFields]) method may be called to change the DBC's fields. If `newFields` is not specified or null, then the DBC will use the data source fields. Otherwise, the DBC is substantially rebuilt as if it were created with \"fields\" set to `newFields`.\n"+
            "\n"+
            "Once a DBCField object has been set as a field on a DBC, it is invalid to modify the object's attributes directly, unless the attribute is specifically marked as writable. Instead, use setters on the DBC if available to change the field attribute or create a new DBCField object and update the component's fields (via setFields()) with the new DBCField object replacing the old one.\n"+
            "\n"+
            "## Data source & fetching data\n"+
            "\n"+
            "### Attributes\n"+
            "* \"dataSource\" (string): The ID of the data source to bind to.\n"+
            "* \"autoFetchData\" (boolean): If set to `true`, the DBC will perform a one-time fetch of data from the data source to display in the component.\n"+
            "* \"fetchRequestProperties\" (DSRequest properties): If \"autoFetchData\" is `true`, an object containing properties for the one-time DSRequest to fetch the initial data.\n"+
            "* \"implicitCriteria\" (AdvancedCriteria object): Criteria that are never shown to or edited by the user and are cumulative with any criteria provided by the user or \"initialCriteria\".\n"+
            "* \"initialCriteria\" (AdvancedCriteria object): Initial criteria for the DBC. Typically, the user has the ability to modify this, to customize what data is displayed.\n"+
            "\n"+
            "### Methods\n"+
            "* setData([newData]): Sets the data to be displayed in the DBC.\n"+
            "* setDataSource([newDataSource, fields]): If `newDataSource` is null, then unbinds the DBC from its existing data source. Otherwise, if the DBC is bound to a different data source, then the DBC is bound to the new data source. Any existing data and fields are discarded, and `fields` is used as the DBC's new fields.\n"+
            "* fetchData([criteria, callback, requestProperties]): Fetches data from the data source. If data has not already been provided via setData(), this method will create a ResultSet and use it from then on.\n"+
            "* setImplicitCriteria([newImplicitCriteria, callback, initialFetch]): Sets the DBC's \"implicitCriteria\".\n"+
            "\n"+
            "## Sorting\n"+
            "The \"initialSort\" attribute (array of SortSpecifier objects) specifies the initial sort configuration.\n"+
            "getSort() may be used to obtain a copy of the DBC's current sort configuration.\n"+
            "setSort([newSortSpecifiers]) may be used to set the DBC's sort configuration.\n"+
            "\n"+
            "## Additional notes\n"+
            "By default, a DBC will not fetch any data from the data source; the DBC will display no data until fetchData() is called to request data from the data source, or until setData() is called to set the data to display in the DBC. Usually, \"autoFetchData\" should be set to `true`, unless there is a specific reason not to display any data initially, such as:\n"+
            "- If the component is primarily (or at least initially) for editing new data.\n"+
            "- The component is there to accept records dropped onto it from other DBCs.\n"+
            "- If the component displays or edits data related to the user's selection of record(s) in another DBC.",
        format:"Markdown",
        dependencies:["object:AdvancedCriteria"]
    },
    "class:DynamicForm":{
        topic:"DynamicForm class",
        content:
            "DynamicForm is a DataBoundComponent that displays a form for viewing and editing the properties of a single record. It can bind to a data source to automatically load, display, validate, and save data. DynamicForms are commonly used for data entry, editing existing records, filtering data in grids, and displaying record details.\n"+
            "\n"+
            "DynamicForm handles generating and laying out form controls (form items) based on the fields it is configured with. It also provides extensive support for dynamic behavior, such as showing or hiding fields and enabling/disabling controls.\n"+
            "\n"+
            "## Fields/Items\n"+
            "The \"fields\" attribute of a DynamicForm is an array of FormItem configuration objects. Each object specifies a single input control in the form. Basic FormItem attributes include:\n"+
            "* \"name\" (string): Name of the field. This typically corresponds to the name of a field in the data source.\n"+
            "* \"title\" (HTML string): Label text for the form item.\n"+
            "* \"showTitle\" (boolean): Whether a title cell should be shown for the form item.\n"+
            "* \"hint\" (HTML string): String to show next to the form item to indicate something to the user. This string generally appears to the right of the form item.\n"+
            "* \"type\" (string): The type of data-value edited by the form item.\n"+
            "* \"editorType\" (string): The name of the FormItem class to use (e.g. TextItem or SelectItem). If not specified, then this is derived automatically from the field \"type\".\n"+
            "* \"canEdit\" (boolean): Is the form item editable (\"canEdit\":`true`) or read-only (\"canEdit\":`false`)?\n"+
            "* \"required\" (boolean): If set to `true`, then a value for the form item is required.\n"+
            "* \"requiredWhen\" (AdvancedCriteria object): Criteria to be evaluated to determine whether the form item should be required.\n"+
            "* \"defaultValue\": The data-value to use when no value is provided for the form item.\n"+
            "* \"valueMap\" (object | array of HTML string): A map from the data-value that is stored in the record to the HTML display-value that is shown to the user. If \"valueMap\" is an array, then the data-values are the integer indices into the array.\n"+
            "* \"shouldSaveValue\" (boolean): Should the form item's value be saved in the form's values? \"shouldSaveValue\":`false` is used to mark form items which do not correspond to the underlying data model. Examples include: visual separators, password re-type fields, and checkboxes used to show/hide other form items.\n"+
            "* \"validators\" (array of Validator properties): Validators for the form item. Note: These validators will only be run on the client. To do server-enforced validation, validators must be specified via the DataSourceField's \"validators\".\n"+
            "* \"showErrorIcon\" (boolean): Should an error icon appear next to next to the form item if there is a validation error?\n"+
            "* \"showErrorText\" (boolean): If there is a validation error, should the validation error message be displayed next to the form item?\n"+
            "\n"+
            "Like other DataBoundComponents, if you specify \"fields\" together with \"dataSource\", fields with matching names inherit data source field attributes. If \"fields\" is omitted, the form will use all fields from the data source by default. To include all data source fields but customize some fields selectively, set \"useAllDataSourceFields\" to `true`.\n"+
            "\n"+
            "After creation, the form's fields can be reconfigured using setFields([newFields]).\n"+
            "\n"+
            "FormItem lifecycle is managed by the DynamicForm itself. FormItem instances are created and destroyed automatically when new fields are added to the form.\n"+
            "\n"+
            "### SelectItem and ComboBoxItem\n"+
            "DynamicForm provides specialized FormItems for selecting values from a list: SelectItem and ComboBoxItem. These components present drop-down picklists, but they differ slightly in behavior and configuration options.\n"+
            "\n"+
            "SelectItem displays a static list of options in a drop-down. The user must pick from the list (no freeform entry).\n"+
            "\n"+
            "ComboBoxItem combines a picklist with freeform text entry, allowing the user to either pick an option or type their own value. It is commonly used when there are many possible values or when users might enter new ones.\n"+
            "\n"+
            "#### Notes on \"valueMap\" vs. \"optionDataSource\"\n"+
            "* \"valueMap\" provides a simple, static list of options embedded in the form item configuration.\n"+
            "* \"optionDataSource\" allows the picklist to be populated dynamically from the specified data source.\n"+
            "* When \"optionDataSource\" is set, the ComboBoxItem (or SelectItem) automatically issues fetch requests to load matching options as the user types (or when the control is opened).\n"+
            "* For best results, specify \"displayField\" and \"valueField\" to control what is shown (display-value) vs. stored (data-value).\n"+
            "\n"+
            "## Layout and appearance\n"+
            "DynamicForm provides a flexible layout engine for arranging form controls in a grid-like structure. The overall layout is determined by properties set on the DynamicForm itself, while individual field placement and sizing are configured via attributes on each FormItem.\n"+
            "\n"+
            "### DynamicForm-level layout attributes\n"+
            "These attributes control the form's general structure and layout behavior:\n"+
            "* \"numCols\" (integer): The number of columns in the form's grid layout. Default is 2. FormItems are placed left to right in each row and automatically wrap to the next row as needed.\n"+
            "* \"colWidths\" (array of FormItemWidthSpec): An array specifying the widths of each column. FormItemWidthSpec is either an integer (number of pixels wide) or the string \"*\", which divides the remaining space among the columns that have FormItemWidthSpec \"*\".\n"+
            "* \"titleOrientation\" (\"top\" | \"left\" | \"right\"): Controls where the title (label) appears relative to the field. The default is \"left\".\n"+
            "* \"titleSuffix\" (HTML string): String to append after every title. The default is \"&nbsp;:\"\n"+
            "\n"+
            "### FormItem-level layout attributes\n"+
            "Each FormItem has properties to control how it is placed within the form's layout:\n"+
            "* \"colSpan\" (integer or \"*\"): Number of columns the item occupies. Use \"*\" to span all remaining columns of the current row. The \"colSpan\" does not include the title shown for the form item if \"showTitle\":`true`, so the effective \"colSpan\" is one higher than this setting if this item is showing a title and the title orientation is either \"left\" or \"right\".\n"+
            "* \"rowSpan\" (integer): Number of rows the item occupies.\n"+
            "* \"startRow\" (boolean): If `true`, the item starts a new row regardless of the previous item's placement.\n"+
            "* \"endRow\" (boolean): If `true`, the next item will appear on the next row.\n"+
            "* \"sectionExpanded\" (boolean): For SectionItems, whether the section starts expanded.\n"+
            "\n"+
            "### SectionItems and grouping\n"+
            "To organize fields visually and functionally, DynamicForm supports special items:\n"+
            "* SectionItem: Renders a collapsible section containing other fields. Fields declared after the SectionItem in the \"fields\" array are automatically grouped under it until the next SectionItem or the end of the array.\n"+
            "* SpacerItem: Creates blank space in the layout grid.\n"+
            "* RowSpacerItem: Inserts vertical space between rows.\n"+
            "* BlurbItem / StaticTextItem: Renders uneditable text, often used for instructions or explanations.\n"+
            "\n"+
            "### Notes\n"+
            "* Titles are automatically sized to fit the longest label in the form, unless overridden with \"colWidths\".\n"+
            "* When showing titles or using \"colSpan\", \"rowSpan\", \"startRow\", and \"endRow\", be aware of how items wrap and how space is allocated across columns and rows.\n"+
            "\n"+
            "## Data binding and loading data\n"+
            "\n"+
            "### Attributes\n"+
            "* \"dataSource\" (string): The ID of the data source to bind the form to.\n"+
            "* \"autoFetchData\" (boolean): If `true`, automatically loads the first record from the data source when the form is initialized.\n"+
            "\n"+
            "### Methods\n"+
            "* editRecord(record): Populates the form with data from the provided record object.\n"+
            "* editNewRecord([initialValues]): Puts the form into \"new record\" mode for adding a new record.\n"+
            "* fetchData([criteria, callback, requestProperties]): Fetches data from the data source and populates the form with the first record matching `criteria`.\n"+
            "* saveData([callback, requestProperties]): Saves the current form values to the data source.\n"+
            "* reset(): Resets the form's values to their initial state.\n"+
            "* setValues(values): Sets the current form values without affecting the editing state.\n"+
            "* getValues(): Returns an object containing the current form values.\n"+
            "\n"+
            "## Validation\n"+
            "DynamicForm automatically performs validation whenever saveData() is called. Each field is validated according to:\n"+
            "* \"required\" flags\n"+
            "* \"validators\" specified on the field or corresponding data source field\n"+
            "* built-in type validations (e.g., integers, dates)\n"+
            "\n"+
            "Validation errors are shown next to the corresponding FormItems by default. "+
            "Form item attributes \"showErrorIcon\", \"showErrorText\", etc. control how validation errors are displayed when they are displayed inline in the form, next to the form item where there is a validation error. To instead display all errors at the top of the form, set the form's \"showInlineErrors\" attribute to `false`.\n"+
            "\n"+
            "## Editing behavior\n"+
            "By default, DynamicForm:\n"+
            "* Tracks whether the form has been modified (isDirty()).\n"+
            "* Validates all fields before saving.\n"+
            "* Sends an \"add\" or \"update\" operation to the data source when saveData() is called.\n"+
            "* Resets the form when a save completes successfully (if editing a new record).\n"+
            "\n"+
            "## Additional notes\n"+
            "* FormItems can be shown or hidden dynamically via showItem() and hideItem().\n"+
            "* You can programmatically validate the form with validate() or validateItem(name).\n"+
            "* Form values can be retrieved at any time via getValuesAsAdvancedCriteria() for filtering other DataBoundComponents.\n",
        format:"Markdown",
        dependencies:["interface:DataBoundComponent"]
    },
    "class:ListGrid":{
        topic:"ListGrid class",
        content:
            "ListGrid displays data in a tabular/grid form, with rows (corresponding to records) and columns (corresponding to fields). It supports built-in features like sorting, filtering, grouping, hiliting, and editing data directly in the grid. "+
            "ListGrid implements DataBoundComponent.\n"+
            "\n"+
            "## Fields\n"+
            "The grid's \"fields\" attribute is an array of ListGridField objects.\n",
        format:"Markdown",
        dependencies:["interface:DataBoundComponent","object:ListGridField"]
    },
    "object:AdvancedCriteria":{
        topic:"AdvancedCriteria",
        content:
            isc.trimDoc`
                An AdvancedCriteria object expresses record-filtering logic in SmartClient data queries.
                The object usually contains, at minimum, the properties:
                * "_constructor" (only for the top-level object, omitted in subcriteria): the string "AdvancedCriteria"
                * "operator": one of the following operator strings:
                    - Logical operators: "and", "or", "not"
                    - Field operators:
                        * Equality: "equals", "notEqual", "iEquals", "iNotEqual"
                        * Substring: "contains", "notContains", "iContains", "iNotContains"
                        * Prefix: "startsWith", "notStartsWith", "iStartsWith", "iNotStartsWith"
                        * Suffix: "endsWith", "notEndsWith", "iEndsWith", "iNotEndsWith"
                        * Comparison: "greaterThan", "greaterOrEqual", "lessThan", "lessOrEqual"
                        * Null/blank: "isNull", "notNull", "isBlank" (equals null or ""), "notBlank" (neither null nor "")

                    Do not use any other operator.

                You may see that the "_constructor" property has been omitted in the top-level
                object.  That is valid, but it is better to explicitly include "_constructor":"AdvancedCriteria".

                If the "operator" is "equals" (the default), then "operator" may be omitted.

                When using a logical operator, the AdvancedCriteria must have a "criteria" property.
                For "not", this is a single AdvancedCriteria, and for "and"/"or" this is an array
                of two or more AdvancedCriteria.
                The semantics of the logical operators are as follows:
                * "and" requires all subcriteria to be \`true\`.
                * "or" requires at least one subcriterion to be \`true\`.
                * "not" negates the single subcriterion.

                When using a field operator, the AdvancedCriteria object must have the additional properties:
                * "fieldName": the field name
                * "value": the comparison value (omit if "operator" is "isNull", "notNull", "isBlank", or "notBlank")

                For equality and comparison criteria on numeric fields, you must infer the units
                of the field's values from the field's title, description, name or other available
                information about the field. For example, if a field's title is "Area in km^2",
                then you might infer that the field's values have units of square-kilometers.
                Always convert comparison values to the same units that you infer for the
                field's values. For example, if you infer (from the name) that a 'cmLength' field
                has units of centimeters and you want to filter for lengths greater than
                100 inches, then you must convert 100 inches (the comparison value) to the same
                units of the field values (centimeters); "'cmLength' is more than 100 inches"
                can be represented as:
                <code language="JavaScript">
                {
                  "_constructor": "AdvancedCriteria",
                  "operator": "greaterThan",
                  "fieldName": "cmLength",
                  "value": 254  // 100 inches converted to centimeters (the units of the 'cmLength' field)
                }
                </code>

                If you are outputting AdvancedCriteria as JSON, then for fields of type "date",
                "value" will be a string in the format "yyyy-MM-dd", where yyyy
                is the four-digit year, MM is the two-digit month (01 = January), and dd is
                the two-digit day of the month. If you are outputting AdvancedCriteria as JavaScript,
                then "value" should be a call to isc.DateUtil.createLogicalDate(year, month, day),
                where \`month\` is 0-based.

                AdvancedCriteria does not support filtering by top-N (e.g. the top 3 records)
                or percentiles directly. To achieve those requirements, configure the "startRow",
                "endRow", and "sortBy" fetch DSRequest properties, or the "dataPageSize" and
                "initialSort" DataBoundComponent properties.

                The equality, substring, prefix, and suffix operators beginning with "i" are
                case-insensitive.

                If the "operator" is "lessThan" or "lessOrEqual" and the field's values may
                be \`null\` (i.e. the field is not "required":\`true\`), then you must be
                explicit about whether to include \`null\` values or not; this is because some
                data queries will treat \`null\` as always less-than any non-\`null\` value,
                but other data queries will not. If you want \`null\` values to be included,
                then use an "or" criterion with one of the subcriteria using "operator":"isNull"
                on the field. If you do not want \`null\` values to be included, then use an
                "and" criterion with one of the subcriteria using "operator":"notNull"
                on the field.
                For example, given a 'testScore' field that is not required (hence, its values
                may be \`null\`):
                "'testScore' is available and less than 75" can be represented as:
                <code language="JavaScript">
                {
                  "_constructor": "AdvancedCriteria",
                  "operator": "and",
                  "criteria": [
                    {"fieldName": "testScore", "operator": "notNull"},
                    {"fieldName": "testScore", "operator": "lessThan", "value": 75}
                  ]
                }
                </code>
                "'testScore' is not reported or less than 20" can be represented as:
                <code language="JavaScript">
                {
                  "_constructor": "AdvancedCriteria",
                  "operator": "or",
                  "criteria": [
                    {"fieldName": "testScore", "operator": "isNull"},
                    {"fieldName": "testScore", "operator": "lessThan", "value": 20}
                  ]
                }
                </code>

                Example: "'fieldA' is greater than zero" can be represented as:
                <code language="JavaScript">
                {
                  "_constructor": "AdvancedCriteria",
                  "operator": "greaterThan",
                  "fieldName": "fieldA",
                  "value": 0
                }
                </code>

                Example: "'orderID' must be non-empty and 'orderTotal' must be more than 0 and
                less than 20" can be represented as:
                <code language="JavaScript">
                {
                  "_constructor": "AdvancedCriteria",
                  "operator": "and",
                  "criteria": [
                    {"fieldName": "orderID", "operator": "notBlank"},
                    {"fieldName": "orderTotal", "operator": "greaterThan", "value": 0},
                    {"fieldName": "orderTotal", "operator": "lessThan", "value": 20}
                  ]
                }
                </code>
            `,
        format:"Markdown"
    },
    "CriteriaShorthand":{
        topic:"Criteria Shorthand",
        content:'xmlCriteriaShorthand\n'+
            'All rules described in this topic are applied any time a property is of type AdvancedCriteria (in both Component XML and JavaScript component creation) and any API declares an AdvancedCriteria param.\n'+
            '\n'+
            'A shorthand format for AdvancedCriteria is supported for simple criteria where the outer criterion is assumed to be an "and" operator:\n'+
            '\n'+
            ' <!-- Simple format -->\n'+
            ' <criteria fieldName="restrictAge" operator="equals" value="true"/>\n'+
            ' \n'+
            'This is equivalent to:\n'+
            ' <!-- Normal format -->\n'+
            ' <criteria _constructor="AdvancedCriteria operator="and">\n'+
            '   <criteria>\n'+
            '     <criterion fieldName="restrictAge" operator="equals" value="true"/>\n'+
            '   </criteria> \n'+
            ' </criteria>\n'+
            ' \n'+
            'Additionally these defaults are used allowing to simplify AdvancedCriteria declaration:\n'+
            'operator="and" default is used if criteria is present at the same level\n'+
            'operator="equals" default is used if fieldName is present at the same level\n'+
            'value="true" default is used if operator="equals" default was applied\n'+
            'So, shorthand format above could be simplified even more, for example to conditionally enable a form button:\n'+
            ' <!-- Simple format -->\n'+
            ' <enableWhen fieldName="CustomerGrid.anySelected"/>\n'+
            ' \n'+
            'Full equivalent:\n'+
            ' <!-- Normal format -->\n'+
            ' <enableWhen _constructor="AdvancedCriteria operator="and">\n'+
            '   <criteria>\n'+
            '     <criterion fieldName="CustomerGrid.anySelected" operator="equals" value="true"/>\n'+
            '   </criteria>\n'+
            ' </enableWhen>\n'+
            ' \n'+
            'Another example shows all defaults usage, significantly shortening AdvancedCriteria declaration for boolean dynamic property (see full setup in Boolean Dynamic Properties example):\n'+
            ' <!-- Simple format -->\n'+
            ' <trueWhen>\n'+
            '     <criteria fieldName="settingsForm/values/exportFieldWidths" />\n'+
            '     <criteria fieldName="settingsForm/values/exportAs" operator="inSet" >\n'+
            '         <value>xls</value>\n'+
            '         <value>ooxml</value>\n'+
            '     </criteria>\n'+
            ' </trueWhen>\n'+
            ' \n'+
            'Full equivalent:\n'+
            ' <!-- Normal format -->\n'+
            ' <trueWhen>\n'+
            '     <AdvancedCriteria operator="and">\n'+
            '         <criteria>\n'+
            '             <criterion fieldName="settingsForm/values/exportFieldWidths" operator="equals" value="true"/>\n'+
            '             <criterion fieldName="settingsForm/values/exportAs" operator="inSet" >\n'+
            '                 <value>xls</value>\n'+
            '                 <value>ooxml</value>\n'+
            '             </criterion>\n'+
            '         </criteria>\n'+
            '     </AdvancedCriteria>\n'+
            ' </trueWhen>\n'+
            ' \n'+
            'JS example:\n'+
            ' // Simple format\n'+
            ' {fieldName: "restrictAge"}\n'+
            '\n'+
            ' // Normal format\n'+
            ' {\n'+
            '   _constructor: "AdvancedCriteria",\n'+
            '   operator: "and",\n'+
            '   criteria: [\n'+
            '     {fieldName: "restrictAge", operator: "equals", value: true}\n'+
            '   ]\n'+
            ' }\n',
        format:"Markdown"
    },
    "class:TabSet":{
        topic:"Tabset class",
        content:"## TabSet Overview\n"+
            "The SmartClient TabSet is a UI control that provides a tabbed interface for managing multiple\n"+
            "content panes within a single container. Each tab displays its associated pane when selected.\n"+
            "This allows compact organization of related views in applications like dashboards or wizards.\n"+
            "\n"+
            "## Key Concepts\n"+
            "- Tabs: Clickable labels used to switch views.\n"+
            "- Panes: Content displayed when a tab is selected.\n"+
            "- TabSet: Container that holds and manages tabs and their content.\n"+
            "\n"+
            "## Creating a TabSet\n"+
            "Use isc.TabSet.create() to define the tabbed layout and initialize with optional tabs:\n"+
            "\n"+
            "  isc.TabSet.create({\n"+
            "      ID: \"mainTabSet\",\n"+
            "      width: \"100%\",\n"+
            "      height: \"100%\",\n"+
            "      tabs: []\n"+
            "  });\n"+
            "\n"+
            "## Adding Tabs and Panes\n"+
            "Tabs are objects with at least a title and pane (any SmartClient component):\n"+
            "\n"+
            "  mainTabSet.addTab({\n"+
            "      title: \"New Tab\",\n"+
            "      ID: \"newTab\",\n"+
            "      pane: isc.HTMLPane.create({ contents: \"<h2>Hello from new tab!</h2>\" })\n"+
            "  });\n"+
            "\n"+
            "## Accessing and Managing Tabs\n"+
            "- Select a tab:\n"+
            "    mainTabSet.selectTab(\"tab1\");\n"+
            "- Remove a tab:\n"+
            "    mainTabSet.removeTab(\"tab1\");\n"+
            "- Update a tab:\n"+
            "    mainTabSet.updateTab(\"tab1\", { title: \"Updated Title\" });\n"+
            "- Get selected tab:\n"+
            "    var tab = mainTabSet.getSelectedTab();\n"+
            "\n"+
            "## Working with Panes\n"+
            "Panes are SmartClient components (Canvas, ListGrid, etc.). They can be updated or accessed:\n"+
            "\n"+
            "  mainTabSet.updateTab(\"tab1\", {\n"+
            "      pane: isc.DynamicForm.create({ fields: [...] })\n"+
            "  });\n"+
            "\n"+
            "  var pane = mainTabSet.getTabPane(\"tab1\");\n"+
            "\n"+
            "## Events and Interaction\n"+
            "- tabSelected: Fires when a tab is selected.\n"+
            "- tabDeselected: Fires before a tab is switched away from.\n"+
            "- canCloseTabs: Enables close buttons on each tab.\n"+
            "\n"+
            "  mainTabSet.tabSelected = function (tabNum, tabPane, ID, tab) {\n"+
            "      isc.say(\"You selected tab: \" + tab.title);\n"+
            "  };\n"+
            "\n"+
            "## Styling and Configuration Options\n"+
            "- tabBarPosition: Set to \"top\", \"bottom\", \"left\", or \"right\" to position tabs.\n"+
            "- canClose: Set true per tab or globally with canCloseTabs: true.\n"+
            "- Tab picker menu appears automatically if tabs overflow the visible area.\n"+
            "\n"+
            "## Summary\n"+
            "The TabSet is ideal for managing multiple views in a compact layout. Tabs and their panes can\n"+
            "be created, updated, and removed dynamically, making TabSet a flexible layout and navigation\n"+
            "tool in SmartClient applications.\n",
        format:"Markdown"
    },
    "class:HLayout":{
        topic:"HLayout class",
        content:"## HLayout Overview\n"+
            "HLayout is a SmartClient container that arranges its children horizontally, from left to right.\n"+
            "It's used when components need to appear side-by-side and automatically manage space and spacing.\n"+
            "\n"+
            "## Creating an HLayout\n"+
            "Use isc.HLayout.create() to define a horizontal layout container:\n"+
            "\n"+
            "  isc.HLayout.create({\n"+
            "      width: \"100%\",\n"+
            "      height: 100,\n"+
            "      membersMargin: 10,\n"+
            "      members: [\n"+
            "          isc.Label.create({ contents: \"Left\" }),\n"+
            "          isc.Label.create({ contents: \"Right\" })\n"+
            "      ]\n"+
            "  });\n"+
            "\n"+
            "## Key Properties\n"+
            "- members: List of child widgets to be laid out.\n"+
            "- membersMargin: Spacing between members (in pixels).\n"+
            "- layoutAlign: Controls vertical alignment (e.g., \"top\", \"center\", \"bottom\").\n"+
            "- width / height: Specifies the size of the layout container.\n"+
            "- overflow: Defines how to handle overflow content.\n"+
            "\n"+
            "## Dynamic Usage\n"+
            "- Add a member:\n"+
            "    myHLayout.addMember(isc.Button.create({ title: \"New Button\" }));\n"+
            "- Remove a member:\n"+
            "    myHLayout.removeMember(existingComponent);\n"+
            "\n"+
            "## Flexible Sizing\n"+
            "- Use layoutPolicy: \"fill\" to stretch children.\n"+
            "- Children can use width: \"*\" to take remaining space.\n"+
            "\n"+
            "## Nesting\n"+
            "HLayouts can be nested within other layouts to build complex horizontal arrangements in UIs.\n"+
            "\n"+
            "## Summary\n"+
            "HLayout helps structure UI horizontally, automatically handling spacing and sizing. Ideal for\n"+
            "toolbars, split panes, or any layout requiring side-by-side arrangement of components.\n",
        format:"markdown"
    },
    "class:VLayout":{
        topic:"VLayout class",
        content:"## VLayout Overview\n"+
            "VLayout is a SmartClient layout container that arranges child components vertically, top to bottom.\n"+
            "It is commonly used for stacking elements in forms, dashboards, or panels.\n"+
            "\n"+
            "## Creating a VLayout\n"+
            "Use isc.VLayout.create() to define a vertical layout structure:\n"+
            "\n"+
            "  isc.VLayout.create({\n"+
            "      width: 300,\n"+
            "      height: \"100%\",\n"+
            "      membersMargin: 5,\n"+
            "      members: [\n"+
            "          isc.Button.create({ title: \"Top\" }),\n"+
            "          isc.Button.create({ title: \"Bottom\" })\n"+
            "      ]\n"+
            "  });\n"+
            "\n"+
            "## Key Properties\n"+
            "- members: Array of child widgets to be stacked vertically.\n"+
            "- membersMargin: Sets space between stacked items.\n"+
            "- layoutAlign: Controls horizontal alignment (e.g., \"left\", \"center\", \"right\").\n"+
            "- height / width: Overall layout container size.\n"+
            "- overflow: Behavior when children exceed layout size.\n"+
            "\n"+
            "## Dynamic Usage\n"+
            "- Add a new member dynamically:\n"+
            "    myVLayout.addMember(isc.Label.create({ contents: \"Dynamic Label\" }));\n"+
            "- Remove an existing member:\n"+
            "    myVLayout.removeMember(existingComponent);\n"+
            "\n"+
            "## Stretching and Fill\n"+
            "- Set layoutPolicy: \"fill\" to distribute available space.\n"+
            "- Children can use height: \"*\" to grow and fill remaining vertical space.\n"+
            "\n"+
            "## Nesting\n"+
            "VLayouts can contain other VLayouts or HLayouts to compose rich, nested UI structures.\n"+
            "\n"+
            "## Summary\n"+
            "VLayout is best suited for top-to-bottom arrangements like stacked buttons, form fields, or\n"+
            "sections. It simplifies spacing and resizing and is a key building block in SmartClient UIs.\n",
        format:"markdown"
    },
    "class:Button":{
        topic:"Button class",
        content:"## Button Overview\n"+
            "The SmartClient Button class is a subclass of Canvas that provides a clickable UI control with\n"+
            "a caption, built-in styling, and mouse interaction. It is used to trigger actions in response\n"+
            "to user input.\n"+
            "\n"+
            "## Creating a Button\n"+
            "Buttons are created with isc.Button.create() and require at least a title and optionally a\n"+
            "click handler:\n"+
            "\n"+
            "  isc.Button.create({\n"+
            "      title: \"Click Me\",\n"+
            "      width: 120,\n"+
            "      click: function () {\n"+
            "          isc.say(\"Button clicked!\");\n"+
            "      }\n"+
            "  });\n"+
            "\n"+
            "## Pertinent Properties (Not in Canvas)\n"+
            "- title: String shown on the button face. This is the main label of the button.\n"+
            "- autoFit: If true, the button automatically sizes to fit its title.\n"+
            "- icon: URL or image reference to show an icon next to the title.\n"+
            "- iconOrientation: \"left\" or \"right\" – controls where icon appears relative to title.\n"+
            "- showRollOver, showDown: Boolean flags that control visual feedback for mouse interactions.\n"+
            "- baseStyle: CSS style name for customizing the button's appearance.\n"+
            "\n"+
            "## Events and Interaction\n"+
            "- click(): This is the primary interaction event for buttons.\n"+
            "  Define this function to perform an action when the user presses the button.\n"+
            "\n"+
            "  Example:\n"+
            "    click: function () {\n"+
            "        doSomethingImportant();\n"+
            "    }\n"+
            "\n"+
            "- mouseOver(), mouseOut(), mouseDown(), mouseUp(): Optional Canvas-based event hooks.\n"+
            "\n"+
            "## Styling Buttons\n"+
            "- You can customize the visual style using baseStyle and skinning system.\n"+
            "- Use autoFit for buttons that grow/shrink with the label text.\n"+
            "- For grouped buttons or toolbars, consider placing them in an HLayout or ToolStrip.\n"+
            "\n"+
            "## Summary\n"+
            "SmartClient Buttons provide a ready-to-use interactive element with a title, built-in click\n"+
            "event support, and automatic visual feedback. They extend Canvas but introduce user-facing\n"+
            "properties like title, autoFit, icon, and the all-important click() handler.\n",
        format:"markdown"
    },
    "class:FacetChart":{
        topic:"FacetChart class",
        content:"## FacetChart Overview\n"+
            "FacetChart is a SmartClient data visualization component used to display charts like bar,\n"+
            "line, pie, and area graphs. It is built on the DrawPane and supports multi-faceted data,\n"+
            "with grouping, titles, legends, and interactive features.\n"+
            "\n"+
            "## Creating a FacetChart\n"+
            "Create a chart with isc.FacetChart.create(), specifying chart type, data, and value metrics:\n"+
            "\n"+
            "  isc.FacetChart.create({\n"+
            "      ID: \"salesChart\",\n"+
            "      width: \"100%\",\n"+
            "      height: 300,\n"+
            "      chartType: \"bar\",\n"+
            "      facets: [\n"+
            "          { id: \"region\", title: \"Region\" }\n"+
            "      ],\n"+
            "      valueProperty: \"sales\",\n"+
            "      data: [\n"+
            "          { region: \"North\", sales: 120 },\n"+
            "          { region: \"South\", sales: 95 }\n"+
            "      ]\n"+
            "  });\n"+
            "\n"+
            "## Supported chartType values\n"+
            "- \"bar\" (default)\n"+
            "- \"column\"\n"+
            "- \"line\"\n"+
            "- \"area\"\n"+
            "- \"pie\"\n"+
            "- \"doughnut\"\n"+
            "- \"radar\"\n"+
            "\n"+
            "## Key Properties\n"+
            "- chartType: Defines the type of chart to render (e.g., \"bar\", \"pie\").\n"+
            "- facets: Defines dimensions for grouping (like rows or series).\n"+
            "- valueProperty: The field containing numerical data for plotting.\n"+
            "- title: Title of the chart.\n"+
            "- showLegend: Controls visibility of the legend.\n"+
            "- data: Array of data records, each with facet and value fields.\n"+
            "\n"+
            "## Interaction Features\n"+
            "- showDataValuesMode: never, auto, inChartOnly, inChartOrHover, inChartAndHover, inHoverOnly.\n"+
            "- click events: valueClick, pointClick, legendClick, dataLabelClick - Define behavior when chart elements are clicked.\n"+
            "\n"+
            "  Example:\n"+
            "    valueClick: function (drawnValue) {\n"+
            "        isc.say(\"Clicked on: \" + drawnValue);\n"+
            "    }\n"+
            "\n"+
            "## Styling and Configuration\n"+
            "- Use valueTitle to set labels for data values.\n"+
            "- Use facets and facetTitles to control groupings and legend labels.\n"+
            "\n"+
            "## Summary\n"+
            "FacetChart allows developers to create rich, interactive visualizations with multiple chart\n"+
            "types. While it supports many standard charts, scatter plots are not supported, and related\n"+
            "properties like xAxisMetric must be avoided. Use FacetChart for data summaries, comparisons,\n"+
            "and visual groupings across multiple dimensions.\n",
        format:"markdown"
    },
    "class:Facet":{
        topic:"Facet class",
        content:"## Facet Overview\n"+
            "The Facet class in SmartClient defines a dimension of categorization for use in components\n"+
            "like FacetChart. Each facet represents a field or attribute by which data can be grouped,\n"+
            "split, or compared visually.\n"+
            "\n"+
            "Facets are typically passed into the `facets` array of a FacetChart and define how data records\n"+
            "are bucketed or displayed in charts.\n"+
            "\n"+
            "## Basic Structure\n"+
            "Each facet is a simple object that usually includes an `id`, a `title`, and a `values` array.\n"+
            "\n"+
            "  {\n"+
            "      id: \"region\",\n"+
            "      title: \"Region\",\n"+
            "      values: [\n"+
            "          { id: \"north\", title: \"North\" },\n"+
            "          { id: \"south\", title: \"South\" }\n"+
            "      ]\n"+
            "  }\n"+
            "\n"+
            "## Key Properties\n"+
            "- id: The unique identifier for the facet (used to match data).\n"+
            "- title: A human-readable label for display in charts and legends.\n"+
            "- values: An array of objects defining each discrete value in the facet.\n"+
            "  Each value typically includes:\n"+
            "    - id: The data value.\n"+
            "    - title: The label to show in the chart UI.\n"+
            "\n"+
            "**Important Note:** The Facet class does NOT use a `valueMap` property.\n"+
            "Instead, it uses a `values` array with structured objects. If you're trying to customize\n"+
            "display labels, use `values` with `id` and `title` entries, not a flat valueMap.\n"+
            "\n"+
            "## Example Use in a FacetChart\n"+
            "  isc.FacetChart.create({\n"+
            "      facets: [\n"+
            "          {\n"+
            "              id: \"product\",\n"+
            "              title: \"Product\",\n"+
            "              values: [\n"+
            "                  { id: \"A\", title: \"Product A\" },\n"+
            "                  { id: \"B\", title: \"Product B\" }\n"+
            "              ]\n"+
            "          }\n"+
            "      ],\n"+
            "      valueProperty: \"sales\",\n"+
            "      chartType: \"bar\",\n"+
            "      data: [\n"+
            "          { product: \"A\", sales: 120 },\n"+
            "          { product: \"B\", sales: 90 }\n"+
            "      ]\n"+
            "  });\n"+
            "\n"+
            "## Summary\n"+
            "Facets define how SmartClient charts and grids categorize and group data. A facet consists of\n"+
            "an id, title, and a values array. Unlike form items, facets do not use valueMap — instead, they\n"+
            "expect a structured `values` array to define display labels and order. Facets are essential for\n"+
            "driving multi-dimensional visualizations in FacetChart.\n",
        format:"markdown"
    },
    "object:DBCField":{
        topic:"DBCField object",
        content:"## DBCField Overview\n"+
            "A DBCField is a field declaration used within a DataBoundComponent (such as ListGrid,\n"+
            "DynamicForm, or DetailViewer) to bind the component to a specific field from its\n"+
            "DataSource. It is based on the Field type and adds exactly one required property: `name`.\n"+
            "\n"+
            "## Relationship to Field\n"+
            "DBCField inherits from Field, which includes the following properties:\n"+
            "- canEdit\n"+
            "- canExport\n"+
            "- escapeHTML\n"+
            "- exportTitle\n"+
            "- multiple\n"+
            "- primaryKey\n"+
            "- required\n"+
            "- sortByField\n"+
            "- title\n"+
            "- type\n"+
            "- valueMap\n"+
            "\n"+
            "These properties define how the field behaves and is rendered in the UI. They do not affect\n"+
            "server-side logic.\n"+
            "\n"+
            "## DBCField-Specific Property\n"+
            "- name (String): The ID of the DataSource field this DBCField represents. This is required\n"+
            "  and is the only property on DBCField that is not already present on Field.\n"+
            "\n"+
            "## Example\n"+
            "  isc.ListGrid.create({\n"+
            "      dataSource: \"employeesDS\",\n"+
            "      fields: [\n"+
            "          { name: \"employeeId\", title: \"ID\", canEdit: false },\n"+
            "          { name: \"name\", required: true },\n"+
            "          { name: \"department\", valueMap: [\"HR\", \"Sales\", \"Engineering\"] }\n"+
            "      ]\n"+
            "  });\n"+
            "\n"+
            "## Summary\n"+
            "DBCField is the type used in DataBoundComponents to define which DataSource fields to display\n"+
            "and how. It is identical to Field except that it adds one required property — `name` — to\n"+
            "identify the field being bound. All other behavior is inherited from Field.\n",
        format:"markdown"
    },
    "class:Label":{
        topic:"Label class",
        content:"## Label Overview\n"+
            "The SmartClient `Label` class is a lightweight, read-only display widget used to show static\n"+
            "text or HTML content in the UI. It extends `Canvas` and is optimized for performance and\n"+
            "simplicity when no user interaction or editing is needed.\n"+
            "\n"+
            "## Relationship to Canvas\n"+
            "`Label` is a subclass of `Canvas`, and inherits most layout, sizing, and styling behavior from it.\n"+
            "However, it adds specific properties focused on content display and is stripped of interactive\n"+
            "features like event handling or child widgets.\n"+
            "\n"+
            "## Key Properties\n"+
            "- contents: (String) — The actual text or HTML to be displayed. This is the main content of the label.\n"+
            "- wrap: (Boolean) — If true, content wraps within the width of the label. Defaults to true.\n"+
            "- align: (String) — Horizontal alignment of text: \"left\", \"center\", or \"right\".\n"+
            "- valign: (String) — Vertical alignment: \"top\", \"center\", or \"bottom\".\n"+
            "- icon: (String) — Optional URL of an image/icon to show next to the text.\n"+
            "- iconOrientation: (String) — \"left\" or \"right\" — controls icon position relative to text.\n"+
            "- iconSize: (Number) — Pixel height and width for the icon (applies to both dimensions).\n"+
            "- clip: (Boolean) — If true, overflow content is clipped instead of resized or wrapped.\n"+
            "\n"+
            "## Example\n"+
            "  isc.Label.create({\n"+
            "      ID: \"statusLabel\",\n"+
            "      contents: \"Status: Ready\",\n"+
            "      width: 200,\n"+
            "      height: 20,\n"+
            "      align: \"left\",\n"+
            "      styleName: \"statusText\"\n"+
            "  });\n"+
            "\n"+
            "## Usage Notes\n"+
            "- `Label` is read-only. For editable text, use a `TextItem` in a form instead.\n"+
            "- It can display raw text or HTML. Use `escapeHTML: false` if rendering custom markup.\n"+
            "- For performance, prefer `Label` over `Canvas` when no interactivity is needed.\n"+
            "\n"+
            "## Summary\n"+
            "SmartClient `Label` is a display-only widget for rendering text or HTML in a clean, efficient way.\n"+
            "It supports basic formatting, alignment, and optional icons. Use it for static UI text such as\n"+
            "captions, titles, messages, and status indicators.\n",
        format:"markdown"
    },
    "RuleScope":{
        topic:"RuleScope",
        content:"Canvas.ruleScope [IR]\ttype:String, defaultValue: null\n\n"+
            "ID of the component that gathers the context for evaluation of criteria-based rules "+
            "specified by properties such as FormItem.visibleWhen, Dynamic Properties, and "+
            "dynamicCriteria such as ListGrid.initialCriteria.\n"+
            "If ruleScope is not specified, this component will search through its parentCanvas chain "+
            "until it either reaches the top or reaches a parent marked isRuleScope. This means that "+
            "typically, ruleScope does not have to be explicitly specified, since components that want "+
            "to reference each other often have the same top-level parent (eg, they are part of the same "+
            "screen). However, you would need to specify ruleScope in scenarios such as a modal Window "+
            "that wants to reference values in the component it was launched from.\n\n"+
            "Determination of the ruleScope happens when the component is first drawn.\n\n"+
            "The component designated as the ruleScope manages a nested data structure called the "+
            "\"rule context\" which contains information from all DataBoundComponents that are registered "+
            "with the ruleScope. By specifying Criterion.fieldName as a DataPath, AdvancedCriteria defined "+
            "in properties such as FormItem.visibleWhen can access any part of the rule context.\n\n"+
            "By default, the rule context contains data as follows:\n\n"+
            "- Any DataBoundComponent or ValuesManager that has a DataSource contributes the values of the "+
            "selected record or record being edited under the ID of the DataSource. For any collision an "+
            "editable display (such as a form or editable grid) wins over a static display. Hidden or "+
            "cleared components have lowest priority even if editable. For two editable components the "+
            "first becomes the contributor.\n"+
            "- Any ListGrid or other component that manages a selection and has been assigned an explicit "+
            "ID will contribute values of the selected record under <componentId>.selectedRecord, values of "+
            "the grid summary under <componentId>.summaryRecord, and selection flags: anySelected, "+
            "multiSelected, numSelected. Also: <componentId>.selectedRowNum.\n"+
            "- Any DynamicForm or component that edits values and has an explicit ID contributes its current "+
            "values under <componentId>.values, and contributes a flag hasChanges.\n"+
            "- Any DynamicForm or ListGrid with an ID contributes <componentId>.focusField to indicate "+
            "which field has focus, or absence if no focus.\n"+
            "- Any ListGrid with an ID contributes a flag isGrouped under <componentId>.\n"+
            "- Any DataSource included in a DataContext or testDataContext contributes to "+
            "dataContext.<DataSourceID>. Only the first contribution is saved as dataContext is immutable.\n"+
            "- A ValuesManager contributes the DataSource-prefixed portion of ruleContext before member forms.\n\n"+
            "In addition to data from DataBoundComponent, ruleScope includes entries from the "+
            "Authentication class (e.g. userId, roles) and device characteristics as follows:\n\n"+
            "{\n"+
            "  device : {\n"+
            "    isPhone : false,\n"+
            "    isTablet : false,\n"+
            "    isDesktop : true,\n"+
            "    isLandscape : true\n"+
            "  }\n"+
            "}\n\n"+
            "For example, if a ListGrid \"itemGrid\" and DynamicForm \"itemForm\" are bound to the same "+
            "DataSource with selection/editing:\n\n"+
            "{\n"+
            "  supplyItem : { itemID: \"654321\", itemName: \"Sewing Machine\", price: 5.50 },\n"+
            "  itemForm.values : { itemID: \"654321\", itemName: \"Sewing Machine\", price: 5.50 },\n"+
            "  itemForm.focusField : \"itemName\",\n"+
            "  itemForm.hasChanges : true,\n"+
            "  itemGrid.selectedRecord : { itemID: \"654321\", itemName: \"Sewing Machine\", price: 3.50 },\n"+
            "  itemGrid.anySelected : true,\n"+
            "  itemGrid.multiSelected : false,\n"+
            "  itemGrid.numSelected : 1,\n"+
            "  itemGrid.isGrouped : false,\n"+
            "  device : { isPhone: false, isTablet: false, isDesktop: true, isLandscape: true },\n"+
            "  auth : {\n"+
            "    currentUser : { userId: \"lisa\", firstName: \"Lisa\", lastName: \"Admin\", roles: \"admin\" },\n"+
            "    roles : ['admin'],\n"+
            "    isSuperUser : false\n"+
            "  }\n"+
            "}\n\n"+
            "An application can put custom data into the ruleScope via provideRuleContext().\n\n"+
            "ValuesManager and RuleContext:\n"+
            "* WhenRules in member forms of a ValuesManager using short-form references apply only to "+
            "that form. To reference external field values, use the DataSource-prefixed path.\n\n"+
            "Troubleshooting RuleScope issues:\n"+
            "The system includes provideRuleContext() and removeRuleContext(), and consumers include all "+
            "criteria-based rules. Enable logging for these categories at Info or Debug levels:\n\n"+
            "- ruleContext\n- whenRules\n- dynamicProperties\n- dynamicCriteria\n\n"+
            "Use the Developer Console to add these categories if not already present.\n\n"+
            "Example log entries, evaluations, and criteria diagnostics are available by enabling Info or "+
            "Debug priority, as shown above.\n\n"+
            "## dynamicCriteria\n"+
            "If a property indicates it has support for \"dynamic criteria\" it means that values in the "+
            "criteria may be dynamically derived from the current Canvas.ruleScope using "+
            "Criterion.valuePath.\n\n"+
            "In other words, it allows criteria to be declared using values from nearby drawn components, "+
            "via the Canvas.ruleScope. Values are pulled from the ruleScope via setting "+
            "Criterion.valuePath. When values drawn from the ruleScope change, the component where "+
            "dynamicCriteria is declared will be notified and automatically use the new value.\n\n"+
            "Example:\n\n"+
            "isc.DynamicForm.create({\n"+
            "  ID: \"theForm\",\n"+
            "  items:[{\n"+
            "    name: \"lifeSpan\",\n"+
            "    type: \"text\",\n"+
            "    title: \"LifeSpan\",\n"+
            "    defaultValue: \"45\"\n"+
            "  }]\n"+
            "});\n\n"+
            "isc.ListGrid.create({\n"+
            "  width: 300,\n"+
            "  height: 400,\n"+
            "  top: 50,\n"+
            "  dataSource: \"animals\",\n"+
            "  initialCriteria: {\n"+
            "    fieldName: \"lifeSpan\",\n"+
            "    operator: \"greaterThan\",\n"+
            "    valuePath: \"theForm.values.lifeSpan\"\n"+
            "  }\n"+
            "});",
        format:"markdown"
    },
    "ComponentXML":{
        topic:"ComponentXML",
        content:"Component XML\n"+
            "As covered in the QuickStart Guide Chapter 4, Coding, SmartClient components can be "+
            "created in either XML or JavaScript format. This section covers further details of using the "+
            "XML format, called \"SmartClient component XML\".\n\n"+
            "Referring to previously defined components\n\n"+
            "To refer to another component by ID in XML, use <Canvas withID=\"\"/>. For example:\n\n"+
            "<Canvas ID=\"myCanvas\"/>\n"+
            "<Canvas ID=\"myCanvas2\"/>\n"+
            "<VLayout>\n"+
            "    <members>\n"+
            "        <Canvas withID=\"myCanvas\"/>\n"+
            "        <Canvas withID=\"myCanvas2\"/>\n"+
            "    </members>\n"+
            "</VLayout>\n\n"+
            "Loading screens stored in Component XML\n\n"+
            "Save your Component XML as a file named screenName.ui.xml under webroot/shared/ui/. This "+
            "makes it visible to the system. You can change this path with the server.properties "+
            "project.ui setting. screenName must use only valid identifier characters (underscores are OK).\n\n"+
            "If you use multiple top-level tags, wrap them in <isomorphicXML> to make valid XML.\n\n"+
            "Screens are loaded with ScreenLoaderServlet (registered at projectBase/isomorphic/screenLoader "+
            "by default). If you've edited web.xml, you may need to re-register it.\n\n"+
            "To launch a mockup-only application:\n"+
            "<script src=\"../isomorphic/screenLoader?screenName=screenName\"></script>\n\n"+
            "To dynamically load or load multiple screens, use RPCManager.loadScreen().\n\n"+
            "Strict validation can be enabled to catch XML errors (see Strict Mode).\n\n"+
            "Embedding JavaScript code\n\n"+
            "Use the <JS> tag to embed expressions in XML. Example:\n"+
            "<VLayout>\n"+
            "    <width><JS>isc.Page.getWidth() - 20</JS></width>\n"+
            "</VLayout>\n\n"+
            "StringMethods like ListGrid.recordClick() can be defined inline:\n"+
            "<ListGrid>\n"+
            "    <recordClick>if (record.age > 65) doSomething()</recordClick>\n"+
            "</ListGrid>\n\n"+
            "Or using <JS>:\n"+
            "<ListGrid>\n"+
            "    <recordClick><JS>function (viewer, record) {\n"+
            "        if (record.age > 65) doSomething();\n"+
            "    }</JS></recordClick>\n"+
            "</ListGrid>\n\n"+
            "Use &amp; for &&, or wrap code in CDATA to avoid escaping:\n"+
            "<![CDATA[\n"+
            "  if (record.status != null && record.age > 65) doSomething()\n"+
            "]]>\n\n"+
            "For non-trivial code, keep JavaScript in separate .js files and keep XML simple.\n\n"+
            "Event Handlers & Scripting loaded components\n\n"+
            "Retrieve components using Canvas.getById(\"id\") and attach handlers:\n"+
            "isc.Canvas.getById(\"mainGrid\").addMethods({ recordClick: \"editForm.editRecord(record)\" });\n\n"+
            "Add loaded screen to a layout:\n"+
            "existingLayout.addMember(isc.Canvas.getById(\"componentId\"));\n\n"+
            "Use <Canvas withID=\"theGrid\"/> inside XML to refer to programmatically created components.\n\n"+
            "Declarative Actions\n\n"+
            "Declare event responses as Actions:\n"+
            "<recordClick>\n"+
            "  <Action target=\"customerDetailViewer\" name=\"viewSelectedData\" mapping=\"viewer\"/>\n"+
            "</recordClick>\n\n"+
            "target: ID of the component\n"+
            "name: method name\n"+
            "mapping: optional parameters (see below)\n\n"+
            "Processes can also be defined declaratively:\n"+
            "<recordClick>\n"+
            "  <Process>...</Process>\n"+
            "</recordClick>\n\n"+
            "Multiple Actions and/or Processes can be declared for one event.\n\n"+
            "Parameters and Actions\n\n"+
            "Parameters go in the mapping attribute and can include:\n"+
            "- Variable name (e.g., record)\n"+
            "- this (reference to the declaring component)\n"+
            "- Literals: 'foo', 17\n"+
            "- JS expressions: new Date()\n\n"+
            "Example: viewer is passed by recordClick(), so use mapping=\"viewer\"\n\n"+
            "Global IDs\n\n"+
            "Global IDs can conflict when loading multiple screens. Use RPCManager.loadScreen() to avoid "+
            "this. It suppresses global IDs and gives generated IDs.\n\n"+
            "Use getByLocalId() from the root of the loaded screen to find components.\n\n"+
            "Loading multiple screens\n\n"+
            "Use RPCManager.cacheScreens() to preload screen definitions. Then call "+
            "RPCManager.createScreen() to instantiate a screen.\n\n"+
            "Best practices:\n"+
            "- Load all screens at startup with cacheScreens()\n"+
            "- Create screens lazily with createScreen()\n"+
            "- For huge apps, split cacheScreens() calls by feature group\n\n"+
            "Dynamic Component XML\n\n"+
            "Register a DynamicScreenGenerator using ScreenLoaderServlet.addDynamicScreenGenerator().\n"+
            "Example:\n"+
            "ScreenLoaderServlet.addDynamicScreenGenerator(new DynamicScreenGenerator() {\n"+
            "  public String getScreen(String id) {\n"+
            "    if (id.equals(\"testDynamicScreenPrefix3\")) return null;\n"+
            "    id = id.replace(\"testDynamicScreen\", \"\");\n"+
            "    return \"\";\n"+
            "  }\n"+
            "}, \"testDynamicScreenPrefix\");\n\n"+
            "Other approaches include JSP tags or XML.toJS():\n"+
            "<%@ taglib uri=\"http://www.smartclient.com/taglib\" prefix=\"isomorphic\" %>\n"+
            "<isomorphic:XML>...</isomorphic:XML>\n\n"+
            "Or server-side:\n"+
            "XML.toJS(\"<isomorphicXML xmlns:xsi=\\\"nativeType\\\">...<\/isomorphicXML>\");\n\n"+
            "For static screens, convert XML to JS as a build step and load it with loadScreen().\n\n"+
            "Troubleshooting\n\n"+
            "- XML parsing errors appear in server and Developer Console logs.\n"+
            "- Use the \"RPC\" tab to view screen loader responses.\n"+
            "- Use \"Eval XML\" in Developer Console > Results to preview and debug.\n\n"+
            "Localization\n\n"+
            "Use <fmt> tags in XML for i18n, as in DataSource files. See DataSource localization docs.\n\n"+
            "Custom Properties\n\n"+
            "<Canvas myProperty=\"false\"/> sets the string \"false\", which is truthy in JavaScript.\n"+
            "Use xsi:type to set type:\n"+
            "<myProperty xsi:type=\"xsd:boolean\">false</myProperty>\n\n"+
            "To define a nested component instance:\n"+
            "<myListGrid xsi:type=\"ListGrid\" width=\"500\" height=\"600\"/>\n\n"+
            "To define a config object (not an instance):\n"+
            "<listGridProperties xsi:type=\"ListGrid\" propertiesOnly=\"true\" width=\"500\" height=\"600\"/>\n\n"+
            "Custom Components\n\n"+
            "Define a class in JS with defineClass(), then use constructor in XML:\n"+
            "<ListGrid constructor=\"MyListGrid\" width=\"500\"/>\n\n"+
            "Component Schema\n\n"+
            "You can define a Component Schema to support Reify, instead of using constructor/xsi:type.",
        format:"markdown"
    }
},isc.aiHelpDocuments);
isc.registerHelpDocuments({
    "APIs list:Canvas":{
        topic:"APIs list for Canvas",
        content:"Only the following APIs are available on Canvas:\n"+
            "\n"+
            "## Attributes\n"+
            "* ID (GlobalId string)\n"+
            "* autoDraw (boolean)\n"+
            "* children (array of Canvas)\n"+
            "* peers (array of Canvas)\n"+
            "* htmlElement (DOMElement object | string)\n"+
            "* htmlPosition (DrawPosition string)\n"+
            "* matchElement (boolean)\n"+
            "* position (Positioning string)\n"+
            "* left (number | string)\n"+
            "* top (number | string)\n"+
            "* width (number | string)\n"+
            "* height (number | string)\n"+
            "* defaultWidth (integer)\n"+
            "* defaultHeight (integer)\n"+
            "* minWidth (number)\n"+
            "* minHeight (number)\n"+
            "* maxWidth (number)\n"+
            "* maxHeight (number)\n"+
            "* autoShowParent (boolean)\n"+
            "* visibility (Visibility string)\n"+
            "* canSelectText (boolean)\n"+
            "* styleName (CSSStyleName string)\n"+
            "* contents (HTML string)\n"+
            "* dynamicContents (boolean)\n"+
            "* dynamicContentsVars (ValueMap object)\n"+
            "* margin (number)\n"+
            "* padding (number)\n"+
            "* border (string)\n"+
            "* backgroundColor (CSSColor string)\n"+
            "* backgroundImage (SCImgURL string)\n"+
            "* backgroundRepeat (BackgroundRepeat string)\n"+
            "* appImgDir (URL string)\n"+
            "* skinImgDir (SCImgURL string)\n"+
            "* cursor (Cursor string)\n"+
            "* disabledCursor (Cursor string)\n"+
            "* opacity (number)\n"+
            "* overflow (Overflow string)\n"+
            "* showCustomScrollbars (boolean)\n"+
            "* scrollbarSize (number)\n"+
            "* disabled (boolean)\n"+
            "* visibleWhen (AdvancedCriteria object)\n"+
            "* enableWhen (AdvancedCriteria object)\n"+
            "* redrawOnResize (boolean)\n"+
            "* canFocus (boolean)\n"+
            "* tabIndex (number)\n"+
            "* accessKey (string)\n"+
            "* contextMenu (Menu)\n"+
            "* prompt (HTML string)\n"+
            "* canDrag (boolean)\n"+
            "* dragStartDistance (number)\n"+
            "* canDragScroll (boolean)\n"+
            "* dragScrollDelay (number)\n"+
            "* dragIntersectStyle (DragIntersectStyle string)\n"+
            "* canDragReposition (boolean)\n"+
            "* dragRepositionCursor (Cursor string)\n"+
            "* canDragResize (boolean)\n"+
            "* resizeFrom (array of EdgeName string)\n"+
            "* canHover (boolean)\n"+
            "* hoverDelay (number)\n"+
            "* showHover (boolean)\n"+
            "* hoverWidth (integer)\n"+
            "* hoverHeight (integer)\n"+
            "* hoverAlign (Alignment string)\n"+
            "* hoverVAlign (VerticalAlignment string)\n"+
            "* hoverWrap (boolean)\n"+
            "* hoverStyle (CSSStyleName string)\n"+
            "* hoverOpacity (number)\n"+
            "* hoverMoveWithMouse (boolean)\n"+
            "* edgeMarginSize (number)\n"+
            "* edgeCursorMap (object)\n"+
            "* keepInParentRect (boolean | array of integer)\n"+
            "* dragAppearance (DragAppearance string)\n"+
            "* dragType (string)\n"+
            "* dropTypes (array of string | string)\n"+
            "* dragTarget (Canvas | string)\n"+
            "* showDragShadow (boolean)\n"+
            "* dragOpacity (integer)\n"+
            "* canDrop (boolean)\n"+
            "* canAcceptDrop (boolean)\n"+
            "* canDropBefore (boolean)\n"+
            "* mouseStillDownInitialDelay (integer)\n"+
            "* mouseStillDownDelay (integer)\n"+
            "* doubleClickDelay (integer)\n"+
            "* noDoubleClicks (boolean)\n"+
            "* snapTo (string)\n"+
            "* snapOffsetLeft (integer)\n"+
            "* snapOffsetTop (integer)\n"+
            "* snapToGrid (boolean)\n"+
            "* snapResizeToGrid (boolean)\n"+
            "* childrenSnapToGrid (boolean)\n"+
            "* childrenSnapResizeToGrid (boolean)\n"+
            "* snapHGap (number)\n"+
            "* snapVGap (number)\n"+
            "* snapOnDrop (boolean)\n"+
            "* showPointer (boolean)\n"+
            "* pointerTarget (AutoTestLocator string | GlobalId string)\n"+
            "* pointerSettings (PointerSettings object)\n"+
            "* workflows (array of Process)\n"+
            "* borderRadius (string)\n"+
            "* showEdges (boolean)\n"+
            "* edgeSize (number)\n"+
            "* edgeOffset (number)\n"+
            "* edgeImage (SCImgURL string)\n"+
            "* customEdges (array of string)\n"+
            "* edgeBackgroundColor (CSSColor string)\n"+
            "* edgeOpacity (integer)\n"+
            "* edgeShowCenter (boolean)\n"+
            "* edgeCenterBackgroundColor (CSSColor string)\n"+
            "* showShadow (boolean)\n"+
            "* shadowDepth (number)\n"+
            "* shadowOffset (number)\n"+
            "* shadowSoftness (number)\n"+
            "* shadowImage (SCImgURL string)\n"+
            "* isGroup (boolean)\n"+
            "* groupTitle (HTML string)\n"+
            "* testDataContext (DataContext object)\n"+
            "* autoPopulateData (boolean)\n"+
            "* ruleScope (string)\n"+
            "* isRuleScope (boolean)\n"+
            "* valuesManager (ValuesManager | GlobalId string)\n"+
            "* dataPath (DataPath string)\n"+
            "* animateTime (number)\n"+
            "* animateAcceleration (AnimationAcceleration string)\n"+
            "* animateMoveTime (number)\n"+
            "* animateResizeTime (number)\n"+
            "* animateRectTime (number)\n"+
            "* animateFadeTime (number)\n"+
            "* animateScrollTime (number)\n"+
            "* animateShowTime (number)\n"+
            "* animateHideTime (number)\n"+
            "* animateMoveAcceleration (AnimationAcceleration string)\n"+
            "* animateResizeAcceleration (AnimationAcceleration string)\n"+
            "* animateRectAcceleration (AnimationAcceleration string)\n"+
            "* animateScrollAcceleration (AnimationAcceleration string)\n"+
            "* animateShowAcceleration (AnimationAcceleration string)\n"+
            "* animateHideAcceleration (AnimationAcceleration string)\n"+
            "* layoutAlign (Alignment string | VerticalAlignment string)\n"+
            "* showResizeBar (boolean)\n"+
            "* resizeBarTarget (string)\n"+
            "* extraSpace (positive integer)\n"+
            "\n"+
            "## Methods\n"+
            "* showNextTo()\n"+
            "* show()\n"+
            "* hide()\n"+
            "* print()\n",
        format:"Markdown"
    },
    "APIs list:Layout":{
        topic:"APIs list for Layout",
        content:"Only the following APIs are available on Layout:\n"+
            "\n"+
            "## Attributes\n"+
            "* members (array of Canvas)\n"+
            "* overflow (Overflow string)\n"+
            "* vertical (boolean)\n"+
            "* vPolicy (LayoutPolicy string)\n"+
            "* hPolicy (LayoutPolicy string)\n"+
            "* minMemberLength (integer)\n"+
            "* minBreadthMember (string | integer | Canvas)\n"+
            "* enforcePolicy (boolean)\n"+
            "* defaultLayoutAlign (Alignment string | VerticalAlignment string)\n"+
            "* align (Alignment string | VerticalAlignment string)\n"+
            "* reverseOrder (boolean)\n"+
            "* paddingAsLayoutMargin (boolean)\n"+
            "* layoutMargin (integer)\n"+
            "* layoutLeftMargin (integer)\n"+
            "* layoutRightMargin (integer)\n"+
            "* layoutTopMargin (integer)\n"+
            "* layoutBottomMargin (integer)\n"+
            "* membersMargin (integer)\n"+
            "* leaveScrollbarGap (boolean)\n"+
            "* resizeBarClass (string)\n"+
            "* resizeBarSize (integer)\n"+
            "* animateMembers (boolean)\n"+
            "* animateMemberTime (number)\n"+
            "* canDropComponents (boolean)\n"+
            "* dropLineThickness (number)\n"+
            "* showDragPlaceHolder (boolean)\n"+
            "* placeHolderProperties (Canvas properties object)\n"+
            "* placeHolderDefaults (Canvas properties object)\n"+
            "\n"+
            "## Inherited from Canvas\n"+
            "\n"+
            "### Attributes\n"+
            "* ID (GlobalId string)\n"+
            "* autoDraw (boolean)\n"+
            "* children (array of Canvas)\n"+
            "* peers (array of Canvas)\n"+
            "* htmlElement (DOMElement object | string)\n"+
            "* htmlPosition (DrawPosition string)\n"+
            "* matchElement (boolean)\n"+
            "* position (Positioning string)\n"+
            "* left (number | string)\n"+
            "* top (number | string)\n"+
            "* width (number | string)\n"+
            "* height (number | string)\n"+
            "* defaultWidth (integer)\n"+
            "* defaultHeight (integer)\n"+
            "* minWidth (number)\n"+
            "* minHeight (number)\n"+
            "* maxWidth (number)\n"+
            "* maxHeight (number)\n"+
            "* autoShowParent (boolean)\n"+
            "* visibility (Visibility string)\n"+
            "* canSelectText (boolean)\n"+
            "* styleName (CSSStyleName string)\n"+
            "* contents (HTML string)\n"+
            "* dynamicContents (boolean)\n"+
            "* dynamicContentsVars (ValueMap object)\n"+
            "* margin (number)\n"+
            "* padding (number)\n"+
            "* border (string)\n"+
            "* backgroundColor (CSSColor string)\n"+
            "* backgroundImage (SCImgURL string)\n"+
            "* backgroundRepeat (BackgroundRepeat string)\n"+
            "* appImgDir (URL string)\n"+
            "* skinImgDir (SCImgURL string)\n"+
            "* cursor (Cursor string)\n"+
            "* disabledCursor (Cursor string)\n"+
            "* opacity (number)\n"+
            "* showCustomScrollbars (boolean)\n"+
            "* scrollbarSize (number)\n"+
            "* disabled (boolean)\n"+
            "* visibleWhen (AdvancedCriteria object)\n"+
            "* enableWhen (AdvancedCriteria object)\n"+
            "* redrawOnResize (boolean)\n"+
            "* canFocus (boolean)\n"+
            "* tabIndex (number)\n"+
            "* accessKey (string)\n"+
            "* contextMenu (Menu)\n"+
            "* prompt (HTML string)\n"+
            "* canDrag (boolean)\n"+
            "* dragStartDistance (number)\n"+
            "* canDragScroll (boolean)\n"+
            "* dragScrollDelay (number)\n"+
            "* dragIntersectStyle (DragIntersectStyle string)\n"+
            "* canDragReposition (boolean)\n"+
            "* dragRepositionCursor (Cursor string)\n"+
            "* canDragResize (boolean)\n"+
            "* resizeFrom (array of EdgeName string)\n"+
            "* canHover (boolean)\n"+
            "* hoverDelay (number)\n"+
            "* showHover (boolean)\n"+
            "* hoverWidth (integer)\n"+
            "* hoverHeight (integer)\n"+
            "* hoverAlign (Alignment string)\n"+
            "* hoverVAlign (VerticalAlignment string)\n"+
            "* hoverWrap (boolean)\n"+
            "* hoverStyle (CSSStyleName string)\n"+
            "* hoverOpacity (number)\n"+
            "* hoverMoveWithMouse (boolean)\n"+
            "* edgeMarginSize (number)\n"+
            "* edgeCursorMap (object)\n"+
            "* keepInParentRect (boolean | array of integer)\n"+
            "* dragAppearance (DragAppearance string)\n"+
            "* dragType (string)\n"+
            "* dropTypes (array of string | string)\n"+
            "* dragTarget (Canvas | string)\n"+
            "* showDragShadow (boolean)\n"+
            "* dragOpacity (integer)\n"+
            "* canDrop (boolean)\n"+
            "* canAcceptDrop (boolean)\n"+
            "* canDropBefore (boolean)\n"+
            "* mouseStillDownInitialDelay (integer)\n"+
            "* mouseStillDownDelay (integer)\n"+
            "* doubleClickDelay (integer)\n"+
            "* noDoubleClicks (boolean)\n"+
            "* snapTo (string)\n"+
            "* snapOffsetLeft (integer)\n"+
            "* snapOffsetTop (integer)\n"+
            "* snapToGrid (boolean)\n"+
            "* snapResizeToGrid (boolean)\n"+
            "* childrenSnapToGrid (boolean)\n"+
            "* childrenSnapResizeToGrid (boolean)\n"+
            "* snapHGap (number)\n"+
            "* snapVGap (number)\n"+
            "* snapOnDrop (boolean)\n"+
            "* showPointer (boolean)\n"+
            "* pointerTarget (AutoTestLocator string | GlobalId string)\n"+
            "* pointerSettings (PointerSettings object)\n"+
            "* workflows (array of Process)\n"+
            "* borderRadius (string)\n"+
            "* showEdges (boolean)\n"+
            "* edgeSize (number)\n"+
            "* edgeOffset (number)\n"+
            "* edgeImage (SCImgURL string)\n"+
            "* customEdges (array of string)\n"+
            "* edgeBackgroundColor (CSSColor string)\n"+
            "* edgeOpacity (integer)\n"+
            "* edgeShowCenter (boolean)\n"+
            "* edgeCenterBackgroundColor (CSSColor string)\n"+
            "* showShadow (boolean)\n"+
            "* shadowDepth (number)\n"+
            "* shadowOffset (number)\n"+
            "* shadowSoftness (number)\n"+
            "* shadowImage (SCImgURL string)\n"+
            "* isGroup (boolean)\n"+
            "* groupTitle (HTML string)\n"+
            "* testDataContext (DataContext object)\n"+
            "* autoPopulateData (boolean)\n"+
            "* ruleScope (string)\n"+
            "* isRuleScope (boolean)\n"+
            "* valuesManager (ValuesManager | GlobalId string)\n"+
            "* dataPath (DataPath string)\n"+
            "* animateTime (number)\n"+
            "* animateAcceleration (AnimationAcceleration string)\n"+
            "* animateMoveTime (number)\n"+
            "* animateResizeTime (number)\n"+
            "* animateRectTime (number)\n"+
            "* animateFadeTime (number)\n"+
            "* animateScrollTime (number)\n"+
            "* animateShowTime (number)\n"+
            "* animateHideTime (number)\n"+
            "* animateMoveAcceleration (AnimationAcceleration string)\n"+
            "* animateResizeAcceleration (AnimationAcceleration string)\n"+
            "* animateRectAcceleration (AnimationAcceleration string)\n"+
            "* animateScrollAcceleration (AnimationAcceleration string)\n"+
            "* animateShowAcceleration (AnimationAcceleration string)\n"+
            "* animateHideAcceleration (AnimationAcceleration string)\n"+
            "* layoutAlign (Alignment string | VerticalAlignment string)\n"+
            "* showResizeBar (boolean)\n"+
            "* resizeBarTarget (string)\n"+
            "* extraSpace (positive integer)\n"+
            "\n"+
            "### Methods\n"+
            "* showNextTo()\n"+
            "* show()\n"+
            "* hide()\n"+
            "* print()\n",
        format:"Markdown"
    },
    "APIs list:HLayout":{
        topic:"APIs list for HLayout",
        content:"Only the following APIs are available on HLayout:\n"+
            "\n"+
            "## Inherited from Layout\n"+
            "\n"+
            "### Attributes\n"+
            "* members (array of Canvas)\n"+
            "* overflow (Overflow string)\n"+
            "* vertical (boolean)\n"+
            "* vPolicy (LayoutPolicy string)\n"+
            "* hPolicy (LayoutPolicy string)\n"+
            "* minMemberLength (integer)\n"+
            "* minBreadthMember (string | integer | Canvas)\n"+
            "* enforcePolicy (boolean)\n"+
            "* defaultLayoutAlign (Alignment string | VerticalAlignment string)\n"+
            "* align (Alignment string | VerticalAlignment string)\n"+
            "* reverseOrder (boolean)\n"+
            "* paddingAsLayoutMargin (boolean)\n"+
            "* layoutMargin (integer)\n"+
            "* layoutLeftMargin (integer)\n"+
            "* layoutRightMargin (integer)\n"+
            "* layoutTopMargin (integer)\n"+
            "* layoutBottomMargin (integer)\n"+
            "* membersMargin (integer)\n"+
            "* leaveScrollbarGap (boolean)\n"+
            "* resizeBarClass (string)\n"+
            "* resizeBarSize (integer)\n"+
            "* animateMembers (boolean)\n"+
            "* animateMemberTime (number)\n"+
            "* canDropComponents (boolean)\n"+
            "* dropLineThickness (number)\n"+
            "* showDragPlaceHolder (boolean)\n"+
            "* placeHolderProperties (Canvas properties object)\n"+
            "* placeHolderDefaults (Canvas properties object)\n"+
            "\n"+
            "## Inherited from Canvas\n"+
            "\n"+
            "### Attributes\n"+
            "* ID (GlobalId string)\n"+
            "* autoDraw (boolean)\n"+
            "* children (array of Canvas)\n"+
            "* peers (array of Canvas)\n"+
            "* htmlElement (DOMElement object | string)\n"+
            "* htmlPosition (DrawPosition string)\n"+
            "* matchElement (boolean)\n"+
            "* position (Positioning string)\n"+
            "* left (number | string)\n"+
            "* top (number | string)\n"+
            "* width (number | string)\n"+
            "* height (number | string)\n"+
            "* defaultWidth (integer)\n"+
            "* defaultHeight (integer)\n"+
            "* minWidth (number)\n"+
            "* minHeight (number)\n"+
            "* maxWidth (number)\n"+
            "* maxHeight (number)\n"+
            "* autoShowParent (boolean)\n"+
            "* visibility (Visibility string)\n"+
            "* canSelectText (boolean)\n"+
            "* styleName (CSSStyleName string)\n"+
            "* contents (HTML string)\n"+
            "* dynamicContents (boolean)\n"+
            "* dynamicContentsVars (ValueMap object)\n"+
            "* margin (number)\n"+
            "* padding (number)\n"+
            "* border (string)\n"+
            "* backgroundColor (CSSColor string)\n"+
            "* backgroundImage (SCImgURL string)\n"+
            "* backgroundRepeat (BackgroundRepeat string)\n"+
            "* appImgDir (URL string)\n"+
            "* skinImgDir (SCImgURL string)\n"+
            "* cursor (Cursor string)\n"+
            "* disabledCursor (Cursor string)\n"+
            "* opacity (number)\n"+
            "* showCustomScrollbars (boolean)\n"+
            "* scrollbarSize (number)\n"+
            "* disabled (boolean)\n"+
            "* visibleWhen (AdvancedCriteria object)\n"+
            "* enableWhen (AdvancedCriteria object)\n"+
            "* redrawOnResize (boolean)\n"+
            "* canFocus (boolean)\n"+
            "* tabIndex (number)\n"+
            "* accessKey (string)\n"+
            "* contextMenu (Menu)\n"+
            "* prompt (HTML string)\n"+
            "* canDrag (boolean)\n"+
            "* dragStartDistance (number)\n"+
            "* canDragScroll (boolean)\n"+
            "* dragScrollDelay (number)\n"+
            "* dragIntersectStyle (DragIntersectStyle string)\n"+
            "* canDragReposition (boolean)\n"+
            "* dragRepositionCursor (Cursor string)\n"+
            "* canDragResize (boolean)\n"+
            "* resizeFrom (array of EdgeName string)\n"+
            "* canHover (boolean)\n"+
            "* hoverDelay (number)\n"+
            "* showHover (boolean)\n"+
            "* hoverWidth (integer)\n"+
            "* hoverHeight (integer)\n"+
            "* hoverAlign (Alignment string)\n"+
            "* hoverVAlign (VerticalAlignment string)\n"+
            "* hoverWrap (boolean)\n"+
            "* hoverStyle (CSSStyleName string)\n"+
            "* hoverOpacity (number)\n"+
            "* hoverMoveWithMouse (boolean)\n"+
            "* edgeMarginSize (number)\n"+
            "* edgeCursorMap (object)\n"+
            "* keepInParentRect (boolean | array of integer)\n"+
            "* dragAppearance (DragAppearance string)\n"+
            "* dragType (string)\n"+
            "* dropTypes (array of string | string)\n"+
            "* dragTarget (Canvas | string)\n"+
            "* showDragShadow (boolean)\n"+
            "* dragOpacity (integer)\n"+
            "* canDrop (boolean)\n"+
            "* canAcceptDrop (boolean)\n"+
            "* canDropBefore (boolean)\n"+
            "* mouseStillDownInitialDelay (integer)\n"+
            "* mouseStillDownDelay (integer)\n"+
            "* doubleClickDelay (integer)\n"+
            "* noDoubleClicks (boolean)\n"+
            "* snapTo (string)\n"+
            "* snapOffsetLeft (integer)\n"+
            "* snapOffsetTop (integer)\n"+
            "* snapToGrid (boolean)\n"+
            "* snapResizeToGrid (boolean)\n"+
            "* childrenSnapToGrid (boolean)\n"+
            "* childrenSnapResizeToGrid (boolean)\n"+
            "* snapHGap (number)\n"+
            "* snapVGap (number)\n"+
            "* snapOnDrop (boolean)\n"+
            "* showPointer (boolean)\n"+
            "* pointerTarget (AutoTestLocator string | GlobalId string)\n"+
            "* pointerSettings (PointerSettings object)\n"+
            "* workflows (array of Process)\n"+
            "* borderRadius (string)\n"+
            "* showEdges (boolean)\n"+
            "* edgeSize (number)\n"+
            "* edgeOffset (number)\n"+
            "* edgeImage (SCImgURL string)\n"+
            "* customEdges (array of string)\n"+
            "* edgeBackgroundColor (CSSColor string)\n"+
            "* edgeOpacity (integer)\n"+
            "* edgeShowCenter (boolean)\n"+
            "* edgeCenterBackgroundColor (CSSColor string)\n"+
            "* showShadow (boolean)\n"+
            "* shadowDepth (number)\n"+
            "* shadowOffset (number)\n"+
            "* shadowSoftness (number)\n"+
            "* shadowImage (SCImgURL string)\n"+
            "* isGroup (boolean)\n"+
            "* groupTitle (HTML string)\n"+
            "* testDataContext (DataContext object)\n"+
            "* autoPopulateData (boolean)\n"+
            "* ruleScope (string)\n"+
            "* isRuleScope (boolean)\n"+
            "* valuesManager (ValuesManager | GlobalId string)\n"+
            "* dataPath (DataPath string)\n"+
            "* animateTime (number)\n"+
            "* animateAcceleration (AnimationAcceleration string)\n"+
            "* animateMoveTime (number)\n"+
            "* animateResizeTime (number)\n"+
            "* animateRectTime (number)\n"+
            "* animateFadeTime (number)\n"+
            "* animateScrollTime (number)\n"+
            "* animateShowTime (number)\n"+
            "* animateHideTime (number)\n"+
            "* animateMoveAcceleration (AnimationAcceleration string)\n"+
            "* animateResizeAcceleration (AnimationAcceleration string)\n"+
            "* animateRectAcceleration (AnimationAcceleration string)\n"+
            "* animateScrollAcceleration (AnimationAcceleration string)\n"+
            "* animateShowAcceleration (AnimationAcceleration string)\n"+
            "* animateHideAcceleration (AnimationAcceleration string)\n"+
            "* layoutAlign (Alignment string | VerticalAlignment string)\n"+
            "* showResizeBar (boolean)\n"+
            "* resizeBarTarget (string)\n"+
            "* extraSpace (positive integer)\n"+
            "\n"+
            "### Methods\n"+
            "* showNextTo()\n"+
            "* show()\n"+
            "* hide()\n"+
            "* print()\n",
        format:"Markdown"
    },
    "APIs list:VLayout":{
        topic:"APIs list for VLayout",
        content:"Only the following APIs are available on VLayout:\n"+
            "\n"+
            "## Inherited from Layout\n"+
            "\n"+
            "### Attributes\n"+
            "* members (array of Canvas)\n"+
            "* overflow (Overflow string)\n"+
            "* vertical (boolean)\n"+
            "* vPolicy (LayoutPolicy string)\n"+
            "* hPolicy (LayoutPolicy string)\n"+
            "* minMemberLength (integer)\n"+
            "* minBreadthMember (string | integer | Canvas)\n"+
            "* enforcePolicy (boolean)\n"+
            "* defaultLayoutAlign (Alignment string | VerticalAlignment string)\n"+
            "* align (Alignment string | VerticalAlignment string)\n"+
            "* reverseOrder (boolean)\n"+
            "* paddingAsLayoutMargin (boolean)\n"+
            "* layoutMargin (integer)\n"+
            "* layoutLeftMargin (integer)\n"+
            "* layoutRightMargin (integer)\n"+
            "* layoutTopMargin (integer)\n"+
            "* layoutBottomMargin (integer)\n"+
            "* membersMargin (integer)\n"+
            "* leaveScrollbarGap (boolean)\n"+
            "* resizeBarClass (string)\n"+
            "* resizeBarSize (integer)\n"+
            "* animateMembers (boolean)\n"+
            "* animateMemberTime (number)\n"+
            "* canDropComponents (boolean)\n"+
            "* dropLineThickness (number)\n"+
            "* showDragPlaceHolder (boolean)\n"+
            "* placeHolderProperties (Canvas properties object)\n"+
            "* placeHolderDefaults (Canvas properties object)\n"+
            "\n"+
            "## Inherited from Canvas\n"+
            "\n"+
            "### Attributes\n"+
            "* ID (GlobalId string)\n"+
            "* autoDraw (boolean)\n"+
            "* children (array of Canvas)\n"+
            "* peers (array of Canvas)\n"+
            "* htmlElement (DOMElement object | string)\n"+
            "* htmlPosition (DrawPosition string)\n"+
            "* matchElement (boolean)\n"+
            "* position (Positioning string)\n"+
            "* left (number | string)\n"+
            "* top (number | string)\n"+
            "* width (number | string)\n"+
            "* height (number | string)\n"+
            "* defaultWidth (integer)\n"+
            "* defaultHeight (integer)\n"+
            "* minWidth (number)\n"+
            "* minHeight (number)\n"+
            "* maxWidth (number)\n"+
            "* maxHeight (number)\n"+
            "* autoShowParent (boolean)\n"+
            "* visibility (Visibility string)\n"+
            "* canSelectText (boolean)\n"+
            "* styleName (CSSStyleName string)\n"+
            "* contents (HTML string)\n"+
            "* dynamicContents (boolean)\n"+
            "* dynamicContentsVars (ValueMap object)\n"+
            "* margin (number)\n"+
            "* padding (number)\n"+
            "* border (string)\n"+
            "* backgroundColor (CSSColor string)\n"+
            "* backgroundImage (SCImgURL string)\n"+
            "* backgroundRepeat (BackgroundRepeat string)\n"+
            "* appImgDir (URL string)\n"+
            "* skinImgDir (SCImgURL string)\n"+
            "* cursor (Cursor string)\n"+
            "* disabledCursor (Cursor string)\n"+
            "* opacity (number)\n"+
            "* showCustomScrollbars (boolean)\n"+
            "* scrollbarSize (number)\n"+
            "* disabled (boolean)\n"+
            "* visibleWhen (AdvancedCriteria object)\n"+
            "* enableWhen (AdvancedCriteria object)\n"+
            "* redrawOnResize (boolean)\n"+
            "* canFocus (boolean)\n"+
            "* tabIndex (number)\n"+
            "* accessKey (string)\n"+
            "* contextMenu (Menu)\n"+
            "* prompt (HTML string)\n"+
            "* canDrag (boolean)\n"+
            "* dragStartDistance (number)\n"+
            "* canDragScroll (boolean)\n"+
            "* dragScrollDelay (number)\n"+
            "* dragIntersectStyle (DragIntersectStyle string)\n"+
            "* canDragReposition (boolean)\n"+
            "* dragRepositionCursor (Cursor string)\n"+
            "* canDragResize (boolean)\n"+
            "* resizeFrom (array of EdgeName string)\n"+
            "* canHover (boolean)\n"+
            "* hoverDelay (number)\n"+
            "* showHover (boolean)\n"+
            "* hoverWidth (integer)\n"+
            "* hoverHeight (integer)\n"+
            "* hoverAlign (Alignment string)\n"+
            "* hoverVAlign (VerticalAlignment string)\n"+
            "* hoverWrap (boolean)\n"+
            "* hoverStyle (CSSStyleName string)\n"+
            "* hoverOpacity (number)\n"+
            "* hoverMoveWithMouse (boolean)\n"+
            "* edgeMarginSize (number)\n"+
            "* edgeCursorMap (object)\n"+
            "* keepInParentRect (boolean | array of integer)\n"+
            "* dragAppearance (DragAppearance string)\n"+
            "* dragType (string)\n"+
            "* dropTypes (array of string | string)\n"+
            "* dragTarget (Canvas | string)\n"+
            "* showDragShadow (boolean)\n"+
            "* dragOpacity (integer)\n"+
            "* canDrop (boolean)\n"+
            "* canAcceptDrop (boolean)\n"+
            "* canDropBefore (boolean)\n"+
            "* mouseStillDownInitialDelay (integer)\n"+
            "* mouseStillDownDelay (integer)\n"+
            "* doubleClickDelay (integer)\n"+
            "* noDoubleClicks (boolean)\n"+
            "* snapTo (string)\n"+
            "* snapOffsetLeft (integer)\n"+
            "* snapOffsetTop (integer)\n"+
            "* snapToGrid (boolean)\n"+
            "* snapResizeToGrid (boolean)\n"+
            "* childrenSnapToGrid (boolean)\n"+
            "* childrenSnapResizeToGrid (boolean)\n"+
            "* snapHGap (number)\n"+
            "* snapVGap (number)\n"+
            "* snapOnDrop (boolean)\n"+
            "* showPointer (boolean)\n"+
            "* pointerTarget (AutoTestLocator string | GlobalId string)\n"+
            "* pointerSettings (PointerSettings object)\n"+
            "* workflows (array of Process)\n"+
            "* borderRadius (string)\n"+
            "* showEdges (boolean)\n"+
            "* edgeSize (number)\n"+
            "* edgeOffset (number)\n"+
            "* edgeImage (SCImgURL string)\n"+
            "* customEdges (array of string)\n"+
            "* edgeBackgroundColor (CSSColor string)\n"+
            "* edgeOpacity (integer)\n"+
            "* edgeShowCenter (boolean)\n"+
            "* edgeCenterBackgroundColor (CSSColor string)\n"+
            "* showShadow (boolean)\n"+
            "* shadowDepth (number)\n"+
            "* shadowOffset (number)\n"+
            "* shadowSoftness (number)\n"+
            "* shadowImage (SCImgURL string)\n"+
            "* isGroup (boolean)\n"+
            "* groupTitle (HTML string)\n"+
            "* testDataContext (DataContext object)\n"+
            "* autoPopulateData (boolean)\n"+
            "* ruleScope (string)\n"+
            "* isRuleScope (boolean)\n"+
            "* valuesManager (ValuesManager | GlobalId string)\n"+
            "* dataPath (DataPath string)\n"+
            "* animateTime (number)\n"+
            "* animateAcceleration (AnimationAcceleration string)\n"+
            "* animateMoveTime (number)\n"+
            "* animateResizeTime (number)\n"+
            "* animateRectTime (number)\n"+
            "* animateFadeTime (number)\n"+
            "* animateScrollTime (number)\n"+
            "* animateShowTime (number)\n"+
            "* animateHideTime (number)\n"+
            "* animateMoveAcceleration (AnimationAcceleration string)\n"+
            "* animateResizeAcceleration (AnimationAcceleration string)\n"+
            "* animateRectAcceleration (AnimationAcceleration string)\n"+
            "* animateScrollAcceleration (AnimationAcceleration string)\n"+
            "* animateShowAcceleration (AnimationAcceleration string)\n"+
            "* animateHideAcceleration (AnimationAcceleration string)\n"+
            "* layoutAlign (Alignment string | VerticalAlignment string)\n"+
            "* showResizeBar (boolean)\n"+
            "* resizeBarTarget (string)\n"+
            "* extraSpace (positive integer)\n"+
            "\n"+
            "### Methods\n"+
            "* showNextTo()\n"+
            "* show()\n"+
            "* hide()\n"+
            "* print()\n",
        format:"Markdown"
    },
    "APIs list:HStack":{
        topic:"APIs list for HStack",
        content:"Only the following APIs are available on HStack:\n"+
            "\n"+
            "## Inherited from Layout\n"+
            "\n"+
            "### Attributes\n"+
            "* members (array of Canvas)\n"+
            "* overflow (Overflow string)\n"+
            "* vertical (boolean)\n"+
            "* vPolicy (LayoutPolicy string)\n"+
            "* hPolicy (LayoutPolicy string)\n"+
            "* minMemberLength (integer)\n"+
            "* minBreadthMember (string | integer | Canvas)\n"+
            "* enforcePolicy (boolean)\n"+
            "* defaultLayoutAlign (Alignment string | VerticalAlignment string)\n"+
            "* align (Alignment string | VerticalAlignment string)\n"+
            "* reverseOrder (boolean)\n"+
            "* paddingAsLayoutMargin (boolean)\n"+
            "* layoutMargin (integer)\n"+
            "* layoutLeftMargin (integer)\n"+
            "* layoutRightMargin (integer)\n"+
            "* layoutTopMargin (integer)\n"+
            "* layoutBottomMargin (integer)\n"+
            "* membersMargin (integer)\n"+
            "* leaveScrollbarGap (boolean)\n"+
            "* resizeBarClass (string)\n"+
            "* resizeBarSize (integer)\n"+
            "* animateMembers (boolean)\n"+
            "* animateMemberTime (number)\n"+
            "* canDropComponents (boolean)\n"+
            "* dropLineThickness (number)\n"+
            "* showDragPlaceHolder (boolean)\n"+
            "* placeHolderProperties (Canvas properties object)\n"+
            "* placeHolderDefaults (Canvas properties object)\n"+
            "\n"+
            "## Inherited from Canvas\n"+
            "\n"+
            "### Attributes\n"+
            "* ID (GlobalId string)\n"+
            "* autoDraw (boolean)\n"+
            "* children (array of Canvas)\n"+
            "* peers (array of Canvas)\n"+
            "* htmlElement (DOMElement object | string)\n"+
            "* htmlPosition (DrawPosition string)\n"+
            "* matchElement (boolean)\n"+
            "* position (Positioning string)\n"+
            "* left (number | string)\n"+
            "* top (number | string)\n"+
            "* width (number | string)\n"+
            "* height (number | string)\n"+
            "* defaultWidth (integer)\n"+
            "* defaultHeight (integer)\n"+
            "* minWidth (number)\n"+
            "* minHeight (number)\n"+
            "* maxWidth (number)\n"+
            "* maxHeight (number)\n"+
            "* autoShowParent (boolean)\n"+
            "* visibility (Visibility string)\n"+
            "* canSelectText (boolean)\n"+
            "* styleName (CSSStyleName string)\n"+
            "* contents (HTML string)\n"+
            "* dynamicContents (boolean)\n"+
            "* dynamicContentsVars (ValueMap object)\n"+
            "* margin (number)\n"+
            "* padding (number)\n"+
            "* border (string)\n"+
            "* backgroundColor (CSSColor string)\n"+
            "* backgroundImage (SCImgURL string)\n"+
            "* backgroundRepeat (BackgroundRepeat string)\n"+
            "* appImgDir (URL string)\n"+
            "* skinImgDir (SCImgURL string)\n"+
            "* cursor (Cursor string)\n"+
            "* disabledCursor (Cursor string)\n"+
            "* opacity (number)\n"+
            "* showCustomScrollbars (boolean)\n"+
            "* scrollbarSize (number)\n"+
            "* disabled (boolean)\n"+
            "* visibleWhen (AdvancedCriteria object)\n"+
            "* enableWhen (AdvancedCriteria object)\n"+
            "* redrawOnResize (boolean)\n"+
            "* canFocus (boolean)\n"+
            "* tabIndex (number)\n"+
            "* accessKey (string)\n"+
            "* contextMenu (Menu)\n"+
            "* prompt (HTML string)\n"+
            "* canDrag (boolean)\n"+
            "* dragStartDistance (number)\n"+
            "* canDragScroll (boolean)\n"+
            "* dragScrollDelay (number)\n"+
            "* dragIntersectStyle (DragIntersectStyle string)\n"+
            "* canDragReposition (boolean)\n"+
            "* dragRepositionCursor (Cursor string)\n"+
            "* canDragResize (boolean)\n"+
            "* resizeFrom (array of EdgeName string)\n"+
            "* canHover (boolean)\n"+
            "* hoverDelay (number)\n"+
            "* showHover (boolean)\n"+
            "* hoverWidth (integer)\n"+
            "* hoverHeight (integer)\n"+
            "* hoverAlign (Alignment string)\n"+
            "* hoverVAlign (VerticalAlignment string)\n"+
            "* hoverWrap (boolean)\n"+
            "* hoverStyle (CSSStyleName string)\n"+
            "* hoverOpacity (number)\n"+
            "* hoverMoveWithMouse (boolean)\n"+
            "* edgeMarginSize (number)\n"+
            "* edgeCursorMap (object)\n"+
            "* keepInParentRect (boolean | array of integer)\n"+
            "* dragAppearance (DragAppearance string)\n"+
            "* dragType (string)\n"+
            "* dropTypes (array of string | string)\n"+
            "* dragTarget (Canvas | string)\n"+
            "* showDragShadow (boolean)\n"+
            "* dragOpacity (integer)\n"+
            "* canDrop (boolean)\n"+
            "* canAcceptDrop (boolean)\n"+
            "* canDropBefore (boolean)\n"+
            "* mouseStillDownInitialDelay (integer)\n"+
            "* mouseStillDownDelay (integer)\n"+
            "* doubleClickDelay (integer)\n"+
            "* noDoubleClicks (boolean)\n"+
            "* snapTo (string)\n"+
            "* snapOffsetLeft (integer)\n"+
            "* snapOffsetTop (integer)\n"+
            "* snapToGrid (boolean)\n"+
            "* snapResizeToGrid (boolean)\n"+
            "* childrenSnapToGrid (boolean)\n"+
            "* childrenSnapResizeToGrid (boolean)\n"+
            "* snapHGap (number)\n"+
            "* snapVGap (number)\n"+
            "* snapOnDrop (boolean)\n"+
            "* showPointer (boolean)\n"+
            "* pointerTarget (AutoTestLocator string | GlobalId string)\n"+
            "* pointerSettings (PointerSettings object)\n"+
            "* workflows (array of Process)\n"+
            "* borderRadius (string)\n"+
            "* showEdges (boolean)\n"+
            "* edgeSize (number)\n"+
            "* edgeOffset (number)\n"+
            "* edgeImage (SCImgURL string)\n"+
            "* customEdges (array of string)\n"+
            "* edgeBackgroundColor (CSSColor string)\n"+
            "* edgeOpacity (integer)\n"+
            "* edgeShowCenter (boolean)\n"+
            "* edgeCenterBackgroundColor (CSSColor string)\n"+
            "* showShadow (boolean)\n"+
            "* shadowDepth (number)\n"+
            "* shadowOffset (number)\n"+
            "* shadowSoftness (number)\n"+
            "* shadowImage (SCImgURL string)\n"+
            "* isGroup (boolean)\n"+
            "* groupTitle (HTML string)\n"+
            "* testDataContext (DataContext object)\n"+
            "* autoPopulateData (boolean)\n"+
            "* ruleScope (string)\n"+
            "* isRuleScope (boolean)\n"+
            "* valuesManager (ValuesManager | GlobalId string)\n"+
            "* dataPath (DataPath string)\n"+
            "* animateTime (number)\n"+
            "* animateAcceleration (AnimationAcceleration string)\n"+
            "* animateMoveTime (number)\n"+
            "* animateResizeTime (number)\n"+
            "* animateRectTime (number)\n"+
            "* animateFadeTime (number)\n"+
            "* animateScrollTime (number)\n"+
            "* animateShowTime (number)\n"+
            "* animateHideTime (number)\n"+
            "* animateMoveAcceleration (AnimationAcceleration string)\n"+
            "* animateResizeAcceleration (AnimationAcceleration string)\n"+
            "* animateRectAcceleration (AnimationAcceleration string)\n"+
            "* animateScrollAcceleration (AnimationAcceleration string)\n"+
            "* animateShowAcceleration (AnimationAcceleration string)\n"+
            "* animateHideAcceleration (AnimationAcceleration string)\n"+
            "* layoutAlign (Alignment string | VerticalAlignment string)\n"+
            "* showResizeBar (boolean)\n"+
            "* resizeBarTarget (string)\n"+
            "* extraSpace (positive integer)\n"+
            "\n"+
            "### Methods\n"+
            "* showNextTo()\n"+
            "* show()\n"+
            "* hide()\n"+
            "* print()\n",
        format:"Markdown"
    },
    "APIs list:VStack":{
        topic:"APIs list for VStack",
        content:"Only the following APIs are available on VStack:\n"+
            "\n"+
            "## Inherited from Layout\n"+
            "\n"+
            "### Attributes\n"+
            "* members (array of Canvas)\n"+
            "* overflow (Overflow string)\n"+
            "* vertical (boolean)\n"+
            "* vPolicy (LayoutPolicy string)\n"+
            "* hPolicy (LayoutPolicy string)\n"+
            "* minMemberLength (integer)\n"+
            "* minBreadthMember (string | integer | Canvas)\n"+
            "* enforcePolicy (boolean)\n"+
            "* defaultLayoutAlign (Alignment string | VerticalAlignment string)\n"+
            "* align (Alignment string | VerticalAlignment string)\n"+
            "* reverseOrder (boolean)\n"+
            "* paddingAsLayoutMargin (boolean)\n"+
            "* layoutMargin (integer)\n"+
            "* layoutLeftMargin (integer)\n"+
            "* layoutRightMargin (integer)\n"+
            "* layoutTopMargin (integer)\n"+
            "* layoutBottomMargin (integer)\n"+
            "* membersMargin (integer)\n"+
            "* leaveScrollbarGap (boolean)\n"+
            "* resizeBarClass (string)\n"+
            "* resizeBarSize (integer)\n"+
            "* animateMembers (boolean)\n"+
            "* animateMemberTime (number)\n"+
            "* canDropComponents (boolean)\n"+
            "* dropLineThickness (number)\n"+
            "* showDragPlaceHolder (boolean)\n"+
            "* placeHolderProperties (Canvas properties object)\n"+
            "* placeHolderDefaults (Canvas properties object)\n"+
            "\n"+
            "## Inherited from Canvas\n"+
            "\n"+
            "### Attributes\n"+
            "* ID (GlobalId string)\n"+
            "* autoDraw (boolean)\n"+
            "* children (array of Canvas)\n"+
            "* peers (array of Canvas)\n"+
            "* htmlElement (DOMElement object | string)\n"+
            "* htmlPosition (DrawPosition string)\n"+
            "* matchElement (boolean)\n"+
            "* position (Positioning string)\n"+
            "* left (number | string)\n"+
            "* top (number | string)\n"+
            "* width (number | string)\n"+
            "* height (number | string)\n"+
            "* defaultWidth (integer)\n"+
            "* defaultHeight (integer)\n"+
            "* minWidth (number)\n"+
            "* minHeight (number)\n"+
            "* maxWidth (number)\n"+
            "* maxHeight (number)\n"+
            "* autoShowParent (boolean)\n"+
            "* visibility (Visibility string)\n"+
            "* canSelectText (boolean)\n"+
            "* styleName (CSSStyleName string)\n"+
            "* contents (HTML string)\n"+
            "* dynamicContents (boolean)\n"+
            "* dynamicContentsVars (ValueMap object)\n"+
            "* margin (number)\n"+
            "* padding (number)\n"+
            "* border (string)\n"+
            "* backgroundColor (CSSColor string)\n"+
            "* backgroundImage (SCImgURL string)\n"+
            "* backgroundRepeat (BackgroundRepeat string)\n"+
            "* appImgDir (URL string)\n"+
            "* skinImgDir (SCImgURL string)\n"+
            "* cursor (Cursor string)\n"+
            "* disabledCursor (Cursor string)\n"+
            "* opacity (number)\n"+
            "* showCustomScrollbars (boolean)\n"+
            "* scrollbarSize (number)\n"+
            "* disabled (boolean)\n"+
            "* visibleWhen (AdvancedCriteria object)\n"+
            "* enableWhen (AdvancedCriteria object)\n"+
            "* redrawOnResize (boolean)\n"+
            "* canFocus (boolean)\n"+
            "* tabIndex (number)\n"+
            "* accessKey (string)\n"+
            "* contextMenu (Menu)\n"+
            "* prompt (HTML string)\n"+
            "* canDrag (boolean)\n"+
            "* dragStartDistance (number)\n"+
            "* canDragScroll (boolean)\n"+
            "* dragScrollDelay (number)\n"+
            "* dragIntersectStyle (DragIntersectStyle string)\n"+
            "* canDragReposition (boolean)\n"+
            "* dragRepositionCursor (Cursor string)\n"+
            "* canDragResize (boolean)\n"+
            "* resizeFrom (array of EdgeName string)\n"+
            "* canHover (boolean)\n"+
            "* hoverDelay (number)\n"+
            "* showHover (boolean)\n"+
            "* hoverWidth (integer)\n"+
            "* hoverHeight (integer)\n"+
            "* hoverAlign (Alignment string)\n"+
            "* hoverVAlign (VerticalAlignment string)\n"+
            "* hoverWrap (boolean)\n"+
            "* hoverStyle (CSSStyleName string)\n"+
            "* hoverOpacity (number)\n"+
            "* hoverMoveWithMouse (boolean)\n"+
            "* edgeMarginSize (number)\n"+
            "* edgeCursorMap (object)\n"+
            "* keepInParentRect (boolean | array of integer)\n"+
            "* dragAppearance (DragAppearance string)\n"+
            "* dragType (string)\n"+
            "* dropTypes (array of string | string)\n"+
            "* dragTarget (Canvas | string)\n"+
            "* showDragShadow (boolean)\n"+
            "* dragOpacity (integer)\n"+
            "* canDrop (boolean)\n"+
            "* canAcceptDrop (boolean)\n"+
            "* canDropBefore (boolean)\n"+
            "* mouseStillDownInitialDelay (integer)\n"+
            "* mouseStillDownDelay (integer)\n"+
            "* doubleClickDelay (integer)\n"+
            "* noDoubleClicks (boolean)\n"+
            "* snapTo (string)\n"+
            "* snapOffsetLeft (integer)\n"+
            "* snapOffsetTop (integer)\n"+
            "* snapToGrid (boolean)\n"+
            "* snapResizeToGrid (boolean)\n"+
            "* childrenSnapToGrid (boolean)\n"+
            "* childrenSnapResizeToGrid (boolean)\n"+
            "* snapHGap (number)\n"+
            "* snapVGap (number)\n"+
            "* snapOnDrop (boolean)\n"+
            "* showPointer (boolean)\n"+
            "* pointerTarget (AutoTestLocator string | GlobalId string)\n"+
            "* pointerSettings (PointerSettings object)\n"+
            "* workflows (array of Process)\n"+
            "* borderRadius (string)\n"+
            "* showEdges (boolean)\n"+
            "* edgeSize (number)\n"+
            "* edgeOffset (number)\n"+
            "* edgeImage (SCImgURL string)\n"+
            "* customEdges (array of string)\n"+
            "* edgeBackgroundColor (CSSColor string)\n"+
            "* edgeOpacity (integer)\n"+
            "* edgeShowCenter (boolean)\n"+
            "* edgeCenterBackgroundColor (CSSColor string)\n"+
            "* showShadow (boolean)\n"+
            "* shadowDepth (number)\n"+
            "* shadowOffset (number)\n"+
            "* shadowSoftness (number)\n"+
            "* shadowImage (SCImgURL string)\n"+
            "* isGroup (boolean)\n"+
            "* groupTitle (HTML string)\n"+
            "* testDataContext (DataContext object)\n"+
            "* autoPopulateData (boolean)\n"+
            "* ruleScope (string)\n"+
            "* isRuleScope (boolean)\n"+
            "* valuesManager (ValuesManager | GlobalId string)\n"+
            "* dataPath (DataPath string)\n"+
            "* animateTime (number)\n"+
            "* animateAcceleration (AnimationAcceleration string)\n"+
            "* animateMoveTime (number)\n"+
            "* animateResizeTime (number)\n"+
            "* animateRectTime (number)\n"+
            "* animateFadeTime (number)\n"+
            "* animateScrollTime (number)\n"+
            "* animateShowTime (number)\n"+
            "* animateHideTime (number)\n"+
            "* animateMoveAcceleration (AnimationAcceleration string)\n"+
            "* animateResizeAcceleration (AnimationAcceleration string)\n"+
            "* animateRectAcceleration (AnimationAcceleration string)\n"+
            "* animateScrollAcceleration (AnimationAcceleration string)\n"+
            "* animateShowAcceleration (AnimationAcceleration string)\n"+
            "* animateHideAcceleration (AnimationAcceleration string)\n"+
            "* layoutAlign (Alignment string | VerticalAlignment string)\n"+
            "* showResizeBar (boolean)\n"+
            "* resizeBarTarget (string)\n"+
            "* extraSpace (positive integer)\n"+
            "\n"+
            "### Methods\n"+
            "* showNextTo()\n"+
            "* show()\n"+
            "* hide()\n"+
            "* print()\n",
        format:"Markdown"
    },
    "APIs list:SectionStack":{
        topic:"APIs list for SectionStack",
        content:"Only the following APIs are available on SectionStack:\n"+
            "\n"+
            "## Attributes\n"+
            "* overflow (Overflow string)\n"+
            "* styleName (CSSStyleName string)\n"+
            "* sectionHeaderClass (Classname)\n"+
            "* headerHeight (number)\n"+
            "* sections (array of SectionStackSection properties objects)\n"+
            "* canResizeSections (boolean)\n"+
            "* canDropComponents (boolean)\n"+
            "* canTabToHeaders (boolean)\n"+
            "* scrollSectionIntoView (boolean)\n"+
            "* animateSections (boolean)\n"+
            "* visibilityMode (VisibilityMode string)\n"+
            "* canCollapseAll (boolean)\n"+
            "* itemIndent (number)\n"+
            "* itemStartIndent (number)\n"+
            "* itemEndIndent (number)\n"+
            "* showExpandControls (boolean)\n"+
            "* canCloseSections (boolean)\n"+
            "* closeSectionIcon (SCImgURL string)\n"+
            "* closeSectionIconSize (number)\n"+
            "\n"+
            "## Inherited from Layout\n"+
            "\n"+
            "### Attributes\n"+
            "* vertical (boolean)\n"+
            "* vPolicy (LayoutPolicy string)\n"+
            "* hPolicy (LayoutPolicy string)\n"+
            "* minMemberLength (integer)\n"+
            "* minBreadthMember (string | integer | Canvas)\n"+
            "* enforcePolicy (boolean)\n"+
            "* defaultLayoutAlign (Alignment string | VerticalAlignment string)\n"+
            "* align (Alignment string | VerticalAlignment string)\n"+
            "* reverseOrder (boolean)\n"+
            "* paddingAsLayoutMargin (boolean)\n"+
            "* layoutMargin (integer)\n"+
            "* layoutLeftMargin (integer)\n"+
            "* layoutRightMargin (integer)\n"+
            "* layoutTopMargin (integer)\n"+
            "* layoutBottomMargin (integer)\n"+
            "* membersMargin (integer)\n"+
            "* leaveScrollbarGap (boolean)\n"+
            "* resizeBarClass (string)\n"+
            "* resizeBarSize (integer)\n"+
            "* animateMembers (boolean)\n"+
            "* animateMemberTime (number)\n"+
            "* dropLineThickness (number)\n"+
            "* showDragPlaceHolder (boolean)\n"+
            "* placeHolderProperties (Canvas properties object)\n"+
            "* placeHolderDefaults (Canvas properties object)\n"+
            "\n"+
            "## Inherited from Canvas\n"+
            "\n"+
            "### Attributes\n"+
            "* ID (GlobalId string)\n"+
            "* autoDraw (boolean)\n"+
            "* htmlElement (DOMElement object | string)\n"+
            "* htmlPosition (DrawPosition string)\n"+
            "* matchElement (boolean)\n"+
            "* position (Positioning string)\n"+
            "* left (number | string)\n"+
            "* top (number | string)\n"+
            "* width (number | string)\n"+
            "* height (number | string)\n"+
            "* defaultWidth (integer)\n"+
            "* defaultHeight (integer)\n"+
            "* minWidth (number)\n"+
            "* minHeight (number)\n"+
            "* maxWidth (number)\n"+
            "* maxHeight (number)\n"+
            "* autoShowParent (boolean)\n"+
            "* visibility (Visibility string)\n"+
            "* canSelectText (boolean)\n"+
            "* contents (HTML string)\n"+
            "* dynamicContents (boolean)\n"+
            "* dynamicContentsVars (ValueMap object)\n"+
            "* margin (number)\n"+
            "* padding (number)\n"+
            "* border (string)\n"+
            "* backgroundColor (CSSColor string)\n"+
            "* backgroundImage (SCImgURL string)\n"+
            "* backgroundRepeat (BackgroundRepeat string)\n"+
            "* appImgDir (URL string)\n"+
            "* skinImgDir (SCImgURL string)\n"+
            "* cursor (Cursor string)\n"+
            "* disabledCursor (Cursor string)\n"+
            "* opacity (number)\n"+
            "* showCustomScrollbars (boolean)\n"+
            "* scrollbarSize (number)\n"+
            "* disabled (boolean)\n"+
            "* visibleWhen (AdvancedCriteria object)\n"+
            "* enableWhen (AdvancedCriteria object)\n"+
            "* redrawOnResize (boolean)\n"+
            "* canFocus (boolean)\n"+
            "* tabIndex (number)\n"+
            "* accessKey (string)\n"+
            "* contextMenu (Menu)\n"+
            "* prompt (HTML string)\n"+
            "* canDrag (boolean)\n"+
            "* dragStartDistance (number)\n"+
            "* canDragScroll (boolean)\n"+
            "* dragScrollDelay (number)\n"+
            "* dragIntersectStyle (DragIntersectStyle string)\n"+
            "* canDragReposition (boolean)\n"+
            "* dragRepositionCursor (Cursor string)\n"+
            "* canDragResize (boolean)\n"+
            "* resizeFrom (array of EdgeName string)\n"+
            "* canHover (boolean)\n"+
            "* hoverDelay (number)\n"+
            "* showHover (boolean)\n"+
            "* hoverWidth (integer)\n"+
            "* hoverHeight (integer)\n"+
            "* hoverAlign (Alignment string)\n"+
            "* hoverVAlign (VerticalAlignment string)\n"+
            "* hoverWrap (boolean)\n"+
            "* hoverStyle (CSSStyleName string)\n"+
            "* hoverOpacity (number)\n"+
            "* hoverMoveWithMouse (boolean)\n"+
            "* edgeMarginSize (number)\n"+
            "* edgeCursorMap (object)\n"+
            "* keepInParentRect (boolean | array of integer)\n"+
            "* dragAppearance (DragAppearance string)\n"+
            "* dragType (string)\n"+
            "* dropTypes (array of string | string)\n"+
            "* dragTarget (Canvas | string)\n"+
            "* showDragShadow (boolean)\n"+
            "* dragOpacity (integer)\n"+
            "* canDrop (boolean)\n"+
            "* canAcceptDrop (boolean)\n"+
            "* canDropBefore (boolean)\n"+
            "* mouseStillDownInitialDelay (integer)\n"+
            "* mouseStillDownDelay (integer)\n"+
            "* doubleClickDelay (integer)\n"+
            "* noDoubleClicks (boolean)\n"+
            "* snapTo (string)\n"+
            "* snapOffsetLeft (integer)\n"+
            "* snapOffsetTop (integer)\n"+
            "* snapToGrid (boolean)\n"+
            "* snapResizeToGrid (boolean)\n"+
            "* childrenSnapToGrid (boolean)\n"+
            "* childrenSnapResizeToGrid (boolean)\n"+
            "* snapHGap (number)\n"+
            "* snapVGap (number)\n"+
            "* snapOnDrop (boolean)\n"+
            "* showPointer (boolean)\n"+
            "* pointerTarget (AutoTestLocator string | GlobalId string)\n"+
            "* pointerSettings (PointerSettings object)\n"+
            "* workflows (array of Process)\n"+
            "* borderRadius (string)\n"+
            "* showEdges (boolean)\n"+
            "* edgeSize (number)\n"+
            "* edgeOffset (number)\n"+
            "* edgeImage (SCImgURL string)\n"+
            "* customEdges (array of string)\n"+
            "* edgeBackgroundColor (CSSColor string)\n"+
            "* edgeOpacity (integer)\n"+
            "* edgeShowCenter (boolean)\n"+
            "* edgeCenterBackgroundColor (CSSColor string)\n"+
            "* showShadow (boolean)\n"+
            "* shadowDepth (number)\n"+
            "* shadowOffset (number)\n"+
            "* shadowSoftness (number)\n"+
            "* shadowImage (SCImgURL string)\n"+
            "* isGroup (boolean)\n"+
            "* groupTitle (HTML string)\n"+
            "* testDataContext (DataContext object)\n"+
            "* autoPopulateData (boolean)\n"+
            "* ruleScope (string)\n"+
            "* isRuleScope (boolean)\n"+
            "* valuesManager (ValuesManager | GlobalId string)\n"+
            "* dataPath (DataPath string)\n"+
            "* animateTime (number)\n"+
            "* animateAcceleration (AnimationAcceleration string)\n"+
            "* animateMoveTime (number)\n"+
            "* animateResizeTime (number)\n"+
            "* animateRectTime (number)\n"+
            "* animateFadeTime (number)\n"+
            "* animateScrollTime (number)\n"+
            "* animateShowTime (number)\n"+
            "* animateHideTime (number)\n"+
            "* animateMoveAcceleration (AnimationAcceleration string)\n"+
            "* animateResizeAcceleration (AnimationAcceleration string)\n"+
            "* animateRectAcceleration (AnimationAcceleration string)\n"+
            "* animateScrollAcceleration (AnimationAcceleration string)\n"+
            "* animateShowAcceleration (AnimationAcceleration string)\n"+
            "* animateHideAcceleration (AnimationAcceleration string)\n"+
            "* layoutAlign (Alignment string | VerticalAlignment string)\n"+
            "* showResizeBar (boolean)\n"+
            "* resizeBarTarget (string)\n"+
            "* extraSpace (positive integer)\n"+
            "\n"+
            "### Methods\n"+
            "* showNextTo()\n"+
            "* show()\n"+
            "* hide()\n"+
            "* print()\n",
        format:"Markdown"
    },
    "APIs list:SectionStackSection":{
        topic:"APIs list for SectionStackSection",
        content:"Only the following APIs are available on SectionStackSection:\n"+
            "\n"+
            "## Attributes\n"+
            "* ID (string)\n"+
            "* controls (array of Canvas)\n"+
            "* title (HTML string)\n"+
            "* showClippedTitleOnHover (boolean)\n"+
            "* items (array of Canvas | array of Shortcut properties objects)\n"+
            "* showHeader (boolean)\n"+
            "* resizeable (boolean)\n"+
            "* expanded (boolean)\n"+
            "* hidden (boolean)\n"+
            "* canCollapse (boolean)\n"+
            "* canClose (boolean)\n"+
            "* closeIcon (SCImgURL string)\n"+
            "* closeIconSize (number)\n",
        format:"Markdown"
    },
    "APIs list:Window":{
        topic:"APIs list for Window",
        content:"Only the following APIs are available on Window:\n"+
            "\n"+
            "## Attributes\n"+
            "* canDragReposition (boolean)\n"+
            "* keepInParentRect (boolean | array of integer)\n"+
            "* canDragResize (boolean)\n"+
            "* resizeFrom (array of EdgeName string)\n"+
            "* opacity (integer)\n"+
            "* isModal (boolean)\n"+
            "* showModalMask (boolean)\n"+
            "* modalMaskOpacity (number)\n"+
            "* autoCenter (boolean)\n"+
            "* dismissOnOutsideClick (boolean)\n"+
            "* dismissOnEscape (boolean)\n"+
            "* showBody (boolean)\n"+
            "* bodyStyle (CSSStyleName string)\n"+
            "* bodyColor (CSSColor string)\n"+
            "* hiliteBodyColor (CSSColor string)\n"+
            "* items (array of Canvas | Canvas | string)\n"+
            "* src (string)\n"+
            "* contentsType (string)\n"+
            "* bodyConstructor (string)\n"+
            "* bodyDefaults (object)\n"+
            "* contentLayout (ContentLayoutPolicy string)\n"+
            "* autoSize (boolean)\n"+
            "* showHeader (boolean)\n"+
            "* showHeaderBackground (boolean)\n"+
            "* headerStyle (CSSStyleName string)\n"+
            "* headerSrc (SCImgURL string)\n"+
            "* headerControls (array of string)\n"+
            "* hiliteHeaderStyle (CSSStyleName string)\n"+
            "* hiliteHeaderSrc (SCImgURL string)\n"+
            "* showTitle (boolean)\n"+
            "* title (HTML string)\n"+
            "* headerLabelDefaults (object)\n"+
            "* showHeaderIcon (boolean)\n"+
            "* headerIconDefaults (object)\n"+
            "* canFocusInHeaderButtons (boolean)\n"+
            "* showCloseButton (boolean)\n"+
            "* showMinimizeButton (boolean)\n"+
            "* minimized (boolean)\n"+
            "* defaultMinimizeHeight (number)\n"+
            "* minimizeHeight (number)\n"+
            "* animateMinimize (boolean)\n"+
            "* minimizeTime (number)\n"+
            "* minimizeAcceleration (AnimationAcceleration string)\n"+
            "* maximized (boolean)\n"+
            "* showMaximizeButton (boolean)\n"+
            "* showFooter (boolean)\n"+
            "* footerHeight (number)\n"+
            "* footerControls (array of string)\n"+
            "* showStatusBar (boolean)\n"+
            "* showResizer (boolean)\n"+
            "* showEdges (boolean)\n"+
            "* showShadow (boolean)\n"+
            "\n"+
            "## Inherited from Layout\n"+
            "\n"+
            "### Attributes\n"+
            "* overflow (Overflow string)\n"+
            "* defaultLayoutAlign (Alignment string | VerticalAlignment string)\n"+
            "* align (Alignment string | VerticalAlignment string)\n"+
            "* layoutMargin (integer)\n"+
            "* membersMargin (integer)\n"+
            "\n"+
            "## Inherited from Canvas\n"+
            "\n"+
            "### Attributes\n"+
            "* ID (GlobalId string)\n"+
            "* autoDraw (boolean)\n"+
            "* children (array of Canvas)\n"+
            "* peers (array of Canvas)\n"+
            "* htmlElement (DOMElement object | string)\n"+
            "* htmlPosition (DrawPosition string)\n"+
            "* matchElement (boolean)\n"+
            "* position (Positioning string)\n"+
            "* left (number | string)\n"+
            "* top (number | string)\n"+
            "* width (number | string)\n"+
            "* height (number | string)\n"+
            "* defaultWidth (integer)\n"+
            "* defaultHeight (integer)\n"+
            "* minWidth (number)\n"+
            "* minHeight (number)\n"+
            "* maxWidth (number)\n"+
            "* maxHeight (number)\n"+
            "* autoShowParent (boolean)\n"+
            "* visibility (Visibility string)\n"+
            "* canSelectText (boolean)\n"+
            "* styleName (CSSStyleName string)\n"+
            "* contents (HTML string)\n"+
            "* dynamicContents (boolean)\n"+
            "* dynamicContentsVars (ValueMap object)\n"+
            "* margin (number)\n"+
            "* padding (number)\n"+
            "* border (string)\n"+
            "* backgroundColor (CSSColor string)\n"+
            "* backgroundImage (SCImgURL string)\n"+
            "* backgroundRepeat (BackgroundRepeat string)\n"+
            "* appImgDir (URL string)\n"+
            "* skinImgDir (SCImgURL string)\n"+
            "* cursor (Cursor string)\n"+
            "* disabledCursor (Cursor string)\n"+
            "* showCustomScrollbars (boolean)\n"+
            "* scrollbarSize (number)\n"+
            "* disabled (boolean)\n"+
            "* visibleWhen (AdvancedCriteria object)\n"+
            "* redrawOnResize (boolean)\n"+
            "* canFocus (boolean)\n"+
            "* tabIndex (number)\n"+
            "* accessKey (string)\n"+
            "* contextMenu (Menu)\n"+
            "* prompt (HTML string)\n"+
            "* canDrag (boolean)\n"+
            "* dragStartDistance (number)\n"+
            "* canDragScroll (boolean)\n"+
            "* dragScrollDelay (number)\n"+
            "* dragIntersectStyle (DragIntersectStyle string)\n"+
            "* dragRepositionCursor (Cursor string)\n"+
            "* canHover (boolean)\n"+
            "* hoverDelay (number)\n"+
            "* showHover (boolean)\n"+
            "* hoverWidth (integer)\n"+
            "* hoverHeight (integer)\n"+
            "* hoverAlign (Alignment string)\n"+
            "* hoverVAlign (VerticalAlignment string)\n"+
            "* hoverWrap (boolean)\n"+
            "* hoverStyle (CSSStyleName string)\n"+
            "* hoverOpacity (number)\n"+
            "* hoverMoveWithMouse (boolean)\n"+
            "* edgeMarginSize (number)\n"+
            "* edgeCursorMap (object)\n"+
            "* dragAppearance (DragAppearance string)\n"+
            "* dragType (string)\n"+
            "* dropTypes (array of string | string)\n"+
            "* dragTarget (Canvas | string)\n"+
            "* showDragShadow (boolean)\n"+
            "* dragOpacity (integer)\n"+
            "* canDrop (boolean)\n"+
            "* canAcceptDrop (boolean)\n"+
            "* canDropBefore (boolean)\n"+
            "* mouseStillDownInitialDelay (integer)\n"+
            "* mouseStillDownDelay (integer)\n"+
            "* doubleClickDelay (integer)\n"+
            "* noDoubleClicks (boolean)\n"+
            "* snapTo (string)\n"+
            "* snapOffsetLeft (integer)\n"+
            "* snapOffsetTop (integer)\n"+
            "* snapToGrid (boolean)\n"+
            "* snapResizeToGrid (boolean)\n"+
            "* childrenSnapToGrid (boolean)\n"+
            "* childrenSnapResizeToGrid (boolean)\n"+
            "* snapHGap (number)\n"+
            "* snapVGap (number)\n"+
            "* snapOnDrop (boolean)\n"+
            "* showPointer (boolean)\n"+
            "* pointerTarget (AutoTestLocator string | GlobalId string)\n"+
            "* pointerSettings (PointerSettings object)\n"+
            "* workflows (array of Process)\n"+
            "* borderRadius (string)\n"+
            "* edgeSize (number)\n"+
            "* edgeOffset (number)\n"+
            "* edgeImage (SCImgURL string)\n"+
            "* customEdges (array of string)\n"+
            "* edgeBackgroundColor (CSSColor string)\n"+
            "* edgeOpacity (integer)\n"+
            "* edgeShowCenter (boolean)\n"+
            "* edgeCenterBackgroundColor (CSSColor string)\n"+
            "* shadowDepth (number)\n"+
            "* shadowOffset (number)\n"+
            "* shadowSoftness (number)\n"+
            "* shadowImage (SCImgURL string)\n"+
            "* isGroup (boolean)\n"+
            "* groupTitle (HTML string)\n"+
            "* testDataContext (DataContext object)\n"+
            "* autoPopulateData (boolean)\n"+
            "* ruleScope (string)\n"+
            "* isRuleScope (boolean)\n"+
            "* valuesManager (ValuesManager | GlobalId string)\n"+
            "* dataPath (DataPath string)\n"+
            "* animateTime (number)\n"+
            "* animateAcceleration (AnimationAcceleration string)\n"+
            "* animateMoveTime (number)\n"+
            "* animateResizeTime (number)\n"+
            "* animateRectTime (number)\n"+
            "* animateFadeTime (number)\n"+
            "* animateScrollTime (number)\n"+
            "* animateShowTime (number)\n"+
            "* animateHideTime (number)\n"+
            "* animateMoveAcceleration (AnimationAcceleration string)\n"+
            "* animateResizeAcceleration (AnimationAcceleration string)\n"+
            "* animateRectAcceleration (AnimationAcceleration string)\n"+
            "* animateScrollAcceleration (AnimationAcceleration string)\n"+
            "* animateShowAcceleration (AnimationAcceleration string)\n"+
            "* animateHideAcceleration (AnimationAcceleration string)\n"+
            "* layoutAlign (Alignment string | VerticalAlignment string)\n"+
            "* showResizeBar (boolean)\n"+
            "* resizeBarTarget (string)\n"+
            "* extraSpace (positive integer)\n"+
            "\n"+
            "### Methods\n"+
            "* showNextTo()\n"+
            "* show()\n"+
            "* hide()\n"+
            "* print()\n",
        format:"Markdown"
    },
    "APIs list:Dialog":{
        topic:"APIs list for Dialog",
        content:"Only the following APIs are available on Dialog:\n"+
            "\n"+
            "## Attributes\n"+
            "* defaultWidth (integer)\n"+
            "* styleName (CSSStyleName string)\n"+
            "* showToolbar (boolean)\n"+
            "* toolbarButtons (array of Button | array of Button properties objects)\n"+
            "\n"+
            "## Inherited from Window\n"+
            "\n"+
            "### Attributes\n"+
            "* canDragReposition (boolean)\n"+
            "* keepInParentRect (boolean | array of integer)\n"+
            "* canDragResize (boolean)\n"+
            "* resizeFrom (array of EdgeName string)\n"+
            "* opacity (integer)\n"+
            "* isModal (boolean)\n"+
            "* showModalMask (boolean)\n"+
            "* modalMaskOpacity (number)\n"+
            "* autoCenter (boolean)\n"+
            "* dismissOnOutsideClick (boolean)\n"+
            "* dismissOnEscape (boolean)\n"+
            "* showBody (boolean)\n"+
            "* bodyStyle (CSSStyleName string)\n"+
            "* bodyColor (CSSColor string)\n"+
            "* hiliteBodyColor (CSSColor string)\n"+
            "* items (array of Canvas | Canvas | string)\n"+
            "* src (string)\n"+
            "* contentsType (string)\n"+
            "* bodyConstructor (string)\n"+
            "* bodyDefaults (object)\n"+
            "* contentLayout (ContentLayoutPolicy string)\n"+
            "* autoSize (boolean)\n"+
            "* showHeader (boolean)\n"+
            "* showHeaderBackground (boolean)\n"+
            "* headerStyle (CSSStyleName string)\n"+
            "* headerSrc (SCImgURL string)\n"+
            "* headerControls (array of string)\n"+
            "* hiliteHeaderStyle (CSSStyleName string)\n"+
            "* hiliteHeaderSrc (SCImgURL string)\n"+
            "* showTitle (boolean)\n"+
            "* title (HTML string)\n"+
            "* headerLabelDefaults (object)\n"+
            "* showHeaderIcon (boolean)\n"+
            "* headerIconDefaults (object)\n"+
            "* canFocusInHeaderButtons (boolean)\n"+
            "* showCloseButton (boolean)\n"+
            "* showMinimizeButton (boolean)\n"+
            "* minimized (boolean)\n"+
            "* defaultMinimizeHeight (number)\n"+
            "* minimizeHeight (number)\n"+
            "* animateMinimize (boolean)\n"+
            "* minimizeTime (number)\n"+
            "* minimizeAcceleration (AnimationAcceleration string)\n"+
            "* maximized (boolean)\n"+
            "* showMaximizeButton (boolean)\n"+
            "* showFooter (boolean)\n"+
            "* footerHeight (number)\n"+
            "* footerControls (array of string)\n"+
            "* showStatusBar (boolean)\n"+
            "* showResizer (boolean)\n"+
            "* showEdges (boolean)\n"+
            "* showShadow (boolean)\n"+
            "\n"+
            "## Inherited from Layout\n"+
            "\n"+
            "### Attributes\n"+
            "* overflow (Overflow string)\n"+
            "* defaultLayoutAlign (Alignment string | VerticalAlignment string)\n"+
            "* align (Alignment string | VerticalAlignment string)\n"+
            "* layoutMargin (integer)\n"+
            "* membersMargin (integer)\n"+
            "\n"+
            "## Inherited from Canvas\n"+
            "\n"+
            "### Attributes\n"+
            "* ID (GlobalId string)\n"+
            "* autoDraw (boolean)\n"+
            "* children (array of Canvas)\n"+
            "* peers (array of Canvas)\n"+
            "* htmlElement (DOMElement object | string)\n"+
            "* htmlPosition (DrawPosition string)\n"+
            "* matchElement (boolean)\n"+
            "* position (Positioning string)\n"+
            "* left (number | string)\n"+
            "* top (number | string)\n"+
            "* width (number | string)\n"+
            "* height (number | string)\n"+
            "* defaultHeight (integer)\n"+
            "* minWidth (number)\n"+
            "* minHeight (number)\n"+
            "* maxWidth (number)\n"+
            "* maxHeight (number)\n"+
            "* autoShowParent (boolean)\n"+
            "* visibility (Visibility string)\n"+
            "* canSelectText (boolean)\n"+
            "* contents (HTML string)\n"+
            "* dynamicContents (boolean)\n"+
            "* dynamicContentsVars (ValueMap object)\n"+
            "* margin (number)\n"+
            "* padding (number)\n"+
            "* border (string)\n"+
            "* backgroundColor (CSSColor string)\n"+
            "* backgroundImage (SCImgURL string)\n"+
            "* backgroundRepeat (BackgroundRepeat string)\n"+
            "* appImgDir (URL string)\n"+
            "* skinImgDir (SCImgURL string)\n"+
            "* cursor (Cursor string)\n"+
            "* disabledCursor (Cursor string)\n"+
            "* showCustomScrollbars (boolean)\n"+
            "* scrollbarSize (number)\n"+
            "* disabled (boolean)\n"+
            "* visibleWhen (AdvancedCriteria object)\n"+
            "* redrawOnResize (boolean)\n"+
            "* canFocus (boolean)\n"+
            "* tabIndex (number)\n"+
            "* accessKey (string)\n"+
            "* contextMenu (Menu)\n"+
            "* prompt (HTML string)\n"+
            "* canDrag (boolean)\n"+
            "* dragStartDistance (number)\n"+
            "* canDragScroll (boolean)\n"+
            "* dragScrollDelay (number)\n"+
            "* dragIntersectStyle (DragIntersectStyle string)\n"+
            "* dragRepositionCursor (Cursor string)\n"+
            "* canHover (boolean)\n"+
            "* hoverDelay (number)\n"+
            "* showHover (boolean)\n"+
            "* hoverWidth (integer)\n"+
            "* hoverHeight (integer)\n"+
            "* hoverAlign (Alignment string)\n"+
            "* hoverVAlign (VerticalAlignment string)\n"+
            "* hoverWrap (boolean)\n"+
            "* hoverStyle (CSSStyleName string)\n"+
            "* hoverOpacity (number)\n"+
            "* hoverMoveWithMouse (boolean)\n"+
            "* edgeMarginSize (number)\n"+
            "* edgeCursorMap (object)\n"+
            "* dragAppearance (DragAppearance string)\n"+
            "* dragType (string)\n"+
            "* dropTypes (array of string | string)\n"+
            "* dragTarget (Canvas | string)\n"+
            "* showDragShadow (boolean)\n"+
            "* dragOpacity (integer)\n"+
            "* canDrop (boolean)\n"+
            "* canAcceptDrop (boolean)\n"+
            "* canDropBefore (boolean)\n"+
            "* mouseStillDownInitialDelay (integer)\n"+
            "* mouseStillDownDelay (integer)\n"+
            "* doubleClickDelay (integer)\n"+
            "* noDoubleClicks (boolean)\n"+
            "* snapTo (string)\n"+
            "* snapOffsetLeft (integer)\n"+
            "* snapOffsetTop (integer)\n"+
            "* snapToGrid (boolean)\n"+
            "* snapResizeToGrid (boolean)\n"+
            "* childrenSnapToGrid (boolean)\n"+
            "* childrenSnapResizeToGrid (boolean)\n"+
            "* snapHGap (number)\n"+
            "* snapVGap (number)\n"+
            "* snapOnDrop (boolean)\n"+
            "* showPointer (boolean)\n"+
            "* pointerTarget (AutoTestLocator string | GlobalId string)\n"+
            "* pointerSettings (PointerSettings object)\n"+
            "* workflows (array of Process)\n"+
            "* borderRadius (string)\n"+
            "* edgeSize (number)\n"+
            "* edgeOffset (number)\n"+
            "* edgeImage (SCImgURL string)\n"+
            "* customEdges (array of string)\n"+
            "* edgeBackgroundColor (CSSColor string)\n"+
            "* edgeOpacity (integer)\n"+
            "* edgeShowCenter (boolean)\n"+
            "* edgeCenterBackgroundColor (CSSColor string)\n"+
            "* shadowDepth (number)\n"+
            "* shadowOffset (number)\n"+
            "* shadowSoftness (number)\n"+
            "* shadowImage (SCImgURL string)\n"+
            "* isGroup (boolean)\n"+
            "* groupTitle (HTML string)\n"+
            "* testDataContext (DataContext object)\n"+
            "* autoPopulateData (boolean)\n"+
            "* ruleScope (string)\n"+
            "* isRuleScope (boolean)\n"+
            "* valuesManager (ValuesManager | GlobalId string)\n"+
            "* dataPath (DataPath string)\n"+
            "* animateTime (number)\n"+
            "* animateAcceleration (AnimationAcceleration string)\n"+
            "* animateMoveTime (number)\n"+
            "* animateResizeTime (number)\n"+
            "* animateRectTime (number)\n"+
            "* animateFadeTime (number)\n"+
            "* animateScrollTime (number)\n"+
            "* animateShowTime (number)\n"+
            "* animateHideTime (number)\n"+
            "* animateMoveAcceleration (AnimationAcceleration string)\n"+
            "* animateResizeAcceleration (AnimationAcceleration string)\n"+
            "* animateRectAcceleration (AnimationAcceleration string)\n"+
            "* animateScrollAcceleration (AnimationAcceleration string)\n"+
            "* animateShowAcceleration (AnimationAcceleration string)\n"+
            "* animateHideAcceleration (AnimationAcceleration string)\n"+
            "* layoutAlign (Alignment string | VerticalAlignment string)\n"+
            "* showResizeBar (boolean)\n"+
            "* resizeBarTarget (string)\n"+
            "* extraSpace (positive integer)\n"+
            "\n"+
            "### Methods\n"+
            "* showNextTo()\n"+
            "* show()\n"+
            "* hide()\n"+
            "* print()\n",
        format:"Markdown"
    },
    "APIs list:DynamicForm":{
        topic:"APIs list for DynamicForm",
        content:"Only the following APIs are available on DynamicForm:\n"+
            "\n"+
            "## Attributes\n"+
            "* autoFetchData (boolean)\n"+
            "* autoFetchTextMatchStyle (TextMatchStyle string)\n"+
            "* fetchRequestProperties (DSRequest properties object)\n"+
            "* initialCriteria (Criteria object)\n"+
            "* implicitCriteria (Criteria object)\n"+
            "* items (array of FormItem properties objects)\n"+
            "* fields (array of FormItem properties objects)\n"+
            "* initialSort (array of SortSpecifier objects)\n"+
            "* values (object)\n"+
            "* itemLayout (FormLayoutType)\n"+
            "* linearMode (boolean)\n"+
            "* linearOnMobile (boolean)\n"+
            "* numCols (number)\n"+
            "* linearNumCols (number)\n"+
            "* fixedColWidths (boolean)\n"+
            "* colWidths (array)\n"+
            "* minColWidth (number)\n"+
            "* cellPadding (number)\n"+
            "* cellBorder (number)\n"+
            "* sectionVisibilityMode (VisibilityMode string)\n"+
            "* longTextEditorThreshold (number)\n"+
            "* longTextEditorType (string)\n"+
            "* valuesManager (ValuesManager | GlobalId string)\n"+
            "* titleOrientation (TitleOrientation string)\n"+
            "* titlePrefix (HTML string)\n"+
            "* rightTitlePrefix (HTML string)\n"+
            "* titleSuffix (HTML string)\n"+
            "* rightTitleSuffix (HTML string)\n"+
            "* titleWidth (number | the literal string \"*\")\n"+
            "* wrapItemTitles (boolean)\n"+
            "* showInlineErrors (boolean)\n"+
            "* showErrorIcons (boolean)\n"+
            "* showErrorText (boolean)\n"+
            "* showErrorStyle (boolean)\n"+
            "* errorOrientation (Align)\n"+
            "* errorItemProperties (object)\n"+
            "* errorItemCellStyle (string)\n"+
            "* errorsPreamble (HTML string)\n"+
            "* showTitlesWithErrorMessages (boolean)\n"+
            "* hiliteRequiredFields (boolean)\n"+
            "* requiredTitlePrefix (HTML string)\n"+
            "* requiredRightTitlePrefix (HTML string)\n"+
            "* requiredTitleSuffix (HTML string)\n"+
            "* requiredRightTitleSuffix (HTML string)\n"+
            "* canEdit (boolean)\n"+
            "* readOnlyDisplay (ReadOnlyDisplayAppearance string)\n"+
            "* readOnlyTextBoxStyle (FormItemBaseStyle string)\n"+
            "* itemHoverDelay (number)\n"+
            "* itemHoverWidth (number | string)\n"+
            "* itemHoverHeight (number | string)\n"+
            "* itemHoverAlign (Alignment string)\n"+
            "* itemHoverVAlign (number | string)\n"+
            "* itemHoverStyle (CSSStyleName string)\n"+
            "* itemHoverOpacity (number)\n"+
            "* errors (object)\n"+
            "* validateOnChange (boolean)\n"+
            "* unknownErrorMessage (HTML string)\n"+
            "* autoFocus (boolean)\n"+
            "* autoFocusOnError (boolean)\n"+
            "* selectOnFocus (boolean)\n"+
            "* canFocus (boolean)\n"+
            "* autoComplete (AutoComplete string)\n"+
            "* browserSpellCheck (boolean)\n"+
            "* validationURL (URL string)\n"+
            "* action (URL string)\n"+
            "* target (string)\n"+
            "* method (FormMethod string)\n"+
            "* encoding (Encoding string)\n"+
            "* canSubmit (boolean)\n"+
            "* saveOnEnter (boolean)\n"+
            "* dataSource (DataSource | ID string)\n"+
            "* dataArity (string)\n"+
            "* titleAlign (Alignment string)\n"+
            "\n"+
            "## Methods\n"+
            "* editNewRecord()\n"+
            "* editSelectedData()\n"+
            "* reset()\n"+
            "* saveData()\n"+
            "* viewSelectedData()\n"+
            "* setValues()\n"+
            "* clearValues()\n"+
            "* validate()\n"+
            "* itemChanged()\n"+
            "\n"+
            "## Inherited from Canvas\n"+
            "\n"+
            "### Attributes\n"+
            "* ID (GlobalId string)\n"+
            "* autoDraw (boolean)\n"+
            "* htmlElement (DOMElement object | string)\n"+
            "* htmlPosition (DrawPosition string)\n"+
            "* matchElement (boolean)\n"+
            "* position (Positioning string)\n"+
            "* left (number | string)\n"+
            "* top (number | string)\n"+
            "* width (number | string)\n"+
            "* height (number | string)\n"+
            "* defaultWidth (integer)\n"+
            "* defaultHeight (integer)\n"+
            "* minWidth (number)\n"+
            "* minHeight (number)\n"+
            "* maxWidth (number)\n"+
            "* maxHeight (number)\n"+
            "* autoShowParent (boolean)\n"+
            "* visibility (Visibility string)\n"+
            "* canSelectText (boolean)\n"+
            "* styleName (CSSStyleName string)\n"+
            "* contents (HTML string)\n"+
            "* dynamicContents (boolean)\n"+
            "* dynamicContentsVars (ValueMap object)\n"+
            "* margin (number)\n"+
            "* padding (number)\n"+
            "* border (string)\n"+
            "* backgroundColor (CSSColor string)\n"+
            "* backgroundImage (SCImgURL string)\n"+
            "* backgroundRepeat (BackgroundRepeat string)\n"+
            "* appImgDir (URL string)\n"+
            "* skinImgDir (SCImgURL string)\n"+
            "* cursor (Cursor string)\n"+
            "* disabledCursor (Cursor string)\n"+
            "* opacity (number)\n"+
            "* overflow (Overflow string)\n"+
            "* showCustomScrollbars (boolean)\n"+
            "* scrollbarSize (number)\n"+
            "* disabled (boolean)\n"+
            "* visibleWhen (AdvancedCriteria object)\n"+
            "* enableWhen (AdvancedCriteria object)\n"+
            "* redrawOnResize (boolean)\n"+
            "* tabIndex (number)\n"+
            "* accessKey (string)\n"+
            "* contextMenu (Menu)\n"+
            "* prompt (HTML string)\n"+
            "* canDrag (boolean)\n"+
            "* dragStartDistance (number)\n"+
            "* canDragScroll (boolean)\n"+
            "* dragScrollDelay (number)\n"+
            "* dragIntersectStyle (DragIntersectStyle string)\n"+
            "* canDragReposition (boolean)\n"+
            "* dragRepositionCursor (Cursor string)\n"+
            "* canDragResize (boolean)\n"+
            "* resizeFrom (array of EdgeName string)\n"+
            "* canHover (boolean)\n"+
            "* hoverDelay (number)\n"+
            "* showHover (boolean)\n"+
            "* hoverWidth (integer)\n"+
            "* hoverHeight (integer)\n"+
            "* hoverAlign (Alignment string)\n"+
            "* hoverVAlign (VerticalAlignment string)\n"+
            "* hoverWrap (boolean)\n"+
            "* hoverStyle (CSSStyleName string)\n"+
            "* hoverOpacity (number)\n"+
            "* hoverMoveWithMouse (boolean)\n"+
            "* edgeMarginSize (number)\n"+
            "* edgeCursorMap (object)\n"+
            "* keepInParentRect (boolean | array of integer)\n"+
            "* dragAppearance (DragAppearance string)\n"+
            "* dragType (string)\n"+
            "* dropTypes (array of string | string)\n"+
            "* dragTarget (Canvas | string)\n"+
            "* showDragShadow (boolean)\n"+
            "* dragOpacity (integer)\n"+
            "* canDrop (boolean)\n"+
            "* canAcceptDrop (boolean)\n"+
            "* canDropBefore (boolean)\n"+
            "* mouseStillDownInitialDelay (integer)\n"+
            "* mouseStillDownDelay (integer)\n"+
            "* doubleClickDelay (integer)\n"+
            "* noDoubleClicks (boolean)\n"+
            "* snapTo (string)\n"+
            "* snapOffsetLeft (integer)\n"+
            "* snapOffsetTop (integer)\n"+
            "* snapToGrid (boolean)\n"+
            "* snapResizeToGrid (boolean)\n"+
            "* childrenSnapToGrid (boolean)\n"+
            "* childrenSnapResizeToGrid (boolean)\n"+
            "* snapHGap (number)\n"+
            "* snapVGap (number)\n"+
            "* snapOnDrop (boolean)\n"+
            "* showPointer (boolean)\n"+
            "* pointerTarget (AutoTestLocator string | GlobalId string)\n"+
            "* pointerSettings (PointerSettings object)\n"+
            "* workflows (array of Process)\n"+
            "* borderRadius (string)\n"+
            "* showEdges (boolean)\n"+
            "* edgeSize (number)\n"+
            "* edgeOffset (number)\n"+
            "* edgeImage (SCImgURL string)\n"+
            "* customEdges (array of string)\n"+
            "* edgeBackgroundColor (CSSColor string)\n"+
            "* edgeOpacity (integer)\n"+
            "* edgeShowCenter (boolean)\n"+
            "* edgeCenterBackgroundColor (CSSColor string)\n"+
            "* showShadow (boolean)\n"+
            "* shadowDepth (number)\n"+
            "* shadowOffset (number)\n"+
            "* shadowSoftness (number)\n"+
            "* shadowImage (SCImgURL string)\n"+
            "* isGroup (boolean)\n"+
            "* groupTitle (HTML string)\n"+
            "* testDataContext (DataContext object)\n"+
            "* autoPopulateData (boolean)\n"+
            "* ruleScope (string)\n"+
            "* isRuleScope (boolean)\n"+
            "* dataPath (DataPath string)\n"+
            "* animateTime (number)\n"+
            "* animateAcceleration (AnimationAcceleration string)\n"+
            "* animateMoveTime (number)\n"+
            "* animateResizeTime (number)\n"+
            "* animateRectTime (number)\n"+
            "* animateFadeTime (number)\n"+
            "* animateScrollTime (number)\n"+
            "* animateShowTime (number)\n"+
            "* animateHideTime (number)\n"+
            "* animateMoveAcceleration (AnimationAcceleration string)\n"+
            "* animateResizeAcceleration (AnimationAcceleration string)\n"+
            "* animateRectAcceleration (AnimationAcceleration string)\n"+
            "* animateScrollAcceleration (AnimationAcceleration string)\n"+
            "* animateShowAcceleration (AnimationAcceleration string)\n"+
            "* animateHideAcceleration (AnimationAcceleration string)\n"+
            "* layoutAlign (Alignment string | VerticalAlignment string)\n"+
            "* showResizeBar (boolean)\n"+
            "* resizeBarTarget (string)\n"+
            "* extraSpace (positive integer)\n"+
            "\n"+
            "### Methods\n"+
            "* showNextTo()\n"+
            "* show()\n"+
            "* hide()\n"+
            "* print()\n",
        format:"Markdown"
    },
    "APIs list:FormItem":{
        topic:"APIs list for FormItem",
        content:"Only the following APIs are available on FormItem:\n"+
            "\n"+
            "## Attributes\n"+
            "* type (FormItemType string)\n"+
            "* editorType (FormItem class name string)\n"+
            "* name (FieldName string)\n"+
            "* dataPath (DataPath string)\n"+
            "* title (HTML string)\n"+
            "* defaultValue (Any)\n"+
            "* value (Any)\n"+
            "* ID (GlobalId string)\n"+
            "* valueMap (array | ValueMap object)\n"+
            "* optionDataSource (DataSource | string)\n"+
            "* optionOperationId (string)\n"+
            "* valueField (string)\n"+
            "* displayField (string)\n"+
            "* fetchMissingValues (boolean)\n"+
            "* filterLocally (boolean)\n"+
            "* dateFormatter (DateDisplayFormat string)\n"+
            "* timeFormatter (TimeDisplayFormat string)\n"+
            "* decimalPrecision (number)\n"+
            "* decimalPad (number)\n"+
            "* format (FormatString string)\n"+
            "* exportFormat (FormatString string)\n"+
            "* valueIcons (object)\n"+
            "* emptyValueIcon (string)\n"+
            "* showValueIconOnly (boolean)\n"+
            "* suppressValueIcon (boolean)\n"+
            "* valueIconWidth (number)\n"+
            "* valueIconHeight (number)\n"+
            "* valueIconSize (number)\n"+
            "* valueIconLeftPadding (number)\n"+
            "* valueIconRightPadding (number)\n"+
            "* imageURLPrefix (string)\n"+
            "* imageURLSuffix (string)\n"+
            "* showPickerIcon (boolean)\n"+
            "* showFocusedPickerIcon (boolean)\n"+
            "* pickerIconProperties (FormItemIcon properties object)\n"+
            "* pickerIconSrc (SCImgURL string)\n"+
            "* pickerIconWidth (integer)\n"+
            "* pickerIconHeight (integer)\n"+
            "* validators (array of Validator)\n"+
            "* required (boolean)\n"+
            "* requiredWhen (Criteria object)\n"+
            "* visible (boolean)\n"+
            "* visibleWhen (AdvancedCriteria object)\n"+
            "* canEdit (boolean)\n"+
            "* readOnlyDisplay (ReadOnlyDisplayAppearance string)\n"+
            "* readOnlyTextBoxStyle (FormItemBaseStyle string)\n"+
            "* readOnlyWhen (AdvancedCriteria object)\n"+
            "* disabled (boolean)\n"+
            "* disableIconsOnReadOnly (boolean)\n"+
            "* accessKey (string)\n"+
            "* tabIndex (integer)\n"+
            "* globalTabIndex (integer)\n"+
            "* selectOnFocus (boolean)\n"+
            "* selectOnClick (boolean)\n"+
            "* changeOnKeypress (boolean)\n"+
            "* showTitle (boolean)\n"+
            "* titleOrientation (TitleOrientation string)\n"+
            "* titleAlign (Alignment string)\n"+
            "* titleVAlign (VerticalAlignment string)\n"+
            "* clipTitle (boolean)\n"+
            "* wrapTitle (boolean)\n"+
            "* redrawOnChange (boolean)\n"+
            "* validateOnChange (boolean)\n"+
            "* validateOnExit (boolean)\n"+
            "* width (integer | string)\n"+
            "* linearWidth (integer | string)\n"+
            "* height (integer | string)\n"+
            "* cellHeight (number)\n"+
            "* titleColSpan (number)\n"+
            "* colSpan (integer | string)\n"+
            "* linearColSpan (integer | string)\n"+
            "* rowSpan (number)\n"+
            "* startRow (boolean)\n"+
            "* endRow (boolean)\n"+
            "* linearStartRow (integer | string)\n"+
            "* linearEndRow (integer | string)\n"+
            "* align (Alignment string)\n"+
            "* vAlign (VerticalAlignment string)\n"+
            "* textAlign (Alignment string)\n"+
            "* left (integer)\n"+
            "* top (integer)\n"+
            "* autoComplete (AutoComplete string)\n"+
            "* icons (array of FormItemIcon properties objects)\n"+
            "* defaultIconSrc (SCImgURL string)\n"+
            "* showOverIcons (boolean)\n"+
            "* showFocusedIcons (boolean)\n"+
            "* iconVAlign (VerticalAlignment string)\n"+
            "* iconWidth (integer)\n"+
            "* iconHeight (integer)\n"+
            "* prompt (HTML string)\n"+
            "* readOnlyHover (HTML string)\n"+
            "* disabledHover (HTML string)\n"+
            "* showIcons (boolean)\n"+
            "* errorIconHeight (number)\n"+
            "* errorIconWidth (number)\n"+
            "* showErrorIcon (boolean)\n"+
            "* showErrorText (boolean)\n"+
            "* showErrorStyle (boolean)\n"+
            "* errorOrientation (Align)\n"+
            "* hint (HTML string)\n"+
            "* showHint (boolean)\n"+
            "* wrapHintText (boolean)\n"+
            "* showFocused (boolean)\n"+
            "* showDisabled (boolean)\n"+
            "* cellStyle (FormItemBaseStyle string)\n"+
            "* hintStyle (CSSStyleName string)\n"+
            "* titleStyle (FormItemBaseStyle string)\n"+
            "* textBoxStyle (FormItemBaseStyle string)\n"+
            "* pickerIconStyle (FormItemBaseStyle string)\n"+
            "* controlStyle (FormItemBaseStyle string)\n"+
            "* hoverDelay (number)\n"+
            "* hoverWidth (number | string)\n"+
            "* hoverHeight (number | string)\n"+
            "* hoverAlign (Alignment string)\n"+
            "* hoverVAlign (VerticalAlignment string)\n"+
            "* hoverStyle (CSSStyleName string)\n"+
            "* hoverOpacity (number)\n"+
            "* showClippedTitleOnHover (boolean)\n"+
            "* showClippedValueOnHover (boolean)\n"+
            "* operator (OperatorId string)\n"+
            "* formula (UserFormula object)\n"+
            "* textFormula (UserSummary object)\n"+
            "* saveOnEnter (boolean)\n"+
            "* multiple (boolean)\n"+
            "* errorMessageWidth (integer)\n"+
            "* implicitSave (boolean)\n"+
            "* implicitSaveOnBlur (boolean)\n"+
            "* shouldSaveValue (boolean)\n"+
            "* canSelectText (boolean)\n"+
            "* readOnlyCanSelectText (array of ReadOnlyDisplayAppearance string)\n"+
            "* allowExpressions (boolean)\n"+
            "\n"+
            "## Methods\n"+
            "* click()\n",
        format:"Markdown"
    },
    "APIs list:TextItem":{
        topic:"APIs list for TextItem",
        content:"Only the following APIs are available on TextItem:\n"+
            "\n"+
            "## Attributes\n"+
            "* width (number)\n"+
            "* height (number)\n"+
            "* textBoxStyle (FormItemBaseStyle string)\n"+
            "* length (number)\n"+
            "* selectOnFocus (boolean)\n"+
            "* selectOnClick (boolean)\n"+
            "* changeOnKeypress (boolean)\n"+
            "* fetchMissingValues (boolean)\n"+
            "* showHintInField (boolean)\n"+
            "* saveOnEnter (boolean)\n"+
            "* escapeHTML (boolean)\n"+
            "\n"+
            "## Inherited from FormItem\n"+
            "\n"+
            "### Attributes\n"+
            "* type (FormItemType string)\n"+
            "* editorType (FormItem class name string)\n"+
            "* name (FieldName string)\n"+
            "* dataPath (DataPath string)\n"+
            "* title (HTML string)\n"+
            "* defaultValue (Any)\n"+
            "* value (Any)\n"+
            "* ID (GlobalId string)\n"+
            "* valueMap (array | ValueMap object)\n"+
            "* optionDataSource (DataSource | string)\n"+
            "* optionOperationId (string)\n"+
            "* valueField (string)\n"+
            "* displayField (string)\n"+
            "* filterLocally (boolean)\n"+
            "* dateFormatter (DateDisplayFormat string)\n"+
            "* timeFormatter (TimeDisplayFormat string)\n"+
            "* decimalPrecision (number)\n"+
            "* decimalPad (number)\n"+
            "* format (FormatString string)\n"+
            "* exportFormat (FormatString string)\n"+
            "* valueIcons (object)\n"+
            "* emptyValueIcon (string)\n"+
            "* showValueIconOnly (boolean)\n"+
            "* suppressValueIcon (boolean)\n"+
            "* valueIconWidth (number)\n"+
            "* valueIconHeight (number)\n"+
            "* valueIconSize (number)\n"+
            "* valueIconLeftPadding (number)\n"+
            "* valueIconRightPadding (number)\n"+
            "* imageURLPrefix (string)\n"+
            "* imageURLSuffix (string)\n"+
            "* showPickerIcon (boolean)\n"+
            "* showFocusedPickerIcon (boolean)\n"+
            "* pickerIconProperties (FormItemIcon properties object)\n"+
            "* pickerIconSrc (SCImgURL string)\n"+
            "* pickerIconWidth (integer)\n"+
            "* pickerIconHeight (integer)\n"+
            "* validators (array of Validator)\n"+
            "* required (boolean)\n"+
            "* requiredWhen (Criteria object)\n"+
            "* visible (boolean)\n"+
            "* visibleWhen (AdvancedCriteria object)\n"+
            "* canEdit (boolean)\n"+
            "* readOnlyDisplay (ReadOnlyDisplayAppearance string)\n"+
            "* readOnlyTextBoxStyle (FormItemBaseStyle string)\n"+
            "* readOnlyWhen (AdvancedCriteria object)\n"+
            "* disabled (boolean)\n"+
            "* disableIconsOnReadOnly (boolean)\n"+
            "* accessKey (string)\n"+
            "* tabIndex (integer)\n"+
            "* globalTabIndex (integer)\n"+
            "* showTitle (boolean)\n"+
            "* titleOrientation (TitleOrientation string)\n"+
            "* titleAlign (Alignment string)\n"+
            "* titleVAlign (VerticalAlignment string)\n"+
            "* clipTitle (boolean)\n"+
            "* wrapTitle (boolean)\n"+
            "* redrawOnChange (boolean)\n"+
            "* validateOnChange (boolean)\n"+
            "* validateOnExit (boolean)\n"+
            "* linearWidth (integer | string)\n"+
            "* cellHeight (number)\n"+
            "* titleColSpan (number)\n"+
            "* colSpan (integer | string)\n"+
            "* linearColSpan (integer | string)\n"+
            "* rowSpan (number)\n"+
            "* startRow (boolean)\n"+
            "* endRow (boolean)\n"+
            "* linearStartRow (integer | string)\n"+
            "* linearEndRow (integer | string)\n"+
            "* align (Alignment string)\n"+
            "* vAlign (VerticalAlignment string)\n"+
            "* textAlign (Alignment string)\n"+
            "* left (integer)\n"+
            "* top (integer)\n"+
            "* autoComplete (AutoComplete string)\n"+
            "* icons (array of FormItemIcon properties objects)\n"+
            "* defaultIconSrc (SCImgURL string)\n"+
            "* showOverIcons (boolean)\n"+
            "* showFocusedIcons (boolean)\n"+
            "* iconVAlign (VerticalAlignment string)\n"+
            "* iconWidth (integer)\n"+
            "* iconHeight (integer)\n"+
            "* prompt (HTML string)\n"+
            "* readOnlyHover (HTML string)\n"+
            "* disabledHover (HTML string)\n"+
            "* showIcons (boolean)\n"+
            "* errorIconHeight (number)\n"+
            "* errorIconWidth (number)\n"+
            "* showErrorIcon (boolean)\n"+
            "* showErrorText (boolean)\n"+
            "* showErrorStyle (boolean)\n"+
            "* errorOrientation (Align)\n"+
            "* hint (HTML string)\n"+
            "* showHint (boolean)\n"+
            "* wrapHintText (boolean)\n"+
            "* showFocused (boolean)\n"+
            "* showDisabled (boolean)\n"+
            "* cellStyle (FormItemBaseStyle string)\n"+
            "* hintStyle (CSSStyleName string)\n"+
            "* titleStyle (FormItemBaseStyle string)\n"+
            "* pickerIconStyle (FormItemBaseStyle string)\n"+
            "* controlStyle (FormItemBaseStyle string)\n"+
            "* hoverDelay (number)\n"+
            "* hoverWidth (number | string)\n"+
            "* hoverHeight (number | string)\n"+
            "* hoverAlign (Alignment string)\n"+
            "* hoverVAlign (VerticalAlignment string)\n"+
            "* hoverStyle (CSSStyleName string)\n"+
            "* hoverOpacity (number)\n"+
            "* showClippedTitleOnHover (boolean)\n"+
            "* showClippedValueOnHover (boolean)\n"+
            "* operator (OperatorId string)\n"+
            "* formula (UserFormula object)\n"+
            "* textFormula (UserSummary object)\n"+
            "* multiple (boolean)\n"+
            "* errorMessageWidth (integer)\n"+
            "* implicitSave (boolean)\n"+
            "* implicitSaveOnBlur (boolean)\n"+
            "* shouldSaveValue (boolean)\n"+
            "* canSelectText (boolean)\n"+
            "* readOnlyCanSelectText (array of ReadOnlyDisplayAppearance string)\n"+
            "* allowExpressions (boolean)\n"+
            "\n"+
            "### Methods\n"+
            "* click()\n"+
            "* changed()\n",
        format:"Markdown"
    },
    "APIs list:TextAreaItem":{
        topic:"APIs list for TextAreaItem",
        content:"Only the following APIs are available on TextAreaItem:\n"+
            "\n"+
            "## Attributes\n"+
            "* defaultValue (string)\n"+
            "* wrap (TEXTAREA_WRAP string)\n"+
            "* width (number)\n"+
            "* height (number)\n"+
            "* pickerIconHeight (integer)\n"+
            "* textBoxStyle (FormItemBaseStyle string)\n"+
            "* length (number)\n"+
            "* iconVAlign (VerticalAlignment string)\n"+
            "* selectOnFocus (boolean)\n"+
            "* selectOnClick (boolean)\n"+
            "* changeOnKeypress (boolean)\n"+
            "* showHintInField (boolean)\n"+
            "* escapeHTML (boolean)\n"+
            "\n"+
            "## Inherited from FormItem\n"+
            "\n"+
            "### Attributes\n"+
            "* type (FormItemType string)\n"+
            "* editorType (FormItem class name string)\n"+
            "* name (FieldName string)\n"+
            "* dataPath (DataPath string)\n"+
            "* title (HTML string)\n"+
            "* value (Any)\n"+
            "* ID (GlobalId string)\n"+
            "* valueMap (array | ValueMap object)\n"+
            "* optionDataSource (DataSource | string)\n"+
            "* optionOperationId (string)\n"+
            "* valueField (string)\n"+
            "* displayField (string)\n"+
            "* fetchMissingValues (boolean)\n"+
            "* filterLocally (boolean)\n"+
            "* dateFormatter (DateDisplayFormat string)\n"+
            "* timeFormatter (TimeDisplayFormat string)\n"+
            "* decimalPrecision (number)\n"+
            "* decimalPad (number)\n"+
            "* format (FormatString string)\n"+
            "* exportFormat (FormatString string)\n"+
            "* valueIcons (object)\n"+
            "* emptyValueIcon (string)\n"+
            "* showValueIconOnly (boolean)\n"+
            "* suppressValueIcon (boolean)\n"+
            "* valueIconWidth (number)\n"+
            "* valueIconHeight (number)\n"+
            "* valueIconSize (number)\n"+
            "* valueIconLeftPadding (number)\n"+
            "* valueIconRightPadding (number)\n"+
            "* imageURLPrefix (string)\n"+
            "* imageURLSuffix (string)\n"+
            "* showPickerIcon (boolean)\n"+
            "* showFocusedPickerIcon (boolean)\n"+
            "* pickerIconProperties (FormItemIcon properties object)\n"+
            "* pickerIconSrc (SCImgURL string)\n"+
            "* pickerIconWidth (integer)\n"+
            "* validators (array of Validator)\n"+
            "* required (boolean)\n"+
            "* requiredWhen (Criteria object)\n"+
            "* visible (boolean)\n"+
            "* visibleWhen (AdvancedCriteria object)\n"+
            "* canEdit (boolean)\n"+
            "* readOnlyDisplay (ReadOnlyDisplayAppearance string)\n"+
            "* readOnlyTextBoxStyle (FormItemBaseStyle string)\n"+
            "* readOnlyWhen (AdvancedCriteria object)\n"+
            "* disabled (boolean)\n"+
            "* disableIconsOnReadOnly (boolean)\n"+
            "* accessKey (string)\n"+
            "* tabIndex (integer)\n"+
            "* globalTabIndex (integer)\n"+
            "* showTitle (boolean)\n"+
            "* titleOrientation (TitleOrientation string)\n"+
            "* titleAlign (Alignment string)\n"+
            "* titleVAlign (VerticalAlignment string)\n"+
            "* clipTitle (boolean)\n"+
            "* wrapTitle (boolean)\n"+
            "* redrawOnChange (boolean)\n"+
            "* validateOnChange (boolean)\n"+
            "* validateOnExit (boolean)\n"+
            "* linearWidth (integer | string)\n"+
            "* cellHeight (number)\n"+
            "* titleColSpan (number)\n"+
            "* colSpan (integer | string)\n"+
            "* linearColSpan (integer | string)\n"+
            "* rowSpan (number)\n"+
            "* startRow (boolean)\n"+
            "* endRow (boolean)\n"+
            "* linearStartRow (integer | string)\n"+
            "* linearEndRow (integer | string)\n"+
            "* align (Alignment string)\n"+
            "* vAlign (VerticalAlignment string)\n"+
            "* textAlign (Alignment string)\n"+
            "* left (integer)\n"+
            "* top (integer)\n"+
            "* autoComplete (AutoComplete string)\n"+
            "* icons (array of FormItemIcon properties objects)\n"+
            "* defaultIconSrc (SCImgURL string)\n"+
            "* showOverIcons (boolean)\n"+
            "* showFocusedIcons (boolean)\n"+
            "* iconWidth (integer)\n"+
            "* iconHeight (integer)\n"+
            "* prompt (HTML string)\n"+
            "* readOnlyHover (HTML string)\n"+
            "* disabledHover (HTML string)\n"+
            "* showIcons (boolean)\n"+
            "* errorIconHeight (number)\n"+
            "* errorIconWidth (number)\n"+
            "* showErrorIcon (boolean)\n"+
            "* showErrorText (boolean)\n"+
            "* showErrorStyle (boolean)\n"+
            "* errorOrientation (Align)\n"+
            "* hint (HTML string)\n"+
            "* showHint (boolean)\n"+
            "* wrapHintText (boolean)\n"+
            "* showFocused (boolean)\n"+
            "* showDisabled (boolean)\n"+
            "* cellStyle (FormItemBaseStyle string)\n"+
            "* hintStyle (CSSStyleName string)\n"+
            "* titleStyle (FormItemBaseStyle string)\n"+
            "* pickerIconStyle (FormItemBaseStyle string)\n"+
            "* controlStyle (FormItemBaseStyle string)\n"+
            "* hoverDelay (number)\n"+
            "* hoverWidth (number | string)\n"+
            "* hoverHeight (number | string)\n"+
            "* hoverAlign (Alignment string)\n"+
            "* hoverVAlign (VerticalAlignment string)\n"+
            "* hoverStyle (CSSStyleName string)\n"+
            "* hoverOpacity (number)\n"+
            "* showClippedTitleOnHover (boolean)\n"+
            "* showClippedValueOnHover (boolean)\n"+
            "* operator (OperatorId string)\n"+
            "* formula (UserFormula object)\n"+
            "* textFormula (UserSummary object)\n"+
            "* saveOnEnter (boolean)\n"+
            "* multiple (boolean)\n"+
            "* errorMessageWidth (integer)\n"+
            "* implicitSave (boolean)\n"+
            "* implicitSaveOnBlur (boolean)\n"+
            "* shouldSaveValue (boolean)\n"+
            "* canSelectText (boolean)\n"+
            "* readOnlyCanSelectText (array of ReadOnlyDisplayAppearance string)\n"+
            "* allowExpressions (boolean)\n"+
            "\n"+
            "### Methods\n"+
            "* click()\n"+
            "* changed()\n",
        format:"Markdown"
    },
    "APIs list:SelectItem":{
        topic:"APIs list for SelectItem",
        content:"Only the following APIs are available on SelectItem:\n"+
            "\n"+
            "## Attributes\n"+
            "* height (number)\n"+
            "* addUnknownValues (boolean)\n"+
            "* defaultValue (Any)\n"+
            "* defaultToFirstOption (boolean)\n"+
            "* multiple (boolean)\n"+
            "* multipleAppearance (MultipleAppearance string)\n"+
            "* textBoxStyle (FormItemBaseStyle string)\n"+
            "* controlStyle (FormItemBaseStyle string)\n"+
            "* pickerIconStyle (FormItemBaseStyle string)\n"+
            "* showFocused (boolean)\n"+
            "* pickerIconWidth (integer)\n"+
            "* pickerIconHeight (integer)\n"+
            "* pickerIconSrc (SCImgURL string)\n"+
            "* showOver (boolean)\n"+
            "* canSelectText (boolean)\n"+
            "* allowEmptyValue (boolean)\n"+
            "* specialValues (ValueMap object)\n"+
            "* autoFetchData (boolean)\n"+
            "* showHintInField (boolean)\n"+
            "* saveOnEnter (boolean)\n"+
            "* escapeHTML (boolean)\n"+
            "* optionDataSource (DataSource | string)\n"+
            "* pickListFields (array of ListGridField objects)\n"+
            "* optionFilterContext (DSRequest properties object)\n"+
            "* optionOperationId (string)\n"+
            "* displayField (string)\n"+
            "* valueField (string)\n"+
            "* filterLocally (boolean)\n"+
            "* pickListCriteria (Criteria object)\n"+
            "* showOptionsFromDataSource (boolean)\n"+
            "* pickListProperties (ListGrid properties object)\n"+
            "\n"+
            "## Inherited from FormItem\n"+
            "\n"+
            "### Attributes\n"+
            "* type (FormItemType string)\n"+
            "* editorType (FormItem class name string)\n"+
            "* name (FieldName string)\n"+
            "* dataPath (DataPath string)\n"+
            "* title (HTML string)\n"+
            "* value (Any)\n"+
            "* ID (GlobalId string)\n"+
            "* valueMap (array | ValueMap object)\n"+
            "* optionCriteria (Criteria object)\n"+
            "* fetchMissingValues (boolean)\n"+
            "* dateFormatter (DateDisplayFormat string)\n"+
            "* timeFormatter (TimeDisplayFormat string)\n"+
            "* decimalPrecision (number)\n"+
            "* decimalPad (number)\n"+
            "* format (FormatString string)\n"+
            "* exportFormat (FormatString string)\n"+
            "* valueIcons (object)\n"+
            "* emptyValueIcon (string)\n"+
            "* showValueIconOnly (boolean)\n"+
            "* suppressValueIcon (boolean)\n"+
            "* valueIconWidth (number)\n"+
            "* valueIconHeight (number)\n"+
            "* valueIconSize (number)\n"+
            "* valueIconLeftPadding (number)\n"+
            "* valueIconRightPadding (number)\n"+
            "* imageURLPrefix (string)\n"+
            "* imageURLSuffix (string)\n"+
            "* showFocusedPickerIcon (boolean)\n"+
            "* pickerIconProperties (FormItemIcon properties object)\n"+
            "* validators (array of Validator)\n"+
            "* required (boolean)\n"+
            "* requiredWhen (Criteria object)\n"+
            "* visible (boolean)\n"+
            "* visibleWhen (AdvancedCriteria object)\n"+
            "* canEdit (boolean)\n"+
            "* readOnlyDisplay (ReadOnlyDisplayAppearance string)\n"+
            "* readOnlyTextBoxStyle (FormItemBaseStyle string)\n"+
            "* readOnlyWhen (AdvancedCriteria object)\n"+
            "* disabled (boolean)\n"+
            "* disableIconsOnReadOnly (boolean)\n"+
            "* accessKey (string)\n"+
            "* tabIndex (integer)\n"+
            "* globalTabIndex (integer)\n"+
            "* selectOnFocus (boolean)\n"+
            "* selectOnClick (boolean)\n"+
            "* changeOnKeypress (boolean)\n"+
            "* showTitle (boolean)\n"+
            "* titleOrientation (TitleOrientation string)\n"+
            "* titleAlign (Alignment string)\n"+
            "* titleVAlign (VerticalAlignment string)\n"+
            "* clipTitle (boolean)\n"+
            "* wrapTitle (boolean)\n"+
            "* redrawOnChange (boolean)\n"+
            "* validateOnChange (boolean)\n"+
            "* validateOnExit (boolean)\n"+
            "* width (integer | string)\n"+
            "* linearWidth (integer | string)\n"+
            "* cellHeight (number)\n"+
            "* titleColSpan (number)\n"+
            "* colSpan (integer | string)\n"+
            "* linearColSpan (integer | string)\n"+
            "* rowSpan (number)\n"+
            "* startRow (boolean)\n"+
            "* endRow (boolean)\n"+
            "* linearStartRow (integer | string)\n"+
            "* linearEndRow (integer | string)\n"+
            "* align (Alignment string)\n"+
            "* vAlign (VerticalAlignment string)\n"+
            "* textAlign (Alignment string)\n"+
            "* left (integer)\n"+
            "* top (integer)\n"+
            "* autoComplete (AutoComplete string)\n"+
            "* icons (array of FormItemIcon properties objects)\n"+
            "* defaultIconSrc (SCImgURL string)\n"+
            "* showOverIcons (boolean)\n"+
            "* showFocusedIcons (boolean)\n"+
            "* iconVAlign (VerticalAlignment string)\n"+
            "* iconWidth (integer)\n"+
            "* iconHeight (integer)\n"+
            "* prompt (HTML string)\n"+
            "* readOnlyHover (HTML string)\n"+
            "* disabledHover (HTML string)\n"+
            "* showIcons (boolean)\n"+
            "* errorIconHeight (number)\n"+
            "* errorIconWidth (number)\n"+
            "* showErrorIcon (boolean)\n"+
            "* showErrorText (boolean)\n"+
            "* showErrorStyle (boolean)\n"+
            "* errorOrientation (Align)\n"+
            "* hint (HTML string)\n"+
            "* showHint (boolean)\n"+
            "* wrapHintText (boolean)\n"+
            "* showDisabled (boolean)\n"+
            "* cellStyle (FormItemBaseStyle string)\n"+
            "* hintStyle (CSSStyleName string)\n"+
            "* titleStyle (FormItemBaseStyle string)\n"+
            "* hoverDelay (number)\n"+
            "* hoverWidth (number | string)\n"+
            "* hoverHeight (number | string)\n"+
            "* hoverAlign (Alignment string)\n"+
            "* hoverVAlign (VerticalAlignment string)\n"+
            "* hoverStyle (CSSStyleName string)\n"+
            "* hoverOpacity (number)\n"+
            "* showClippedTitleOnHover (boolean)\n"+
            "* showClippedValueOnHover (boolean)\n"+
            "* operator (OperatorId string)\n"+
            "* formula (UserFormula object)\n"+
            "* textFormula (UserSummary object)\n"+
            "* errorMessageWidth (integer)\n"+
            "* implicitSave (boolean)\n"+
            "* implicitSaveOnBlur (boolean)\n"+
            "* shouldSaveValue (boolean)\n"+
            "* readOnlyCanSelectText (array of ReadOnlyDisplayAppearance string)\n"+
            "* allowExpressions (boolean)\n"+
            "\n"+
            "### Methods\n"+
            "* click()\n"+
            "* changed()\n",
        format:"Markdown"
    },
    "APIs list:ComboBoxItem":{
        topic:"APIs list for ComboBoxItem",
        content:"Only the following APIs are available on ComboBoxItem:\n"+
            "\n"+
            "## Attributes\n"+
            "* defaultValue (Any)\n"+
            "* defaultToFirstOption (boolean)\n"+
            "* showHintInField (boolean)\n"+
            "* showPickerIcon (boolean)\n"+
            "* pickerIconWidth (integer)\n"+
            "* pickerIconHeight (integer)\n"+
            "* pickerIconSrc (SCImgURL string)\n"+
            "* showPickListOnKeypress (boolean)\n"+
            "* saveOnEnter (boolean)\n"+
            "* completeOnTab (boolean)\n"+
            "* completeOnEnter (boolean)\n"+
            "* formatOnBlur (boolean)\n"+
            "* specialValues (ValueMap object)\n"+
            "* addUnknownValues (boolean)\n"+
            "* optionDataSource (DataSource | string)\n"+
            "* pickListFields (array of ListGridField objects)\n"+
            "* optionFilterContext (DSRequest properties object)\n"+
            "* optionOperationId (string)\n"+
            "* displayField (string)\n"+
            "* valueField (string)\n"+
            "* filterLocally (boolean)\n"+
            "* pickListCriteria (Criteria object)\n"+
            "* showOptionsFromDataSource (boolean)\n"+
            "* pickListProperties (ListGrid properties object)\n"+
            "* autoOpenTree (string)\n"+
            "* autoFetchData (boolean)\n"+
            "* filterFields (array of string)\n"+
            "* textMatchStyle (TextMatchStyle string)\n"+
            "* showAllOptions (boolean)\n"+
            "* separatorRows (array of ListGridRecord[)\n"+
            "* allowExpressions (boolean)\n"+
            "\n"+
            "## Inherited from TextItem\n"+
            "\n"+
            "### Attributes\n"+
            "* width (number)\n"+
            "* height (number)\n"+
            "* textBoxStyle (FormItemBaseStyle string)\n"+
            "* length (number)\n"+
            "* selectOnFocus (boolean)\n"+
            "* selectOnClick (boolean)\n"+
            "* changeOnKeypress (boolean)\n"+
            "* fetchMissingValues (boolean)\n"+
            "* escapeHTML (boolean)\n"+
            "\n"+
            "## Inherited from FormItem\n"+
            "\n"+
            "### Attributes\n"+
            "* type (FormItemType string)\n"+
            "* editorType (FormItem class name string)\n"+
            "* name (FieldName string)\n"+
            "* dataPath (DataPath string)\n"+
            "* title (HTML string)\n"+
            "* value (Any)\n"+
            "* ID (GlobalId string)\n"+
            "* valueMap (array | ValueMap object)\n"+
            "* optionCriteria (Criteria object)\n"+
            "* dateFormatter (DateDisplayFormat string)\n"+
            "* timeFormatter (TimeDisplayFormat string)\n"+
            "* decimalPrecision (number)\n"+
            "* decimalPad (number)\n"+
            "* format (FormatString string)\n"+
            "* exportFormat (FormatString string)\n"+
            "* valueIcons (object)\n"+
            "* emptyValueIcon (string)\n"+
            "* showValueIconOnly (boolean)\n"+
            "* suppressValueIcon (boolean)\n"+
            "* valueIconWidth (number)\n"+
            "* valueIconHeight (number)\n"+
            "* valueIconSize (number)\n"+
            "* valueIconLeftPadding (number)\n"+
            "* valueIconRightPadding (number)\n"+
            "* imageURLPrefix (string)\n"+
            "* imageURLSuffix (string)\n"+
            "* showFocusedPickerIcon (boolean)\n"+
            "* pickerIconProperties (FormItemIcon properties object)\n"+
            "* validators (array of Validator)\n"+
            "* required (boolean)\n"+
            "* requiredWhen (Criteria object)\n"+
            "* visible (boolean)\n"+
            "* visibleWhen (AdvancedCriteria object)\n"+
            "* canEdit (boolean)\n"+
            "* readOnlyDisplay (ReadOnlyDisplayAppearance string)\n"+
            "* readOnlyTextBoxStyle (FormItemBaseStyle string)\n"+
            "* readOnlyWhen (AdvancedCriteria object)\n"+
            "* disabled (boolean)\n"+
            "* disableIconsOnReadOnly (boolean)\n"+
            "* accessKey (string)\n"+
            "* tabIndex (integer)\n"+
            "* globalTabIndex (integer)\n"+
            "* showTitle (boolean)\n"+
            "* titleOrientation (TitleOrientation string)\n"+
            "* titleAlign (Alignment string)\n"+
            "* titleVAlign (VerticalAlignment string)\n"+
            "* clipTitle (boolean)\n"+
            "* wrapTitle (boolean)\n"+
            "* redrawOnChange (boolean)\n"+
            "* validateOnChange (boolean)\n"+
            "* validateOnExit (boolean)\n"+
            "* linearWidth (integer | string)\n"+
            "* cellHeight (number)\n"+
            "* titleColSpan (number)\n"+
            "* colSpan (integer | string)\n"+
            "* linearColSpan (integer | string)\n"+
            "* rowSpan (number)\n"+
            "* startRow (boolean)\n"+
            "* endRow (boolean)\n"+
            "* linearStartRow (integer | string)\n"+
            "* linearEndRow (integer | string)\n"+
            "* align (Alignment string)\n"+
            "* vAlign (VerticalAlignment string)\n"+
            "* textAlign (Alignment string)\n"+
            "* left (integer)\n"+
            "* top (integer)\n"+
            "* autoComplete (AutoComplete string)\n"+
            "* icons (array of FormItemIcon properties objects)\n"+
            "* defaultIconSrc (SCImgURL string)\n"+
            "* showOverIcons (boolean)\n"+
            "* showFocusedIcons (boolean)\n"+
            "* iconVAlign (VerticalAlignment string)\n"+
            "* iconWidth (integer)\n"+
            "* iconHeight (integer)\n"+
            "* prompt (HTML string)\n"+
            "* readOnlyHover (HTML string)\n"+
            "* disabledHover (HTML string)\n"+
            "* showIcons (boolean)\n"+
            "* errorIconHeight (number)\n"+
            "* errorIconWidth (number)\n"+
            "* showErrorIcon (boolean)\n"+
            "* showErrorText (boolean)\n"+
            "* showErrorStyle (boolean)\n"+
            "* errorOrientation (Align)\n"+
            "* hint (HTML string)\n"+
            "* showHint (boolean)\n"+
            "* wrapHintText (boolean)\n"+
            "* showFocused (boolean)\n"+
            "* showDisabled (boolean)\n"+
            "* cellStyle (FormItemBaseStyle string)\n"+
            "* hintStyle (CSSStyleName string)\n"+
            "* titleStyle (FormItemBaseStyle string)\n"+
            "* pickerIconStyle (FormItemBaseStyle string)\n"+
            "* controlStyle (FormItemBaseStyle string)\n"+
            "* hoverDelay (number)\n"+
            "* hoverWidth (number | string)\n"+
            "* hoverHeight (number | string)\n"+
            "* hoverAlign (Alignment string)\n"+
            "* hoverVAlign (VerticalAlignment string)\n"+
            "* hoverStyle (CSSStyleName string)\n"+
            "* hoverOpacity (number)\n"+
            "* showClippedTitleOnHover (boolean)\n"+
            "* showClippedValueOnHover (boolean)\n"+
            "* operator (OperatorId string)\n"+
            "* formula (UserFormula object)\n"+
            "* textFormula (UserSummary object)\n"+
            "* multiple (boolean)\n"+
            "* errorMessageWidth (integer)\n"+
            "* implicitSave (boolean)\n"+
            "* implicitSaveOnBlur (boolean)\n"+
            "* shouldSaveValue (boolean)\n"+
            "* canSelectText (boolean)\n"+
            "* readOnlyCanSelectText (array of ReadOnlyDisplayAppearance string)\n"+
            "\n"+
            "### Methods\n"+
            "* click()\n"+
            "* changed()\n",
        format:"Markdown"
    },
    "APIs list:CheckboxItem":{
        topic:"APIs list for CheckboxItem",
        content:"Only the following APIs are available on CheckboxItem:\n"+
            "\n"+
            "## Attributes\n"+
            "* defaultValue (boolean)\n"+
            "* titleStyle (FormItemBaseStyle string)\n"+
            "* textBoxStyle (FormItemBaseStyle string)\n"+
            "* width (number)\n"+
            "* labelAsTitle (boolean)\n"+
            "* checkedImage (SCImgURL string)\n"+
            "* uncheckedImage (SCImgURL string)\n"+
            "* unsetImage (SCImgURL string)\n"+
            "* valueIconWidth (number)\n"+
            "* valueIconHeight (number)\n"+
            "* valueMap (object | array)\n"+
            "* allowEmptyValue (boolean)\n"+
            "* showNullAsTrue (boolean)\n"+
            "\n"+
            "## Inherited from FormItem\n"+
            "\n"+
            "### Attributes\n"+
            "* editorType (FormItem class name string)\n"+
            "* name (FieldName string)\n"+
            "* dataPath (DataPath string)\n"+
            "* title (HTML string)\n"+
            "* value (Any)\n"+
            "* ID (GlobalId string)\n"+
            "* optionDataSource (DataSource | string)\n"+
            "* optionOperationId (string)\n"+
            "* valueField (string)\n"+
            "* displayField (string)\n"+
            "* fetchMissingValues (boolean)\n"+
            "* filterLocally (boolean)\n"+
            "* dateFormatter (DateDisplayFormat string)\n"+
            "* timeFormatter (TimeDisplayFormat string)\n"+
            "* decimalPrecision (number)\n"+
            "* decimalPad (number)\n"+
            "* format (FormatString string)\n"+
            "* exportFormat (FormatString string)\n"+
            "* valueIcons (object)\n"+
            "* emptyValueIcon (string)\n"+
            "* showValueIconOnly (boolean)\n"+
            "* suppressValueIcon (boolean)\n"+
            "* valueIconSize (number)\n"+
            "* valueIconLeftPadding (number)\n"+
            "* valueIconRightPadding (number)\n"+
            "* imageURLPrefix (string)\n"+
            "* imageURLSuffix (string)\n"+
            "* showPickerIcon (boolean)\n"+
            "* showFocusedPickerIcon (boolean)\n"+
            "* pickerIconProperties (FormItemIcon properties object)\n"+
            "* pickerIconSrc (SCImgURL string)\n"+
            "* pickerIconWidth (integer)\n"+
            "* pickerIconHeight (integer)\n"+
            "* validators (array of Validator)\n"+
            "* requiredWhen (Criteria object)\n"+
            "* visible (boolean)\n"+
            "* visibleWhen (AdvancedCriteria object)\n"+
            "* canEdit (boolean)\n"+
            "* readOnlyDisplay (ReadOnlyDisplayAppearance string)\n"+
            "* readOnlyTextBoxStyle (FormItemBaseStyle string)\n"+
            "* readOnlyWhen (AdvancedCriteria object)\n"+
            "* disabled (boolean)\n"+
            "* disableIconsOnReadOnly (boolean)\n"+
            "* accessKey (string)\n"+
            "* tabIndex (integer)\n"+
            "* globalTabIndex (integer)\n"+
            "* selectOnFocus (boolean)\n"+
            "* selectOnClick (boolean)\n"+
            "* changeOnKeypress (boolean)\n"+
            "* titleOrientation (TitleOrientation string)\n"+
            "* titleVAlign (VerticalAlignment string)\n"+
            "* clipTitle (boolean)\n"+
            "* wrapTitle (boolean)\n"+
            "* redrawOnChange (boolean)\n"+
            "* validateOnChange (boolean)\n"+
            "* validateOnExit (boolean)\n"+
            "* linearWidth (integer | string)\n"+
            "* height (integer | string)\n"+
            "* cellHeight (number)\n"+
            "* titleColSpan (number)\n"+
            "* colSpan (integer | string)\n"+
            "* linearColSpan (integer | string)\n"+
            "* rowSpan (number)\n"+
            "* startRow (boolean)\n"+
            "* endRow (boolean)\n"+
            "* linearStartRow (integer | string)\n"+
            "* linearEndRow (integer | string)\n"+
            "* align (Alignment string)\n"+
            "* vAlign (VerticalAlignment string)\n"+
            "* textAlign (Alignment string)\n"+
            "* left (integer)\n"+
            "* top (integer)\n"+
            "* autoComplete (AutoComplete string)\n"+
            "* icons (array of FormItemIcon properties objects)\n"+
            "* defaultIconSrc (SCImgURL string)\n"+
            "* showOverIcons (boolean)\n"+
            "* showFocusedIcons (boolean)\n"+
            "* iconVAlign (VerticalAlignment string)\n"+
            "* iconWidth (integer)\n"+
            "* iconHeight (integer)\n"+
            "* prompt (HTML string)\n"+
            "* readOnlyHover (HTML string)\n"+
            "* disabledHover (HTML string)\n"+
            "* showIcons (boolean)\n"+
            "* errorIconHeight (number)\n"+
            "* errorIconWidth (number)\n"+
            "* showErrorIcon (boolean)\n"+
            "* showErrorText (boolean)\n"+
            "* showErrorStyle (boolean)\n"+
            "* errorOrientation (Align)\n"+
            "* hint (HTML string)\n"+
            "* showHint (boolean)\n"+
            "* wrapHintText (boolean)\n"+
            "* showFocused (boolean)\n"+
            "* showDisabled (boolean)\n"+
            "* cellStyle (FormItemBaseStyle string)\n"+
            "* hintStyle (CSSStyleName string)\n"+
            "* pickerIconStyle (FormItemBaseStyle string)\n"+
            "* controlStyle (FormItemBaseStyle string)\n"+
            "* hoverDelay (number)\n"+
            "* hoverWidth (number | string)\n"+
            "* hoverHeight (number | string)\n"+
            "* hoverAlign (Alignment string)\n"+
            "* hoverVAlign (VerticalAlignment string)\n"+
            "* hoverStyle (CSSStyleName string)\n"+
            "* hoverOpacity (number)\n"+
            "* showClippedTitleOnHover (boolean)\n"+
            "* showClippedValueOnHover (boolean)\n"+
            "* operator (OperatorId string)\n"+
            "* formula (UserFormula object)\n"+
            "* textFormula (UserSummary object)\n"+
            "* saveOnEnter (boolean)\n"+
            "* multiple (boolean)\n"+
            "* errorMessageWidth (integer)\n"+
            "* implicitSave (boolean)\n"+
            "* implicitSaveOnBlur (boolean)\n"+
            "* shouldSaveValue (boolean)\n"+
            "* canSelectText (boolean)\n"+
            "* readOnlyCanSelectText (array of ReadOnlyDisplayAppearance string)\n"+
            "* allowExpressions (boolean)\n"+
            "\n"+
            "### Methods\n"+
            "* click()\n"+
            "* changed()\n",
        format:"Markdown"
    },
    "APIs list:RadioGroupItem":{
        topic:"APIs list for RadioGroupItem",
        content:"Only the following APIs are available on RadioGroupItem:\n"+
            "\n"+
            "## Attributes\n"+
            "* vertical (boolean)\n"+
            "* textBoxStyle (FormItemBaseStyle string)\n"+
            "* wrap (boolean)\n"+
            "* disabledValues (array of string)\n"+
            "\n"+
            "## Inherited from FormItem\n"+
            "\n"+
            "### Attributes\n"+
            "* type (FormItemType string)\n"+
            "* editorType (FormItem class name string)\n"+
            "* name (FieldName string)\n"+
            "* dataPath (DataPath string)\n"+
            "* title (HTML string)\n"+
            "* defaultValue (Any)\n"+
            "* value (Any)\n"+
            "* ID (GlobalId string)\n"+
            "* valueMap (array | ValueMap object)\n"+
            "* optionDataSource (DataSource | string)\n"+
            "* optionOperationId (string)\n"+
            "* valueField (string)\n"+
            "* displayField (string)\n"+
            "* fetchMissingValues (boolean)\n"+
            "* filterLocally (boolean)\n"+
            "* dateFormatter (DateDisplayFormat string)\n"+
            "* timeFormatter (TimeDisplayFormat string)\n"+
            "* decimalPrecision (number)\n"+
            "* decimalPad (number)\n"+
            "* format (FormatString string)\n"+
            "* exportFormat (FormatString string)\n"+
            "* valueIcons (object)\n"+
            "* emptyValueIcon (string)\n"+
            "* showValueIconOnly (boolean)\n"+
            "* suppressValueIcon (boolean)\n"+
            "* valueIconWidth (number)\n"+
            "* valueIconHeight (number)\n"+
            "* valueIconSize (number)\n"+
            "* valueIconLeftPadding (number)\n"+
            "* valueIconRightPadding (number)\n"+
            "* imageURLPrefix (string)\n"+
            "* imageURLSuffix (string)\n"+
            "* showPickerIcon (boolean)\n"+
            "* showFocusedPickerIcon (boolean)\n"+
            "* pickerIconProperties (FormItemIcon properties object)\n"+
            "* pickerIconSrc (SCImgURL string)\n"+
            "* pickerIconWidth (integer)\n"+
            "* pickerIconHeight (integer)\n"+
            "* validators (array of Validator)\n"+
            "* required (boolean)\n"+
            "* requiredWhen (Criteria object)\n"+
            "* visible (boolean)\n"+
            "* visibleWhen (AdvancedCriteria object)\n"+
            "* canEdit (boolean)\n"+
            "* readOnlyDisplay (ReadOnlyDisplayAppearance string)\n"+
            "* readOnlyTextBoxStyle (FormItemBaseStyle string)\n"+
            "* readOnlyWhen (AdvancedCriteria object)\n"+
            "* disabled (boolean)\n"+
            "* disableIconsOnReadOnly (boolean)\n"+
            "* accessKey (string)\n"+
            "* tabIndex (integer)\n"+
            "* globalTabIndex (integer)\n"+
            "* selectOnFocus (boolean)\n"+
            "* selectOnClick (boolean)\n"+
            "* changeOnKeypress (boolean)\n"+
            "* showTitle (boolean)\n"+
            "* titleOrientation (TitleOrientation string)\n"+
            "* titleAlign (Alignment string)\n"+
            "* titleVAlign (VerticalAlignment string)\n"+
            "* clipTitle (boolean)\n"+
            "* wrapTitle (boolean)\n"+
            "* redrawOnChange (boolean)\n"+
            "* validateOnChange (boolean)\n"+
            "* validateOnExit (boolean)\n"+
            "* width (integer | string)\n"+
            "* linearWidth (integer | string)\n"+
            "* height (integer | string)\n"+
            "* cellHeight (number)\n"+
            "* titleColSpan (number)\n"+
            "* colSpan (integer | string)\n"+
            "* linearColSpan (integer | string)\n"+
            "* rowSpan (number)\n"+
            "* startRow (boolean)\n"+
            "* endRow (boolean)\n"+
            "* linearStartRow (integer | string)\n"+
            "* linearEndRow (integer | string)\n"+
            "* align (Alignment string)\n"+
            "* vAlign (VerticalAlignment string)\n"+
            "* textAlign (Alignment string)\n"+
            "* left (integer)\n"+
            "* top (integer)\n"+
            "* autoComplete (AutoComplete string)\n"+
            "* icons (array of FormItemIcon properties objects)\n"+
            "* defaultIconSrc (SCImgURL string)\n"+
            "* showOverIcons (boolean)\n"+
            "* showFocusedIcons (boolean)\n"+
            "* iconVAlign (VerticalAlignment string)\n"+
            "* iconWidth (integer)\n"+
            "* iconHeight (integer)\n"+
            "* readOnlyHover (HTML string)\n"+
            "* disabledHover (HTML string)\n"+
            "* showIcons (boolean)\n"+
            "* errorIconHeight (number)\n"+
            "* errorIconWidth (number)\n"+
            "* showErrorIcon (boolean)\n"+
            "* showErrorText (boolean)\n"+
            "* showErrorStyle (boolean)\n"+
            "* errorOrientation (Align)\n"+
            "* hint (HTML string)\n"+
            "* showHint (boolean)\n"+
            "* wrapHintText (boolean)\n"+
            "* showFocused (boolean)\n"+
            "* showDisabled (boolean)\n"+
            "* cellStyle (FormItemBaseStyle string)\n"+
            "* hintStyle (CSSStyleName string)\n"+
            "* titleStyle (FormItemBaseStyle string)\n"+
            "* pickerIconStyle (FormItemBaseStyle string)\n"+
            "* controlStyle (FormItemBaseStyle string)\n"+
            "* hoverDelay (number)\n"+
            "* hoverWidth (number | string)\n"+
            "* hoverHeight (number | string)\n"+
            "* hoverAlign (Alignment string)\n"+
            "* hoverVAlign (VerticalAlignment string)\n"+
            "* hoverStyle (CSSStyleName string)\n"+
            "* hoverOpacity (number)\n"+
            "* showClippedTitleOnHover (boolean)\n"+
            "* showClippedValueOnHover (boolean)\n"+
            "* operator (OperatorId string)\n"+
            "* formula (UserFormula object)\n"+
            "* textFormula (UserSummary object)\n"+
            "* saveOnEnter (boolean)\n"+
            "* multiple (boolean)\n"+
            "* errorMessageWidth (integer)\n"+
            "* implicitSave (boolean)\n"+
            "* implicitSaveOnBlur (boolean)\n"+
            "* shouldSaveValue (boolean)\n"+
            "* canSelectText (boolean)\n"+
            "* readOnlyCanSelectText (array of ReadOnlyDisplayAppearance string)\n"+
            "* allowExpressions (boolean)\n"+
            "\n"+
            "### Methods\n"+
            "* click()\n"+
            "* changed()\n",
        format:"Markdown"
    },
    "APIs list:DateItem":{
        topic:"APIs list for DateItem",
        content:"Only the following APIs are available on DateItem:\n"+
            "\n"+
            "## Attributes\n"+
            "* defaultValue (Date object)\n"+
            "* wrapHintText (boolean)\n"+
            "* showHintInField (boolean)\n"+
            "* useTextField (boolean)\n"+
            "* textAlign (Alignment string)\n"+
            "* invalidDateStringMessage (string)\n"+
            "* startDate (Date object)\n"+
            "* endDate (Date object)\n"+
            "* centuryThreshold (number)\n"+
            "* use24HourTime (boolean)\n"+
            "* showPickerTimeItem (boolean)\n"+
            "* dateFormatter (DateDisplayFormat string)\n"+
            "* inputFormat (DateInputFormat string)\n"+
            "* selectorFormat (DateItemSelectorFormat string)\n"+
            "* showChooserFiscalYearPicker (boolean)\n"+
            "* showChooserWeekPicker (boolean)\n"+
            "\n"+
            "## Inherited from FormItem\n"+
            "\n"+
            "### Attributes\n"+
            "* editorType (FormItem class name string)\n"+
            "* name (FieldName string)\n"+
            "* dataPath (DataPath string)\n"+
            "* title (HTML string)\n"+
            "* value (Any)\n"+
            "* ID (GlobalId string)\n"+
            "* valueMap (array | ValueMap object)\n"+
            "* optionDataSource (DataSource | string)\n"+
            "* optionOperationId (string)\n"+
            "* valueField (string)\n"+
            "* displayField (string)\n"+
            "* fetchMissingValues (boolean)\n"+
            "* filterLocally (boolean)\n"+
            "* timeFormatter (TimeDisplayFormat string)\n"+
            "* decimalPrecision (number)\n"+
            "* decimalPad (number)\n"+
            "* format (FormatString string)\n"+
            "* exportFormat (FormatString string)\n"+
            "* valueIcons (object)\n"+
            "* emptyValueIcon (string)\n"+
            "* showValueIconOnly (boolean)\n"+
            "* suppressValueIcon (boolean)\n"+
            "* valueIconWidth (number)\n"+
            "* valueIconHeight (number)\n"+
            "* valueIconSize (number)\n"+
            "* valueIconLeftPadding (number)\n"+
            "* valueIconRightPadding (number)\n"+
            "* imageURLPrefix (string)\n"+
            "* imageURLSuffix (string)\n"+
            "* showPickerIcon (boolean)\n"+
            "* showFocusedPickerIcon (boolean)\n"+
            "* pickerIconProperties (FormItemIcon properties object)\n"+
            "* pickerIconSrc (SCImgURL string)\n"+
            "* pickerIconWidth (integer)\n"+
            "* pickerIconHeight (integer)\n"+
            "* validators (array of Validator)\n"+
            "* requiredWhen (Criteria object)\n"+
            "* visible (boolean)\n"+
            "* visibleWhen (AdvancedCriteria object)\n"+
            "* canEdit (boolean)\n"+
            "* readOnlyDisplay (ReadOnlyDisplayAppearance string)\n"+
            "* readOnlyTextBoxStyle (FormItemBaseStyle string)\n"+
            "* readOnlyWhen (AdvancedCriteria object)\n"+
            "* disabled (boolean)\n"+
            "* disableIconsOnReadOnly (boolean)\n"+
            "* accessKey (string)\n"+
            "* tabIndex (integer)\n"+
            "* globalTabIndex (integer)\n"+
            "* selectOnFocus (boolean)\n"+
            "* selectOnClick (boolean)\n"+
            "* changeOnKeypress (boolean)\n"+
            "* showTitle (boolean)\n"+
            "* titleOrientation (TitleOrientation string)\n"+
            "* titleAlign (Alignment string)\n"+
            "* titleVAlign (VerticalAlignment string)\n"+
            "* clipTitle (boolean)\n"+
            "* wrapTitle (boolean)\n"+
            "* redrawOnChange (boolean)\n"+
            "* validateOnChange (boolean)\n"+
            "* validateOnExit (boolean)\n"+
            "* width (integer | string)\n"+
            "* linearWidth (integer | string)\n"+
            "* height (integer | string)\n"+
            "* cellHeight (number)\n"+
            "* titleColSpan (number)\n"+
            "* colSpan (integer | string)\n"+
            "* linearColSpan (integer | string)\n"+
            "* rowSpan (number)\n"+
            "* startRow (boolean)\n"+
            "* endRow (boolean)\n"+
            "* linearStartRow (integer | string)\n"+
            "* linearEndRow (integer | string)\n"+
            "* align (Alignment string)\n"+
            "* vAlign (VerticalAlignment string)\n"+
            "* left (integer)\n"+
            "* top (integer)\n"+
            "* autoComplete (AutoComplete string)\n"+
            "* icons (array of FormItemIcon properties objects)\n"+
            "* defaultIconSrc (SCImgURL string)\n"+
            "* showOverIcons (boolean)\n"+
            "* showFocusedIcons (boolean)\n"+
            "* iconVAlign (VerticalAlignment string)\n"+
            "* iconWidth (integer)\n"+
            "* iconHeight (integer)\n"+
            "* prompt (HTML string)\n"+
            "* readOnlyHover (HTML string)\n"+
            "* disabledHover (HTML string)\n"+
            "* showIcons (boolean)\n"+
            "* errorIconHeight (number)\n"+
            "* errorIconWidth (number)\n"+
            "* showErrorIcon (boolean)\n"+
            "* showErrorText (boolean)\n"+
            "* showErrorStyle (boolean)\n"+
            "* errorOrientation (Align)\n"+
            "* hint (HTML string)\n"+
            "* showHint (boolean)\n"+
            "* showFocused (boolean)\n"+
            "* showDisabled (boolean)\n"+
            "* cellStyle (FormItemBaseStyle string)\n"+
            "* hintStyle (CSSStyleName string)\n"+
            "* titleStyle (FormItemBaseStyle string)\n"+
            "* textBoxStyle (FormItemBaseStyle string)\n"+
            "* pickerIconStyle (FormItemBaseStyle string)\n"+
            "* controlStyle (FormItemBaseStyle string)\n"+
            "* hoverDelay (number)\n"+
            "* hoverWidth (number | string)\n"+
            "* hoverHeight (number | string)\n"+
            "* hoverAlign (Alignment string)\n"+
            "* hoverVAlign (VerticalAlignment string)\n"+
            "* hoverStyle (CSSStyleName string)\n"+
            "* hoverOpacity (number)\n"+
            "* showClippedTitleOnHover (boolean)\n"+
            "* showClippedValueOnHover (boolean)\n"+
            "* operator (OperatorId string)\n"+
            "* formula (UserFormula object)\n"+
            "* textFormula (UserSummary object)\n"+
            "* saveOnEnter (boolean)\n"+
            "* multiple (boolean)\n"+
            "* errorMessageWidth (integer)\n"+
            "* implicitSave (boolean)\n"+
            "* implicitSaveOnBlur (boolean)\n"+
            "* shouldSaveValue (boolean)\n"+
            "* canSelectText (boolean)\n"+
            "* readOnlyCanSelectText (array of ReadOnlyDisplayAppearance string)\n"+
            "* allowExpressions (boolean)\n"+
            "\n"+
            "### Methods\n"+
            "* click()\n"+
            "* changed()\n",
        format:"Markdown"
    },
    "APIs list:TimeItem":{
        topic:"APIs list for TimeItem",
        content:"Only the following APIs are available on TimeItem:\n"+
            "\n"+
            "## Attributes\n"+
            "* wrapHintText (boolean)\n"+
            "* showHintInField (boolean)\n"+
            "* showHourItem (boolean)\n"+
            "* hourItemTitle (HTML string)\n"+
            "* hourItemPrompt (HTML string)\n"+
            "* showMinuteItem (boolean)\n"+
            "* minuteItemTitle (HTML string)\n"+
            "* minuteItemPrompt (HTML string)\n"+
            "* showSecondItem (boolean)\n"+
            "* secondItemTitle (HTML string)\n"+
            "* secondItemPrompt (HTML string)\n"+
            "* showMillisecondItem (boolean)\n"+
            "* millisecondItemTitle (HTML string)\n"+
            "* millisecondItemPrompt (HTML string)\n"+
            "* timeFormatter (TimeDisplayFormat string)\n"+
            "* useTextField (boolean)\n"+
            "* textAlign (Alignment string)\n"+
            "* textBoxStyle (CSSStyleName string)\n"+
            "* hourMinValue (number)\n"+
            "* hourMaxValue (number)\n"+
            "* hourIncrement (number)\n"+
            "* minuteMinValue (number)\n"+
            "* minuteMaxValue (number)\n"+
            "* minuteIncrement (number)\n"+
            "* secondMinValue (number)\n"+
            "* secondMaxValue (number)\n"+
            "* secondIncrement (number)\n"+
            "* millisecondMinValue (number)\n"+
            "* millisecondMaxValue (number)\n"+
            "* millisecondIncrement (number)\n"+
            "\n"+
            "## Inherited from FormItem\n"+
            "\n"+
            "### Attributes\n"+
            "* editorType (FormItem class name string)\n"+
            "* name (FieldName string)\n"+
            "* dataPath (DataPath string)\n"+
            "* title (HTML string)\n"+
            "* defaultValue (Any)\n"+
            "* value (Any)\n"+
            "* ID (GlobalId string)\n"+
            "* valueMap (array | ValueMap object)\n"+
            "* optionDataSource (DataSource | string)\n"+
            "* optionOperationId (string)\n"+
            "* valueField (string)\n"+
            "* displayField (string)\n"+
            "* fetchMissingValues (boolean)\n"+
            "* filterLocally (boolean)\n"+
            "* dateFormatter (DateDisplayFormat string)\n"+
            "* decimalPrecision (number)\n"+
            "* decimalPad (number)\n"+
            "* format (FormatString string)\n"+
            "* exportFormat (FormatString string)\n"+
            "* valueIcons (object)\n"+
            "* emptyValueIcon (string)\n"+
            "* showValueIconOnly (boolean)\n"+
            "* suppressValueIcon (boolean)\n"+
            "* valueIconWidth (number)\n"+
            "* valueIconHeight (number)\n"+
            "* valueIconSize (number)\n"+
            "* valueIconLeftPadding (number)\n"+
            "* valueIconRightPadding (number)\n"+
            "* imageURLPrefix (string)\n"+
            "* imageURLSuffix (string)\n"+
            "* showPickerIcon (boolean)\n"+
            "* showFocusedPickerIcon (boolean)\n"+
            "* pickerIconProperties (FormItemIcon properties object)\n"+
            "* pickerIconSrc (SCImgURL string)\n"+
            "* pickerIconWidth (integer)\n"+
            "* pickerIconHeight (integer)\n"+
            "* validators (array of Validator)\n"+
            "* required (boolean)\n"+
            "* requiredWhen (Criteria object)\n"+
            "* visible (boolean)\n"+
            "* visibleWhen (AdvancedCriteria object)\n"+
            "* canEdit (boolean)\n"+
            "* readOnlyDisplay (ReadOnlyDisplayAppearance string)\n"+
            "* readOnlyTextBoxStyle (FormItemBaseStyle string)\n"+
            "* readOnlyWhen (AdvancedCriteria object)\n"+
            "* disabled (boolean)\n"+
            "* disableIconsOnReadOnly (boolean)\n"+
            "* accessKey (string)\n"+
            "* tabIndex (integer)\n"+
            "* globalTabIndex (integer)\n"+
            "* selectOnFocus (boolean)\n"+
            "* selectOnClick (boolean)\n"+
            "* changeOnKeypress (boolean)\n"+
            "* showTitle (boolean)\n"+
            "* titleOrientation (TitleOrientation string)\n"+
            "* titleAlign (Alignment string)\n"+
            "* titleVAlign (VerticalAlignment string)\n"+
            "* clipTitle (boolean)\n"+
            "* wrapTitle (boolean)\n"+
            "* redrawOnChange (boolean)\n"+
            "* validateOnChange (boolean)\n"+
            "* validateOnExit (boolean)\n"+
            "* width (integer | string)\n"+
            "* linearWidth (integer | string)\n"+
            "* height (integer | string)\n"+
            "* cellHeight (number)\n"+
            "* titleColSpan (number)\n"+
            "* colSpan (integer | string)\n"+
            "* linearColSpan (integer | string)\n"+
            "* rowSpan (number)\n"+
            "* startRow (boolean)\n"+
            "* endRow (boolean)\n"+
            "* linearStartRow (integer | string)\n"+
            "* linearEndRow (integer | string)\n"+
            "* align (Alignment string)\n"+
            "* vAlign (VerticalAlignment string)\n"+
            "* left (integer)\n"+
            "* top (integer)\n"+
            "* autoComplete (AutoComplete string)\n"+
            "* icons (array of FormItemIcon properties objects)\n"+
            "* defaultIconSrc (SCImgURL string)\n"+
            "* showOverIcons (boolean)\n"+
            "* showFocusedIcons (boolean)\n"+
            "* iconVAlign (VerticalAlignment string)\n"+
            "* iconWidth (integer)\n"+
            "* iconHeight (integer)\n"+
            "* prompt (HTML string)\n"+
            "* readOnlyHover (HTML string)\n"+
            "* disabledHover (HTML string)\n"+
            "* showIcons (boolean)\n"+
            "* errorIconHeight (number)\n"+
            "* errorIconWidth (number)\n"+
            "* showErrorIcon (boolean)\n"+
            "* showErrorText (boolean)\n"+
            "* showErrorStyle (boolean)\n"+
            "* errorOrientation (Align)\n"+
            "* hint (HTML string)\n"+
            "* showHint (boolean)\n"+
            "* showFocused (boolean)\n"+
            "* showDisabled (boolean)\n"+
            "* cellStyle (FormItemBaseStyle string)\n"+
            "* hintStyle (CSSStyleName string)\n"+
            "* titleStyle (FormItemBaseStyle string)\n"+
            "* pickerIconStyle (FormItemBaseStyle string)\n"+
            "* controlStyle (FormItemBaseStyle string)\n"+
            "* hoverDelay (number)\n"+
            "* hoverWidth (number | string)\n"+
            "* hoverHeight (number | string)\n"+
            "* hoverAlign (Alignment string)\n"+
            "* hoverVAlign (VerticalAlignment string)\n"+
            "* hoverStyle (CSSStyleName string)\n"+
            "* hoverOpacity (number)\n"+
            "* showClippedTitleOnHover (boolean)\n"+
            "* showClippedValueOnHover (boolean)\n"+
            "* operator (OperatorId string)\n"+
            "* formula (UserFormula object)\n"+
            "* textFormula (UserSummary object)\n"+
            "* saveOnEnter (boolean)\n"+
            "* multiple (boolean)\n"+
            "* errorMessageWidth (integer)\n"+
            "* implicitSave (boolean)\n"+
            "* implicitSaveOnBlur (boolean)\n"+
            "* shouldSaveValue (boolean)\n"+
            "* canSelectText (boolean)\n"+
            "* readOnlyCanSelectText (array of ReadOnlyDisplayAppearance string)\n"+
            "* allowExpressions (boolean)\n"+
            "\n"+
            "### Methods\n"+
            "* click()\n"+
            "* changed()\n",
        format:"Markdown"
    },
    "APIs list:Button":{
        topic:"APIs list for Button",
        content:"Only the following APIs are available on Button:\n"+
            "\n"+
            "## Attributes\n"+
            "* title (HTML string)\n"+
            "* hiliteAccessKey (boolean)\n"+
            "* icon (SCImgURL string)\n"+
            "* iconSize (integer)\n"+
            "* iconWidth (integer)\n"+
            "* iconHeight (integer)\n"+
            "* iconOrientation (string)\n"+
            "* iconAlign (string)\n"+
            "* iconSpacing (integer)\n"+
            "* showDisabledIcon (boolean)\n"+
            "* showRollOverIcon (boolean)\n"+
            "* showFocusedIcon (boolean)\n"+
            "* showDownIcon (boolean)\n"+
            "* showSelectedIcon (boolean)\n"+
            "* autoFit (boolean)\n"+
            "* width (number | string)\n"+
            "* height (number | string)\n"+
            "* styleName (CSSStyleName string)\n"+
            "* baseStyle (CSSStyleName string)\n"+
            "* selected (boolean)\n"+
            "* radioGroup (string)\n"+
            "* actionType (SelectionType string)\n"+
            "* state (State string)\n"+
            "* showDisabled (boolean)\n"+
            "* showDown (boolean)\n"+
            "* showFocused (boolean)\n"+
            "* showRollOver (boolean)\n"+
            "* align (Alignment string)\n"+
            "* valign (VerticalAlignment string)\n"+
            "* wrap (boolean)\n"+
            "* overflow (Overflow string)\n"+
            "\n"+
            "## Inherited from StatefulCanvas\n"+
            "\n"+
            "### Attributes\n"+
            "* showFocusedAsOver (boolean)\n"+
            "* showOverCanvas (boolean)\n"+
            "* showMenuOnClick (boolean)\n"+
            "\n"+
            "## Inherited from Canvas\n"+
            "\n"+
            "### Attributes\n"+
            "* ID (GlobalId string)\n"+
            "* autoDraw (boolean)\n"+
            "* htmlElement (DOMElement object | string)\n"+
            "* htmlPosition (DrawPosition string)\n"+
            "* matchElement (boolean)\n"+
            "* position (Positioning string)\n"+
            "* left (number | string)\n"+
            "* top (number | string)\n"+
            "* defaultWidth (integer)\n"+
            "* defaultHeight (integer)\n"+
            "* minWidth (number)\n"+
            "* minHeight (number)\n"+
            "* maxWidth (number)\n"+
            "* maxHeight (number)\n"+
            "* autoShowParent (boolean)\n"+
            "* visibility (Visibility string)\n"+
            "* canSelectText (boolean)\n"+
            "* contents (HTML string)\n"+
            "* dynamicContents (boolean)\n"+
            "* dynamicContentsVars (ValueMap object)\n"+
            "* margin (number)\n"+
            "* padding (number)\n"+
            "* border (string)\n"+
            "* backgroundColor (CSSColor string)\n"+
            "* backgroundImage (SCImgURL string)\n"+
            "* backgroundRepeat (BackgroundRepeat string)\n"+
            "* appImgDir (URL string)\n"+
            "* skinImgDir (SCImgURL string)\n"+
            "* cursor (Cursor string)\n"+
            "* disabledCursor (Cursor string)\n"+
            "* opacity (number)\n"+
            "* showCustomScrollbars (boolean)\n"+
            "* scrollbarSize (number)\n"+
            "* disabled (boolean)\n"+
            "* visibleWhen (AdvancedCriteria object)\n"+
            "* enableWhen (AdvancedCriteria object)\n"+
            "* redrawOnResize (boolean)\n"+
            "* canFocus (boolean)\n"+
            "* tabIndex (number)\n"+
            "* accessKey (string)\n"+
            "* contextMenu (Menu)\n"+
            "* prompt (HTML string)\n"+
            "* canDrag (boolean)\n"+
            "* dragStartDistance (number)\n"+
            "* canDragScroll (boolean)\n"+
            "* dragScrollDelay (number)\n"+
            "* dragIntersectStyle (DragIntersectStyle string)\n"+
            "* canDragReposition (boolean)\n"+
            "* dragRepositionCursor (Cursor string)\n"+
            "* canDragResize (boolean)\n"+
            "* resizeFrom (array of EdgeName string)\n"+
            "* canHover (boolean)\n"+
            "* hoverDelay (number)\n"+
            "* showHover (boolean)\n"+
            "* hoverWidth (integer)\n"+
            "* hoverHeight (integer)\n"+
            "* hoverAlign (Alignment string)\n"+
            "* hoverVAlign (VerticalAlignment string)\n"+
            "* hoverWrap (boolean)\n"+
            "* hoverStyle (CSSStyleName string)\n"+
            "* hoverOpacity (number)\n"+
            "* hoverMoveWithMouse (boolean)\n"+
            "* edgeMarginSize (number)\n"+
            "* edgeCursorMap (object)\n"+
            "* keepInParentRect (boolean | array of integer)\n"+
            "* dragAppearance (DragAppearance string)\n"+
            "* dragType (string)\n"+
            "* dropTypes (array of string | string)\n"+
            "* dragTarget (Canvas | string)\n"+
            "* showDragShadow (boolean)\n"+
            "* dragOpacity (integer)\n"+
            "* canDrop (boolean)\n"+
            "* canAcceptDrop (boolean)\n"+
            "* canDropBefore (boolean)\n"+
            "* mouseStillDownInitialDelay (integer)\n"+
            "* mouseStillDownDelay (integer)\n"+
            "* doubleClickDelay (integer)\n"+
            "* noDoubleClicks (boolean)\n"+
            "* snapTo (string)\n"+
            "* snapOffsetLeft (integer)\n"+
            "* snapOffsetTop (integer)\n"+
            "* snapToGrid (boolean)\n"+
            "* snapResizeToGrid (boolean)\n"+
            "* childrenSnapToGrid (boolean)\n"+
            "* childrenSnapResizeToGrid (boolean)\n"+
            "* snapHGap (number)\n"+
            "* snapVGap (number)\n"+
            "* snapOnDrop (boolean)\n"+
            "* showPointer (boolean)\n"+
            "* pointerTarget (AutoTestLocator string | GlobalId string)\n"+
            "* pointerSettings (PointerSettings object)\n"+
            "* workflows (array of Process)\n"+
            "* borderRadius (string)\n"+
            "* showEdges (boolean)\n"+
            "* edgeSize (number)\n"+
            "* edgeOffset (number)\n"+
            "* edgeImage (SCImgURL string)\n"+
            "* customEdges (array of string)\n"+
            "* edgeBackgroundColor (CSSColor string)\n"+
            "* edgeOpacity (integer)\n"+
            "* edgeShowCenter (boolean)\n"+
            "* edgeCenterBackgroundColor (CSSColor string)\n"+
            "* showShadow (boolean)\n"+
            "* shadowDepth (number)\n"+
            "* shadowOffset (number)\n"+
            "* shadowSoftness (number)\n"+
            "* shadowImage (SCImgURL string)\n"+
            "* isGroup (boolean)\n"+
            "* groupTitle (HTML string)\n"+
            "* testDataContext (DataContext object)\n"+
            "* autoPopulateData (boolean)\n"+
            "* ruleScope (string)\n"+
            "* isRuleScope (boolean)\n"+
            "* valuesManager (ValuesManager | GlobalId string)\n"+
            "* dataPath (DataPath string)\n"+
            "* animateTime (number)\n"+
            "* animateAcceleration (AnimationAcceleration string)\n"+
            "* animateMoveTime (number)\n"+
            "* animateResizeTime (number)\n"+
            "* animateRectTime (number)\n"+
            "* animateFadeTime (number)\n"+
            "* animateScrollTime (number)\n"+
            "* animateShowTime (number)\n"+
            "* animateHideTime (number)\n"+
            "* animateMoveAcceleration (AnimationAcceleration string)\n"+
            "* animateResizeAcceleration (AnimationAcceleration string)\n"+
            "* animateRectAcceleration (AnimationAcceleration string)\n"+
            "* animateScrollAcceleration (AnimationAcceleration string)\n"+
            "* animateShowAcceleration (AnimationAcceleration string)\n"+
            "* animateHideAcceleration (AnimationAcceleration string)\n"+
            "* layoutAlign (Alignment string | VerticalAlignment string)\n"+
            "* showResizeBar (boolean)\n"+
            "* resizeBarTarget (string)\n"+
            "* extraSpace (positive integer)\n"+
            "\n"+
            "### Methods\n"+
            "* showNextTo()\n"+
            "* show()\n"+
            "* hide()\n"+
            "* click()\n"+
            "* print()\n",
        format:"Markdown"
    },
    "APIs list:IButton":{
        topic:"APIs list for IButton",
        content:"Only the following APIs are available on IButton:\n"+
            "\n"+
            "## Inherited from Button\n"+
            "\n"+
            "### Attributes\n"+
            "* title (HTML string)\n"+
            "* hiliteAccessKey (boolean)\n"+
            "* icon (SCImgURL string)\n"+
            "* iconSize (integer)\n"+
            "* iconWidth (integer)\n"+
            "* iconHeight (integer)\n"+
            "* iconOrientation (string)\n"+
            "* iconAlign (string)\n"+
            "* iconSpacing (integer)\n"+
            "* showDisabledIcon (boolean)\n"+
            "* showRollOverIcon (boolean)\n"+
            "* showFocusedIcon (boolean)\n"+
            "* showDownIcon (boolean)\n"+
            "* showSelectedIcon (boolean)\n"+
            "* autoFit (boolean)\n"+
            "* width (number | string)\n"+
            "* height (number | string)\n"+
            "* styleName (CSSStyleName string)\n"+
            "* baseStyle (CSSStyleName string)\n"+
            "* selected (boolean)\n"+
            "* radioGroup (string)\n"+
            "* actionType (SelectionType string)\n"+
            "* state (State string)\n"+
            "* showDisabled (boolean)\n"+
            "* showDown (boolean)\n"+
            "* showFocused (boolean)\n"+
            "* showRollOver (boolean)\n"+
            "* align (Alignment string)\n"+
            "* valign (VerticalAlignment string)\n"+
            "* wrap (boolean)\n"+
            "* overflow (Overflow string)\n"+
            "\n"+
            "## Inherited from StatefulCanvas\n"+
            "\n"+
            "### Attributes\n"+
            "* showFocusedAsOver (boolean)\n"+
            "* showOverCanvas (boolean)\n"+
            "* showMenuOnClick (boolean)\n"+
            "\n"+
            "## Inherited from Canvas\n"+
            "\n"+
            "### Attributes\n"+
            "* ID (GlobalId string)\n"+
            "* autoDraw (boolean)\n"+
            "* htmlElement (DOMElement object | string)\n"+
            "* htmlPosition (DrawPosition string)\n"+
            "* matchElement (boolean)\n"+
            "* position (Positioning string)\n"+
            "* left (number | string)\n"+
            "* top (number | string)\n"+
            "* defaultWidth (integer)\n"+
            "* defaultHeight (integer)\n"+
            "* minWidth (number)\n"+
            "* minHeight (number)\n"+
            "* maxWidth (number)\n"+
            "* maxHeight (number)\n"+
            "* autoShowParent (boolean)\n"+
            "* visibility (Visibility string)\n"+
            "* canSelectText (boolean)\n"+
            "* contents (HTML string)\n"+
            "* dynamicContents (boolean)\n"+
            "* dynamicContentsVars (ValueMap object)\n"+
            "* margin (number)\n"+
            "* padding (number)\n"+
            "* border (string)\n"+
            "* backgroundColor (CSSColor string)\n"+
            "* backgroundImage (SCImgURL string)\n"+
            "* backgroundRepeat (BackgroundRepeat string)\n"+
            "* appImgDir (URL string)\n"+
            "* skinImgDir (SCImgURL string)\n"+
            "* cursor (Cursor string)\n"+
            "* disabledCursor (Cursor string)\n"+
            "* opacity (number)\n"+
            "* showCustomScrollbars (boolean)\n"+
            "* scrollbarSize (number)\n"+
            "* disabled (boolean)\n"+
            "* visibleWhen (AdvancedCriteria object)\n"+
            "* enableWhen (AdvancedCriteria object)\n"+
            "* redrawOnResize (boolean)\n"+
            "* canFocus (boolean)\n"+
            "* tabIndex (number)\n"+
            "* accessKey (string)\n"+
            "* contextMenu (Menu)\n"+
            "* prompt (HTML string)\n"+
            "* canDrag (boolean)\n"+
            "* dragStartDistance (number)\n"+
            "* canDragScroll (boolean)\n"+
            "* dragScrollDelay (number)\n"+
            "* dragIntersectStyle (DragIntersectStyle string)\n"+
            "* canDragReposition (boolean)\n"+
            "* dragRepositionCursor (Cursor string)\n"+
            "* canDragResize (boolean)\n"+
            "* resizeFrom (array of EdgeName string)\n"+
            "* canHover (boolean)\n"+
            "* hoverDelay (number)\n"+
            "* showHover (boolean)\n"+
            "* hoverWidth (integer)\n"+
            "* hoverHeight (integer)\n"+
            "* hoverAlign (Alignment string)\n"+
            "* hoverVAlign (VerticalAlignment string)\n"+
            "* hoverWrap (boolean)\n"+
            "* hoverStyle (CSSStyleName string)\n"+
            "* hoverOpacity (number)\n"+
            "* hoverMoveWithMouse (boolean)\n"+
            "* edgeMarginSize (number)\n"+
            "* edgeCursorMap (object)\n"+
            "* keepInParentRect (boolean | array of integer)\n"+
            "* dragAppearance (DragAppearance string)\n"+
            "* dragType (string)\n"+
            "* dropTypes (array of string | string)\n"+
            "* dragTarget (Canvas | string)\n"+
            "* showDragShadow (boolean)\n"+
            "* dragOpacity (integer)\n"+
            "* canDrop (boolean)\n"+
            "* canAcceptDrop (boolean)\n"+
            "* canDropBefore (boolean)\n"+
            "* mouseStillDownInitialDelay (integer)\n"+
            "* mouseStillDownDelay (integer)\n"+
            "* doubleClickDelay (integer)\n"+
            "* noDoubleClicks (boolean)\n"+
            "* snapTo (string)\n"+
            "* snapOffsetLeft (integer)\n"+
            "* snapOffsetTop (integer)\n"+
            "* snapToGrid (boolean)\n"+
            "* snapResizeToGrid (boolean)\n"+
            "* childrenSnapToGrid (boolean)\n"+
            "* childrenSnapResizeToGrid (boolean)\n"+
            "* snapHGap (number)\n"+
            "* snapVGap (number)\n"+
            "* snapOnDrop (boolean)\n"+
            "* showPointer (boolean)\n"+
            "* pointerTarget (AutoTestLocator string | GlobalId string)\n"+
            "* pointerSettings (PointerSettings object)\n"+
            "* workflows (array of Process)\n"+
            "* borderRadius (string)\n"+
            "* showEdges (boolean)\n"+
            "* edgeSize (number)\n"+
            "* edgeOffset (number)\n"+
            "* edgeImage (SCImgURL string)\n"+
            "* customEdges (array of string)\n"+
            "* edgeBackgroundColor (CSSColor string)\n"+
            "* edgeOpacity (integer)\n"+
            "* edgeShowCenter (boolean)\n"+
            "* edgeCenterBackgroundColor (CSSColor string)\n"+
            "* showShadow (boolean)\n"+
            "* shadowDepth (number)\n"+
            "* shadowOffset (number)\n"+
            "* shadowSoftness (number)\n"+
            "* shadowImage (SCImgURL string)\n"+
            "* isGroup (boolean)\n"+
            "* groupTitle (HTML string)\n"+
            "* testDataContext (DataContext object)\n"+
            "* autoPopulateData (boolean)\n"+
            "* ruleScope (string)\n"+
            "* isRuleScope (boolean)\n"+
            "* valuesManager (ValuesManager | GlobalId string)\n"+
            "* dataPath (DataPath string)\n"+
            "* animateTime (number)\n"+
            "* animateAcceleration (AnimationAcceleration string)\n"+
            "* animateMoveTime (number)\n"+
            "* animateResizeTime (number)\n"+
            "* animateRectTime (number)\n"+
            "* animateFadeTime (number)\n"+
            "* animateScrollTime (number)\n"+
            "* animateShowTime (number)\n"+
            "* animateHideTime (number)\n"+
            "* animateMoveAcceleration (AnimationAcceleration string)\n"+
            "* animateResizeAcceleration (AnimationAcceleration string)\n"+
            "* animateRectAcceleration (AnimationAcceleration string)\n"+
            "* animateScrollAcceleration (AnimationAcceleration string)\n"+
            "* animateShowAcceleration (AnimationAcceleration string)\n"+
            "* animateHideAcceleration (AnimationAcceleration string)\n"+
            "* layoutAlign (Alignment string | VerticalAlignment string)\n"+
            "* showResizeBar (boolean)\n"+
            "* resizeBarTarget (string)\n"+
            "* extraSpace (positive integer)\n"+
            "\n"+
            "### Methods\n"+
            "* showNextTo()\n"+
            "* show()\n"+
            "* hide()\n"+
            "* click()\n"+
            "* doubleClick()\n"+
            "* print()\n",
        format:"Markdown"
    },
    "APIs list:ToolStrip":{
        topic:"APIs list for ToolStrip",
        content:"Only the following APIs are available on ToolStrip:\n"+
            "\n"+
            "## Attributes\n"+
            "* members (array of Canvas)\n"+
            "* height (number)\n"+
            "* styleName (CSSStyleName string)\n"+
            "* vertical (boolean)\n"+
            "* resizeBarClass (string)\n"+
            "* resizeBarSize (integer)\n"+
            "* separatorClass (string)\n"+
            "* separatorSize (integer)\n"+
            "\n"+
            "## Inherited from Layout\n"+
            "\n"+
            "### Attributes\n"+
            "* overflow (Overflow string)\n"+
            "* vPolicy (LayoutPolicy string)\n"+
            "* hPolicy (LayoutPolicy string)\n"+
            "* minMemberLength (integer)\n"+
            "* minBreadthMember (string | integer | Canvas)\n"+
            "* enforcePolicy (boolean)\n"+
            "* defaultLayoutAlign (Alignment string | VerticalAlignment string)\n"+
            "* align (Alignment string | VerticalAlignment string)\n"+
            "* reverseOrder (boolean)\n"+
            "* paddingAsLayoutMargin (boolean)\n"+
            "* layoutMargin (integer)\n"+
            "* layoutLeftMargin (integer)\n"+
            "* layoutRightMargin (integer)\n"+
            "* layoutTopMargin (integer)\n"+
            "* layoutBottomMargin (integer)\n"+
            "* membersMargin (integer)\n"+
            "* leaveScrollbarGap (boolean)\n"+
            "* animateMembers (boolean)\n"+
            "* animateMemberTime (number)\n"+
            "* canDropComponents (boolean)\n"+
            "* dropLineThickness (number)\n"+
            "* showDragPlaceHolder (boolean)\n"+
            "* placeHolderProperties (Canvas properties object)\n"+
            "* placeHolderDefaults (Canvas properties object)\n"+
            "\n"+
            "## Inherited from Canvas\n"+
            "\n"+
            "### Attributes\n"+
            "* ID (GlobalId string)\n"+
            "* autoDraw (boolean)\n"+
            "* children (array of Canvas)\n"+
            "* peers (array of Canvas)\n"+
            "* htmlElement (DOMElement object | string)\n"+
            "* htmlPosition (DrawPosition string)\n"+
            "* matchElement (boolean)\n"+
            "* position (Positioning string)\n"+
            "* left (number | string)\n"+
            "* top (number | string)\n"+
            "* width (number | string)\n"+
            "* defaultWidth (integer)\n"+
            "* defaultHeight (integer)\n"+
            "* minWidth (number)\n"+
            "* minHeight (number)\n"+
            "* maxWidth (number)\n"+
            "* maxHeight (number)\n"+
            "* autoShowParent (boolean)\n"+
            "* visibility (Visibility string)\n"+
            "* canSelectText (boolean)\n"+
            "* contents (HTML string)\n"+
            "* dynamicContents (boolean)\n"+
            "* dynamicContentsVars (ValueMap object)\n"+
            "* margin (number)\n"+
            "* padding (number)\n"+
            "* border (string)\n"+
            "* backgroundColor (CSSColor string)\n"+
            "* backgroundImage (SCImgURL string)\n"+
            "* backgroundRepeat (BackgroundRepeat string)\n"+
            "* appImgDir (URL string)\n"+
            "* skinImgDir (SCImgURL string)\n"+
            "* cursor (Cursor string)\n"+
            "* disabledCursor (Cursor string)\n"+
            "* opacity (number)\n"+
            "* showCustomScrollbars (boolean)\n"+
            "* scrollbarSize (number)\n"+
            "* disabled (boolean)\n"+
            "* visibleWhen (AdvancedCriteria object)\n"+
            "* enableWhen (AdvancedCriteria object)\n"+
            "* redrawOnResize (boolean)\n"+
            "* canFocus (boolean)\n"+
            "* tabIndex (number)\n"+
            "* accessKey (string)\n"+
            "* contextMenu (Menu)\n"+
            "* prompt (HTML string)\n"+
            "* canDrag (boolean)\n"+
            "* dragStartDistance (number)\n"+
            "* canDragScroll (boolean)\n"+
            "* dragScrollDelay (number)\n"+
            "* dragIntersectStyle (DragIntersectStyle string)\n"+
            "* canDragReposition (boolean)\n"+
            "* dragRepositionCursor (Cursor string)\n"+
            "* canDragResize (boolean)\n"+
            "* resizeFrom (array of EdgeName string)\n"+
            "* canHover (boolean)\n"+
            "* hoverDelay (number)\n"+
            "* showHover (boolean)\n"+
            "* hoverWidth (integer)\n"+
            "* hoverHeight (integer)\n"+
            "* hoverAlign (Alignment string)\n"+
            "* hoverVAlign (VerticalAlignment string)\n"+
            "* hoverWrap (boolean)\n"+
            "* hoverStyle (CSSStyleName string)\n"+
            "* hoverOpacity (number)\n"+
            "* hoverMoveWithMouse (boolean)\n"+
            "* edgeMarginSize (number)\n"+
            "* edgeCursorMap (object)\n"+
            "* keepInParentRect (boolean | array of integer)\n"+
            "* dragAppearance (DragAppearance string)\n"+
            "* dragType (string)\n"+
            "* dropTypes (array of string | string)\n"+
            "* dragTarget (Canvas | string)\n"+
            "* showDragShadow (boolean)\n"+
            "* dragOpacity (integer)\n"+
            "* canDrop (boolean)\n"+
            "* canAcceptDrop (boolean)\n"+
            "* canDropBefore (boolean)\n"+
            "* mouseStillDownInitialDelay (integer)\n"+
            "* mouseStillDownDelay (integer)\n"+
            "* doubleClickDelay (integer)\n"+
            "* noDoubleClicks (boolean)\n"+
            "* snapTo (string)\n"+
            "* snapOffsetLeft (integer)\n"+
            "* snapOffsetTop (integer)\n"+
            "* snapToGrid (boolean)\n"+
            "* snapResizeToGrid (boolean)\n"+
            "* childrenSnapToGrid (boolean)\n"+
            "* childrenSnapResizeToGrid (boolean)\n"+
            "* snapHGap (number)\n"+
            "* snapVGap (number)\n"+
            "* snapOnDrop (boolean)\n"+
            "* showPointer (boolean)\n"+
            "* pointerTarget (AutoTestLocator string | GlobalId string)\n"+
            "* pointerSettings (PointerSettings object)\n"+
            "* workflows (array of Process)\n"+
            "* borderRadius (string)\n"+
            "* showEdges (boolean)\n"+
            "* edgeSize (number)\n"+
            "* edgeOffset (number)\n"+
            "* edgeImage (SCImgURL string)\n"+
            "* customEdges (array of string)\n"+
            "* edgeBackgroundColor (CSSColor string)\n"+
            "* edgeOpacity (integer)\n"+
            "* edgeShowCenter (boolean)\n"+
            "* edgeCenterBackgroundColor (CSSColor string)\n"+
            "* showShadow (boolean)\n"+
            "* shadowDepth (number)\n"+
            "* shadowOffset (number)\n"+
            "* shadowSoftness (number)\n"+
            "* shadowImage (SCImgURL string)\n"+
            "* isGroup (boolean)\n"+
            "* groupTitle (HTML string)\n"+
            "* testDataContext (DataContext object)\n"+
            "* autoPopulateData (boolean)\n"+
            "* ruleScope (string)\n"+
            "* isRuleScope (boolean)\n"+
            "* valuesManager (ValuesManager | GlobalId string)\n"+
            "* dataPath (DataPath string)\n"+
            "* animateTime (number)\n"+
            "* animateAcceleration (AnimationAcceleration string)\n"+
            "* animateMoveTime (number)\n"+
            "* animateResizeTime (number)\n"+
            "* animateRectTime (number)\n"+
            "* animateFadeTime (number)\n"+
            "* animateScrollTime (number)\n"+
            "* animateShowTime (number)\n"+
            "* animateHideTime (number)\n"+
            "* animateMoveAcceleration (AnimationAcceleration string)\n"+
            "* animateResizeAcceleration (AnimationAcceleration string)\n"+
            "* animateRectAcceleration (AnimationAcceleration string)\n"+
            "* animateScrollAcceleration (AnimationAcceleration string)\n"+
            "* animateShowAcceleration (AnimationAcceleration string)\n"+
            "* animateHideAcceleration (AnimationAcceleration string)\n"+
            "* layoutAlign (Alignment string | VerticalAlignment string)\n"+
            "* showResizeBar (boolean)\n"+
            "* resizeBarTarget (string)\n"+
            "* extraSpace (positive integer)\n"+
            "\n"+
            "### Methods\n"+
            "* showNextTo()\n"+
            "* show()\n"+
            "* hide()\n"+
            "* print()\n",
        format:"Markdown"
    },
    "APIs list:ToolStripButton":{
        topic:"APIs list for ToolStripButton",
        content:"Only the following APIs are available on ToolStripButton:\n"+
            "\n"+
            "## Inherited from Button\n"+
            "\n"+
            "### Attributes\n"+
            "* title (HTML string)\n"+
            "* hiliteAccessKey (boolean)\n"+
            "* icon (SCImgURL string)\n"+
            "* iconSize (integer)\n"+
            "* iconWidth (integer)\n"+
            "* iconHeight (integer)\n"+
            "* iconOrientation (string)\n"+
            "* iconAlign (string)\n"+
            "* iconSpacing (integer)\n"+
            "* showDisabledIcon (boolean)\n"+
            "* showRollOverIcon (boolean)\n"+
            "* showFocusedIcon (boolean)\n"+
            "* showDownIcon (boolean)\n"+
            "* showSelectedIcon (boolean)\n"+
            "* autoFit (boolean)\n"+
            "* width (number | string)\n"+
            "* height (number | string)\n"+
            "* styleName (CSSStyleName string)\n"+
            "* baseStyle (CSSStyleName string)\n"+
            "* selected (boolean)\n"+
            "* radioGroup (string)\n"+
            "* actionType (SelectionType string)\n"+
            "* state (State string)\n"+
            "* showDisabled (boolean)\n"+
            "* showDown (boolean)\n"+
            "* showFocused (boolean)\n"+
            "* showRollOver (boolean)\n"+
            "* align (Alignment string)\n"+
            "* valign (VerticalAlignment string)\n"+
            "* wrap (boolean)\n"+
            "* overflow (Overflow string)\n"+
            "\n"+
            "## Inherited from StatefulCanvas\n"+
            "\n"+
            "### Attributes\n"+
            "* showFocusedAsOver (boolean)\n"+
            "* showOverCanvas (boolean)\n"+
            "* showMenuOnClick (boolean)\n"+
            "\n"+
            "## Inherited from Canvas\n"+
            "\n"+
            "### Attributes\n"+
            "* ID (GlobalId string)\n"+
            "* autoDraw (boolean)\n"+
            "* htmlElement (DOMElement object | string)\n"+
            "* htmlPosition (DrawPosition string)\n"+
            "* matchElement (boolean)\n"+
            "* position (Positioning string)\n"+
            "* left (number | string)\n"+
            "* top (number | string)\n"+
            "* defaultWidth (integer)\n"+
            "* defaultHeight (integer)\n"+
            "* minWidth (number)\n"+
            "* minHeight (number)\n"+
            "* maxWidth (number)\n"+
            "* maxHeight (number)\n"+
            "* autoShowParent (boolean)\n"+
            "* visibility (Visibility string)\n"+
            "* canSelectText (boolean)\n"+
            "* contents (HTML string)\n"+
            "* dynamicContents (boolean)\n"+
            "* dynamicContentsVars (ValueMap object)\n"+
            "* margin (number)\n"+
            "* padding (number)\n"+
            "* border (string)\n"+
            "* backgroundColor (CSSColor string)\n"+
            "* backgroundImage (SCImgURL string)\n"+
            "* backgroundRepeat (BackgroundRepeat string)\n"+
            "* appImgDir (URL string)\n"+
            "* skinImgDir (SCImgURL string)\n"+
            "* cursor (Cursor string)\n"+
            "* disabledCursor (Cursor string)\n"+
            "* opacity (number)\n"+
            "* showCustomScrollbars (boolean)\n"+
            "* scrollbarSize (number)\n"+
            "* disabled (boolean)\n"+
            "* visibleWhen (AdvancedCriteria object)\n"+
            "* enableWhen (AdvancedCriteria object)\n"+
            "* redrawOnResize (boolean)\n"+
            "* canFocus (boolean)\n"+
            "* tabIndex (number)\n"+
            "* accessKey (string)\n"+
            "* contextMenu (Menu)\n"+
            "* prompt (HTML string)\n"+
            "* canDrag (boolean)\n"+
            "* dragStartDistance (number)\n"+
            "* canDragScroll (boolean)\n"+
            "* dragScrollDelay (number)\n"+
            "* dragIntersectStyle (DragIntersectStyle string)\n"+
            "* canDragReposition (boolean)\n"+
            "* dragRepositionCursor (Cursor string)\n"+
            "* canDragResize (boolean)\n"+
            "* resizeFrom (array of EdgeName string)\n"+
            "* canHover (boolean)\n"+
            "* hoverDelay (number)\n"+
            "* showHover (boolean)\n"+
            "* hoverWidth (integer)\n"+
            "* hoverHeight (integer)\n"+
            "* hoverAlign (Alignment string)\n"+
            "* hoverVAlign (VerticalAlignment string)\n"+
            "* hoverWrap (boolean)\n"+
            "* hoverStyle (CSSStyleName string)\n"+
            "* hoverOpacity (number)\n"+
            "* hoverMoveWithMouse (boolean)\n"+
            "* edgeMarginSize (number)\n"+
            "* edgeCursorMap (object)\n"+
            "* keepInParentRect (boolean | array of integer)\n"+
            "* dragAppearance (DragAppearance string)\n"+
            "* dragType (string)\n"+
            "* dropTypes (array of string | string)\n"+
            "* dragTarget (Canvas | string)\n"+
            "* showDragShadow (boolean)\n"+
            "* dragOpacity (integer)\n"+
            "* canDrop (boolean)\n"+
            "* canAcceptDrop (boolean)\n"+
            "* canDropBefore (boolean)\n"+
            "* mouseStillDownInitialDelay (integer)\n"+
            "* mouseStillDownDelay (integer)\n"+
            "* doubleClickDelay (integer)\n"+
            "* noDoubleClicks (boolean)\n"+
            "* snapTo (string)\n"+
            "* snapOffsetLeft (integer)\n"+
            "* snapOffsetTop (integer)\n"+
            "* snapToGrid (boolean)\n"+
            "* snapResizeToGrid (boolean)\n"+
            "* childrenSnapToGrid (boolean)\n"+
            "* childrenSnapResizeToGrid (boolean)\n"+
            "* snapHGap (number)\n"+
            "* snapVGap (number)\n"+
            "* snapOnDrop (boolean)\n"+
            "* showPointer (boolean)\n"+
            "* pointerTarget (AutoTestLocator string | GlobalId string)\n"+
            "* pointerSettings (PointerSettings object)\n"+
            "* workflows (array of Process)\n"+
            "* borderRadius (string)\n"+
            "* showEdges (boolean)\n"+
            "* edgeSize (number)\n"+
            "* edgeOffset (number)\n"+
            "* edgeImage (SCImgURL string)\n"+
            "* customEdges (array of string)\n"+
            "* edgeBackgroundColor (CSSColor string)\n"+
            "* edgeOpacity (integer)\n"+
            "* edgeShowCenter (boolean)\n"+
            "* edgeCenterBackgroundColor (CSSColor string)\n"+
            "* showShadow (boolean)\n"+
            "* shadowDepth (number)\n"+
            "* shadowOffset (number)\n"+
            "* shadowSoftness (number)\n"+
            "* shadowImage (SCImgURL string)\n"+
            "* isGroup (boolean)\n"+
            "* groupTitle (HTML string)\n"+
            "* testDataContext (DataContext object)\n"+
            "* autoPopulateData (boolean)\n"+
            "* ruleScope (string)\n"+
            "* isRuleScope (boolean)\n"+
            "* valuesManager (ValuesManager | GlobalId string)\n"+
            "* dataPath (DataPath string)\n"+
            "* animateTime (number)\n"+
            "* animateAcceleration (AnimationAcceleration string)\n"+
            "* animateMoveTime (number)\n"+
            "* animateResizeTime (number)\n"+
            "* animateRectTime (number)\n"+
            "* animateFadeTime (number)\n"+
            "* animateScrollTime (number)\n"+
            "* animateShowTime (number)\n"+
            "* animateHideTime (number)\n"+
            "* animateMoveAcceleration (AnimationAcceleration string)\n"+
            "* animateResizeAcceleration (AnimationAcceleration string)\n"+
            "* animateRectAcceleration (AnimationAcceleration string)\n"+
            "* animateScrollAcceleration (AnimationAcceleration string)\n"+
            "* animateShowAcceleration (AnimationAcceleration string)\n"+
            "* animateHideAcceleration (AnimationAcceleration string)\n"+
            "* layoutAlign (Alignment string | VerticalAlignment string)\n"+
            "* showResizeBar (boolean)\n"+
            "* resizeBarTarget (string)\n"+
            "* extraSpace (positive integer)\n"+
            "\n"+
            "### Methods\n"+
            "* showNextTo()\n"+
            "* show()\n"+
            "* hide()\n"+
            "* click()\n"+
            "* doubleClick()\n"+
            "* print()\n",
        format:"Markdown"
    },
    "APIs list:ToolStripSeparator":{
        topic:"APIs list for ToolStripSeparator",
        content:"Only the following APIs are available on ToolStripSeparator:\n"+
            "\n"+
            "## Attributes\n"+
            "* skinImgDir (SCImgURL string)\n"+
            "\n"+
            "## Inherited from Img\n"+
            "\n"+
            "### Attributes\n"+
            "* name (string)\n"+
            "* showRollOver (boolean)\n"+
            "* showFocused (boolean)\n"+
            "* showFocusedAsOver (boolean)\n"+
            "* showDown (boolean)\n"+
            "* showDisabled (boolean)\n"+
            "* src (SCImgURL string | SCStatefulImgConfig object)\n"+
            "* prompt (HTML string)\n"+
            "* activeAreaHTML (HTML string)\n"+
            "* imageType (ImageStyle string)\n"+
            "* imageHeight (integer)\n"+
            "* imageWidth (integer)\n"+
            "* size (number)\n"+
            "* showTitle (boolean)\n"+
            "\n"+
            "## Inherited from StatefulCanvas\n"+
            "\n"+
            "### Attributes\n"+
            "* selected (boolean)\n"+
            "* state (State string)\n"+
            "* actionType (SelectionType string)\n"+
            "* radioGroup (string)\n"+
            "* styleName (CSSStyleName string)\n"+
            "* baseStyle (CSSStyleName string)\n"+
            "* align (Alignment string)\n"+
            "* valign (VerticalAlignment string)\n"+
            "* width (number | string)\n"+
            "* height (number | string)\n"+
            "* icon (SCImgURL string)\n"+
            "* iconSize (integer)\n"+
            "* iconWidth (integer)\n"+
            "* iconHeight (integer)\n"+
            "* iconOrientation (string)\n"+
            "* iconSpacing (integer)\n"+
            "* showDisabledIcon (boolean)\n"+
            "* showRollOverIcon (boolean)\n"+
            "* showDownIcon (boolean)\n"+
            "* showSelectedIcon (boolean)\n"+
            "* showFocusedIcon (boolean)\n"+
            "* showOverCanvas (boolean)\n"+
            "* showMenuOnClick (boolean)\n"+
            "\n"+
            "## Inherited from Canvas\n"+
            "\n"+
            "### Attributes\n"+
            "* ID (GlobalId string)\n"+
            "* autoDraw (boolean)\n"+
            "* htmlElement (DOMElement object | string)\n"+
            "* htmlPosition (DrawPosition string)\n"+
            "* matchElement (boolean)\n"+
            "* position (Positioning string)\n"+
            "* left (number | string)\n"+
            "* top (number | string)\n"+
            "* defaultWidth (integer)\n"+
            "* defaultHeight (integer)\n"+
            "* minWidth (number)\n"+
            "* minHeight (number)\n"+
            "* maxWidth (number)\n"+
            "* maxHeight (number)\n"+
            "* autoShowParent (boolean)\n"+
            "* visibility (Visibility string)\n"+
            "* canSelectText (boolean)\n"+
            "* contents (HTML string)\n"+
            "* dynamicContents (boolean)\n"+
            "* dynamicContentsVars (ValueMap object)\n"+
            "* margin (number)\n"+
            "* padding (number)\n"+
            "* border (string)\n"+
            "* backgroundColor (CSSColor string)\n"+
            "* backgroundImage (SCImgURL string)\n"+
            "* backgroundRepeat (BackgroundRepeat string)\n"+
            "* appImgDir (URL string)\n"+
            "* cursor (Cursor string)\n"+
            "* disabledCursor (Cursor string)\n"+
            "* opacity (number)\n"+
            "* overflow (Overflow string)\n"+
            "* showCustomScrollbars (boolean)\n"+
            "* scrollbarSize (number)\n"+
            "* disabled (boolean)\n"+
            "* visibleWhen (AdvancedCriteria object)\n"+
            "* enableWhen (AdvancedCriteria object)\n"+
            "* redrawOnResize (boolean)\n"+
            "* canFocus (boolean)\n"+
            "* tabIndex (number)\n"+
            "* accessKey (string)\n"+
            "* contextMenu (Menu)\n"+
            "* canDrag (boolean)\n"+
            "* dragStartDistance (number)\n"+
            "* canDragScroll (boolean)\n"+
            "* dragScrollDelay (number)\n"+
            "* dragIntersectStyle (DragIntersectStyle string)\n"+
            "* canDragReposition (boolean)\n"+
            "* dragRepositionCursor (Cursor string)\n"+
            "* canDragResize (boolean)\n"+
            "* resizeFrom (array of EdgeName string)\n"+
            "* canHover (boolean)\n"+
            "* hoverDelay (number)\n"+
            "* showHover (boolean)\n"+
            "* hoverWidth (integer)\n"+
            "* hoverHeight (integer)\n"+
            "* hoverAlign (Alignment string)\n"+
            "* hoverVAlign (VerticalAlignment string)\n"+
            "* hoverWrap (boolean)\n"+
            "* hoverStyle (CSSStyleName string)\n"+
            "* hoverOpacity (number)\n"+
            "* hoverMoveWithMouse (boolean)\n"+
            "* edgeMarginSize (number)\n"+
            "* edgeCursorMap (object)\n"+
            "* keepInParentRect (boolean | array of integer)\n"+
            "* dragAppearance (DragAppearance string)\n"+
            "* dragType (string)\n"+
            "* dropTypes (array of string | string)\n"+
            "* dragTarget (Canvas | string)\n"+
            "* showDragShadow (boolean)\n"+
            "* dragOpacity (integer)\n"+
            "* canDrop (boolean)\n"+
            "* canAcceptDrop (boolean)\n"+
            "* canDropBefore (boolean)\n"+
            "* mouseStillDownInitialDelay (integer)\n"+
            "* mouseStillDownDelay (integer)\n"+
            "* doubleClickDelay (integer)\n"+
            "* noDoubleClicks (boolean)\n"+
            "* snapTo (string)\n"+
            "* snapOffsetLeft (integer)\n"+
            "* snapOffsetTop (integer)\n"+
            "* snapToGrid (boolean)\n"+
            "* snapResizeToGrid (boolean)\n"+
            "* childrenSnapToGrid (boolean)\n"+
            "* childrenSnapResizeToGrid (boolean)\n"+
            "* snapHGap (number)\n"+
            "* snapVGap (number)\n"+
            "* snapOnDrop (boolean)\n"+
            "* showPointer (boolean)\n"+
            "* pointerTarget (AutoTestLocator string | GlobalId string)\n"+
            "* pointerSettings (PointerSettings object)\n"+
            "* workflows (array of Process)\n"+
            "* borderRadius (string)\n"+
            "* showEdges (boolean)\n"+
            "* edgeSize (number)\n"+
            "* edgeOffset (number)\n"+
            "* edgeImage (SCImgURL string)\n"+
            "* customEdges (array of string)\n"+
            "* edgeBackgroundColor (CSSColor string)\n"+
            "* edgeOpacity (integer)\n"+
            "* edgeShowCenter (boolean)\n"+
            "* edgeCenterBackgroundColor (CSSColor string)\n"+
            "* showShadow (boolean)\n"+
            "* shadowDepth (number)\n"+
            "* shadowOffset (number)\n"+
            "* shadowSoftness (number)\n"+
            "* shadowImage (SCImgURL string)\n"+
            "* isGroup (boolean)\n"+
            "* groupTitle (HTML string)\n"+
            "* testDataContext (DataContext object)\n"+
            "* autoPopulateData (boolean)\n"+
            "* ruleScope (string)\n"+
            "* isRuleScope (boolean)\n"+
            "* valuesManager (ValuesManager | GlobalId string)\n"+
            "* dataPath (DataPath string)\n"+
            "* animateTime (number)\n"+
            "* animateAcceleration (AnimationAcceleration string)\n"+
            "* animateMoveTime (number)\n"+
            "* animateResizeTime (number)\n"+
            "* animateRectTime (number)\n"+
            "* animateFadeTime (number)\n"+
            "* animateScrollTime (number)\n"+
            "* animateShowTime (number)\n"+
            "* animateHideTime (number)\n"+
            "* animateMoveAcceleration (AnimationAcceleration string)\n"+
            "* animateResizeAcceleration (AnimationAcceleration string)\n"+
            "* animateRectAcceleration (AnimationAcceleration string)\n"+
            "* animateScrollAcceleration (AnimationAcceleration string)\n"+
            "* animateShowAcceleration (AnimationAcceleration string)\n"+
            "* animateHideAcceleration (AnimationAcceleration string)\n"+
            "* layoutAlign (Alignment string | VerticalAlignment string)\n"+
            "* showResizeBar (boolean)\n"+
            "* resizeBarTarget (string)\n"+
            "* extraSpace (positive integer)\n"+
            "\n"+
            "### Methods\n"+
            "* showNextTo()\n"+
            "* show()\n"+
            "* hide()\n"+
            "* click()\n"+
            "* doubleClick()\n"+
            "* print()\n",
        format:"Markdown"
    },
    "APIs list:Label":{
        topic:"APIs list for Label",
        content:"Only the following APIs are available on Label:\n"+
            "\n"+
            "## Attributes\n"+
            "* contents (HTML string)\n"+
            "* dynamicContents (boolean)\n"+
            "* align (Alignment string)\n"+
            "* valign (VerticalAlignment string)\n"+
            "* wrap (boolean)\n"+
            "* autoFit (boolean)\n"+
            "* width (number | string)\n"+
            "* height (number | string)\n"+
            "* icon (SCImgURL string)\n"+
            "* iconSize (integer)\n"+
            "* iconWidth (integer)\n"+
            "* iconHeight (integer)\n"+
            "* iconOrientation (string)\n"+
            "* iconAlign (string)\n"+
            "* iconSpacing (integer)\n"+
            "* showDisabledIcon (boolean)\n"+
            "* showRollOverIcon (boolean)\n"+
            "* showFocusedIcon (boolean)\n"+
            "* showDownIcon (boolean)\n"+
            "* showSelectedIcon (boolean)\n"+
            "* styleName (CSSStyleName string)\n"+
            "\n"+
            "## Inherited from Button\n"+
            "\n"+
            "### Attributes\n"+
            "* hiliteAccessKey (boolean)\n"+
            "* baseStyle (CSSStyleName string)\n"+
            "* selected (boolean)\n"+
            "* radioGroup (string)\n"+
            "* actionType (SelectionType string)\n"+
            "* state (State string)\n"+
            "* showDisabled (boolean)\n"+
            "* showDown (boolean)\n"+
            "* showFocused (boolean)\n"+
            "* showRollOver (boolean)\n"+
            "* overflow (Overflow string)\n"+
            "\n"+
            "## Inherited from StatefulCanvas\n"+
            "\n"+
            "### Attributes\n"+
            "* showFocusedAsOver (boolean)\n"+
            "* showOverCanvas (boolean)\n"+
            "* showMenuOnClick (boolean)\n"+
            "\n"+
            "## Inherited from Canvas\n"+
            "\n"+
            "### Attributes\n"+
            "* ID (GlobalId string)\n"+
            "* autoDraw (boolean)\n"+
            "* htmlElement (DOMElement object | string)\n"+
            "* htmlPosition (DrawPosition string)\n"+
            "* matchElement (boolean)\n"+
            "* position (Positioning string)\n"+
            "* left (number | string)\n"+
            "* top (number | string)\n"+
            "* defaultWidth (integer)\n"+
            "* defaultHeight (integer)\n"+
            "* minWidth (number)\n"+
            "* minHeight (number)\n"+
            "* maxWidth (number)\n"+
            "* maxHeight (number)\n"+
            "* autoShowParent (boolean)\n"+
            "* visibility (Visibility string)\n"+
            "* canSelectText (boolean)\n"+
            "* dynamicContentsVars (ValueMap object)\n"+
            "* margin (number)\n"+
            "* padding (number)\n"+
            "* border (string)\n"+
            "* backgroundColor (CSSColor string)\n"+
            "* backgroundImage (SCImgURL string)\n"+
            "* backgroundRepeat (BackgroundRepeat string)\n"+
            "* appImgDir (URL string)\n"+
            "* skinImgDir (SCImgURL string)\n"+
            "* cursor (Cursor string)\n"+
            "* disabledCursor (Cursor string)\n"+
            "* opacity (number)\n"+
            "* showCustomScrollbars (boolean)\n"+
            "* scrollbarSize (number)\n"+
            "* disabled (boolean)\n"+
            "* visibleWhen (AdvancedCriteria object)\n"+
            "* enableWhen (AdvancedCriteria object)\n"+
            "* redrawOnResize (boolean)\n"+
            "* canFocus (boolean)\n"+
            "* tabIndex (number)\n"+
            "* accessKey (string)\n"+
            "* contextMenu (Menu)\n"+
            "* prompt (HTML string)\n"+
            "* canDrag (boolean)\n"+
            "* dragStartDistance (number)\n"+
            "* canDragScroll (boolean)\n"+
            "* dragScrollDelay (number)\n"+
            "* dragIntersectStyle (DragIntersectStyle string)\n"+
            "* canDragReposition (boolean)\n"+
            "* dragRepositionCursor (Cursor string)\n"+
            "* canDragResize (boolean)\n"+
            "* resizeFrom (array of EdgeName string)\n"+
            "* canHover (boolean)\n"+
            "* hoverDelay (number)\n"+
            "* showHover (boolean)\n"+
            "* hoverWidth (integer)\n"+
            "* hoverHeight (integer)\n"+
            "* hoverAlign (Alignment string)\n"+
            "* hoverVAlign (VerticalAlignment string)\n"+
            "* hoverWrap (boolean)\n"+
            "* hoverStyle (CSSStyleName string)\n"+
            "* hoverOpacity (number)\n"+
            "* hoverMoveWithMouse (boolean)\n"+
            "* edgeMarginSize (number)\n"+
            "* edgeCursorMap (object)\n"+
            "* keepInParentRect (boolean | array of integer)\n"+
            "* dragAppearance (DragAppearance string)\n"+
            "* dragType (string)\n"+
            "* dropTypes (array of string | string)\n"+
            "* dragTarget (Canvas | string)\n"+
            "* showDragShadow (boolean)\n"+
            "* dragOpacity (integer)\n"+
            "* canDrop (boolean)\n"+
            "* canAcceptDrop (boolean)\n"+
            "* canDropBefore (boolean)\n"+
            "* mouseStillDownInitialDelay (integer)\n"+
            "* mouseStillDownDelay (integer)\n"+
            "* doubleClickDelay (integer)\n"+
            "* noDoubleClicks (boolean)\n"+
            "* snapTo (string)\n"+
            "* snapOffsetLeft (integer)\n"+
            "* snapOffsetTop (integer)\n"+
            "* snapToGrid (boolean)\n"+
            "* snapResizeToGrid (boolean)\n"+
            "* childrenSnapToGrid (boolean)\n"+
            "* childrenSnapResizeToGrid (boolean)\n"+
            "* snapHGap (number)\n"+
            "* snapVGap (number)\n"+
            "* snapOnDrop (boolean)\n"+
            "* showPointer (boolean)\n"+
            "* pointerTarget (AutoTestLocator string | GlobalId string)\n"+
            "* pointerSettings (PointerSettings object)\n"+
            "* workflows (array of Process)\n"+
            "* borderRadius (string)\n"+
            "* showEdges (boolean)\n"+
            "* edgeSize (number)\n"+
            "* edgeOffset (number)\n"+
            "* edgeImage (SCImgURL string)\n"+
            "* customEdges (array of string)\n"+
            "* edgeBackgroundColor (CSSColor string)\n"+
            "* edgeOpacity (integer)\n"+
            "* edgeShowCenter (boolean)\n"+
            "* edgeCenterBackgroundColor (CSSColor string)\n"+
            "* showShadow (boolean)\n"+
            "* shadowDepth (number)\n"+
            "* shadowOffset (number)\n"+
            "* shadowSoftness (number)\n"+
            "* shadowImage (SCImgURL string)\n"+
            "* isGroup (boolean)\n"+
            "* groupTitle (HTML string)\n"+
            "* testDataContext (DataContext object)\n"+
            "* autoPopulateData (boolean)\n"+
            "* ruleScope (string)\n"+
            "* isRuleScope (boolean)\n"+
            "* valuesManager (ValuesManager | GlobalId string)\n"+
            "* dataPath (DataPath string)\n"+
            "* animateTime (number)\n"+
            "* animateAcceleration (AnimationAcceleration string)\n"+
            "* animateMoveTime (number)\n"+
            "* animateResizeTime (number)\n"+
            "* animateRectTime (number)\n"+
            "* animateFadeTime (number)\n"+
            "* animateScrollTime (number)\n"+
            "* animateShowTime (number)\n"+
            "* animateHideTime (number)\n"+
            "* animateMoveAcceleration (AnimationAcceleration string)\n"+
            "* animateResizeAcceleration (AnimationAcceleration string)\n"+
            "* animateRectAcceleration (AnimationAcceleration string)\n"+
            "* animateScrollAcceleration (AnimationAcceleration string)\n"+
            "* animateShowAcceleration (AnimationAcceleration string)\n"+
            "* animateHideAcceleration (AnimationAcceleration string)\n"+
            "* layoutAlign (Alignment string | VerticalAlignment string)\n"+
            "* showResizeBar (boolean)\n"+
            "* resizeBarTarget (string)\n"+
            "* extraSpace (positive integer)\n"+
            "\n"+
            "### Methods\n"+
            "* showNextTo()\n"+
            "* show()\n"+
            "* hide()\n"+
            "* click()\n"+
            "* print()\n",
        format:"Markdown"
    },
    "APIs list:Img":{
        topic:"APIs list for Img",
        content:"Only the following APIs are available on Img:\n"+
            "\n"+
            "## Attributes\n"+
            "* name (string)\n"+
            "* showRollOver (boolean)\n"+
            "* showFocused (boolean)\n"+
            "* showFocusedAsOver (boolean)\n"+
            "* showDown (boolean)\n"+
            "* showDisabled (boolean)\n"+
            "* src (SCImgURL string | SCStatefulImgConfig object)\n"+
            "* prompt (HTML string)\n"+
            "* activeAreaHTML (HTML string)\n"+
            "* imageType (ImageStyle string)\n"+
            "* imageHeight (integer)\n"+
            "* imageWidth (integer)\n"+
            "* size (number)\n"+
            "* showTitle (boolean)\n"+
            "\n"+
            "## Inherited from StatefulCanvas\n"+
            "\n"+
            "### Attributes\n"+
            "* selected (boolean)\n"+
            "* state (State string)\n"+
            "* actionType (SelectionType string)\n"+
            "* radioGroup (string)\n"+
            "* styleName (CSSStyleName string)\n"+
            "* baseStyle (CSSStyleName string)\n"+
            "* align (Alignment string)\n"+
            "* valign (VerticalAlignment string)\n"+
            "* width (number | string)\n"+
            "* height (number | string)\n"+
            "* icon (SCImgURL string)\n"+
            "* iconSize (integer)\n"+
            "* iconWidth (integer)\n"+
            "* iconHeight (integer)\n"+
            "* iconOrientation (string)\n"+
            "* iconSpacing (integer)\n"+
            "* showDisabledIcon (boolean)\n"+
            "* showRollOverIcon (boolean)\n"+
            "* showDownIcon (boolean)\n"+
            "* showSelectedIcon (boolean)\n"+
            "* showFocusedIcon (boolean)\n"+
            "* showOverCanvas (boolean)\n"+
            "* showMenuOnClick (boolean)\n"+
            "\n"+
            "## Inherited from Canvas\n"+
            "\n"+
            "### Attributes\n"+
            "* ID (GlobalId string)\n"+
            "* autoDraw (boolean)\n"+
            "* htmlElement (DOMElement object | string)\n"+
            "* htmlPosition (DrawPosition string)\n"+
            "* matchElement (boolean)\n"+
            "* position (Positioning string)\n"+
            "* left (number | string)\n"+
            "* top (number | string)\n"+
            "* defaultWidth (integer)\n"+
            "* defaultHeight (integer)\n"+
            "* minWidth (number)\n"+
            "* minHeight (number)\n"+
            "* maxWidth (number)\n"+
            "* maxHeight (number)\n"+
            "* autoShowParent (boolean)\n"+
            "* visibility (Visibility string)\n"+
            "* canSelectText (boolean)\n"+
            "* contents (HTML string)\n"+
            "* dynamicContents (boolean)\n"+
            "* dynamicContentsVars (ValueMap object)\n"+
            "* margin (number)\n"+
            "* padding (number)\n"+
            "* border (string)\n"+
            "* backgroundColor (CSSColor string)\n"+
            "* backgroundImage (SCImgURL string)\n"+
            "* backgroundRepeat (BackgroundRepeat string)\n"+
            "* appImgDir (URL string)\n"+
            "* skinImgDir (SCImgURL string)\n"+
            "* cursor (Cursor string)\n"+
            "* disabledCursor (Cursor string)\n"+
            "* opacity (number)\n"+
            "* overflow (Overflow string)\n"+
            "* showCustomScrollbars (boolean)\n"+
            "* scrollbarSize (number)\n"+
            "* disabled (boolean)\n"+
            "* visibleWhen (AdvancedCriteria object)\n"+
            "* enableWhen (AdvancedCriteria object)\n"+
            "* redrawOnResize (boolean)\n"+
            "* canFocus (boolean)\n"+
            "* tabIndex (number)\n"+
            "* accessKey (string)\n"+
            "* contextMenu (Menu)\n"+
            "* canDrag (boolean)\n"+
            "* dragStartDistance (number)\n"+
            "* canDragScroll (boolean)\n"+
            "* dragScrollDelay (number)\n"+
            "* dragIntersectStyle (DragIntersectStyle string)\n"+
            "* canDragReposition (boolean)\n"+
            "* dragRepositionCursor (Cursor string)\n"+
            "* canDragResize (boolean)\n"+
            "* resizeFrom (array of EdgeName string)\n"+
            "* canHover (boolean)\n"+
            "* hoverDelay (number)\n"+
            "* showHover (boolean)\n"+
            "* hoverWidth (integer)\n"+
            "* hoverHeight (integer)\n"+
            "* hoverAlign (Alignment string)\n"+
            "* hoverVAlign (VerticalAlignment string)\n"+
            "* hoverWrap (boolean)\n"+
            "* hoverStyle (CSSStyleName string)\n"+
            "* hoverOpacity (number)\n"+
            "* hoverMoveWithMouse (boolean)\n"+
            "* edgeMarginSize (number)\n"+
            "* edgeCursorMap (object)\n"+
            "* keepInParentRect (boolean | array of integer)\n"+
            "* dragAppearance (DragAppearance string)\n"+
            "* dragType (string)\n"+
            "* dropTypes (array of string | string)\n"+
            "* dragTarget (Canvas | string)\n"+
            "* showDragShadow (boolean)\n"+
            "* dragOpacity (integer)\n"+
            "* canDrop (boolean)\n"+
            "* canAcceptDrop (boolean)\n"+
            "* canDropBefore (boolean)\n"+
            "* mouseStillDownInitialDelay (integer)\n"+
            "* mouseStillDownDelay (integer)\n"+
            "* doubleClickDelay (integer)\n"+
            "* noDoubleClicks (boolean)\n"+
            "* snapTo (string)\n"+
            "* snapOffsetLeft (integer)\n"+
            "* snapOffsetTop (integer)\n"+
            "* snapToGrid (boolean)\n"+
            "* snapResizeToGrid (boolean)\n"+
            "* childrenSnapToGrid (boolean)\n"+
            "* childrenSnapResizeToGrid (boolean)\n"+
            "* snapHGap (number)\n"+
            "* snapVGap (number)\n"+
            "* snapOnDrop (boolean)\n"+
            "* showPointer (boolean)\n"+
            "* pointerTarget (AutoTestLocator string | GlobalId string)\n"+
            "* pointerSettings (PointerSettings object)\n"+
            "* workflows (array of Process)\n"+
            "* borderRadius (string)\n"+
            "* showEdges (boolean)\n"+
            "* edgeSize (number)\n"+
            "* edgeOffset (number)\n"+
            "* edgeImage (SCImgURL string)\n"+
            "* customEdges (array of string)\n"+
            "* edgeBackgroundColor (CSSColor string)\n"+
            "* edgeOpacity (integer)\n"+
            "* edgeShowCenter (boolean)\n"+
            "* edgeCenterBackgroundColor (CSSColor string)\n"+
            "* showShadow (boolean)\n"+
            "* shadowDepth (number)\n"+
            "* shadowOffset (number)\n"+
            "* shadowSoftness (number)\n"+
            "* shadowImage (SCImgURL string)\n"+
            "* isGroup (boolean)\n"+
            "* groupTitle (HTML string)\n"+
            "* testDataContext (DataContext object)\n"+
            "* autoPopulateData (boolean)\n"+
            "* ruleScope (string)\n"+
            "* isRuleScope (boolean)\n"+
            "* valuesManager (ValuesManager | GlobalId string)\n"+
            "* dataPath (DataPath string)\n"+
            "* animateTime (number)\n"+
            "* animateAcceleration (AnimationAcceleration string)\n"+
            "* animateMoveTime (number)\n"+
            "* animateResizeTime (number)\n"+
            "* animateRectTime (number)\n"+
            "* animateFadeTime (number)\n"+
            "* animateScrollTime (number)\n"+
            "* animateShowTime (number)\n"+
            "* animateHideTime (number)\n"+
            "* animateMoveAcceleration (AnimationAcceleration string)\n"+
            "* animateResizeAcceleration (AnimationAcceleration string)\n"+
            "* animateRectAcceleration (AnimationAcceleration string)\n"+
            "* animateScrollAcceleration (AnimationAcceleration string)\n"+
            "* animateShowAcceleration (AnimationAcceleration string)\n"+
            "* animateHideAcceleration (AnimationAcceleration string)\n"+
            "* layoutAlign (Alignment string | VerticalAlignment string)\n"+
            "* showResizeBar (boolean)\n"+
            "* resizeBarTarget (string)\n"+
            "* extraSpace (positive integer)\n"+
            "\n"+
            "### Methods\n"+
            "* showNextTo()\n"+
            "* show()\n"+
            "* hide()\n"+
            "* click()\n"+
            "* doubleClick()\n"+
            "* print()\n",
        format:"Markdown"
    },
    "APIs list:ImgButton":{
        topic:"APIs list for ImgButton",
        content:"Only the following APIs are available on ImgButton:\n"+
            "\n"+
            "## Attributes\n"+
            "* hiliteAccessKey (boolean)\n"+
            "* icon (SCImgURL string)\n"+
            "* iconSize (integer)\n"+
            "* iconWidth (integer)\n"+
            "* iconHeight (integer)\n"+
            "* iconOrientation (string)\n"+
            "* iconAlign (string)\n"+
            "* iconSpacing (integer)\n"+
            "* showDisabledIcon (boolean)\n"+
            "* showRollOverIcon (boolean)\n"+
            "* showFocusedIcon (boolean)\n"+
            "* showDownIcon (boolean)\n"+
            "* showSelectedIcon (boolean)\n"+
            "* width (number | string)\n"+
            "* height (number | string)\n"+
            "* baseStyle (CSSStyleName string)\n"+
            "* selected (boolean)\n"+
            "* radioGroup (string)\n"+
            "* actionType (SelectionType string)\n"+
            "* state (State string)\n"+
            "* showDisabled (boolean)\n"+
            "* showDown (boolean)\n"+
            "* showFocused (boolean)\n"+
            "* showRollOver (boolean)\n"+
            "* align (Alignment string)\n"+
            "* valign (VerticalAlignment string)\n"+
            "* showTitle (boolean)\n"+
            "* labelHPad (number)\n"+
            "* labelVPad (number)\n"+
            "* src (SCImgURL string | SCStatefulImgConfig object)\n"+
            "\n"+
            "## Inherited from Img\n"+
            "\n"+
            "### Attributes\n"+
            "* name (string)\n"+
            "* showFocusedAsOver (boolean)\n"+
            "* prompt (HTML string)\n"+
            "* activeAreaHTML (HTML string)\n"+
            "* imageType (ImageStyle string)\n"+
            "* imageHeight (integer)\n"+
            "* imageWidth (integer)\n"+
            "* size (number)\n"+
            "\n"+
            "## Inherited from StatefulCanvas\n"+
            "\n"+
            "### Attributes\n"+
            "* styleName (CSSStyleName string)\n"+
            "* showOverCanvas (boolean)\n"+
            "* showMenuOnClick (boolean)\n"+
            "\n"+
            "## Inherited from Canvas\n"+
            "\n"+
            "### Attributes\n"+
            "* ID (GlobalId string)\n"+
            "* autoDraw (boolean)\n"+
            "* htmlElement (DOMElement object | string)\n"+
            "* htmlPosition (DrawPosition string)\n"+
            "* matchElement (boolean)\n"+
            "* position (Positioning string)\n"+
            "* left (number | string)\n"+
            "* top (number | string)\n"+
            "* defaultWidth (integer)\n"+
            "* defaultHeight (integer)\n"+
            "* minWidth (number)\n"+
            "* minHeight (number)\n"+
            "* maxWidth (number)\n"+
            "* maxHeight (number)\n"+
            "* autoShowParent (boolean)\n"+
            "* visibility (Visibility string)\n"+
            "* canSelectText (boolean)\n"+
            "* contents (HTML string)\n"+
            "* dynamicContents (boolean)\n"+
            "* dynamicContentsVars (ValueMap object)\n"+
            "* margin (number)\n"+
            "* padding (number)\n"+
            "* border (string)\n"+
            "* backgroundColor (CSSColor string)\n"+
            "* backgroundImage (SCImgURL string)\n"+
            "* backgroundRepeat (BackgroundRepeat string)\n"+
            "* appImgDir (URL string)\n"+
            "* skinImgDir (SCImgURL string)\n"+
            "* cursor (Cursor string)\n"+
            "* disabledCursor (Cursor string)\n"+
            "* opacity (number)\n"+
            "* overflow (Overflow string)\n"+
            "* showCustomScrollbars (boolean)\n"+
            "* scrollbarSize (number)\n"+
            "* disabled (boolean)\n"+
            "* visibleWhen (AdvancedCriteria object)\n"+
            "* enableWhen (AdvancedCriteria object)\n"+
            "* redrawOnResize (boolean)\n"+
            "* canFocus (boolean)\n"+
            "* tabIndex (number)\n"+
            "* accessKey (string)\n"+
            "* contextMenu (Menu)\n"+
            "* canDrag (boolean)\n"+
            "* dragStartDistance (number)\n"+
            "* canDragScroll (boolean)\n"+
            "* dragScrollDelay (number)\n"+
            "* dragIntersectStyle (DragIntersectStyle string)\n"+
            "* canDragReposition (boolean)\n"+
            "* dragRepositionCursor (Cursor string)\n"+
            "* canDragResize (boolean)\n"+
            "* resizeFrom (array of EdgeName string)\n"+
            "* canHover (boolean)\n"+
            "* hoverDelay (number)\n"+
            "* showHover (boolean)\n"+
            "* hoverWidth (integer)\n"+
            "* hoverHeight (integer)\n"+
            "* hoverAlign (Alignment string)\n"+
            "* hoverVAlign (VerticalAlignment string)\n"+
            "* hoverWrap (boolean)\n"+
            "* hoverStyle (CSSStyleName string)\n"+
            "* hoverOpacity (number)\n"+
            "* hoverMoveWithMouse (boolean)\n"+
            "* edgeMarginSize (number)\n"+
            "* edgeCursorMap (object)\n"+
            "* keepInParentRect (boolean | array of integer)\n"+
            "* dragAppearance (DragAppearance string)\n"+
            "* dragType (string)\n"+
            "* dropTypes (array of string | string)\n"+
            "* dragTarget (Canvas | string)\n"+
            "* showDragShadow (boolean)\n"+
            "* dragOpacity (integer)\n"+
            "* canDrop (boolean)\n"+
            "* canAcceptDrop (boolean)\n"+
            "* canDropBefore (boolean)\n"+
            "* mouseStillDownInitialDelay (integer)\n"+
            "* mouseStillDownDelay (integer)\n"+
            "* doubleClickDelay (integer)\n"+
            "* noDoubleClicks (boolean)\n"+
            "* snapTo (string)\n"+
            "* snapOffsetLeft (integer)\n"+
            "* snapOffsetTop (integer)\n"+
            "* snapToGrid (boolean)\n"+
            "* snapResizeToGrid (boolean)\n"+
            "* childrenSnapToGrid (boolean)\n"+
            "* childrenSnapResizeToGrid (boolean)\n"+
            "* snapHGap (number)\n"+
            "* snapVGap (number)\n"+
            "* snapOnDrop (boolean)\n"+
            "* showPointer (boolean)\n"+
            "* pointerTarget (AutoTestLocator string | GlobalId string)\n"+
            "* pointerSettings (PointerSettings object)\n"+
            "* workflows (array of Process)\n"+
            "* borderRadius (string)\n"+
            "* showEdges (boolean)\n"+
            "* edgeSize (number)\n"+
            "* edgeOffset (number)\n"+
            "* edgeImage (SCImgURL string)\n"+
            "* customEdges (array of string)\n"+
            "* edgeBackgroundColor (CSSColor string)\n"+
            "* edgeOpacity (integer)\n"+
            "* edgeShowCenter (boolean)\n"+
            "* edgeCenterBackgroundColor (CSSColor string)\n"+
            "* showShadow (boolean)\n"+
            "* shadowDepth (number)\n"+
            "* shadowOffset (number)\n"+
            "* shadowSoftness (number)\n"+
            "* shadowImage (SCImgURL string)\n"+
            "* isGroup (boolean)\n"+
            "* groupTitle (HTML string)\n"+
            "* testDataContext (DataContext object)\n"+
            "* autoPopulateData (boolean)\n"+
            "* ruleScope (string)\n"+
            "* isRuleScope (boolean)\n"+
            "* valuesManager (ValuesManager | GlobalId string)\n"+
            "* dataPath (DataPath string)\n"+
            "* animateTime (number)\n"+
            "* animateAcceleration (AnimationAcceleration string)\n"+
            "* animateMoveTime (number)\n"+
            "* animateResizeTime (number)\n"+
            "* animateRectTime (number)\n"+
            "* animateFadeTime (number)\n"+
            "* animateScrollTime (number)\n"+
            "* animateShowTime (number)\n"+
            "* animateHideTime (number)\n"+
            "* animateMoveAcceleration (AnimationAcceleration string)\n"+
            "* animateResizeAcceleration (AnimationAcceleration string)\n"+
            "* animateRectAcceleration (AnimationAcceleration string)\n"+
            "* animateScrollAcceleration (AnimationAcceleration string)\n"+
            "* animateShowAcceleration (AnimationAcceleration string)\n"+
            "* animateHideAcceleration (AnimationAcceleration string)\n"+
            "* layoutAlign (Alignment string | VerticalAlignment string)\n"+
            "* showResizeBar (boolean)\n"+
            "* resizeBarTarget (string)\n"+
            "* extraSpace (positive integer)\n"+
            "\n"+
            "### Methods\n"+
            "* showNextTo()\n"+
            "* show()\n"+
            "* hide()\n"+
            "* click()\n"+
            "* doubleClick()\n"+
            "* print()\n",
        format:"Markdown"
    },
    "APIs list:Menu":{
        topic:"APIs list for Menu",
        content:"Only the following APIs are available on Menu:\n"+
            "\n"+
            "## Attributes\n"+
            "* canShowFilterEditor (boolean)\n"+
            "* canSaveSearches (boolean)\n"+
            "* data (array of MenuItem objects | array of Record[ | Tree | RecordList)\n"+
            "* items (array of MenuItem objects)\n"+
            "* dataSource (DataSource)\n"+
            "* initialCriteria (Criteria object)\n"+
            "* autoFetchData (boolean)\n"+
            "* bodyStyleName (CSSStyleName string)\n"+
            "* defaultWidth (integer)\n"+
            "* cellHeight (number)\n"+
            "* autoDraw (boolean)\n"+
            "* baseStyle (CSSStyleName string)\n"+
            "* useKeys (boolean)\n"+
            "* showKeys (boolean)\n"+
            "* showIcons (boolean)\n"+
            "* showSubmenus (boolean)\n"+
            "* emptyMessage (HTML string)\n"+
            "* iconWidth (number)\n"+
            "* iconHeight (number)\n"+
            "* showAnimationEffect (string)\n"+
            "* submenuImage (SCImgURL string | ImgHTML properties object)\n"+
            "* submenuDisabledImage (SCImgURL string | ImgHTML properties object)\n"+
            "* checkmarkImage (SCImgURL string | ImgHTML properties object)\n"+
            "* checkmarkDisabledImage (SCImgURL string | ImgHTML properties object)\n"+
            "* canSelectParentItems (boolean)\n"+
            "* autoDismiss (boolean)\n"+
            "* showEdges (boolean)\n"+
            "* showShadow (boolean)\n"+
            "\n"+
            "## Methods\n"+
            "* fetchData()\n"+
            "\n"+
            "## Inherited from ListGrid\n"+
            "\n"+
            "### Attributes\n"+
            "* fetchRequestProperties (DSRequest properties object)\n"+
            "* implicitCriteria (Criteria object)\n"+
            "* styleName (CSSStyleName string)\n"+
            "* dataArity (string)\n"+
            "* useAllDataSourceFields (boolean)\n"+
            "* saveDefaultSearch (boolean)\n"+
            "* savedSearchStoredState (SavedSearchStoredState string)\n"+
            "* noSavedSearchesText (HTML string)\n"+
            "* savedSearchText (HTML string)\n"+
            "* newSearchText (HTML string)\n"+
            "* savedSearchAdminSeparator (ListGridRecord properties object)\n"+
            "* savedSearchDS (string)\n"+
            "* savedSearchAdminRole (string)\n"+
            "* groupStartOpen (GroupStartOpen string | array)\n"+
            "* groupTitleColumnProperties (ListGridField properties object)\n"+
            "* canGroupBy (boolean)\n"+
            "* groupByField (string | array of string)\n"+
            "* overflow (Overflow string)\n"+
            "* autoFitData (Autofit string)\n"+
            "* autoFitMaxRecords (integer)\n"+
            "* cellPadding (number)\n"+
            "* showRecordComponents (boolean)\n"+
            "* recordComponentPosition (EmbeddedPosition string)\n"+
            "* hoverStyle (CSSStyleName string)\n"+
            "* selectionType (SelectionStyle string)\n"+
            "* showEmptyMessage (boolean)\n"+
            "* loadingDataMessage (HTML string)\n"+
            "* showFilterEditor (boolean)\n"+
            "* autoFetchTextMatchStyle (TextMatchStyle string)\n"+
            "* canEdit (boolean)\n"+
            "* editByCell (boolean)\n"+
            "* saveByCell (boolean)\n"+
            "* canRemoveRecords (boolean)\n"+
            "* warnOnRemoval (boolean)\n"+
            "* warnOnRemovalMessage (string)\n"+
            "* editEvent (ListGridEditEvent string)\n"+
            "* wrapHeaderTitles (boolean)\n"+
            "* canSort (boolean)\n"+
            "* canEditHilites (boolean)\n"+
            "* canDragRecordsOut (boolean)\n"+
            "* canAcceptDroppedRecords (boolean)\n"+
            "* canReorderRecords (boolean)\n"+
            "* dragDataAction (DragDataAction string)\n"+
            "* skinImgDir (SCImgURL string)\n"+
            "* canExpandMultipleRecords (boolean)\n"+
            "* detailField (string)\n"+
            "* expansionMode (ExpansionMode string)\n"+
            "* expansionScreen (string)\n"+
            "* detailDS (string)\n"+
            "* viewState (ListGridViewState string)\n"+
            "* autoPersistViewState (array of ListGridViewStatePart string)\n"+
            "* gridComponents (array of ListGridComponent string | array of Any)\n"+
            "* autoFitHeaderHeights (boolean)\n"+
            "* applyFormulaAfterSummary (boolean)\n"+
            "* showHoverComponents (boolean)\n"+
            "* hoverMode (HoverMode string)\n"+
            "* hoverScreen (string)\n"+
            "* showGridSummary (boolean)\n"+
            "* hideEmptySummaryRow (boolean)\n"+
            "* allowFilterExpressions (boolean)\n"+
            "* updateSummariesDuringEditing (boolean)\n"+
            "* allowFilterWindow (boolean)\n"+
            "* showFilterWindowCriteriaIndicator (boolean)\n"+
            "* searchForm (DynamicForm | ValuesManager)\n"+
            "* showFilterEditorHovers (boolean)\n"+
            "* initialSort (array of SortSpecifier objects)\n"+
            "* recordScreen (string)\n"+
            "* showGroupSummary (boolean)\n"+
            "* useAdvancedFieldPicker (boolean)\n"+
            "* advancedFieldPickerThreshold (integer)\n"+
            "\n"+
            "### Methods\n"+
            "* exportData()\n"+
            "* filterData()\n"+
            "* fetchRelatedData()\n"+
            "* removeSelectedData()\n"+
            "* exportClientData()\n"+
            "* recordClick()\n"+
            "* recordDoubleClick()\n"+
            "* startEditing()\n"+
            "* startEditingNew()\n"+
            "* removeRecordClick()\n"+
            "* selectionUpdated()\n"+
            "\n"+
            "## Inherited from Canvas\n"+
            "\n"+
            "### Attributes\n"+
            "* ID (GlobalId string)\n"+
            "* htmlElement (DOMElement object | string)\n"+
            "* htmlPosition (DrawPosition string)\n"+
            "* matchElement (boolean)\n"+
            "* position (Positioning string)\n"+
            "* left (number | string)\n"+
            "* top (number | string)\n"+
            "* width (number | string)\n"+
            "* height (number | string)\n"+
            "* defaultHeight (integer)\n"+
            "* minWidth (number)\n"+
            "* maxWidth (number)\n"+
            "* maxHeight (number)\n"+
            "* autoShowParent (boolean)\n"+
            "* visibility (Visibility string)\n"+
            "* canSelectText (boolean)\n"+
            "* contents (HTML string)\n"+
            "* dynamicContents (boolean)\n"+
            "* dynamicContentsVars (ValueMap object)\n"+
            "* margin (number)\n"+
            "* padding (number)\n"+
            "* border (string)\n"+
            "* backgroundColor (CSSColor string)\n"+
            "* backgroundImage (SCImgURL string)\n"+
            "* backgroundRepeat (BackgroundRepeat string)\n"+
            "* appImgDir (URL string)\n"+
            "* cursor (Cursor string)\n"+
            "* disabledCursor (Cursor string)\n"+
            "* opacity (number)\n"+
            "* showCustomScrollbars (boolean)\n"+
            "* scrollbarSize (number)\n"+
            "* disabled (boolean)\n"+
            "* visibleWhen (AdvancedCriteria object)\n"+
            "* enableWhen (AdvancedCriteria object)\n"+
            "* redrawOnResize (boolean)\n"+
            "* canFocus (boolean)\n"+
            "* tabIndex (number)\n"+
            "* accessKey (string)\n"+
            "* contextMenu (Menu)\n"+
            "* prompt (HTML string)\n"+
            "* canDrag (boolean)\n"+
            "* dragStartDistance (number)\n"+
            "* canDragScroll (boolean)\n"+
            "* dragScrollDelay (number)\n"+
            "* dragIntersectStyle (DragIntersectStyle string)\n"+
            "* canDragReposition (boolean)\n"+
            "* dragRepositionCursor (Cursor string)\n"+
            "* canDragResize (boolean)\n"+
            "* resizeFrom (array of EdgeName string)\n"+
            "* hoverDelay (number)\n"+
            "* hoverWidth (integer)\n"+
            "* hoverHeight (integer)\n"+
            "* hoverAlign (Alignment string)\n"+
            "* hoverVAlign (VerticalAlignment string)\n"+
            "* hoverWrap (boolean)\n"+
            "* hoverOpacity (number)\n"+
            "* hoverMoveWithMouse (boolean)\n"+
            "* edgeMarginSize (number)\n"+
            "* edgeCursorMap (object)\n"+
            "* keepInParentRect (boolean | array of integer)\n"+
            "* dragAppearance (DragAppearance string)\n"+
            "* dragType (string)\n"+
            "* dropTypes (array of string | string)\n"+
            "* dragTarget (Canvas | string)\n"+
            "* showDragShadow (boolean)\n"+
            "* dragOpacity (integer)\n"+
            "* canDrop (boolean)\n"+
            "* canAcceptDrop (boolean)\n"+
            "* canDropBefore (boolean)\n"+
            "* mouseStillDownInitialDelay (integer)\n"+
            "* mouseStillDownDelay (integer)\n"+
            "* doubleClickDelay (integer)\n"+
            "* noDoubleClicks (boolean)\n"+
            "* snapTo (string)\n"+
            "* snapOffsetLeft (integer)\n"+
            "* snapOffsetTop (integer)\n"+
            "* snapToGrid (boolean)\n"+
            "* snapResizeToGrid (boolean)\n"+
            "* childrenSnapToGrid (boolean)\n"+
            "* childrenSnapResizeToGrid (boolean)\n"+
            "* snapHGap (number)\n"+
            "* snapVGap (number)\n"+
            "* snapOnDrop (boolean)\n"+
            "* showPointer (boolean)\n"+
            "* pointerTarget (AutoTestLocator string | GlobalId string)\n"+
            "* pointerSettings (PointerSettings object)\n"+
            "* workflows (array of Process)\n"+
            "* borderRadius (string)\n"+
            "* edgeSize (number)\n"+
            "* edgeOffset (number)\n"+
            "* edgeImage (SCImgURL string)\n"+
            "* customEdges (array of string)\n"+
            "* edgeBackgroundColor (CSSColor string)\n"+
            "* edgeOpacity (integer)\n"+
            "* edgeShowCenter (boolean)\n"+
            "* edgeCenterBackgroundColor (CSSColor string)\n"+
            "* shadowDepth (number)\n"+
            "* shadowOffset (number)\n"+
            "* shadowSoftness (number)\n"+
            "* shadowImage (SCImgURL string)\n"+
            "* isGroup (boolean)\n"+
            "* groupTitle (HTML string)\n"+
            "* testDataContext (DataContext object)\n"+
            "* autoPopulateData (boolean)\n"+
            "* ruleScope (string)\n"+
            "* isRuleScope (boolean)\n"+
            "* valuesManager (ValuesManager | GlobalId string)\n"+
            "* dataPath (DataPath string)\n"+
            "* animateTime (number)\n"+
            "* animateAcceleration (AnimationAcceleration string)\n"+
            "* animateMoveTime (number)\n"+
            "* animateResizeTime (number)\n"+
            "* animateRectTime (number)\n"+
            "* animateFadeTime (number)\n"+
            "* animateScrollTime (number)\n"+
            "* animateShowTime (number)\n"+
            "* animateHideTime (number)\n"+
            "* animateMoveAcceleration (AnimationAcceleration string)\n"+
            "* animateResizeAcceleration (AnimationAcceleration string)\n"+
            "* animateRectAcceleration (AnimationAcceleration string)\n"+
            "* animateScrollAcceleration (AnimationAcceleration string)\n"+
            "* animateShowAcceleration (AnimationAcceleration string)\n"+
            "* animateHideAcceleration (AnimationAcceleration string)\n"+
            "* layoutAlign (Alignment string | VerticalAlignment string)\n"+
            "* showResizeBar (boolean)\n"+
            "* resizeBarTarget (string)\n"+
            "* extraSpace (positive integer)\n"+
            "\n"+
            "### Methods\n"+
            "* showNextTo()\n"+
            "* show()\n"+
            "* hide()\n"+
            "* print()\n",
        format:"Markdown"
    },
    "APIs list:MenuItem":{
        topic:"APIs list for MenuItem",
        content:"Only the following APIs are available on MenuItem:\n"+
            "\n"+
            "## Attributes\n"+
            "* title (HTML string)\n"+
            "* submenu (Menu)\n"+
            "* canSelectParent (boolean)\n"+
            "* isSeparator (boolean)\n"+
            "* enabled (boolean)\n"+
            "* checked (boolean)\n"+
            "* icon (string)\n"+
            "* iconWidth (number)\n"+
            "* iconHeight (number)\n"+
            "* keys (KeyIdentifier object | array of KeyIdentifier objects)\n"+
            "* keyTitle (string)\n"+
            "* enableWhen (AdvancedCriteria object)\n"+
            "* visibleWhen (AdvancedCriteria object)\n"+
            "* embeddedComponent (Canvas)\n"+
            "* embeddedComponentFields (array of string)\n"+
            "\n"+
            "## Methods\n"+
            "* click()\n"+
            "\n"+
            "## Inherited from ListGridRecord\n"+
            "\n"+
            "### Attributes\n"+
            "* singleCellValue (HTML string)\n"+
            "* canDrag (boolean)\n"+
            "* canAcceptDrop (boolean)\n"+
            "* linkText (string)\n",
        format:"Markdown"
    },
    "APIs list:MenuButton":{
        topic:"APIs list for MenuButton",
        content:"Only the following APIs are available on MenuButton:\n"+
            "\n"+
            "## Attributes\n"+
            "* title (string)\n"+
            "* height (number | string)\n"+
            "* icon (SCImgURL string)\n"+
            "* showMenuButtonImage (boolean)\n"+
            "* menuButtonImage (SCImgURL string)\n"+
            "* menuButtonImageUp (SCImgURL string)\n"+
            "* hiliteAccessKey (boolean)\n"+
            "* showMenuBelow (boolean)\n"+
            "* menu (Menu)\n"+
            "* menuAnimationEffect (string)\n"+
            "* showMenuOnRollOver (boolean)\n"+
            "\n"+
            "## Inherited from Button\n"+
            "\n"+
            "### Attributes\n"+
            "* iconSize (integer)\n"+
            "* iconWidth (integer)\n"+
            "* iconHeight (integer)\n"+
            "* iconOrientation (string)\n"+
            "* iconAlign (string)\n"+
            "* iconSpacing (integer)\n"+
            "* showDisabledIcon (boolean)\n"+
            "* showRollOverIcon (boolean)\n"+
            "* showFocusedIcon (boolean)\n"+
            "* showDownIcon (boolean)\n"+
            "* showSelectedIcon (boolean)\n"+
            "* autoFit (boolean)\n"+
            "* width (number | string)\n"+
            "* styleName (CSSStyleName string)\n"+
            "* baseStyle (CSSStyleName string)\n"+
            "* selected (boolean)\n"+
            "* radioGroup (string)\n"+
            "* actionType (SelectionType string)\n"+
            "* state (State string)\n"+
            "* showDisabled (boolean)\n"+
            "* showDown (boolean)\n"+
            "* showFocused (boolean)\n"+
            "* showRollOver (boolean)\n"+
            "* align (Alignment string)\n"+
            "* valign (VerticalAlignment string)\n"+
            "* wrap (boolean)\n"+
            "* overflow (Overflow string)\n"+
            "\n"+
            "## Inherited from StatefulCanvas\n"+
            "\n"+
            "### Attributes\n"+
            "* showFocusedAsOver (boolean)\n"+
            "* showOverCanvas (boolean)\n"+
            "* showMenuOnClick (boolean)\n"+
            "\n"+
            "## Inherited from Canvas\n"+
            "\n"+
            "### Attributes\n"+
            "* ID (GlobalId string)\n"+
            "* autoDraw (boolean)\n"+
            "* htmlElement (DOMElement object | string)\n"+
            "* htmlPosition (DrawPosition string)\n"+
            "* matchElement (boolean)\n"+
            "* position (Positioning string)\n"+
            "* left (number | string)\n"+
            "* top (number | string)\n"+
            "* defaultWidth (integer)\n"+
            "* defaultHeight (integer)\n"+
            "* minWidth (number)\n"+
            "* minHeight (number)\n"+
            "* maxWidth (number)\n"+
            "* maxHeight (number)\n"+
            "* autoShowParent (boolean)\n"+
            "* visibility (Visibility string)\n"+
            "* canSelectText (boolean)\n"+
            "* contents (HTML string)\n"+
            "* dynamicContents (boolean)\n"+
            "* dynamicContentsVars (ValueMap object)\n"+
            "* margin (number)\n"+
            "* padding (number)\n"+
            "* border (string)\n"+
            "* backgroundColor (CSSColor string)\n"+
            "* backgroundImage (SCImgURL string)\n"+
            "* backgroundRepeat (BackgroundRepeat string)\n"+
            "* appImgDir (URL string)\n"+
            "* skinImgDir (SCImgURL string)\n"+
            "* cursor (Cursor string)\n"+
            "* disabledCursor (Cursor string)\n"+
            "* opacity (number)\n"+
            "* showCustomScrollbars (boolean)\n"+
            "* scrollbarSize (number)\n"+
            "* disabled (boolean)\n"+
            "* visibleWhen (AdvancedCriteria object)\n"+
            "* enableWhen (AdvancedCriteria object)\n"+
            "* redrawOnResize (boolean)\n"+
            "* canFocus (boolean)\n"+
            "* tabIndex (number)\n"+
            "* accessKey (string)\n"+
            "* contextMenu (Menu)\n"+
            "* prompt (HTML string)\n"+
            "* canDrag (boolean)\n"+
            "* dragStartDistance (number)\n"+
            "* canDragScroll (boolean)\n"+
            "* dragScrollDelay (number)\n"+
            "* dragIntersectStyle (DragIntersectStyle string)\n"+
            "* canDragReposition (boolean)\n"+
            "* dragRepositionCursor (Cursor string)\n"+
            "* canDragResize (boolean)\n"+
            "* resizeFrom (array of EdgeName string)\n"+
            "* canHover (boolean)\n"+
            "* hoverDelay (number)\n"+
            "* showHover (boolean)\n"+
            "* hoverWidth (integer)\n"+
            "* hoverHeight (integer)\n"+
            "* hoverAlign (Alignment string)\n"+
            "* hoverVAlign (VerticalAlignment string)\n"+
            "* hoverWrap (boolean)\n"+
            "* hoverStyle (CSSStyleName string)\n"+
            "* hoverOpacity (number)\n"+
            "* hoverMoveWithMouse (boolean)\n"+
            "* edgeMarginSize (number)\n"+
            "* edgeCursorMap (object)\n"+
            "* keepInParentRect (boolean | array of integer)\n"+
            "* dragAppearance (DragAppearance string)\n"+
            "* dragType (string)\n"+
            "* dropTypes (array of string | string)\n"+
            "* dragTarget (Canvas | string)\n"+
            "* showDragShadow (boolean)\n"+
            "* dragOpacity (integer)\n"+
            "* canDrop (boolean)\n"+
            "* canAcceptDrop (boolean)\n"+
            "* canDropBefore (boolean)\n"+
            "* mouseStillDownInitialDelay (integer)\n"+
            "* mouseStillDownDelay (integer)\n"+
            "* doubleClickDelay (integer)\n"+
            "* noDoubleClicks (boolean)\n"+
            "* snapTo (string)\n"+
            "* snapOffsetLeft (integer)\n"+
            "* snapOffsetTop (integer)\n"+
            "* snapToGrid (boolean)\n"+
            "* snapResizeToGrid (boolean)\n"+
            "* childrenSnapToGrid (boolean)\n"+
            "* childrenSnapResizeToGrid (boolean)\n"+
            "* snapHGap (number)\n"+
            "* snapVGap (number)\n"+
            "* snapOnDrop (boolean)\n"+
            "* showPointer (boolean)\n"+
            "* pointerTarget (AutoTestLocator string | GlobalId string)\n"+
            "* pointerSettings (PointerSettings object)\n"+
            "* workflows (array of Process)\n"+
            "* borderRadius (string)\n"+
            "* showEdges (boolean)\n"+
            "* edgeSize (number)\n"+
            "* edgeOffset (number)\n"+
            "* edgeImage (SCImgURL string)\n"+
            "* customEdges (array of string)\n"+
            "* edgeBackgroundColor (CSSColor string)\n"+
            "* edgeOpacity (integer)\n"+
            "* edgeShowCenter (boolean)\n"+
            "* edgeCenterBackgroundColor (CSSColor string)\n"+
            "* showShadow (boolean)\n"+
            "* shadowDepth (number)\n"+
            "* shadowOffset (number)\n"+
            "* shadowSoftness (number)\n"+
            "* shadowImage (SCImgURL string)\n"+
            "* isGroup (boolean)\n"+
            "* groupTitle (HTML string)\n"+
            "* testDataContext (DataContext object)\n"+
            "* autoPopulateData (boolean)\n"+
            "* ruleScope (string)\n"+
            "* isRuleScope (boolean)\n"+
            "* valuesManager (ValuesManager | GlobalId string)\n"+
            "* dataPath (DataPath string)\n"+
            "* animateTime (number)\n"+
            "* animateAcceleration (AnimationAcceleration string)\n"+
            "* animateMoveTime (number)\n"+
            "* animateResizeTime (number)\n"+
            "* animateRectTime (number)\n"+
            "* animateFadeTime (number)\n"+
            "* animateScrollTime (number)\n"+
            "* animateShowTime (number)\n"+
            "* animateHideTime (number)\n"+
            "* animateMoveAcceleration (AnimationAcceleration string)\n"+
            "* animateResizeAcceleration (AnimationAcceleration string)\n"+
            "* animateRectAcceleration (AnimationAcceleration string)\n"+
            "* animateScrollAcceleration (AnimationAcceleration string)\n"+
            "* animateShowAcceleration (AnimationAcceleration string)\n"+
            "* animateHideAcceleration (AnimationAcceleration string)\n"+
            "* layoutAlign (Alignment string | VerticalAlignment string)\n"+
            "* showResizeBar (boolean)\n"+
            "* resizeBarTarget (string)\n"+
            "* extraSpace (positive integer)\n"+
            "\n"+
            "### Methods\n"+
            "* showNextTo()\n"+
            "* show()\n"+
            "* hide()\n"+
            "* click()\n"+
            "* print()\n",
        format:"Markdown"
    },
    "APIs list:TreeGrid":{
        topic:"APIs list for TreeGrid",
        content:"Only the following APIs are available on TreeGrid:\n"+
            "\n"+
            "## Attributes\n"+
            "* dataSource (DataSource | ID string)\n"+
            "* data (Tree)\n"+
            "* initialData (array of TreeNode objects)\n"+
            "* loadDataOnDemand (boolean)\n"+
            "* dataArity (string)\n"+
            "* autoFetchTextMatchStyle (TextMatchStyle string)\n"+
            "* selectionProperty (string)\n"+
            "* fields (array of TreeGridField objects)\n"+
            "* treeFieldTitle (string)\n"+
            "* showRoot (boolean)\n"+
            "* separateFolders (boolean)\n"+
            "* dataProperties (Tree)\n"+
            "* displayNodeType (DisplayNodeType string)\n"+
            "* canDragRecordsOut (boolean)\n"+
            "* canAcceptDroppedRecords (boolean)\n"+
            "* canReorderRecords (boolean)\n"+
            "* canDropOnLeaves (boolean)\n"+
            "* canReparentNodes (boolean)\n"+
            "* dragDataAction (DragDataAction string)\n"+
            "* parentAlreadyContainsChildMessage (string)\n"+
            "* cantDragIntoSelfMessage (string)\n"+
            "* cantDragIntoChildMessage (string)\n"+
            "* indentSize (number)\n"+
            "* iconSize (number)\n"+
            "* folderIcon (SCImgURL string)\n"+
            "* dropIconSuffix (string)\n"+
            "* openIconSuffix (string)\n"+
            "* closedIconSuffix (string)\n"+
            "* nodeIcon (SCImgURL string)\n"+
            "* showOpenIcons (boolean)\n"+
            "* showDropIcons (boolean)\n"+
            "* customIconProperty (string)\n"+
            "* customIconOpenProperty (string)\n"+
            "* customIconDropProperty (string)\n"+
            "* showCustomIconOpen (boolean)\n"+
            "* showCustomIconDrop (boolean)\n"+
            "* manyItemsImage (SCImgURL string)\n"+
            "* showConnectors (boolean)\n"+
            "* openerImage (SCImgURL string | SCStatefulImgConfig object)\n"+
            "* connectorImage (SCImgURL string | SCStatefulImgConfig object)\n"+
            "* useAllDataSourceFields (boolean)\n"+
            "* autoOpenTree (string)\n"+
            "* animateFolders (boolean)\n"+
            "* animateFolderTime (number)\n"+
            "* animateFolderSpeed (number)\n"+
            "* animateFolderEffect (AnimationAcceleration string)\n"+
            "\n"+
            "## Methods\n"+
            "* fetchData()\n"+
            "* filterData()\n"+
            "* exportClientData()\n"+
            "* startEditingNew()\n"+
            "* recordDoubleClick()\n"+
            "* folderClick()\n"+
            "* leafClick()\n"+
            "* nodeClick()\n"+
            "\n"+
            "## Inherited from ListGrid\n"+
            "\n"+
            "### Attributes\n"+
            "* autoFetchData (boolean)\n"+
            "* fetchRequestProperties (DSRequest properties object)\n"+
            "* initialCriteria (Criteria object)\n"+
            "* implicitCriteria (Criteria object)\n"+
            "* styleName (CSSStyleName string)\n"+
            "* autoFetchDisplayMap (boolean)\n"+
            "* saveLocally (boolean)\n"+
            "* showDetailFields (boolean)\n"+
            "* titleField (string)\n"+
            "* saveDefaultSearch (boolean)\n"+
            "* canSaveSearches (boolean)\n"+
            "* savedSearchStoredState (SavedSearchStoredState string)\n"+
            "* noSavedSearchesText (HTML string)\n"+
            "* savedSearchText (HTML string)\n"+
            "* newSearchText (HTML string)\n"+
            "* savedSearchAdminSeparator (ListGridRecord properties object)\n"+
            "* savedSearchDS (string)\n"+
            "* savedSearchAdminRole (string)\n"+
            "* groupStartOpen (GroupStartOpen string | array)\n"+
            "* groupTitleColumnProperties (ListGridField properties object)\n"+
            "* groupIconSize (number)\n"+
            "* groupIndentSize (number)\n"+
            "* groupByMaxRecords (integer)\n"+
            "* valueIconSize (number)\n"+
            "* valueIconWidth (number)\n"+
            "* valueIconHeight (number)\n"+
            "* valueIconLeftPadding (number)\n"+
            "* valueIconRightPadding (number)\n"+
            "* hiliteIcons (array of string)\n"+
            "* hiliteIconPosition (HiliteIconPosition string)\n"+
            "* hiliteIconSize (number)\n"+
            "* hiliteIconWidth (number)\n"+
            "* hiliteIconHeight (number)\n"+
            "* hiliteIconLeftPadding (number)\n"+
            "* hiliteIconRightPadding (number)\n"+
            "* imageSize (number)\n"+
            "* headerSpans (array of HeaderSpan objects)\n"+
            "* headerSpanHeight (integer)\n"+
            "* showTreeColumnPicker (boolean)\n"+
            "* modalEditing (boolean)\n"+
            "* fetchDelay (number)\n"+
            "* overflow (Overflow string)\n"+
            "* minHeight (number)\n"+
            "* showAllRecords (boolean)\n"+
            "* drawAheadRatio (number)\n"+
            "* scrollRedrawDelay (integer)\n"+
            "* dataPageSize (integer)\n"+
            "* bodyOverflow (Overflow string)\n"+
            "* bodyBackgroundColor (string)\n"+
            "* bodyStyleName (CSSStyleName string)\n"+
            "* emptyCellValue (HTML string)\n"+
            "* cellHeight (number)\n"+
            "* fixedRecordHeights (boolean)\n"+
            "* fixedFieldWidths (boolean)\n"+
            "* autoFitData (Autofit string)\n"+
            "* autoFitMaxHeight (integer)\n"+
            "* autoFitMaxRecords (integer)\n"+
            "* autoFitMaxWidth (integer | string)\n"+
            "* autoFitMaxColumns (integer)\n"+
            "* autoFitFieldWidths (boolean)\n"+
            "* autoFitWidthApproach (AutoFitWidthApproach string)\n"+
            "* leaveScrollbarGap (boolean)\n"+
            "* wrapCells (boolean)\n"+
            "* cellPadding (number)\n"+
            "* dateFormatter (DateDisplayFormat string)\n"+
            "* dateInputFormat (DateInputFormat string)\n"+
            "* timeFormatter (TimeDisplayFormat string)\n"+
            "* fastCellUpdates (boolean)\n"+
            "* baseStyle (CSSStyleName string)\n"+
            "* editFailedBaseStyle (CSSStyleName string)\n"+
            "* editFailedCSSText (string)\n"+
            "* editPendingCSSText (string)\n"+
            "* recordCustomStyleProperty (string)\n"+
            "* recordBaseStyleProperty (string)\n"+
            "* shrinkForFreeze (boolean)\n"+
            "* alternateRecordStyles (boolean)\n"+
            "* alternateRecordFrequency (number)\n"+
            "* generateClickOnSpace (boolean)\n"+
            "* generateClickOnEnter (boolean)\n"+
            "* generateDoubleClickOnSpace (boolean)\n"+
            "* generateDoubleClickOnEnter (boolean)\n"+
            "* arrowKeyAction (string)\n"+
            "* showRecordComponents (boolean)\n"+
            "* recordComponentPosition (EmbeddedPosition string)\n"+
            "* showRollOver (boolean)\n"+
            "* canHover (boolean)\n"+
            "* showHover (boolean)\n"+
            "* hoverStyle (CSSStyleName string)\n"+
            "* selectionAppearance (SelectionAppearance string)\n"+
            "* selectionType (SelectionStyle string)\n"+
            "* canDragSelect (boolean)\n"+
            "* checkboxFieldImageWidth (integer)\n"+
            "* checkboxFieldImageHeight (integer)\n"+
            "* showEmptyMessage (boolean)\n"+
            "* emptyMessage (HTML string)\n"+
            "* emptyMessageStyle (CSSStyleName string)\n"+
            "* loadingDataMessage (HTML string)\n"+
            "* loadingDataMessageStyle (CSSStyleName string)\n"+
            "* loadingMessage (string)\n"+
            "* singleCellValueProperty (string)\n"+
            "* isSeparatorProperty (string)\n"+
            "* showFilterEditor (boolean)\n"+
            "* canShowFilterEditor (boolean)\n"+
            "* filterEditorHeight (number)\n"+
            "* canEdit (boolean)\n"+
            "* recordEditProperty (string)\n"+
            "* editByCell (boolean)\n"+
            "* saveByCell (boolean)\n"+
            "* validateByCell (boolean)\n"+
            "* validateOnChange (boolean)\n"+
            "* neverValidate (boolean)\n"+
            "* canRemoveRecords (boolean)\n"+
            "* warnOnRemoval (boolean)\n"+
            "* warnOnRemovalMessage (string)\n"+
            "* animateRemoveRecord (boolean)\n"+
            "* animateRemoveTime (number)\n"+
            "* animateRemoveSpeed (number)\n"+
            "* filterByCell (boolean)\n"+
            "* filterOnKeypress (boolean)\n"+
            "* waitForSave (boolean)\n"+
            "* stopOnErrors (boolean)\n"+
            "* autoSaveEdits (boolean)\n"+
            "* confirmCancelEditing (boolean)\n"+
            "* cancelEditingConfirmationMessage (string)\n"+
            "* confirmDiscardEdits (boolean)\n"+
            "* confirmDiscardEditsMessage (string)\n"+
            "* discardEditsSaveButtonTitle (string)\n"+
            "* rowEndEditAction (RowEndEditAction string)\n"+
            "* listEndEditAction (RowEndEditAction string)\n"+
            "* enterKeyEditAction (EnterKeyEditAction string)\n"+
            "* escapeKeyEditAction (EscapeKeyEditAction string)\n"+
            "* editEvent (ListGridEditEvent string)\n"+
            "* editOnFocus (boolean)\n"+
            "* selectOnEdit (boolean)\n"+
            "* longTextEditorThreshold (integer)\n"+
            "* longTextEditorType (string)\n"+
            "* headerHeight (number)\n"+
            "* minFieldWidth (integer)\n"+
            "* showHeader (boolean)\n"+
            "* headerBarStyle (CSSStyleName string)\n"+
            "* headerBackgroundColor (CSSColor string)\n"+
            "* headerButtonConstructor (Class name string)\n"+
            "* headerBaseStyle (CSSStyleName string)\n"+
            "* headerTitleStyle (CSSStyleName string)\n"+
            "* headerButtonDefaults (Button properties object)\n"+
            "* headerButtonProperties (Button properties object)\n"+
            "* wrapHeaderTitles (boolean)\n"+
            "* sorterConstructor (Class name string)\n"+
            "* sorterDefaults (object)\n"+
            "* sorterProperties (Button properties object)\n"+
            "* canSort (boolean)\n"+
            "* sortField (string | integer)\n"+
            "* sortDirection (SortDirection string)\n"+
            "* showSortArrow (SortArrow string)\n"+
            "* canPickFields (boolean)\n"+
            "* canFreezeFields (boolean)\n"+
            "* canAddFormulaFields (boolean)\n"+
            "* canAddSummaryFields (boolean)\n"+
            "* canEditHilites (boolean)\n"+
            "* hilites (array of Hilite objects)\n"+
            "* showHeaderContextMenu (boolean)\n"+
            "* showHeaderMenuButton (boolean)\n"+
            "* headerMenuButtonIconWidth (number)\n"+
            "* headerMenuButtonIconHeight (number)\n"+
            "* headerMenuButtonWidth (number)\n"+
            "* headerMenuButtonHeight (number | string)\n"+
            "* canReorderFields (boolean)\n"+
            "* canResizeFields (boolean)\n"+
            "* dragTrackerMode (DragTrackerMode string)\n"+
            "* resizeFieldsInRealTime (boolean)\n"+
            "* skinImgDir (SCImgURL string)\n"+
            "* sortAscendingImage (SCImgURL string | ImgHTML properties object)\n"+
            "* sortDescendingImage (SCImgURL string | ImgHTML properties object)\n"+
            "* trackerImage (SCImgURL string | ImgHTML properties object)\n"+
            "* booleanTrueImage (SCImgURL string)\n"+
            "* booleanFalseImage (SCImgURL string)\n"+
            "* booleanImageWidth (number)\n"+
            "* booleanImageHeight (number)\n"+
            "* canExpandRecords (boolean)\n"+
            "* canExpandMultipleRecords (boolean)\n"+
            "* detailField (string)\n"+
            "* expansionMode (ExpansionMode string)\n"+
            "* expansionScreen (string)\n"+
            "* detailDS (string)\n"+
            "* viewState (ListGridViewState string)\n"+
            "* autoPersistViewState (array of ListGridViewStatePart string)\n"+
            "* gridComponents (array of ListGridComponent string | array of Any)\n"+
            "* autoFitHeaderHeights (boolean)\n"+
            "* applyFormulaAfterSummary (boolean)\n"+
            "* printHeaderStyle (CSSStyleName string)\n"+
            "* showHoverComponents (boolean)\n"+
            "* hoverMode (HoverMode string)\n"+
            "* hoverScreen (string)\n"+
            "* showGridSummary (boolean)\n"+
            "* hideEmptySummaryRow (boolean)\n"+
            "* allowFilterExpressions (boolean)\n"+
            "* updateSummariesDuringEditing (boolean)\n"+
            "* freezeFieldText (HTML string)\n"+
            "* unfreezeFieldText (HTML string)\n"+
            "* groupByText (HTML string)\n"+
            "* allowFilterWindow (boolean)\n"+
            "* showFilterWindowCriteriaIndicator (boolean)\n"+
            "* searchForm (DynamicForm | ValuesManager)\n"+
            "* showFilterEditorHovers (boolean)\n"+
            "* initialSort (array of SortSpecifier objects)\n"+
            "* showSortNumerals (boolean)\n"+
            "* recordScreen (string)\n"+
            "* showGroupSummary (boolean)\n"+
            "* useAdvancedFieldPicker (boolean)\n"+
            "* advancedFieldPickerThreshold (integer)\n"+
            "\n"+
            "### Methods\n"+
            "* exportData()\n"+
            "* fetchRelatedData()\n"+
            "* removeSelectedData()\n"+
            "* recordClick()\n"+
            "* startEditing()\n"+
            "* removeRecordClick()\n"+
            "* selectionUpdated()\n"+
            "\n"+
            "## Inherited from Canvas\n"+
            "\n"+
            "### Attributes\n"+
            "* ID (GlobalId string)\n"+
            "* autoDraw (boolean)\n"+
            "* htmlElement (DOMElement object | string)\n"+
            "* htmlPosition (DrawPosition string)\n"+
            "* matchElement (boolean)\n"+
            "* position (Positioning string)\n"+
            "* left (number | string)\n"+
            "* top (number | string)\n"+
            "* width (number | string)\n"+
            "* height (number | string)\n"+
            "* defaultWidth (integer)\n"+
            "* defaultHeight (integer)\n"+
            "* minWidth (number)\n"+
            "* maxWidth (number)\n"+
            "* maxHeight (number)\n"+
            "* autoShowParent (boolean)\n"+
            "* visibility (Visibility string)\n"+
            "* canSelectText (boolean)\n"+
            "* contents (HTML string)\n"+
            "* dynamicContents (boolean)\n"+
            "* dynamicContentsVars (ValueMap object)\n"+
            "* margin (number)\n"+
            "* padding (number)\n"+
            "* border (string)\n"+
            "* backgroundColor (CSSColor string)\n"+
            "* backgroundImage (SCImgURL string)\n"+
            "* backgroundRepeat (BackgroundRepeat string)\n"+
            "* appImgDir (URL string)\n"+
            "* cursor (Cursor string)\n"+
            "* disabledCursor (Cursor string)\n"+
            "* opacity (number)\n"+
            "* showCustomScrollbars (boolean)\n"+
            "* scrollbarSize (number)\n"+
            "* disabled (boolean)\n"+
            "* visibleWhen (AdvancedCriteria object)\n"+
            "* enableWhen (AdvancedCriteria object)\n"+
            "* redrawOnResize (boolean)\n"+
            "* canFocus (boolean)\n"+
            "* tabIndex (number)\n"+
            "* accessKey (string)\n"+
            "* contextMenu (Menu)\n"+
            "* prompt (HTML string)\n"+
            "* canDrag (boolean)\n"+
            "* dragStartDistance (number)\n"+
            "* canDragScroll (boolean)\n"+
            "* dragScrollDelay (number)\n"+
            "* dragIntersectStyle (DragIntersectStyle string)\n"+
            "* canDragReposition (boolean)\n"+
            "* dragRepositionCursor (Cursor string)\n"+
            "* canDragResize (boolean)\n"+
            "* resizeFrom (array of EdgeName string)\n"+
            "* hoverDelay (number)\n"+
            "* hoverWidth (integer)\n"+
            "* hoverHeight (integer)\n"+
            "* hoverAlign (Alignment string)\n"+
            "* hoverVAlign (VerticalAlignment string)\n"+
            "* hoverWrap (boolean)\n"+
            "* hoverOpacity (number)\n"+
            "* hoverMoveWithMouse (boolean)\n"+
            "* edgeMarginSize (number)\n"+
            "* edgeCursorMap (object)\n"+
            "* keepInParentRect (boolean | array of integer)\n"+
            "* dragAppearance (DragAppearance string)\n"+
            "* dragType (string)\n"+
            "* dropTypes (array of string | string)\n"+
            "* dragTarget (Canvas | string)\n"+
            "* showDragShadow (boolean)\n"+
            "* dragOpacity (integer)\n"+
            "* canDrop (boolean)\n"+
            "* canAcceptDrop (boolean)\n"+
            "* canDropBefore (boolean)\n"+
            "* mouseStillDownInitialDelay (integer)\n"+
            "* mouseStillDownDelay (integer)\n"+
            "* doubleClickDelay (integer)\n"+
            "* noDoubleClicks (boolean)\n"+
            "* snapTo (string)\n"+
            "* snapOffsetLeft (integer)\n"+
            "* snapOffsetTop (integer)\n"+
            "* snapToGrid (boolean)\n"+
            "* snapResizeToGrid (boolean)\n"+
            "* childrenSnapToGrid (boolean)\n"+
            "* childrenSnapResizeToGrid (boolean)\n"+
            "* snapHGap (number)\n"+
            "* snapVGap (number)\n"+
            "* snapOnDrop (boolean)\n"+
            "* showPointer (boolean)\n"+
            "* pointerTarget (AutoTestLocator string | GlobalId string)\n"+
            "* pointerSettings (PointerSettings object)\n"+
            "* workflows (array of Process)\n"+
            "* borderRadius (string)\n"+
            "* showEdges (boolean)\n"+
            "* edgeSize (number)\n"+
            "* edgeOffset (number)\n"+
            "* edgeImage (SCImgURL string)\n"+
            "* customEdges (array of string)\n"+
            "* edgeBackgroundColor (CSSColor string)\n"+
            "* edgeOpacity (integer)\n"+
            "* edgeShowCenter (boolean)\n"+
            "* edgeCenterBackgroundColor (CSSColor string)\n"+
            "* showShadow (boolean)\n"+
            "* shadowDepth (number)\n"+
            "* shadowOffset (number)\n"+
            "* shadowSoftness (number)\n"+
            "* shadowImage (SCImgURL string)\n"+
            "* isGroup (boolean)\n"+
            "* groupTitle (HTML string)\n"+
            "* testDataContext (DataContext object)\n"+
            "* autoPopulateData (boolean)\n"+
            "* ruleScope (string)\n"+
            "* isRuleScope (boolean)\n"+
            "* valuesManager (ValuesManager | GlobalId string)\n"+
            "* dataPath (DataPath string)\n"+
            "* animateTime (number)\n"+
            "* animateAcceleration (AnimationAcceleration string)\n"+
            "* animateMoveTime (number)\n"+
            "* animateResizeTime (number)\n"+
            "* animateRectTime (number)\n"+
            "* animateFadeTime (number)\n"+
            "* animateScrollTime (number)\n"+
            "* animateShowTime (number)\n"+
            "* animateHideTime (number)\n"+
            "* animateMoveAcceleration (AnimationAcceleration string)\n"+
            "* animateResizeAcceleration (AnimationAcceleration string)\n"+
            "* animateRectAcceleration (AnimationAcceleration string)\n"+
            "* animateScrollAcceleration (AnimationAcceleration string)\n"+
            "* animateShowAcceleration (AnimationAcceleration string)\n"+
            "* animateHideAcceleration (AnimationAcceleration string)\n"+
            "* layoutAlign (Alignment string | VerticalAlignment string)\n"+
            "* showResizeBar (boolean)\n"+
            "* resizeBarTarget (string)\n"+
            "* extraSpace (positive integer)\n"+
            "\n"+
            "### Methods\n"+
            "* showNextTo()\n"+
            "* show()\n"+
            "* hide()\n"+
            "* print()\n",
        format:"Markdown"
    },
    "APIs list:Tree":{
        topic:"APIs list for Tree",
        content:"Only the following APIs are available on Tree:\n"+
            "\n"+
            "## Attributes\n"+
            "* modelType (TreeModelType string)\n"+
            "* isFolderProperty (string)\n"+
            "* defaultIsFolder (boolean)\n"+
            "* reportCollisions (boolean)\n"+
            "* pathDelim (string)\n"+
            "* nameProperty (string)\n"+
            "* titleProperty (string)\n"+
            "* idField (string)\n"+
            "* parentIdField (string)\n"+
            "* childrenProperty (string)\n"+
            "* openProperty (string)\n"+
            "* data (array of TreeNode objects)\n"+
            "* rootValue (string | number)\n"+
            "* root (TreeNode object)\n"+
            "* discardParentlessNodes (boolean)\n"+
            "* showRoot (boolean)\n"+
            "* autoOpenRoot (boolean)\n"+
            "* separateFolders (boolean)\n"+
            "* defaultNodeTitle (string)\n",
        format:"Markdown"
    },
    "APIs list:TreeNode":{
        topic:"APIs list for TreeNode",
        content:"Only the following APIs are available on TreeNode:\n"+
            "\n"+
            "## Attributes\n"+
            "* enabled (boolean)\n"+
            "* canDrag (boolean)\n"+
            "* canAcceptDrop (boolean)\n"+
            "* isFolder (boolean | string)\n"+
            "* name (string)\n"+
            "* title (HTML string)\n"+
            "* id (string | number)\n"+
            "* parentId (string | number)\n"+
            "* children (array of TreeNode objects)\n",
        format:"Markdown"
    },
    "APIs list:ListGrid":{
        topic:"APIs list for ListGrid",
        content:"Only the following APIs are available on ListGrid:\n"+
            "\n"+
            "## Attributes\n"+
            "* autoFetchData (boolean)\n"+
            "* fetchRequestProperties (DSRequest properties object)\n"+
            "* initialCriteria (Criteria object)\n"+
            "* implicitCriteria (Criteria object)\n"+
            "* styleName (CSSStyleName string)\n"+
            "* data (array of ListGridRecord objects)\n"+
            "* fields (array of ListGridField objects)\n"+
            "* dataSource (DataSource | ID string)\n"+
            "* dataArity (string)\n"+
            "* autoFetchDisplayMap (boolean)\n"+
            "* saveLocally (boolean)\n"+
            "* useAllDataSourceFields (boolean)\n"+
            "* showDetailFields (boolean)\n"+
            "* titleField (string)\n"+
            "* dataProperties (ResultSet)\n"+
            "* saveDefaultSearch (boolean)\n"+
            "* canSaveSearches (boolean)\n"+
            "* savedSearchStoredState (SavedSearchStoredState string)\n"+
            "* noSavedSearchesText (HTML string)\n"+
            "* savedSearchText (HTML string)\n"+
            "* newSearchText (HTML string)\n"+
            "* savedSearchAdminSeparator (ListGridRecord properties object)\n"+
            "* savedSearchDS (string)\n"+
            "* savedSearchAdminRole (string)\n"+
            "* groupStartOpen (GroupStartOpen string | array)\n"+
            "* groupTitleColumnProperties (ListGridField properties object)\n"+
            "* groupIconSize (number)\n"+
            "* groupIndentSize (number)\n"+
            "* canGroupBy (boolean)\n"+
            "* groupByMaxRecords (integer)\n"+
            "* groupByField (string | array of string)\n"+
            "* valueIconSize (number)\n"+
            "* valueIconWidth (number)\n"+
            "* valueIconHeight (number)\n"+
            "* valueIconLeftPadding (number)\n"+
            "* valueIconRightPadding (number)\n"+
            "* hiliteIcons (array of string)\n"+
            "* hiliteIconPosition (HiliteIconPosition string)\n"+
            "* hiliteIconSize (number)\n"+
            "* hiliteIconWidth (number)\n"+
            "* hiliteIconHeight (number)\n"+
            "* hiliteIconLeftPadding (number)\n"+
            "* hiliteIconRightPadding (number)\n"+
            "* imageSize (number)\n"+
            "* headerSpans (array of HeaderSpan objects)\n"+
            "* headerSpanHeight (integer)\n"+
            "* showTreeColumnPicker (boolean)\n"+
            "* modalEditing (boolean)\n"+
            "* fetchDelay (number)\n"+
            "* overflow (Overflow string)\n"+
            "* minHeight (number)\n"+
            "* showAllRecords (boolean)\n"+
            "* drawAheadRatio (number)\n"+
            "* scrollRedrawDelay (integer)\n"+
            "* dataPageSize (integer)\n"+
            "* bodyOverflow (Overflow string)\n"+
            "* bodyBackgroundColor (string)\n"+
            "* bodyStyleName (CSSStyleName string)\n"+
            "* emptyCellValue (HTML string)\n"+
            "* cellHeight (number)\n"+
            "* fixedRecordHeights (boolean)\n"+
            "* fixedFieldWidths (boolean)\n"+
            "* autoFitData (Autofit string)\n"+
            "* autoFitMaxHeight (integer)\n"+
            "* autoFitMaxRecords (integer)\n"+
            "* autoFitMaxWidth (integer | string)\n"+
            "* autoFitMaxColumns (integer)\n"+
            "* autoFitFieldWidths (boolean)\n"+
            "* autoFitWidthApproach (AutoFitWidthApproach string)\n"+
            "* leaveScrollbarGap (boolean)\n"+
            "* wrapCells (boolean)\n"+
            "* cellPadding (number)\n"+
            "* dateFormatter (DateDisplayFormat string)\n"+
            "* dateInputFormat (DateInputFormat string)\n"+
            "* timeFormatter (TimeDisplayFormat string)\n"+
            "* fastCellUpdates (boolean)\n"+
            "* baseStyle (CSSStyleName string)\n"+
            "* editFailedBaseStyle (CSSStyleName string)\n"+
            "* editFailedCSSText (string)\n"+
            "* editPendingCSSText (string)\n"+
            "* recordCustomStyleProperty (string)\n"+
            "* recordBaseStyleProperty (string)\n"+
            "* shrinkForFreeze (boolean)\n"+
            "* alternateRecordStyles (boolean)\n"+
            "* alternateRecordFrequency (number)\n"+
            "* generateClickOnSpace (boolean)\n"+
            "* generateClickOnEnter (boolean)\n"+
            "* generateDoubleClickOnSpace (boolean)\n"+
            "* generateDoubleClickOnEnter (boolean)\n"+
            "* arrowKeyAction (string)\n"+
            "* showRecordComponents (boolean)\n"+
            "* recordComponentPosition (EmbeddedPosition string)\n"+
            "* showRollOver (boolean)\n"+
            "* canHover (boolean)\n"+
            "* showHover (boolean)\n"+
            "* hoverStyle (CSSStyleName string)\n"+
            "* selectionAppearance (SelectionAppearance string)\n"+
            "* selectionType (SelectionStyle string)\n"+
            "* selectionProperty (string)\n"+
            "* canDragSelect (boolean)\n"+
            "* checkboxFieldImageWidth (integer)\n"+
            "* checkboxFieldImageHeight (integer)\n"+
            "* showEmptyMessage (boolean)\n"+
            "* emptyMessage (HTML string)\n"+
            "* emptyMessageStyle (CSSStyleName string)\n"+
            "* loadingDataMessage (HTML string)\n"+
            "* loadingDataMessageStyle (CSSStyleName string)\n"+
            "* loadingMessage (string)\n"+
            "* singleCellValueProperty (string)\n"+
            "* isSeparatorProperty (string)\n"+
            "* showFilterEditor (boolean)\n"+
            "* canShowFilterEditor (boolean)\n"+
            "* filterEditorHeight (number)\n"+
            "* autoFetchTextMatchStyle (TextMatchStyle string)\n"+
            "* canEdit (boolean)\n"+
            "* recordEditProperty (string)\n"+
            "* editByCell (boolean)\n"+
            "* saveByCell (boolean)\n"+
            "* validateByCell (boolean)\n"+
            "* validateOnChange (boolean)\n"+
            "* neverValidate (boolean)\n"+
            "* canRemoveRecords (boolean)\n"+
            "* warnOnRemoval (boolean)\n"+
            "* warnOnRemovalMessage (string)\n"+
            "* animateRemoveRecord (boolean)\n"+
            "* animateRemoveTime (number)\n"+
            "* animateRemoveSpeed (number)\n"+
            "* filterByCell (boolean)\n"+
            "* filterOnKeypress (boolean)\n"+
            "* waitForSave (boolean)\n"+
            "* stopOnErrors (boolean)\n"+
            "* autoSaveEdits (boolean)\n"+
            "* confirmCancelEditing (boolean)\n"+
            "* cancelEditingConfirmationMessage (string)\n"+
            "* confirmDiscardEdits (boolean)\n"+
            "* confirmDiscardEditsMessage (string)\n"+
            "* discardEditsSaveButtonTitle (string)\n"+
            "* rowEndEditAction (RowEndEditAction string)\n"+
            "* listEndEditAction (RowEndEditAction string)\n"+
            "* enterKeyEditAction (EnterKeyEditAction string)\n"+
            "* escapeKeyEditAction (EscapeKeyEditAction string)\n"+
            "* editEvent (ListGridEditEvent string)\n"+
            "* editOnFocus (boolean)\n"+
            "* selectOnEdit (boolean)\n"+
            "* longTextEditorThreshold (integer)\n"+
            "* longTextEditorType (string)\n"+
            "* headerHeight (number)\n"+
            "* minFieldWidth (integer)\n"+
            "* showHeader (boolean)\n"+
            "* headerBarStyle (CSSStyleName string)\n"+
            "* headerBackgroundColor (CSSColor string)\n"+
            "* headerButtonConstructor (Class name string)\n"+
            "* headerBaseStyle (CSSStyleName string)\n"+
            "* headerTitleStyle (CSSStyleName string)\n"+
            "* headerButtonDefaults (Button properties object)\n"+
            "* headerButtonProperties (Button properties object)\n"+
            "* wrapHeaderTitles (boolean)\n"+
            "* sorterConstructor (Class name string)\n"+
            "* sorterDefaults (object)\n"+
            "* sorterProperties (Button properties object)\n"+
            "* canSort (boolean)\n"+
            "* sortField (string | integer)\n"+
            "* sortDirection (SortDirection string)\n"+
            "* showSortArrow (SortArrow string)\n"+
            "* canPickFields (boolean)\n"+
            "* canFreezeFields (boolean)\n"+
            "* canAddFormulaFields (boolean)\n"+
            "* canAddSummaryFields (boolean)\n"+
            "* canEditHilites (boolean)\n"+
            "* hilites (array of Hilite objects)\n"+
            "* showHeaderContextMenu (boolean)\n"+
            "* showHeaderMenuButton (boolean)\n"+
            "* headerMenuButtonIconWidth (number)\n"+
            "* headerMenuButtonIconHeight (number)\n"+
            "* headerMenuButtonWidth (number)\n"+
            "* headerMenuButtonHeight (number | string)\n"+
            "* canDragRecordsOut (boolean)\n"+
            "* canAcceptDroppedRecords (boolean)\n"+
            "* canReorderRecords (boolean)\n"+
            "* canReorderFields (boolean)\n"+
            "* canResizeFields (boolean)\n"+
            "* dragTrackerMode (DragTrackerMode string)\n"+
            "* resizeFieldsInRealTime (boolean)\n"+
            "* dragDataAction (DragDataAction string)\n"+
            "* skinImgDir (SCImgURL string)\n"+
            "* sortAscendingImage (SCImgURL string | ImgHTML properties object)\n"+
            "* sortDescendingImage (SCImgURL string | ImgHTML properties object)\n"+
            "* trackerImage (SCImgURL string | ImgHTML properties object)\n"+
            "* booleanTrueImage (SCImgURL string)\n"+
            "* booleanFalseImage (SCImgURL string)\n"+
            "* booleanImageWidth (number)\n"+
            "* booleanImageHeight (number)\n"+
            "* canExpandRecords (boolean)\n"+
            "* canExpandMultipleRecords (boolean)\n"+
            "* detailField (string)\n"+
            "* expansionMode (ExpansionMode string)\n"+
            "* expansionScreen (string)\n"+
            "* detailDS (string)\n"+
            "* viewState (ListGridViewState string)\n"+
            "* autoPersistViewState (array of ListGridViewStatePart string)\n"+
            "* gridComponents (array of ListGridComponent string | array of Any)\n"+
            "* autoFitHeaderHeights (boolean)\n"+
            "* applyFormulaAfterSummary (boolean)\n"+
            "* printHeaderStyle (CSSStyleName string)\n"+
            "* showHoverComponents (boolean)\n"+
            "* hoverMode (HoverMode string)\n"+
            "* hoverScreen (string)\n"+
            "* showGridSummary (boolean)\n"+
            "* hideEmptySummaryRow (boolean)\n"+
            "* allowFilterExpressions (boolean)\n"+
            "* updateSummariesDuringEditing (boolean)\n"+
            "* freezeFieldText (HTML string)\n"+
            "* unfreezeFieldText (HTML string)\n"+
            "* groupByText (HTML string)\n"+
            "* allowFilterWindow (boolean)\n"+
            "* showFilterWindowCriteriaIndicator (boolean)\n"+
            "* searchForm (DynamicForm | ValuesManager)\n"+
            "* showFilterEditorHovers (boolean)\n"+
            "* initialSort (array of SortSpecifier objects)\n"+
            "* showSortNumerals (boolean)\n"+
            "* recordScreen (string)\n"+
            "* showGroupSummary (boolean)\n"+
            "* useAdvancedFieldPicker (boolean)\n"+
            "* advancedFieldPickerThreshold (integer)\n"+
            "\n"+
            "## Methods\n"+
            "* fetchData()\n"+
            "* exportData()\n"+
            "* filterData()\n"+
            "* fetchRelatedData()\n"+
            "* removeSelectedData()\n"+
            "* exportClientData()\n"+
            "* recordClick()\n"+
            "* recordDoubleClick()\n"+
            "* startEditing()\n"+
            "* startEditingNew()\n"+
            "* removeRecordClick()\n"+
            "* selectionUpdated()\n"+
            "\n"+
            "## Inherited from Canvas\n"+
            "\n"+
            "### Attributes\n"+
            "* ID (GlobalId string)\n"+
            "* autoDraw (boolean)\n"+
            "* htmlElement (DOMElement object | string)\n"+
            "* htmlPosition (DrawPosition string)\n"+
            "* matchElement (boolean)\n"+
            "* position (Positioning string)\n"+
            "* left (number | string)\n"+
            "* top (number | string)\n"+
            "* width (number | string)\n"+
            "* height (number | string)\n"+
            "* defaultWidth (integer)\n"+
            "* defaultHeight (integer)\n"+
            "* minWidth (number)\n"+
            "* maxWidth (number)\n"+
            "* maxHeight (number)\n"+
            "* autoShowParent (boolean)\n"+
            "* visibility (Visibility string)\n"+
            "* canSelectText (boolean)\n"+
            "* contents (HTML string)\n"+
            "* dynamicContents (boolean)\n"+
            "* dynamicContentsVars (ValueMap object)\n"+
            "* margin (number)\n"+
            "* padding (number)\n"+
            "* border (string)\n"+
            "* backgroundColor (CSSColor string)\n"+
            "* backgroundImage (SCImgURL string)\n"+
            "* backgroundRepeat (BackgroundRepeat string)\n"+
            "* appImgDir (URL string)\n"+
            "* cursor (Cursor string)\n"+
            "* disabledCursor (Cursor string)\n"+
            "* opacity (number)\n"+
            "* showCustomScrollbars (boolean)\n"+
            "* scrollbarSize (number)\n"+
            "* disabled (boolean)\n"+
            "* visibleWhen (AdvancedCriteria object)\n"+
            "* enableWhen (AdvancedCriteria object)\n"+
            "* redrawOnResize (boolean)\n"+
            "* canFocus (boolean)\n"+
            "* tabIndex (number)\n"+
            "* accessKey (string)\n"+
            "* contextMenu (Menu)\n"+
            "* prompt (HTML string)\n"+
            "* canDrag (boolean)\n"+
            "* dragStartDistance (number)\n"+
            "* canDragScroll (boolean)\n"+
            "* dragScrollDelay (number)\n"+
            "* dragIntersectStyle (DragIntersectStyle string)\n"+
            "* canDragReposition (boolean)\n"+
            "* dragRepositionCursor (Cursor string)\n"+
            "* canDragResize (boolean)\n"+
            "* resizeFrom (array of EdgeName string)\n"+
            "* hoverDelay (number)\n"+
            "* hoverWidth (integer)\n"+
            "* hoverHeight (integer)\n"+
            "* hoverAlign (Alignment string)\n"+
            "* hoverVAlign (VerticalAlignment string)\n"+
            "* hoverWrap (boolean)\n"+
            "* hoverOpacity (number)\n"+
            "* hoverMoveWithMouse (boolean)\n"+
            "* edgeMarginSize (number)\n"+
            "* edgeCursorMap (object)\n"+
            "* keepInParentRect (boolean | array of integer)\n"+
            "* dragAppearance (DragAppearance string)\n"+
            "* dragType (string)\n"+
            "* dropTypes (array of string | string)\n"+
            "* dragTarget (Canvas | string)\n"+
            "* showDragShadow (boolean)\n"+
            "* dragOpacity (integer)\n"+
            "* canDrop (boolean)\n"+
            "* canAcceptDrop (boolean)\n"+
            "* canDropBefore (boolean)\n"+
            "* mouseStillDownInitialDelay (integer)\n"+
            "* mouseStillDownDelay (integer)\n"+
            "* doubleClickDelay (integer)\n"+
            "* noDoubleClicks (boolean)\n"+
            "* snapTo (string)\n"+
            "* snapOffsetLeft (integer)\n"+
            "* snapOffsetTop (integer)\n"+
            "* snapToGrid (boolean)\n"+
            "* snapResizeToGrid (boolean)\n"+
            "* childrenSnapToGrid (boolean)\n"+
            "* childrenSnapResizeToGrid (boolean)\n"+
            "* snapHGap (number)\n"+
            "* snapVGap (number)\n"+
            "* snapOnDrop (boolean)\n"+
            "* showPointer (boolean)\n"+
            "* pointerTarget (AutoTestLocator string | GlobalId string)\n"+
            "* pointerSettings (PointerSettings object)\n"+
            "* workflows (array of Process)\n"+
            "* borderRadius (string)\n"+
            "* showEdges (boolean)\n"+
            "* edgeSize (number)\n"+
            "* edgeOffset (number)\n"+
            "* edgeImage (SCImgURL string)\n"+
            "* customEdges (array of string)\n"+
            "* edgeBackgroundColor (CSSColor string)\n"+
            "* edgeOpacity (integer)\n"+
            "* edgeShowCenter (boolean)\n"+
            "* edgeCenterBackgroundColor (CSSColor string)\n"+
            "* showShadow (boolean)\n"+
            "* shadowDepth (number)\n"+
            "* shadowOffset (number)\n"+
            "* shadowSoftness (number)\n"+
            "* shadowImage (SCImgURL string)\n"+
            "* isGroup (boolean)\n"+
            "* groupTitle (HTML string)\n"+
            "* testDataContext (DataContext object)\n"+
            "* autoPopulateData (boolean)\n"+
            "* ruleScope (string)\n"+
            "* isRuleScope (boolean)\n"+
            "* valuesManager (ValuesManager | GlobalId string)\n"+
            "* dataPath (DataPath string)\n"+
            "* animateTime (number)\n"+
            "* animateAcceleration (AnimationAcceleration string)\n"+
            "* animateMoveTime (number)\n"+
            "* animateResizeTime (number)\n"+
            "* animateRectTime (number)\n"+
            "* animateFadeTime (number)\n"+
            "* animateScrollTime (number)\n"+
            "* animateShowTime (number)\n"+
            "* animateHideTime (number)\n"+
            "* animateMoveAcceleration (AnimationAcceleration string)\n"+
            "* animateResizeAcceleration (AnimationAcceleration string)\n"+
            "* animateRectAcceleration (AnimationAcceleration string)\n"+
            "* animateScrollAcceleration (AnimationAcceleration string)\n"+
            "* animateShowAcceleration (AnimationAcceleration string)\n"+
            "* animateHideAcceleration (AnimationAcceleration string)\n"+
            "* layoutAlign (Alignment string | VerticalAlignment string)\n"+
            "* showResizeBar (boolean)\n"+
            "* resizeBarTarget (string)\n"+
            "* extraSpace (positive integer)\n"+
            "\n"+
            "### Methods\n"+
            "* showNextTo()\n"+
            "* show()\n"+
            "* hide()\n"+
            "* print()\n",
        format:"Markdown"
    },
    "APIs list:ListGridField":{
        topic:"APIs list for ListGridField",
        content:"Only the following APIs are available on ListGridField:\n"+
            "\n"+
            "## Attributes\n"+
            "* groupingModes (ValueMap object)\n"+
            "* groupPrecision (integer)\n"+
            "* groupGranularity (integer)\n"+
            "* canGroupBy (boolean)\n"+
            "* canSortClientOnly (boolean)\n"+
            "* canExport (boolean)\n"+
            "* summaryValue (HTML string)\n"+
            "* valueIcons (object)\n"+
            "* valueIconSize (number)\n"+
            "* valueIconWidth (number)\n"+
            "* valueIconHeight (number)\n"+
            "* valueIconLeftPadding (number)\n"+
            "* valueIconRightPadding (number)\n"+
            "* editorValueIcons (object)\n"+
            "* editorValueIconWidth (number)\n"+
            "* editorValueIconHeight (number)\n"+
            "* showValueIconOnly (boolean)\n"+
            "* suppressValueIcon (boolean)\n"+
            "* valueIconOrientation (string)\n"+
            "* hiliteIconPosition (HiliteIconPosition string)\n"+
            "* hiliteIconSize (number)\n"+
            "* hiliteIconWidth (number)\n"+
            "* hiliteIconHeight (number)\n"+
            "* hiliteIconLeftPadding (number)\n"+
            "* hiliteIconRightPadding (number)\n"+
            "* imageURLPrefix (string)\n"+
            "* imageURLSuffix (string)\n"+
            "* editorImageURLPrefix (string)\n"+
            "* editorImageURLSuffix (string)\n"+
            "* imageSize (number)\n"+
            "* imageWidth (number)\n"+
            "* imageHeight (number)\n"+
            "* type (ListGridFieldType string)\n"+
            "* name (FieldName string)\n"+
            "* title (HTML string)\n"+
            "* showTitle (boolean)\n"+
            "* wrap (boolean)\n"+
            "* cellPrompt (HTML string)\n"+
            "* hidden (boolean)\n"+
            "* visibleWhen (Criteria object)\n"+
            "* enableWhen (Criteria object)\n"+
            "* frozen (boolean)\n"+
            "* showGridSummary (boolean)\n"+
            "* showGroupSummary (boolean)\n"+
            "* summaryFunction (SummaryFunction string | array of SummaryFunction string)\n"+
            "* applyAfterSummary (boolean)\n"+
            "* icon (SCImgURL string)\n"+
            "* iconSize (integer)\n"+
            "* iconWidth (integer)\n"+
            "* iconHeight (integer)\n"+
            "* iconOrientation (string)\n"+
            "* iconSpacing (integer)\n"+
            "* showDisabledIcon (boolean)\n"+
            "* showRollOverIcon (boolean)\n"+
            "* showFocusedIcon (boolean)\n"+
            "* showDownIcon (boolean)\n"+
            "* showSelectedIcon (boolean)\n"+
            "* cellIcon (SCImgURL string)\n"+
            "* format (FormatString string)\n"+
            "* exportFormat (FormatString string)\n"+
            "* icons (array of FormItemIcon properties objects)\n"+
            "* editorIconWidth (number)\n"+
            "* editorIconHeight (number)\n"+
            "* defaultIconSrc (string)\n"+
            "* iconVAlign (string)\n"+
            "* width (number | string)\n"+
            "* minWidth (number)\n"+
            "* maxWidth (number)\n"+
            "* align (Alignment string)\n"+
            "* headerBaseStyle (CSSStyleName string)\n"+
            "* headerTitleStyle (CSSStyleName string)\n"+
            "* cellAlign (Alignment string)\n"+
            "* baseStyle (CSSStyleName string)\n"+
            "* canSort (boolean)\n"+
            "* sortDirection (SortDirection string)\n"+
            "* canEdit (boolean)\n"+
            "* defaultValue (Any)\n"+
            "* enterKeyEditAction (EnterKeyEditAction string)\n"+
            "* escapeKeyEditAction (EscapeKeyEditAction string)\n"+
            "* editorType (FormItemClassName string)\n"+
            "* editorProperties (FormItem properties object)\n"+
            "* initialValue (Any)\n"+
            "* validateOnChange (boolean)\n"+
            "* required (boolean)\n"+
            "* decimalPrecision (number)\n"+
            "* inputFormat (DateInputFormat string)\n"+
            "* canFilter (boolean)\n"+
            "* filterEditorValueMap (object)\n"+
            "* filterEditorType (FormItemClassName string)\n"+
            "* defaultFilterValue (Any)\n"+
            "* filterEditorProperties (FormItem properties object)\n"+
            "* filterOnKeypress (boolean)\n"+
            "* escapeHTML (boolean)\n"+
            "* linkText (string)\n"+
            "* valueMap (object | array of string)\n"+
            "* sortByMappedValue (boolean)\n"+
            "* multiple (boolean)\n"+
            "* editorValueMap (ValueMap object)\n"+
            "* emptyCellValue (HTML string)\n"+
            "* autoFetchDisplayMap (boolean)\n"+
            "* optionDataSource (string)\n"+
            "* valueField (string)\n"+
            "* displayField (FieldName string)\n"+
            "* sortByDisplayField (boolean)\n"+
            "* optionCriteria (Criteria object)\n"+
            "* includeFrom (string)\n"+
            "* canAutoFitWidth (boolean)\n"+
            "* autoFit (AutoFitWidthApproach string)\n"+
            "* autoFitWidth (boolean)\n"+
            "* autoFitWidthApproach (AutoFitWidthApproach string)\n"+
            "* showHover (boolean)\n"+
            "* showHoverComponents (boolean)\n"+
            "* canToggle (boolean)\n"+
            "* hideOnPhone (boolean)\n"+
            "* hideOnTablet (boolean)\n"+
            "* userFormula (UserFormula object)\n"+
            "* canEditFormula (boolean)\n"+
            "* editorFormula (UserFormula object)\n"+
            "* editorTextFormula (UserSummary object)\n"+
            "* userSummary (UserSummary object)\n"+
            "* canEditSummary (boolean)\n"+
            "\n"+
            "## Methods\n"+
            "* valueIconClick()\n"+
            "* editorEnter()\n"+
            "* editorExit()\n"+
            "* recordClick()\n"+
            "* recordDoubleClick()\n"+
            "* changed()\n"+
            "\n"+
            "## Inherited from Field\n"+
            "\n"+
            "### Attributes\n"+
            "* primaryKey (boolean)\n"+
            "* exportTitle (HTML string)\n"+
            "* sortByField (FieldName string)\n",
        format:"Markdown"
    },
    "APIs list:DetailViewer":{
        topic:"APIs list for DetailViewer",
        content:"Only the following APIs are available on DetailViewer:\n"+
            "\n"+
            "## Attributes\n"+
            "* fetchRequestProperties (DSRequest properties object)\n"+
            "* initialCriteria (Criteria object)\n"+
            "* implicitCriteria (Criteria object)\n"+
            "* autoFetchData (boolean)\n"+
            "* data (array of DetailViewerRecord objects | array of Record objects | RecordList)\n"+
            "* dataArity (string)\n"+
            "* dataSource (DataSource | ID string)\n"+
            "* fields (array of DetailViewerField objects)\n"+
            "* hiliteIcons (array of string)\n"+
            "* hiliteIconPosition (HiliteIconPosition string)\n"+
            "* hiliteIconSize (number)\n"+
            "* hiliteIconWidth (number)\n"+
            "* hiliteIconHeight (number)\n"+
            "* hiliteIconLeftPadding (number)\n"+
            "* hiliteIconRightPadding (number)\n"+
            "* recordsPerBlock (number)\n"+
            "* blockSeparator (HTML string)\n"+
            "* showEmptyField (boolean)\n"+
            "* emptyCellValue (HTML string)\n"+
            "* labelPrefix (HTML string)\n"+
            "* labelSuffix (HTML string)\n"+
            "* wrapLabel (boolean)\n"+
            "* wrapValues (boolean)\n"+
            "* styleName (CSSStyleName string)\n"+
            "* labelStyle (CSSStyleName string)\n"+
            "* cellStyle (CSSStyleName string)\n"+
            "* headerStyle (CSSStyleName string)\n"+
            "* separatorStyle (CSSStyleName string)\n"+
            "* dateFormatter (DateDisplayFormat string)\n"+
            "* showEmptyMessage (boolean)\n"+
            "* emptyMessage (HTML string)\n"+
            "* emptyMessageStyle (CSSStyleName string)\n"+
            "* loadingMessage (HTML string)\n"+
            "* loadingMessageStyle (CSSStyleName string)\n"+
            "\n"+
            "## Methods\n"+
            "* viewSelectedData()\n"+
            "\n"+
            "## Inherited from Canvas\n"+
            "\n"+
            "### Attributes\n"+
            "* ID (GlobalId string)\n"+
            "* autoDraw (boolean)\n"+
            "* htmlElement (DOMElement object | string)\n"+
            "* htmlPosition (DrawPosition string)\n"+
            "* matchElement (boolean)\n"+
            "* position (Positioning string)\n"+
            "* left (number | string)\n"+
            "* top (number | string)\n"+
            "* width (number | string)\n"+
            "* height (number | string)\n"+
            "* defaultWidth (integer)\n"+
            "* defaultHeight (integer)\n"+
            "* minWidth (number)\n"+
            "* minHeight (number)\n"+
            "* maxWidth (number)\n"+
            "* maxHeight (number)\n"+
            "* autoShowParent (boolean)\n"+
            "* visibility (Visibility string)\n"+
            "* canSelectText (boolean)\n"+
            "* contents (HTML string)\n"+
            "* dynamicContents (boolean)\n"+
            "* dynamicContentsVars (ValueMap object)\n"+
            "* margin (number)\n"+
            "* padding (number)\n"+
            "* border (string)\n"+
            "* backgroundColor (CSSColor string)\n"+
            "* backgroundImage (SCImgURL string)\n"+
            "* backgroundRepeat (BackgroundRepeat string)\n"+
            "* appImgDir (URL string)\n"+
            "* skinImgDir (SCImgURL string)\n"+
            "* cursor (Cursor string)\n"+
            "* disabledCursor (Cursor string)\n"+
            "* opacity (number)\n"+
            "* overflow (Overflow string)\n"+
            "* showCustomScrollbars (boolean)\n"+
            "* scrollbarSize (number)\n"+
            "* disabled (boolean)\n"+
            "* visibleWhen (AdvancedCriteria object)\n"+
            "* enableWhen (AdvancedCriteria object)\n"+
            "* redrawOnResize (boolean)\n"+
            "* canFocus (boolean)\n"+
            "* tabIndex (number)\n"+
            "* accessKey (string)\n"+
            "* contextMenu (Menu)\n"+
            "* prompt (HTML string)\n"+
            "* canDrag (boolean)\n"+
            "* dragStartDistance (number)\n"+
            "* canDragScroll (boolean)\n"+
            "* dragScrollDelay (number)\n"+
            "* dragIntersectStyle (DragIntersectStyle string)\n"+
            "* canDragReposition (boolean)\n"+
            "* dragRepositionCursor (Cursor string)\n"+
            "* canDragResize (boolean)\n"+
            "* resizeFrom (array of EdgeName string)\n"+
            "* canHover (boolean)\n"+
            "* hoverDelay (number)\n"+
            "* showHover (boolean)\n"+
            "* hoverWidth (integer)\n"+
            "* hoverHeight (integer)\n"+
            "* hoverAlign (Alignment string)\n"+
            "* hoverVAlign (VerticalAlignment string)\n"+
            "* hoverWrap (boolean)\n"+
            "* hoverStyle (CSSStyleName string)\n"+
            "* hoverOpacity (number)\n"+
            "* hoverMoveWithMouse (boolean)\n"+
            "* edgeMarginSize (number)\n"+
            "* edgeCursorMap (object)\n"+
            "* keepInParentRect (boolean | array of integer)\n"+
            "* dragAppearance (DragAppearance string)\n"+
            "* dragType (string)\n"+
            "* dropTypes (array of string | string)\n"+
            "* dragTarget (Canvas | string)\n"+
            "* showDragShadow (boolean)\n"+
            "* dragOpacity (integer)\n"+
            "* canDrop (boolean)\n"+
            "* canAcceptDrop (boolean)\n"+
            "* canDropBefore (boolean)\n"+
            "* mouseStillDownInitialDelay (integer)\n"+
            "* mouseStillDownDelay (integer)\n"+
            "* doubleClickDelay (integer)\n"+
            "* noDoubleClicks (boolean)\n"+
            "* snapTo (string)\n"+
            "* snapOffsetLeft (integer)\n"+
            "* snapOffsetTop (integer)\n"+
            "* snapToGrid (boolean)\n"+
            "* snapResizeToGrid (boolean)\n"+
            "* childrenSnapToGrid (boolean)\n"+
            "* childrenSnapResizeToGrid (boolean)\n"+
            "* snapHGap (number)\n"+
            "* snapVGap (number)\n"+
            "* snapOnDrop (boolean)\n"+
            "* showPointer (boolean)\n"+
            "* pointerTarget (AutoTestLocator string | GlobalId string)\n"+
            "* pointerSettings (PointerSettings object)\n"+
            "* workflows (array of Process)\n"+
            "* borderRadius (string)\n"+
            "* showEdges (boolean)\n"+
            "* edgeSize (number)\n"+
            "* edgeOffset (number)\n"+
            "* edgeImage (SCImgURL string)\n"+
            "* customEdges (array of string)\n"+
            "* edgeBackgroundColor (CSSColor string)\n"+
            "* edgeOpacity (integer)\n"+
            "* edgeShowCenter (boolean)\n"+
            "* edgeCenterBackgroundColor (CSSColor string)\n"+
            "* showShadow (boolean)\n"+
            "* shadowDepth (number)\n"+
            "* shadowOffset (number)\n"+
            "* shadowSoftness (number)\n"+
            "* shadowImage (SCImgURL string)\n"+
            "* isGroup (boolean)\n"+
            "* groupTitle (HTML string)\n"+
            "* testDataContext (DataContext object)\n"+
            "* autoPopulateData (boolean)\n"+
            "* ruleScope (string)\n"+
            "* isRuleScope (boolean)\n"+
            "* valuesManager (ValuesManager | GlobalId string)\n"+
            "* dataPath (DataPath string)\n"+
            "* animateTime (number)\n"+
            "* animateAcceleration (AnimationAcceleration string)\n"+
            "* animateMoveTime (number)\n"+
            "* animateResizeTime (number)\n"+
            "* animateRectTime (number)\n"+
            "* animateFadeTime (number)\n"+
            "* animateScrollTime (number)\n"+
            "* animateShowTime (number)\n"+
            "* animateHideTime (number)\n"+
            "* animateMoveAcceleration (AnimationAcceleration string)\n"+
            "* animateResizeAcceleration (AnimationAcceleration string)\n"+
            "* animateRectAcceleration (AnimationAcceleration string)\n"+
            "* animateScrollAcceleration (AnimationAcceleration string)\n"+
            "* animateShowAcceleration (AnimationAcceleration string)\n"+
            "* animateHideAcceleration (AnimationAcceleration string)\n"+
            "* layoutAlign (Alignment string | VerticalAlignment string)\n"+
            "* showResizeBar (boolean)\n"+
            "* resizeBarTarget (string)\n"+
            "* extraSpace (positive integer)\n"+
            "\n"+
            "### Methods\n"+
            "* showNextTo()\n"+
            "* show()\n"+
            "* hide()\n"+
            "* print()\n",
        format:"Markdown"
    },
    "APIs list:DetailViewerField":{
        topic:"APIs list for DetailViewerField",
        content:"Only the following APIs are available on DetailViewerField:\n"+
            "\n"+
            "## Attributes\n"+
            "* name (FieldName string)\n"+
            "* dateFormatter (DateDisplayFormat string)\n"+
            "* decimalPrecision (number)\n"+
            "* decimalPad (number)\n"+
            "* imageSize (integer | string)\n"+
            "* imageWidth (integer | string)\n"+
            "* imageHeight (integer | string)\n"+
            "* linkText (string)\n"+
            "* linkTextProperty (string)\n"+
            "* target (string)\n"+
            "* format (FormatString string)\n"+
            "* canHilite (boolean)\n"+
            "* hiliteIconPosition (HiliteIconPosition string)\n"+
            "* hiliteIconSize (number)\n"+
            "* hiliteIconWidth (number)\n"+
            "* hiliteIconHeight (number)\n"+
            "* hiliteIconLeftPadding (number)\n"+
            "* hiliteIconRightPadding (number)\n"+
            "* type (string)\n"+
            "* title (HTML string)\n"+
            "* valueMap (object)\n"+
            "* value (HTML string)\n"+
            "* height (number)\n"+
            "* cellStyle (CSSStyleName string)\n"+
            "* printCellStyle (CSSStyleName string)\n",
        format:"Markdown"
    },
    "APIs list:TileGrid":{
        topic:"APIs list for TileGrid",
        content:"Only the following APIs are available on TileGrid:\n"+
            "\n"+
            "## Attributes\n"+
            "* fields (array of DetailViewerField objects)\n"+
            "* tiles (array of Canvas)\n"+
            "* showDetailFields (boolean)\n"+
            "* data (array of TileRecord objects | array of Record objects | RecordList)\n"+
            "* dataSource (DataSource | ID string)\n"+
            "* dataArity (string)\n"+
            "* autoFetchData (boolean)\n"+
            "* autoFetchTextMatchStyle (TextMatchStyle string)\n"+
            "* fetchRequestProperties (DSRequest properties object)\n"+
            "* initialCriteria (Criteria object)\n"+
            "* implicitCriteria (Criteria object)\n"+
            "* selectionType (SelectionStyle string)\n"+
            "* detailViewerProperties (DetailViewer properties object)\n"+
            "* showAllRecords (boolean)\n"+
            "* loadingDataMessage (HTML string)\n"+
            "* loadingDataMessageStyle (CSSStyleName string)\n"+
            "* animateTileChange (boolean)\n"+
            "* styleName (CSSStyleName string)\n"+
            "* tileScreen (string)\n"+
            "* canReorderTiles (boolean)\n"+
            "* canDragTilesOut (boolean)\n"+
            "* canAcceptDroppedRecords (boolean)\n"+
            "* dragTrackerStyle (CSSStyleName string)\n"+
            "* dragDataAction (DragDataAction string)\n"+
            "* showEmptyMessage (boolean)\n"+
            "* emptyMessage (HTML string)\n"+
            "* emptyMessageStyle (CSSStyleName string)\n"+
            "\n"+
            "## Methods\n"+
            "* fetchData()\n"+
            "* viewSelectedData()\n"+
            "* recordClick()\n"+
            "\n"+
            "## Inherited from TileLayout\n"+
            "\n"+
            "### Attributes\n"+
            "* layoutPolicy (TileLayoutPolicy string)\n"+
            "* tileSize (integer)\n"+
            "* tileWidth (integer)\n"+
            "* tileHeight (integer)\n"+
            "* tileMargin (integer)\n"+
            "* tileHMargin (integer)\n"+
            "* tileVMargin (integer)\n"+
            "* layoutMargin (integer)\n"+
            "* paddingAsLayoutMargin (boolean)\n"+
            "* orientation (Orientation string)\n"+
            "* tilesPerLine (integer)\n"+
            "* overflow (Overflow string)\n"+
            "* expandMargins (boolean)\n"+
            "* autoWrapLines (boolean)\n"+
            "\n"+
            "## Inherited from Canvas\n"+
            "\n"+
            "### Attributes\n"+
            "* ID (GlobalId string)\n"+
            "* autoDraw (boolean)\n"+
            "* children (array of Canvas)\n"+
            "* peers (array of Canvas)\n"+
            "* htmlElement (DOMElement object | string)\n"+
            "* htmlPosition (DrawPosition string)\n"+
            "* matchElement (boolean)\n"+
            "* position (Positioning string)\n"+
            "* left (number | string)\n"+
            "* top (number | string)\n"+
            "* width (number | string)\n"+
            "* height (number | string)\n"+
            "* defaultWidth (integer)\n"+
            "* defaultHeight (integer)\n"+
            "* minWidth (number)\n"+
            "* minHeight (number)\n"+
            "* maxWidth (number)\n"+
            "* maxHeight (number)\n"+
            "* autoShowParent (boolean)\n"+
            "* visibility (Visibility string)\n"+
            "* canSelectText (boolean)\n"+
            "* contents (HTML string)\n"+
            "* dynamicContents (boolean)\n"+
            "* dynamicContentsVars (ValueMap object)\n"+
            "* margin (number)\n"+
            "* padding (number)\n"+
            "* border (string)\n"+
            "* backgroundColor (CSSColor string)\n"+
            "* backgroundImage (SCImgURL string)\n"+
            "* backgroundRepeat (BackgroundRepeat string)\n"+
            "* appImgDir (URL string)\n"+
            "* skinImgDir (SCImgURL string)\n"+
            "* cursor (Cursor string)\n"+
            "* disabledCursor (Cursor string)\n"+
            "* opacity (number)\n"+
            "* showCustomScrollbars (boolean)\n"+
            "* scrollbarSize (number)\n"+
            "* disabled (boolean)\n"+
            "* visibleWhen (AdvancedCriteria object)\n"+
            "* enableWhen (AdvancedCriteria object)\n"+
            "* redrawOnResize (boolean)\n"+
            "* canFocus (boolean)\n"+
            "* tabIndex (number)\n"+
            "* accessKey (string)\n"+
            "* contextMenu (Menu)\n"+
            "* prompt (HTML string)\n"+
            "* canDrag (boolean)\n"+
            "* dragStartDistance (number)\n"+
            "* canDragScroll (boolean)\n"+
            "* dragScrollDelay (number)\n"+
            "* dragIntersectStyle (DragIntersectStyle string)\n"+
            "* canDragReposition (boolean)\n"+
            "* dragRepositionCursor (Cursor string)\n"+
            "* canDragResize (boolean)\n"+
            "* resizeFrom (array of EdgeName string)\n"+
            "* canHover (boolean)\n"+
            "* hoverDelay (number)\n"+
            "* showHover (boolean)\n"+
            "* hoverWidth (integer)\n"+
            "* hoverHeight (integer)\n"+
            "* hoverAlign (Alignment string)\n"+
            "* hoverVAlign (VerticalAlignment string)\n"+
            "* hoverWrap (boolean)\n"+
            "* hoverStyle (CSSStyleName string)\n"+
            "* hoverOpacity (number)\n"+
            "* hoverMoveWithMouse (boolean)\n"+
            "* edgeMarginSize (number)\n"+
            "* edgeCursorMap (object)\n"+
            "* keepInParentRect (boolean | array of integer)\n"+
            "* dragAppearance (DragAppearance string)\n"+
            "* dragType (string)\n"+
            "* dropTypes (array of string | string)\n"+
            "* dragTarget (Canvas | string)\n"+
            "* showDragShadow (boolean)\n"+
            "* dragOpacity (integer)\n"+
            "* canDrop (boolean)\n"+
            "* canAcceptDrop (boolean)\n"+
            "* canDropBefore (boolean)\n"+
            "* mouseStillDownInitialDelay (integer)\n"+
            "* mouseStillDownDelay (integer)\n"+
            "* doubleClickDelay (integer)\n"+
            "* noDoubleClicks (boolean)\n"+
            "* snapTo (string)\n"+
            "* snapOffsetLeft (integer)\n"+
            "* snapOffsetTop (integer)\n"+
            "* snapToGrid (boolean)\n"+
            "* snapResizeToGrid (boolean)\n"+
            "* childrenSnapToGrid (boolean)\n"+
            "* childrenSnapResizeToGrid (boolean)\n"+
            "* snapHGap (number)\n"+
            "* snapVGap (number)\n"+
            "* snapOnDrop (boolean)\n"+
            "* showPointer (boolean)\n"+
            "* pointerTarget (AutoTestLocator string | GlobalId string)\n"+
            "* pointerSettings (PointerSettings object)\n"+
            "* workflows (array of Process)\n"+
            "* borderRadius (string)\n"+
            "* showEdges (boolean)\n"+
            "* edgeSize (number)\n"+
            "* edgeOffset (number)\n"+
            "* edgeImage (SCImgURL string)\n"+
            "* customEdges (array of string)\n"+
            "* edgeBackgroundColor (CSSColor string)\n"+
            "* edgeOpacity (integer)\n"+
            "* edgeShowCenter (boolean)\n"+
            "* edgeCenterBackgroundColor (CSSColor string)\n"+
            "* showShadow (boolean)\n"+
            "* shadowDepth (number)\n"+
            "* shadowOffset (number)\n"+
            "* shadowSoftness (number)\n"+
            "* shadowImage (SCImgURL string)\n"+
            "* isGroup (boolean)\n"+
            "* groupTitle (HTML string)\n"+
            "* testDataContext (DataContext object)\n"+
            "* autoPopulateData (boolean)\n"+
            "* ruleScope (string)\n"+
            "* isRuleScope (boolean)\n"+
            "* valuesManager (ValuesManager | GlobalId string)\n"+
            "* dataPath (DataPath string)\n"+
            "* animateTime (number)\n"+
            "* animateAcceleration (AnimationAcceleration string)\n"+
            "* animateMoveTime (number)\n"+
            "* animateResizeTime (number)\n"+
            "* animateRectTime (number)\n"+
            "* animateFadeTime (number)\n"+
            "* animateScrollTime (number)\n"+
            "* animateShowTime (number)\n"+
            "* animateHideTime (number)\n"+
            "* animateMoveAcceleration (AnimationAcceleration string)\n"+
            "* animateResizeAcceleration (AnimationAcceleration string)\n"+
            "* animateRectAcceleration (AnimationAcceleration string)\n"+
            "* animateScrollAcceleration (AnimationAcceleration string)\n"+
            "* animateShowAcceleration (AnimationAcceleration string)\n"+
            "* animateHideAcceleration (AnimationAcceleration string)\n"+
            "* layoutAlign (Alignment string | VerticalAlignment string)\n"+
            "* showResizeBar (boolean)\n"+
            "* resizeBarTarget (string)\n"+
            "* extraSpace (positive integer)\n"+
            "\n"+
            "### Methods\n"+
            "* showNextTo()\n"+
            "* show()\n"+
            "* hide()\n"+
            "* print()\n",
        format:"Markdown"
    },
    "APIs list:TileLayout":{
        topic:"APIs list for TileLayout",
        content:"Only the following APIs are available on TileLayout:\n"+
            "\n"+
            "## Attributes\n"+
            "* tiles (array of Canvas)\n"+
            "* layoutPolicy (TileLayoutPolicy string)\n"+
            "* tileSize (integer)\n"+
            "* tileWidth (integer)\n"+
            "* tileHeight (integer)\n"+
            "* tileMargin (integer)\n"+
            "* tileHMargin (integer)\n"+
            "* tileVMargin (integer)\n"+
            "* layoutMargin (integer)\n"+
            "* paddingAsLayoutMargin (boolean)\n"+
            "* animateTileChange (boolean)\n"+
            "* orientation (Orientation string)\n"+
            "* tilesPerLine (integer)\n"+
            "* overflow (Overflow string)\n"+
            "* expandMargins (boolean)\n"+
            "* autoWrapLines (boolean)\n"+
            "* dragDataAction (DragDataAction string)\n"+
            "\n"+
            "## Inherited from Canvas\n"+
            "\n"+
            "### Attributes\n"+
            "* ID (GlobalId string)\n"+
            "* autoDraw (boolean)\n"+
            "* children (array of Canvas)\n"+
            "* peers (array of Canvas)\n"+
            "* htmlElement (DOMElement object | string)\n"+
            "* htmlPosition (DrawPosition string)\n"+
            "* matchElement (boolean)\n"+
            "* position (Positioning string)\n"+
            "* left (number | string)\n"+
            "* top (number | string)\n"+
            "* width (number | string)\n"+
            "* height (number | string)\n"+
            "* defaultWidth (integer)\n"+
            "* defaultHeight (integer)\n"+
            "* minWidth (number)\n"+
            "* minHeight (number)\n"+
            "* maxWidth (number)\n"+
            "* maxHeight (number)\n"+
            "* autoShowParent (boolean)\n"+
            "* visibility (Visibility string)\n"+
            "* canSelectText (boolean)\n"+
            "* styleName (CSSStyleName string)\n"+
            "* contents (HTML string)\n"+
            "* dynamicContents (boolean)\n"+
            "* dynamicContentsVars (ValueMap object)\n"+
            "* margin (number)\n"+
            "* padding (number)\n"+
            "* border (string)\n"+
            "* backgroundColor (CSSColor string)\n"+
            "* backgroundImage (SCImgURL string)\n"+
            "* backgroundRepeat (BackgroundRepeat string)\n"+
            "* appImgDir (URL string)\n"+
            "* skinImgDir (SCImgURL string)\n"+
            "* cursor (Cursor string)\n"+
            "* disabledCursor (Cursor string)\n"+
            "* opacity (number)\n"+
            "* showCustomScrollbars (boolean)\n"+
            "* scrollbarSize (number)\n"+
            "* disabled (boolean)\n"+
            "* visibleWhen (AdvancedCriteria object)\n"+
            "* enableWhen (AdvancedCriteria object)\n"+
            "* redrawOnResize (boolean)\n"+
            "* canFocus (boolean)\n"+
            "* tabIndex (number)\n"+
            "* accessKey (string)\n"+
            "* contextMenu (Menu)\n"+
            "* prompt (HTML string)\n"+
            "* canDrag (boolean)\n"+
            "* dragStartDistance (number)\n"+
            "* canDragScroll (boolean)\n"+
            "* dragScrollDelay (number)\n"+
            "* dragIntersectStyle (DragIntersectStyle string)\n"+
            "* canDragReposition (boolean)\n"+
            "* dragRepositionCursor (Cursor string)\n"+
            "* canDragResize (boolean)\n"+
            "* resizeFrom (array of EdgeName string)\n"+
            "* canHover (boolean)\n"+
            "* hoverDelay (number)\n"+
            "* showHover (boolean)\n"+
            "* hoverWidth (integer)\n"+
            "* hoverHeight (integer)\n"+
            "* hoverAlign (Alignment string)\n"+
            "* hoverVAlign (VerticalAlignment string)\n"+
            "* hoverWrap (boolean)\n"+
            "* hoverStyle (CSSStyleName string)\n"+
            "* hoverOpacity (number)\n"+
            "* hoverMoveWithMouse (boolean)\n"+
            "* edgeMarginSize (number)\n"+
            "* edgeCursorMap (object)\n"+
            "* keepInParentRect (boolean | array of integer)\n"+
            "* dragAppearance (DragAppearance string)\n"+
            "* dragType (string)\n"+
            "* dropTypes (array of string | string)\n"+
            "* dragTarget (Canvas | string)\n"+
            "* showDragShadow (boolean)\n"+
            "* dragOpacity (integer)\n"+
            "* canDrop (boolean)\n"+
            "* canAcceptDrop (boolean)\n"+
            "* canDropBefore (boolean)\n"+
            "* mouseStillDownInitialDelay (integer)\n"+
            "* mouseStillDownDelay (integer)\n"+
            "* doubleClickDelay (integer)\n"+
            "* noDoubleClicks (boolean)\n"+
            "* snapTo (string)\n"+
            "* snapOffsetLeft (integer)\n"+
            "* snapOffsetTop (integer)\n"+
            "* snapToGrid (boolean)\n"+
            "* snapResizeToGrid (boolean)\n"+
            "* childrenSnapToGrid (boolean)\n"+
            "* childrenSnapResizeToGrid (boolean)\n"+
            "* snapHGap (number)\n"+
            "* snapVGap (number)\n"+
            "* snapOnDrop (boolean)\n"+
            "* showPointer (boolean)\n"+
            "* pointerTarget (AutoTestLocator string | GlobalId string)\n"+
            "* pointerSettings (PointerSettings object)\n"+
            "* workflows (array of Process)\n"+
            "* borderRadius (string)\n"+
            "* showEdges (boolean)\n"+
            "* edgeSize (number)\n"+
            "* edgeOffset (number)\n"+
            "* edgeImage (SCImgURL string)\n"+
            "* customEdges (array of string)\n"+
            "* edgeBackgroundColor (CSSColor string)\n"+
            "* edgeOpacity (integer)\n"+
            "* edgeShowCenter (boolean)\n"+
            "* edgeCenterBackgroundColor (CSSColor string)\n"+
            "* showShadow (boolean)\n"+
            "* shadowDepth (number)\n"+
            "* shadowOffset (number)\n"+
            "* shadowSoftness (number)\n"+
            "* shadowImage (SCImgURL string)\n"+
            "* isGroup (boolean)\n"+
            "* groupTitle (HTML string)\n"+
            "* testDataContext (DataContext object)\n"+
            "* autoPopulateData (boolean)\n"+
            "* ruleScope (string)\n"+
            "* isRuleScope (boolean)\n"+
            "* valuesManager (ValuesManager | GlobalId string)\n"+
            "* dataPath (DataPath string)\n"+
            "* animateTime (number)\n"+
            "* animateAcceleration (AnimationAcceleration string)\n"+
            "* animateMoveTime (number)\n"+
            "* animateResizeTime (number)\n"+
            "* animateRectTime (number)\n"+
            "* animateFadeTime (number)\n"+
            "* animateScrollTime (number)\n"+
            "* animateShowTime (number)\n"+
            "* animateHideTime (number)\n"+
            "* animateMoveAcceleration (AnimationAcceleration string)\n"+
            "* animateResizeAcceleration (AnimationAcceleration string)\n"+
            "* animateRectAcceleration (AnimationAcceleration string)\n"+
            "* animateScrollAcceleration (AnimationAcceleration string)\n"+
            "* animateShowAcceleration (AnimationAcceleration string)\n"+
            "* animateHideAcceleration (AnimationAcceleration string)\n"+
            "* layoutAlign (Alignment string | VerticalAlignment string)\n"+
            "* showResizeBar (boolean)\n"+
            "* resizeBarTarget (string)\n"+
            "* extraSpace (positive integer)\n"+
            "\n"+
            "### Methods\n"+
            "* showNextTo()\n"+
            "* show()\n"+
            "* hide()\n"+
            "* print()\n",
        format:"Markdown"
    },
    "APIs list:TabSet":{
        topic:"APIs list for TabSet",
        content:"Only the following APIs are available on TabSet:\n"+
            "\n"+
            "## Attributes\n"+
            "* tabs (array of Tab objects)\n"+
            "* tabProperties (Tab properties object)\n"+
            "* useSimpleTabs (boolean)\n"+
            "* simpleTabBaseStyle (CSSStyleName string)\n"+
            "* tabBarPosition (Side string)\n"+
            "* tabBarAlign (Side string | Alignment string)\n"+
            "* tabBarThickness (number)\n"+
            "* selectedTab (Tab object | integer)\n"+
            "* canCloseTabs (boolean)\n"+
            "* closeTabIcon (SCImgURL string)\n"+
            "* closeTabIconSize (integer)\n"+
            "* canReorderTabs (boolean)\n"+
            "* tabBarControls (array)\n"+
            "* showTabScroller (boolean)\n"+
            "* showTabPicker (boolean)\n"+
            "* animateTabScrolling (boolean)\n"+
            "* scrollerButtonSize (number)\n"+
            "* pickerButtonSize (integer)\n"+
            "* skinImgDir (SCImgURL string)\n"+
            "* scrollerHSrc (SCImgURL string)\n"+
            "* scrollerVSrc (SCImgURL string)\n"+
            "* pickerButtonHSrc (SCImgURL string)\n"+
            "* pickerButtonVSrc (SCImgURL string)\n"+
            "* paneContainerClassName (CSSStyleName string)\n"+
            "* paneContainerOverflow (Overflow string)\n"+
            "* symmetricEdges (boolean)\n"+
            "* leftEdgeSizes (EdgeSizes object)\n"+
            "* topEdgeSizes (EdgeSizes object)\n"+
            "* bottomEdgeSizes (EdgeSizes object)\n"+
            "* rightEdgeSizes (EdgeSizes object)\n"+
            "* leftEdgeOffsets (EdgeSizes object)\n"+
            "* rightEdgeOffsets (EdgeSizes object)\n"+
            "* topEdgeOffsets (EdgeSizes object)\n"+
            "* bottomEdgeOffsets (EdgeSizes object)\n"+
            "* showPaneContainerEdges (boolean)\n"+
            "* tabBarProperties (TabBar properties object)\n"+
            "* showPartialEdges (boolean)\n"+
            "* destroyPanes (boolean)\n"+
            "\n"+
            "## Methods\n"+
            "* tabSelected()\n"+
            "* tabDeselected()\n"+
            "\n"+
            "## Inherited from Canvas\n"+
            "\n"+
            "### Attributes\n"+
            "* ID (GlobalId string)\n"+
            "* autoDraw (boolean)\n"+
            "* htmlElement (DOMElement object | string)\n"+
            "* htmlPosition (DrawPosition string)\n"+
            "* matchElement (boolean)\n"+
            "* position (Positioning string)\n"+
            "* left (number | string)\n"+
            "* top (number | string)\n"+
            "* width (number | string)\n"+
            "* height (number | string)\n"+
            "* defaultWidth (integer)\n"+
            "* defaultHeight (integer)\n"+
            "* minWidth (number)\n"+
            "* minHeight (number)\n"+
            "* maxWidth (number)\n"+
            "* maxHeight (number)\n"+
            "* autoShowParent (boolean)\n"+
            "* visibility (Visibility string)\n"+
            "* styleName (CSSStyleName string)\n"+
            "* contents (HTML string)\n"+
            "* dynamicContents (boolean)\n"+
            "* dynamicContentsVars (ValueMap object)\n"+
            "* margin (number)\n"+
            "* padding (number)\n"+
            "* border (string)\n"+
            "* backgroundColor (CSSColor string)\n"+
            "* backgroundImage (SCImgURL string)\n"+
            "* backgroundRepeat (BackgroundRepeat string)\n"+
            "* appImgDir (URL string)\n"+
            "* cursor (Cursor string)\n"+
            "* disabledCursor (Cursor string)\n"+
            "* opacity (number)\n"+
            "* overflow (Overflow string)\n"+
            "* showCustomScrollbars (boolean)\n"+
            "* scrollbarSize (number)\n"+
            "* disabled (boolean)\n"+
            "* visibleWhen (AdvancedCriteria object)\n"+
            "* enableWhen (AdvancedCriteria object)\n"+
            "* redrawOnResize (boolean)\n"+
            "* canFocus (boolean)\n"+
            "* tabIndex (number)\n"+
            "* accessKey (string)\n"+
            "* contextMenu (Menu)\n"+
            "* prompt (HTML string)\n"+
            "* canDrag (boolean)\n"+
            "* dragStartDistance (number)\n"+
            "* canDragScroll (boolean)\n"+
            "* dragScrollDelay (number)\n"+
            "* dragIntersectStyle (DragIntersectStyle string)\n"+
            "* canDragReposition (boolean)\n"+
            "* dragRepositionCursor (Cursor string)\n"+
            "* canDragResize (boolean)\n"+
            "* resizeFrom (array of EdgeName string)\n"+
            "* canHover (boolean)\n"+
            "* hoverDelay (number)\n"+
            "* showHover (boolean)\n"+
            "* hoverWidth (integer)\n"+
            "* hoverHeight (integer)\n"+
            "* hoverAlign (Alignment string)\n"+
            "* hoverVAlign (VerticalAlignment string)\n"+
            "* hoverWrap (boolean)\n"+
            "* hoverStyle (CSSStyleName string)\n"+
            "* hoverOpacity (number)\n"+
            "* hoverMoveWithMouse (boolean)\n"+
            "* edgeMarginSize (number)\n"+
            "* edgeCursorMap (object)\n"+
            "* keepInParentRect (boolean | array of integer)\n"+
            "* dragAppearance (DragAppearance string)\n"+
            "* dragType (string)\n"+
            "* dropTypes (array of string | string)\n"+
            "* dragTarget (Canvas | string)\n"+
            "* showDragShadow (boolean)\n"+
            "* dragOpacity (integer)\n"+
            "* canDrop (boolean)\n"+
            "* canAcceptDrop (boolean)\n"+
            "* canDropBefore (boolean)\n"+
            "* mouseStillDownInitialDelay (integer)\n"+
            "* mouseStillDownDelay (integer)\n"+
            "* doubleClickDelay (integer)\n"+
            "* noDoubleClicks (boolean)\n"+
            "* snapTo (string)\n"+
            "* snapOffsetLeft (integer)\n"+
            "* snapOffsetTop (integer)\n"+
            "* snapToGrid (boolean)\n"+
            "* snapResizeToGrid (boolean)\n"+
            "* childrenSnapToGrid (boolean)\n"+
            "* childrenSnapResizeToGrid (boolean)\n"+
            "* snapHGap (number)\n"+
            "* snapVGap (number)\n"+
            "* snapOnDrop (boolean)\n"+
            "* showPointer (boolean)\n"+
            "* pointerTarget (AutoTestLocator string | GlobalId string)\n"+
            "* pointerSettings (PointerSettings object)\n"+
            "* workflows (array of Process)\n"+
            "* borderRadius (string)\n"+
            "* showEdges (boolean)\n"+
            "* edgeSize (number)\n"+
            "* edgeOffset (number)\n"+
            "* edgeImage (SCImgURL string)\n"+
            "* customEdges (array of string)\n"+
            "* edgeBackgroundColor (CSSColor string)\n"+
            "* edgeOpacity (integer)\n"+
            "* edgeShowCenter (boolean)\n"+
            "* edgeCenterBackgroundColor (CSSColor string)\n"+
            "* showShadow (boolean)\n"+
            "* shadowDepth (number)\n"+
            "* shadowOffset (number)\n"+
            "* shadowSoftness (number)\n"+
            "* shadowImage (SCImgURL string)\n"+
            "* isGroup (boolean)\n"+
            "* groupTitle (HTML string)\n"+
            "* testDataContext (DataContext object)\n"+
            "* autoPopulateData (boolean)\n"+
            "* ruleScope (string)\n"+
            "* isRuleScope (boolean)\n"+
            "* valuesManager (ValuesManager | GlobalId string)\n"+
            "* dataPath (DataPath string)\n"+
            "* animateTime (number)\n"+
            "* animateAcceleration (AnimationAcceleration string)\n"+
            "* animateMoveTime (number)\n"+
            "* animateResizeTime (number)\n"+
            "* animateRectTime (number)\n"+
            "* animateFadeTime (number)\n"+
            "* animateScrollTime (number)\n"+
            "* animateShowTime (number)\n"+
            "* animateHideTime (number)\n"+
            "* animateMoveAcceleration (AnimationAcceleration string)\n"+
            "* animateResizeAcceleration (AnimationAcceleration string)\n"+
            "* animateRectAcceleration (AnimationAcceleration string)\n"+
            "* animateScrollAcceleration (AnimationAcceleration string)\n"+
            "* animateShowAcceleration (AnimationAcceleration string)\n"+
            "* animateHideAcceleration (AnimationAcceleration string)\n"+
            "* layoutAlign (Alignment string | VerticalAlignment string)\n"+
            "* showResizeBar (boolean)\n"+
            "* resizeBarTarget (string)\n"+
            "* extraSpace (positive integer)\n"+
            "\n"+
            "### Methods\n"+
            "* showNextTo()\n"+
            "* show()\n"+
            "* hide()\n"+
            "* print()\n",
        format:"Markdown"
    },
    "APIs list:Tab":{
        topic:"APIs list for Tab",
        content:"Only the following APIs are available on Tab:\n"+
            "\n"+
            "## Attributes\n"+
            "* title (HTML string)\n"+
            "* pickerTitle (HTML string)\n"+
            "* pane (Canvas | ID string | Shortcut properties object)\n"+
            "* ID (GlobalId string)\n"+
            "* width (number)\n"+
            "* disabled (boolean)\n"+
            "* hidden (boolean)\n"+
            "* visibleWhen (Criteria object)\n"+
            "* enableWhen (Criteria object)\n"+
            "* icon (SCImgURL string)\n"+
            "* canClose (boolean)\n"+
            "* closeIcon (SCImgURL string)\n"+
            "\n"+
            "## Methods\n"+
            "* tabSelected()\n"+
            "* tabDeselected()\n",
        format:"Markdown"
    },
    "APIs list:HTMLFlow":{
        topic:"APIs list for HTMLFlow",
        content:"Only the following APIs are available on HTMLFlow:\n"+
            "\n"+
            "## Attributes\n"+
            "* defaultWidth (integer)\n"+
            "* defaultHeight (integer)\n"+
            "* overflow (Overflow string)\n"+
            "* contents (HTML string)\n"+
            "* dynamicContents (boolean)\n"+
            "* contentsURL (URL string)\n"+
            "* loadingMessage (HTML string)\n"+
            "* contentsURLParams (object)\n"+
            "* httpMethod (SendMethod string)\n"+
            "* contentsType (ContentsType string)\n"+
            "* allowCaching (boolean)\n"+
            "* evalScriptBlocks (boolean)\n"+
            "* captureSCComponents (boolean)\n"+
            "* canSelectText (boolean)\n"+
            "\n"+
            "## Methods\n"+
            "* setContentsURL()\n"+
            "\n"+
            "## Inherited from Canvas\n"+
            "\n"+
            "### Attributes\n"+
            "* ID (GlobalId string)\n"+
            "* autoDraw (boolean)\n"+
            "* htmlElement (DOMElement object | string)\n"+
            "* htmlPosition (DrawPosition string)\n"+
            "* matchElement (boolean)\n"+
            "* position (Positioning string)\n"+
            "* left (number | string)\n"+
            "* top (number | string)\n"+
            "* width (number | string)\n"+
            "* height (number | string)\n"+
            "* minWidth (number)\n"+
            "* minHeight (number)\n"+
            "* maxWidth (number)\n"+
            "* maxHeight (number)\n"+
            "* autoShowParent (boolean)\n"+
            "* visibility (Visibility string)\n"+
            "* styleName (CSSStyleName string)\n"+
            "* dynamicContentsVars (ValueMap object)\n"+
            "* margin (number)\n"+
            "* padding (number)\n"+
            "* border (string)\n"+
            "* backgroundColor (CSSColor string)\n"+
            "* backgroundImage (SCImgURL string)\n"+
            "* backgroundRepeat (BackgroundRepeat string)\n"+
            "* appImgDir (URL string)\n"+
            "* skinImgDir (SCImgURL string)\n"+
            "* cursor (Cursor string)\n"+
            "* disabledCursor (Cursor string)\n"+
            "* opacity (number)\n"+
            "* showCustomScrollbars (boolean)\n"+
            "* scrollbarSize (number)\n"+
            "* disabled (boolean)\n"+
            "* visibleWhen (AdvancedCriteria object)\n"+
            "* enableWhen (AdvancedCriteria object)\n"+
            "* redrawOnResize (boolean)\n"+
            "* canFocus (boolean)\n"+
            "* tabIndex (number)\n"+
            "* accessKey (string)\n"+
            "* contextMenu (Menu)\n"+
            "* prompt (HTML string)\n"+
            "* canDrag (boolean)\n"+
            "* dragStartDistance (number)\n"+
            "* canDragScroll (boolean)\n"+
            "* dragScrollDelay (number)\n"+
            "* dragIntersectStyle (DragIntersectStyle string)\n"+
            "* canDragReposition (boolean)\n"+
            "* dragRepositionCursor (Cursor string)\n"+
            "* canDragResize (boolean)\n"+
            "* resizeFrom (array of EdgeName string)\n"+
            "* canHover (boolean)\n"+
            "* hoverDelay (number)\n"+
            "* showHover (boolean)\n"+
            "* hoverWidth (integer)\n"+
            "* hoverHeight (integer)\n"+
            "* hoverAlign (Alignment string)\n"+
            "* hoverVAlign (VerticalAlignment string)\n"+
            "* hoverWrap (boolean)\n"+
            "* hoverStyle (CSSStyleName string)\n"+
            "* hoverOpacity (number)\n"+
            "* hoverMoveWithMouse (boolean)\n"+
            "* edgeMarginSize (number)\n"+
            "* edgeCursorMap (object)\n"+
            "* keepInParentRect (boolean | array of integer)\n"+
            "* dragAppearance (DragAppearance string)\n"+
            "* dragType (string)\n"+
            "* dropTypes (array of string | string)\n"+
            "* dragTarget (Canvas | string)\n"+
            "* showDragShadow (boolean)\n"+
            "* dragOpacity (integer)\n"+
            "* canDrop (boolean)\n"+
            "* canAcceptDrop (boolean)\n"+
            "* canDropBefore (boolean)\n"+
            "* mouseStillDownInitialDelay (integer)\n"+
            "* mouseStillDownDelay (integer)\n"+
            "* doubleClickDelay (integer)\n"+
            "* noDoubleClicks (boolean)\n"+
            "* snapTo (string)\n"+
            "* snapOffsetLeft (integer)\n"+
            "* snapOffsetTop (integer)\n"+
            "* snapToGrid (boolean)\n"+
            "* snapResizeToGrid (boolean)\n"+
            "* childrenSnapToGrid (boolean)\n"+
            "* childrenSnapResizeToGrid (boolean)\n"+
            "* snapHGap (number)\n"+
            "* snapVGap (number)\n"+
            "* snapOnDrop (boolean)\n"+
            "* showPointer (boolean)\n"+
            "* pointerTarget (AutoTestLocator string | GlobalId string)\n"+
            "* pointerSettings (PointerSettings object)\n"+
            "* workflows (array of Process)\n"+
            "* borderRadius (string)\n"+
            "* showEdges (boolean)\n"+
            "* edgeSize (number)\n"+
            "* edgeOffset (number)\n"+
            "* edgeImage (SCImgURL string)\n"+
            "* customEdges (array of string)\n"+
            "* edgeBackgroundColor (CSSColor string)\n"+
            "* edgeOpacity (integer)\n"+
            "* edgeShowCenter (boolean)\n"+
            "* edgeCenterBackgroundColor (CSSColor string)\n"+
            "* showShadow (boolean)\n"+
            "* shadowDepth (number)\n"+
            "* shadowOffset (number)\n"+
            "* shadowSoftness (number)\n"+
            "* shadowImage (SCImgURL string)\n"+
            "* isGroup (boolean)\n"+
            "* groupTitle (HTML string)\n"+
            "* testDataContext (DataContext object)\n"+
            "* autoPopulateData (boolean)\n"+
            "* ruleScope (string)\n"+
            "* isRuleScope (boolean)\n"+
            "* valuesManager (ValuesManager | GlobalId string)\n"+
            "* dataPath (DataPath string)\n"+
            "* animateTime (number)\n"+
            "* animateAcceleration (AnimationAcceleration string)\n"+
            "* animateMoveTime (number)\n"+
            "* animateResizeTime (number)\n"+
            "* animateRectTime (number)\n"+
            "* animateFadeTime (number)\n"+
            "* animateScrollTime (number)\n"+
            "* animateShowTime (number)\n"+
            "* animateHideTime (number)\n"+
            "* animateMoveAcceleration (AnimationAcceleration string)\n"+
            "* animateResizeAcceleration (AnimationAcceleration string)\n"+
            "* animateRectAcceleration (AnimationAcceleration string)\n"+
            "* animateScrollAcceleration (AnimationAcceleration string)\n"+
            "* animateShowAcceleration (AnimationAcceleration string)\n"+
            "* animateHideAcceleration (AnimationAcceleration string)\n"+
            "* layoutAlign (Alignment string | VerticalAlignment string)\n"+
            "* showResizeBar (boolean)\n"+
            "* resizeBarTarget (string)\n"+
            "* extraSpace (positive integer)\n"+
            "\n"+
            "### Methods\n"+
            "* showNextTo()\n"+
            "* show()\n"+
            "* hide()\n"+
            "* print()\n",
        format:"Markdown"
    },
    "APIs list:HTMLPane":{
        topic:"APIs list for HTMLPane",
        content:"Only the following APIs are available on HTMLPane:\n"+
            "\n"+
            "## Attributes\n"+
            "* contents (HTML string)\n"+
            "* contentsURL (URL string)\n"+
            "* contentsURLParams (object)\n"+
            "* contentsType (ContentsType string)\n"+
            "* overflow (Overflow string)\n"+
            "* defaultHeight (integer)\n"+
            "\n"+
            "## Inherited from HTMLFlow\n"+
            "\n"+
            "### Attributes\n"+
            "* defaultWidth (integer)\n"+
            "* dynamicContents (boolean)\n"+
            "* loadingMessage (HTML string)\n"+
            "* httpMethod (SendMethod string)\n"+
            "* allowCaching (boolean)\n"+
            "* evalScriptBlocks (boolean)\n"+
            "* captureSCComponents (boolean)\n"+
            "* canSelectText (boolean)\n"+
            "\n"+
            "### Methods\n"+
            "* setContentsURL()\n"+
            "\n"+
            "## Inherited from Canvas\n"+
            "\n"+
            "### Attributes\n"+
            "* ID (GlobalId string)\n"+
            "* autoDraw (boolean)\n"+
            "* htmlElement (DOMElement object | string)\n"+
            "* htmlPosition (DrawPosition string)\n"+
            "* matchElement (boolean)\n"+
            "* position (Positioning string)\n"+
            "* left (number | string)\n"+
            "* top (number | string)\n"+
            "* width (number | string)\n"+
            "* height (number | string)\n"+
            "* minWidth (number)\n"+
            "* minHeight (number)\n"+
            "* maxWidth (number)\n"+
            "* maxHeight (number)\n"+
            "* autoShowParent (boolean)\n"+
            "* visibility (Visibility string)\n"+
            "* styleName (CSSStyleName string)\n"+
            "* dynamicContentsVars (ValueMap object)\n"+
            "* margin (number)\n"+
            "* padding (number)\n"+
            "* border (string)\n"+
            "* backgroundColor (CSSColor string)\n"+
            "* backgroundImage (SCImgURL string)\n"+
            "* backgroundRepeat (BackgroundRepeat string)\n"+
            "* appImgDir (URL string)\n"+
            "* skinImgDir (SCImgURL string)\n"+
            "* cursor (Cursor string)\n"+
            "* disabledCursor (Cursor string)\n"+
            "* opacity (number)\n"+
            "* showCustomScrollbars (boolean)\n"+
            "* scrollbarSize (number)\n"+
            "* disabled (boolean)\n"+
            "* visibleWhen (AdvancedCriteria object)\n"+
            "* enableWhen (AdvancedCriteria object)\n"+
            "* redrawOnResize (boolean)\n"+
            "* canFocus (boolean)\n"+
            "* tabIndex (number)\n"+
            "* accessKey (string)\n"+
            "* contextMenu (Menu)\n"+
            "* prompt (HTML string)\n"+
            "* canDrag (boolean)\n"+
            "* dragStartDistance (number)\n"+
            "* canDragScroll (boolean)\n"+
            "* dragScrollDelay (number)\n"+
            "* dragIntersectStyle (DragIntersectStyle string)\n"+
            "* canDragReposition (boolean)\n"+
            "* dragRepositionCursor (Cursor string)\n"+
            "* canDragResize (boolean)\n"+
            "* resizeFrom (array of EdgeName string)\n"+
            "* canHover (boolean)\n"+
            "* hoverDelay (number)\n"+
            "* showHover (boolean)\n"+
            "* hoverWidth (integer)\n"+
            "* hoverHeight (integer)\n"+
            "* hoverAlign (Alignment string)\n"+
            "* hoverVAlign (VerticalAlignment string)\n"+
            "* hoverWrap (boolean)\n"+
            "* hoverStyle (CSSStyleName string)\n"+
            "* hoverOpacity (number)\n"+
            "* hoverMoveWithMouse (boolean)\n"+
            "* edgeMarginSize (number)\n"+
            "* edgeCursorMap (object)\n"+
            "* keepInParentRect (boolean | array of integer)\n"+
            "* dragAppearance (DragAppearance string)\n"+
            "* dragType (string)\n"+
            "* dropTypes (array of string | string)\n"+
            "* dragTarget (Canvas | string)\n"+
            "* showDragShadow (boolean)\n"+
            "* dragOpacity (integer)\n"+
            "* canDrop (boolean)\n"+
            "* canAcceptDrop (boolean)\n"+
            "* canDropBefore (boolean)\n"+
            "* mouseStillDownInitialDelay (integer)\n"+
            "* mouseStillDownDelay (integer)\n"+
            "* doubleClickDelay (integer)\n"+
            "* noDoubleClicks (boolean)\n"+
            "* snapTo (string)\n"+
            "* snapOffsetLeft (integer)\n"+
            "* snapOffsetTop (integer)\n"+
            "* snapToGrid (boolean)\n"+
            "* snapResizeToGrid (boolean)\n"+
            "* childrenSnapToGrid (boolean)\n"+
            "* childrenSnapResizeToGrid (boolean)\n"+
            "* snapHGap (number)\n"+
            "* snapVGap (number)\n"+
            "* snapOnDrop (boolean)\n"+
            "* showPointer (boolean)\n"+
            "* pointerTarget (AutoTestLocator string | GlobalId string)\n"+
            "* pointerSettings (PointerSettings object)\n"+
            "* workflows (array of Process)\n"+
            "* borderRadius (string)\n"+
            "* showEdges (boolean)\n"+
            "* edgeSize (number)\n"+
            "* edgeOffset (number)\n"+
            "* edgeImage (SCImgURL string)\n"+
            "* customEdges (array of string)\n"+
            "* edgeBackgroundColor (CSSColor string)\n"+
            "* edgeOpacity (integer)\n"+
            "* edgeShowCenter (boolean)\n"+
            "* edgeCenterBackgroundColor (CSSColor string)\n"+
            "* showShadow (boolean)\n"+
            "* shadowDepth (number)\n"+
            "* shadowOffset (number)\n"+
            "* shadowSoftness (number)\n"+
            "* shadowImage (SCImgURL string)\n"+
            "* isGroup (boolean)\n"+
            "* groupTitle (HTML string)\n"+
            "* testDataContext (DataContext object)\n"+
            "* autoPopulateData (boolean)\n"+
            "* ruleScope (string)\n"+
            "* isRuleScope (boolean)\n"+
            "* valuesManager (ValuesManager | GlobalId string)\n"+
            "* dataPath (DataPath string)\n"+
            "* animateTime (number)\n"+
            "* animateAcceleration (AnimationAcceleration string)\n"+
            "* animateMoveTime (number)\n"+
            "* animateResizeTime (number)\n"+
            "* animateRectTime (number)\n"+
            "* animateFadeTime (number)\n"+
            "* animateScrollTime (number)\n"+
            "* animateShowTime (number)\n"+
            "* animateHideTime (number)\n"+
            "* animateMoveAcceleration (AnimationAcceleration string)\n"+
            "* animateResizeAcceleration (AnimationAcceleration string)\n"+
            "* animateRectAcceleration (AnimationAcceleration string)\n"+
            "* animateScrollAcceleration (AnimationAcceleration string)\n"+
            "* animateShowAcceleration (AnimationAcceleration string)\n"+
            "* animateHideAcceleration (AnimationAcceleration string)\n"+
            "* layoutAlign (Alignment string | VerticalAlignment string)\n"+
            "* showResizeBar (boolean)\n"+
            "* resizeBarTarget (string)\n"+
            "* extraSpace (positive integer)\n"+
            "\n"+
            "### Methods\n"+
            "* showNextTo()\n"+
            "* show()\n"+
            "* hide()\n"+
            "* print()\n",
        format:"Markdown"
    },
    "APIs list:RichTextEditor":{
        topic:"APIs list for RichTextEditor",
        content:"Only the following APIs are available on RichTextEditor:\n"+
            "\n"+
            "## Attributes\n"+
            "* value (string)\n"+
            "* controlGroups (array)\n"+
            "* styleControls (array of ControlName string)\n"+
            "* fontControls (array of ControlName string)\n"+
            "* fontNames (object)\n"+
            "* fontSizes (object)\n"+
            "* formatControls (array of ControlName string)\n"+
            "* colorControls (array of ControlName string)\n"+
            "\n"+
            "## Inherited from Layout\n"+
            "\n"+
            "### Attributes\n"+
            "* members (array of Canvas)\n"+
            "* overflow (Overflow string)\n"+
            "* vertical (boolean)\n"+
            "* vPolicy (LayoutPolicy string)\n"+
            "* hPolicy (LayoutPolicy string)\n"+
            "* minMemberLength (integer)\n"+
            "* minBreadthMember (string | integer | Canvas)\n"+
            "* enforcePolicy (boolean)\n"+
            "* defaultLayoutAlign (Alignment string | VerticalAlignment string)\n"+
            "* align (Alignment string | VerticalAlignment string)\n"+
            "* reverseOrder (boolean)\n"+
            "* paddingAsLayoutMargin (boolean)\n"+
            "* layoutMargin (integer)\n"+
            "* layoutLeftMargin (integer)\n"+
            "* layoutRightMargin (integer)\n"+
            "* layoutTopMargin (integer)\n"+
            "* layoutBottomMargin (integer)\n"+
            "* membersMargin (integer)\n"+
            "* leaveScrollbarGap (boolean)\n"+
            "* resizeBarClass (string)\n"+
            "* resizeBarSize (integer)\n"+
            "* animateMembers (boolean)\n"+
            "* animateMemberTime (number)\n"+
            "* canDropComponents (boolean)\n"+
            "* dropLineThickness (number)\n"+
            "* showDragPlaceHolder (boolean)\n"+
            "* placeHolderProperties (Canvas properties object)\n"+
            "* placeHolderDefaults (Canvas properties object)\n"+
            "\n"+
            "## Inherited from Canvas\n"+
            "\n"+
            "### Attributes\n"+
            "* ID (GlobalId string)\n"+
            "* autoDraw (boolean)\n"+
            "* children (array of Canvas)\n"+
            "* peers (array of Canvas)\n"+
            "* htmlElement (DOMElement object | string)\n"+
            "* htmlPosition (DrawPosition string)\n"+
            "* matchElement (boolean)\n"+
            "* position (Positioning string)\n"+
            "* left (number | string)\n"+
            "* top (number | string)\n"+
            "* width (number | string)\n"+
            "* height (number | string)\n"+
            "* defaultWidth (integer)\n"+
            "* defaultHeight (integer)\n"+
            "* minWidth (number)\n"+
            "* minHeight (number)\n"+
            "* maxWidth (number)\n"+
            "* maxHeight (number)\n"+
            "* autoShowParent (boolean)\n"+
            "* visibility (Visibility string)\n"+
            "* canSelectText (boolean)\n"+
            "* styleName (CSSStyleName string)\n"+
            "* contents (HTML string)\n"+
            "* dynamicContents (boolean)\n"+
            "* dynamicContentsVars (ValueMap object)\n"+
            "* margin (number)\n"+
            "* padding (number)\n"+
            "* border (string)\n"+
            "* backgroundColor (CSSColor string)\n"+
            "* backgroundImage (SCImgURL string)\n"+
            "* backgroundRepeat (BackgroundRepeat string)\n"+
            "* appImgDir (URL string)\n"+
            "* skinImgDir (SCImgURL string)\n"+
            "* cursor (Cursor string)\n"+
            "* disabledCursor (Cursor string)\n"+
            "* opacity (number)\n"+
            "* showCustomScrollbars (boolean)\n"+
            "* scrollbarSize (number)\n"+
            "* disabled (boolean)\n"+
            "* visibleWhen (AdvancedCriteria object)\n"+
            "* enableWhen (AdvancedCriteria object)\n"+
            "* redrawOnResize (boolean)\n"+
            "* canFocus (boolean)\n"+
            "* tabIndex (number)\n"+
            "* accessKey (string)\n"+
            "* contextMenu (Menu)\n"+
            "* prompt (HTML string)\n"+
            "* canDrag (boolean)\n"+
            "* dragStartDistance (number)\n"+
            "* canDragScroll (boolean)\n"+
            "* dragScrollDelay (number)\n"+
            "* dragIntersectStyle (DragIntersectStyle string)\n"+
            "* canDragReposition (boolean)\n"+
            "* dragRepositionCursor (Cursor string)\n"+
            "* canDragResize (boolean)\n"+
            "* resizeFrom (array of EdgeName string)\n"+
            "* canHover (boolean)\n"+
            "* hoverDelay (number)\n"+
            "* showHover (boolean)\n"+
            "* hoverWidth (integer)\n"+
            "* hoverHeight (integer)\n"+
            "* hoverAlign (Alignment string)\n"+
            "* hoverVAlign (VerticalAlignment string)\n"+
            "* hoverWrap (boolean)\n"+
            "* hoverStyle (CSSStyleName string)\n"+
            "* hoverOpacity (number)\n"+
            "* hoverMoveWithMouse (boolean)\n"+
            "* edgeMarginSize (number)\n"+
            "* edgeCursorMap (object)\n"+
            "* keepInParentRect (boolean | array of integer)\n"+
            "* dragAppearance (DragAppearance string)\n"+
            "* dragType (string)\n"+
            "* dropTypes (array of string | string)\n"+
            "* dragTarget (Canvas | string)\n"+
            "* showDragShadow (boolean)\n"+
            "* dragOpacity (integer)\n"+
            "* canDrop (boolean)\n"+
            "* canAcceptDrop (boolean)\n"+
            "* canDropBefore (boolean)\n"+
            "* mouseStillDownInitialDelay (integer)\n"+
            "* mouseStillDownDelay (integer)\n"+
            "* doubleClickDelay (integer)\n"+
            "* noDoubleClicks (boolean)\n"+
            "* snapTo (string)\n"+
            "* snapOffsetLeft (integer)\n"+
            "* snapOffsetTop (integer)\n"+
            "* snapToGrid (boolean)\n"+
            "* snapResizeToGrid (boolean)\n"+
            "* childrenSnapToGrid (boolean)\n"+
            "* childrenSnapResizeToGrid (boolean)\n"+
            "* snapHGap (number)\n"+
            "* snapVGap (number)\n"+
            "* snapOnDrop (boolean)\n"+
            "* showPointer (boolean)\n"+
            "* pointerTarget (AutoTestLocator string | GlobalId string)\n"+
            "* pointerSettings (PointerSettings object)\n"+
            "* workflows (array of Process)\n"+
            "* borderRadius (string)\n"+
            "* showEdges (boolean)\n"+
            "* edgeSize (number)\n"+
            "* edgeOffset (number)\n"+
            "* edgeImage (SCImgURL string)\n"+
            "* customEdges (array of string)\n"+
            "* edgeBackgroundColor (CSSColor string)\n"+
            "* edgeOpacity (integer)\n"+
            "* edgeShowCenter (boolean)\n"+
            "* edgeCenterBackgroundColor (CSSColor string)\n"+
            "* showShadow (boolean)\n"+
            "* shadowDepth (number)\n"+
            "* shadowOffset (number)\n"+
            "* shadowSoftness (number)\n"+
            "* shadowImage (SCImgURL string)\n"+
            "* isGroup (boolean)\n"+
            "* groupTitle (HTML string)\n"+
            "* testDataContext (DataContext object)\n"+
            "* autoPopulateData (boolean)\n"+
            "* ruleScope (string)\n"+
            "* isRuleScope (boolean)\n"+
            "* valuesManager (ValuesManager | GlobalId string)\n"+
            "* dataPath (DataPath string)\n"+
            "* animateTime (number)\n"+
            "* animateAcceleration (AnimationAcceleration string)\n"+
            "* animateMoveTime (number)\n"+
            "* animateResizeTime (number)\n"+
            "* animateRectTime (number)\n"+
            "* animateFadeTime (number)\n"+
            "* animateScrollTime (number)\n"+
            "* animateShowTime (number)\n"+
            "* animateHideTime (number)\n"+
            "* animateMoveAcceleration (AnimationAcceleration string)\n"+
            "* animateResizeAcceleration (AnimationAcceleration string)\n"+
            "* animateRectAcceleration (AnimationAcceleration string)\n"+
            "* animateScrollAcceleration (AnimationAcceleration string)\n"+
            "* animateShowAcceleration (AnimationAcceleration string)\n"+
            "* animateHideAcceleration (AnimationAcceleration string)\n"+
            "* layoutAlign (Alignment string | VerticalAlignment string)\n"+
            "* showResizeBar (boolean)\n"+
            "* resizeBarTarget (string)\n"+
            "* extraSpace (positive integer)\n"+
            "\n"+
            "### Methods\n"+
            "* showNextTo()\n"+
            "* show()\n"+
            "* hide()\n"+
            "* print()\n",
        format:"Markdown"
    },
    "APIs list:Slider":{
        topic:"APIs list for Slider",
        content:"Only the following APIs are available on Slider:\n"+
            "\n"+
            "## Attributes\n"+
            "* title (string)\n"+
            "* length (integer)\n"+
            "* vertical (boolean)\n"+
            "* thumbThickWidth (integer)\n"+
            "* thumbThinWidth (integer)\n"+
            "* trackWidth (integer)\n"+
            "* thumbSrc (string)\n"+
            "* trackSrc (string)\n"+
            "* trackCapSize (integer)\n"+
            "* trackImageType (ImageStyle string)\n"+
            "* showTitle (boolean)\n"+
            "* showRange (boolean)\n"+
            "* showValue (boolean)\n"+
            "* labelWidth (integer)\n"+
            "* labelHeight (integer)\n"+
            "* labelSpacing (integer)\n"+
            "* vLabelSpacing (integer)\n"+
            "* hLabelSpacing (integer)\n"+
            "* titleSpacing (integer)\n"+
            "* value (number)\n"+
            "* minValue (number)\n"+
            "* minValueLabel (string)\n"+
            "* maxValue (number)\n"+
            "* maxValueLabel (string)\n"+
            "* numValues (integer)\n"+
            "* roundValues (boolean)\n"+
            "* roundPrecision (integer)\n"+
            "* flipValues (boolean)\n"+
            "* sliderTarget (Canvas)\n"+
            "* canFocus (boolean)\n"+
            "* stepPercent (number)\n"+
            "* animateThumb (boolean)\n"+
            "* animateThumbTime (integer)\n"+
            "* animateThumbInit (boolean)\n"+
            "\n"+
            "## Inherited from Canvas\n"+
            "\n"+
            "### Attributes\n"+
            "* ID (GlobalId string)\n"+
            "* autoDraw (boolean)\n"+
            "* htmlElement (DOMElement object | string)\n"+
            "* htmlPosition (DrawPosition string)\n"+
            "* matchElement (boolean)\n"+
            "* position (Positioning string)\n"+
            "* left (number | string)\n"+
            "* top (number | string)\n"+
            "* width (number | string)\n"+
            "* height (number | string)\n"+
            "* defaultWidth (integer)\n"+
            "* defaultHeight (integer)\n"+
            "* minWidth (number)\n"+
            "* minHeight (number)\n"+
            "* maxWidth (number)\n"+
            "* maxHeight (number)\n"+
            "* autoShowParent (boolean)\n"+
            "* visibility (Visibility string)\n"+
            "* canSelectText (boolean)\n"+
            "* styleName (CSSStyleName string)\n"+
            "* contents (HTML string)\n"+
            "* dynamicContents (boolean)\n"+
            "* dynamicContentsVars (ValueMap object)\n"+
            "* margin (number)\n"+
            "* padding (number)\n"+
            "* border (string)\n"+
            "* backgroundColor (CSSColor string)\n"+
            "* backgroundImage (SCImgURL string)\n"+
            "* backgroundRepeat (BackgroundRepeat string)\n"+
            "* appImgDir (URL string)\n"+
            "* skinImgDir (SCImgURL string)\n"+
            "* cursor (Cursor string)\n"+
            "* disabledCursor (Cursor string)\n"+
            "* opacity (number)\n"+
            "* overflow (Overflow string)\n"+
            "* showCustomScrollbars (boolean)\n"+
            "* scrollbarSize (number)\n"+
            "* disabled (boolean)\n"+
            "* visibleWhen (AdvancedCriteria object)\n"+
            "* enableWhen (AdvancedCriteria object)\n"+
            "* redrawOnResize (boolean)\n"+
            "* tabIndex (number)\n"+
            "* accessKey (string)\n"+
            "* contextMenu (Menu)\n"+
            "* prompt (HTML string)\n"+
            "* canDrag (boolean)\n"+
            "* dragStartDistance (number)\n"+
            "* canDragScroll (boolean)\n"+
            "* dragScrollDelay (number)\n"+
            "* dragIntersectStyle (DragIntersectStyle string)\n"+
            "* canDragReposition (boolean)\n"+
            "* dragRepositionCursor (Cursor string)\n"+
            "* canDragResize (boolean)\n"+
            "* resizeFrom (array of EdgeName string)\n"+
            "* canHover (boolean)\n"+
            "* hoverDelay (number)\n"+
            "* showHover (boolean)\n"+
            "* hoverWidth (integer)\n"+
            "* hoverHeight (integer)\n"+
            "* hoverAlign (Alignment string)\n"+
            "* hoverVAlign (VerticalAlignment string)\n"+
            "* hoverWrap (boolean)\n"+
            "* hoverStyle (CSSStyleName string)\n"+
            "* hoverOpacity (number)\n"+
            "* hoverMoveWithMouse (boolean)\n"+
            "* edgeMarginSize (number)\n"+
            "* edgeCursorMap (object)\n"+
            "* keepInParentRect (boolean | array of integer)\n"+
            "* dragAppearance (DragAppearance string)\n"+
            "* dragType (string)\n"+
            "* dropTypes (array of string | string)\n"+
            "* dragTarget (Canvas | string)\n"+
            "* showDragShadow (boolean)\n"+
            "* dragOpacity (integer)\n"+
            "* canDrop (boolean)\n"+
            "* canAcceptDrop (boolean)\n"+
            "* canDropBefore (boolean)\n"+
            "* mouseStillDownInitialDelay (integer)\n"+
            "* mouseStillDownDelay (integer)\n"+
            "* doubleClickDelay (integer)\n"+
            "* noDoubleClicks (boolean)\n"+
            "* snapTo (string)\n"+
            "* snapOffsetLeft (integer)\n"+
            "* snapOffsetTop (integer)\n"+
            "* snapToGrid (boolean)\n"+
            "* snapResizeToGrid (boolean)\n"+
            "* childrenSnapToGrid (boolean)\n"+
            "* childrenSnapResizeToGrid (boolean)\n"+
            "* snapHGap (number)\n"+
            "* snapVGap (number)\n"+
            "* snapOnDrop (boolean)\n"+
            "* showPointer (boolean)\n"+
            "* pointerTarget (AutoTestLocator string | GlobalId string)\n"+
            "* pointerSettings (PointerSettings object)\n"+
            "* workflows (array of Process)\n"+
            "* borderRadius (string)\n"+
            "* showEdges (boolean)\n"+
            "* edgeSize (number)\n"+
            "* edgeOffset (number)\n"+
            "* edgeImage (SCImgURL string)\n"+
            "* customEdges (array of string)\n"+
            "* edgeBackgroundColor (CSSColor string)\n"+
            "* edgeOpacity (integer)\n"+
            "* edgeShowCenter (boolean)\n"+
            "* edgeCenterBackgroundColor (CSSColor string)\n"+
            "* showShadow (boolean)\n"+
            "* shadowDepth (number)\n"+
            "* shadowOffset (number)\n"+
            "* shadowSoftness (number)\n"+
            "* shadowImage (SCImgURL string)\n"+
            "* isGroup (boolean)\n"+
            "* groupTitle (HTML string)\n"+
            "* testDataContext (DataContext object)\n"+
            "* autoPopulateData (boolean)\n"+
            "* ruleScope (string)\n"+
            "* isRuleScope (boolean)\n"+
            "* valuesManager (ValuesManager | GlobalId string)\n"+
            "* dataPath (DataPath string)\n"+
            "* animateTime (number)\n"+
            "* animateAcceleration (AnimationAcceleration string)\n"+
            "* animateMoveTime (number)\n"+
            "* animateResizeTime (number)\n"+
            "* animateRectTime (number)\n"+
            "* animateFadeTime (number)\n"+
            "* animateScrollTime (number)\n"+
            "* animateShowTime (number)\n"+
            "* animateHideTime (number)\n"+
            "* animateMoveAcceleration (AnimationAcceleration string)\n"+
            "* animateResizeAcceleration (AnimationAcceleration string)\n"+
            "* animateRectAcceleration (AnimationAcceleration string)\n"+
            "* animateScrollAcceleration (AnimationAcceleration string)\n"+
            "* animateShowAcceleration (AnimationAcceleration string)\n"+
            "* animateHideAcceleration (AnimationAcceleration string)\n"+
            "* layoutAlign (Alignment string | VerticalAlignment string)\n"+
            "* showResizeBar (boolean)\n"+
            "* resizeBarTarget (string)\n"+
            "* extraSpace (positive integer)\n"+
            "\n"+
            "### Methods\n"+
            "* showNextTo()\n"+
            "* show()\n"+
            "* hide()\n"+
            "* print()\n",
        format:"Markdown"
    },
    "APIs list:Progressbar":{
        topic:"APIs list for Progressbar",
        content:"Only the following APIs are available on Progressbar:\n"+
            "\n"+
            "## Attributes\n"+
            "* percentDone (number)\n"+
            "* length (number | string)\n"+
            "* breadth (number)\n"+
            "* vertical (boolean)\n"+
            "* src (SCImgURL string)\n"+
            "* baseStyle (CSSStyleName string)\n"+
            "\n"+
            "## Inherited from StretchImg\n"+
            "\n"+
            "### Attributes\n"+
            "* capSize (number)\n"+
            "* hSrc (SCImgURL string)\n"+
            "* vSrc (SCImgURL string)\n"+
            "* imageType (ImageStyle string)\n"+
            "* items (array of StretchItem objects)\n"+
            "* showTitle (boolean)\n"+
            "\n"+
            "## Inherited from StatefulCanvas\n"+
            "\n"+
            "### Attributes\n"+
            "* title (HTML string)\n"+
            "* selected (boolean)\n"+
            "* state (State string)\n"+
            "* showRollOver (boolean)\n"+
            "* showFocused (boolean)\n"+
            "* showFocusedAsOver (boolean)\n"+
            "* showDown (boolean)\n"+
            "* showDisabled (boolean)\n"+
            "* actionType (SelectionType string)\n"+
            "* radioGroup (string)\n"+
            "* styleName (CSSStyleName string)\n"+
            "* align (Alignment string)\n"+
            "* valign (VerticalAlignment string)\n"+
            "* autoFit (boolean)\n"+
            "* width (number | string)\n"+
            "* height (number | string)\n"+
            "* icon (SCImgURL string)\n"+
            "* iconSize (integer)\n"+
            "* iconWidth (integer)\n"+
            "* iconHeight (integer)\n"+
            "* iconOrientation (string)\n"+
            "* iconSpacing (integer)\n"+
            "* showDisabledIcon (boolean)\n"+
            "* showRollOverIcon (boolean)\n"+
            "* showDownIcon (boolean)\n"+
            "* showSelectedIcon (boolean)\n"+
            "* showFocusedIcon (boolean)\n"+
            "* showOverCanvas (boolean)\n"+
            "* showMenuOnClick (boolean)\n"+
            "\n"+
            "## Inherited from Canvas\n"+
            "\n"+
            "### Attributes\n"+
            "* ID (GlobalId string)\n"+
            "* autoDraw (boolean)\n"+
            "* htmlElement (DOMElement object | string)\n"+
            "* htmlPosition (DrawPosition string)\n"+
            "* matchElement (boolean)\n"+
            "* position (Positioning string)\n"+
            "* left (number | string)\n"+
            "* top (number | string)\n"+
            "* defaultWidth (integer)\n"+
            "* defaultHeight (integer)\n"+
            "* minWidth (number)\n"+
            "* minHeight (number)\n"+
            "* maxWidth (number)\n"+
            "* maxHeight (number)\n"+
            "* autoShowParent (boolean)\n"+
            "* visibility (Visibility string)\n"+
            "* canSelectText (boolean)\n"+
            "* contents (HTML string)\n"+
            "* dynamicContents (boolean)\n"+
            "* dynamicContentsVars (ValueMap object)\n"+
            "* margin (number)\n"+
            "* padding (number)\n"+
            "* border (string)\n"+
            "* backgroundColor (CSSColor string)\n"+
            "* backgroundImage (SCImgURL string)\n"+
            "* backgroundRepeat (BackgroundRepeat string)\n"+
            "* appImgDir (URL string)\n"+
            "* skinImgDir (SCImgURL string)\n"+
            "* cursor (Cursor string)\n"+
            "* disabledCursor (Cursor string)\n"+
            "* opacity (number)\n"+
            "* overflow (Overflow string)\n"+
            "* showCustomScrollbars (boolean)\n"+
            "* scrollbarSize (number)\n"+
            "* disabled (boolean)\n"+
            "* visibleWhen (AdvancedCriteria object)\n"+
            "* enableWhen (AdvancedCriteria object)\n"+
            "* redrawOnResize (boolean)\n"+
            "* canFocus (boolean)\n"+
            "* tabIndex (number)\n"+
            "* accessKey (string)\n"+
            "* contextMenu (Menu)\n"+
            "* prompt (HTML string)\n"+
            "* canDrag (boolean)\n"+
            "* dragStartDistance (number)\n"+
            "* canDragScroll (boolean)\n"+
            "* dragScrollDelay (number)\n"+
            "* dragIntersectStyle (DragIntersectStyle string)\n"+
            "* canDragReposition (boolean)\n"+
            "* dragRepositionCursor (Cursor string)\n"+
            "* canDragResize (boolean)\n"+
            "* resizeFrom (array of EdgeName string)\n"+
            "* canHover (boolean)\n"+
            "* hoverDelay (number)\n"+
            "* showHover (boolean)\n"+
            "* hoverWidth (integer)\n"+
            "* hoverHeight (integer)\n"+
            "* hoverAlign (Alignment string)\n"+
            "* hoverVAlign (VerticalAlignment string)\n"+
            "* hoverWrap (boolean)\n"+
            "* hoverStyle (CSSStyleName string)\n"+
            "* hoverOpacity (number)\n"+
            "* hoverMoveWithMouse (boolean)\n"+
            "* edgeMarginSize (number)\n"+
            "* edgeCursorMap (object)\n"+
            "* keepInParentRect (boolean | array of integer)\n"+
            "* dragAppearance (DragAppearance string)\n"+
            "* dragType (string)\n"+
            "* dropTypes (array of string | string)\n"+
            "* dragTarget (Canvas | string)\n"+
            "* showDragShadow (boolean)\n"+
            "* dragOpacity (integer)\n"+
            "* canDrop (boolean)\n"+
            "* canAcceptDrop (boolean)\n"+
            "* canDropBefore (boolean)\n"+
            "* mouseStillDownInitialDelay (integer)\n"+
            "* mouseStillDownDelay (integer)\n"+
            "* doubleClickDelay (integer)\n"+
            "* noDoubleClicks (boolean)\n"+
            "* snapTo (string)\n"+
            "* snapOffsetLeft (integer)\n"+
            "* snapOffsetTop (integer)\n"+
            "* snapToGrid (boolean)\n"+
            "* snapResizeToGrid (boolean)\n"+
            "* childrenSnapToGrid (boolean)\n"+
            "* childrenSnapResizeToGrid (boolean)\n"+
            "* snapHGap (number)\n"+
            "* snapVGap (number)\n"+
            "* snapOnDrop (boolean)\n"+
            "* showPointer (boolean)\n"+
            "* pointerTarget (AutoTestLocator string | GlobalId string)\n"+
            "* pointerSettings (PointerSettings object)\n"+
            "* workflows (array of Process)\n"+
            "* borderRadius (string)\n"+
            "* showEdges (boolean)\n"+
            "* edgeSize (number)\n"+
            "* edgeOffset (number)\n"+
            "* edgeImage (SCImgURL string)\n"+
            "* customEdges (array of string)\n"+
            "* edgeBackgroundColor (CSSColor string)\n"+
            "* edgeOpacity (integer)\n"+
            "* edgeShowCenter (boolean)\n"+
            "* edgeCenterBackgroundColor (CSSColor string)\n"+
            "* showShadow (boolean)\n"+
            "* shadowDepth (number)\n"+
            "* shadowOffset (number)\n"+
            "* shadowSoftness (number)\n"+
            "* shadowImage (SCImgURL string)\n"+
            "* isGroup (boolean)\n"+
            "* groupTitle (HTML string)\n"+
            "* testDataContext (DataContext object)\n"+
            "* autoPopulateData (boolean)\n"+
            "* ruleScope (string)\n"+
            "* isRuleScope (boolean)\n"+
            "* valuesManager (ValuesManager | GlobalId string)\n"+
            "* dataPath (DataPath string)\n"+
            "* animateTime (number)\n"+
            "* animateAcceleration (AnimationAcceleration string)\n"+
            "* animateMoveTime (number)\n"+
            "* animateResizeTime (number)\n"+
            "* animateRectTime (number)\n"+
            "* animateFadeTime (number)\n"+
            "* animateScrollTime (number)\n"+
            "* animateShowTime (number)\n"+
            "* animateHideTime (number)\n"+
            "* animateMoveAcceleration (AnimationAcceleration string)\n"+
            "* animateResizeAcceleration (AnimationAcceleration string)\n"+
            "* animateRectAcceleration (AnimationAcceleration string)\n"+
            "* animateScrollAcceleration (AnimationAcceleration string)\n"+
            "* animateShowAcceleration (AnimationAcceleration string)\n"+
            "* animateHideAcceleration (AnimationAcceleration string)\n"+
            "* layoutAlign (Alignment string | VerticalAlignment string)\n"+
            "* showResizeBar (boolean)\n"+
            "* resizeBarTarget (string)\n"+
            "* extraSpace (positive integer)\n"+
            "\n"+
            "### Methods\n"+
            "* showNextTo()\n"+
            "* show()\n"+
            "* hide()\n"+
            "* click()\n"+
            "* doubleClick()\n"+
            "* print()\n",
        format:"Markdown"
    },
    "APIs list:SectionHeader":{
        topic:"APIs list for SectionHeader",
        content:"Only the following APIs are available on SectionHeader:\n"+
            "\n"+
            "## Attributes\n"+
            "* showClippedTitleOnHover (boolean)\n"+
            "* icon (SCImgURL string)\n"+
            "* baseStyle (CSSStyleName string)\n"+
            "* noDoubleClicks (boolean)\n"+
            "\n"+
            "## Inherited from Label\n"+
            "\n"+
            "### Attributes\n"+
            "* contents (HTML string)\n"+
            "* dynamicContents (boolean)\n"+
            "* align (Alignment string)\n"+
            "* valign (VerticalAlignment string)\n"+
            "* wrap (boolean)\n"+
            "* autoFit (boolean)\n"+
            "* width (number | string)\n"+
            "* height (number | string)\n"+
            "* iconSize (integer)\n"+
            "* iconWidth (integer)\n"+
            "* iconHeight (integer)\n"+
            "* iconOrientation (string)\n"+
            "* iconAlign (string)\n"+
            "* iconSpacing (integer)\n"+
            "* showDisabledIcon (boolean)\n"+
            "* showRollOverIcon (boolean)\n"+
            "* showFocusedIcon (boolean)\n"+
            "* showDownIcon (boolean)\n"+
            "* showSelectedIcon (boolean)\n"+
            "* styleName (CSSStyleName string)\n"+
            "\n"+
            "## Inherited from Button\n"+
            "\n"+
            "### Attributes\n"+
            "* hiliteAccessKey (boolean)\n"+
            "* selected (boolean)\n"+
            "* radioGroup (string)\n"+
            "* actionType (SelectionType string)\n"+
            "* state (State string)\n"+
            "* showDisabled (boolean)\n"+
            "* showDown (boolean)\n"+
            "* showFocused (boolean)\n"+
            "* showRollOver (boolean)\n"+
            "* overflow (Overflow string)\n"+
            "\n"+
            "## Inherited from StatefulCanvas\n"+
            "\n"+
            "### Attributes\n"+
            "* showFocusedAsOver (boolean)\n"+
            "* showOverCanvas (boolean)\n"+
            "* showMenuOnClick (boolean)\n"+
            "\n"+
            "## Inherited from Canvas\n"+
            "\n"+
            "### Attributes\n"+
            "* ID (GlobalId string)\n"+
            "* autoDraw (boolean)\n"+
            "* htmlElement (DOMElement object | string)\n"+
            "* htmlPosition (DrawPosition string)\n"+
            "* matchElement (boolean)\n"+
            "* position (Positioning string)\n"+
            "* left (number | string)\n"+
            "* top (number | string)\n"+
            "* defaultWidth (integer)\n"+
            "* defaultHeight (integer)\n"+
            "* minWidth (number)\n"+
            "* minHeight (number)\n"+
            "* maxWidth (number)\n"+
            "* maxHeight (number)\n"+
            "* autoShowParent (boolean)\n"+
            "* visibility (Visibility string)\n"+
            "* canSelectText (boolean)\n"+
            "* dynamicContentsVars (ValueMap object)\n"+
            "* margin (number)\n"+
            "* padding (number)\n"+
            "* border (string)\n"+
            "* backgroundColor (CSSColor string)\n"+
            "* backgroundImage (SCImgURL string)\n"+
            "* backgroundRepeat (BackgroundRepeat string)\n"+
            "* appImgDir (URL string)\n"+
            "* skinImgDir (SCImgURL string)\n"+
            "* cursor (Cursor string)\n"+
            "* disabledCursor (Cursor string)\n"+
            "* opacity (number)\n"+
            "* showCustomScrollbars (boolean)\n"+
            "* scrollbarSize (number)\n"+
            "* disabled (boolean)\n"+
            "* visibleWhen (AdvancedCriteria object)\n"+
            "* enableWhen (AdvancedCriteria object)\n"+
            "* redrawOnResize (boolean)\n"+
            "* canFocus (boolean)\n"+
            "* tabIndex (number)\n"+
            "* accessKey (string)\n"+
            "* contextMenu (Menu)\n"+
            "* prompt (HTML string)\n"+
            "* canDrag (boolean)\n"+
            "* dragStartDistance (number)\n"+
            "* canDragScroll (boolean)\n"+
            "* dragScrollDelay (number)\n"+
            "* dragIntersectStyle (DragIntersectStyle string)\n"+
            "* canDragReposition (boolean)\n"+
            "* dragRepositionCursor (Cursor string)\n"+
            "* canDragResize (boolean)\n"+
            "* resizeFrom (array of EdgeName string)\n"+
            "* canHover (boolean)\n"+
            "* hoverDelay (number)\n"+
            "* showHover (boolean)\n"+
            "* hoverWidth (integer)\n"+
            "* hoverHeight (integer)\n"+
            "* hoverAlign (Alignment string)\n"+
            "* hoverVAlign (VerticalAlignment string)\n"+
            "* hoverWrap (boolean)\n"+
            "* hoverStyle (CSSStyleName string)\n"+
            "* hoverOpacity (number)\n"+
            "* hoverMoveWithMouse (boolean)\n"+
            "* edgeMarginSize (number)\n"+
            "* edgeCursorMap (object)\n"+
            "* keepInParentRect (boolean | array of integer)\n"+
            "* dragAppearance (DragAppearance string)\n"+
            "* dragType (string)\n"+
            "* dropTypes (array of string | string)\n"+
            "* dragTarget (Canvas | string)\n"+
            "* showDragShadow (boolean)\n"+
            "* dragOpacity (integer)\n"+
            "* canDrop (boolean)\n"+
            "* canAcceptDrop (boolean)\n"+
            "* canDropBefore (boolean)\n"+
            "* mouseStillDownInitialDelay (integer)\n"+
            "* mouseStillDownDelay (integer)\n"+
            "* doubleClickDelay (integer)\n"+
            "* snapTo (string)\n"+
            "* snapOffsetLeft (integer)\n"+
            "* snapOffsetTop (integer)\n"+
            "* snapToGrid (boolean)\n"+
            "* snapResizeToGrid (boolean)\n"+
            "* childrenSnapToGrid (boolean)\n"+
            "* childrenSnapResizeToGrid (boolean)\n"+
            "* snapHGap (number)\n"+
            "* snapVGap (number)\n"+
            "* snapOnDrop (boolean)\n"+
            "* showPointer (boolean)\n"+
            "* pointerTarget (AutoTestLocator string | GlobalId string)\n"+
            "* pointerSettings (PointerSettings object)\n"+
            "* workflows (array of Process)\n"+
            "* borderRadius (string)\n"+
            "* showEdges (boolean)\n"+
            "* edgeSize (number)\n"+
            "* edgeOffset (number)\n"+
            "* edgeImage (SCImgURL string)\n"+
            "* customEdges (array of string)\n"+
            "* edgeBackgroundColor (CSSColor string)\n"+
            "* edgeOpacity (integer)\n"+
            "* edgeShowCenter (boolean)\n"+
            "* edgeCenterBackgroundColor (CSSColor string)\n"+
            "* showShadow (boolean)\n"+
            "* shadowDepth (number)\n"+
            "* shadowOffset (number)\n"+
            "* shadowSoftness (number)\n"+
            "* shadowImage (SCImgURL string)\n"+
            "* isGroup (boolean)\n"+
            "* groupTitle (HTML string)\n"+
            "* testDataContext (DataContext object)\n"+
            "* autoPopulateData (boolean)\n"+
            "* ruleScope (string)\n"+
            "* isRuleScope (boolean)\n"+
            "* valuesManager (ValuesManager | GlobalId string)\n"+
            "* dataPath (DataPath string)\n"+
            "* animateTime (number)\n"+
            "* animateAcceleration (AnimationAcceleration string)\n"+
            "* animateMoveTime (number)\n"+
            "* animateResizeTime (number)\n"+
            "* animateRectTime (number)\n"+
            "* animateFadeTime (number)\n"+
            "* animateScrollTime (number)\n"+
            "* animateShowTime (number)\n"+
            "* animateHideTime (number)\n"+
            "* animateMoveAcceleration (AnimationAcceleration string)\n"+
            "* animateResizeAcceleration (AnimationAcceleration string)\n"+
            "* animateRectAcceleration (AnimationAcceleration string)\n"+
            "* animateScrollAcceleration (AnimationAcceleration string)\n"+
            "* animateShowAcceleration (AnimationAcceleration string)\n"+
            "* animateHideAcceleration (AnimationAcceleration string)\n"+
            "* layoutAlign (Alignment string | VerticalAlignment string)\n"+
            "* showResizeBar (boolean)\n"+
            "* resizeBarTarget (string)\n"+
            "* extraSpace (positive integer)\n"+
            "\n"+
            "### Methods\n"+
            "* showNextTo()\n"+
            "* show()\n"+
            "* hide()\n"+
            "* click()\n"+
            "* print()\n",
        format:"Markdown"
    },
    "APIs list:SplitPane":{
        topic:"APIs list for SplitPane",
        content:"Only the following APIs are available on SplitPane:\n"+
            "\n"+
            "## Attributes\n"+
            "* vertical (boolean)\n"+
            "* addHistoryEntries (boolean)\n"+
            "* pageOrientation (PageOrientation string)\n"+
            "* notifyAfterNavigationClick (boolean)\n"+
            "* navigationPaneWidth (number | string)\n"+
            "* showNavigationBar (boolean)\n"+
            "* currentPane (CurrentPane string)\n"+
            "* navigationTitle (HTML string)\n"+
            "* navigationPane (Canvas)\n"+
            "* listTitle (HTML string)\n"+
            "* listPane (Canvas)\n"+
            "* showListToolStrip (boolean)\n"+
            "* detailTitle (HTML string)\n"+
            "* detailPane (Canvas)\n"+
            "* showDetailToolStrip (boolean)\n"+
            "* detailToolButtons (array of Canvas)\n"+
            "* showLeftButton (boolean)\n"+
            "* showRightButton (boolean)\n"+
            "* listPaneTitleTemplate (HTML string)\n"+
            "* detailPaneTitleTemplate (HTML string)\n"+
            "* autoNavigate (boolean)\n"+
            "\n"+
            "## Methods\n"+
            "* navigateListPane()\n"+
            "* navigateDetailPane()\n"+
            "\n"+
            "## Inherited from Layout\n"+
            "\n"+
            "### Attributes\n"+
            "* members (array of Canvas)\n"+
            "* overflow (Overflow string)\n"+
            "* vPolicy (LayoutPolicy string)\n"+
            "* hPolicy (LayoutPolicy string)\n"+
            "* minMemberLength (integer)\n"+
            "* minBreadthMember (string | integer | Canvas)\n"+
            "* enforcePolicy (boolean)\n"+
            "* defaultLayoutAlign (Alignment string | VerticalAlignment string)\n"+
            "* align (Alignment string | VerticalAlignment string)\n"+
            "* paddingAsLayoutMargin (boolean)\n"+
            "* layoutMargin (integer)\n"+
            "* layoutLeftMargin (integer)\n"+
            "* layoutRightMargin (integer)\n"+
            "* layoutTopMargin (integer)\n"+
            "* layoutBottomMargin (integer)\n"+
            "* membersMargin (integer)\n"+
            "* leaveScrollbarGap (boolean)\n"+
            "* resizeBarClass (string)\n"+
            "* resizeBarSize (integer)\n"+
            "* animateMembers (boolean)\n"+
            "* animateMemberTime (number)\n"+
            "* canDropComponents (boolean)\n"+
            "* dropLineThickness (number)\n"+
            "* showDragPlaceHolder (boolean)\n"+
            "* placeHolderProperties (Canvas properties object)\n"+
            "* placeHolderDefaults (Canvas properties object)\n"+
            "\n"+
            "## Inherited from Canvas\n"+
            "\n"+
            "### Attributes\n"+
            "* ID (GlobalId string)\n"+
            "* autoDraw (boolean)\n"+
            "* children (array of Canvas)\n"+
            "* peers (array of Canvas)\n"+
            "* htmlElement (DOMElement object | string)\n"+
            "* htmlPosition (DrawPosition string)\n"+
            "* matchElement (boolean)\n"+
            "* position (Positioning string)\n"+
            "* left (number | string)\n"+
            "* top (number | string)\n"+
            "* width (number | string)\n"+
            "* height (number | string)\n"+
            "* defaultWidth (integer)\n"+
            "* defaultHeight (integer)\n"+
            "* minWidth (number)\n"+
            "* minHeight (number)\n"+
            "* maxWidth (number)\n"+
            "* maxHeight (number)\n"+
            "* autoShowParent (boolean)\n"+
            "* visibility (Visibility string)\n"+
            "* canSelectText (boolean)\n"+
            "* styleName (CSSStyleName string)\n"+
            "* contents (HTML string)\n"+
            "* dynamicContents (boolean)\n"+
            "* dynamicContentsVars (ValueMap object)\n"+
            "* margin (number)\n"+
            "* padding (number)\n"+
            "* border (string)\n"+
            "* backgroundColor (CSSColor string)\n"+
            "* backgroundImage (SCImgURL string)\n"+
            "* backgroundRepeat (BackgroundRepeat string)\n"+
            "* appImgDir (URL string)\n"+
            "* skinImgDir (SCImgURL string)\n"+
            "* cursor (Cursor string)\n"+
            "* disabledCursor (Cursor string)\n"+
            "* opacity (number)\n"+
            "* showCustomScrollbars (boolean)\n"+
            "* scrollbarSize (number)\n"+
            "* disabled (boolean)\n"+
            "* visibleWhen (AdvancedCriteria object)\n"+
            "* enableWhen (AdvancedCriteria object)\n"+
            "* redrawOnResize (boolean)\n"+
            "* canFocus (boolean)\n"+
            "* tabIndex (number)\n"+
            "* accessKey (string)\n"+
            "* contextMenu (Menu)\n"+
            "* prompt (HTML string)\n"+
            "* canDrag (boolean)\n"+
            "* dragStartDistance (number)\n"+
            "* canDragScroll (boolean)\n"+
            "* dragScrollDelay (number)\n"+
            "* dragIntersectStyle (DragIntersectStyle string)\n"+
            "* canDragReposition (boolean)\n"+
            "* dragRepositionCursor (Cursor string)\n"+
            "* canDragResize (boolean)\n"+
            "* resizeFrom (array of EdgeName string)\n"+
            "* canHover (boolean)\n"+
            "* hoverDelay (number)\n"+
            "* showHover (boolean)\n"+
            "* hoverWidth (integer)\n"+
            "* hoverHeight (integer)\n"+
            "* hoverAlign (Alignment string)\n"+
            "* hoverVAlign (VerticalAlignment string)\n"+
            "* hoverWrap (boolean)\n"+
            "* hoverStyle (CSSStyleName string)\n"+
            "* hoverOpacity (number)\n"+
            "* hoverMoveWithMouse (boolean)\n"+
            "* edgeMarginSize (number)\n"+
            "* edgeCursorMap (object)\n"+
            "* keepInParentRect (boolean | array of integer)\n"+
            "* dragAppearance (DragAppearance string)\n"+
            "* dragType (string)\n"+
            "* dropTypes (array of string | string)\n"+
            "* dragTarget (Canvas | string)\n"+
            "* showDragShadow (boolean)\n"+
            "* dragOpacity (integer)\n"+
            "* canDrop (boolean)\n"+
            "* canAcceptDrop (boolean)\n"+
            "* canDropBefore (boolean)\n"+
            "* mouseStillDownInitialDelay (integer)\n"+
            "* mouseStillDownDelay (integer)\n"+
            "* doubleClickDelay (integer)\n"+
            "* noDoubleClicks (boolean)\n"+
            "* snapTo (string)\n"+
            "* snapOffsetLeft (integer)\n"+
            "* snapOffsetTop (integer)\n"+
            "* snapToGrid (boolean)\n"+
            "* snapResizeToGrid (boolean)\n"+
            "* childrenSnapToGrid (boolean)\n"+
            "* childrenSnapResizeToGrid (boolean)\n"+
            "* snapHGap (number)\n"+
            "* snapVGap (number)\n"+
            "* snapOnDrop (boolean)\n"+
            "* showPointer (boolean)\n"+
            "* pointerTarget (AutoTestLocator string | GlobalId string)\n"+
            "* pointerSettings (PointerSettings object)\n"+
            "* workflows (array of Process)\n"+
            "* borderRadius (string)\n"+
            "* showEdges (boolean)\n"+
            "* edgeSize (number)\n"+
            "* edgeOffset (number)\n"+
            "* edgeImage (SCImgURL string)\n"+
            "* customEdges (array of string)\n"+
            "* edgeBackgroundColor (CSSColor string)\n"+
            "* edgeOpacity (integer)\n"+
            "* edgeShowCenter (boolean)\n"+
            "* edgeCenterBackgroundColor (CSSColor string)\n"+
            "* showShadow (boolean)\n"+
            "* shadowDepth (number)\n"+
            "* shadowOffset (number)\n"+
            "* shadowSoftness (number)\n"+
            "* shadowImage (SCImgURL string)\n"+
            "* isGroup (boolean)\n"+
            "* groupTitle (HTML string)\n"+
            "* testDataContext (DataContext object)\n"+
            "* autoPopulateData (boolean)\n"+
            "* ruleScope (string)\n"+
            "* isRuleScope (boolean)\n"+
            "* valuesManager (ValuesManager | GlobalId string)\n"+
            "* dataPath (DataPath string)\n"+
            "* animateTime (number)\n"+
            "* animateAcceleration (AnimationAcceleration string)\n"+
            "* animateMoveTime (number)\n"+
            "* animateResizeTime (number)\n"+
            "* animateRectTime (number)\n"+
            "* animateFadeTime (number)\n"+
            "* animateScrollTime (number)\n"+
            "* animateShowTime (number)\n"+
            "* animateHideTime (number)\n"+
            "* animateMoveAcceleration (AnimationAcceleration string)\n"+
            "* animateResizeAcceleration (AnimationAcceleration string)\n"+
            "* animateRectAcceleration (AnimationAcceleration string)\n"+
            "* animateScrollAcceleration (AnimationAcceleration string)\n"+
            "* animateShowAcceleration (AnimationAcceleration string)\n"+
            "* animateHideAcceleration (AnimationAcceleration string)\n"+
            "* layoutAlign (Alignment string | VerticalAlignment string)\n"+
            "* showResizeBar (boolean)\n"+
            "* resizeBarTarget (string)\n"+
            "* extraSpace (positive integer)\n"+
            "\n"+
            "### Methods\n"+
            "* showNextTo()\n"+
            "* show()\n"+
            "* hide()\n"+
            "* print()\n",
        format:"Markdown"
    },
    "APIs list:EdgedCanvas":{
        topic:"APIs list for EdgedCanvas",
        content:"Only the following APIs are available on EdgedCanvas:\n"+
            "\n"+
            "## Attributes\n"+
            "* skinImgDir (SCImgURL string)\n"+
            "* edgeImage (SCImgURL string)\n"+
            "* edgeColor (CSSColor string)\n"+
            "* customEdges (array of string)\n"+
            "* showCenter (boolean)\n"+
            "* edgeSize (integer)\n"+
            "* edgeLeft (integer)\n"+
            "* edgeRight (integer)\n"+
            "* edgeTop (integer)\n"+
            "* edgeBottom (integer)\n"+
            "* edgeOffset (integer)\n"+
            "* edgeOffsetTop (integer)\n"+
            "* edgeOffsetBottom (integer)\n"+
            "* edgeOffsetLeft (integer)\n"+
            "* edgeOffsetRight (integer)\n"+
            "* centerBackgroundColor (CSSColor string)\n"+
            "\n"+
            "## Inherited from Canvas\n"+
            "\n"+
            "### Attributes\n"+
            "* ID (GlobalId string)\n"+
            "* autoDraw (boolean)\n"+
            "* children (array of Canvas)\n"+
            "* peers (array of Canvas)\n"+
            "* htmlElement (DOMElement object | string)\n"+
            "* htmlPosition (DrawPosition string)\n"+
            "* matchElement (boolean)\n"+
            "* position (Positioning string)\n"+
            "* left (number | string)\n"+
            "* top (number | string)\n"+
            "* width (number | string)\n"+
            "* height (number | string)\n"+
            "* defaultWidth (integer)\n"+
            "* defaultHeight (integer)\n"+
            "* minWidth (number)\n"+
            "* minHeight (number)\n"+
            "* maxWidth (number)\n"+
            "* maxHeight (number)\n"+
            "* autoShowParent (boolean)\n"+
            "* visibility (Visibility string)\n"+
            "* canSelectText (boolean)\n"+
            "* styleName (CSSStyleName string)\n"+
            "* contents (HTML string)\n"+
            "* dynamicContents (boolean)\n"+
            "* dynamicContentsVars (ValueMap object)\n"+
            "* margin (number)\n"+
            "* padding (number)\n"+
            "* border (string)\n"+
            "* backgroundColor (CSSColor string)\n"+
            "* backgroundImage (SCImgURL string)\n"+
            "* backgroundRepeat (BackgroundRepeat string)\n"+
            "* appImgDir (URL string)\n"+
            "* cursor (Cursor string)\n"+
            "* disabledCursor (Cursor string)\n"+
            "* opacity (number)\n"+
            "* overflow (Overflow string)\n"+
            "* showCustomScrollbars (boolean)\n"+
            "* scrollbarSize (number)\n"+
            "* disabled (boolean)\n"+
            "* visibleWhen (AdvancedCriteria object)\n"+
            "* enableWhen (AdvancedCriteria object)\n"+
            "* redrawOnResize (boolean)\n"+
            "* canFocus (boolean)\n"+
            "* tabIndex (number)\n"+
            "* accessKey (string)\n"+
            "* contextMenu (Menu)\n"+
            "* prompt (HTML string)\n"+
            "* canDrag (boolean)\n"+
            "* dragStartDistance (number)\n"+
            "* canDragScroll (boolean)\n"+
            "* dragScrollDelay (number)\n"+
            "* dragIntersectStyle (DragIntersectStyle string)\n"+
            "* canDragReposition (boolean)\n"+
            "* dragRepositionCursor (Cursor string)\n"+
            "* canDragResize (boolean)\n"+
            "* resizeFrom (array of EdgeName string)\n"+
            "* canHover (boolean)\n"+
            "* hoverDelay (number)\n"+
            "* showHover (boolean)\n"+
            "* hoverWidth (integer)\n"+
            "* hoverHeight (integer)\n"+
            "* hoverAlign (Alignment string)\n"+
            "* hoverVAlign (VerticalAlignment string)\n"+
            "* hoverWrap (boolean)\n"+
            "* hoverStyle (CSSStyleName string)\n"+
            "* hoverOpacity (number)\n"+
            "* hoverMoveWithMouse (boolean)\n"+
            "* edgeMarginSize (number)\n"+
            "* edgeCursorMap (object)\n"+
            "* keepInParentRect (boolean | array of integer)\n"+
            "* dragAppearance (DragAppearance string)\n"+
            "* dragType (string)\n"+
            "* dropTypes (array of string | string)\n"+
            "* dragTarget (Canvas | string)\n"+
            "* showDragShadow (boolean)\n"+
            "* dragOpacity (integer)\n"+
            "* canDrop (boolean)\n"+
            "* canAcceptDrop (boolean)\n"+
            "* canDropBefore (boolean)\n"+
            "* mouseStillDownInitialDelay (integer)\n"+
            "* mouseStillDownDelay (integer)\n"+
            "* doubleClickDelay (integer)\n"+
            "* noDoubleClicks (boolean)\n"+
            "* snapTo (string)\n"+
            "* snapOffsetLeft (integer)\n"+
            "* snapOffsetTop (integer)\n"+
            "* snapToGrid (boolean)\n"+
            "* snapResizeToGrid (boolean)\n"+
            "* childrenSnapToGrid (boolean)\n"+
            "* childrenSnapResizeToGrid (boolean)\n"+
            "* snapHGap (number)\n"+
            "* snapVGap (number)\n"+
            "* snapOnDrop (boolean)\n"+
            "* showPointer (boolean)\n"+
            "* pointerTarget (AutoTestLocator string | GlobalId string)\n"+
            "* pointerSettings (PointerSettings object)\n"+
            "* workflows (array of Process)\n"+
            "* borderRadius (string)\n"+
            "* showEdges (boolean)\n"+
            "* edgeBackgroundColor (CSSColor string)\n"+
            "* edgeOpacity (integer)\n"+
            "* edgeShowCenter (boolean)\n"+
            "* edgeCenterBackgroundColor (CSSColor string)\n"+
            "* showShadow (boolean)\n"+
            "* shadowDepth (number)\n"+
            "* shadowOffset (number)\n"+
            "* shadowSoftness (number)\n"+
            "* shadowImage (SCImgURL string)\n"+
            "* isGroup (boolean)\n"+
            "* groupTitle (HTML string)\n"+
            "* testDataContext (DataContext object)\n"+
            "* autoPopulateData (boolean)\n"+
            "* ruleScope (string)\n"+
            "* isRuleScope (boolean)\n"+
            "* valuesManager (ValuesManager | GlobalId string)\n"+
            "* dataPath (DataPath string)\n"+
            "* animateTime (number)\n"+
            "* animateAcceleration (AnimationAcceleration string)\n"+
            "* animateMoveTime (number)\n"+
            "* animateResizeTime (number)\n"+
            "* animateRectTime (number)\n"+
            "* animateFadeTime (number)\n"+
            "* animateScrollTime (number)\n"+
            "* animateShowTime (number)\n"+
            "* animateHideTime (number)\n"+
            "* animateMoveAcceleration (AnimationAcceleration string)\n"+
            "* animateResizeAcceleration (AnimationAcceleration string)\n"+
            "* animateRectAcceleration (AnimationAcceleration string)\n"+
            "* animateScrollAcceleration (AnimationAcceleration string)\n"+
            "* animateShowAcceleration (AnimationAcceleration string)\n"+
            "* animateHideAcceleration (AnimationAcceleration string)\n"+
            "* layoutAlign (Alignment string | VerticalAlignment string)\n"+
            "* showResizeBar (boolean)\n"+
            "* resizeBarTarget (string)\n"+
            "* extraSpace (positive integer)\n"+
            "\n"+
            "### Methods\n"+
            "* showNextTo()\n"+
            "* show()\n"+
            "* hide()\n"+
            "* print()\n",
        format:"Markdown"
    },
    "APIs list:Toolbar":{
        topic:"APIs list for Toolbar",
        content:"Only the following APIs are available on Toolbar:\n"+
            "\n"+
            "## Attributes\n"+
            "* buttons (array of Button properties objects)\n"+
            "* vertical (boolean)\n"+
            "* buttonConstructor (Class name string)\n"+
            "* canReorderItems (boolean)\n"+
            "* canResizeItems (boolean)\n"+
            "* canAcceptDrop (boolean)\n"+
            "* buttonDefaults (object)\n"+
            "\n"+
            "## Inherited from Layout\n"+
            "\n"+
            "### Attributes\n"+
            "* overflow (Overflow string)\n"+
            "\n"+
            "## Inherited from Canvas\n"+
            "\n"+
            "### Attributes\n"+
            "* ID (GlobalId string)\n"+
            "* autoDraw (boolean)\n"+
            "* htmlElement (DOMElement object | string)\n"+
            "* htmlPosition (DrawPosition string)\n"+
            "* matchElement (boolean)\n"+
            "* position (Positioning string)\n"+
            "* left (number | string)\n"+
            "* top (number | string)\n"+
            "* width (number | string)\n"+
            "* height (number | string)\n"+
            "* defaultWidth (integer)\n"+
            "* defaultHeight (integer)\n"+
            "* minWidth (number)\n"+
            "* minHeight (number)\n"+
            "* maxWidth (number)\n"+
            "* maxHeight (number)\n"+
            "* autoShowParent (boolean)\n"+
            "* visibility (Visibility string)\n"+
            "* canSelectText (boolean)\n"+
            "* styleName (CSSStyleName string)\n"+
            "* contents (HTML string)\n"+
            "* dynamicContents (boolean)\n"+
            "* dynamicContentsVars (ValueMap object)\n"+
            "* margin (number)\n"+
            "* padding (number)\n"+
            "* border (string)\n"+
            "* backgroundColor (CSSColor string)\n"+
            "* backgroundImage (SCImgURL string)\n"+
            "* backgroundRepeat (BackgroundRepeat string)\n"+
            "* appImgDir (URL string)\n"+
            "* skinImgDir (SCImgURL string)\n"+
            "* cursor (Cursor string)\n"+
            "* disabledCursor (Cursor string)\n"+
            "* opacity (number)\n"+
            "* showCustomScrollbars (boolean)\n"+
            "* scrollbarSize (number)\n"+
            "* disabled (boolean)\n"+
            "* visibleWhen (AdvancedCriteria object)\n"+
            "* enableWhen (AdvancedCriteria object)\n"+
            "* redrawOnResize (boolean)\n"+
            "* canFocus (boolean)\n"+
            "* tabIndex (number)\n"+
            "* accessKey (string)\n"+
            "* contextMenu (Menu)\n"+
            "* prompt (HTML string)\n"+
            "* canDrag (boolean)\n"+
            "* dragStartDistance (number)\n"+
            "* canDragScroll (boolean)\n"+
            "* dragScrollDelay (number)\n"+
            "* dragIntersectStyle (DragIntersectStyle string)\n"+
            "* canDragReposition (boolean)\n"+
            "* dragRepositionCursor (Cursor string)\n"+
            "* canDragResize (boolean)\n"+
            "* resizeFrom (array of EdgeName string)\n"+
            "* canHover (boolean)\n"+
            "* hoverDelay (number)\n"+
            "* showHover (boolean)\n"+
            "* hoverWidth (integer)\n"+
            "* hoverHeight (integer)\n"+
            "* hoverAlign (Alignment string)\n"+
            "* hoverVAlign (VerticalAlignment string)\n"+
            "* hoverWrap (boolean)\n"+
            "* hoverStyle (CSSStyleName string)\n"+
            "* hoverOpacity (number)\n"+
            "* hoverMoveWithMouse (boolean)\n"+
            "* edgeMarginSize (number)\n"+
            "* edgeCursorMap (object)\n"+
            "* keepInParentRect (boolean | array of integer)\n"+
            "* dragAppearance (DragAppearance string)\n"+
            "* dragType (string)\n"+
            "* dropTypes (array of string | string)\n"+
            "* dragTarget (Canvas | string)\n"+
            "* showDragShadow (boolean)\n"+
            "* dragOpacity (integer)\n"+
            "* canDrop (boolean)\n"+
            "* canDropBefore (boolean)\n"+
            "* mouseStillDownInitialDelay (integer)\n"+
            "* mouseStillDownDelay (integer)\n"+
            "* doubleClickDelay (integer)\n"+
            "* noDoubleClicks (boolean)\n"+
            "* snapTo (string)\n"+
            "* snapOffsetLeft (integer)\n"+
            "* snapOffsetTop (integer)\n"+
            "* snapToGrid (boolean)\n"+
            "* snapResizeToGrid (boolean)\n"+
            "* childrenSnapToGrid (boolean)\n"+
            "* childrenSnapResizeToGrid (boolean)\n"+
            "* snapHGap (number)\n"+
            "* snapVGap (number)\n"+
            "* snapOnDrop (boolean)\n"+
            "* showPointer (boolean)\n"+
            "* pointerTarget (AutoTestLocator string | GlobalId string)\n"+
            "* pointerSettings (PointerSettings object)\n"+
            "* workflows (array of Process)\n"+
            "* borderRadius (string)\n"+
            "* showEdges (boolean)\n"+
            "* edgeSize (number)\n"+
            "* edgeOffset (number)\n"+
            "* edgeImage (SCImgURL string)\n"+
            "* customEdges (array of string)\n"+
            "* edgeBackgroundColor (CSSColor string)\n"+
            "* edgeOpacity (integer)\n"+
            "* edgeShowCenter (boolean)\n"+
            "* edgeCenterBackgroundColor (CSSColor string)\n"+
            "* showShadow (boolean)\n"+
            "* shadowDepth (number)\n"+
            "* shadowOffset (number)\n"+
            "* shadowSoftness (number)\n"+
            "* shadowImage (SCImgURL string)\n"+
            "* isGroup (boolean)\n"+
            "* groupTitle (HTML string)\n"+
            "* testDataContext (DataContext object)\n"+
            "* autoPopulateData (boolean)\n"+
            "* ruleScope (string)\n"+
            "* isRuleScope (boolean)\n"+
            "* valuesManager (ValuesManager | GlobalId string)\n"+
            "* dataPath (DataPath string)\n"+
            "* animateTime (number)\n"+
            "* animateAcceleration (AnimationAcceleration string)\n"+
            "* animateMoveTime (number)\n"+
            "* animateResizeTime (number)\n"+
            "* animateRectTime (number)\n"+
            "* animateFadeTime (number)\n"+
            "* animateScrollTime (number)\n"+
            "* animateShowTime (number)\n"+
            "* animateHideTime (number)\n"+
            "* animateMoveAcceleration (AnimationAcceleration string)\n"+
            "* animateResizeAcceleration (AnimationAcceleration string)\n"+
            "* animateRectAcceleration (AnimationAcceleration string)\n"+
            "* animateScrollAcceleration (AnimationAcceleration string)\n"+
            "* animateShowAcceleration (AnimationAcceleration string)\n"+
            "* animateHideAcceleration (AnimationAcceleration string)\n"+
            "* layoutAlign (Alignment string | VerticalAlignment string)\n"+
            "* showResizeBar (boolean)\n"+
            "* resizeBarTarget (string)\n"+
            "* extraSpace (positive integer)\n"+
            "\n"+
            "### Methods\n"+
            "* showNextTo()\n"+
            "* show()\n"+
            "* hide()\n"+
            "* print()\n",
        format:"Markdown"
    },
    "APIs list:DataSource":{
        topic:"APIs list for DataSource",
        content:"Only the following APIs are available on DataSource:\n"+
            "\n"+
            "## Attributes\n"+
            "* serverConfig (DataSource properties object)\n"+
            "* headers (object)\n"+
            "* params (object)\n"+
            "* httpMethod (string)\n"+
            "* requestFormat (RESTRequestFormat string)\n"+
            "* responseFormat (RESTResponseFormat string)\n"+
            "* wrapInList (boolean)\n"+
            "* requestTemplate (string)\n"+
            "* responseTemplate (string)\n"+
            "* requiresCompleteRESTResponse (boolean)\n"+
            "* ID (Identifier string)\n"+
            "* description (string)\n"+
            "* addGlobalId (boolean)\n"+
            "* dataFormat (DSDataFormat string)\n"+
            "* useStrictJSON (boolean)\n"+
            "* dataProtocol (DSProtocol string)\n"+
            "* callbackParam (string)\n"+
            "* requestProperties (DSRequest properties object)\n"+
            "* dataTransport (RPCTransport string)\n"+
            "* serverType (DSServerType string)\n"+
            "* tableName (string)\n"+
            "* schema (string)\n"+
            "* quoteTableName (boolean)\n"+
            "* relatedTableAlias (string)\n"+
            "* dbName (string)\n"+
            "* quoteColumnNames (boolean)\n"+
            "* logSlowSQL (integer)\n"+
            "* logSlowFetch (integer)\n"+
            "* logSlowAdd (integer)\n"+
            "* logSlowUpdate (integer)\n"+
            "* logSlowRemove (integer)\n"+
            "* logSlowCustom (integer)\n"+
            "* jsonPrefix (string)\n"+
            "* jsonSuffix (string)\n"+
            "* fields (array of DataSourceField objects)\n"+
            "* inheritsFrom (DataSource ID string)\n"+
            "* auditedDataSourceID (string)\n"+
            "* addedAuditFields (array of DataSourceField objects)\n"+
            "* inheritanceMode (DSInheritanceMode string)\n"+
            "* useFlatFields (boolean)\n"+
            "* showLocalFieldsOnly (boolean)\n"+
            "* useParentFieldOrder (boolean)\n"+
            "* dropExtraFields (boolean)\n"+
            "* autoDeriveSchema (boolean)\n"+
            "* schemaBean (string)\n"+
            "* idClassName (string)\n"+
            "* patternSingleWildcard (string | array of string)\n"+
            "* patternMultiWildcard (string | array of string)\n"+
            "* translatePatternOperators (boolean)\n"+
            "* xmlNamespaces (object)\n"+
            "* serviceNamespace (URN)\n"+
            "* schemaNamespace (URN)\n"+
            "* recordXPath (XPathExpression string)\n"+
            "* dataURL (URL string)\n"+
            "* tagName (string)\n"+
            "* useOfflineStorage (boolean)\n"+
            "* clientOnly (boolean)\n"+
            "* mockMode (boolean)\n"+
            "* mockDataRows (integer)\n"+
            "* mockDataCriteria (Criteria object)\n"+
            "* criteriaPolicy (CriteriaPolicy string)\n"+
            "* defaultTextMatchStyle (TextMatchStyle string)\n"+
            "* ignoreTextMatchStyleCaseSensitive (boolean)\n"+
            "* arrayCriteriaForceExact (boolean)\n"+
            "* useLocalValidators (boolean)\n"+
            "* requiredMessage (HTML string)\n"+
            "* showPrompt (boolean)\n"+
            "* enumTranslateStrategy (EnumTranslateStrategy string)\n"+
            "* enumOrdinalProperty (string)\n"+
            "* autoDeriveTitles (boolean)\n"+
            "* sparseUpdates (boolean)\n"+
            "* noNullUpdates (boolean)\n"+
            "* requiresAuthentication (boolean)\n"+
            "* requiresRole (string)\n"+
            "* requires (VelocityExpression string)\n"+
            "* creatorOverrides (boolean)\n"+
            "* ownerIdField (string)\n"+
            "* guestUserId (string)\n"+
            "* ownerIdNullRole (string)\n"+
            "* ownerIdNullAccess (NullAccessType string)\n"+
            "* autoJoinTransactions (boolean)\n"+
            "* useSpringTransaction (boolean)\n"+
            "* tableCode (string)\n"+
            "* progressiveLoading (boolean)\n"+
            "* clientRequestMaxRows (integer)\n"+
            "* requestMaxRows (integer)\n"+
            "* cacheAllData (boolean)\n"+
            "* cacheAcrossOperationIds (boolean)\n"+
            "* cacheData (array of Record objects)\n"+
            "* autoConvertRelativeDates (boolean)\n"+
            "* useAnsiJoins (boolean)\n"+
            "* audit (boolean)\n"+
            "* auditDataSourceID (string)\n"+
            "* auditUserFieldName (string)\n"+
            "* auditTimeStampFieldName (string)\n"+
            "* auditRevisionFieldName (string)\n"+
            "* auditChangedFieldsFieldLength (integer)\n"+
            "* auditTypeFieldName (string)\n"+
            "* auditDSConstructor (string)\n"+
            "* autoCreateAuditTable (boolean)\n"+
            "* compareMetadataForAuditChangeStatus (boolean)\n"+
            "* unionOf (string)\n"+
            "* unionFields (string)\n"+
            "* defaultUnionFieldsStrategy (UnionFieldsStrategy string)\n"+
            "* title (string)\n"+
            "* pluralTitle (string)\n"+
            "* titleField (string)\n"+
            "* serverConstructor (string)\n"+
            "* qualifyColumnNames (boolean)\n"+
            "* validateRelatedRecords (boolean)\n"+
            "* beanClassName (string)\n"+
            "* implicitCriteria (Criteria object)\n"+
            "* globalNamespaces (object)\n"+
            "* fileNameField (string)\n"+
            "* fileTypeField (string)\n"+
            "* fileFormatField (string)\n"+
            "* fileContentsField (string)\n"+
            "* fileLastModifiedField (string)\n"+
            "* fileVersionField (string)\n"+
            "* projectFileKey (string)\n"+
            "* projectFileLocations (array of string)\n"+
            "* isSampleDS (boolean)\n"+
            "* script (string)\n"+
            "* transformRequestScript (string)\n"+
            "* transformResponseScript (string)\n"+
            "* serverObject (ServerObject object)\n"+
            "* operationBindings (array of OperationBinding)\n"+
            "* allowClientRequestedSummaries (boolean)\n"+
            "* recordName (string)\n"+
            "* cacheSyncStrategy (CacheSyncStrategy string)\n"+
            "* cacheSyncTiming (CacheSyncTiming string)\n"+
            "* defaultMultiUpdatePolicy (MultiUpdatePolicy string)\n"+
            "* dropUnknownCriteria (boolean)\n"+
            "* strictSQLFiltering (boolean)\n"+
            "* allowAdvancedCriteria (boolean)\n"+
            "* allowAggregation (boolean)\n"+
            "* suppressManualAggregation (string)\n"+
            "* allowDynamicTreeJoins (boolean)\n",
        format:"Markdown"
    },
    "APIs list:DataSourceField":{
        topic:"APIs list for DataSourceField",
        content:"Only the following APIs are available on DataSourceField:\n"+
            "\n"+
            "## Attributes\n"+
            "* columnCode (string)\n"+
            "* name (FieldName string)\n"+
            "* description (string)\n"+
            "* type (FieldType string)\n"+
            "* mimeType (string)\n"+
            "* required (boolean)\n"+
            "* requiredMessage (string)\n"+
            "* nillable (boolean)\n"+
            "* valueMap (ValueMap object)\n"+
            "* valueMapEnum (string)\n"+
            "* validators (array of Validator)\n"+
            "* length (number)\n"+
            "* valueXPath (XPathExpression string)\n"+
            "* valueWriteXPath (XPathExpression string)\n"+
            "* title (HTML string)\n"+
            "* escapeHTML (boolean)\n"+
            "* canView (boolean)\n"+
            "* canEdit (boolean)\n"+
            "* canSave (boolean)\n"+
            "* canFilter (boolean)\n"+
            "* decimalPrecision (number)\n"+
            "* decimalPad (number)\n"+
            "* precision (number)\n"+
            "* ignore (boolean)\n"+
            "* detail (boolean)\n"+
            "* primaryKey (boolean)\n"+
            "* foreignKey (string)\n"+
            "* childrenProperty (boolean)\n"+
            "* rootValue (Any)\n"+
            "* sequenceName (string)\n"+
            "* includeFrom (string)\n"+
            "* includeVia (string)\n"+
            "* relatedTableAlias (string)\n"+
            "* otherFKs (string)\n"+
            "* displayField (string)\n"+
            "* useLocalDisplayFieldValue (boolean)\n"+
            "* foreignDisplayField (string)\n"+
            "* joinType (JoinType string)\n"+
            "* summaryFunction (SummaryFunction string)\n"+
            "* valueOperation (string)\n"+
            "* xmlAttribute (boolean)\n"+
            "* childTagName (string)\n"+
            "* group (string)\n"+
            "* recreateOnChange (boolean)\n"+
            "* multiple (boolean)\n"+
            "* multipleStorage (MultipleFieldStorage string)\n"+
            "* multipleStorageSeparator (string)\n"+
            "* javaClass (string)\n"+
            "* javaCollectionClass (string)\n"+
            "* javaKeyClass (string)\n"+
            "* exportTitle (string)\n"+
            "* canExport (boolean)\n"+
            "* uploadFieldName (string)\n"+
            "* batchUploadOperationId (string)\n"+
            "* batchUploadCaseSensitive (boolean)\n"+
            "* showFileInline (boolean)\n"+
            "* imageWidth (number | string)\n"+
            "* imageHeight (number | string)\n"+
            "* viewRequiresAuthentication (boolean)\n"+
            "* editRequiresAuthentication (boolean)\n"+
            "* initRequiresAuthentication (boolean)\n"+
            "* updateRequiresAuthentication (boolean)\n"+
            "* viewRequiresRole (string)\n"+
            "* editRequiresRole (string)\n"+
            "* initRequiresRole (string)\n"+
            "* updateRequiresRole (string)\n"+
            "* viewRequires (VelocityExpression string)\n"+
            "* editRequires (VelocityExpression string)\n"+
            "* initRequires (VelocityExpression string)\n"+
            "* updateRequires (VelocityExpression string)\n"+
            "* creatorOverrides (boolean)\n"+
            "* translatorClassName (string)\n"+
            "* audit (FieldAuditMode string)\n"+
            "* customSQL (boolean)\n"+
            "* customSelectExpression (VelocityExpression string)\n"+
            "* customUpdateExpression (VelocityExpression string)\n"+
            "* customInsertExpression (VelocityExpression string)\n"+
            "* customCriteriaExpression (VelocityExpression string)\n"+
            "* autoQuoteCustomExpressions (boolean)\n"+
            "* outputWhen (OutputWhen string)\n"+
            "* nativeName (string)\n"+
            "* tableName (string)\n"+
            "* unionOf (string)\n"+
            "* importStrategyFailedErrorMessage (string)\n"+
            "* sqlStorageStrategy (string)\n"+
            "* sqlDateFormat (string)\n"+
            "* storeMilliseconds (boolean)\n"+
            "* sqlTrueValue (string)\n"+
            "* sqlFalseValue (string)\n"+
            "* stringInBrowser (boolean)\n"+
            "* sortByField (string)\n"+
            "* ignoreTextMatchStyle (boolean)\n"+
            "* canSortClientOnly (boolean)\n"+
            "* storeWithHash (HashAlgorithm string)\n"+
            "* maxFileSize (integer)\n"+
            "* encodeInResponse (boolean)\n"+
            "* format (FormatString string)\n"+
            "* exportFormat (FormatString string)\n"+
            "* fieldValueScript (string)\n"+
            "* includeSummaryFunction (SummaryFunction string)\n"+
            "* joinPrefix (string)\n"+
            "* joinString (string)\n"+
            "* joinSuffix (string)\n"+
            "* allowClientRequestedSummaries (boolean)\n"+
            "* validOperators (array of OperatorId string)\n"+
            "* filterOn (FieldFilterMode string)\n",
        format:"Markdown"
    },
    "APIs list:OperationBinding":{
        topic:"APIs list for OperationBinding",
        content:"Only the following APIs are available on OperationBinding:\n"+
            "\n"+
            "## Attributes\n"+
            "* headers (string)\n"+
            "* params (string)\n"+
            "* httpMethod (string)\n"+
            "* requestFormat (RESTRequestFormat string)\n"+
            "* responseFormat (RESTResponseFormat string)\n"+
            "* wrapInList (boolean)\n"+
            "* requestTemplate (string)\n"+
            "* responseTemplate (string)\n"+
            "* requiresCompleteRESTResponse (string)\n"+
            "* arrayCriteriaForceExact (boolean)\n"+
            "* skipAudit (boolean)\n"+
            "* unionFields (string)\n"+
            "* beanClassName (string)\n"+
            "* operationType (DSOperationType string)\n"+
            "* operationId (string)\n"+
            "* description (string)\n"+
            "* requiredCriterion (string)\n"+
            "* serverMethod (string)\n"+
            "* methodArguments (string)\n"+
            "* serverObject (ServerObject object)\n"+
            "* script (string)\n"+
            "* transformRequestScript (string)\n"+
            "* transformResponseScript (string)\n"+
            "* isDDL (boolean)\n"+
            "* wsOperation (string)\n"+
            "* dataURL (URL string)\n"+
            "* dataProtocol (DSProtocol string)\n"+
            "* dataFormat (DSDataFormat string)\n"+
            "* dataTransport (RPCTransport string)\n"+
            "* callbackParam (string)\n"+
            "* requestProperties (DSRequest properties object)\n"+
            "* preventHTTPCaching (boolean)\n"+
            "* defaultParams (object)\n"+
            "* useFlatFields (boolean)\n"+
            "* summaryFunctions (object)\n"+
            "* groupBy (array of string)\n"+
            "* recordXPath (XPathExpression string)\n"+
            "* recordName (string)\n"+
            "* spoofResponses (boolean)\n"+
            "* xmlNamespaces (object)\n"+
            "* responseDataSchema (DataSource)\n"+
            "* exportResults (boolean)\n"+
            "* exportAs (ExportFormat string)\n"+
            "* exportFilename (string)\n"+
            "* lineBreakStyle (string)\n"+
            "* autoJoinTransactions (boolean)\n"+
            "* useSpringTransaction (boolean)\n"+
            "* includeAnsiJoinsInTableClause (boolean)\n"+
            "* selectClause (VelocityExpression string)\n"+
            "* tableClause (VelocityExpression string)\n"+
            "* whereClause (VelocityExpression string)\n"+
            "* groupClause (VelocityExpression string)\n"+
            "* orderClause (VelocityExpression string)\n"+
            "* valuesClause (VelocityExpression string)\n"+
            "* applyCriteriaBeforeAggregation (boolean)\n"+
            "* useHavingClause (boolean)\n"+
            "* customSQL (VelocityExpression string)\n"+
            "* customHQL (string)\n"+
            "* customJQL (string)\n"+
            "* skipRowCount (boolean)\n"+
            "* customFields (string | array)\n"+
            "* customValueFields (string | array)\n"+
            "* customCriteriaFields (string | array)\n"+
            "* excludeCriteriaFields (string | array)\n"+
            "* useForCacheSync (boolean)\n"+
            "* cacheSyncOperation (string)\n"+
            "* canSyncCache (boolean)\n"+
            "* cacheSyncStrategy (CacheSyncStrategy string)\n"+
            "* cacheSyncTiming (CacheSyncTiming string)\n"+
            "* sqlType (SQLType string)\n"+
            "* allowMultiUpdate (boolean)\n"+
            "* providesMissingKeys (boolean)\n"+
            "* qualifyColumnNames (boolean)\n"+
            "* outputs (string)\n"+
            "* progressiveLoading (boolean)\n"+
            "* allowAdvancedCriteria (boolean)\n"+
            "* criteria (array of DSRequestModifier objects)\n"+
            "* values (array of DSRequestModifier objects)\n"+
            "* requiresAuthentication (boolean)\n"+
            "* requiresRole (string)\n"+
            "* requires (VelocityExpression string)\n"+
            "* creatorOverrides (boolean)\n"+
            "* ownerIdField (string)\n"+
            "* guestUserId (string)\n"+
            "* mail (Mail)\n",
        format:"Markdown"
    },
    "APIs list:DSRequest":{
        topic:"APIs list for DSRequest",
        content:"Only the following APIs are available on DSRequest:\n"+
            "\n"+
            "## Attributes\n"+
            "* startRow (number)\n"+
            "* endRow (number)\n"+
            "* sortBy (FieldName string | array of FieldName string | array of SortSpecifier objects)\n"+
            "* summaryFunctions (object)\n"+
            "* groupBy (array of string)\n"+
            "* applyCriteriaBeforeAggregation (boolean)\n"+
            "* exportAs (ExportFormat string)\n"+
            "* exportDisplay (ExportDisplay string)\n",
        format:"Markdown"
    },
    "APIs list:AdvancedCriteria":{
        topic:"APIs list for AdvancedCriteria",
        content:"Only the following APIs are available on AdvancedCriteria:\n"+
            "\n"+
            "## Attributes\n"+
            "* strictSQLFiltering (boolean)\n",
        format:"Markdown"
    },
    "APIs list:FilterBuilder":{
        topic:"APIs list for FilterBuilder",
        content:"Only the following APIs are available on FilterBuilder:\n"+
            "\n"+
            "## Attributes\n"+
            "* criteria (AdvancedCriteria object)\n"+
            "\n"+
            "## Inherited from Layout\n"+
            "\n"+
            "### Attributes\n"+
            "* members (array of Canvas)\n"+
            "* overflow (Overflow string)\n"+
            "* vertical (boolean)\n"+
            "* vPolicy (LayoutPolicy string)\n"+
            "* hPolicy (LayoutPolicy string)\n"+
            "* minMemberLength (integer)\n"+
            "* minBreadthMember (string | integer | Canvas)\n"+
            "* enforcePolicy (boolean)\n"+
            "* defaultLayoutAlign (Alignment string | VerticalAlignment string)\n"+
            "* align (Alignment string | VerticalAlignment string)\n"+
            "* reverseOrder (boolean)\n"+
            "* paddingAsLayoutMargin (boolean)\n"+
            "* layoutMargin (integer)\n"+
            "* layoutLeftMargin (integer)\n"+
            "* layoutRightMargin (integer)\n"+
            "* layoutTopMargin (integer)\n"+
            "* layoutBottomMargin (integer)\n"+
            "* membersMargin (integer)\n"+
            "* leaveScrollbarGap (boolean)\n"+
            "* resizeBarClass (string)\n"+
            "* resizeBarSize (integer)\n"+
            "* animateMembers (boolean)\n"+
            "* animateMemberTime (number)\n"+
            "* canDropComponents (boolean)\n"+
            "* dropLineThickness (number)\n"+
            "* showDragPlaceHolder (boolean)\n"+
            "* placeHolderProperties (Canvas properties object)\n"+
            "* placeHolderDefaults (Canvas properties object)\n"+
            "\n"+
            "## Inherited from Canvas\n"+
            "\n"+
            "### Attributes\n"+
            "* ID (GlobalId string)\n"+
            "* autoDraw (boolean)\n"+
            "* children (array of Canvas)\n"+
            "* peers (array of Canvas)\n"+
            "* htmlElement (DOMElement object | string)\n"+
            "* htmlPosition (DrawPosition string)\n"+
            "* matchElement (boolean)\n"+
            "* position (Positioning string)\n"+
            "* left (number | string)\n"+
            "* top (number | string)\n"+
            "* width (number | string)\n"+
            "* height (number | string)\n"+
            "* defaultWidth (integer)\n"+
            "* defaultHeight (integer)\n"+
            "* minWidth (number)\n"+
            "* minHeight (number)\n"+
            "* maxWidth (number)\n"+
            "* maxHeight (number)\n"+
            "* autoShowParent (boolean)\n"+
            "* visibility (Visibility string)\n"+
            "* canSelectText (boolean)\n"+
            "* styleName (CSSStyleName string)\n"+
            "* contents (HTML string)\n"+
            "* dynamicContents (boolean)\n"+
            "* dynamicContentsVars (ValueMap object)\n"+
            "* margin (number)\n"+
            "* padding (number)\n"+
            "* border (string)\n"+
            "* backgroundColor (CSSColor string)\n"+
            "* backgroundImage (SCImgURL string)\n"+
            "* backgroundRepeat (BackgroundRepeat string)\n"+
            "* appImgDir (URL string)\n"+
            "* skinImgDir (SCImgURL string)\n"+
            "* cursor (Cursor string)\n"+
            "* disabledCursor (Cursor string)\n"+
            "* opacity (number)\n"+
            "* showCustomScrollbars (boolean)\n"+
            "* scrollbarSize (number)\n"+
            "* disabled (boolean)\n"+
            "* visibleWhen (AdvancedCriteria object)\n"+
            "* enableWhen (AdvancedCriteria object)\n"+
            "* redrawOnResize (boolean)\n"+
            "* canFocus (boolean)\n"+
            "* tabIndex (number)\n"+
            "* accessKey (string)\n"+
            "* contextMenu (Menu)\n"+
            "* prompt (HTML string)\n"+
            "* canDrag (boolean)\n"+
            "* dragStartDistance (number)\n"+
            "* canDragScroll (boolean)\n"+
            "* dragScrollDelay (number)\n"+
            "* dragIntersectStyle (DragIntersectStyle string)\n"+
            "* canDragReposition (boolean)\n"+
            "* dragRepositionCursor (Cursor string)\n"+
            "* canDragResize (boolean)\n"+
            "* resizeFrom (array of EdgeName string)\n"+
            "* canHover (boolean)\n"+
            "* hoverDelay (number)\n"+
            "* showHover (boolean)\n"+
            "* hoverWidth (integer)\n"+
            "* hoverHeight (integer)\n"+
            "* hoverAlign (Alignment string)\n"+
            "* hoverVAlign (VerticalAlignment string)\n"+
            "* hoverWrap (boolean)\n"+
            "* hoverStyle (CSSStyleName string)\n"+
            "* hoverOpacity (number)\n"+
            "* hoverMoveWithMouse (boolean)\n"+
            "* edgeMarginSize (number)\n"+
            "* edgeCursorMap (object)\n"+
            "* keepInParentRect (boolean | array of integer)\n"+
            "* dragAppearance (DragAppearance string)\n"+
            "* dragType (string)\n"+
            "* dropTypes (array of string | string)\n"+
            "* dragTarget (Canvas | string)\n"+
            "* showDragShadow (boolean)\n"+
            "* dragOpacity (integer)\n"+
            "* canDrop (boolean)\n"+
            "* canAcceptDrop (boolean)\n"+
            "* canDropBefore (boolean)\n"+
            "* mouseStillDownInitialDelay (integer)\n"+
            "* mouseStillDownDelay (integer)\n"+
            "* doubleClickDelay (integer)\n"+
            "* noDoubleClicks (boolean)\n"+
            "* snapTo (string)\n"+
            "* snapOffsetLeft (integer)\n"+
            "* snapOffsetTop (integer)\n"+
            "* snapToGrid (boolean)\n"+
            "* snapResizeToGrid (boolean)\n"+
            "* childrenSnapToGrid (boolean)\n"+
            "* childrenSnapResizeToGrid (boolean)\n"+
            "* snapHGap (number)\n"+
            "* snapVGap (number)\n"+
            "* snapOnDrop (boolean)\n"+
            "* showPointer (boolean)\n"+
            "* pointerTarget (AutoTestLocator string | GlobalId string)\n"+
            "* pointerSettings (PointerSettings object)\n"+
            "* workflows (array of Process)\n"+
            "* borderRadius (string)\n"+
            "* showEdges (boolean)\n"+
            "* edgeSize (number)\n"+
            "* edgeOffset (number)\n"+
            "* edgeImage (SCImgURL string)\n"+
            "* customEdges (array of string)\n"+
            "* edgeBackgroundColor (CSSColor string)\n"+
            "* edgeOpacity (integer)\n"+
            "* edgeShowCenter (boolean)\n"+
            "* edgeCenterBackgroundColor (CSSColor string)\n"+
            "* showShadow (boolean)\n"+
            "* shadowDepth (number)\n"+
            "* shadowOffset (number)\n"+
            "* shadowSoftness (number)\n"+
            "* shadowImage (SCImgURL string)\n"+
            "* isGroup (boolean)\n"+
            "* groupTitle (HTML string)\n"+
            "* testDataContext (DataContext object)\n"+
            "* autoPopulateData (boolean)\n"+
            "* ruleScope (string)\n"+
            "* isRuleScope (boolean)\n"+
            "* valuesManager (ValuesManager | GlobalId string)\n"+
            "* dataPath (DataPath string)\n"+
            "* animateTime (number)\n"+
            "* animateAcceleration (AnimationAcceleration string)\n"+
            "* animateMoveTime (number)\n"+
            "* animateResizeTime (number)\n"+
            "* animateRectTime (number)\n"+
            "* animateFadeTime (number)\n"+
            "* animateScrollTime (number)\n"+
            "* animateShowTime (number)\n"+
            "* animateHideTime (number)\n"+
            "* animateMoveAcceleration (AnimationAcceleration string)\n"+
            "* animateResizeAcceleration (AnimationAcceleration string)\n"+
            "* animateRectAcceleration (AnimationAcceleration string)\n"+
            "* animateScrollAcceleration (AnimationAcceleration string)\n"+
            "* animateShowAcceleration (AnimationAcceleration string)\n"+
            "* animateHideAcceleration (AnimationAcceleration string)\n"+
            "* layoutAlign (Alignment string | VerticalAlignment string)\n"+
            "* showResizeBar (boolean)\n"+
            "* resizeBarTarget (string)\n"+
            "* extraSpace (positive integer)\n"+
            "\n"+
            "### Methods\n"+
            "* showNextTo()\n"+
            "* show()\n"+
            "* hide()\n"+
            "* print()\n",
        format:"Markdown"
    },
    "APIs list:SearchForm":{
        topic:"APIs list for SearchForm",
        content:"Only the following APIs are available on SearchForm:\n"+
            "\n"+
            "## Attributes\n"+
            "* searchOnEnter (boolean)\n"+
            "* criteriaChangedDelay (integer)\n"+
            "\n"+
            "## Methods\n"+
            "* search()\n"+
            "* criteriaChanged()\n"+
            "\n"+
            "## Inherited from DynamicForm\n"+
            "\n"+
            "### Attributes\n"+
            "* autoFetchData (boolean)\n"+
            "* autoFetchTextMatchStyle (TextMatchStyle string)\n"+
            "* fetchRequestProperties (DSRequest properties object)\n"+
            "* initialCriteria (Criteria object)\n"+
            "* implicitCriteria (Criteria object)\n"+
            "* items (array of FormItem properties objects)\n"+
            "* fields (array of FormItem properties objects)\n"+
            "* initialSort (array of SortSpecifier objects)\n"+
            "* values (object)\n"+
            "* itemLayout (FormLayoutType)\n"+
            "* linearMode (boolean)\n"+
            "* linearOnMobile (boolean)\n"+
            "* numCols (number)\n"+
            "* linearNumCols (number)\n"+
            "* fixedColWidths (boolean)\n"+
            "* colWidths (array)\n"+
            "* minColWidth (number)\n"+
            "* cellPadding (number)\n"+
            "* cellBorder (number)\n"+
            "* sectionVisibilityMode (VisibilityMode string)\n"+
            "* longTextEditorThreshold (number)\n"+
            "* longTextEditorType (string)\n"+
            "* valuesManager (ValuesManager | GlobalId string)\n"+
            "* titleOrientation (TitleOrientation string)\n"+
            "* titlePrefix (HTML string)\n"+
            "* rightTitlePrefix (HTML string)\n"+
            "* titleSuffix (HTML string)\n"+
            "* rightTitleSuffix (HTML string)\n"+
            "* titleWidth (number | the literal string \"*\")\n"+
            "* wrapItemTitles (boolean)\n"+
            "* showInlineErrors (boolean)\n"+
            "* showErrorIcons (boolean)\n"+
            "* showErrorText (boolean)\n"+
            "* showErrorStyle (boolean)\n"+
            "* errorOrientation (Align)\n"+
            "* errorItemProperties (object)\n"+
            "* errorItemCellStyle (string)\n"+
            "* errorsPreamble (HTML string)\n"+
            "* showTitlesWithErrorMessages (boolean)\n"+
            "* hiliteRequiredFields (boolean)\n"+
            "* requiredTitlePrefix (HTML string)\n"+
            "* requiredRightTitlePrefix (HTML string)\n"+
            "* requiredTitleSuffix (HTML string)\n"+
            "* requiredRightTitleSuffix (HTML string)\n"+
            "* canEdit (boolean)\n"+
            "* readOnlyDisplay (ReadOnlyDisplayAppearance string)\n"+
            "* readOnlyTextBoxStyle (FormItemBaseStyle string)\n"+
            "* itemHoverDelay (number)\n"+
            "* itemHoverWidth (number | string)\n"+
            "* itemHoverHeight (number | string)\n"+
            "* itemHoverAlign (Alignment string)\n"+
            "* itemHoverVAlign (number | string)\n"+
            "* itemHoverStyle (CSSStyleName string)\n"+
            "* itemHoverOpacity (number)\n"+
            "* errors (object)\n"+
            "* validateOnChange (boolean)\n"+
            "* unknownErrorMessage (HTML string)\n"+
            "* autoFocus (boolean)\n"+
            "* autoFocusOnError (boolean)\n"+
            "* selectOnFocus (boolean)\n"+
            "* canFocus (boolean)\n"+
            "* autoComplete (AutoComplete string)\n"+
            "* browserSpellCheck (boolean)\n"+
            "* validationURL (URL string)\n"+
            "* action (URL string)\n"+
            "* target (string)\n"+
            "* method (FormMethod string)\n"+
            "* encoding (Encoding string)\n"+
            "* canSubmit (boolean)\n"+
            "* dataSource (DataSource | ID string)\n"+
            "* dataArity (string)\n"+
            "* titleAlign (Alignment string)\n"+
            "\n"+
            "### Methods\n"+
            "* editNewRecord()\n"+
            "* editSelectedData()\n"+
            "* reset()\n"+
            "* saveData()\n"+
            "* viewSelectedData()\n"+
            "* setValues()\n"+
            "* clearValues()\n"+
            "* validate()\n"+
            "* itemChanged()\n"+
            "\n"+
            "## Inherited from Canvas\n"+
            "\n"+
            "### Attributes\n"+
            "* ID (GlobalId string)\n"+
            "* autoDraw (boolean)\n"+
            "* htmlElement (DOMElement object | string)\n"+
            "* htmlPosition (DrawPosition string)\n"+
            "* matchElement (boolean)\n"+
            "* position (Positioning string)\n"+
            "* left (number | string)\n"+
            "* top (number | string)\n"+
            "* width (number | string)\n"+
            "* height (number | string)\n"+
            "* defaultWidth (integer)\n"+
            "* defaultHeight (integer)\n"+
            "* minWidth (number)\n"+
            "* minHeight (number)\n"+
            "* maxWidth (number)\n"+
            "* maxHeight (number)\n"+
            "* autoShowParent (boolean)\n"+
            "* visibility (Visibility string)\n"+
            "* canSelectText (boolean)\n"+
            "* styleName (CSSStyleName string)\n"+
            "* contents (HTML string)\n"+
            "* dynamicContents (boolean)\n"+
            "* dynamicContentsVars (ValueMap object)\n"+
            "* margin (number)\n"+
            "* padding (number)\n"+
            "* border (string)\n"+
            "* backgroundColor (CSSColor string)\n"+
            "* backgroundImage (SCImgURL string)\n"+
            "* backgroundRepeat (BackgroundRepeat string)\n"+
            "* appImgDir (URL string)\n"+
            "* skinImgDir (SCImgURL string)\n"+
            "* cursor (Cursor string)\n"+
            "* disabledCursor (Cursor string)\n"+
            "* opacity (number)\n"+
            "* overflow (Overflow string)\n"+
            "* showCustomScrollbars (boolean)\n"+
            "* scrollbarSize (number)\n"+
            "* disabled (boolean)\n"+
            "* visibleWhen (AdvancedCriteria object)\n"+
            "* enableWhen (AdvancedCriteria object)\n"+
            "* redrawOnResize (boolean)\n"+
            "* tabIndex (number)\n"+
            "* accessKey (string)\n"+
            "* contextMenu (Menu)\n"+
            "* prompt (HTML string)\n"+
            "* canDrag (boolean)\n"+
            "* dragStartDistance (number)\n"+
            "* canDragScroll (boolean)\n"+
            "* dragScrollDelay (number)\n"+
            "* dragIntersectStyle (DragIntersectStyle string)\n"+
            "* canDragReposition (boolean)\n"+
            "* dragRepositionCursor (Cursor string)\n"+
            "* canDragResize (boolean)\n"+
            "* resizeFrom (array of EdgeName string)\n"+
            "* canHover (boolean)\n"+
            "* hoverDelay (number)\n"+
            "* showHover (boolean)\n"+
            "* hoverWidth (integer)\n"+
            "* hoverHeight (integer)\n"+
            "* hoverAlign (Alignment string)\n"+
            "* hoverVAlign (VerticalAlignment string)\n"+
            "* hoverWrap (boolean)\n"+
            "* hoverStyle (CSSStyleName string)\n"+
            "* hoverOpacity (number)\n"+
            "* hoverMoveWithMouse (boolean)\n"+
            "* edgeMarginSize (number)\n"+
            "* edgeCursorMap (object)\n"+
            "* keepInParentRect (boolean | array of integer)\n"+
            "* dragAppearance (DragAppearance string)\n"+
            "* dragType (string)\n"+
            "* dropTypes (array of string | string)\n"+
            "* dragTarget (Canvas | string)\n"+
            "* showDragShadow (boolean)\n"+
            "* dragOpacity (integer)\n"+
            "* canDrop (boolean)\n"+
            "* canAcceptDrop (boolean)\n"+
            "* canDropBefore (boolean)\n"+
            "* mouseStillDownInitialDelay (integer)\n"+
            "* mouseStillDownDelay (integer)\n"+
            "* doubleClickDelay (integer)\n"+
            "* noDoubleClicks (boolean)\n"+
            "* snapTo (string)\n"+
            "* snapOffsetLeft (integer)\n"+
            "* snapOffsetTop (integer)\n"+
            "* snapToGrid (boolean)\n"+
            "* snapResizeToGrid (boolean)\n"+
            "* childrenSnapToGrid (boolean)\n"+
            "* childrenSnapResizeToGrid (boolean)\n"+
            "* snapHGap (number)\n"+
            "* snapVGap (number)\n"+
            "* snapOnDrop (boolean)\n"+
            "* showPointer (boolean)\n"+
            "* pointerTarget (AutoTestLocator string | GlobalId string)\n"+
            "* pointerSettings (PointerSettings object)\n"+
            "* workflows (array of Process)\n"+
            "* borderRadius (string)\n"+
            "* showEdges (boolean)\n"+
            "* edgeSize (number)\n"+
            "* edgeOffset (number)\n"+
            "* edgeImage (SCImgURL string)\n"+
            "* customEdges (array of string)\n"+
            "* edgeBackgroundColor (CSSColor string)\n"+
            "* edgeOpacity (integer)\n"+
            "* edgeShowCenter (boolean)\n"+
            "* edgeCenterBackgroundColor (CSSColor string)\n"+
            "* showShadow (boolean)\n"+
            "* shadowDepth (number)\n"+
            "* shadowOffset (number)\n"+
            "* shadowSoftness (number)\n"+
            "* shadowImage (SCImgURL string)\n"+
            "* isGroup (boolean)\n"+
            "* groupTitle (HTML string)\n"+
            "* testDataContext (DataContext object)\n"+
            "* autoPopulateData (boolean)\n"+
            "* ruleScope (string)\n"+
            "* isRuleScope (boolean)\n"+
            "* dataPath (DataPath string)\n"+
            "* animateTime (number)\n"+
            "* animateAcceleration (AnimationAcceleration string)\n"+
            "* animateMoveTime (number)\n"+
            "* animateResizeTime (number)\n"+
            "* animateRectTime (number)\n"+
            "* animateFadeTime (number)\n"+
            "* animateScrollTime (number)\n"+
            "* animateShowTime (number)\n"+
            "* animateHideTime (number)\n"+
            "* animateMoveAcceleration (AnimationAcceleration string)\n"+
            "* animateResizeAcceleration (AnimationAcceleration string)\n"+
            "* animateRectAcceleration (AnimationAcceleration string)\n"+
            "* animateScrollAcceleration (AnimationAcceleration string)\n"+
            "* animateShowAcceleration (AnimationAcceleration string)\n"+
            "* animateHideAcceleration (AnimationAcceleration string)\n"+
            "* layoutAlign (Alignment string | VerticalAlignment string)\n"+
            "* showResizeBar (boolean)\n"+
            "* resizeBarTarget (string)\n"+
            "* extraSpace (positive integer)\n"+
            "\n"+
            "### Methods\n"+
            "* showNextTo()\n"+
            "* show()\n"+
            "* hide()\n"+
            "* print()\n",
        format:"Markdown"
    },
    "APIs list:ValuesManager":{
        topic:"APIs list for ValuesManager",
        content:"Only the following APIs are available on ValuesManager:\n"+
            "\n"+
            "## Attributes\n"+
            "* dataSource (DataSource | GlobalId string)\n"+
            "* fetchOperation (string)\n"+
            "* members (array of DynamicForm)\n"+
            "\n"+
            "## Methods\n"+
            "* editNewRecord()\n"+
            "* editRecord()\n"+
            "* editSelectedData()\n"+
            "* saveData()\n"+
            "* validate()\n"+
            "* setValues()\n"+
            "* clearValues()\n"+
            "* itemChanged()\n",
        format:"Markdown"
    },
    "APIs list:Portlet":{
        topic:"APIs list for Portlet",
        content:"Only the following APIs are available on Portlet:\n"+
            "\n"+
            "## Attributes\n"+
            "* dragType (string)\n"+
            "* canDrop (boolean)\n"+
            "* minHeight (number)\n"+
            "* minWidth (number)\n"+
            "* height (number | string)\n"+
            "* rowHeight (number | string)\n"+
            "* showCloseConfirmationMessage (boolean)\n"+
            "* closeConfirmationMessage (string)\n"+
            "* destroyOnClose (boolean)\n"+
            "\n"+
            "## Inherited from Window\n"+
            "\n"+
            "### Attributes\n"+
            "* canDragReposition (boolean)\n"+
            "* keepInParentRect (boolean | array of integer)\n"+
            "* canDragResize (boolean)\n"+
            "* resizeFrom (array of EdgeName string)\n"+
            "* opacity (integer)\n"+
            "* isModal (boolean)\n"+
            "* showModalMask (boolean)\n"+
            "* modalMaskOpacity (number)\n"+
            "* autoCenter (boolean)\n"+
            "* dismissOnOutsideClick (boolean)\n"+
            "* dismissOnEscape (boolean)\n"+
            "* showBody (boolean)\n"+
            "* bodyStyle (CSSStyleName string)\n"+
            "* bodyColor (CSSColor string)\n"+
            "* hiliteBodyColor (CSSColor string)\n"+
            "* items (array of Canvas | Canvas | string)\n"+
            "* src (string)\n"+
            "* contentsType (string)\n"+
            "* bodyConstructor (string)\n"+
            "* bodyDefaults (object)\n"+
            "* contentLayout (ContentLayoutPolicy string)\n"+
            "* autoSize (boolean)\n"+
            "* showHeader (boolean)\n"+
            "* showHeaderBackground (boolean)\n"+
            "* headerStyle (CSSStyleName string)\n"+
            "* headerSrc (SCImgURL string)\n"+
            "* headerControls (array of string)\n"+
            "* hiliteHeaderStyle (CSSStyleName string)\n"+
            "* hiliteHeaderSrc (SCImgURL string)\n"+
            "* showTitle (boolean)\n"+
            "* title (HTML string)\n"+
            "* headerLabelDefaults (object)\n"+
            "* showHeaderIcon (boolean)\n"+
            "* headerIconDefaults (object)\n"+
            "* canFocusInHeaderButtons (boolean)\n"+
            "* showCloseButton (boolean)\n"+
            "* showMinimizeButton (boolean)\n"+
            "* minimized (boolean)\n"+
            "* defaultMinimizeHeight (number)\n"+
            "* minimizeHeight (number)\n"+
            "* animateMinimize (boolean)\n"+
            "* minimizeTime (number)\n"+
            "* minimizeAcceleration (AnimationAcceleration string)\n"+
            "* maximized (boolean)\n"+
            "* showMaximizeButton (boolean)\n"+
            "* showFooter (boolean)\n"+
            "* footerHeight (number)\n"+
            "* footerControls (array of string)\n"+
            "* showStatusBar (boolean)\n"+
            "* showResizer (boolean)\n"+
            "* showEdges (boolean)\n"+
            "* showShadow (boolean)\n"+
            "\n"+
            "## Inherited from Layout\n"+
            "\n"+
            "### Attributes\n"+
            "* overflow (Overflow string)\n"+
            "* defaultLayoutAlign (Alignment string | VerticalAlignment string)\n"+
            "* align (Alignment string | VerticalAlignment string)\n"+
            "* layoutMargin (integer)\n"+
            "* membersMargin (integer)\n"+
            "\n"+
            "## Inherited from Canvas\n"+
            "\n"+
            "### Attributes\n"+
            "* ID (GlobalId string)\n"+
            "* autoDraw (boolean)\n"+
            "* children (array of Canvas)\n"+
            "* peers (array of Canvas)\n"+
            "* htmlElement (DOMElement object | string)\n"+
            "* htmlPosition (DrawPosition string)\n"+
            "* matchElement (boolean)\n"+
            "* position (Positioning string)\n"+
            "* left (number | string)\n"+
            "* top (number | string)\n"+
            "* width (number | string)\n"+
            "* defaultWidth (integer)\n"+
            "* defaultHeight (integer)\n"+
            "* maxWidth (number)\n"+
            "* maxHeight (number)\n"+
            "* autoShowParent (boolean)\n"+
            "* visibility (Visibility string)\n"+
            "* canSelectText (boolean)\n"+
            "* styleName (CSSStyleName string)\n"+
            "* contents (HTML string)\n"+
            "* dynamicContents (boolean)\n"+
            "* dynamicContentsVars (ValueMap object)\n"+
            "* margin (number)\n"+
            "* padding (number)\n"+
            "* border (string)\n"+
            "* backgroundColor (CSSColor string)\n"+
            "* backgroundImage (SCImgURL string)\n"+
            "* backgroundRepeat (BackgroundRepeat string)\n"+
            "* appImgDir (URL string)\n"+
            "* skinImgDir (SCImgURL string)\n"+
            "* cursor (Cursor string)\n"+
            "* disabledCursor (Cursor string)\n"+
            "* showCustomScrollbars (boolean)\n"+
            "* scrollbarSize (number)\n"+
            "* disabled (boolean)\n"+
            "* visibleWhen (AdvancedCriteria object)\n"+
            "* redrawOnResize (boolean)\n"+
            "* canFocus (boolean)\n"+
            "* tabIndex (number)\n"+
            "* accessKey (string)\n"+
            "* contextMenu (Menu)\n"+
            "* prompt (HTML string)\n"+
            "* canDrag (boolean)\n"+
            "* dragStartDistance (number)\n"+
            "* canDragScroll (boolean)\n"+
            "* dragScrollDelay (number)\n"+
            "* dragIntersectStyle (DragIntersectStyle string)\n"+
            "* dragRepositionCursor (Cursor string)\n"+
            "* canHover (boolean)\n"+
            "* hoverDelay (number)\n"+
            "* showHover (boolean)\n"+
            "* hoverWidth (integer)\n"+
            "* hoverHeight (integer)\n"+
            "* hoverAlign (Alignment string)\n"+
            "* hoverVAlign (VerticalAlignment string)\n"+
            "* hoverWrap (boolean)\n"+
            "* hoverStyle (CSSStyleName string)\n"+
            "* hoverOpacity (number)\n"+
            "* hoverMoveWithMouse (boolean)\n"+
            "* edgeMarginSize (number)\n"+
            "* edgeCursorMap (object)\n"+
            "* dragAppearance (DragAppearance string)\n"+
            "* dropTypes (array of string | string)\n"+
            "* dragTarget (Canvas | string)\n"+
            "* showDragShadow (boolean)\n"+
            "* dragOpacity (integer)\n"+
            "* canAcceptDrop (boolean)\n"+
            "* canDropBefore (boolean)\n"+
            "* mouseStillDownInitialDelay (integer)\n"+
            "* mouseStillDownDelay (integer)\n"+
            "* doubleClickDelay (integer)\n"+
            "* noDoubleClicks (boolean)\n"+
            "* snapTo (string)\n"+
            "* snapOffsetLeft (integer)\n"+
            "* snapOffsetTop (integer)\n"+
            "* snapToGrid (boolean)\n"+
            "* snapResizeToGrid (boolean)\n"+
            "* childrenSnapToGrid (boolean)\n"+
            "* childrenSnapResizeToGrid (boolean)\n"+
            "* snapHGap (number)\n"+
            "* snapVGap (number)\n"+
            "* snapOnDrop (boolean)\n"+
            "* showPointer (boolean)\n"+
            "* pointerTarget (AutoTestLocator string | GlobalId string)\n"+
            "* pointerSettings (PointerSettings object)\n"+
            "* workflows (array of Process)\n"+
            "* borderRadius (string)\n"+
            "* edgeSize (number)\n"+
            "* edgeOffset (number)\n"+
            "* edgeImage (SCImgURL string)\n"+
            "* customEdges (array of string)\n"+
            "* edgeBackgroundColor (CSSColor string)\n"+
            "* edgeOpacity (integer)\n"+
            "* edgeShowCenter (boolean)\n"+
            "* edgeCenterBackgroundColor (CSSColor string)\n"+
            "* shadowDepth (number)\n"+
            "* shadowOffset (number)\n"+
            "* shadowSoftness (number)\n"+
            "* shadowImage (SCImgURL string)\n"+
            "* isGroup (boolean)\n"+
            "* groupTitle (HTML string)\n"+
            "* testDataContext (DataContext object)\n"+
            "* autoPopulateData (boolean)\n"+
            "* ruleScope (string)\n"+
            "* isRuleScope (boolean)\n"+
            "* valuesManager (ValuesManager | GlobalId string)\n"+
            "* dataPath (DataPath string)\n"+
            "* animateTime (number)\n"+
            "* animateAcceleration (AnimationAcceleration string)\n"+
            "* animateMoveTime (number)\n"+
            "* animateResizeTime (number)\n"+
            "* animateRectTime (number)\n"+
            "* animateFadeTime (number)\n"+
            "* animateScrollTime (number)\n"+
            "* animateShowTime (number)\n"+
            "* animateHideTime (number)\n"+
            "* animateMoveAcceleration (AnimationAcceleration string)\n"+
            "* animateResizeAcceleration (AnimationAcceleration string)\n"+
            "* animateRectAcceleration (AnimationAcceleration string)\n"+
            "* animateScrollAcceleration (AnimationAcceleration string)\n"+
            "* animateShowAcceleration (AnimationAcceleration string)\n"+
            "* animateHideAcceleration (AnimationAcceleration string)\n"+
            "* layoutAlign (Alignment string | VerticalAlignment string)\n"+
            "* showResizeBar (boolean)\n"+
            "* resizeBarTarget (string)\n"+
            "* extraSpace (positive integer)\n"+
            "\n"+
            "### Methods\n"+
            "* showNextTo()\n"+
            "* show()\n"+
            "* hide()\n"+
            "* print()\n",
        format:"Markdown"
    },
    "APIs list:PortalLayout":{
        topic:"APIs list for PortalLayout",
        content:"Only the following APIs are available on PortalLayout:\n"+
            "\n"+
            "## Attributes\n"+
            "* overflow (Overflow string)\n"+
            "* columnOverflow (Overflow string)\n"+
            "* canStretchColumnWidths (boolean)\n"+
            "* canShrinkColumnWidths (boolean)\n"+
            "* preventUnderflow (boolean)\n"+
            "* preventColumnUnderflow (boolean)\n"+
            "* preventRowUnderflow (boolean)\n"+
            "* columnSpacing (integer)\n"+
            "* portletHSpacing (integer)\n"+
            "* portletVSpacing (integer)\n"+
            "* numColumns (integer)\n"+
            "* showColumnMenus (boolean)\n"+
            "* columnBorder (string)\n"+
            "* canResizeColumns (boolean)\n"+
            "* canResizePortlets (boolean)\n"+
            "* portletDropTypes (array of string)\n"+
            "* canAcceptDrop (boolean)\n"+
            "* dropTypes (array of string)\n"+
            "\n"+
            "## Inherited from Layout\n"+
            "\n"+
            "### Attributes\n"+
            "* vertical (boolean)\n"+
            "* vPolicy (LayoutPolicy string)\n"+
            "* hPolicy (LayoutPolicy string)\n"+
            "* minMemberLength (integer)\n"+
            "* minBreadthMember (string | integer | Canvas)\n"+
            "* enforcePolicy (boolean)\n"+
            "* defaultLayoutAlign (Alignment string | VerticalAlignment string)\n"+
            "* align (Alignment string | VerticalAlignment string)\n"+
            "* reverseOrder (boolean)\n"+
            "* paddingAsLayoutMargin (boolean)\n"+
            "* layoutMargin (integer)\n"+
            "* layoutLeftMargin (integer)\n"+
            "* layoutRightMargin (integer)\n"+
            "* layoutTopMargin (integer)\n"+
            "* layoutBottomMargin (integer)\n"+
            "* leaveScrollbarGap (boolean)\n"+
            "* resizeBarClass (string)\n"+
            "* resizeBarSize (integer)\n"+
            "* animateMembers (boolean)\n"+
            "* animateMemberTime (number)\n"+
            "* canDropComponents (boolean)\n"+
            "* dropLineThickness (number)\n"+
            "* showDragPlaceHolder (boolean)\n"+
            "* placeHolderProperties (Canvas properties object)\n"+
            "* placeHolderDefaults (Canvas properties object)\n"+
            "\n"+
            "## Inherited from Canvas\n"+
            "\n"+
            "### Attributes\n"+
            "* ID (GlobalId string)\n"+
            "* autoDraw (boolean)\n"+
            "* htmlElement (DOMElement object | string)\n"+
            "* htmlPosition (DrawPosition string)\n"+
            "* matchElement (boolean)\n"+
            "* position (Positioning string)\n"+
            "* left (number | string)\n"+
            "* top (number | string)\n"+
            "* width (number | string)\n"+
            "* height (number | string)\n"+
            "* defaultWidth (integer)\n"+
            "* defaultHeight (integer)\n"+
            "* minWidth (number)\n"+
            "* minHeight (number)\n"+
            "* maxWidth (number)\n"+
            "* maxHeight (number)\n"+
            "* autoShowParent (boolean)\n"+
            "* visibility (Visibility string)\n"+
            "* canSelectText (boolean)\n"+
            "* styleName (CSSStyleName string)\n"+
            "* contents (HTML string)\n"+
            "* dynamicContents (boolean)\n"+
            "* dynamicContentsVars (ValueMap object)\n"+
            "* margin (number)\n"+
            "* padding (number)\n"+
            "* border (string)\n"+
            "* backgroundColor (CSSColor string)\n"+
            "* backgroundImage (SCImgURL string)\n"+
            "* backgroundRepeat (BackgroundRepeat string)\n"+
            "* appImgDir (URL string)\n"+
            "* skinImgDir (SCImgURL string)\n"+
            "* cursor (Cursor string)\n"+
            "* disabledCursor (Cursor string)\n"+
            "* opacity (number)\n"+
            "* showCustomScrollbars (boolean)\n"+
            "* scrollbarSize (number)\n"+
            "* disabled (boolean)\n"+
            "* visibleWhen (AdvancedCriteria object)\n"+
            "* enableWhen (AdvancedCriteria object)\n"+
            "* redrawOnResize (boolean)\n"+
            "* canFocus (boolean)\n"+
            "* tabIndex (number)\n"+
            "* accessKey (string)\n"+
            "* contextMenu (Menu)\n"+
            "* prompt (HTML string)\n"+
            "* canDrag (boolean)\n"+
            "* dragStartDistance (number)\n"+
            "* canDragScroll (boolean)\n"+
            "* dragScrollDelay (number)\n"+
            "* dragIntersectStyle (DragIntersectStyle string)\n"+
            "* canDragReposition (boolean)\n"+
            "* dragRepositionCursor (Cursor string)\n"+
            "* canDragResize (boolean)\n"+
            "* resizeFrom (array of EdgeName string)\n"+
            "* canHover (boolean)\n"+
            "* hoverDelay (number)\n"+
            "* showHover (boolean)\n"+
            "* hoverWidth (integer)\n"+
            "* hoverHeight (integer)\n"+
            "* hoverAlign (Alignment string)\n"+
            "* hoverVAlign (VerticalAlignment string)\n"+
            "* hoverWrap (boolean)\n"+
            "* hoverStyle (CSSStyleName string)\n"+
            "* hoverOpacity (number)\n"+
            "* hoverMoveWithMouse (boolean)\n"+
            "* edgeMarginSize (number)\n"+
            "* edgeCursorMap (object)\n"+
            "* keepInParentRect (boolean | array of integer)\n"+
            "* dragAppearance (DragAppearance string)\n"+
            "* dragType (string)\n"+
            "* dragTarget (Canvas | string)\n"+
            "* showDragShadow (boolean)\n"+
            "* dragOpacity (integer)\n"+
            "* canDrop (boolean)\n"+
            "* canDropBefore (boolean)\n"+
            "* mouseStillDownInitialDelay (integer)\n"+
            "* mouseStillDownDelay (integer)\n"+
            "* doubleClickDelay (integer)\n"+
            "* noDoubleClicks (boolean)\n"+
            "* snapTo (string)\n"+
            "* snapOffsetLeft (integer)\n"+
            "* snapOffsetTop (integer)\n"+
            "* snapToGrid (boolean)\n"+
            "* snapResizeToGrid (boolean)\n"+
            "* childrenSnapToGrid (boolean)\n"+
            "* childrenSnapResizeToGrid (boolean)\n"+
            "* snapHGap (number)\n"+
            "* snapVGap (number)\n"+
            "* snapOnDrop (boolean)\n"+
            "* showPointer (boolean)\n"+
            "* pointerTarget (AutoTestLocator string | GlobalId string)\n"+
            "* pointerSettings (PointerSettings object)\n"+
            "* workflows (array of Process)\n"+
            "* borderRadius (string)\n"+
            "* showEdges (boolean)\n"+
            "* edgeSize (number)\n"+
            "* edgeOffset (number)\n"+
            "* edgeImage (SCImgURL string)\n"+
            "* customEdges (array of string)\n"+
            "* edgeBackgroundColor (CSSColor string)\n"+
            "* edgeOpacity (integer)\n"+
            "* edgeShowCenter (boolean)\n"+
            "* edgeCenterBackgroundColor (CSSColor string)\n"+
            "* showShadow (boolean)\n"+
            "* shadowDepth (number)\n"+
            "* shadowOffset (number)\n"+
            "* shadowSoftness (number)\n"+
            "* shadowImage (SCImgURL string)\n"+
            "* isGroup (boolean)\n"+
            "* groupTitle (HTML string)\n"+
            "* testDataContext (DataContext object)\n"+
            "* autoPopulateData (boolean)\n"+
            "* ruleScope (string)\n"+
            "* isRuleScope (boolean)\n"+
            "* valuesManager (ValuesManager | GlobalId string)\n"+
            "* dataPath (DataPath string)\n"+
            "* animateTime (number)\n"+
            "* animateAcceleration (AnimationAcceleration string)\n"+
            "* animateMoveTime (number)\n"+
            "* animateResizeTime (number)\n"+
            "* animateRectTime (number)\n"+
            "* animateFadeTime (number)\n"+
            "* animateScrollTime (number)\n"+
            "* animateShowTime (number)\n"+
            "* animateHideTime (number)\n"+
            "* animateMoveAcceleration (AnimationAcceleration string)\n"+
            "* animateResizeAcceleration (AnimationAcceleration string)\n"+
            "* animateRectAcceleration (AnimationAcceleration string)\n"+
            "* animateScrollAcceleration (AnimationAcceleration string)\n"+
            "* animateShowAcceleration (AnimationAcceleration string)\n"+
            "* animateHideAcceleration (AnimationAcceleration string)\n"+
            "* layoutAlign (Alignment string | VerticalAlignment string)\n"+
            "* showResizeBar (boolean)\n"+
            "* resizeBarTarget (string)\n"+
            "* extraSpace (positive integer)\n"+
            "\n"+
            "### Methods\n"+
            "* showNextTo()\n"+
            "* show()\n"+
            "* hide()\n"+
            "* print()\n",
        format:"Markdown"
    },
    "APIs list:Calendar":{
        topic:"APIs list for Calendar",
        content:"Only the following APIs are available on Calendar:\n"+
            "\n"+
            "## Attributes\n"+
            "* chosenDate (Date object)\n"+
            "* firstDayOfWeek (number)\n"+
            "* baseStyle (CSSStyleName string)\n"+
            "* dayHeaderBaseStyle (CSSStyleName string)\n"+
            "* dayBodyBaseStyle (CSSStyleName string)\n"+
            "* otherDayHeaderBaseStyle (CSSStyleName string)\n"+
            "* otherDayBodyBaseStyle (CSSStyleName string)\n"+
            "* otherDayBlankStyle (CSSStyleName string)\n"+
            "* showDayView (boolean)\n"+
            "* showWeekView (boolean)\n"+
            "* showMonthView (boolean)\n"+
            "* selectedCellStyle (CSSStyleName string)\n"+
            "* workdayBaseStyle (CSSStyleName string)\n"+
            "* workdayStart (Time)\n"+
            "* workdayEnd (Time)\n"+
            "* showWorkday (boolean)\n"+
            "* scrollToWorkday (boolean)\n"+
            "* nameField (string)\n"+
            "* descriptionField (string)\n"+
            "* startDateField (string)\n"+
            "* endDateField (string)\n"+
            "* canEditField (string)\n"+
            "* weekEventBorderOverlap (boolean)\n"+
            "* eventSnapGap (integer)\n"+
            "* showQuickEventDialog (boolean)\n"+
            "* eventEditorFields (array of FormItem)\n"+
            "* eventDialogFields (array of FormItem)\n"+
            "* canCreateEvents (boolean)\n"+
            "* canEditEvents (boolean)\n"+
            "* showDateChooser (boolean)\n"+
            "* disableWeekends (boolean)\n"+
            "* showWeekends (boolean)\n"+
            "* showDayHeaders (boolean)\n"+
            "* showOtherDays (boolean)\n"+
            "* eventOverlapPercent (number)\n"+
            "* data (array of CalendarEvent objects)\n"+
            "* dataSource (DataSource | ID string)\n"+
            "* autoFetchData (boolean)\n"+
            "* autoFetchTextMatchStyle (TextMatchStyle string)\n"+
            "* initialCriteria (Criteria object)\n"+
            "* implicitCriteria (Criteria object)\n"+
            "* invalidDateMessage (string)\n"+
            "* showEventCanvasComponents (boolean)\n"+
            "* eventScreen (string)\n"+
            "* zones (array of CalendarEvent objects)\n"+
            "* indicators (array of CalendarEvent objects)\n"+
            "\n"+
            "## Methods\n"+
            "* fetchData()\n"+
            "\n"+
            "## Inherited from Canvas\n"+
            "\n"+
            "### Attributes\n"+
            "* ID (GlobalId string)\n"+
            "* autoDraw (boolean)\n"+
            "* children (array of Canvas)\n"+
            "* peers (array of Canvas)\n"+
            "* htmlElement (DOMElement object | string)\n"+
            "* htmlPosition (DrawPosition string)\n"+
            "* matchElement (boolean)\n"+
            "* position (Positioning string)\n"+
            "* left (number | string)\n"+
            "* top (number | string)\n"+
            "* width (number | string)\n"+
            "* height (number | string)\n"+
            "* defaultWidth (integer)\n"+
            "* defaultHeight (integer)\n"+
            "* minWidth (number)\n"+
            "* minHeight (number)\n"+
            "* maxWidth (number)\n"+
            "* maxHeight (number)\n"+
            "* autoShowParent (boolean)\n"+
            "* visibility (Visibility string)\n"+
            "* canSelectText (boolean)\n"+
            "* styleName (CSSStyleName string)\n"+
            "* contents (HTML string)\n"+
            "* dynamicContents (boolean)\n"+
            "* dynamicContentsVars (ValueMap object)\n"+
            "* margin (number)\n"+
            "* padding (number)\n"+
            "* border (string)\n"+
            "* backgroundColor (CSSColor string)\n"+
            "* backgroundImage (SCImgURL string)\n"+
            "* backgroundRepeat (BackgroundRepeat string)\n"+
            "* appImgDir (URL string)\n"+
            "* skinImgDir (SCImgURL string)\n"+
            "* cursor (Cursor string)\n"+
            "* disabledCursor (Cursor string)\n"+
            "* opacity (number)\n"+
            "* overflow (Overflow string)\n"+
            "* showCustomScrollbars (boolean)\n"+
            "* scrollbarSize (number)\n"+
            "* disabled (boolean)\n"+
            "* visibleWhen (AdvancedCriteria object)\n"+
            "* enableWhen (AdvancedCriteria object)\n"+
            "* redrawOnResize (boolean)\n"+
            "* canFocus (boolean)\n"+
            "* tabIndex (number)\n"+
            "* accessKey (string)\n"+
            "* contextMenu (Menu)\n"+
            "* prompt (HTML string)\n"+
            "* canDrag (boolean)\n"+
            "* dragStartDistance (number)\n"+
            "* canDragScroll (boolean)\n"+
            "* dragScrollDelay (number)\n"+
            "* dragIntersectStyle (DragIntersectStyle string)\n"+
            "* canDragReposition (boolean)\n"+
            "* dragRepositionCursor (Cursor string)\n"+
            "* canDragResize (boolean)\n"+
            "* resizeFrom (array of EdgeName string)\n"+
            "* canHover (boolean)\n"+
            "* hoverDelay (number)\n"+
            "* showHover (boolean)\n"+
            "* hoverWidth (integer)\n"+
            "* hoverHeight (integer)\n"+
            "* hoverAlign (Alignment string)\n"+
            "* hoverVAlign (VerticalAlignment string)\n"+
            "* hoverWrap (boolean)\n"+
            "* hoverStyle (CSSStyleName string)\n"+
            "* hoverOpacity (number)\n"+
            "* hoverMoveWithMouse (boolean)\n"+
            "* edgeMarginSize (number)\n"+
            "* edgeCursorMap (object)\n"+
            "* keepInParentRect (boolean | array of integer)\n"+
            "* dragAppearance (DragAppearance string)\n"+
            "* dragType (string)\n"+
            "* dropTypes (array of string | string)\n"+
            "* dragTarget (Canvas | string)\n"+
            "* showDragShadow (boolean)\n"+
            "* dragOpacity (integer)\n"+
            "* canDrop (boolean)\n"+
            "* canAcceptDrop (boolean)\n"+
            "* canDropBefore (boolean)\n"+
            "* mouseStillDownInitialDelay (integer)\n"+
            "* mouseStillDownDelay (integer)\n"+
            "* doubleClickDelay (integer)\n"+
            "* noDoubleClicks (boolean)\n"+
            "* snapTo (string)\n"+
            "* snapOffsetLeft (integer)\n"+
            "* snapOffsetTop (integer)\n"+
            "* snapToGrid (boolean)\n"+
            "* snapResizeToGrid (boolean)\n"+
            "* childrenSnapToGrid (boolean)\n"+
            "* childrenSnapResizeToGrid (boolean)\n"+
            "* snapHGap (number)\n"+
            "* snapVGap (number)\n"+
            "* snapOnDrop (boolean)\n"+
            "* showPointer (boolean)\n"+
            "* pointerTarget (AutoTestLocator string | GlobalId string)\n"+
            "* pointerSettings (PointerSettings object)\n"+
            "* workflows (array of Process)\n"+
            "* borderRadius (string)\n"+
            "* showEdges (boolean)\n"+
            "* edgeSize (number)\n"+
            "* edgeOffset (number)\n"+
            "* edgeImage (SCImgURL string)\n"+
            "* customEdges (array of string)\n"+
            "* edgeBackgroundColor (CSSColor string)\n"+
            "* edgeOpacity (integer)\n"+
            "* edgeShowCenter (boolean)\n"+
            "* edgeCenterBackgroundColor (CSSColor string)\n"+
            "* showShadow (boolean)\n"+
            "* shadowDepth (number)\n"+
            "* shadowOffset (number)\n"+
            "* shadowSoftness (number)\n"+
            "* shadowImage (SCImgURL string)\n"+
            "* isGroup (boolean)\n"+
            "* groupTitle (HTML string)\n"+
            "* testDataContext (DataContext object)\n"+
            "* autoPopulateData (boolean)\n"+
            "* ruleScope (string)\n"+
            "* isRuleScope (boolean)\n"+
            "* valuesManager (ValuesManager | GlobalId string)\n"+
            "* dataPath (DataPath string)\n"+
            "* animateTime (number)\n"+
            "* animateAcceleration (AnimationAcceleration string)\n"+
            "* animateMoveTime (number)\n"+
            "* animateResizeTime (number)\n"+
            "* animateRectTime (number)\n"+
            "* animateFadeTime (number)\n"+
            "* animateScrollTime (number)\n"+
            "* animateShowTime (number)\n"+
            "* animateHideTime (number)\n"+
            "* animateMoveAcceleration (AnimationAcceleration string)\n"+
            "* animateResizeAcceleration (AnimationAcceleration string)\n"+
            "* animateRectAcceleration (AnimationAcceleration string)\n"+
            "* animateScrollAcceleration (AnimationAcceleration string)\n"+
            "* animateShowAcceleration (AnimationAcceleration string)\n"+
            "* animateHideAcceleration (AnimationAcceleration string)\n"+
            "* layoutAlign (Alignment string | VerticalAlignment string)\n"+
            "* showResizeBar (boolean)\n"+
            "* resizeBarTarget (string)\n"+
            "* extraSpace (positive integer)\n"+
            "\n"+
            "### Methods\n"+
            "* showNextTo()\n"+
            "* show()\n"+
            "* hide()\n"+
            "* print()\n",
        format:"Markdown"
    },
    "APIs list:Timeline":{
        topic:"APIs list for Timeline",
        content:"Only the following APIs are available on Timeline:\n"+
            "\n"+
            "## Inherited from Calendar\n"+
            "\n"+
            "### Attributes\n"+
            "* chosenDate (Date object)\n"+
            "* firstDayOfWeek (number)\n"+
            "* baseStyle (CSSStyleName string)\n"+
            "* dayHeaderBaseStyle (CSSStyleName string)\n"+
            "* dayBodyBaseStyle (CSSStyleName string)\n"+
            "* otherDayHeaderBaseStyle (CSSStyleName string)\n"+
            "* otherDayBodyBaseStyle (CSSStyleName string)\n"+
            "* otherDayBlankStyle (CSSStyleName string)\n"+
            "* showDayView (boolean)\n"+
            "* showWeekView (boolean)\n"+
            "* showMonthView (boolean)\n"+
            "* selectedCellStyle (CSSStyleName string)\n"+
            "* workdayBaseStyle (CSSStyleName string)\n"+
            "* workdayStart (Time)\n"+
            "* workdayEnd (Time)\n"+
            "* showWorkday (boolean)\n"+
            "* scrollToWorkday (boolean)\n"+
            "* nameField (string)\n"+
            "* descriptionField (string)\n"+
            "* startDateField (string)\n"+
            "* endDateField (string)\n"+
            "* canEditField (string)\n"+
            "* weekEventBorderOverlap (boolean)\n"+
            "* eventSnapGap (integer)\n"+
            "* showQuickEventDialog (boolean)\n"+
            "* eventEditorFields (array of FormItem)\n"+
            "* eventDialogFields (array of FormItem)\n"+
            "* canCreateEvents (boolean)\n"+
            "* canEditEvents (boolean)\n"+
            "* showDateChooser (boolean)\n"+
            "* disableWeekends (boolean)\n"+
            "* showWeekends (boolean)\n"+
            "* showDayHeaders (boolean)\n"+
            "* showOtherDays (boolean)\n"+
            "* eventOverlapPercent (number)\n"+
            "* data (array of CalendarEvent objects)\n"+
            "* dataSource (DataSource | ID string)\n"+
            "* autoFetchData (boolean)\n"+
            "* autoFetchTextMatchStyle (TextMatchStyle string)\n"+
            "* initialCriteria (Criteria object)\n"+
            "* implicitCriteria (Criteria object)\n"+
            "* invalidDateMessage (string)\n"+
            "* showEventCanvasComponents (boolean)\n"+
            "* eventScreen (string)\n"+
            "* zones (array of CalendarEvent objects)\n"+
            "* indicators (array of CalendarEvent objects)\n"+
            "\n"+
            "### Methods\n"+
            "* fetchData()\n"+
            "\n"+
            "## Inherited from Canvas\n"+
            "\n"+
            "### Attributes\n"+
            "* ID (GlobalId string)\n"+
            "* autoDraw (boolean)\n"+
            "* children (array of Canvas)\n"+
            "* peers (array of Canvas)\n"+
            "* htmlElement (DOMElement object | string)\n"+
            "* htmlPosition (DrawPosition string)\n"+
            "* matchElement (boolean)\n"+
            "* position (Positioning string)\n"+
            "* left (number | string)\n"+
            "* top (number | string)\n"+
            "* width (number | string)\n"+
            "* height (number | string)\n"+
            "* defaultWidth (integer)\n"+
            "* defaultHeight (integer)\n"+
            "* minWidth (number)\n"+
            "* minHeight (number)\n"+
            "* maxWidth (number)\n"+
            "* maxHeight (number)\n"+
            "* autoShowParent (boolean)\n"+
            "* visibility (Visibility string)\n"+
            "* canSelectText (boolean)\n"+
            "* styleName (CSSStyleName string)\n"+
            "* contents (HTML string)\n"+
            "* dynamicContents (boolean)\n"+
            "* dynamicContentsVars (ValueMap object)\n"+
            "* margin (number)\n"+
            "* padding (number)\n"+
            "* border (string)\n"+
            "* backgroundColor (CSSColor string)\n"+
            "* backgroundImage (SCImgURL string)\n"+
            "* backgroundRepeat (BackgroundRepeat string)\n"+
            "* appImgDir (URL string)\n"+
            "* skinImgDir (SCImgURL string)\n"+
            "* cursor (Cursor string)\n"+
            "* disabledCursor (Cursor string)\n"+
            "* opacity (number)\n"+
            "* overflow (Overflow string)\n"+
            "* showCustomScrollbars (boolean)\n"+
            "* scrollbarSize (number)\n"+
            "* disabled (boolean)\n"+
            "* visibleWhen (AdvancedCriteria object)\n"+
            "* enableWhen (AdvancedCriteria object)\n"+
            "* redrawOnResize (boolean)\n"+
            "* canFocus (boolean)\n"+
            "* tabIndex (number)\n"+
            "* accessKey (string)\n"+
            "* contextMenu (Menu)\n"+
            "* prompt (HTML string)\n"+
            "* canDrag (boolean)\n"+
            "* dragStartDistance (number)\n"+
            "* canDragScroll (boolean)\n"+
            "* dragScrollDelay (number)\n"+
            "* dragIntersectStyle (DragIntersectStyle string)\n"+
            "* canDragReposition (boolean)\n"+
            "* dragRepositionCursor (Cursor string)\n"+
            "* canDragResize (boolean)\n"+
            "* resizeFrom (array of EdgeName string)\n"+
            "* canHover (boolean)\n"+
            "* hoverDelay (number)\n"+
            "* showHover (boolean)\n"+
            "* hoverWidth (integer)\n"+
            "* hoverHeight (integer)\n"+
            "* hoverAlign (Alignment string)\n"+
            "* hoverVAlign (VerticalAlignment string)\n"+
            "* hoverWrap (boolean)\n"+
            "* hoverStyle (CSSStyleName string)\n"+
            "* hoverOpacity (number)\n"+
            "* hoverMoveWithMouse (boolean)\n"+
            "* edgeMarginSize (number)\n"+
            "* edgeCursorMap (object)\n"+
            "* keepInParentRect (boolean | array of integer)\n"+
            "* dragAppearance (DragAppearance string)\n"+
            "* dragType (string)\n"+
            "* dropTypes (array of string | string)\n"+
            "* dragTarget (Canvas | string)\n"+
            "* showDragShadow (boolean)\n"+
            "* dragOpacity (integer)\n"+
            "* canDrop (boolean)\n"+
            "* canAcceptDrop (boolean)\n"+
            "* canDropBefore (boolean)\n"+
            "* mouseStillDownInitialDelay (integer)\n"+
            "* mouseStillDownDelay (integer)\n"+
            "* doubleClickDelay (integer)\n"+
            "* noDoubleClicks (boolean)\n"+
            "* snapTo (string)\n"+
            "* snapOffsetLeft (integer)\n"+
            "* snapOffsetTop (integer)\n"+
            "* snapToGrid (boolean)\n"+
            "* snapResizeToGrid (boolean)\n"+
            "* childrenSnapToGrid (boolean)\n"+
            "* childrenSnapResizeToGrid (boolean)\n"+
            "* snapHGap (number)\n"+
            "* snapVGap (number)\n"+
            "* snapOnDrop (boolean)\n"+
            "* showPointer (boolean)\n"+
            "* pointerTarget (AutoTestLocator string | GlobalId string)\n"+
            "* pointerSettings (PointerSettings object)\n"+
            "* workflows (array of Process)\n"+
            "* borderRadius (string)\n"+
            "* showEdges (boolean)\n"+
            "* edgeSize (number)\n"+
            "* edgeOffset (number)\n"+
            "* edgeImage (SCImgURL string)\n"+
            "* customEdges (array of string)\n"+
            "* edgeBackgroundColor (CSSColor string)\n"+
            "* edgeOpacity (integer)\n"+
            "* edgeShowCenter (boolean)\n"+
            "* edgeCenterBackgroundColor (CSSColor string)\n"+
            "* showShadow (boolean)\n"+
            "* shadowDepth (number)\n"+
            "* shadowOffset (number)\n"+
            "* shadowSoftness (number)\n"+
            "* shadowImage (SCImgURL string)\n"+
            "* isGroup (boolean)\n"+
            "* groupTitle (HTML string)\n"+
            "* testDataContext (DataContext object)\n"+
            "* autoPopulateData (boolean)\n"+
            "* ruleScope (string)\n"+
            "* isRuleScope (boolean)\n"+
            "* valuesManager (ValuesManager | GlobalId string)\n"+
            "* dataPath (DataPath string)\n"+
            "* animateTime (number)\n"+
            "* animateAcceleration (AnimationAcceleration string)\n"+
            "* animateMoveTime (number)\n"+
            "* animateResizeTime (number)\n"+
            "* animateRectTime (number)\n"+
            "* animateFadeTime (number)\n"+
            "* animateScrollTime (number)\n"+
            "* animateShowTime (number)\n"+
            "* animateHideTime (number)\n"+
            "* animateMoveAcceleration (AnimationAcceleration string)\n"+
            "* animateResizeAcceleration (AnimationAcceleration string)\n"+
            "* animateRectAcceleration (AnimationAcceleration string)\n"+
            "* animateScrollAcceleration (AnimationAcceleration string)\n"+
            "* animateShowAcceleration (AnimationAcceleration string)\n"+
            "* animateHideAcceleration (AnimationAcceleration string)\n"+
            "* layoutAlign (Alignment string | VerticalAlignment string)\n"+
            "* showResizeBar (boolean)\n"+
            "* resizeBarTarget (string)\n"+
            "* extraSpace (positive integer)\n"+
            "\n"+
            "### Methods\n"+
            "* showNextTo()\n"+
            "* show()\n"+
            "* hide()\n"+
            "* print()\n",
        format:"Markdown"
    },
    "APIs list:DateChooser":{
        topic:"APIs list for DateChooser",
        content:"Only the following APIs are available on DateChooser:\n"+
            "\n"+
            "## Attributes\n"+
            "* skinImgDir (SCImgURL string)\n"+
            "* prevYearIconWidth (integer)\n"+
            "* prevYearIconHeight (integer)\n"+
            "* prevMonthIconWidth (integer)\n"+
            "* prevMonthIconHeight (integer)\n"+
            "* nextYearIconWidth (integer)\n"+
            "* nextYearIconHeight (integer)\n"+
            "* nextMonthIconWidth (integer)\n"+
            "* nextMonthIconHeight (integer)\n"+
            "* showDoubleYearIcon (boolean)\n"+
            "* showTodayButton (boolean)\n"+
            "* showCancelButton (boolean)\n"+
            "* todayButtonTitle (string)\n"+
            "* cancelButtonTitle (string)\n"+
            "* todayButtonHeight (integer)\n"+
            "* disableWeekends (boolean)\n"+
            "* showWeekends (boolean)\n"+
            "* firstDayOfWeek (integer)\n"+
            "* baseButtonStyle (CSSStyleName string)\n"+
            "* baseWeekdayStyle (CSSStyleName string)\n"+
            "* baseWeekendStyle (CSSStyleName string)\n"+
            "* headerStyle (CSSStyleName string)\n"+
            "\n"+
            "## Inherited from Layout\n"+
            "\n"+
            "### Attributes\n"+
            "* overflow (Overflow string)\n"+
            "\n"+
            "## Inherited from Canvas\n"+
            "\n"+
            "### Attributes\n"+
            "* ID (GlobalId string)\n"+
            "* autoDraw (boolean)\n"+
            "* children (array of Canvas)\n"+
            "* peers (array of Canvas)\n"+
            "* htmlElement (DOMElement object | string)\n"+
            "* htmlPosition (DrawPosition string)\n"+
            "* matchElement (boolean)\n"+
            "* position (Positioning string)\n"+
            "* left (number | string)\n"+
            "* top (number | string)\n"+
            "* width (number | string)\n"+
            "* height (number | string)\n"+
            "* defaultWidth (integer)\n"+
            "* defaultHeight (integer)\n"+
            "* minWidth (number)\n"+
            "* minHeight (number)\n"+
            "* maxWidth (number)\n"+
            "* maxHeight (number)\n"+
            "* autoShowParent (boolean)\n"+
            "* visibility (Visibility string)\n"+
            "* canSelectText (boolean)\n"+
            "* styleName (CSSStyleName string)\n"+
            "* contents (HTML string)\n"+
            "* dynamicContents (boolean)\n"+
            "* dynamicContentsVars (ValueMap object)\n"+
            "* margin (number)\n"+
            "* padding (number)\n"+
            "* border (string)\n"+
            "* backgroundColor (CSSColor string)\n"+
            "* backgroundImage (SCImgURL string)\n"+
            "* backgroundRepeat (BackgroundRepeat string)\n"+
            "* appImgDir (URL string)\n"+
            "* cursor (Cursor string)\n"+
            "* disabledCursor (Cursor string)\n"+
            "* opacity (number)\n"+
            "* showCustomScrollbars (boolean)\n"+
            "* scrollbarSize (number)\n"+
            "* disabled (boolean)\n"+
            "* visibleWhen (AdvancedCriteria object)\n"+
            "* enableWhen (AdvancedCriteria object)\n"+
            "* redrawOnResize (boolean)\n"+
            "* canFocus (boolean)\n"+
            "* tabIndex (number)\n"+
            "* accessKey (string)\n"+
            "* contextMenu (Menu)\n"+
            "* prompt (HTML string)\n"+
            "* canDrag (boolean)\n"+
            "* dragStartDistance (number)\n"+
            "* canDragScroll (boolean)\n"+
            "* dragScrollDelay (number)\n"+
            "* dragIntersectStyle (DragIntersectStyle string)\n"+
            "* canDragReposition (boolean)\n"+
            "* dragRepositionCursor (Cursor string)\n"+
            "* canDragResize (boolean)\n"+
            "* resizeFrom (array of EdgeName string)\n"+
            "* canHover (boolean)\n"+
            "* hoverDelay (number)\n"+
            "* showHover (boolean)\n"+
            "* hoverWidth (integer)\n"+
            "* hoverHeight (integer)\n"+
            "* hoverAlign (Alignment string)\n"+
            "* hoverVAlign (VerticalAlignment string)\n"+
            "* hoverWrap (boolean)\n"+
            "* hoverStyle (CSSStyleName string)\n"+
            "* hoverOpacity (number)\n"+
            "* hoverMoveWithMouse (boolean)\n"+
            "* edgeMarginSize (number)\n"+
            "* edgeCursorMap (object)\n"+
            "* keepInParentRect (boolean | array of integer)\n"+
            "* dragAppearance (DragAppearance string)\n"+
            "* dragType (string)\n"+
            "* dropTypes (array of string | string)\n"+
            "* dragTarget (Canvas | string)\n"+
            "* showDragShadow (boolean)\n"+
            "* dragOpacity (integer)\n"+
            "* canDrop (boolean)\n"+
            "* canAcceptDrop (boolean)\n"+
            "* canDropBefore (boolean)\n"+
            "* mouseStillDownInitialDelay (integer)\n"+
            "* mouseStillDownDelay (integer)\n"+
            "* doubleClickDelay (integer)\n"+
            "* noDoubleClicks (boolean)\n"+
            "* snapTo (string)\n"+
            "* snapOffsetLeft (integer)\n"+
            "* snapOffsetTop (integer)\n"+
            "* snapToGrid (boolean)\n"+
            "* snapResizeToGrid (boolean)\n"+
            "* childrenSnapToGrid (boolean)\n"+
            "* childrenSnapResizeToGrid (boolean)\n"+
            "* snapHGap (number)\n"+
            "* snapVGap (number)\n"+
            "* snapOnDrop (boolean)\n"+
            "* showPointer (boolean)\n"+
            "* pointerTarget (AutoTestLocator string | GlobalId string)\n"+
            "* pointerSettings (PointerSettings object)\n"+
            "* workflows (array of Process)\n"+
            "* borderRadius (string)\n"+
            "* showEdges (boolean)\n"+
            "* edgeSize (number)\n"+
            "* edgeOffset (number)\n"+
            "* edgeImage (SCImgURL string)\n"+
            "* customEdges (array of string)\n"+
            "* edgeBackgroundColor (CSSColor string)\n"+
            "* edgeOpacity (integer)\n"+
            "* edgeShowCenter (boolean)\n"+
            "* edgeCenterBackgroundColor (CSSColor string)\n"+
            "* showShadow (boolean)\n"+
            "* shadowDepth (number)\n"+
            "* shadowOffset (number)\n"+
            "* shadowSoftness (number)\n"+
            "* shadowImage (SCImgURL string)\n"+
            "* isGroup (boolean)\n"+
            "* groupTitle (HTML string)\n"+
            "* testDataContext (DataContext object)\n"+
            "* autoPopulateData (boolean)\n"+
            "* ruleScope (string)\n"+
            "* isRuleScope (boolean)\n"+
            "* valuesManager (ValuesManager | GlobalId string)\n"+
            "* dataPath (DataPath string)\n"+
            "* animateTime (number)\n"+
            "* animateAcceleration (AnimationAcceleration string)\n"+
            "* animateMoveTime (number)\n"+
            "* animateResizeTime (number)\n"+
            "* animateRectTime (number)\n"+
            "* animateFadeTime (number)\n"+
            "* animateScrollTime (number)\n"+
            "* animateShowTime (number)\n"+
            "* animateHideTime (number)\n"+
            "* animateMoveAcceleration (AnimationAcceleration string)\n"+
            "* animateResizeAcceleration (AnimationAcceleration string)\n"+
            "* animateRectAcceleration (AnimationAcceleration string)\n"+
            "* animateScrollAcceleration (AnimationAcceleration string)\n"+
            "* animateShowAcceleration (AnimationAcceleration string)\n"+
            "* animateHideAcceleration (AnimationAcceleration string)\n"+
            "* layoutAlign (Alignment string | VerticalAlignment string)\n"+
            "* showResizeBar (boolean)\n"+
            "* resizeBarTarget (string)\n"+
            "* extraSpace (positive integer)\n"+
            "\n"+
            "### Methods\n"+
            "* showNextTo()\n"+
            "* show()\n"+
            "* hide()\n"+
            "* print()\n",
        format:"Markdown"
    },
    "APIs list:CubeGrid":{
        topic:"APIs list for CubeGrid",
        content:"Only the following APIs are available on CubeGrid:\n"+
            "\n"+
            "## Attributes\n"+
            "* styleName (CSSStyleName string)\n"+
            "* bodyStyleName (CSSStyleName string)\n"+
            "* baseStyle (CSSStyleName string)\n"+
            "* alternateRecordStyles (boolean)\n"+
            "* skinImgDir (SCImgURL string)\n"+
            "* facetValueHoverWidth (number | string)\n"+
            "* facetLabelHoverWidth (number | string)\n"+
            "* facetValueHoverHeight (number | string)\n"+
            "* facetLabelHoverHeight (number | string)\n"+
            "* facetValueHoverAlign (Alignment string)\n"+
            "* facetLabelHoverAlign (Alignment string)\n"+
            "* facetValueHoverVAlign (VerticalAlignment string)\n"+
            "* facetLabelHoverVAlign (VerticalAlignment string)\n"+
            "* facetValueHoverStyle (CSSStyleName string)\n"+
            "* facetLabelHoverStyle (CSSStyleName string)\n"+
            "* fixedFacetValues (FacetValueMap object)\n"+
            "* hilites (array of Hilite objects)\n"+
            "* dataSource (DataSource)\n"+
            "* autoFetchData (boolean)\n"+
            "* autoFetchTextMatchStyle (TextMatchStyle string)\n"+
            "* fetchRequestProperties (DSRequest properties object)\n"+
            "* facets (array of Facet)\n"+
            "* showFacetContextMenus (boolean)\n"+
            "* showFacetValueContextMenus (boolean)\n"+
            "* canSelectValues (boolean)\n"+
            "* canSelectHeaders (boolean)\n"+
            "* autoSelectHeaders (boolean)\n"+
            "* autoSelectValues (AutoSelectionModel string)\n"+
            "* simpleDeselect (boolean)\n"+
            "* columnFacets (array of string)\n"+
            "* rowFacets (array of string)\n"+
            "* hideEmptyFacetValues (boolean)\n"+
            "* data (array of CellRecord objects)\n"+
            "* valueProperty (Identifier string)\n"+
            "* cellIdProperty (Identifier string)\n"+
            "* canEdit (boolean)\n"+
            "* editByCell (boolean)\n"+
            "* saveByCell (boolean)\n"+
            "* canDragSelect (boolean)\n"+
            "* canReorderColumns (boolean)\n"+
            "* canResizeColumns (boolean)\n"+
            "* canCollapseFacets (boolean)\n"+
            "* canMinimizeFacets (boolean)\n"+
            "* sortedFacetValues (FacetValueMap object)\n"+
            "* sortDirection (SortDirection string)\n"+
            "* canSortFacets (boolean)\n"+
            "* canSortData (boolean)\n"+
            "* canMinimizeColumns (boolean)\n"+
            "* canMoveFacets (boolean)\n"+
            "* rowHeaderGridMode (boolean)\n"+
            "* autoSizeHeaders (boolean)\n"+
            "* facetTitleAlign (Alignment string)\n"+
            "* facetValueAlign (Alignment string)\n"+
            "* cellAlign (Alignment string)\n"+
            "* wrapFacetTitles (boolean)\n"+
            "* wrapFacetValueTitles (boolean)\n"+
            "* padTitles (boolean)\n"+
            "* defaultFacetWidth (number)\n"+
            "* rollupValue (string)\n"+
            "* metricFacetId (string)\n"+
            "* valueTitle (string)\n"+
            "* bodyMinWidth (number)\n"+
            "* bodyMinHeight (number)\n"+
            "* autoFitFieldWidths (boolean)\n"+
            "* enableCharting (boolean)\n"+
            "* chartConstructor (Classname)\n"+
            "* chartType (ChartType string)\n"+
            "* chartConfirmThreshold (number)\n"+
            "\n"+
            "## Methods\n"+
            "* exportClientData()\n"+
            "\n"+
            "## Inherited from ListGrid\n"+
            "\n"+
            "### Attributes\n"+
            "* initialCriteria (Criteria object)\n"+
            "* implicitCriteria (Criteria object)\n"+
            "* fields (array of ListGridField objects)\n"+
            "* dataArity (string)\n"+
            "* autoFetchDisplayMap (boolean)\n"+
            "* saveLocally (boolean)\n"+
            "* useAllDataSourceFields (boolean)\n"+
            "* showDetailFields (boolean)\n"+
            "* titleField (string)\n"+
            "* dataProperties (ResultSet)\n"+
            "* saveDefaultSearch (boolean)\n"+
            "* canSaveSearches (boolean)\n"+
            "* savedSearchStoredState (SavedSearchStoredState string)\n"+
            "* noSavedSearchesText (HTML string)\n"+
            "* savedSearchText (HTML string)\n"+
            "* newSearchText (HTML string)\n"+
            "* savedSearchAdminSeparator (ListGridRecord properties object)\n"+
            "* savedSearchDS (string)\n"+
            "* savedSearchAdminRole (string)\n"+
            "* groupStartOpen (GroupStartOpen string | array)\n"+
            "* groupTitleColumnProperties (ListGridField properties object)\n"+
            "* groupIconSize (number)\n"+
            "* groupIndentSize (number)\n"+
            "* canGroupBy (boolean)\n"+
            "* groupByMaxRecords (integer)\n"+
            "* groupByField (string | array of string)\n"+
            "* valueIconSize (number)\n"+
            "* valueIconWidth (number)\n"+
            "* valueIconHeight (number)\n"+
            "* valueIconLeftPadding (number)\n"+
            "* valueIconRightPadding (number)\n"+
            "* hiliteIcons (array of string)\n"+
            "* hiliteIconPosition (HiliteIconPosition string)\n"+
            "* hiliteIconSize (number)\n"+
            "* hiliteIconWidth (number)\n"+
            "* hiliteIconHeight (number)\n"+
            "* hiliteIconLeftPadding (number)\n"+
            "* hiliteIconRightPadding (number)\n"+
            "* imageSize (number)\n"+
            "* headerSpans (array of HeaderSpan objects)\n"+
            "* headerSpanHeight (integer)\n"+
            "* showTreeColumnPicker (boolean)\n"+
            "* modalEditing (boolean)\n"+
            "* fetchDelay (number)\n"+
            "* overflow (Overflow string)\n"+
            "* minHeight (number)\n"+
            "* showAllRecords (boolean)\n"+
            "* drawAheadRatio (number)\n"+
            "* scrollRedrawDelay (integer)\n"+
            "* dataPageSize (integer)\n"+
            "* bodyOverflow (Overflow string)\n"+
            "* bodyBackgroundColor (string)\n"+
            "* emptyCellValue (HTML string)\n"+
            "* cellHeight (number)\n"+
            "* fixedRecordHeights (boolean)\n"+
            "* fixedFieldWidths (boolean)\n"+
            "* autoFitData (Autofit string)\n"+
            "* autoFitMaxHeight (integer)\n"+
            "* autoFitMaxRecords (integer)\n"+
            "* autoFitMaxWidth (integer | string)\n"+
            "* autoFitMaxColumns (integer)\n"+
            "* autoFitWidthApproach (AutoFitWidthApproach string)\n"+
            "* leaveScrollbarGap (boolean)\n"+
            "* wrapCells (boolean)\n"+
            "* cellPadding (number)\n"+
            "* dateFormatter (DateDisplayFormat string)\n"+
            "* dateInputFormat (DateInputFormat string)\n"+
            "* timeFormatter (TimeDisplayFormat string)\n"+
            "* fastCellUpdates (boolean)\n"+
            "* editFailedBaseStyle (CSSStyleName string)\n"+
            "* editFailedCSSText (string)\n"+
            "* editPendingCSSText (string)\n"+
            "* recordCustomStyleProperty (string)\n"+
            "* recordBaseStyleProperty (string)\n"+
            "* shrinkForFreeze (boolean)\n"+
            "* alternateRecordFrequency (number)\n"+
            "* generateClickOnSpace (boolean)\n"+
            "* generateClickOnEnter (boolean)\n"+
            "* generateDoubleClickOnSpace (boolean)\n"+
            "* generateDoubleClickOnEnter (boolean)\n"+
            "* arrowKeyAction (string)\n"+
            "* showRecordComponents (boolean)\n"+
            "* recordComponentPosition (EmbeddedPosition string)\n"+
            "* showRollOver (boolean)\n"+
            "* canHover (boolean)\n"+
            "* showHover (boolean)\n"+
            "* hoverStyle (CSSStyleName string)\n"+
            "* selectionAppearance (SelectionAppearance string)\n"+
            "* selectionType (SelectionStyle string)\n"+
            "* selectionProperty (string)\n"+
            "* checkboxFieldImageWidth (integer)\n"+
            "* checkboxFieldImageHeight (integer)\n"+
            "* showEmptyMessage (boolean)\n"+
            "* emptyMessage (HTML string)\n"+
            "* emptyMessageStyle (CSSStyleName string)\n"+
            "* loadingDataMessage (HTML string)\n"+
            "* loadingDataMessageStyle (CSSStyleName string)\n"+
            "* loadingMessage (string)\n"+
            "* singleCellValueProperty (string)\n"+
            "* isSeparatorProperty (string)\n"+
            "* showFilterEditor (boolean)\n"+
            "* canShowFilterEditor (boolean)\n"+
            "* filterEditorHeight (number)\n"+
            "* recordEditProperty (string)\n"+
            "* validateByCell (boolean)\n"+
            "* validateOnChange (boolean)\n"+
            "* neverValidate (boolean)\n"+
            "* canRemoveRecords (boolean)\n"+
            "* warnOnRemoval (boolean)\n"+
            "* warnOnRemovalMessage (string)\n"+
            "* animateRemoveRecord (boolean)\n"+
            "* animateRemoveTime (number)\n"+
            "* animateRemoveSpeed (number)\n"+
            "* filterByCell (boolean)\n"+
            "* filterOnKeypress (boolean)\n"+
            "* waitForSave (boolean)\n"+
            "* stopOnErrors (boolean)\n"+
            "* autoSaveEdits (boolean)\n"+
            "* confirmCancelEditing (boolean)\n"+
            "* cancelEditingConfirmationMessage (string)\n"+
            "* confirmDiscardEdits (boolean)\n"+
            "* confirmDiscardEditsMessage (string)\n"+
            "* discardEditsSaveButtonTitle (string)\n"+
            "* rowEndEditAction (RowEndEditAction string)\n"+
            "* listEndEditAction (RowEndEditAction string)\n"+
            "* enterKeyEditAction (EnterKeyEditAction string)\n"+
            "* escapeKeyEditAction (EscapeKeyEditAction string)\n"+
            "* editEvent (ListGridEditEvent string)\n"+
            "* editOnFocus (boolean)\n"+
            "* selectOnEdit (boolean)\n"+
            "* longTextEditorThreshold (integer)\n"+
            "* longTextEditorType (string)\n"+
            "* headerHeight (number)\n"+
            "* minFieldWidth (integer)\n"+
            "* showHeader (boolean)\n"+
            "* headerBarStyle (CSSStyleName string)\n"+
            "* headerBackgroundColor (CSSColor string)\n"+
            "* headerButtonConstructor (Class name string)\n"+
            "* headerBaseStyle (CSSStyleName string)\n"+
            "* headerTitleStyle (CSSStyleName string)\n"+
            "* headerButtonDefaults (Button properties object)\n"+
            "* headerButtonProperties (Button properties object)\n"+
            "* wrapHeaderTitles (boolean)\n"+
            "* sorterConstructor (Class name string)\n"+
            "* sorterDefaults (object)\n"+
            "* sorterProperties (Button properties object)\n"+
            "* canSort (boolean)\n"+
            "* sortField (string | integer)\n"+
            "* showSortArrow (SortArrow string)\n"+
            "* canPickFields (boolean)\n"+
            "* canFreezeFields (boolean)\n"+
            "* canAddFormulaFields (boolean)\n"+
            "* canAddSummaryFields (boolean)\n"+
            "* canEditHilites (boolean)\n"+
            "* showCellContextMenus (boolean)\n"+
            "* showHeaderContextMenu (boolean)\n"+
            "* showHeaderMenuButton (boolean)\n"+
            "* headerMenuButtonIconWidth (number)\n"+
            "* headerMenuButtonIconHeight (number)\n"+
            "* headerMenuButtonWidth (number)\n"+
            "* headerMenuButtonHeight (number | string)\n"+
            "* canDragRecordsOut (boolean)\n"+
            "* canAcceptDroppedRecords (boolean)\n"+
            "* canReorderRecords (boolean)\n"+
            "* canReorderFields (boolean)\n"+
            "* canResizeFields (boolean)\n"+
            "* dragTrackerMode (DragTrackerMode string)\n"+
            "* resizeFieldsInRealTime (boolean)\n"+
            "* dragDataAction (DragDataAction string)\n"+
            "* sortAscendingImage (SCImgURL string | ImgHTML properties object)\n"+
            "* sortDescendingImage (SCImgURL string | ImgHTML properties object)\n"+
            "* trackerImage (SCImgURL string | ImgHTML properties object)\n"+
            "* booleanTrueImage (SCImgURL string)\n"+
            "* booleanFalseImage (SCImgURL string)\n"+
            "* booleanImageWidth (number)\n"+
            "* booleanImageHeight (number)\n"+
            "* canExpandRecords (boolean)\n"+
            "* canExpandMultipleRecords (boolean)\n"+
            "* detailField (string)\n"+
            "* expansionMode (ExpansionMode string)\n"+
            "* expansionScreen (string)\n"+
            "* detailDS (string)\n"+
            "* viewState (ListGridViewState string)\n"+
            "* autoPersistViewState (array of ListGridViewStatePart string)\n"+
            "* gridComponents (array of ListGridComponent string | array of Any)\n"+
            "* autoFitHeaderHeights (boolean)\n"+
            "* applyFormulaAfterSummary (boolean)\n"+
            "* printHeaderStyle (CSSStyleName string)\n"+
            "* showHoverComponents (boolean)\n"+
            "* hoverMode (HoverMode string)\n"+
            "* hoverScreen (string)\n"+
            "* showGridSummary (boolean)\n"+
            "* hideEmptySummaryRow (boolean)\n"+
            "* allowFilterExpressions (boolean)\n"+
            "* updateSummariesDuringEditing (boolean)\n"+
            "* freezeFieldText (HTML string)\n"+
            "* unfreezeFieldText (HTML string)\n"+
            "* groupByText (HTML string)\n"+
            "* allowFilterWindow (boolean)\n"+
            "* showFilterWindowCriteriaIndicator (boolean)\n"+
            "* searchForm (DynamicForm | ValuesManager)\n"+
            "* showFilterEditorHovers (boolean)\n"+
            "* initialSort (array of SortSpecifier objects)\n"+
            "* showSortNumerals (boolean)\n"+
            "* recordScreen (string)\n"+
            "* showGroupSummary (boolean)\n"+
            "* useAdvancedFieldPicker (boolean)\n"+
            "* advancedFieldPickerThreshold (integer)\n"+
            "\n"+
            "### Methods\n"+
            "* fetchData()\n"+
            "* exportData()\n"+
            "* filterData()\n"+
            "* fetchRelatedData()\n"+
            "* removeSelectedData()\n"+
            "* recordClick()\n"+
            "* recordDoubleClick()\n"+
            "* startEditing()\n"+
            "* startEditingNew()\n"+
            "* removeRecordClick()\n"+
            "* selectionUpdated()\n"+
            "\n"+
            "## Inherited from Canvas\n"+
            "\n"+
            "### Attributes\n"+
            "* ID (GlobalId string)\n"+
            "* autoDraw (boolean)\n"+
            "* htmlElement (DOMElement object | string)\n"+
            "* htmlPosition (DrawPosition string)\n"+
            "* matchElement (boolean)\n"+
            "* position (Positioning string)\n"+
            "* left (number | string)\n"+
            "* top (number | string)\n"+
            "* width (number | string)\n"+
            "* height (number | string)\n"+
            "* defaultWidth (integer)\n"+
            "* defaultHeight (integer)\n"+
            "* minWidth (number)\n"+
            "* maxWidth (number)\n"+
            "* maxHeight (number)\n"+
            "* autoShowParent (boolean)\n"+
            "* visibility (Visibility string)\n"+
            "* canSelectText (boolean)\n"+
            "* contents (HTML string)\n"+
            "* dynamicContents (boolean)\n"+
            "* dynamicContentsVars (ValueMap object)\n"+
            "* margin (number)\n"+
            "* padding (number)\n"+
            "* border (string)\n"+
            "* backgroundColor (CSSColor string)\n"+
            "* backgroundImage (SCImgURL string)\n"+
            "* backgroundRepeat (BackgroundRepeat string)\n"+
            "* appImgDir (URL string)\n"+
            "* cursor (Cursor string)\n"+
            "* disabledCursor (Cursor string)\n"+
            "* opacity (number)\n"+
            "* showCustomScrollbars (boolean)\n"+
            "* scrollbarSize (number)\n"+
            "* disabled (boolean)\n"+
            "* visibleWhen (AdvancedCriteria object)\n"+
            "* enableWhen (AdvancedCriteria object)\n"+
            "* redrawOnResize (boolean)\n"+
            "* canFocus (boolean)\n"+
            "* tabIndex (number)\n"+
            "* accessKey (string)\n"+
            "* contextMenu (Menu)\n"+
            "* prompt (HTML string)\n"+
            "* canDrag (boolean)\n"+
            "* dragStartDistance (number)\n"+
            "* canDragScroll (boolean)\n"+
            "* dragScrollDelay (number)\n"+
            "* dragIntersectStyle (DragIntersectStyle string)\n"+
            "* canDragReposition (boolean)\n"+
            "* dragRepositionCursor (Cursor string)\n"+
            "* canDragResize (boolean)\n"+
            "* resizeFrom (array of EdgeName string)\n"+
            "* hoverDelay (number)\n"+
            "* hoverWidth (integer)\n"+
            "* hoverHeight (integer)\n"+
            "* hoverAlign (Alignment string)\n"+
            "* hoverVAlign (VerticalAlignment string)\n"+
            "* hoverWrap (boolean)\n"+
            "* hoverOpacity (number)\n"+
            "* hoverMoveWithMouse (boolean)\n"+
            "* edgeMarginSize (number)\n"+
            "* edgeCursorMap (object)\n"+
            "* keepInParentRect (boolean | array of integer)\n"+
            "* dragAppearance (DragAppearance string)\n"+
            "* dragType (string)\n"+
            "* dropTypes (array of string | string)\n"+
            "* dragTarget (Canvas | string)\n"+
            "* showDragShadow (boolean)\n"+
            "* dragOpacity (integer)\n"+
            "* canDrop (boolean)\n"+
            "* canAcceptDrop (boolean)\n"+
            "* canDropBefore (boolean)\n"+
            "* mouseStillDownInitialDelay (integer)\n"+
            "* mouseStillDownDelay (integer)\n"+
            "* doubleClickDelay (integer)\n"+
            "* noDoubleClicks (boolean)\n"+
            "* snapTo (string)\n"+
            "* snapOffsetLeft (integer)\n"+
            "* snapOffsetTop (integer)\n"+
            "* snapToGrid (boolean)\n"+
            "* snapResizeToGrid (boolean)\n"+
            "* childrenSnapToGrid (boolean)\n"+
            "* childrenSnapResizeToGrid (boolean)\n"+
            "* snapHGap (number)\n"+
            "* snapVGap (number)\n"+
            "* snapOnDrop (boolean)\n"+
            "* showPointer (boolean)\n"+
            "* pointerTarget (AutoTestLocator string | GlobalId string)\n"+
            "* pointerSettings (PointerSettings object)\n"+
            "* workflows (array of Process)\n"+
            "* borderRadius (string)\n"+
            "* showEdges (boolean)\n"+
            "* edgeSize (number)\n"+
            "* edgeOffset (number)\n"+
            "* edgeImage (SCImgURL string)\n"+
            "* customEdges (array of string)\n"+
            "* edgeBackgroundColor (CSSColor string)\n"+
            "* edgeOpacity (integer)\n"+
            "* edgeShowCenter (boolean)\n"+
            "* edgeCenterBackgroundColor (CSSColor string)\n"+
            "* showShadow (boolean)\n"+
            "* shadowDepth (number)\n"+
            "* shadowOffset (number)\n"+
            "* shadowSoftness (number)\n"+
            "* shadowImage (SCImgURL string)\n"+
            "* isGroup (boolean)\n"+
            "* groupTitle (HTML string)\n"+
            "* testDataContext (DataContext object)\n"+
            "* autoPopulateData (boolean)\n"+
            "* ruleScope (string)\n"+
            "* isRuleScope (boolean)\n"+
            "* valuesManager (ValuesManager | GlobalId string)\n"+
            "* dataPath (DataPath string)\n"+
            "* animateTime (number)\n"+
            "* animateAcceleration (AnimationAcceleration string)\n"+
            "* animateMoveTime (number)\n"+
            "* animateResizeTime (number)\n"+
            "* animateRectTime (number)\n"+
            "* animateFadeTime (number)\n"+
            "* animateScrollTime (number)\n"+
            "* animateShowTime (number)\n"+
            "* animateHideTime (number)\n"+
            "* animateMoveAcceleration (AnimationAcceleration string)\n"+
            "* animateResizeAcceleration (AnimationAcceleration string)\n"+
            "* animateRectAcceleration (AnimationAcceleration string)\n"+
            "* animateScrollAcceleration (AnimationAcceleration string)\n"+
            "* animateShowAcceleration (AnimationAcceleration string)\n"+
            "* animateHideAcceleration (AnimationAcceleration string)\n"+
            "* layoutAlign (Alignment string | VerticalAlignment string)\n"+
            "* showResizeBar (boolean)\n"+
            "* resizeBarTarget (string)\n"+
            "* extraSpace (positive integer)\n"+
            "\n"+
            "### Methods\n"+
            "* showNextTo()\n"+
            "* show()\n"+
            "* hide()\n"+
            "* print()\n",
        format:"Markdown"
    }
},isc.aiHelpDocuments);
isc.defineClass("InternalAIMessagesBuilder").addProperties({
    messagesSource:"user",
    ssMessagesProperty:"userMessages",
    ssMessagesPlaceholder:"${userMessages}",
    init:function(){
        this.Super("init",arguments);
        this.aiMessages=[];
    },
    appendPrompt:function(prompt){
        if(prompt==this.ssMessagesPlaceholder){
            this.__appendSSMessages();
        }else{
            this.aiMessages.push({
                source:"system",
                content:prompt.evalDynamicString(this.target,this.evalVars)
            });
        }
    },
    __appendSSMessages:function(){
        var messagesSource=this.messagesSource;
        this.aiMessages.addList(this[this.ssMessagesProperty].map(function(ssMessage){
            return{
                source:messagesSource,
                content:ssMessage.content,
                type:ssMessage.type
            };
        }));
    },
    appendPrompts:function(prompts){
        if(!isc.isAn.Array(prompts)){
            this.appendPrompt(prompts);
            return;
        }
        for(var i=0;i<prompts.length;++i){
            this.appendPrompt(prompts[i]);
        }
    },
    appendHelpDocuments:function(helpDocuments){
        if(helpDocuments&&helpDocuments.length>0){
            var content="";
            for(var h=0;h<helpDocuments.length;++h){
                var helpDocument=helpDocuments[h];
                content+="<requirements-document topic=\""+(helpDocument.topic||helpDocument.ID).trim()+"\"";
                if(helpDocument.format)content+=" format=\""+helpDocument.format.trim()+"\"";
                content+=">\n"
                    +helpDocument.content.trim()+"\n"
                    +"</requirements-document>\n";
            }
            this.aiMessages.push({
                source:"system",
                content:content
            });
        }
    },
    renderTemplate:function(templateName){
        var templateOutput=(this.target||isc.AI).render(templateName,this.evalVars);
        var pos=templateOutput.indexOf(this.ssMessagesPlaceholder);
        if(pos<0)pos=0;
        else{
            if(pos>0){
                this.aiMessages.push({
                    source:"system",
                    content:templateOutput.substring(0,pos)
                });
            }
            this.__appendSSMessages();
            pos+=this.ssMessagesPlaceholder.length;
        }
        if(pos<templateOutput.length){
            this.aiMessages.push({
                source:"system",
                content:templateOutput.substring(pos)
            });
        }
    }
});
isc.defineClass("InternalAIMessagesBuilder2","InternalAIMessagesBuilder");
isc.A=isc.InternalAIMessagesBuilder2.getPrototype();
isc.A.ssMessagesProperty="ssMessages";
isc.A.ssMessagesPlaceholder="${ssMessages}"
;

isc.defineClass("AIEngine").addClassProperties({
    defaultHistoryIntroduction:"You have previously interacted with the user as follows. "+
        "Each prior message from the user is delineated by ^^^^^^^ both before and after "+
        "their message. Your responses are delineated by ####### both before and after your "+
        "message.",
    defaultHistoryConclusion:"That is the end of your previous interaction with the user. "+
        "You are now to respond to the following.",
    defaultHistoryDelimiters:{
        "system":"\n\n",
        "user":"^^^^^^^\n",
        "AI":"#######\n"
    },
    _isTextContentType:function(type){
        return type==null||type=="text";
    },
    _isImageContentType:function(type){
        return type=="jpegImage"||type=="pngImage";
    },
    isImageMessage:function(aiMessage){
        return this._isImageContentType(aiMessage.type);
    },
    getImageFormat:function(contentType){
        if(contentType=="jpegImage"){
            return"jpeg";
        }else if(contentType=="png"||contentType=="pngImage"){
            return"png";
        }else{
            return null;
        }
    },
    _getMIMEType:function(imageMessage){
        this._assert(this.isImageMessage(imageMessage));
        return imageMessage.type=="jpegImage"?"image/jpeg":"image/png";
    },
    containsImageMessage:function(aiMessages){
        if(aiMessages!=null){
            for(var i=0;i<aiMessages.length;++i){
                if(this.isImageMessage(aiMessages[i])){
                    return true;
                }
            }
        }
        return false;
    },
    isVisionRequest:function(aiRequest){
        if(this.containsImageMessage(aiRequest.messages)){
            return true;
        }
        return false;
    },
    cloneAIRequest:function(aiRequest){
        var clonedRequest=isc.addPropertiesWithAssign({},aiRequest);
        delete clonedRequest._isNormalized;
        if(isc.isAn.Array(clonedRequest.messages)){
            clonedRequest.messages=clonedRequest.messages.duplicate();
        }
        return clonedRequest;
    },
    _sendRequestCallbackArgNames:"aiResponse,aiRequest"
});
isc.A=isc.AIEngine.getPrototype();
isc.B=isc._allFuncs;
isc.C=isc.B._maxIndex;
isc.D=isc._funcClasses;
isc.D[isc.C]=isc.A.Class;
isc.A.maxRecordsPerBatch=10;
isc.A._aiTransactions=[];
isc.A.recordPickingBatchTimeout=20000;
isc.A.fieldPagingPrompts=[
        "A user is interacting with an Isomorphic SmartClient web application.\n"+
        "They wish to take the following action - \"${actionDescription}\" - on "+
        "a data-bound component (such as a ListGrid) based on the following query prompt:",
        "${userMessages}",
        "The dataSource the component is bound to has a large number of fields, many of which "+
        "are unlikely to be relevant to the action being performed.\n"+
        "The objects in the source-array below represent a subset of these available fields."+
        "Using the properties on each field object for the dataSource and your own knowledge, "+
        "determine which fields are relevant to the user-supplied query prompt.\n"+
        "For example, if the query was 'amount is larger than 100', you should look for a field with a name, "+
        "title or description most related to 'amount'. Note that the user may not use the exact field name or "+
        "title in their query. For example if the user refers to 'amount' they may be referring to 'quantity', 'price', 'cost' "+
        "or similar fields. Please return all field objects that could be relevant.\n\n"+
        "Your response should be an object serialized in JSON format with a single property called 'result'. "+
        "This property should be set to an array of integers, where each integer is the index of a matching record in the source-array below.  "+
        "For example, if the first field object in the array below may be relevant to the user's query, your response array "+
        "must include its source-array index (0) as the first entry.  Similarly, the source-array indices of any "+
        "other matching field objects must also be in your response array.\n\n"+
        "If a field object is not relevant to the query prompt, do not include its index in your response array.\n\n"+
        "If no field objects are relevant, the 'result' property in your response object should be set to an empty array.\n\n"+
        "Apart from this object, your response must not include any other preamble or content of any kind."
    ];
isc.A._basicTypes=[null,"text","number","object","array"];
isc.A.requestOperationId="createChatCompletion";
isc.A.rateLimitInitialDelay=5000;
isc.A.rateLimitMaxDelay=60000;
isc.A.rateLimitBackoffFactor=2;
isc.A.rateLimitMaxRetries=4;
isc.B.push(isc.A.getRecordsPerPrompt=function isc_AIEngine_getRecordsPerPrompt(sampleRecords,fixedPrompt,settings){
        this._assert(isc.isAn.Array(sampleRecords));
        var data=sampleRecords;
        fixedPrompt=fixedPrompt||0;
        settings=settings||{};
        settings.startIndex=settings.startIndex||0;
        var tokenStats={
            fixedTokens:isc.isA.Number(parseInt(fixedPrompt))?parseInt(fixedPrompt):
                this.estimateTokenCount(fixedPrompt),
            responseTokensPerRecord:settings.responseTokensPerRecord,
            totalTokens:null,
            avgTokens:null,
            minTokens:null,
            maxTokens:null,
            usedTokens:null,
            remainingTokens:null
        };
        var serializedRecords=[];
        var result={
            status:null,
            engineId:this.engineId,
            totalRecords:data.length,
            startIndex:settings.startIndex,
            numRecords:0,
            exactNumRecords:0,
            variance:1,
            tokenStats:tokenStats,
            formatDescription:null,
            serializedForm:serializedRecords
        };
        var availableDataTokens=this.tokenLimit-tokenStats.fixedTokens;
        var dataTokens=0;
        var format=settings.serializationFormat||this.serializationFormat;
        var isJSON=format!="csv";
        var isCompactJSON=format=="compactJSON";
        var recordSeparator=(isCompactJSON?",":(isJSON?",\n":"\n"));
        for(var i=settings.startIndex;i<data.length;i++){
            var record=data[i];
                var processed={};
                processed.record=isc.AI.serializeIndexedRecord(record,i,settings);
                processed.tokenCount=this.estimateTokenCount(processed.record+recordSeparator);
                if(result.numRecords==0||availableDataTokens>=processed.tokenCount){
                    serializedRecords.add(processed);
                    result.numRecords++;
                    result.exactNumRecords=result.numRecords;
                    dataTokens+=processed.tokenCount;
                    availableDataTokens-=processed.tokenCount;
                    if(availableDataTokens<0){
                        result.status="The number of fixed tokens already exceeds the token limit.";
                        result.exactNumRecords=0;
                        break;
                    }
                }else{
                    var delta=processed.tokenCount-availableDataTokens;
                    result.exactNumRecords=result.numRecords+(delta/processed.tokenCount);
                    break;
                }
            if(settings.aiPageSize&&result.numRecords>=settings.aiPageSize){
                break;
            }
        }
        tokenStats.totalTokens=dataTokens;
        tokenStats.minTokens=serializedRecords.getProperty("tokenCount").min();
        tokenStats.maxTokens=serializedRecords.getProperty("tokenCount").max();
        tokenStats.avgTokens=Math.ceil(serializedRecords.getProperty("tokenCount").sum()/result.numRecords);
        tokenStats.remainingTokens=availableDataTokens;
        result.variance=tokenStats.maxTokens/tokenStats.minTokens;
        return result;
    }
,isc.A.getBatches=function isc_AIEngine_getBatches(templateAIRequest,records,settings){
        this._assert(isc.isAn.Array(records));
        settings=settings||{};
        var formatDescription=isc.AI.getFormatDescription(settings);
        templateAIRequest=isc.AIEngine.cloneAIRequest(templateAIRequest);
        if(!templateAIRequest.messages)templateAIRequest.messages=[];
        templateAIRequest.messages.push({source:"system",content:formatDescription});
        var lastMessageIndex=templateAIRequest.messages.length-1;
        var fixedTokens=this.estimateRequestTokenCount(templateAIRequest);
        if(settings.aiPageSize==0)settings.aiPageSize=null;
        if(this.maxRecordsPerBatch){
            if(!isc.isA.Number(settings.aiPageSize))settings.aiPageSize=this.maxRecordsPerBatch;
            else settings.aiPageSize=Math.min(settings.aiPageSize,this.maxRecordsPerBatch);
        }
        var batches=[];
        for(var i=0,len=records.length;i<len;){
            var nextSettings=isc.addPropertiesWithAssign({},settings);
            nextSettings.startIndex=i;
            var batchingInfo=this.getRecordsPerPrompt(records,fixedTokens,nextSettings);
            this._assert(batchingInfo.numRecords>0);
            var serializedRecords=batchingInfo.serializedForm.getProperty("record");
            this._assert(serializedRecords.length==batchingInfo.numRecords);
            var aiRequest=isc.AIEngine.cloneAIRequest(templateAIRequest);
            for(var m=0;m<lastMessageIndex;++m){
                var message=aiRequest.messages[m];
                if(message.source=="system"&&
                    isc.AIEngine._isTextContentType(message.type)&&
                    isc.isA.nonemptyString(message.content))
                {
                    message=isc.addPropertiesWithAssign({},message);
                    message.content=message.content.evalDynamicString(this,batchingInfo);
                    aiRequest.messages[m]=message;
                }
            }
            aiRequest.messages[lastMessageIndex]={
                source:"system",
                content:formatDescription+isc.AI._joinSerializedRecords(serializedRecords,settings)
            };
            batches.push({
                aiRequest:aiRequest,
                startIndex:i,
                length:batchingInfo.numRecords,
                _formatDescription:formatDescription,
                _serializedRecords:serializedRecords,
                _settings:settings
            });
            i+=batchingInfo.numRecords
        }
        return batches;
    }
,isc.A.splitBatch=function isc_AIEngine_splitBatch(batch){
        this._assert(batch.length>=2);
        var newStartIndex1=batch.startIndex,
            newLength1=batch.length>>1,
            newStartIndex2=batch.startIndex+newLength1,
            newLength2=batch.length-newLength1;
        this._assert(newLength1>=1&&newLength2>=1);
        var aiRequest=batch.aiRequest,
            lastMessageIndex=aiRequest.messages.length-1,
            formatDescription=batch._formatDescription,
            settings=batch._settings;
        var newSerializedRecords1=batch._serializedRecords.slice(0,newLength1),
            newAIRequest1=isc.AIEngine.cloneAIRequest(aiRequest);
        this._assert(newSerializedRecords1.length==newLength1);
        newAIRequest1.messages[lastMessageIndex]={
            source:"system",
            content:formatDescription+isc.AI._joinSerializedRecords(newSerializedRecords1,settings)
        };
        var newSerializedRecords2=batch._serializedRecords.slice(newLength1),
            newAIRequest2=isc.AIEngine.cloneAIRequest(aiRequest);
        this._assert(newSerializedRecords2.length==newLength2);
        newAIRequest2.messages[lastMessageIndex]={
            source:"system",
            content:formatDescription+isc.AI._joinSerializedRecords(newSerializedRecords2,settings)
        };
        return[{
            aiRequest:newAIRequest1,
            startIndex:newStartIndex1,
            length:newLength1,
            _formatDescription:formatDescription,
            _serializedRecords:newSerializedRecords1,
            _settings:settings
        },{
            aiRequest:newAIRequest2,
            startIndex:newStartIndex2,
            length:newLength2,
            _formatDescription:formatDescription,
            _serializedRecords:newSerializedRecords2,
            _settings:settings
        }];
    }
,isc.A.doPageRecordsPicking=function isc_AIEngine_doPageRecordsPicking(aiMessages,records,callback,settings){
        settings=settings||{};
        var _self=this;
        var transactions=this._aiTransactions;
        var transaction={
            id:"aiTransaction_"+transactions.length,
            engineId:this.engineId,
            postProcessCallback:callback,
            progressCallback:settings.progressCallback,
            batches:[],
            results:[]
        };
        transactions.add(transaction);
        var cancellationController=settings.cancellationController,
            subCancellationController=isc.CancellationController.create();
        var data=records;
        if(data.localData)data=data.localData;
        var completeTransaction=function(transaction){
            transactions.remove(transaction);
            var matches=[];
            for(var i=0;i<transaction.batches.length;i++){
                var batch=transaction.batches[i];
                if(settings.keepEmptyMatches){
                    _self._assert(batch.result.getLength()==batch.length);
                    matches.addList(batch.result);
                }else{
                    for(var j=0;j<batch.result.length;j++){
                        var recordIndex=batch.result[j];
                        var match=data.get(recordIndex);
                        if(match==null){
                            _self.logWarn("Unable to find match for index in data: "+recordIndex,"AI");
                        }else{
                            matches.add(match);
                        }
                    }
                }
            }
            _self.logDebug("Completing AI Transaction "+transaction.id+", with "+
                transaction.batches.length+" batches covering "+
                data.length+" total records, and "+matches.length+" matches","AI");
            _self.fireCallback(transaction.postProcessCallback,"matches,batches",[matches,transaction.batches]);
        };
        if(!isc.isAn.Array(data)||data.length<=0){
            this.delayFireCallback(completeTransaction,"transaction",[transaction]);
            return transaction;
        }
        var finishedRows=0;
        var addTransactionBatch=function(transaction,batch){
            _self.logDebug("Adding batch "+batch.batchId+" to AI-transaction "+transaction.id,"AI");
            transaction.batches.add(batch);
            var aiRequest=batch.aiRequest;
            _self.sendRequest(aiRequest,function(aiResponse){
                finishedRows+=batch.length;
                var arrResult;
                if(aiResponse.type!="success"){
                    arrResult=[];
                    batch.nonSuccessfulResult=aiResponse;
                }else{
                    arrResult=aiResponse.message&&aiResponse.message.content&&aiResponse.message.content.result;
                    if(!isc.isAn.Array(arrResult))arrResult=[arrResult];
                }
                if(settings.keepEmptyMatches){
                    while(arrResult.length<batch.length){
                        arrResult.push(isc.AI.invalidSummaryValue);
                    }
                    if(arrResult.length>batch.length)arrResult.setLength(batch.length);
                }else{
                    arrResult.removeEmpty();
                }
                batch.result.addList(arrResult);
                transaction.results.addList(arrResult);
                batch.executing=0;
                var matches=transaction.results.length;
                if(transaction.progressCallback){
                    var isCanceled=cancellationController&&cancellationController.canceled,
                        progressCallbackResult=transaction.progressCallback(finishedRows,data.length,matches),
                        shouldContinue=!isCanceled&&progressCallbackResult!==false;
                    if(!shouldContinue){
                        var cancellationReason=isCanceled?cancellationController.cancellationReason:"progressCallback() returned `false`.";
                        if(!subCancellationController.canceled){
                            subCancellationController.cancel(cancellationReason,"application");
                        }
                        _self.logDebug("doPageRecordsPicking() transaction "+transaction.id+" was canceled by the progressCallback.","AI");
                        return;
                    }
                }
                if(transaction.batches.getProperty("executing").sum()==0){
                    completeTransaction(transaction);
                }
            },{
                showPrompt:false,
                ignoreTokenLimit:true,
                requestProperties:{timeout:this.recordPickingBatchTimeout},
                maxRetries:settings.maxRetries
            });
        };
        var templateAIRequest={
            messages:aiMessages,
            responseType:"object",
            cancellationController:subCancellationController
        };
        var batches=this.getBatches(templateAIRequest,data,settings);
        for(var batchId=0;batchId<batches.length;++batchId){
            var batch=batches[batchId];
            isc.addPropertiesWithAssign(batch,{
                batchId:batchId,
                range:[batch.startIndex,batch.startIndex+batch.length-1],
                executing:1,
                result:[]
            });
            addTransactionBatch(transaction,batch);
        }
        return transaction;
    }
,isc.A.shouldUseAIFieldPaging=function isc_AIEngine_shouldUseAIFieldPaging(aiRequest,fields,aiConfig){
        if(!isc.AI.useAIFieldPaging)return false;
        var recordPickingSettings={
            engineId:this.engineId,
            fieldNames:aiConfig.salientFieldAttributes||isc.AI.salientFieldAttributes,
            serializationFormat:aiConfig.serializationFormat
        };
        var tokenEstimate=this.estimateRequestTokenCount(aiRequest);
        var batchingInfo=this.getRecordsPerPrompt(fields,tokenEstimate,recordPickingSettings);
        return(batchingInfo.totalRecords>batchingInfo.numRecords);
    }
,isc.A.retrieveFieldsForPrompt=function isc_AIEngine_retrieveFieldsForPrompt(userMessages,actionDescription,fields,callback,context,aiConfig){
        var aiMessagesBuilder=isc.InternalAIMessagesBuilder.create({
            userMessages:userMessages,
            target:this,
            evalVars:{
                actionDescription:actionDescription
            }
        });
        aiMessagesBuilder.appendPrompts(this.fieldPagingPrompts);
        context=context||{};
        var progressCallback=context.progressCallback;
        var aiPageSize=context.aiPageSize;
        if(aiPageSize==0)aiPageSize=null;
        var salientFieldAttributes=aiConfig&&aiConfig.salientFieldAttributes;
        if(salientFieldAttributes==null)salientFieldAttributes=isc.AI.salientFieldAttributes;
        var recordPickingSettings={
            engineId:this.engineId,
            fieldNames:salientFieldAttributes,
            aiPageSize:aiPageSize,
            progressCallback:progressCallback
        };
        this.doPageRecordsPicking(aiMessagesBuilder.aiMessages,fields,function(results){
            isc.AI.fireCallback(callback,"finalFields",[results]);
        },recordPickingSettings);
    }
,isc.A.asyncRetrieveFieldsForPrompt=function isc_AIEngine_asyncRetrieveFieldsForPrompt(userMessages,actionDescription,fields,context,aiConfig){
        var resolversObj=Promise.withResolvers();
        this.retrieveFieldsForPrompt(userMessages,actionDescription,fields,function(finalFields){
            resolversObj.resolve(finalFields);
        },context,aiConfig);
        return resolversObj.promise;
    }
,isc.A.estimateTokenCount=function isc_AIEngine_estimateTokenCount(text){
        text=text||"";
        var words=text.trim().split(/\s/);
        var tokenLength=3;
        var count=0;
        for(var i=0;i<words.length;i++){
            var splitWord=words[i].split(/\W/);
            count+=splitWord.length-1;
            for(var ii=0;ii<splitWord.length;ii++){
                count+=Math.max(1,splitWord[ii].length/tokenLength);
            }
        }
        return Math.ceil(count);
    }
,isc.A.estimateMessageTokenCount=function isc_AIEngine_estimateMessageTokenCount(aiMessage){
        if(aiMessage.type=="jpegImage"||aiMessage.type=="pngImage"){
            return 1000;
        }
        var content=aiMessage.content;
        if((aiMessage.type=="array"||aiMessage.type=="object")&&
            !isc.isA.String(content)&&
            isc.isAn.Object(content))
        {
            content=isc.AI._encodeJSON(content);
        }
        return this.estimateTokenCount(String(content));
    }
,isc.A.estimateRequestTokenCount=function isc_AIEngine_estimateRequestTokenCount(aiRequest){
        aiRequest=this.normalizeRequest(aiRequest);
        this._assert(aiRequest.prompt==null);
        var promptText=this.makePromptText(aiRequest);
        return this.estimateTokenCount(promptText);
    }
,isc.A.getTokenLimit=function isc_AIEngine_getTokenLimit(aiRequest){
        return this.tokenLimit;
    }
,isc.A.couldSupportRequest=function isc_AIEngine_couldSupportRequest(aiRequest){
        aiRequest=this.normalizeRequest(aiRequest);
        if(!this._basicTypes.contains(aiRequest.responseType)){
            return false;
        }
        const messages=aiRequest.messages,
            canSupportVisionRequests=this.canSupportVisionRequests();
        if(messages!=null){
            for(var i=0;i<messages.length;++i){
                var message=messages[i];
                if(this._basicTypes.contains(message.type)){
                    continue;
                }
                if(canSupportVisionRequests&&isc.AIEngine._isImageContentType(message.type)){
                    continue;
                }
                return false;
            }
        }
        var tokenEstimate=this.estimateRequestTokenCount(aiRequest);
        if(tokenEstimate>this.getTokenLimit(aiRequest)){
            return false;
        }
        return true;
    }
,isc.A.canSupportVisionRequests=function isc_AIEngine_canSupportVisionRequests(){
        return false;
    }
,isc.A.sendRequest=function isc_AIEngine_sendRequest(aiRequest,callback,config){
        config=isc.addProperties({retryIndex:0},config);
        var rawRequest=this.transformRequest(aiRequest,config);
        this.handleSendRequest(rawRequest,aiRequest,callback,config);
    }
,isc.A.asyncSendRequest=function isc_AIEngine_asyncSendRequest(aiRequest,config){
        if(aiRequest.cancellationController&&aiRequest.cancellationController.canceled){
            return Promise.reject(aiRequest.cancellationController.asCanceledResult());
        }
        var resolversObj=Promise.withResolvers();
        this.sendRequest(aiRequest,function(aiResponse){
            if(aiResponse.type=="success")resolversObj.resolve(aiResponse);
            else resolversObj.reject(aiResponse);
        },config);
        return resolversObj.promise;
    }
,isc.A.normalizeRequest=function isc_AIEngine_normalizeRequest(aiRequest){
        if(aiRequest._isNormalized)return aiRequest;
        var messages=aiRequest.messages;
        var copied=false;
        var doCopy=function(){
            aiRequest=isc.addProperties({},aiRequest);
            messages=aiRequest.messages=(messages==null?null:messages.duplicate());
            copied=true;
        }
        if(messages!=null){
            for(var i=0;i<messages.length;++i){
                var message=messages[i],
                    messageCopied=false;
                if(message.source==null||
                    (message.source!="system"&&message.source!="user"&&message.source!="AI"))
                {
                    if(message.source!=null){
                        this.logWarn("Unrecognized AIMessageSource '"+message.source+"'. Changing to 'user'","AI");
                    }
                    if(!copied)doCopy();
                    if(!messageCopied){
                        message=messages[i]=isc.addProperties({},message);
                        messageCopied=true;
                    }
                    message.source="user";
                }
                if(message.type=="number"&&!isc.isA.String(message.content)){
                    if(!copied)doCopy();
                    if(!messageCopied){
                        message=messages[i]=isc.addProperties({},message);
                        messageCopied=true;
                    }
                    message.content=String(message.content);
                    delete message.type;
                }
                if((message.type=="object"||message.type=="array")&&
                    !isc.isA.String(message.content)&&
                    isc.isAn.Object(message.content))
                {
                    if(!copied)doCopy();
                    if(!messageCopied){
                        message=messages[i]=isc.addProperties({},message);
                        messageCopied=true;
                    }
                    message.content=isc.AI._encodeJSON(message.content);
                    delete message.type;
                }
            }
        }
        if(aiRequest.prompt!=null){
            if(!copied)doCopy();
            aiRequest._origPrompt=aiRequest.prompt;
            if(messages==null){
                messages=aiRequest.messages=[];
            }
            messages.push({source:"user",content:aiRequest.prompt});
            delete aiRequest.prompt;
        }
        if(aiRequest.responseType=="number"){
            if(!copied)doCopy();
            if(messages==null){
                messages=aiRequest.messages=[];
            }
            var content="Your response must only be a number";
            if(aiRequest.responseMinimum!=null){
                if(aiRequest.responseMaximum!=null){
                    content+=(" between "+aiRequest.responseMinimum+" and "+
                                              aiRequest.responseMaximum+" inclusive.");
                }else{
                    content+=" at least "+aiRequest.responseMinimum+".";
                }
            }else if(aiRequest.responseMaximum!=null){
                content+=" no more than "+aiRequest.responseMaximum+".";
            }else{
                content+=".";
            }
            messages.push({source:"system",content:content});
            delete aiRequest.responseType;
        }
        if(aiRequest.responseType=="array"||aiRequest.responseType=="object"){
            var requestsJSON=false;
            if(messages!=null){
                for(var i=0;i<messages.length;++i){
                    var message=messages[i];
                    if(isc.AIEngine._isTextContentType(message.type)&&
                        /JSON/i.test(message.content))
                    {
                        requestsJSON=true;
                        break;
                    }
                }
            }
            if(!requestsJSON){
                if(!copied)doCopy();
                if(messages==null){
                    messages=aiRequest.messages=[];
                }
                messages.push({
                    source:"system",
                    content:"Your response must only be a JSON "+aiRequest.responseType+"."
                });
            }
        }
        aiRequest._isNormalized=true;
        return aiRequest;
    }
,isc.A.getTemperature=function isc_AIEngine_getTemperature(aiRequest){
        return(aiRequest&&aiRequest.temperature!=null?aiRequest.temperature:this.temperature);
    }
,isc.A.makeNonTextPromptPart=function isc_AIEngine_makeNonTextPromptPart(aiMessage){
        return"*non-text content*\n";
    }
,isc.A.makePromptParts=function isc_AIEngine_makePromptParts(aiRequest){
        aiRequest=this.normalizeRequest(aiRequest);
        this._assert(aiRequest.prompt==null);
        var historyDelimiters=isc.addProperties({},isc.AIEngine.defaultHistoryDelimiters,aiRequest.historyDelimiters);
        var parts=[],
            messages=aiRequest.messages;
        var lastPartIsNonStringOrStringEndingWith=(function(suffix){
            this._assert(parts.length>0);
            var lastPart=parts[parts.length-1];
            if(!isc.isA.String(lastPart))return true;
            return lastPart.endsWith(suffix);
        }).bind(this);
        var appendPart=function(part){
            if(isc.isA.String(part)&&
                parts.length>0&&
                isc.isA.String(parts[parts.length-1]))
            {
                parts[parts.length-1]+=part;
            }else{
                parts.push(part);
            }
        };
        if(messages!=null){
            var appendMessageContent=(function(message){
                if(parts.length>0){
                    var historyDelim=String(historyDelimiters["system"]);
                    if(message.source=="system"&&!lastPartIsNonStringOrStringEndingWith(historyDelim)){
                        appendPart(historyDelim);
                    }else if(!lastPartIsNonStringOrStringEndingWith('\n')){
                        appendPart("\n");
                    }
                }
                if(!isc.AIEngine._isTextContentType(message.type)){
                    appendPart(this.makeNonTextPromptPart(message));
                }else{
                    appendPart(String(message.content));
                }
            }).bind(this);
            var firstNonSystemMessageIndex=0;
            for(;firstNonSystemMessageIndex<messages.length;++firstNonSystemMessageIndex){
                var i=firstNonSystemMessageIndex;
                if(messages[i].source!="system"){
                    break;
                }
                appendMessageContent(messages[i]);
            }
            var i=firstNonSystemMessageIndex,
                iEnd=messages.length;
            for(;iEnd>i&&messages[iEnd-1].source=="system";--iEnd){}
            if(i<iEnd){
                var lastSource=messages[iEnd-1].source;
                this._assert(lastSource!="system");
                for(;iEnd-1>i&&(messages[iEnd-1-1].source=="system"||
                                      messages[iEnd-1-1].source==lastSource);--iEnd)
                {
                }
            }
            if(i<=iEnd-2){
                appendMessageContent({
                    source:"system",
                    content:(aiRequest.historyIntroduction!=null
                              ?aiRequest.historyIntroduction
                              :isc.AIEngine.defaultHistoryIntroduction)
                });
                for(;i<iEnd-1;++i){
                    var message=messages[i],
                        historyDelim=String(historyDelimiters[message.source||"user"]);
                    if(message.source!="system"){
                        if(parts.length>0&&!lastPartIsNonStringOrStringEndingWith("\n"))appendPart("\n");
                        appendPart(historyDelim);
                    }
                    appendMessageContent(message);
                    if(message.source!="system"){
                        if(parts.length>0&&!lastPartIsNonStringOrStringEndingWith("\n"))appendPart("\n");
                        appendPart(historyDelim);
                    }
                }
                appendMessageContent({
                    source:"system",
                    content:(aiRequest.historyConclusion!=null
                              ?aiRequest.historyConclusion
                              :isc.AIEngine.defaultHistoryConclusion)
                });
            }
            for(;i<messages.length;++i){
                appendMessageContent(messages[i]);
            }
        }
        return parts;
    }
,isc.A.makePromptText=function isc_AIEngine_makePromptText(aiRequest){
        var parts=this.makePromptParts(aiRequest);
        return parts.join("");
    }
,isc.A.transformRequest=function isc_AIEngine_transformRequest(aiRequest,config){
        aiRequest=this.normalizeRequest(aiRequest);
        var promptText=this.makePromptText(aiRequest);
        if(!config.ignoreTokenLimit&&this.tokenLimit!=null){
            var tokenCount=this.estimateTokenCount(promptText);
            if(tokenCount>this.tokenLimit){
                this.logWarn("Approximate token count for prompt text is: "+tokenCount+
                             ". This exceeds the token limit for the ai engine: "+this.name+
                             ". This request may be rejected by the AI server (proceeding anyway).","AI");
            }else{
                this.logDebug("Estimated token count for prompt is: "+tokenCount,"AI");
            }
        }
        return{
            engineId:this.engineId,
            model:this.model,
            temperature:this.getTemperature(aiRequest),
            text:promptText
        };
    }
,isc.A.getDataSourceName=function isc_AIEngine_getDataSourceName(aiRequest){
        return this.dataSourceName||isc.AI.dataSourceName;
    }
,isc.A._getDataSource=function isc_AIEngine__getDataSource(rawRequest,aiRequest,callback,config){
        var ds=isc.AI._getDataSource(this.engineId,aiRequest),
            dataSourceName=this.getDataSourceName(aiRequest);
        if(ds==null&&dataSourceName){
            if(isc.AI.autoLoadDataSource&&!isc.AI._loadDSFailed[dataSourceName]){
                isc.AI._pendingRequests.add({
                    engine:this,
                    rawRequest:rawRequest,
                    aiRequest:aiRequest,
                    callback:callback,
                    config:config
                });
                isc.AI.loadDataSource(dataSourceName);
            }else{
                this.logWarn("No AI DataSource configured","AI");
            }
        }
        return ds;
    }
,isc.A.handleSendRequest=function isc_AIEngine_handleSendRequest(rawRequest,aiRequest,callback,config){
        if(aiRequest.cancellationController&&aiRequest.cancellationController.canceled){
            var nonSuccessfulResult=aiRequest.cancellationController.asCanceledResult();
            this.delayFireCallback(callback,isc.AIEngine._sendRequestCallbackArgNames,[nonSuccessfulResult,aiRequest,config]);
            return;
        }
        var ds=this._getDataSource(rawRequest,aiRequest,callback,config);
        if(!ds){
            const dsName=this.getDataSourceName(aiRequest);
            if(!isc.AI._loadingDS[dsName]&&!isc.AI._loadDSFailed[dsName]){
                isc.AI.logError("DataSource '"+dsName+"' not found or could not be loaded for AI request - cannot continue","AI");
            }
            return;
        }
        if(this.logIsDebugEnabled("AI")){
            this.logDebug("Prompt text to send to AI: "+this.makePromptText(aiRequest),"AI");
        }
        var dsRequest={
            operationId:this.requestOperationId,
            willHandleError:true,
            clientContext:config.context,
            showPrompt:!!config.showPrompt
        };
        if(config.requestProperties!=null){
            isc.addProperties(dsRequest,config.requestProperties);
        }
        var spoofingMode=config.responseSpoofingMode||isc.AI.responseSpoofingMode;
        if(spoofingMode!="none"){
            var spoofedResponse=isc.AI.getSpoofedResponse(aiRequest,this);
            if(spoofedResponse!=null||spoofingMode=="full"){
                this.logDebug("* Using a spoofed response for the current interaction. responseSpoofingMode is \""+spoofingMode+"\". *","AI");
                dsRequest.dataProtocol="clientCustom";
                if(dsRequest.clientContext==null){
                    dsRequest.clientContext={};
                }
                dsRequest.clientContext.dataSource=ds;
                dsRequest.clientContext.aiEngine=this;
                dsRequest.clientContext.aiRequest=aiRequest;
                dsRequest.clientContext.spoofingMode=spoofingMode;
                dsRequest.clientContext.spoofedResponse=spoofedResponse;
            }
        }
        var _this=this;
        ds.fetchData(
            rawRequest,
            function(dsResponse,data,dsRequest){
                var aiResponse,
                    errorResponseInfo;
                if(aiRequest.cancellationController&&aiRequest.cancellationController.canceled){
                    aiResponse=aiRequest.cancellationController.asCanceledResult();
                }else{
                    if(dsResponse._isSpoofed&&(data.makeAIResponse||data.aiResponse)){
                        aiResponse=data.makeAIResponse?data.makeAIResponse(aiRequest,_this):data.aiResponse;
                        errorResponseInfo=data.makeErrorResponseInfo?data.makeErrorResponseInfo(aiRequest,_this):data.errorResponseInfo;
                    }else{
                        var rawResponse=(dsResponse._isSpoofed?_this.makeSpoofedRawResponse(aiRequest,data.value):dsResponse.completeData||data);
                        if(dsResponse.status<0||_this.isErrorResponse(rawResponse,aiRequest)){
                            errorResponseInfo=_this.getErrorResponseInfo(rawResponse,rawRequest,aiRequest,config);
                            aiResponse=isc.createErrorResult(errorResponseInfo&&errorResponseInfo.errorMessage);
                        }else{
                            aiResponse=_this.transformRawResponse(rawResponse,rawRequest,aiRequest,config);
                        }
                    }
                    var context=dsRequest.clientContext||{};
                    if(isc.AI.captureTransactions&&!context.doNotCapture){
                        if(!aiRequest){
                            this.logWarn("Failed to capture transaction at index:"+isc.AI.captureTransactions.length+"\n"+this.echo(dsRequest));
                        }else{
                            var requestPrompt=_this.makePromptText(aiRequest);
                            var responseText=aiResponse.messageText;
                            isc.AI.captureTransaction({
                                aiRequest:isc.addProperties({},aiRequest),
                                aiResponse:isc.addProperties({},aiResponse),
                                prompt:requestPrompt,
                                value:responseText
                            });
                        }
                    }
                    if(aiResponse.type!="success"){
                        var errorType=errorResponseInfo&&errorResponseInfo.errorType;
                        if(errorType)aiResponse.errorType=errorType;
                        var retryIndex=Math.max(0,+config.retryIndex);
                        if(isNaN(retryIndex))retryIndex=0;
                        var maxRetries=Math.max(0,config.maxRetries!=null?config.maxRetries:
                                                  isc.AI.defaultMaxRetries);
                        if(isNaN(maxRetries))maxRetries=0;
                        if(retryIndex>=maxRetries){
                            aiResponse=isc.createErrorResult("Exceeded the maximum number of retries ("+
                                             maxRetries+").",{lastAIResponse:aiResponse});
                        }else if(errorResponseInfo&&errorResponseInfo.recoverable){
                            var retryDelay=errorResponseInfo.retryDelay||isc.AI.sendPromptRetryDelay;
                            rawRequest=errorResponseInfo.newRawRequest||rawRequest;
                            config.retryIndex=retryIndex+1;
                            if(!config._originalRequestId){
                                config._originalRequestId=dsRequest.requestId;
                            }
                            this.logDebug("Delaying original "+config._originalRequestId+" for "+
                                         retryDelay+"ms due to rate limiting.  Attempt "+
                                          config.retryIndex+" / "+config.maxRetries,"AI");
                            _this.delayCall("handleSendRequest",[rawRequest,aiRequest,callback,config],
                                            retryDelay);
                            return;
                        }
                    }
                }
                aiResponse=_this.normalizeResponse(aiResponse,aiRequest,config);
                _this.fireCallback(callback,isc.AIEngine._sendRequestCallbackArgNames,[aiResponse,aiRequest,config]);
            },
            dsRequest
        );
    }
,isc.A.makeSpoofedRawResponse=function isc_AIEngine_makeSpoofedRawResponse(aiRequest,spoofedResponseValue){
        return[{
            chat_role:"assistant",
            chat_content:spoofedResponseValue
        }];
    }
,isc.A.isErrorResponse=function isc_AIEngine_isErrorResponse(rawResponse,aiRequest){
        return!rawResponse||isc.isA.String(rawResponse)||!!rawResponse.error;
    }
,isc.A.getErrorResponseInfo=function isc_AIEngine_getErrorResponseInfo(rawResponse,rawRequest,aiRequest){
        if(isc.isA.String(rawResponse)){
            var obj=isc.AI._extractJsonResult(rawResponse);
            if(obj&&obj.error)rawResponse=obj;
            else return{errorMessage:"An error occurred. The response from the server was: "+rawResponse};
        }else if(!rawResponse||!rawResponse.error)return null;
        return{errorMessage:rawResponse.error.message};
    }
,isc.A.extractAIMessage=function isc_AIEngine_extractAIMessage(messageContent,rawRequest,aiRequest){
        var messageContentType="text";
        if(aiRequest.responseType=="array"||aiRequest.responseType=="object"){
            var tripleBacktickPos=messageContent.indexOf("```");
            if(tripleBacktickPos>=0){
                if(messageContent.indexOf("```json",tripleBacktickPos)>=0){
                    messageContent=isc.AI._extractJsonResult(messageContent,"```json","```",true);
                }else{
                    messageContent=isc.AI._extractJsonResult(messageContent,"```","```",true);
                }
            }else if(aiRequest.responseType=="array"&&messageContent.indexOf("[")>=0){
                messageContent=isc.AI._extractJsonResult(messageContent,"[","]");
            }else{
                messageContent=isc.AI._extractJsonResult(messageContent);
            }
            messageContentType=isc.isAn.Array(messageContent)?"array":"object";
        }
        return{source:"AI",content:messageContent,type:messageContentType};
    }
);
isc.evalBoundary;isc.B.push(isc.A.transformRawResponse=function isc_AIEngine_transformRawResponse(rawResponse,rawRequest,aiRequest,config){
        var content=isc.isAn.Array(rawResponse)&&rawResponse[0]&&rawResponse[0].chat_content;
        if(!isc.isA.String(content)){
            var errorMessage="Unable to extract the message from the AI response";
            this.logWarn(errorMessage,"AI");
            return isc.createErrorResult(errorMessage);
        }
        this.logDebug("Response text from AI: "+content,"AI");
        return{
            type:"success",
            message:this.extractAIMessage(content,rawRequest,aiRequest),
            messageText:content
        };
    }
,isc.A.normalizeResponse=function isc_AIEngine_normalizeResponse(aiResponse,aiRequest,config){
        if(!aiResponse)aiResponse={};
        if(aiResponse.type==null||aiResponse.type=="error"){
            aiResponse.type="error";
        }else{
            var message=aiResponse.message;
            if(message){
                var responseType=aiRequest.responseType||"text";
                if(responseType=="array"){
                    if(!isc.isAn.Array(message.content)){
                        message.content=[message.content];
                        message.type="array";
                    }
                }else if(responseType=="object"){
                    if(!isc.isAn.Object(message.content)||isc.isAn.Array(message.content)){
                        message.content={result:message.content};
                        message.type="object";
                    }
                }else if(responseType=="number"){
                    message.content=Number(message.content);
                    if(aiRequest.responseMinimum!=null){
                        message.content=Math.max(aiRequest.responseMinimum,message.content);
                    }
                    if(aiRequest.responseMaximum!=null){
                        message.content=Math.min(message.content,aiRequest.responseMaximum);
                    }
                    message.type="number";
                }
            }
        }
        return aiResponse;
    }
);
isc.B._maxIndex=isc.C+30;

isc.A=isc.AIEngine.getPrototype();
isc.A.temperature=0.7;
isc.A.tokenLimit=4096
;

isc.defineClass("BaseOpenAIEngine",isc.AIEngine);
isc.A=isc.BaseOpenAIEngine.getPrototype();
isc.B=isc._allFuncs;
isc.C=isc.B._maxIndex;
isc.D=isc._funcClasses;
isc.D[isc.C]=isc.A.Class;
isc.A.provider="OpenAI";
isc.A.dataSourceName="openAIRestConnector";
isc.A.requestOperationId="fetch";
isc.A.tokenLimit=4096;
isc.A.supportsJSONMode=false;
isc.A.supportsStructuredOutputs=false;
isc.A.rateLimitInstructOffset=5000;
isc.A.rateLimitDelayMode="backoff";
isc.B.push(isc.A.estimateRequestTokenCount=function isc_BaseOpenAIEngine_estimateRequestTokenCount(aiRequest){
        aiRequest=this.normalizeRequest(aiRequest);
        this._assert(aiRequest.prompt==null);
        var tokenEstimate=0,
            messages=aiRequest.messages;
        if(messages!=null){
            for(var i=0;i<messages.length;++i){
                tokenEstimate+=this.estimateMessageTokenCount(messages[i]);
            }
        }
        return tokenEstimate;
    }
,isc.A._mapAIMessageSourceToRole=function isc_BaseOpenAIEngine__mapAIMessageSourceToRole(source){
        if(!source)return"user";
        return source=="AI"?"assistant":source;
    }
,isc.A.transformRequest=function isc_BaseOpenAIEngine_transformRequest(aiRequest){
        aiRequest=this.normalizeRequest(aiRequest);
        var isVisionRequest=this.canSupportVisionRequests()&&isc.AIEngine.isVisionRequest(aiRequest);
        var request={
            model:isVisionRequest&&this.visionModel?this.visionModel:this.model||this.engineId,
            temperature:this.getTemperature(aiRequest),
            messages:null
        };
        var aiMessages=aiRequest.messages;
        if(aiMessages!=null){
            var messages=request.messages=new Array(aiMessages.length);
            for(var i=0;i<messages.length;++i){
                var aiMessage=aiMessages[i];
                messages[i]={
                    role:this._mapAIMessageSourceToRole(aiMessage.source),
                    content:null
                };
                if(isVisionRequest&&isc.AIEngine.isImageMessage(aiMessage)){
                    messages[i].content=[{
                        type:"image_url",
                        image_url:{
                            url:"data:image/"+(aiMessage.type=="jpegImage"?"jpeg":"png")+";base64,"+aiMessage.content
                        }
                    }];
                }else if(!isc.AIEngine._isTextContentType(aiMessage.type)){
                    messages[i].content=this.makeNonTextPromptPart(aiMessage);
                }else{
                    messages[i].content=String(aiMessage.content);
                }
            }
        }
        if(this.supportsJSONMode){
            if(aiRequest.responseType=="object"&&
                aiRequest.responseType!="array")
            {
                request.response_format={type:"json_object"};
            }
        }
        if(this.seed!=null)request.seed=this.seed;
        return request;
    }
,isc.A.makeSpoofedRawResponse=function isc_BaseOpenAIEngine_makeSpoofedRawResponse(aiRequest,spoofedResponseValue){
        return{
            choices:[{
                finish_reason:"stop",
                index:0,
                message:{
                    content:spoofedResponseValue,
                    role:"assistant"
                }
            }]
        };
    }
,isc.A.extractAIMessage=function isc_BaseOpenAIEngine_extractAIMessage(messageContent,rawRequest,aiRequest){
        if((messageContent.contains('{')||messageContent.contains('['))&&
            rawRequest&&rawRequest.response_format&&rawRequest.response_format.type=="json_object")
        {
            try{
                messageContent=isc.JSON.decode(messageContent);
                var messageContentType=isc.isAn.Array(messageContent)?"array":"object";
                return{source:"AI",content:messageContent,type:messageContentType};
            }catch(e){
                this.logWarn("JSON mode was enabled, but the response did not parse as JSON: "+e,"AI");
            }
        }
        return this.Super("extractAIMessage",arguments);
    }
,isc.A.getErrorResponseInfo=function isc_BaseOpenAIEngine_getErrorResponseInfo(rawResponse,rawRequest,aiRequest,config){
        if(isc.isA.String(rawResponse)){
            var obj=isc.AI._extractJsonResult(rawResponse);
            if(obj&&obj.error)rawResponse=obj;
            else return{errorMessage:"An error occurred. The response from the server was: "+rawResponse};
        }else if(!rawResponse||!rawResponse.error)return null;
        var errorResponse={errorMessage:rawResponse.error.message};
        var delayMode=config.rateLimitDelayMode||this.rateLimitDelayMode;
        if(rawResponse.error.code=="rate_limit_exceeded"&&delayMode!="none"){
            if(!config.retryIndex){
                if(!config.maxRetries)config.maxRetries=this.rateLimitMaxRetries;
            }
            switch(delayMode){
            case"instruct":
                var message=rawResponse.error.message;
                if(message){
                    var match=message.match(/token.*limit.*please try again in ([0-9.]+)s/i);
                    if(match){
                        errorResponse.retryDelay=Math.ceil(parseFloat(match[1])*1000)+
                                                            this.rateLimitInstructOffset,
                        errorResponse.recoverable=true;
                    }
                }
                break;
            case"backoff":
                if(config.retryDelay)config.retryDelay*=this.rateLimitBackoffFactor;
                else config.retryDelay=this.rateLimitInitialDelay;
                if(config.retryDelay>this.rateLimitMaxDelay){
                    config.retryDelay=this.rateLimitMaxDelay;
                }
                errorResponse.retryDelay=config.retryDelay;
                errorResponse.recoverable=true;
                break;
            }
        }
        return errorResponse;
    }
,isc.A.transformRawResponse=function isc_BaseOpenAIEngine_transformRawResponse(rawResponse,rawRequest,aiRequest){
        var aiResponse={type:"error"};
        if(!rawResponse){
            aiResponse.errorMessage="The response was empty.";
        }else if(rawResponse.error){
            aiResponse.errorMessage=rawResponse.error.message;
        }else{
            var choice=isc.isAn.Array(rawResponse.choices)&&rawResponse.choices[0];
            var messageContent=choice&&choice.message&&choice.message.content;
            if(!isc.isA.String(messageContent)){
                this.logWarn(aiResponse.errorMessage="Unable to extract the message from the AI response","AI");
            }else{
                this.logDebug("Response text from AI: "+messageContent,"AI");
                aiResponse.type="success";
                aiResponse.message=this.extractAIMessage(messageContent,rawRequest,aiRequest);
                aiResponse.messageText=messageContent;
            }
        }
        return aiResponse;
    }
);
isc.B._maxIndex=isc.C+7;

isc.defineClass("OpenAIReasoningEngine",isc.MultimodalGPTEngine);
isc.A=isc.OpenAIReasoningEngine.getPrototype();
isc.B=isc._allFuncs;
isc.C=isc.B._maxIndex;
isc.D=isc._funcClasses;
isc.D[isc.C]=isc.A.Class;
isc.A.tokenLimit=200000-25000;
isc.B.push(isc.A.transformRequest=function isc_OpenAIReasoningEngine_transformRequest(aiRequest){
        var rawRequest=this.Super("transformRequest",arguments);
        rawRequest.max_completion_tokens=25000;
        return rawRequest;
    }
);
isc.B._maxIndex=isc.C+1;

isc.defineClass("MultimodalGPTEngine",isc.BaseOpenAIEngine);
isc.A=isc.MultimodalGPTEngine.getPrototype();
isc.B=isc._allFuncs;
isc.C=isc.B._maxIndex;
isc.D=isc._funcClasses;
isc.D[isc.C]=isc.A.Class;
isc.A.tokenLimit=128000;
isc.B.push(isc.A.canSupportVisionRequests=function isc_MultimodalGPTEngine_canSupportVisionRequests(){
        return true;
    }
,isc.A.estimateMessageTokenCount=function isc_MultimodalGPTEngine_estimateMessageTokenCount(aiMessage){
        if(isc.AIEngine.isImageMessage(aiMessage)){
            return 85;
        }
        return this.Super("estimateMessageTokenCount",arguments);
    }
);
isc.B._maxIndex=isc.C+2;

isc.defineClass("GeminiProAIEngine",isc.AIEngine);
isc.A=isc.GeminiProAIEngine.getPrototype();
isc.B=isc._allFuncs;
isc.C=isc.B._maxIndex;
isc.D=isc._funcClasses;
isc.D[isc.C]=isc.A.Class;
isc.A.name="Gemini Pro";
isc.A.provider="Google";
isc.A.tokenLimit=30720;
isc.A.visionTokenLimit=12288;
isc.A.requestOperationId="fetch";
isc.A.dataSourceName="geminiProRestConnector";
isc.A.visionDataSourceName="geminiProVisionRestConnector";
isc.B.push(isc.A.canSupportVisionRequests=function isc_GeminiProAIEngine_canSupportVisionRequests(){
        return true;
    }
,isc.A.estimateRequestTokenCount=function isc_GeminiProAIEngine_estimateRequestTokenCount(aiRequest){
        aiRequest=this.normalizeRequest(aiRequest);
        this._assert(aiRequest.prompt==null);
        if(isc.AIEngine.isVisionRequest(aiRequest)){
            var promptParts=this.makePromptParts(aiRequest),
                tokenEstimate=0;
            for(var i=0;i<promptParts.length;++i){
                var promptPart=promptParts[i];
                if(isc.isA.String(promptPart)){
                    tokenEstimate+=this.estimateTokenCount(promptPart);
                }
            }
            return tokenEstimate;
        }
        var tokenEstimate=0,
            messages=aiRequest.messages;
        if(messages!=null){
            for(var i=0;i<messages.length;++i){
                tokenEstimate+=this.estimateMessageTokenCount(messages[i]);
            }
        }
        return tokenEstimate;
    }
,isc.A.getTokenLimit=function isc_GeminiProAIEngine_getTokenLimit(aiRequest){
        return(isc.AIEngine.isVisionRequest(aiRequest)?this.visionTokenLimit:this.tokenLimit);
    }
,isc.A.getDataSourceName=function isc_GeminiProAIEngine_getDataSourceName(aiRequest){
        return(isc.AIEngine.isVisionRequest(aiRequest)?this.visionDataSourceName:this.dataSourceName);
    }
,isc.A.makeNonTextPromptPart=function isc_GeminiProAIEngine_makeNonTextPromptPart(aiMessage){
        if(isc.AIEngine.isImageMessage(aiMessage)){
            return{
                inlineData:{
                    mimeType:isc.AIEngine._getMIMEType(aiMessage),
                    data:aiMessage.content
                }
            };
        }
        return this.Super("makeNonTextPromptPart",arguments);
    }
,isc.A.makePromptParts=function isc_GeminiProAIEngine_makePromptParts(aiRequest){
        aiRequest=this.normalizeRequest(aiRequest);
        var origMessages=aiRequest.messages,
            numTrailingImageMessages=0,
            lastMessage;
        if(origMessages!=null&&
            origMessages.length>0&&
            isc.AIEngine.isImageMessage(lastMessage=origMessages[origMessages.length-1]))
        {
            for(var iEnd=origMessages.length;iEnd>0;--iEnd){
                var message=origMessages[iEnd-1];
                if(!isc.AIEngine.isImageMessage(message)||
                    lastMessage.source!=message.source)
                {
                    break;
                }
                ++numTrailingImageMessages;
            }
        }
        if(numTrailingImageMessages==0||numTrailingImageMessages==origMessages.length){
            return this.Super("makePromptParts",[aiRequest]);
        }
        var messages=origMessages.duplicate();
        messages.setLength(messages.length-numTrailingImageMessages);
        var messageBeforeTrailingImageMessages=messages[messages.length-1];
        if(messageBeforeTrailingImageMessages.source!=lastMessage.source){
            messages.push({source:lastMessage.source,content:""});
        }
        var promptParts;
        try{
            aiRequest.messages=messages;
            promptParts=this.Super("makePromptParts",[aiRequest]);
        }finally{
            aiRequest.messages=origMessages;
        }
        for(var i=0;i<numTrailingImageMessages;++i){
            promptParts.push(this.makeNonTextPromptPart(origMessages[origMessages.length-numTrailingImageMessages+i]));
        }
        return promptParts;
    }
,isc.A.transformRequest=function isc_GeminiProAIEngine_transformRequest(aiRequest){
        aiRequest=this.normalizeRequest(aiRequest);
        var messages=aiRequest.messages;
        var generateContentRequest={
            contents:null,
            generationConfig:{
                temperature:this.getTemperature(aiRequest)
            }
        };
        if(isc.AIEngine.isVisionRequest(aiRequest)){
            var promptParts=this.makePromptParts(aiRequest);
            for(var i=0;i<promptParts.length;++i){
                if(isc.isA.String(promptParts[i])){
                    promptParts[i]={text:String(promptParts[i])};
                }
            }
            generateContentRequest.contents=[{parts:promptParts,role:"user"}];
        }else if(messages!=null){
            var contents=generateContentRequest.contents=[];
            for(var messageIndex=0;messageIndex<messages.length;++messageIndex){
                var message=messages[messageIndex];
                this._assert(!isc.AIEngine.isImageMessage(message));
                var part={text:String(message.content)};
                var role=(message.source=="AI"?"model":"user");
                if(contents.length>0&&contents[contents.length-1].role==role){
                    contents[contents.length-1].parts.push(part);
                }else{
                    contents.push({
                        parts:[part],
                        role:role
                    });
                }
            }
        }
        return generateContentRequest;
    }
,isc.A.isErrorResponse=function isc_GeminiProAIEngine_isErrorResponse(rawResponse,aiRequest){
        if(!rawResponse)return true;
        var promptFeedback=rawResponse.promptFeedback;
        if(promptFeedback&&promptFeedback.blockReason)return true;
        var candidates=rawResponse.candidates;
        if(!isc.isAn.Array(candidates)||candidates.length==0)return true;
        return candidates[0].finishReason!="STOP";
    }
,isc.A.getErrorResponseInfo=function isc_GeminiProAIEngine_getErrorResponseInfo(rawResponse,rawRequest,aiRequest){
        if(isc.isA.String(rawResponse)){
            var obj=isc.AI._extractJsonResult(rawResponse);
            if(obj&&obj.finishReason)rawResponse=obj;
            else return{errorMessage:"An error occurred. The response from the server was: "+rawResponse};
        }else if(!rawResponse)return null;
        var errorMessage,
            errorType;
        var promptFeedback=rawResponse.promptFeedback,
            candidates=rawResponse.candidates;
        if(promptFeedback&&promptFeedback.blockReason){
            if(promptFeedback.blockReason=="SAFETY"){
                errorMessage="The request was deemed unsafe.";
                errorType="requestUnsafe";
            }else{
                var usageMetadata=rawResponse.usageMetadata;
                if(usageMetadata&&
                    isc.isA.Number(usageMetadata.promptTokenCount)&&
                    usageMetadata.promptTokenCount>this.getTokenLimit(aiRequest))
                {
                    errorMessage="The request contained too many tokens.";
                    errorType="requestSizeLimitExceeded";
                }else{
                    errorMessage="The request was blocked for an unspecified reason.";
                }
            }
        }else if(!isc.isAn.Array(candidates)||candidates.length==0){
            errorMessage="No candidates were generated.";
        }else{
            var finishReason=candidates[0].finishReason;
            if(finishReason=="MAX_TOKENS"){
                errorMessage="The response contained too many tokens.";
                errorType="responseSizeLimitExceeded";
            }else if(finishReason=="SAFETY"){
                errorMessage="The response was blocked for safety reasons.";
                errorType="responseUnsafe";
            }else if(finishReason=="RECITATION"){
                errorMessage="The response was blocked for recitation reasons.";
            }else{
                errorMessage="The first candidate's finishReason was: "+finishReason;
            }
        }
        return{
            errorMessage:errorMessage,
            errorType:errorType
        };
    }
,isc.A.makeSpoofedRawResponse=function isc_GeminiProAIEngine_makeSpoofedRawResponse(aiRequest,spoofedResponseValue){
        if(aiRequest.responseType=="array"||aiRequest.responseType=="object"){
            spoofedResponseValue="```json\n"+spoofedResponseValue+"\n```";
        }
        return{
            candidates:[{
                content:{
                    parts:[{
                        text:spoofedResponseValue
                    }],
                    role:"model"
                },
                finishReason:"STOP"
            }]
        };
    }
,isc.A.transformRawResponse=function isc_GeminiProAIEngine_transformRawResponse(rawResponse,rawRequest,aiRequest){
        var aiResponse={type:"error"};
        var candidate=rawResponse&&isc.isAn.Array(rawResponse.candidates)&&rawResponse.candidates[0];
        var parts=candidate&&candidate.content&&candidate.content.parts;
        if(parts==null||parts.length==0){
            this.logWarn(aiResponse.errorMessage="Unable to extract the message from the AI response","AI");
        }else{
            var messageContent="";
            if(parts.length>1)this.logWarn(parts.length+" parts were in the AI response","AI");
            for(var i=0;i<parts.length;++i){
                var part=parts[i];
                if(!("text"in part)){
                    this.logWarn("message part was not text: "+isc.JSON.encode(part),"AI");
                }else{
                    messageContent=(messageContent!=""?"\n":"")+part.text;
                }
            }
            this.logDebug("Response text from AI: "+messageContent,"AI");
            aiResponse.type="success";
            aiResponse.message=this.extractAIMessage(messageContent,rawRequest,aiRequest);
            aiResponse.messageText=messageContent;
        }
        return aiResponse;
    }
);
isc.B._maxIndex=isc.C+11;

isc.defineClass("BedrockAIEngine",isc.AIEngine);
isc.A=isc.BedrockAIEngine.getPrototype();
isc.B=isc._allFuncs;
isc.C=isc.B._maxIndex;
isc.D=isc._funcClasses;
isc.D[isc.C]=isc.A.Class;
isc.A.provider="Amazon";
isc.A.dataSourceName="bedrockRestConnector";
isc.A.requestOperationId="fetch";
isc.A.tokenLimit=8192;
isc.A.supportsJSONMode=false;
isc.A.supportsStructuredOutputs=false;
isc.B.push(isc.A.canSupportVisionRequests=function isc_BedrockAIEngine_canSupportVisionRequests(){
        return true;
    }
,isc.A.estimateRequestTokenCount=function isc_BedrockAIEngine_estimateRequestTokenCount(aiRequest){
        aiRequest=this.normalizeRequest(aiRequest);
        this._assert(aiRequest.prompt==null);
        if(isc.AIEngine.isVisionRequest(aiRequest)){
            var promptParts=this.makePromptParts(aiRequest),
                tokenEstimate=0;
            for(var i=0;i<promptParts.length;++i){
                var promptPart=promptParts[i];
                if(isc.isA.String(promptPart)){
                    tokenEstimate+=this.estimateTokenCount(promptPart);
                }
            }
            return tokenEstimate;
        }
        var tokenEstimate=0,
            messages=aiRequest.messages;
        if(messages!=null){
            for(var i=0;i<messages.length;++i){
                tokenEstimate+=this.estimateMessageTokenCount(messages[i]);
            }
        }
        return tokenEstimate;
    }
,isc.A.getTokenLimit=function isc_BedrockAIEngine_getTokenLimit(aiRequest){
        return(isc.AIEngine.isVisionRequest(aiRequest)?this.visionTokenLimit:this.tokenLimit);
    }
,isc.A.getDataSourceName=function isc_BedrockAIEngine_getDataSourceName(aiRequest){
        return this.dataSourceName;
    }
,isc.A.makeNonTextPromptPart=function isc_BedrockAIEngine_makeNonTextPromptPart(aiMessage){
        if(isc.AIEngine.isImageMessage(aiMessage)){
            return{
                inlineData:{
                    mimeType:isc.AIEngine._getMIMEType(aiMessage),
                    data:aiMessage.content
                }
            };
        }
        return this.Super("makeNonTextPromptPart",arguments);
    }
,isc.A.makePromptParts=function isc_BedrockAIEngine_makePromptParts(aiRequest){
        aiRequest=this.normalizeRequest(aiRequest);
        var origMessages=aiRequest.messages,
            numTrailingImageMessages=0,
            lastMessage;
        if(origMessages!=null&&
            origMessages.length>0&&
            isc.AIEngine.isImageMessage(lastMessage=origMessages[origMessages.length-1]))
        {
            for(var iEnd=origMessages.length;iEnd>0;--iEnd){
                var message=origMessages[iEnd-1];
                if(!isc.AIEngine.isImageMessage(message)||
                    lastMessage.source!=message.source)
                {
                    break;
                }
                ++numTrailingImageMessages;
            }
        }
        if(numTrailingImageMessages==0||numTrailingImageMessages==origMessages.length){
            return this.Super("makePromptParts",[aiRequest]);
        }
        var messages=origMessages.duplicate();
        messages.setLength(messages.length-numTrailingImageMessages);
        var messageBeforeTrailingImageMessages=messages[messages.length-1];
        if(messageBeforeTrailingImageMessages.source!=lastMessage.source){
            messages.push({source:lastMessage.source,content:""});
        }
        var promptParts;
        try{
            aiRequest.messages=messages;
            promptParts=this.Super("makePromptParts",[aiRequest]);
        }finally{
            aiRequest.messages=origMessages;
        }
        for(var i=0;i<numTrailingImageMessages;++i){
            promptParts.push(this.makeNonTextPromptPart(origMessages[origMessages.length-numTrailingImageMessages+i]));
        }
        return promptParts;
    }
,isc.A._mapAIMessageSourceToRole=function isc_BedrockAIEngine__mapAIMessageSourceToRole(source){
        if(!source)return"user";
        return source=="AI"?"assistant":source;
    }
,isc.A.transformRequest=function isc_BedrockAIEngine_transformRequest(aiRequest){
        aiRequest=this.normalizeRequest(aiRequest);
        var isVisionRequest=this.canSupportVisionRequests()&&isc.AIEngine.isVisionRequest(aiRequest);
        var request={
            model:isVisionRequest&&this.visionModel?this.visionModel:this.model||this.engineId,
            temperature:this.getTemperature(aiRequest),
            messages:null
        };
        var systemBlock=[];
        var aiMessages=aiRequest.messages;
        if(aiMessages!=null){
            var messages=request.messages=[];
            var m=0;
            for(var i=0;i<aiMessages.length;++i){
                var aiMessage=aiMessages[i];
                var role=this._mapAIMessageSourceToRole(aiMessage.source);
                if(role=="system"){
                    systemBlock[systemBlock.length]={text:aiMessage.content};
                }else{
                    messages[m]={
                        role:role,
                        content:null
                    };
                    if(isVisionRequest&&isc.AIEngine.isImageMessage(aiMessage)){
                        messages[m].content=[{
                            image:{
                                format:isc.AIEngine.getImageFormat(aiMessage.type),
                                source:{
                                    bytes:aiMessage.content
                                }
                            }
                        }];
                    }else if(!isc.AIEngine._isTextContentType(aiMessage.type)){
                        messages[m].content=this.makeNonTextPromptPart(aiMessage);
                    }else{
                        messages[m].content=[];
                        messages[m].content[0]={
                            text:String(aiMessage.content)
                        };
                    }
                    m++;
                }
            }
        }
        if(systemBlock.length>0){
            request.system=systemBlock;
        }
        if(this.supportsJSONMode){
            if(aiRequest.responseType=="object"&&
                aiRequest.responseType!="array")
            {
                request.response_format={type:"json_object"};
            }
        }
        if(this.seed!=null)request.seed=this.seed;
        return request;
    }
,isc.A.isErrorResponse=function isc_BedrockAIEngine_isErrorResponse(rawResponse,aiRequest){
        if(!rawResponse)return true;
        var data;
        try{
            data=rawResponse.output.message.content;
        }catch(e){
            return true;
        }
        if(!isc.isAn.Array(data)||data.length==0)return true;
        if(!data[0].text)return true;
        return rawResponse.stopReason!="end_turn";
    }
,isc.A.getErrorResponseInfo=function isc_BedrockAIEngine_getErrorResponseInfo(rawResponse,rawRequest,aiRequest,config){
        if(isc.isA.String(rawResponse)){
            var obj=isc.AI._extractJsonResult(rawResponse);
            if(obj&&obj.message)rawResponse=obj;
            else return{errorMessage:"An error occurred. The response from the server was: "+rawResponse};
        }else if(!rawResponse||!rawResponse.message)return null;
        var errorResponse={errorMessage:rawResponse.message};
          var serviceUnavailable=errorResponse.errorMessage.indexOf("wait")!=-1&&
                                   errorResponse.errorMessage.indexOf("try")!=-1&&
                                   errorResponse.errorMessage.indexOf("again")!=-1;
        if(serviceUnavailable){
            if(!config.retryIndex){
                if(!config.maxRetries)config.maxRetries=this.rateLimitMaxRetries;
            }
            if(config.retryDelay)config.retryDelay*=this.rateLimitBackoffFactor;
            else config.retryDelay=this.rateLimitInitialDelay;
            if(config.retryDelay>this.rateLimitMaxDelay){
                config.retryDelay=this.rateLimitMaxDelay;
            }
            errorResponse.retryDelay=config.retryDelay;
            errorResponse.recoverable=true;
            this.logInfo("Bedrock responded with a 'busy, please retry' response; retrying in "+
                                    config.retry+" seconds");
        }
        return errorResponse;
    }
,isc.A.makeSpoofedRawResponse=function isc_BedrockAIEngine_makeSpoofedRawResponse(aiRequest,spoofedResponseValue){
        if(aiRequest.responseType=="array"||aiRequest.responseType=="object"){
            spoofedResponseValue="```json\n"+spoofedResponseValue+"\n```";
        }
        return{
            candidates:[{
                content:{
                    parts:[{
                        text:spoofedResponseValue
                    }],
                    role:"model"
                },
                finishReason:"STOP"
            }]
        };
    }
,isc.A.transformRawResponse=function isc_BedrockAIEngine_transformRawResponse(rawResponse,rawRequest,aiRequest){
        var aiResponse={type:"error"};
        if(!rawResponse){
            aiResponse.errorMessage="The response was empty.";
        }else if(rawResponse.error){
            aiResponse.errorMessage=rawResponse.error.message;
        }else{
            if(!rawResponse.output||!rawResponse.output.message||
                    !isc.isAn.Array(rawResponse.output.message.content)||
                    !rawResponse.output.message.content[0].text)
            {
                this.logWarn(aiResponse.errorMessage="Unable to extract the message from the AI response","AI");
                aiResponse.errorMessage="The raw response was missing an element in the "+
                                                "output/message/content[0]/text hierarchy";
            }else{
                var messageContent=rawResponse.output.message.content[0].text;
                this.logDebug("Response text from AI: "+messageContent,"AI");
                aiResponse.type="success";
                aiResponse.message=this.extractAIMessage(messageContent,rawRequest,aiRequest);
                aiResponse.messageText=messageContent;
            }
        }
        return aiResponse;
    }
);
isc.B._maxIndex=isc.C+12;

isc.defineClass("PineconeAssistantEngine",isc.BaseOpenAIEngine);
isc.A=isc.PineconeAssistantEngine.getPrototype();
isc.B=isc._allFuncs;
isc.C=isc.B._maxIndex;
isc.D=isc._funcClasses;
isc.D[isc.C]=isc.A.Class;
isc.A.provider="Pinecone";
isc.A.dataSourceName="pineconeRestConnector";
isc.A.requestOperationId="fetch";
isc.A.model="gpt-4o";
isc.B.push(isc.A._mapAIMessageSourceToRole=function isc_PineconeAssistantEngine__mapAIMessageSourceToRole(source){
        if(!source)source="user";
        return source=="system"?"assistant":source;
    }
,isc.A.transformRequest=function isc_PineconeAssistantEngine_transformRequest(aiRequest){
        var request=this.Super("transformRequest",arguments);
        request.stream=false;
        return request;
    }
,isc.A.transformRawResponse=function isc_PineconeAssistantEngine_transformRawResponse(rawResponse,rawRequest,aiRequest){
        if(rawResponse&&rawResponse.message){
            rawResponse.choices=[{
                message:rawResponse.message,
                finish_reason:rawResponse.finish_reason,
                index:0
            }];
            delete rawResponse.message;
            delete rawResponse.finish_reason;
        }
        return this.Super("transformRawResponse",arguments);
    }
,isc.A.init=function isc_PineconeAssistantEngine_init(){
        this.Super("init",arguments);
        var modelEngine=isc.AI.getEngine(this.model);
        if(!modelEngine){
            this.logWarn("Failed to initialize Pinecone Assistant AI Engine.  Could not find "+
                         "AI Engine: "+this.model);
            return;
        }
        this.tokenLimit=modelEngine.getTokenLimit();
    }
);
isc.B._maxIndex=isc.C+4;

if(!isc.AI)isc.defineClass("AI");
isc.A=isc.AI;
isc.A.localeDescription="English language";
isc.A.requirementsForDisplayingInformationSectionTitle="Requirements for displaying information to the user"
;

isc.AI.registerTemplates({
    summarizeDataSource:function(state,sc,j){
        var dataSource=state.dataSource,
            fields=state.fields||dataSource.getAllFields(),
            dsName=dataSource.getID(),
            shortDescription=isc.AI.getShortDSDescription(dataSource),
            maskedFields=isc.applyMask(fields,isc.AI.salientFieldAttributes);
        for(let f=0;f<maskedFields.length;++f){
            const field=maskedFields[f];
            if(!field.type)field.type="text";
        }
        return isc.trimDoc`
            DataSource '${dsName}' is summarized as "${shortDescription}" and has the following available ${'field'.pluralize(fields.length)}:
            ${j(maskedFields, true)}`;
    },
    applicationDataSourcesPromptSection:function(dataSources,sc,j){
        var numDataSources=!isc.isA.nonemptyArray(dataSources)?0:dataSources.length;
        return isc.trimDoc`
            ## Application DataSources
            ${sc.if(numDataSources == 0,
                "There are no DataSources in the application.",
                isc.trimDoc`
                    There ${sc.if(numDataSources == 1, "is", "are")} ${numDataSources} ${"DataSource".pluralize(numDataSources)} available in the application.
                    The final user interface may use as many of these DataSources as necessary to fulfill the user request:

                    ${sc.for(dataSources, function (dataSource) {
                        return sc.render("summarizeDataSource", {dataSource: dataSource});
                    }, "\n\n")}`
            )}`;
    },
    requirementsForDisplayingInformationPromptSection:function(state,sc,j){
        return isc.trimDoc`
            <requirements-document topic="${sc.AI.requirementsForDisplayingInformationSectionTitle}" format="Markdown">
            The user's locale is: ${sc.AI.localeDescription}
            All display text should be written for, and numbers and dates should be formatted for, this locale.
            Automatic localized formatting of numbers in UIs may be achieved via the "localeInt"
            and "localeFloat" field types.

            Be concise and brief. Avoid redundancy.

            Use a neutral, professional, analytical tone.
            Avoid casual, emotional, or chatty expressions (e.g. "Let's take a look", "Great job!").

            *Never* refer to the user passively or indirectly (e.g. "the user", "a user").
            *Always* use second-person pronouns to refer to the user ("you"/"your").

            *Never* refer to yourself directly or use first-person pronouns (avoid "I"/"me"/"my"/"myself"/"we"/"us"/"our").

            Do not use overly technical language.
            Do not include programming code.

            Assume that the user understands business applications, including the current application,
            but not the SmartClient framework or its terminology. Use plain language to describe
            things rather than technical terms or identifiers:
            * "AdvancedCriteria" \u2192 "criteria"
            * "DSRequest" used to fetch data \u2192 "query"
            * "ListGrid" \u2192 "table"
            * "FacetChart" \u2192 "chart"
            * "DynamicForm" \u2192 "form"
            * Do not refer to a "ScalarViewer". This type of component displays a single
              number result of a query, along with a title. You should talk about the number,
              its significance, and why you are displaying it rather than talking about the
              ScalarViewer component itself.
            * Do not refer to DataSource field names directly.

            Do not display primary key or foreign key values. Always display titles or labels
            that identify records meaningfully. Any DataBoundComponent that you create should
            also not display primary key or foreign key values. Configure fields with "displayField",
            "valueMap", "optionDataSource", or similar properties.

            Never suggest a fix that wouldn't actually fix the problem. For example, do not
            suggest that the user specify a "by rank" criterion (such as "top 10", "lowest 2%")
            in the description of a filter, because that is not achievable via AdvancedCriteria.
            </requirements-document>`;
    }
});
isc.A=isc.AI;
isc.A.advancedCriteriaAIHelpDocument=isc.aiHelpDocuments["object:AdvancedCriteria"]
;

isc.A=isc.AI;
isc.A.aiWasDisabledMessage="AI was disabled.";
isc.A.defaultAIEngineNotRegisteredErrorMessage="The default AI engine '${defaultEngineId}' is not registered.";
isc.A.noAIEngineSupportingVisionRequestsIsRegisteredErrorMessage="No AI engine is registered which supports vision requests.";
isc.A.aiNotAbleToProcessRequestErrorMessage="AI is not able to process your request.";
isc.A.noDataSourcesAvailableOrFoundErrorMessage="There were no data sources available or found.";
isc.A.startingYourRequestDetailMessage="Starting your request\u2026";
isc.A.willSubsetFieldsDetailMessage="Since the data source has a large number of fields, AI will be asked to select which ones are likely to be relevant to your request.";
isc.A.finishedSubsettingFieldsDetailMessage="Finished the request to select the relevant fields.";
isc.A.dataSourceIsRequiredErrorMessage="A globally-installed DataSource with a non-composite primary key is required.";
isc.A.exampleResponseDelineator="$$$$$$$";
isc.A.aiResponseDelineator="#######";
isc.A.scPostDelineator="^^^^^^^";
isc.A._isTextContentType=isc.AIEngine._isTextContentType;
isc.A._isImageContentType=isc.AIEngine._isImageContentType;
isc.A._aiProgressCallbackArgNames="context,numStepsCompleted,estimatedNumTotalSteps,newMessages"
;

isc.A=isc.AI;
isc.A.responseTypes=["Execute JavaScript","Clarify","Inspect","Explain Why Not","Ad Hoc UI","Send A Message"];
isc.A.messageTypes=["Notify","Modal Message"];
isc.A.errorTypes={
        "ContainsAIDelineator":"The Response should not contain "+isc.AI.aiResponseDelineator+" or "+isc.AI.scPostDelineator,
        "NoResponseType":"The Response has no ResponseType, which is invalid.",
        "BadResponseType":"The Response has ResponseType ${responseType}, which is not a valid ResponseType.",
        "NoMessageType":"The Response has a Message but there is no MessageType, which is invalid.",
        "BadMessageType":"The Response has MessageType ${messageType}, which is not a valid MessageType.",
        "NoMessage":"ResponseType is ${responseType} but there is no Message in the Response, which is invalid.",
        "NoJavaScript":"ResponseType is ${responseType} but there is no JavaScript in the Response, which is invalid.",
        "NoCommandComplete":"ResponseType is ${responseType} but the JavaScript code in the Response does not contain a call"+
                            " to isc.AI.commandComplete(). This method should be invoked exactly once when the script's actions are completed",
        "JavaScriptError":
            "Your attempt to execute JavaScript in the user's session resulted in a JavaScript error.\n"+
            "The error message is as follows:\n"+
            "    ${error.message}\n"+
            "End of error message.\n"+
            "${hint}"+
            "The attempted changes have been reverted and no messages have been displayed to the end user.\n"+
            "Please provide a revised response in the same format previously described."
    }
;

isc.A=isc.AI;
isc.B=isc._allFuncs;
isc.C=isc.B._maxIndex;
isc.D=isc._funcClasses;
isc.D[isc.C]=isc.A.Class;
isc.A.defaultMaxFixAttempts=2;
isc.A.allowVoiceAssist=false;
isc.A.serializationFormat="compactJSON";
isc.A.csvFormatDescription="Objects are formatted in a character-separated-values format where each line shows "+
        "the attribute-values of an object for the following fields:\n${fieldNames}\n"+
        "Attribute values are separated by ${separator}.\n";
isc.A.separatorCharacter="|";
isc.A.jsonFormatDescription="Objects are serialized as an array of JSON formatted objects.\n";
isc.A.defaultRecordIndexFieldName="data-record index";
isc.A.disabled=true;
isc.A.engineConfigs=[
        {
            engineId:"gpt-3.5-turbo",
            _constructor:"BaseOpenAIEngine",
            name:"GPT-3.5 Turbo",
            tokenLimit:4096,
            supportsJSONMode:true
        },
        {
            engineId:"gpt-4",
            _constructor:"BaseOpenAIEngine",
            name:"GPT-4",
            tokenLimit:8192,
            supportsJSONMode:true
        },
        {
            engineId:"gpt-4-turbo",
            _constructor:"MultimodalGPTEngine",
            name:"GPT-4 Turbo",
            tokenLimit:128000,
            supportsJSONMode:true
        },
        {
            engineId:"gpt-4o",
            _constructor:"MultimodalGPTEngine",
            name:"GPT-4o",
            tokenLimit:128000,
            supportsJSONMode:true,
            supportsStructuredOutputs:true
        },
        {
            engineId:"gpt-4o-mini",
            _constructor:"MultimodalGPTEngine",
            name:"GPT-4o mini",
            tokenLimit:128000,
            supportsJSONMode:true,
            supportsStructuredOutputs:true
        },
        {
            engineId:"gpt-4.1",
            _constructor:"MultimodalGPTEngine",
            name:"GPT-4.1",
            tokenLimit:1047576,
            supportsJSONMode:true,
            supportsStructuredOutputs:true
        },
        {
            engineId:"gpt-4.1-mini",
            _constructor:"MultimodalGPTEngine",
            name:"GPT-4.1 mini",
            tokenLimit:1047576,
            supportsJSONMode:true,
            supportsStructuredOutputs:true
        },
        {
            engineId:"gpt-4.1-nano",
            _constructor:"MultimodalGPTEngine",
            name:"GPT-4.1 nano",
            tokenLimit:1047576,
            supportsJSONMode:true,
            supportsStructuredOutputs:true
        },
        {
            engineId:"pinecone-isc-rag",
            _constructor:"PineconeAssistantEngine",
            name:"Pinecone ISC RAG"
        },
        {
            engineId:"gemini-pro",
            _constructor:"GeminiProAIEngine"
        },
        {
            engineId:"o1",
            _constructor:"OpenAIReasoningEngine"
        },
        {
            engineId:"o3",
            _constructor:"OpenAIReasoningEngine"
        },
        {
            engineId:"o3-mini",
            _constructor:"OpenAIReasoningEngine",
            canSupportVisionRequests:function(){
                return false;
            }
        },
        {
            engineId:"o4-mini",
            _constructor:"OpenAIReasoningEngine"
        },
        {
            engineId:"bedrock",
            _constructor:"BedrockAIEngine",
            name:"AWS Bedrock"
        }
    ];
isc.A.defaultEngineId="gpt-4.1";
isc.A.engines={};
isc.A.assistantKey={altKey:true,keyName:"J"};
isc.A._dataBoundAIOperationResultCallbackArgNames="result,request";
isc.A.defaultMaxRetries=2;
isc.A.sendPromptRetryDelay=5000;
isc.A._pendingRequests=[];
isc.A.templatedStringFunctionsCache=isc.LRUCache.create({
        maxSize:10,
        keyEvicted:function(key){
            if(isc.AI.logIsDebugEnabled("AI")){
                isc.AI.logDebug("Function for templated string "+isc.AI.__textifyCacheKey(key)+
                        " was evicted from the cache.","AI");
            }
        }
    });
isc.A.useClientSessionHistory=true;
isc.A.adjacentValidationFailureCount=0;
isc.A._aemErrorCount=0;
isc.A.canExport=true;
isc.A.canExportCharts=true;
isc.A.canExportGrids=true;
isc.A.canSaveScreens=true;
isc.A.adHocUIWindowDefaults={
        _constructor:"Window",
        width:"80%",
        height:"80%",
        canDragResize:true,canDragReposition:true,
        keepInParentRect:false,
        autoCenter:true,
        isModal:true,
        title:"AI created User Interface",
        showHeaderIcon:true,
        bodyProperties:{
            padding:10,
            layoutMargin:10,
            membersMargin:9
        },
        toolStripDefaults:{
            _constructor:"ToolStrip",
            autoDraw:false,
            width:"100%",
            height:40
        },
        helpButtonDefaults:{
            _constructor:"ToolStripButton",
            autoDraw:false,
            name:"helpWithUI",
            prompt:"Ask for help with the dynamically created UI",
            click:function(){
                this.creator.getHelpWithThisUI();
            }
        },
        saveButtonDefaults:{
            _constructor:"ToolStripButton",
            autoDraw:false,
            name:"helpWithUI",icon:"[SKINIMG]actions/save.png",
            prompt:"Save this UI for future use",
            click:function(){
                this.creator.saveAdHocUI();
            }
        },
        exportButtonDefaults:{
            _constructor:"ToolStripButton",
            name:"exportUI",icon:"[SKINIMG]actions/export.png",
            click:function(){
                this.creator.exportUI();
            }
        },
        initWidget:function(){
            this.headerIconDefaults.src=isc.AI.getIconURL(true);
            this.addAutoChild("helpButton",{icon:isc.AI.getIconURL(true)});
            this.addAutoChild("saveButton",{showIf:"isc.AI.canSaveScreens"});
            this.addAutoChild("exportButton",{showIf:"isc.AI.canExport"});
            this.addAutoChild("toolStrip",{members:[this.helpButton,this.saveButton,this.exportButton]});
            this.addItem(this.toolStrip);
            return this.Super("initWidget",arguments);
        },
        showCloseButton:true,
        showMinimizeButton:false,showMaximizeButton:true,
        closeClick:function(){
            this.destroy();
        },
        setAdHocUI:function(adHocUI,response){
            this.adHocUI=isc.isAn.Array(adHocUI)?adHocUI[0]:adHocUI;
            this.response=response;
            var dbc=this.adHocUI&&this.adHocUI.getFirstDBC();
            if(!dbc){
                this.exportButton.hide();
            }else{
                this.exportButton.show();
                this.exportButton.prompt=isc.isA.ListGrid(dbc)?"Export Grid Data":
                    "Export Chart";
            }
            this.firstDBC=dbc;
            if(this.adHocUI){
                this.addItem(this.adHocUI,0);
            }
        },
        getAdHocUI:function(){
            return this.adHocUI;
        },
        saveAdHocUI:function(){
            isc.AI.showSaveUIWindow(this.response);
        },
        getAdHocUISummary:function(){
            return this.adHocUI&&this.adHocUI.getUISummary(["data"]);
        },
        exportUI:function(){
            var dbc=this.adHocUI.getFirstDBC();
            if(!dbc){
                isc.logWarn("No exportable UI.");
                return;
            }
            var isLG=isc.isA.ListGrid(dbc),
                isFC=isc.isA.FacetChart(dbc),
                items=[]
            ;
            if(isLG){
                items=[
                    {title:"CSV",val:"csv"},
                    {title:"JSON",val:"json"},
                    {title:"XML",val:"xml"},
                    {title:"XLS (Excel97)",val:"xls"},
                    {title:"OOXML (Excel2007)",val:"ooxml"}
                ];
            }else if(isFC){
                items=[
                    {title:"PNG",val:"png"},
                    {title:"JPEG",val:"jpeg"}
                ];
            }
            var menu=isc.Menu.create({
                autoDraw:false,
                items:items,
                keepInParentRect:true,
                itemClick:function(item){
                    if(isLG){
                        if(item.val=="json"){
                            dbc.exportClientData({operationId:"customJSONExport"
                            });
                        }else{
                            dbc.exportClientData({exportAs:item.val
                            });
                        }
                    }else if(isFC){
                        isc.RPCManager.exportImage(dbc.getSvgString(),{
                            exportDisplay:"download",
                            exportFilename:"export",
                            exportImageFormat:item.val,
                            exportImageQuality:1
                        });
                    }
                }
            })
            menu._moveMenuOffscreen();
            menu.draw();
            var height=menu.getVisibleHeight();
            menu.placeNear(this.exportButton.getPageLeft(),
                this.exportButton.getPageTop()-height);
            menu.show();
        },
        getHelpWithThisUI:function(){
            isc.AI.showAssistant({rootCanvas:this.adHocUI});
        }
    };
isc.A.saveUIWindowDefaults={
        _constructor:"Window",
        width:300,
        autoCenter:true,
        autoSize:true,
        overflow:"visible",
        canDragResize:true,
        isModal:true,
        canDragReposition:true,
        title:"Save AI generated UI",
        bodyProperties:{
            padding:10,
            layoutMargin:10,
            membersMargin:9
        },
        labelDefaults:{
            _constructor:"Label",
            width:"100%",
            height:1,
            overflow:"visible",
            dynamicContents:true,
            contents:"You can save AI-generated screens for later use.  Saved screens are "+
                "available whenever you open the AI assistant.<br><br>"+
                "What would you like to name this UI?<br>"
        },
        formDefaults:{
            _constructor:"DynamicForm",
            height:"*",
            autoFocus:true,
            cellPadding:0,
            fields:[
                {name:"userText",type:"textArea",minHeight:50,width:"*",height:"*",
                    colSpan:"*",showTitle:false,
                    hint:"Type a name for your saved UI",showHintInField:true,
                    keyPress:function(item,form,keyName,characterValue){
                        if(keyName=="Enter"){
                            this.form.creator.saveAdHocUI();
                            return false;
                        }
                    }
                }
            ]
        },
        controlsLayoutDefaults:{
            _constructor:"HLayout",
            width:"100%",
            height:1,
            overflow:"visible",
            align:"right",
            membersMargin:8
        },
        saveButtonDefaults:{
            _constructor:"Button",
            title:"Save",
            autoFit:true,
            autoDraw:false,
            click:function(){
                this.creator.saveAdHocUI();
            },
            layoutAlign:"right"
        },
        cancelButtonDefaults:{
            _constructor:"Button",
            title:"Cancel",
            autoFit:true,
            autoDraw:false,
            click:function(){
                this.creator.hide();;
            },
            layoutAlign:"right"
        },
        initWidget:function(){
            this.Super("initWidget",arguments);
            this.addItem(this.addAutoChild("label"));
            this.addItem(this.addAutoChild("form"));
            this.addAutoChild("saveButton");
            this.addAutoChild("cancelButton");
            this.addItem(this.addAutoChild("controlsLayout",{members:[this.saveButton,this.cancelButton]}));
        },
        saveAdHocUI:function(){
            isc.AI.saveAdHocUI(this.form.getValue("userText"),this.response);
            this.hide();
        },
        closeClick:function(){
            this.hide();
        },
        setResponse:function(response){
            this.response=response;
        },
        show:function(){
            this.form.setValue("userText",(isc.AI.lastUserPrompt||"").substring(0,100));
            return this.Super("show",arguments);
        }
    };
isc.A.savedUIStorageKey="savedUI";
isc.A.screensDataSource=null;
isc.A.logLocalDSRequests=false;
isc.A.assistantBlurb="<b>Ask for AI assistance in using this "+
            "${isc.AI.isShowcase ? \"Showcase Sample\" : \"application\"}.</b><br><br>"+
            "You can:<br><br>"+
            "1. request that the AI configures the existing screen to do something you want "+
                "(such as configuring complex search criteria for a grid)<br><br>"+
            "2. request that the AI builds you a custom interface, to enable you to complete "+
                "tasks more quickly than what the current UI allows. "+
                "Note that AI-created screens may be saved for future use.<br>";
isc.A.assistantHint="Type your question or request here";
isc.A.assistantWindowDefaults={
        _constructor:"Window",
        width:500,
        autoCenter:true,
        autoSize:true,
        overflow:"visible",
        canDragResize:true,
        canDragReposition:true,
        title:"SmartClient AI Assistant",
        showHeaderIcon:true,
        bodyProperties:{
            padding:10,
            layoutMargin:10,
            membersMargin:10
        },
        labelDefaults:{
            _constructor:"Label",
            width:"100%",
            dynamicContents:true
        },
        formDefaults:{
            _constructor:"DynamicForm",
            height:"*",
            autoFocus:true,
            cellPadding:0,
            fields:[
                {name:"userText",type:"textArea",minHeight:50,width:"*",height:"*",
                    colSpan:"*",showTitle:false,
                    hint:isc.AI.assistantHint,showHintInField:true,
                    keyPress:function(item,form,keyName,characterValue){
                        if(keyName=="Enter"){
                            this.form.creator.askTheAI();
                            return false;
                        }
                    }
                }
            ]
        },
        controlsLayoutDefaults:{
            _constructor:"HLayout",
            width:"100%",
            height:1,
            membersMargin:10,
            overflow:"visible"
        },
        savedUIFormDefaults:{
            _constructor:"DynamicForm",
            width:360,
            minWidth:200,
            height:1,
            overflow:"visible",
            autoFocus:false,
            autoDraw:false,
            cellPadding:0,
            layoutAlign:"left"
        },
        askButtonDefaults:{
            _constructor:"Button",
            title:"Ask the AI",
            autoFit:true,
            click:function(){
                this.creator.askTheAI();
            },
            layoutAlign:"right"
        },
        initWidget:function(){
            this.headerIconDefaults.src=isc.AI.getIconURL(true);
            this.Super("initWidget",arguments);
            this.addItem(this.addAutoChild("label",{
                contents:isc.AI.assistantBlurb
            }));
            this.addItem(this.addAutoChild("form"));
            this.addItem(this.addAutoChild("controlsLayout"));
            this.addAutoChild("savedUIForm",{
                fields:[{
                    name:"savedUI",type:"select",width:"*",
                    colSpan:"*",
                    optionDataSource:isc.AI.getScreensDataSource(),
                    valueField:"name",displayField:"name",
                    title:"Saved Screens",
                    wrapTitle:false,
                    pickListProperties:{canRemoveRecords:true},
                    changed:function(){
                        this.form.creator.loadSavedUI(this.getValue());
                        return false;
                    }
                }]
            });
            this.addAutoChild("askButton");
            this.controlsLayout.addMembers([
                this.savedUIForm,
                isc.LayoutSpacer.create({width:"*"}),
                this.askButton
            ]);
        },
        askTheAI:function(){
            var promptText=this.form.getValue("userText")
            isc.AI.command(promptText,"userQuery");
            isc.Notify.addMessage("Asked the AI: \""+promptText+"\"");
        },
        loadSavedUI:function(){
            var uiKey=this.savedUIForm.getValue("savedUI");
            isc.AI.getSavedUI(uiKey,function(data){
                isc.AI.handleAIResponse(data.response.aiResponse);
            })
        },
        close:function(){
            this.Super("close",arguments);
            isc.AI.assistantClosed();
        }
    };
isc.A.clearHistoryOnClose=true;
isc.A.clarifyWindowDefaults={
        _constructor:"Window",
        width:300,
        autoCenter:true,
        autoSize:true,
        canDragResize:true,
        canDragReposition:true,
        height:200,
        title:"The AI needs your input",
        bodyProperties:{
            padding:10,
            layoutMargin:10,
            membersMargin:9
        },
        labelContents:"",
        labelDefaults:{
            _constructor:"Label",
            width:"100%",
            height:1,
            contents:""
        },
        formDefaults:{
            _constructor:"DynamicForm",
            height:"*",
            autoFocus:true,
            cellPadding:0,
            fields:[
                {name:"userText",type:"textArea",minHeight:50,width:"*",height:80,
                    colSpan:"*",showTitle:false,
                    hint:"Type your clarifying information here",showHintInField:true,
                    keyPress:function(item,form,keyName,characterValue){
                        if(keyName=="Enter"){
                            this.form.creator.tellTheAI();
                            return false;
                        }
                    }
                }
            ]
        },
        aiButtonDefaults:{
            _constructor:"Button",
            title:"Tell the AI",
            autoFit:true,
            click:function(){
                this.creator.tellTheAI();
            },
            layoutAlign:"right"
        },
        initWidget:function(){
            this.Super("initWidget",arguments);
            this.addItem(this.addAutoChild("label"));
            this.addItem(this.addAutoChild("form"));
            this.addItem(this.addAutoChild("aiButton"));
        },
        tellTheAI:function(){
            var promptText=this.form.getValue("userText")
            isc.AI.command(promptText,"userClarification");
            isc.AI.hideClarifyWindow();
        }
    };
isc.A._invalidResult={result:"invalid"};
isc.A._responseForBatchCallbackArgNames="aiResponseForBatch,context";
isc.A.useAIFieldPaging=true;
isc.A.salientFieldAttributes=[
        "name",
        "type",
        "required",
        "multiple",
        "title",
        "description",
        "valueMap",
        "validOperators",
        "displayField",
        "foreignKey",
        "joinType",
        "includeFrom",
        "includeVia",
        "hidden"
    ];
isc.A.setFieldsFixedPrompt="This is a request by a user to show and/or hide some ListGrid fields in a web application built with the "+
        "Isomorphic SmartClient Javascript framework. "+
        "The user request is as follows:\n'${userPrompt}'\n"+
        "Your response should be a JSON string containing an object with two attributes.\n"+
        "\"show\": the fields the user wants to show as an array of strings, or an empty array if the user did not ask to show any fields.\n"+
        "\"hide\": the fields the user wants to hide as an array of strings, or an empty array if the user did not ask to hide any fields.\n\n"+
        "Do not include any other text in your response.\n\n";
isc.A.setFieldsHiddenFieldsPromptPrefix="The following fields are not currently visible in the grid but are available to be shown.\n";
isc.A.setFieldsVisibleFieldsPromptPrefix="The grid currently contains the following visible fields which may be hidden.\n";
isc.A._buildViaAIResponseCallbackArgNames="buildResponse,buildRequest";
isc.A._$asyncBuildCriterion="asyncBuildCriterion";
isc.B.push(isc.A.init=function isc_c_AI_init(){
        this.Super("init",arguments);
        this.startAssistant(this.assistantKey);
        this._extendColorMap();
        this._makeLikelyCSSColorRegExp();
        if(this.allowVoiceAssist){
            isc.VoiceAssist&&isc.VoiceAssist.enable();
        }
    }
,isc.A._encodeJSON=function isc_c_AI__encodeJSON(content){
        return isc.JSON.encode(content,{prettyPrint:false});
    }
,isc.A.doPageRecordsPicking=function isc_c_AI_doPageRecordsPicking(fixedPrompt,records,callback,settings){
        var aiMessages=[{source:"user",content:fixedPrompt}],
            context=this._getContextForAIMessages(aiMessages);
        return context.aiEngine.doPageRecordsPicking(aiMessages,records,callback,settings)
    }
,isc.A._getContextForRequest=function isc_c_AI__getContextForRequest(aiRequest){
        if(this.disabled)return{errorMessage:this.aiWasDisabledMessage};
        var defaultAIEngine=this.getEngine();
        if(!defaultAIEngine)return{errorMessage:this.defaultAIEngineNotRegisteredErrorMessage.evalDynamicString(this,this)};
        this._assert(this.isEnabled());
        var aiEngine,
            couldSupportRequest=defaultAIEngine.couldSupportRequest(aiRequest),
            isVisionRequest=isc.AIEngine.containsImageMessage(aiRequest.messages);
        if(couldSupportRequest){
            aiEngine=defaultAIEngine;
        }else{
            var aiEngines=isc.getValues(this.engines),
                i=aiEngines.findIndex(defaultAIEngine);
            this._assert(i>=0);
            if(i>0){
                aiEngines.removeAt(i);
                aiEngines.addAt(defaultAIEngine,0);
            }
            for(i=0;i<aiEngines.length;++i){
                if(i>0&&aiEngines[i].couldSupportRequest(aiRequest)){
                    aiEngine=aiEngines[i];
                    couldSupportRequest=true;
                    break;
                }
                if(!aiEngine&&isVisionRequest&&aiEngines[i].canSupportVisionRequests()){
                    aiEngine=aiEngines[i];
                }
            }
        }
        if(!aiEngine){
            return{errorMessage:isVisionRequest
                                  ?this.noAIEngineSupportingVisionRequestsIsRegisteredErrorMessage
                                  :"No suitable AIEngine was found."};
        }
        if(!couldSupportRequest){
            this.logWarn("Will use AIEngine "+aiEngine.engineId+", but it claims not to support the request","AI");
        }
        return{
            cancellationController:aiRequest.cancellationController,
            aiEngine:aiEngine,
            couldSupportRequest:couldSupportRequest,
            isVisionRequest:isVisionRequest
        };
    }
,isc.A._getContextForAIMessages=function isc_c_AI__getContextForAIMessages(aiMessages){
        var fakeAIRequest={messages:aiMessages};
        return this._getContextForRequest(fakeAIRequest);
    }
,isc.A.shouldUseAIFieldPaging=function isc_c_AI_shouldUseAIFieldPaging(prompt,fields,aiConfig){
        var fakeAIRequest={
            messages:[{source:"user",content:prompt}]
        };
        var context=this._getContextForRequest(fakeAIRequest);
        return context.aiEngine.shouldUseAIFieldPaging(fakeAIRequest,fields,aiConfig);
    }
,isc.A.retrieveFieldsForPrompt=function isc_c_AI_retrieveFieldsForPrompt(userPrompt,actionDescription,fields,callback,context,aiConfig){
        var aiMessages=[{content:userPrompt}];
        context=this._getContextForAIMessages(aiMessages);
        return context.aiEngine.retrieveFieldsForPrompt(aiMessages,actionDescription,fields,callback,context,aiConfig);
    }
,isc.A.getSerializedFields=function isc_c_AI_getSerializedFields(fields,config){
        if(config==null)config={};
        var recordPickingSettings={
            engineId:config.engineId,
            fieldNames:config.salientFieldAttributes||isc.AI.salientFieldAttributes,
            recordIndexFieldName:"",
            serializationFormat:config.serializationFormat
        };
        return this.serializeRecords(fields,recordPickingSettings);
    }
,isc.A.getShortDSDescription=function isc_c_AI_getShortDSDescription(dataSource){
        var dataSourceProps={
            ID:dataSource.ID
        };
        if(dataSource.title!=null){
            dataSourceProps.title=dataSource.title;
        }
        if(dataSource.pluralTitle!=null){
            dataSourceProps.pluralTitle=dataSource.pluralTitle;
        }
        if(dataSource.description!=null){
            dataSourceProps.description=dataSource.description;
        }
        if(dataSource.titleField!=null){
            dataSourceProps.titleField=dataSource.titleField;
        }
        var primaryKeys=dataSource.getPrimaryKeyFieldNames();
        if(primaryKeys!=null&&primaryKeys.length>0){
            if(primaryKeys.length==1)primaryKeys=primaryKeys[0];
            dataSourceProps.primaryKey=primaryKeys;
        }
        return this.echoFull(dataSourceProps);
    }
,isc.A.summarizeDataSource=function isc_c_AI_summarizeDataSource(ds,extraFields,config,includeSalientFields){
        var dsSummary=this.getShortDSDescription(ds),
            haveExtraFields=isc.isAn.Array(extraFields)&&!extraFields.isEmpty(),
            finalFields=haveExtraFields&&includeSalientFields!=false?ds.getSalientFields():[];
        if(haveExtraFields){
            for(var i=0;i<extraFields.length;++i){
                var extraField=extraFields[i];
                if(isc.isA.String(extraField))extraField=ds.getField(extraField);
                if(extraField==null)continue;
                if(finalFields.find("name",extraField.name)==null){
                    finalFields.add(extraField);
                }
            }
        }
        dsSummary+=("\nThis dataSource has the following fields that are relevant to the query:\n"+
                      this.getSerializedFields(finalFields,config));
        return dsSummary;
    }
,isc.A.serializeRecords=function isc_c_AI_serializeRecords(records,settings){
        if(settings==null)settings={};
        if(records==null)records=[];
        var format=settings.serializationFormat||this.serializationFormat;
        if(format=="csv"&&settings.fieldNames==null&&records.length>0){
            settings.fieldNames=isc.getKeys(records[0]);
        }
        var serializedRecords=[];
        for(var i=0;i<records.length;i++){
            serializedRecords.add(this.serializeIndexedRecord(records[i],i,settings));
        }
        return this.getFormatDescription(settings)+this._joinSerializedRecords(serializedRecords,settings);
    }
,isc.A._joinSerializedRecords=function isc_c_AI__joinSerializedRecords(serializedRecords,settings){
        var format=settings.serializationFormat||this.serializationFormat;
        var isJSON=format!="csv";
        var isCompactJSON=format=="compactJSON";
        var recordSeparator=(isCompactJSON?",":(isJSON?",\n":"\n"));
        var combinedRecords=
            (isCompactJSON?"[":(isJSON?"[\n":""))+
            serializedRecords.join(recordSeparator)+
            (isCompactJSON?"]":(isJSON?"\n]":""));
        return combinedRecords;
    }
,isc.A.getFormatDescription=function isc_c_AI_getFormatDescription(settings){
        if(settings==null)settings={};
        var serializationFormat=settings.serializationFormat||this.serializationFormat,
            isJSON=serializationFormat!="csv",
            recordIndexFieldName=settings.recordIndexFieldName!=null?settings.recordIndexFieldName:this.defaultRecordIndexFieldName,
            includeRecordIndexField=recordIndexFieldName!="",
            fieldNames=settings.fieldNames||[];
        if(includeRecordIndexField){
            fieldNames=fieldNames.duplicate();
            fieldNames.unshift(recordIndexFieldName);
        }
        var fieldsString=fieldNames.join(","),
            description=!isJSON?this.csvFormatDescription:this.jsonFormatDescription;
        description=description.evalDynamicString(this,{
            fieldNames:fieldsString,
            separator:this.separatorCharacter
        });
        return description;
    }
,isc.A.serializeIndexedRecord=function isc_c_AI_serializeIndexedRecord(record,recordIndex,settings){
        if(record==null)return"";
        if(settings==null)settings={};
        var format=settings.serializationFormat||this.serializationFormat;
        var isJSON=format!="csv";
        var isCompactJSON=format=="compactJSON";
        var fieldNames=settings.fieldNames;
        if(!isJSON&&fieldNames==null){
            fieldNames=isc.getKeys(record);
            this.logWarn(
                "serializeIndexedRecord is serializing in a format where attribute names are not included in the output."+
                "Attributes will be output in the following order:"+fieldNames.join(",")
            );
        }
        var recordIndexFieldName=(settings.recordIndexFieldName!=null?settings.recordIndexFieldName:this.defaultRecordIndexFieldName);
        var includeRecordIndexField=(recordIndexFieldName!="");
        var serializedRecord="";
        if(format=="csv"){
            if(includeRecordIndexField)serializedRecord+=this._csvSerializeAttribute(String(recordIndex),settings);
            for(var ii=0;ii<fieldNames.length;ii++){
                serializedRecord+=((includeRecordIndexField||ii>0?this.separatorCharacter:"")+
                                     this._csvSerializeAttribute(record[fieldNames[ii]],settings));
            }
        }else{
            if(fieldNames!=null){
                record=isc.applyMask(record,fieldNames);
            }
            if(includeRecordIndexField){
                var newRecord={};
                newRecord[recordIndexFieldName]=recordIndex;
                record=isc.addProperties(newRecord,record);
            }
            serializedRecord=isc.JSON.encode(record,{prettyPrint:!isCompactJSON});
        }
        return serializedRecord;
    }
,isc.A._csvSerializeAttribute=function isc_c_AI__csvSerializeAttribute(value,settings){
        if(value==null)return"";
        return isc.isA.String(value)?value.asSource():value+"";
    }
,isc.A.isEnabled=function isc_c_AI_isEnabled(){
        return this.disabled!=true&&
               (this.defaultEngineId in this.engines||
                this.engineConfigs.find("engineId",this.defaultEngineId)!=null);
    }
,isc.A.registerEngine=function isc_c_AI_registerEngine(engine){
        if(engine.engineId in this.engines)return false;
        this.engines[engine.engineId]=engine;
        return true;
    }
,isc.A.unregisterEngine=function isc_c_AI_unregisterEngine(engineId){
        if(!(engineId in this.engines))return false;
        return delete this.engines[engineId];
    }
,isc.A.getEngine=function isc_c_AI_getEngine(engineId,config){
        engineId=engineId||isc.AI.defaultEngineId;
        var engine=this.engines[engineId];
        if(engine==null){
            var engineConfig=this.engineConfigs.find("engineId",engineId);
            if(engineConfig==null)return null;
            var props=isc.addProperties({engineId:engineId,name:engineId},engineConfig,config);
            var ctor=engineConfig._constructor||"AIEngine";
            engine=isc[ctor].create(props);
            this.engines[engineId]=engine;
        }
        return engine;
    }
,isc.A.asyncLoadSystemSchema=function isc_c_AI_asyncLoadSystemSchema(){
        const resolversObj=Promise.withResolvers();
        if(!this.haveSystemSchema()){
            this.logInfo("It does not appear that the system schema are loaded. Will attempt to load them...","AI");
            const callback={
                target:this,
                method:function(response){
                    if(!this.haveSystemSchema()){
                        this.logWarn("Failed to load the system schema: "+isc.echo(response),"AI");
                        resolversObj.reject();
                    }else{
                        this.logInfo("System schema are now loaded.","AI");
                        resolversObj.resolve();
                    }
                }
            };
            isc.RPCManager.loadSystemSchema(callback,{willHandleError:true});
        }else{
            this.logDebug("System schema are already loaded.","AI");
            resolversObj.resolve();
        }
        return resolversObj.promise;
    }
,isc.A.haveSystemSchema=function isc_c_AI_haveSystemSchema(){
        const canvasDS=isc.DS.get("Canvas");
        return!!(canvasDS&&canvasDS.componentSchema);
    }
,isc.A.allowAssistant=function isc_c_AI_allowAssistant(){
        return true;
    }
,isc.A.startAssistant=function isc_c_AI_startAssistant(key){
        if(isc.AI.aiReady)return;
        if(!isc.AI.allowAssistant()){
            isc.logWarn("No AI engine API key found found.  Can't install AI.","AI");
            return;
        }
        if(key)isc.AI.assistantKey=key;
        key=isc.AI.assistantKey;
        var existingReg=isc.Page.getRegisteredKeyActions(key);
        if(existingReg&&existingReg.length>0){
            isc.logWarn("Specified AI shortcut-key ("+JSON.stringify(key)+") is already in use by another "+
                "handler. To enable the AI assistant shortcut, call isc.AI.startAssistant() with an unused key-name.","AI");
            return;
        }
        isc.Page.registerKey(key,function(key,target){
            target.showAssistant();
            return false;
        },isc.AI);
        isc.AI.aiReady=true;
    }
,isc.A.stopAssistant=function isc_c_AI_stopAssistant(){
        if(!isc.AI.aiReady){
            isc.AI.logWarn("Cannot stop the AI Assistant - it isn't running.");
            return;
        }
        isc.Page.unregisterKey(isc.AI.assistantKey,isc.AI);
        isc.AI.aiReady=false;
    }
,isc.A._asyncAIOperation=function isc_c_AI__asyncAIOperation(asyncMethodName,params){
        if(!this.isEnabled()){
            return isc.rejectAsDisabled(this.aiWasDisabledMessage);
        }
        var asyncMethodArgs=Array.prototype.slice.call(arguments,1);
        return isc.AsyncUtil.asyncOperation(params,function(opContext){
            asyncMethodArgs.push(opContext);
            return isc.AI[asyncMethodName].apply(isc.AI,asyncMethodArgs);
        });
    }
,isc.A._asyncDataBoundAIOperation=function isc_c_AI__asyncDataBoundAIOperation(asyncMethodName,request){
        if(!this.isEnabled()){
            return isc.rejectAsDisabled(this.aiWasDisabledMessage);
        }
        var asyncMethodArgs=Array.prototype.slice.call(arguments,1);
        return isc.AsyncUtil.asyncDataBoundOperation(request,function(dabOpContext){
            var fieldContainer=dabOpContext.component||dabOpContext.dataSource;
            var allNamedFields=fieldContainer&&fieldContainer.getAllNamedFields();
            var relevantFieldNames=request.relevantFieldNames;
            if(allNamedFields&&!allNamedFields.isEmpty()){
                var availableFieldsIndex=allNamedFields.makeIndex("name"),
                    allFieldNames=isc.getKeys(availableFieldsIndex),
                    excludeFieldNames=request.excludeFieldNames;
                if(relevantFieldNames){
                    for(var i=0;i<relevantFieldNames.length;++i){
                        var relevantFieldName=relevantFieldNames[i];
                        if(!relevantFieldName||relevantFieldName.contains('.'))continue;
                        if(!allFieldNames.contains(relevantFieldName)&&
                            !relevantFieldNames.contains(relevantFieldName,i+1))
                        {
                            isc.AI.logWarn("'"+relevantFieldName+"' is listed in `relevantFieldNames`, but there is no such field.","AI");
                        }
                    }
                    availableFieldsIndex=isc.applyMask(availableFieldsIndex,relevantFieldNames);
                }
                if(excludeFieldNames){
                    for(var i=0;i<excludeFieldNames.length;++i){
                        var excludeFieldName=excludeFieldNames[i];
                        if(!excludeFieldName||excludeFieldName.contains('.'))continue;
                        if(!allFieldNames.contains(excludeFieldName)&&
                            !excludeFieldNames.contains(excludeFieldName,i+1))
                        {
                            isc.AI.logWarn("'"+excludeFieldName+"' is listed in `excludeFieldNames`, but there is no such field.","AI");
                        }
                        delete availableFieldsIndex[excludeFieldName];
                    }
                }
                dabOpContext.availableFields=isc.getValues(availableFieldsIndex);
                dabOpContext.availableFieldNames=dabOpContext.availableFields.getProperty("name");
                dabOpContext.availableFieldsIndex=availableFieldsIndex;
            }else if(relevantFieldNames&&!relevantFieldNames.isEmpty()){
                isc.AI.logWarn("Relevant field names were specified, but there are no named fields. Ignoring...","AI");
            }
            asyncMethodArgs.push(dabOpContext);
            return isc.AI[asyncMethodName].apply(isc.AI,asyncMethodArgs);
        });
    }
,isc.A._wrapAsyncDataBoundAIOperation=function isc_c_AI__wrapAsyncDataBoundAIOperation(asyncMethodName,request){
        var asyncMethodArgs=Array.prototype.slice.call(arguments,1,-1),
            callback=arguments[arguments.length-1];
        var fireCallback=function(result){
            var argNames=isc.AI._dataBoundAIOperationResultCallbackArgNames;
            isc.AI.fireCallback(callback,argNames,[result,request]);
        };
        this[asyncMethodName].apply(this,asyncMethodArgs)
            ._whenSettled(fireCallback);
    }
,isc.A.summarizeValue=function isc_c_AI_summarizeValue(request,callback){
        this._wrapAsyncDataBoundAIOperation("asyncSummarizeValue",request,callback);
    }
,isc.A.asyncSummarizeValue=function isc_c_AI_asyncSummarizeValue(request){
        return this._asyncDataBoundAIOperation("_asyncSummarizeValue",request);
    }
,isc.A._asyncSummarizeValue=function isc_c_AI__asyncSummarizeValue(request,dabOpContext){
        var ssAIRequest=request.aiRequest;
        if(!ssAIRequest){
            return isc.rejectWithError(isc.AsyncUtil.missingRequiredParameterErrorMessage.evalDynamicString(this,{paramName:"aiRequest"}));
        }
        var value=request.value;
        if(!value){
            return isc.rejectWithError(isc.AsyncUtil.missingRequiredParameterErrorMessage.evalDynamicString(this,{paramName:"value"}));
        }
        var prompts=[
            "This is a request to supplement a value from a DataSource, using "+
            "relevant general knowledge and your own reasonable inferences. "+
            "The supplemental information requested is:",
            "${ssMessages}"
        ];
        var ssMessages=[{content:ssAIRequest.prompt,type:ssAIRequest.promptType}],
            additionalMessages=ssAIRequest.additionalMessages;
        if(additionalMessages){
            ssMessages.addList(additionalMessages);
            ssMessages.removeEmpty();
        }
        var availableFields=dabOpContext.availableFields,
            record=request.record,
            fieldName=request.fieldName,
            recordSerializationSettings;
        if(availableFields){
            var finalFields=availableFields,
                finalFieldNames=dabOpContext.availableFieldNames;
            var field;
            if(fieldName){
                var pos=finalFieldNames.indexOf(fieldName);
                if(pos<0){
                    this.logWarn("A field with name '"+fieldName+"' is not available. Ignoring...","AI");
                    fieldName=null;
                }else{
                    finalFieldNames.removeAt(pos);
                    field=finalFields[pos];
                }
            }
            if(dabOpContext.dataSource){
                var dsSummary=this.summarizeDataSource(dabOpContext.dataSource,finalFields,{format:"compactJSON"},false);
                prompts.push(
                    "The value to be summarized is from "+
                    (fieldName?"the '"+fieldName+"' field of ":"")+
                    "the DataSource with the following description: "+dsSummary+"\n\n"
                );
            }else{
                this._assert(dabOpContext.component);
                if(field){
                    prompts.push(
                        "The value to be summarized comes from the DataBoundComponent field with "+
                        "the following description (in JSON format): "+
                        this.serializeIndexedRecord(field,null,{
                            recordIndexFieldName:"",
                            fieldNames:this.salientFieldAttributes,
                            format:"compactJSON"
                        })+"\n\n"
                    );
                }
            }
            if(record){
                if(finalFieldNames.isEmpty()){
                    this.logWarn("The context record was specified, but no additional fields are relevant to the request.","AI");
                }else{
                    recordSerializationSettings={
                        recordIndexFieldName:"",
                        fieldNames:finalFieldNames,
                        format:"compactJSON"
                    };
                    prompts.push(
                        "The record that the value is part of is (in JSON format): "+
                        this.serializeIndexedRecord(record,null,recordSerializationSettings)+"\n\n"
                    );
                }
            }
        }else{
            if(record){
                this.logWarn("The record was specified, but no fields are available. Ignoring...","AI");
            }
            if(fieldName){
                this.logWarn("fieldName was specified, but no fields are available. Ignoring...","AI");
            }
        }
        var aiMessagesBuilder=isc.InternalAIMessagesBuilder2.create({
            ssMessages:ssMessages,
            messagesSource:request.aiRequestSource||"system",
            target:this,
            evalVars:{
                value:value
            }
        });
        aiMessagesBuilder.appendPrompts(prompts);
        delete prompts;
        var aiMessages=aiMessagesBuilder.aiMessages;
        var examples=request.examples;
        if(examples&&!examples.isEmpty()){
            if(request.valueType!=null&&request.valueType!="text"){
                this.logWarn("The valueType of examples must be 'text'. Omitting the examples...","AI");
            }else{
                var examplePrompt="For example: ";
                for(var exampleIndex=0;exampleIndex<examples.length;++exampleIndex){
                    var example=examples[exampleIndex];
                    examplePrompt+="For the value '"+(example.value||"")+"'";
                    if(recordSerializationSettings&&example.record){
                        examplePrompt+=" and record "+this.serializeIndexedRecord(
                                example.record,null,recordSerializationSettings);
                    }
                    examplePrompt+=", you might generate '"+(example.summary||"")+"'.\n";
                }
                aiMessages.push({
                    source:"system",
                    content:examplePrompt
                });
            }
        }
        aiMessages.push({
            source:"system",
            content:"Your response should be a single JSON object with one key \"result\" "+
                "and value being the string of supplemental information for the value. "+
                "The value is:"
        });
        aiMessages.push({
            content:value,
            type:request.valueType
        });
        var aiRequest={
            messages:aiMessages,
            responseType:"object",
            cancellationController:dabOpContext.cancellationController
        };
        var context=this._getContextForRequest(aiRequest);
        if(context.errorMessage)return isc.rejectWithError(context.errorMessage);
        var aiConfig={
            maxRetries:request.maxRetries
        };
        return context.aiEngine.asyncSendRequest(aiRequest,aiConfig)
            .then(function(aiResponse){
                var responseObject=aiResponse.message.content,
                    responseStr;
                if(!isc.isAn.Object(responseObject)||
                    !isc.isA.String(responseObject.result)||
                    !(responseStr=responseObject.result.trim()))
                {
                    return isc.rejectWithError(isc.AI.aiNotAbleToProcessRequestErrorMessage);
                }
                return{
                    type:"success",
                    summary:responseStr
                };
            });
    }
);
isc.evalBoundary;isc.B.push(isc.A.command=function isc_c_AI_command(promptText,commandType){
        if(promptText==null)return;
        if(commandType=="complete"){
            if(promptText!=null){
            }
            return;
        }
        if(commandType!="userQuery"&&commandType!="resolveError"&&commandType!="userClarification"){
            return;
        }
        if(commandType=="userQuery"){
            isc.AI.lastUserPrompt=promptText;
        }
        var session=isc.AI.getSession(),
            priorConversation=session[0],
            promptContext=session[1],
            priorMessages=session[2];
        if(priorMessages==null&&this.useClientSessionHistory){
            promptContext={};
            priorMessages=this.sessionMessages=[this.getInitiatorMessage(promptContext)];
            promptText="** Initial request **\n"+promptText;
        }
        var callback=function(response,config){
            isc.AI.handleAIResponse(response,config.clientContext);
        };
        var aiMessages=(priorMessages||[]).concat([{source:(commandType=="resolveError"?"system":"user"),content:promptText}]);
        var requestProps=isc.addProperties({},this.assistantContext,{clientContext:promptContext});
        this.sendRequest({
            messages:aiMessages,
            historyIntroduction:"You have previously interacted with this user during this session as follows. Input from the "+
                                 "user, including contextual information automatically provided by SmartClient, is delineated by "+
                                 isc.AI.scPostDelineator+" at the beginning and end of that information. "+
                                 "Your responses are delineated by "+isc.AI.aiResponseDelineator+" at the beginning and end.",
            historyConclusion:"** New request **",
            historyDelimiters:{
                user:isc.AI.scPostDelineator,
                model:isc.AI.aiResponseDelineator
            }
        },callback,requestProps);
        this.addUserRequestToSessionHistory(promptText,promptContext);
    }
,isc.A.origSendPrompt=function isc_c_AI_origSendPrompt(promptText,callback,config){
        this.sendRequest({messages:[{source:"user",content:promptText}]},callback,config);
    }
,isc.A.sendRequest=function isc_c_AI_sendRequest(aiRequest,callback,config){
        config=isc.addProperties({},config);
        var aiEngine=isc.AI.getEngine(config.engineId);
        if(!aiEngine){
            this.logWarn("Couldn't find any AI Engine with engineId: "+config.engineId);
            return;
        }
        aiEngine.sendRequest(aiRequest,function(aiResponse,aiRequest){
            var messageContent=aiResponse.message&&aiResponse.message.content;
            if(messageContent==null){
                aiEngine.logWarn("Unable to extract message from AI response","AI");
                return;
            }
            aiEngine.logDebug("Response text from AI: "+messageContent,"AI");
            isc.AI.fireCallback(callback,"messageContent,config",[messageContent,config]);
        },config);
    }
,isc.A.__textifyCacheKey=function isc_c_AI___textifyCacheKey(key){
        var commonPrefix="In the context of an Isomorphic SmartClient application,";
        if(key.startsWith(commonPrefix)){
            key="..."+key.substring(commonPrefix.length);
        }
        key="'"+key.replaceAll("\n","\\n")+"'";
        if(key.length>300)key=key.substring(0,166)+"..."+key.substring(key.length-129);
        return key;
    }
,isc.A._getPromptFromTemplatedString=function isc_c_AI__getPromptFromTemplatedString(templatedString,evalVars){
        var func=this.templatedStringFunctionsCache.get(templatedString);
        if(func){
            if(this.logIsDebugEnabled("AI")){
                isc.AI.logDebug("Cache hit for templated string "+isc.AI.__textifyCacheKey(templatedString),"AI");
            }
        }else{
            var escapedTemplatedString=templatedString.replaceAll("\\","\\\\")
                                                        .replaceAll("`","\\`");
            func=new Function("evalVars","with(evalVars){return`"+escapedTemplatedString+"`}");
            this.templatedStringFunctionsCache.put(templatedString,func);
        }
        try{
            return func(Object(evalVars));
        }catch(e){
            throw isc.createErrorResult("Failed to evaluate a templated string to make an AI prompt: "+String((e&&e.message)||e).asHTML(),{
                templatedString:templatedString,
                evalVars:evalVars
            });
        }
    }
,isc.A.asyncSendPrompt=function isc_c_AI_asyncSendPrompt(dynamicString,context,config,aiRequestProps){
        var resolversObj=Promise.withResolvers();
        this.sendPrompt(dynamicString,context,function(dsResponse){
            if(!dsResponse||dsResponse.type!="success"){
                resolversObj.reject(isc.defaultAsyncOperationCatchCallback(dsResponse));
            }else{
                resolversObj.resolve(dsResponse);
            }
        },config,aiRequestProps);
        return resolversObj.promise;
    }
,isc.A.sendPrompt=function isc_c_AI_sendPrompt(dynamicString,context,callback,config,aiRequestProps){
        var aiRequest=isc.addPropertiesWithAssign({},aiRequestProps);
        try{
            aiRequest.prompt=this._getPromptFromTemplatedString(dynamicString,context);
        }catch(e){
            var nonSuccessfulResult=isc.defaultAsyncOperationCatchCallback(e);
            this.delayFireCallback(callback,isc.AIEngine._sendRequestCallbackArgNames,[nonSuccessfulResult,aiRequest,config]);
            return;
        }
        var aiEngine;
        if(config&&config.engineId){
            aiEngine=this.getEngine(config.engineId);
            if(!aiEngine){
                this.logWarn("Couldn't find any AI Engine with engineId: "+config.engineId+
                             "; using default");
            }
        }
        if(!aiEngine){
            var requestContext=this._getContextForRequest(aiRequest);
            if(requestContext.errorMessage){
                var nonSuccessfulResult=isc.createErrorResult(requestContext.errorMessage);
                this.delayFireCallback(callback,isc.AIEngine._sendRequestCallbackArgNames,[nonSuccessfulResult,aiRequest,config]);
                return;
            }
            aiEngine=requestContext.aiEngine;
        }
        aiEngine.sendRequest(aiRequest,callback,config);
    }
,isc.A.estimateTokenCount=function isc_c_AI_estimateTokenCount(text,settings){
        var engine=isc.AI.getEngine(settings&&settings.engineId);
        return engine.estimateTokenCount(text);
    }
,isc.A.getVB=function isc_c_AI_getVB(){
        if(this.isReify)return window.VB;
        return null;
    }
,isc.A.commandComplete=function isc_c_AI_commandComplete(jsObj){
        isc.Class.endAEM();
        if(this.isReify&&this._reifyProjectState){
            isc.AI.getVB().destroyProjectState(this._reifyProjectState);
        }
        var response=isc.AI.lastResponse||{};
        var result=jsObj?isc.JSON.encode(jsObj):null;
        isc.logWarn("commandComplete() called - "+
            (result?"JSON serialized to: "+result:"no JSON to serialize"));
        if(response.message&&!isc.isAn.emptyString(response.message)){
            if(response.messageType=="Notify")isc.Notify.addMessage(response.message);
            else isc.say(response.message);
        }
        if(result)isc.AI.command(result,"complete");
    }
,isc.A.getSessionHistory=function isc_c_AI_getSessionHistory(){
        return this.getSession()[0];
    }
,isc.A.getSessionContext=function isc_c_AI_getSessionContext(){
        return this.getSession()[1];
    }
,isc.A.getSessionMessages=function isc_c_AI_getSessionMessages(){
        return this.getSession()[2];
    }
,isc.A.getSession=function isc_c_AI_getSession(){
        var history=this.sessionHistory;
        var context=this.sessionContext;
        var messages=this.sessionMessages;
        return[history,context,messages];
    }
,isc.A.clearSession=function isc_c_AI_clearSession(){
        delete this.sessionHistory;
        delete this.sessionContext;
        delete this.sessionMessages;
    }
,isc.A.addUserRequestToSessionHistory=function isc_c_AI_addUserRequestToSessionHistory(promptText,promptContext){
        if(this.useClientSessionHistory){
            if(!this.sessionHistory)this.sessionHistory="";
            this.sessionHistory+="\n"+this.scPostDelineator+promptText+this.scPostDelineator;
            if(!this.sessionMessages)this.sessionMessages=[];
            this.sessionMessages.push({source:"user",content:promptText});
            if(promptContext!=null){
                if(this.sessionContext==null)this.sessionContext={};
                isc.addProperties(this.sessionContext,promptContext);
            }
        }
    }
,isc.A.addAIResponseToSessionHistory=function isc_c_AI_addAIResponseToSessionHistory(aiResponse){
        if(this.useClientSessionHistory){
            var clean=isc.AI.cleanAIResponse(aiResponse);
            if(!this.sessionHistory)this.sessionHistory="";
            this.sessionHistory+="\n"+this.aiResponseDelineator+clean+this.aiResponseDelineator;
            if(!this.sessionMessages)this.sessionMessages=[];
            this.sessionMessages.push({source:"AI",content:clean});
        }
    }
,isc.A.handleAIResponse=function isc_c_AI_handleAIResponse(aiResponse,context){
        this.addAIResponseToSessionHistory(aiResponse);
        var response=isc.AI.validateAIResponse(aiResponse);
        this.handleValidatedAIResponse(response,context);
    }
,isc.A.handleValidatedAIResponse=function isc_c_AI_handleValidatedAIResponse(response,context){
        isc.AI.lastResponse=isc.addProperties({},response);
        if(response.errors&&response.errors.length>0){
            this.logWarn("The following errors were found during response validation:"+this.echoAll(response.errors));
            if(response.unableToProcess){
                this.adjacentValidationFailureCount++;
                if(this.adjacentValidationFailureCount>4){
                    isc.say("The AI is unable to process this request as written. Please try rephrasing your request.");
                }else{
                    var errorPrompt="The response you shared was not formatted correctly. "+
                                      "Please rewrite the response in the specified format. The specific error(s) encountered are as follows:"+
                                      "\n- "+response.errors.join("\n- ");
                    this.command(errorPrompt,"resolveError");
                }
                return;
            }
        }
        this.adjacentValidationFailureCount=0;
        switch(response.responseType){
            case"Execute JavaScript":
                var result=isc.AI.handleAIJavaScript(response,context);
                break;
            case"Clarify":
                this.showClarifyWindow(response.message);
                break;
            case"Inspect":
                var result=isc.AI.handleAIJavaScript(response,context);
                break;
            case"Explain Why Not":
            case"Send A Message":
                var result=isc.AI.commandComplete();
                break;
            case"Ad Hoc UI":
                var result=isc.AI.handleAIJavaScript(response,context);
                break;
            default:
        }
    }
,isc.A.getErrorText=function isc_c_AI_getErrorText(errorType,response){
        return isc.AI.errorTypes[errorType].evalDynamicString(this,response);
    }
,isc.A.validateAIResponse=function isc_c_AI_validateAIResponse(aiResponse){
        var errors=[];
        var response={};
        if(!aiResponse||isc.isAn.emptyString(aiResponse)){
            errors.add("No Response Content");
            response.errors=errors;
            response.unableToProcess=true;
            return response;
        }else{
            var parseResult=isc.AI.parseAIResponse(aiResponse);
            response=parseResult.response;
            var type=response.responseType;
            if(parseResult.aiResponse!=aiResponse){
                errors.add(this.getErrorText("ContainsAIDelineator",response));
            }
            if(!type||type==""){
                errors.add(this.getErrorText("NoResponseType",response));
                response.unableToProcess=true;
            }else if(!isc.AI.responseTypes.contains(type)){
                errors.add(this.getErrorText("BadResponseType",response));
                response.unableToProcess=true;
            }
            if(response.message){
                if(type!="Clarify"){
                    if(!response.messageType){
                        errors.add(this.getErrorText("NoMessageType",response));
                        response.unableToProcess=true;
                    }else if(!isc.AI.messageTypes.contains(response.messageType)){
                        errors.add(this.getErrorText("BadMessageType",response));
                        response.unableToProcess=true;
                    }
                }
            }
            if(["Send A Message","Explain Why Not","Clarify"].contains(response.messageType)){
                if(!response.message||isc.isAn.emptyString(response.message)){
                    errors.add(this.getErrorText("NoMessage",response));
                    response.unableToProcess=true;
                }else if(type!="Clarify"){
                    if(!isc.AI.messageTypes.contains(response.messageType)){
                        errors.add(this.getErrorText("BadMessageType",response));
                        response.unableToProcess=true;
                    }
                }
            }
            if((type=="Inspect"||type=="Execute JavaScript")&&
                    (!response.javaScript||response.javaScript.length==0)){
                errors.add(this.getErrorText("NoJavaScript",response));
                response.unableToProcess=true;
            }
            if(response.noCommandComplete){
                if(type=="Inspect"){
                    errors.add(this.getErrorText("NoCommandComplete",response));
                    response.unableToProcess=true;
                }else if(type=="Execute JavaScript"||type=="Ad Hoc UI"){
                    response.fireCommandComplete=true;
                }
            }
        }
        if(errors.length>0)response.errors=errors;
        response.aiResponse=aiResponse;
        isc.logInfo(isc.echoFull(response));
        return response;
    }
,isc.A.cleanAIResponse=function isc_c_AI_cleanAIResponse(aiResponse){
        var clean=aiResponse.replaceAll(
                        isc.AI.exampleResponseDelineator,""
                    ).replaceAll(
                        isc.AI.aiResponseDelineator,""
                    ).replaceAll(
                        isc.AI.scPostDelineator,""
                    );
        return clean
    }
,isc.A.parseAIResponse=function isc_c_AI_parseAIResponse(aiResponse){
        var clean=this.cleanAIResponse(aiResponse);
        var response={};
        response.responseType=this.retrieveAttributeValue("ResponseType:",clean);
        response.messageType=this.retrieveAttributeValue("MessageType:",clean);
        response.message=this.retrieveAttributeValue("Message:",clean,["MessageType:","======","ResponseType:"]);
        response.javaScript=this.retrieveAttributeValue("======",clean,["======"]);
        if(response.javaScript){
            var commandCompleteRegex=new RegExp(/(isc\.AI\.commandComplete\()([\s\S]*?)(\))+/)
            if(response.javaScript.match(commandCompleteRegex)==null){
                response.noCommandComplete=true;
            }
        }
        return{response:response,aiResponse:clean};
    }
,isc.A.retrieveAttributeValue=function isc_c_AI_retrieveAttributeValue(attributeName,aiResponse,endMarkers){
        var attrEndRegex="(?:$|\\n)";
        if(endMarkers!=null&&endMarkers.length>0){
            attrEndRegex="(?:$|\\n\\s*"+endMarkers.join("|\\n\\s*")+")";
        }
        var reString="(?:\\n|^)\\s*"+attributeName+"([\\s\\S]*?)"+attrEndRegex;
        var result=aiResponse.match(new RegExp(reString));
        if(result!=null)result=result.last().trim();
        return result;
    }
,isc.A.handleAIJavaScript=function isc_c_AI_handleAIJavaScript(response,context){
        if(this.isReify){
            this._reifyProjectState=isc.AI.getVB().getProjectState();
        }
        var js=response.javaScript,
            adHocUI=response.responseType=="Ad Hoc UI",
            noAutoDraw
        ;
        if(adHocUI)noAutoDraw=isc.noAutoDraw=true;
        var _this=this;
        delete this.aemError;
        var idMapping=context&&context.idMapping;
        var localVars;
        if(idMapping){
            localVars={};
            for(var ID in idMapping){
                var liveWidget=isc.AutoTest.getLocatorCanvas(idMapping[ID][0]);
                if(liveWidget!=null){
                    localVars[ID]=liveWidget;
                }
            }
        }
        var evalResult=isc.Class.evaluateAICode(
            js,
            function(evaluationError){
                this.aemError=evaluationError;
                if(evaluationError.errorType=="Timeout"){
                    _this.handleAEMTimeout();
                }else{
                    _this.handleAEMError(evaluationError.error);
                }
            },
            true,
            adHocUI,
            localVars
        );
        if(this.aemError){
            delete this.aemError;
            return;
        }
        if(response.fireCommandComplete){
            this.commandComplete();
        }
        if(adHocUI){
            isc.AI.uiWindow=this.createAdHocUIWindow();
            var globals=evalResult.globals;
            var canvii=isc.Canvas._getTopLevelWidget(globals,true);
            isc.AI.uiWindow.setAdHocUI(canvii,response);
            isc.AI.uiWindow.show();
        }
    }
,isc.A.handleAEMError=function isc_c_AI_handleAEMError(error){
        this.resetApplicationState();
        this.logWarn("Error executing AI-generated script:"+error);
        var errorTemplate=this.errorTypes["JavaScriptError"];
        var errorMessage=error.message,
            hint=this.getJSErrorHint(errorMessage)||"";
        var errorPrompt=errorTemplate.evalDynamicString(this,{error:error,hint:hint});
        this._aemErrorCount++;
        if(this._aemErrorCount>2){
            this._aemErrorCount=0;
            isc.say("The AI-generated script has caused an execution error. Please rephrase your request and try again.");
        }else{
            this.command(errorPrompt,"resolveError");
        }
    }
,isc.A.resetApplicationState=function isc_c_AI_resetApplicationState(){
        if(this.isReify&&this._reifyProjectState!=null){
            isc.AI.getVB().restoreProjectState(this._reifyProjectState);
            delete this._reifyProjectState;
        }else{
        }
    }
,isc.A.getJSErrorHint=function isc_c_AI_getJSErrorHint(errorMessage){
        var hint="";
        if(new RegExp("^\S+ is undefined").test(errorMessage)){
            hint="\nSmartClient components are available by the ID in global scope. "+
                "SmartClient classes may be accessed via their class name with the prefix \"isc.\" in global scope.\n";
        }
        return hint;
    }
,isc.A.handleAEMTimeout=function isc_c_AI_handleAEMTimeout(){
        this.logWarn("Timeout after executing AI-generated script - either the "+
            "code flow failed to complete, or did not invoke AI.commandComplete() when it completed.");
    }
,isc.A.getDataSourceNames=function isc_c_AI_getDataSourceNames(){
        if(this.applicationDataSources!=null){
            var dsNames=[];
            for(var i=0;i<this.applicationDataSources.length;i++){
                var dsName=this.applicationDataSources[i];
                if(isc.DataSource.get(dsName)!=null){
                    dsNames.add(dsName);
                }
            }
            return dsNames;
        }
        return(isc.AI.isReify?
            isc.AI.getVB().getProjectDataSourceNames():
            isc.DS.getRegisteredDataSourceObjects(true,true,true,true).getProperty("ID"));
    }
,isc.A.getDataSourceDefinitions=function isc_c_AI_getDataSourceDefinitions(format){
        if(format==null)format="pseudocode";
        if(isc.AI.isReify){
            return isc.AI.getVB().getProjectDataSourceDefinitions(format);
        }else{
            var dsArr=this.getDataSourceNames();
            if(dsArr&&dsArr.length>0){
                dsArr=dsArr.map(function(dsName){return isc.DataSource.get(dsName)});
            }
            return isc.DS.getRegisteredDataSourceDefinitions(format,false,dsArr);
        }
    }
,isc.A.getUISummary=function isc_c_AI_getUISummary(captureWidgetIDs){
        var rootCanvas=this.customRootCanvas;
        if(!rootCanvas)rootCanvas=this.applicationRootCanvas;
        if(rootCanvas==null){
            if(isc.AI.isReify){
                var vb=isc.AI.getVB();
                rootCanvas=vb&&vb.getScreenBaseComponent();
            }else if(isc.AI.isShowcase){
                var exampleViewer=window["featureExplorer_exampleViewer"];
                if(exampleViewer){
                    if(exampleViewer.fullScreenExampleWindow&&
                        exampleViewer.fullScreenExampleWindow.isDrawn()&&
                        exampleViewer.fullScreenExampleWindow.isVisible())
                    {
                        rootCanvas=exampleViewer.fullScreenExampleWindow.viewPane.viewContainer;
                    }else if(
                        exampleViewer.viewPane&&
                        exampleViewer.viewPane.isDrawn()&&
                        exampleViewer.viewPane.isVisible()
                    ){
                        rootCanvas=exampleViewer.viewPane.viewContainer
                    }
                }
            }
        }
        if(rootCanvas==null){
            var topCanvii=isc.Canvas._topCanvii||[];
            for(var i=0;i<topCanvii.length;i++){
                var topCanvas=topCanvii[i];
                if(topCanvas==null)continue;
                if(isc.isA.ScreenSpan(topCanvas))continue;
                if(!topCanvas.isVisible()||!topCanvas.isDrawn()){
                    continue;
                }
                if(isc.isA.Menu(topCanvas))continue;
                if(topCanvas==isc.AI.assistantWindow)continue;
                if(topCanvas.children!=null){
                    rootCanvas=topCanvas;
                    break;
                }
            }
        }
        if(rootCanvas==null)return"";
        var summaryConfig=rootCanvas.getUISummary(["data"]);
        var idMapping={},
            summaryText=isc.JSON.encode(this.postProcessUISummary(summaryConfig,idMapping));
        return captureWidgetIDs?[summaryText,idMapping]:summaryText;
    }
,isc.A.postProcessUISummary=function isc_c_AI_postProcessUISummary(object,idMapping){
        if(isc.isA.Array(object)){
            for(var i=0;i<object.length;i++){
                this.postProcessUISummary(object[i],idMapping);
            }
        }else if(isc.isA.Object(object)&&!isc.isA.Date(object)){
            for(var prop in object){
                this.postProcessUISummary(object[prop],idMapping);
            }
        }
        var smartClientComponentType=object&&object.smartClientComponentType;
        if(smartClientComponentType!=null){
            object._serialize=function(prefix,objRefs,objPath){
                var smartClientComponentType=this.smartClientComponentType;
                var config={};
                var ID=this.id;
                var liveWidget=window[ID];
                if(liveWidget&&liveWidget._autoAssignedID){
                    var localID=liveWidget.getLocalId();
                    var i=0;
                    ID=localID;
                    while(idMapping[ID]!=null){
                        ID=localID+"_"+(++i);
                    }
                    idMapping[ID]=[isc.AutoTest.getObjectLocator(liveWidget),localID,liveWidget.getScreenId()];
                }
                config.ID=ID;
                isc.addProperties(config,this);
                delete config._serialize;
                delete config.smartClientComponentType;
                delete config.id;
                return"isc."+smartClientComponentType+".create("+isc.JSON.encode(config,{prettyPrint:true,leadingIndent:prefix})+")";
            }
        }
        return object;
    }
,isc.A.createAdHocUIWindow=function isc_c_AI_createAdHocUIWindow(){
        return isc.Window.create(isc.AI.adHocUIWindowDefaults);
    }
,isc.A.showSaveUIWindow=function isc_c_AI_showSaveUIWindow(response){
        if(!isc.AI.saveUIWindow){
            isc.AI.saveUIWindow=isc.Window.create(isc.AI.saveUIWindowDefaults);
        }
        isc.AI.saveUIWindow.setResponse(response);
        isc.AI.saveUIWindow.show();
        isc.AI.saveUIWindow.bringToFront();
    }
,isc.A.hideSaveUIWindow=function isc_c_AI_hideSaveUIWindow(){
        if(isc.AI.saveUIWindow)isc.AI.saveUIWindow.hide();
    }
,isc.A.getScreensDataSource=function isc_c_AI_getScreensDataSource(){
        if(!this.screensDataSource)this.screensDataSource=this.getLocalDataSource();
        return this.screensDataSource;
    }
,isc.A.getLocalDataSource=function isc_c_AI_getLocalDataSource(){
        return this._getLocalDataSource({
            transformRequest:function(dsRequest){
                if(dsRequest.doNotTrackRPC==null)dsRequest.doNotTrackRPC=!isc.ss.logLocalDSRequests;
                return dsRequest;
            },
            _generated:true,
            storageMode:"allRecords",
            storageKey:this.savedUIStorageKey
        });
    }
,isc.A._getLocalDataSource=function isc_c_AI__getLocalDataSource(props){
        var _this=this;
        return isc.LocalDataSource.create(props,{
            fields:[
                {name:"name",primaryKey:true},
                {name:"response",type:"text",length:1000000}
            ],
            destroy:function(){
                return this.Super("destroy");
            }
        });
    }
,isc.A.saveAdHocUI=function isc_c_AI_saveAdHocUI(name,response){
        isc.AI.getScreensDataSource().addData({name:name,response:response});
        isc.say("Ad Hoc UI saved.");
    }
,isc.A.getSavedUI=function isc_c_AI_getSavedUI(name,callback){
        isc.AI.getScreensDataSource().fetchData({name:name},
            function(dsRequest,data,rsRequest){
                if(isc.isAn.Array(data))data=data[0];
                if(callback)callback(data);
            }
        );
    }
,isc.A.removeSavedUI=function isc_c_AI_removeSavedUI(name){
        isc.AI.getScreensDataSource().removeData({name:name});
    }
,isc.A.showAssistant=function isc_c_AI_showAssistant(aiContext){
        if(!isc.AI.assistantWindow){
            isc.AI.assistantWindow=isc.Window.create(isc.AI.assistantWindowDefaults);
        }
        isc.AI.initAssistantContext(aiContext);
        isc.AI.assistantWindow.show();
    }
,isc.A.hideAssistant=function isc_c_AI_hideAssistant(){
        if(isc.AI.assistantWindow)isc.AI.assistantWindow.close();
    }
,isc.A.assistantClosed=function isc_c_AI_assistantClosed(){
        if(this.clearHistoryOnClose&&this.useClientSessionHistory)this.clearSession();
        delete isc.AI.assistantContext;
        delete isc.AI.customRootCanvas;
    }
,isc.A.initAssistantContext=function isc_c_AI_initAssistantContext(aiContext){
        if(isc.AI.assistantWindow){
            if(isc.AI.assistantWindow.isVisible())isc.AI.hideAssistant();
        }else isc.AI.clearSession();
        isc.AI.assistantContext=aiContext;
        this.customRootCanvas=aiContext&&aiContext.rootCanvas;
    }
,isc.A.useAssistant=function isc_c_AI_useAssistant(userPrompt,context){
        isc.AI.initAssistantContext(context);
        isc.AI.command(userPrompt,"userQuery");
    }
,isc.A.showClarifyWindow=function isc_c_AI_showClarifyWindow(aiText){
        if(!isc.AI.clarifyWindow){
            isc.AI.clarifyWindow=isc.Window.create(isc.AI.clarifyWindowDefaults);
        }
        var win=isc.AI.clarifyWindow;
        win.label.setContents(aiText);
        win.form.clearValues();
        win.show();
    }
,isc.A.hideClarifyWindow=function isc_c_AI_hideClarifyWindow(){
        if(isc.AI.clarifyWindow)isc.AI.clarifyWindow.hide();
    }
,isc.A.getIconURL=function isc_c_AI_getIconURL(darkBackground){
        return isc.Media.getStockIconSrc("AIAssist");
    }
,isc.A._extractJsonResult=function isc_c_AI__extractJsonResult(result,ldelim,rdelim,excludeDelimiters){
        if(ldelim==null){
            ldelim='{';
        }
        if(rdelim==null){
            rdelim='}';
        }
        var lastRdelimPos=result.lastIndexOf(rdelim);
        if(lastRdelimPos<0)return this._invalidResult;
        result=result.substring(0,lastRdelimPos+(excludeDelimiters?0:rdelim.length));
        var ldelimPos;
        while((ldelimPos=result.indexOf(ldelim))>=0){
            result=result.substring(ldelimPos+(excludeDelimiters?ldelim.length:0));
            try{
                return isc.JSON.decode(result);
            }catch(_e){
                if(!excludeDelimiters)result=result.substring(ldelim.length);
            }
        }
        return this._invalidResult;
    }
,isc.A.asyncRepeatRequestOnBatches=function isc_c_AI_asyncRepeatRequestOnBatches(templateAIRequest,records,fieldNames,settings,responseForBatchCallback){
        var aiResponsesForBatches=[];
        if(!this.isEnabled()){
            return isc.rejectAsDisabled(this.aiWasDisabledMessage,{aiResponsesForBatches:aiResponsesForBatches});
        }
        var givenCC=settings.cancellationController,
            subCC;
        if(givenCC){
            if(givenCC.canceled){
                return Promise.reject(givenCC.asCanceledResult({
                    aiResponsesForBatches:aiResponsesForBatches
                }));
            }
            subCC=givenCC.createSubController();
        }else{
            subCC=isc.CancellationController.create();
        }
        var maxPasses=settings.maxPasses==null?2:settings.maxPasses;
        if(maxPasses<1){
            return isc.rejectWithError("Exceeded the maximum number of passes.",{aiResponsesForBatches:aiResponsesForBatches});
        }
        var context=this._getContextForRequest(templateAIRequest);
        if(context.errorMessage)return isc.rejectWithError(context.errorMessage,{aiResponsesForBatches:aiResponsesForBatches});
        context.aiResponsesForBatches=aiResponsesForBatches;
        var secondPassBatches=context.secondPassBatches=[];
        var aiConfig={
            maxRetries:settings.maxRetries==null?2:settings.maxRetries
        };
        var aiSettings={
            serializationFormat:"compactJSON",
            fieldNames:fieldNames,
            maxRetries:aiConfig.maxRetries,
            cancellationController:subCC,
            aiPageSize:settings.maxRecordsPerBatch,
            recordIndexFieldName:settings.recordIndexFieldName
        };
        var batches=settings._batches;
        if(!batches){
            templateAIRequest=isc.addPropertiesWithAssign({},templateAIRequest);
            templateAIRequest.cancellationController=subCC;
            batches=context.aiEngine.getBatches(templateAIRequest,records,aiSettings);
        }else{
            batches=batches.duplicate();
            for(var i=0;i<batches.length;++i){
                var batch=batches[i]=isc.addPropertiesWithAssign({},batches[i]);
                batch.aiRequest=isc.addProperties({},batch.aiRequest);
                batch.aiRequest.cancellationController=subCC;
            }
        }
        var stopOnError=settings.stopOnError!=false;
        var processAIResponse=function(batch,aiResponse){
            if(givenCC&&givenCC.canceled)return;
            aiResponse.startIndex=batch.startIndex;
            aiResponse.length=batch.length;
            aiResponsesForBatches.push(aiResponse);
            aiResponse.callbackReturnValue=isc.AI.fireCallback(responseForBatchCallback,isc.AI._responseForBatchCallbackArgNames,[aiResponse,context]);
            return aiResponse;
        };
        var mapper=isc.ResolvedValuesMapper.create({
            values:batches,
            keepSettledStatus:!stopOnError?true:null,
            cancellationController:givenCC,
            maxConcurrent:settings.maxConcurrent,
            asyncMap:function(batch){
                return context.aiEngine.asyncSendRequest(batch.aiRequest,aiConfig)
                    .then(function(aiResponse){
                        return processAIResponse(batch,aiResponse);
                    },function(nonSuccessfulAIResponse){
                        var errorType=nonSuccessfulAIResponse.errorType;
                        if(maxPasses>=2&&batch.length>=2&&
                            (errorType=="requestSizeLimitExceeded"||errorType=="responseSizeLimitExceeded"))
                        {
                            secondPassBatches.addList(context.aiEngine.splitBatch(batch));
                            return null;
                        }
                        if(stopOnError&&!subCC.canceled){
                            subCC.cancel("The request for the batch starting at "+
                                    batch.startIndex+", length "+batch.length+" failed: "+
                                    isc.getAsyncMessage(nonSuccessfulAIResponse),"external");
                        }
                        return Promise.reject(processAIResponse(batch,nonSuccessfulAIResponse));
                    });
            }
        });
        return mapper.getPromise()
            .then(function(){
                if(givenCC&&givenCC.canceled){
                    return Promise.reject(givenCC.asCanceledResult({
                        aiResponsesForBatches:aiResponsesForBatches
                    }));
                }
                if(secondPassBatches.isEmpty()){
                    isc.AI._assert(!stopOnError||!givenCC||!givenCC.canceled);
                    return{
                        type:"success",
                        aiResponsesForBatches:aiResponsesForBatches
                    };
                }
                isc.AI._assert(maxPasses>=2);
                var subSettings=isc.addPropertiesWithAssign({},settings);
                subSettings.cancellationController=subCC;
                subSettings._batches=secondPassBatches;
                subSettings.maxPasses=maxPasses-1;
                var subCallback=function(aiResponseForBatch,subContext){
                    aiResponsesForBatches.push(aiResponseForBatch);
                    return isc.AI.fireCallback(responseForBatchCallback,isc.AI._responseForBatchCallbackArgNames,
                            [aiResponseForBatch,context]);
                };
                return isc.AI.asyncRepeatRequestOnBatches(templateAIRequest,records,fieldNames,subSettings,subCallback)
                    .then(function(){
                        return{
                            type:"success",
                            aiResponsesForBatches:aiResponsesForBatches
                        };
                    });
            });
    }
);
isc.evalBoundary;isc.B.push(isc.A.buildSort=function isc_c_AI_buildSort(userPrompt,callback,context,aiConfig){
        aiConfig=isc.addProperties({},aiConfig,{showPrompt:false,context:context});
        var grid=context.grid||context.rootCanvas;
        var ds=grid.getDataSource();
        var fields=ds!=null?isc.getValues(ds.getFields()):grid.getFields();
        var prompt="This is a request for an array of SortSpecifiers to sort the records in a ListGrid in "+
                "a web application built with the Isomorphic SmartClient Javascript framework.  "+
                "Your response should fulfill the following user request:\n'"+userPrompt+"'\n\n"
        prompt+="Your response should be a JSON object with the following properties:\n"+
                "\"sortSpecifiers\": an array of SortSpecifier objects, one for each sort-field "+
                "the user requested, where each consists of two attributes - 'property' (the "+
                "property to sort by) and 'direction' (either 'ascending' or 'descending').\n"+
                "\"groupSortDirection\": this is the sort-direction for group-headers, as opposed "+
                "to data-records - only include this property if the user has asked for "+
                "groups to be sorted - valid values are 'ascending' and 'descending'.  If the "+
                "user requested that group-sort be cleared, set this attribute to null.\n\n";
        prompt+="For example, an appropriate response to a user request of 'Sort by supplierName, "+
                "then by unitCost in descending order' might be as follows:\n"+
                "{sortSpecifiers:[{\"fieldName\":\"supplierName\",\"direction\":\"ascending\"},"+
                "[{\"fieldName\":\"unitCost\",\"direction\":\"descending\"}]}\n\n";
        prompt+="Another example:\n"+
                "request: 'Sort by supplierName and sort groups alphabetically'\n"+
                "response:\n"+
                "{sortSpecifiers:[{\"fieldName\":\"supplierName\",\"direction\":\"ascending\"}], "+
                "groupSortDirection: \"ascending\"}\n\n";
        prompt+="If the user is requesting the existing sort be cleared, set the \"sortSpecifiers\" "+
                "attribute to an empty array.\n";
        prompt+="For context, what follows is the list of fields available for use in SortSpecifiers - ";
        if(this.shouldUseAIFieldPaging(prompt,fields,aiConfig)){
            var _this=this;
            this.retrieveFieldsForPrompt(
                userPrompt,"Apply sorting by field(s)",fields,
                function(finalFields){
                    _this._buildSortWithFinalFields(userPrompt,prompt,callback,context,aiConfig,finalFields);
                },
                context,aiConfig
            );
        }else{
            this._buildSortWithFinalFields(userPrompt,prompt,callback,context,aiConfig,fields);
        }
    }
,isc.A._buildSortWithFinalFields=function isc_c_AI__buildSortWithFinalFields(userPrompt,prompt,callback,context,aiConfig,fields){
        prompt+=this.getSerializedFields(fields,aiConfig)+"\n\n";
        var grid=context.grid||context.rootCanvas;
        prompt+="\n\nFinally, here is the grid's current sort-state:\n";
        prompt+=grid.getSortState()+"\n\n";
        var _this=this;
        isc.AI.origSendPrompt(
            prompt,
            function(result){
                var obj=_this._extractJsonResult(result);
                _this.fireCallback(callback,"result,context",[obj,context]);
            },
            aiConfig);
    }
,isc.A.buildSetFields=function isc_c_AI_buildSetFields(userPrompt,callback,context,aiConfig){
        aiConfig=isc.addProperties({},aiConfig,{showPrompt:false,context:context});
        var prompt=this.setFieldsFixedPrompt.evalDynamicString(this,{userPrompt:userPrompt})
        var grid=context.grid||context.rootCanvas;
        var allFields=grid.getAllFields();
        var visibleFields=[];
        var hiddenFields=[];
        for(var i=0;i<allFields.length;i++){
            if(!grid.fieldIsVisible(allFields[i])){
                hiddenFields.add(allFields[i]);
            }else{
                visibleFields.add(allFields[i]);
            }
        }
        prompt+=this.setFieldsVisibleFieldsPromptPrefix;
        prompt+=this.getSerializedFields(visibleFields,aiConfig)+"\n\n";
        if(this.shouldUseAIFieldPaging(prompt,hiddenFields,aiConfig)){
            var _this=this;
            this.retrieveFieldsForPrompt(
                userPrompt,"Showing and hiding fields in a databound component",hiddenFields,
                function(finalFields){
                    _this._buildSetFieldsWithFinalFields(userPrompt,prompt,callback,context,aiConfig,finalFields);
                },
                context,aiConfig
            );
        }else{
            this._buildSetFieldsWithFinalFields(userPrompt,prompt,callback,context,aiConfig,hiddenFields);
        }
    }
,isc.A._buildSetFieldsWithFinalFields=function isc_c_AI__buildSetFieldsWithFinalFields(userPrompt,prompt,callback,context,aiConfig,hiddenFields){
        prompt+=this.setFieldsHiddenFieldsPromptPrefix;
        prompt+=this.getSerializedFields(hiddenFields,aiConfig);
        var _this=this;
        isc.AI.origSendPrompt(
            prompt,
            function(result){
                var obj=_this._extractJsonResult(result);
                _this.fireCallback(callback,"result,context",[obj,context]);
            },
            aiConfig);
    }
,isc.A.buildGroupBy=function isc_c_AI_buildGroupBy(userPrompt,callback,context,aiConfig){
        aiConfig=isc.addProperties({},aiConfig,{showPrompt:false,context:context});
        var grid=context.grid||context.rootCanvas;
        var gridFields=grid.getFields();
        var prompt="This is a request to determine which field or fields to pass to ListGrid.groupBy() "+
            "in a web application built with the Isomorphic SmartClient Javascript framework.";
        prompt+="Your response should be structured as a JSON array of strings, where array-entries \n"+
                  "are the field-name(s) the user wishes to group by, if any are mentioned.\n"+
                  "If the user requested any existing grouping be cleared, your response should be an "+
                  "empty array.\n\n";
        prompt+="Examples of appropriate responses to user requests:\n\n"+
                "request:\n"+
                "Group by supplierName\n"+
                "response:\n"+
                "[\"supplierName\"]\n\n"+
                "request:\n"+
                "request:\n"+
                "Group the grid by availability, then by region\n"+
                "response:\n"+
                "[\"availability\",\"region\"]\n\n"+
                "request:\n"+
                "Clear the current grouping\n"+
                "response:\n"+
                "[]\n\n";
        prompt+="For context, what follows is the list of fields in the Grid.\n";
        prompt+=this.getSerializedFields(gridFields,aiConfig)+"\n\n";
        prompt+="And here is the grid's current group-state - this is for comparison only:\n";
        prompt+=grid.getGroupState()+"\n\n";
        prompt+="\n\nThe user's request is: \n'"+userPrompt+"'\n";
        var _this=this;
        isc.AI.origSendPrompt(
            prompt,
            function(result){
                var obj=_this._extractJsonResult(result,"[","]");
                _this.fireCallback(callback,"result,context",[obj,context]);
            },
            aiConfig);
    }
,isc.A.asyncSendRequest=function isc_c_AI_asyncSendRequest(aiRequest,config){
        var context=this._getContextForRequest(aiRequest);
        if(context.errorMessage)return isc.rejectWithError(context.errorMessage);
        return context.aiEngine.asyncSendRequest(aiRequest,config);
    }
,isc.A._supportsAIComponentViews=function isc_c_AI__supportsAIComponentViews(ds,aiServiceMode){
        if(false){
            return false;
        }
        var dsID=ds.getID();
        if(dsID==null||isc.DS.get(dsID)!==ds)return false;
        if(!ds.supportsAdvancedCriteria())return false;
        var pkFieldNames=ds.getPrimaryKeyFieldNames();
        if(pkFieldNames==null||pkFieldNames.length!=1||!pkFieldNames[0])return false;
        return true;
    }
,isc.A._createBuildViaAIContext=function isc_c_AI__createBuildViaAIContext(asyncMethodName,buildRequest,opContext){
        var givenCC=opContext.cancellationController;
        var buildContext={
            _resolversObj:Promise.withResolvers(),
            cancellationController:givenCC,
            _ownCC:givenCC?givenCC.createSubController():isc.CancellationController.create(),
            _asyncMethodName:asyncMethodName,
            buildRequest:buildRequest,
            referenceTime:buildRequest.referenceTime||new Date,
            _numStepsCompleted:0,
            _estimatedNumTotalSteps:0,
            _progressDialog:null,
            _aiConfig:{
                maxRetries:(buildRequest.maxRetries==null?2:buildRequest.maxRetries),
                serializationFormat:"compactJSON"
            }
        };
        if(asyncMethodName=="asyncApplyAIFilter")buildContext.applyRequest=buildRequest;
        var cancelObservationId;
        if(givenCC){
            cancelObservationId=isc.observe(givenCC,"cancel","isc.AI.__handleCancelBuildViaAI(returnVal,observed,observer._buildContext,reason,initiator)");
            isc.addProperties(isc.Page._staticObservers[cancelObservationId].observer,{
                _buildContext:buildContext
            });
        }
        var finish=function(buildResponse){
            buildContext._ownCC.destroy();
            if(cancelObservationId!=null)isc.ignore(cancelObservationId);
            var progressDialog=buildContext._progressDialog;
            if(progressDialog&&!progressDialog.destroyed){
                if(buildResponse.type=="canceled"){
                    progressDialog.hide();
                    progressDialog.destroy();
                }else{
                    if(buildResponse.type=="error"){
                        isc.AI._fireAIProgressCallback(
                                buildContext,
                                [{category:"error",content:isc.getAsyncMessage(buildResponse)}],
                                true);
                    }
                    progressDialog.finish(buildResponse.type=="success");
                }
            }
        };
        buildContext._resolversObj.promise.then(finish,finish);
        return buildContext;
    }
,isc.A._fireAIProgressCallback=function isc_c_AI__fireAIProgressCallback(buildContext,newMessages,showProgressDialog){
        if(buildContext._ownCC.canceled)return;
        var numStepsCompleted=buildContext._numStepsCompleted,
            estimatedNumTotalSteps=buildContext._estimatedNumTotalSteps;
        this._assert(numStepsCompleted<=estimatedNumTotalSteps);
        var progressDialog=buildContext._progressDialog;
        if(progressDialog){
            progressDialog.setProgress(numStepsCompleted,estimatedNumTotalSteps);
            progressDialog.addMessages(newMessages);
            if(showProgressDialog)progressDialog.show();
        }
        isc.AI.fireCallback(
            buildContext.buildRequest.progressCallback,
            isc.AI._aiProgressCallbackArgNames,
            [buildContext,numStepsCompleted,estimatedNumTotalSteps,newMessages]
        );
    }
,isc.A._cancelBuildViaAI=function isc_c_AI__cancelBuildViaAI(buildContext,reason,initiator){
        buildContext._resolversObj.reject({
            type:"canceled",
            cancellationReason:reason,
            cancellationInitiator:initiator
        });
    }
,isc.A.__handleCancelBuildViaAI=function isc_c_AI___handleCancelBuildViaAI(wasFirstCancel,cancellationController,buildContext,reason,initiator){
        if(!wasFirstCancel)return;
        this._assert(cancellationController===buildContext.cancellationController);
        this._cancelBuildViaAI(buildContext,reason,initiator);
    }
,isc.A._wrapAsyncBuildViaAIOperation=function isc_c_AI__wrapAsyncBuildViaAIOperation(asyncMethodName,buildRequest,callback){
        var fireCallback=function(buildResponse){
            var argNames=asyncMethodName=="asyncApplyAIFilter"?isc.AI._applyAIFilterResponseCallbackArgNames:isc.AI._buildViaAIResponseCallbackArgNames;
            isc.AI.fireCallback(callback,argNames,[buildResponse,buildRequest]);
        };
        return this[asyncMethodName](buildRequest)
            ._whenSettled(fireCallback);
    }
,isc.A._asyncSummarizeUserMessages=function isc_c_AI__asyncSummarizeUserMessages(buildContext){
        var buildRequest=buildContext.buildRequest,
            userAIRequest=buildRequest.userAIRequest;
        var userMessages=[{content:userAIRequest.prompt,type:userAIRequest.promptType}];
        if(userAIRequest.additionalMessages){
            userMessages.addList(userAIRequest.additionalMessages);
            userMessages.removeEmpty();
        }
        buildContext._userMessages=userMessages;
        var indices=[],
            promises=[];
        for(var index=0;index<userMessages.length;++index){
            if(isc.AIEngine.isImageMessage(userMessages[index])){
                indices.push(index);
                promises.push(this._asyncSummarizeImage(userMessages[index],buildContext));
            }
        }
        if(indices.isEmpty()){
            buildContext._summarizedUserMessages=userMessages;
            return Promise.resolve(userMessages);
        }
        buildContext._summarizedUserMessages=userMessages.duplicate();
        buildContext._estimatedNumTotalSteps+=indices.length;
        this._fireAIProgressCallback(buildContext,[{category:"detail",content:"AI will be asked to summarize your request."}],true);
        return Promise.all(promises)
            .then(function(actuallySummarizedUserMessages){
                var summarizedUserMessages=buildContext._summarizedUserMessages;
                for(var i=0;i<indices.length;++i){
                    summarizedUserMessages[indices[i]]=actuallySummarizedUserMessages[i];
                }
                isc.AI._fireAIProgressCallback(
                    buildContext,
                    [{
                        category:"success",
                        content:"Finished summarizing your request"
                    }]
                );
                return summarizedUserMessages;
            });
    }
,isc.A._asyncSummarizeImage=function isc_c_AI__asyncSummarizeImage(userMessage,buildContext){
        var aiRequest={
            cancellationController:buildContext._ownCC,
            messages:[
                {content:"Summarize in detail the following image:",source:"system"},
                isc.addProperties({},userMessage,{source:"user"})
            ]
        };
        return this.asyncSendRequest(aiRequest,buildContext._aiConfig)
            .then(function(aiResponse){
                ++buildContext._numStepsCompleted;
                isc.AI._fireAIProgressCallback(buildContext);
                return{content:"An image described as: "+aiResponse.message.content};
            });
    }
,isc.A._canUseAICriterion=function isc_c_AI__canUseAICriterion(aiCriterion,ds){
        if(aiCriterion._dsName!=null&&aiCriterion._dsName!=ds.getID()){
            this.logWarn("'aiFilter' criterion built for DataSource '"+aiCriterion._dsName+"' is being used with DataSource '"+ds.getID()+"'.","AI");
        }
        if(aiCriterion._dsName!=ds.getID()||
            !aiCriterion._summarizedUserMessages||
            !isc.isAn.Array(aiCriterion._pkFieldNames)||
            !isc.isAn.Array(aiCriterion._finalFieldNames)||
            !aiCriterion._dsSummary)
        {
            return false;
        }
        var expectedPkFieldNames=ds.getPrimaryKeyFieldNames();
        if(aiCriterion._pkFieldNames.length!=expectedPkFieldNames.length)return false;
        for(var i=0;i<expectedPkFieldNames.length;++i){
            if(!aiCriterion._pkFieldNames.contains(expectedPkFieldNames[i]))return false;
        }
        var dsFields=ds.getFields();
        for(var i=0;i<aiCriterion._finalFieldNames.length;++i){
            if(!(aiCriterion._finalFieldNames[i]in dsFields))return false;
        }
        if(aiCriterion._notPickedPkValues!=null&&!isc.isA.Class(aiCriterion._notPickedPkValues)){
            return false;
        }
        if(aiCriterion._pickedPkValues!=null&&!isc.isA.Class(aiCriterion._pickedPkValues)){
            return false;
        }
        return true;
    }
,isc.A._getPromptText=function isc_c_AI__getPromptText(aiCriterion,dataSource){
        if(this._canUseAICriterion(aiCriterion,dataSource)){
            var userAIFilterRequest=aiCriterion.userAIRequest;
            if(userAIFilterRequest!=null&&
                isc.AIEngine._isTextContentType(userAIFilterRequest.promptType)&&
                userAIFilterRequest.prompt!=null)
            {
                return String(userAIFilterRequest.prompt);
            }
        }
        return"";
    }
,isc.A._applyUsableAIFilterCaches=function isc_c_AI__applyUsableAIFilterCaches(aiCriterion,records,dataSource){
        var partialResult={
            matchingRecords:null,
            remainingRecords:null
        };
        if(aiCriterion.isTrivial){
            partialResult.matchingRecords=records;
        }else{
            var notPickedPkValues=aiCriterion._notPickedPkValues,
                pickedPkValues=aiCriterion._pickedPkValues;
            if(!isc.isA.Class(notPickedPkValues))notPickedPkValues=null;
            if(!isc.isA.Class(pickedPkValues))pickedPkValues=null;
            var matchingRecords=partialResult.matchingRecords=[];
            if(notPickedPkValues||pickedPkValues){
                var remainingRecords=partialResult.remainingRecords=[];
                var pkFieldNames=aiCriterion._pkFieldNames;
                if(pkFieldNames.length==1){
                    var pkFieldName=pkFieldNames[0];
                    for(var recordIndex=0;recordIndex<records.length;++recordIndex){
                        var pkValue=records[recordIndex][pkFieldName];
                        if(notPickedPkValues&&notPickedPkValues.has(pkValue)){
                        }else if(pickedPkValues&&pickedPkValues.has(pkValue)){
                            matchingRecords.add(records[recordIndex]);
                        }else{
                            remainingRecords.add(records[recordIndex]);
                        }
                    }
                }else{
                    this._assert(false);
                }
            }else partialResult.remainingRecords=records;
        }
        return partialResult;
    }
,isc.A._clearAICriterionState=function isc_c_AI__clearAICriterionState(aiCriterion){
        delete aiCriterion._summarizedUserMessages;
        delete aiCriterion._dsName;
        delete aiCriterion._pkFieldNames;
        delete aiCriterion._finalFieldNames;
        delete aiCriterion._dsSummary;
        delete aiCriterion._criteria;
        if(isc.isA.Class(aiCriterion._notPickedPkValues)){
            aiCriterion._notPickedPkValues.clear();
        }
        delete aiCriterion._notPickedPkValues;
        delete aiCriterion._notPickedCriterion;
        if(isc.isA.Class(aiCriterion._pickedPkValues)){
            aiCriterion._pickedPkValues.clear();
        }
        delete aiCriterion._pickedPkValues;
    }
,isc.A._getCleanAICriterion=function isc_c_AI__getCleanAICriterion(aiCriterion){
        var cleanCriterion=isc.addPropertiesWithAssign({},aiCriterion);
        delete cleanCriterion._notPickedPkValues;
        delete cleanCriterion._notPickedCriterion;
        delete cleanCriterion._pickedPkValues;
        delete cleanCriterion._clonable;
        delete cleanCriterion.clone;
        delete cleanCriterion.criteria;
        return cleanCriterion;
    }
,isc.A._createFromCleanAICriterion=function isc_c_AI__createFromCleanAICriterion(cleanCriterion){
        var notPickedPkValues,
            pickedPkValues;
        if(isc.isAn.Array(cleanCriterion._pkFieldNames)){
            if(cleanCriterion._pkFieldNames.length==1){
                notPickedPkValues=isc.Set.create();
                pickedPkValues=isc.Set.create();
            }else{
                notPickedPkValues=isc.TupleSet.create();
                pickedPkValues=isc.TupleSet.create();
            }
        }
        return isc.addProperties({},cleanCriterion,{
            _constructor:"AdvancedCriteria",
            operator:"aiFilter",
            _notPickedPkValues:notPickedPkValues,
            _notPickedCriterion:null,
            _pickedPkValues:pickedPkValues,
            _clonable:true,
            clone:isc.AI._aiCriterionCloneImpl
        });
    }
,isc.A._aiCriterionCloneImpl=function isc_c_AI__aiCriterionCloneImpl(){
        return this;
    }
,isc.A._createBuildCriterionContext=function isc_c_AI__createBuildCriterionContext(asyncMethodName,buildRequest,dabOpContext){
        var buildContext=this._createBuildViaAIContext(asyncMethodName,buildRequest,dabOpContext);
        buildContext.dataSource=dabOpContext.dataSource;
        var mode=buildRequest.mode;
        if(mode==null)mode="hybrid";
        else if(mode!="aiAssist"&&mode!="AIDE"&&mode!="hybrid"){
            this.logWarn("unsupported AI service mode '"+mode+"'. Switching to 'hybrid'.");
            mode="hybrid";
        }
        buildContext.mode=mode;
        if(buildRequest.showProgressDialog==null||buildRequest.showProgressDialog){
            buildContext._progressDialog=isc.FilterViaAIProgressDialog.create(buildRequest.progressDialogProperties,{
                _buildContext:buildContext,
                canCancel:buildRequest.userCanCancel!=false
            });
        }
        buildContext._estimatedNumTotalSteps=1;
        this._fireAIProgressCallback(buildContext,[{category:"detail",content:isc.AI.startingYourRequestDetailMessage}]);
        return buildContext;
    }
,isc.A.buildCriterion=function isc_c_AI_buildCriterion(buildRequest,callback){
        this._wrapAsyncBuildViaAIOperation(this._$asyncBuildCriterion,buildRequest,callback);
    }
,isc.A.asyncBuildCriterion=function isc_c_AI_asyncBuildCriterion(buildRequest){
        return this._asyncDataBoundAIOperation("_asyncBuildCriterion",buildRequest);
    }
,isc.A._asyncBuildCriterion=function isc_c_AI__asyncBuildCriterion(buildRequest,dabOpContext){
        var buildContext=this._createBuildCriterionContext(this._$asyncBuildCriterion,buildRequest,dabOpContext),
            dataSource=buildRequest.dataSource;
        if(!dataSource||!this._supportsAIComponentViews(dataSource,buildContext.mode)){
            buildContext._resolversObj.reject(isc.createErrorResult(this.dataSourceIsRequiredErrorMessage));
        }else{
            this._asyncSummarizeUserMessages(buildContext)
                .then(function(summarizedUserMessages){
                    return isc.AI._asyncBuildCriterionWithSummarizedUserMessages(
                            summarizedUserMessages,buildContext);
                })
                .then(function(criterion){
                    buildContext._resolversObj.resolve({type:"success",criterion:criterion});
                },function(rejectReason){
                    buildContext._resolversObj.reject(isc.defaultAsyncOperationCatchCallback(rejectReason));
                });
        }
        return buildContext._resolversObj.promise;
    }
);
isc.B._maxIndex=isc.C+107;

isc.AI.registerTemplates({
    buildCriterionCommonIntro:function(state,sc){
        const purpose=state.purpose;
        return isc.trimDoc`
            In the context of a business application developed using the Isomorphic SmartClient Framework,
            this is a request to generate an AdvancedCriteria object to apply to a DataBoundComponent
            for the purpose of ${sc.if(purpose == "hilite",
                "hiliting data-records",
                "filtering the data-records shown in the DataBoundComponent to only the ones"
            )} that match the following natural language description of criteria:
            <criteria-description>\${userMessages}</criteria-description>

            The DataBoundComponent's DataSource is:
            \${dsSummary}`;
    },
    buildCriterionAIAssistCommonResponseObjectPropertiesDescription:function(state,sc){
        return isc.trimDoc`
            * "fieldSummaries" (object): A map from the name of each field of the DataSource to a string containing
              a shortened summary of all of the following details that you infer about the
              field from the field's title, description, and other available information:
                - For numeric fields, the units of the field's values if applicable,
                  or whether the units are unknown.
                - The pattern or format of the field's values.
                - Whether the field's values may be \`null\`, and hence require special care
                  in less-than comparisons.
                - Any assumptions that you are making about the field's values.
                - Any uncertainties that you have about the field's values.
            * "criteriaSummary" (string): A shortened summary of all of the following details
              that you infer from the criteria-description:
                - The units of any numeric values mentioned in the criteria-description.
                - The list of field names that are relevant.
                - When comparing a value mentioned in the criteria-description to the values
                  of a field, any conversions of units and reformatting that you made to make
                  the comparison value have the same units and format of field values.
                - When selecting field values less-than a comparison value, whether the
                  criteria-description implies that \`null\` values should be included or
                  excluded.
                - Any assumptions that you are making about the described criteria.
                - Any uncertainties that you have about the described criteria.`;
    },
    buildCriterionCommonOutro:function(state,sc){
        const advancedCriteriaAIHelpDocument=isc.AI.advancedCriteriaAIHelpDocument;
        return isc.trimDoc`
            Here is information about the AdvancedCriteria object:
            <requirements-document topic="${advancedCriteriaAIHelpDocument.topic}"${sc.if(advancedCriteriaAIHelpDocument.format, ` format="${advancedCriteriaAIHelpDocument.format}"`)}>
            ${advancedCriteriaAIHelpDocument.content}</requirements-document>

            For reference, consider the current date and time to be: ${state.referenceTime}

            ${sc.render("requirementsForDisplayingInformationPromptSection")}`;
    },
    buildCriterionHybridPrompt:function(state,sc){
        const purpose=state.purpose;
        return isc.trimDoc`
            ${sc.render("buildCriterionCommonIntro", state)}

            There are two methods of ${sc.if(purpose == "hilite", "hiliting", "filtering")}
            the data-records of the DataBoundComponent:
            1. Generate an AdvancedCriteria object that directly corresponds to the criteria-description.
            2. Evaluate each data-record on a case-by-case basis, using the properties of each data-record,
               all reasonable inferences, and your own knowledge to decide whether a data-record matches
               the criteria-description.

            Method 1 is preferred if you can create such an AdvancedCriteria object.

            Your response must be a JSON object.

            If you decide that method 1 is sufficient, your response object must contain the
            following properties:
            ${sc.render("buildCriterionAIAssistCommonResponseObjectPropertiesDescription", state)}
            * "result": The AdvancedCriteria object that fulfills the criteria-description.

            If you decide that method 2 can fulfill the criteria-description, your response
            must be exactly '{ "result": "method2" }'

            In all other cases, your response object must contain the following properties:
            * "result": The string "invalid"
            * "invalidReasoning": A plain text string directed
              at the user containing your reason(s) why you are unable to generate a functional
              AdvancedCriteria object that fulfills the criteria-description and why evaluating
              each data-record on a case-by-case basis is also insufficient. In the "invalidReasoning" string,
              you must abide by the "${sc.AI.requirementsForDisplayingInformationSectionTitle}" below
              and phrase things in the context of ${sc.if(purpose == "hilite", "hiliting", "filtering")}
              records.

            ${sc.render("buildCriterionCommonOutro", state)}
        `;
    },
    buildCriterionAIAssistPrompt:function(state,sc){
        const purpose=state.purpose;
        return isc.trimDoc`
            ${sc.render("buildCriterionCommonIntro", state)}

            Your response must be a JSON object with the following properties:
            ${sc.render("buildCriterionAIAssistCommonResponseObjectPropertiesDescription", state)}
            * "result" (string or object):
                - If you are unable to generate a functional AdvancedCriteria object from the
                  criteria-description, "result" must be the string "invalid".
                - Otherwise, "result" must be the AdvancedCriteria object that fulfills the
                  criteria-description.
            * "invalidReasoning" (only if "reason" is "invalid"): A plain text string directed
              at the user containing your reason(s) why you are unable to generate a functional
              AdvancedCriteria object that fulfills the criteria-description. In the "invalidReasoning" string,
              you must abide by the "${sc.AI.requirementsForDisplayingInformationSectionTitle}" below
              and phrase things in the context of ${sc.if(purpose == "hilite", "hiliting", "filtering")}
              records.

            ${sc.render("buildCriterionCommonOutro", state)}
        `;
    }
});
isc.A=isc.AI;
isc.B=isc._allFuncs;
isc.C=isc.B._maxIndex;
isc.D=isc._funcClasses;
isc.D[isc.C]=isc.A.Class;
isc.A._allowedOperatorIds=[
        "and",
        "or",
        "not",
        "isBlank","notBlank",
        "isNull","notNull",
        "equals","notEqual","iEquals","iNotEqual",
        "contains","notContains","iContains","iNotContains",
        "startsWith","notStartsWith","iStartsWith","iNotStartsWith",
        "endsWith","notEndsWith","iEndsWith","iNotEndsWith",
        "greaterThan",
        "lessThan",
        "greaterOrEqual",
        "lessOrEqual"
    ];
isc.A.fixCriterionPrompts=[
        "The user of a web application built with the Isomorphic SmartClient JavaScript Framework "+
        "has requested to filter the data-records of a data-bound component according to the following filter-query:",
        "${userMessages}",
        "The data-bound component's DataSource has the following summary:\n"+
        "${dsSummary}\n\n"+
        "You generated the following AdvancedCriteria object:\n"+
        "${encodedCriterion}\n\n"+
        "The reason(s) why this is invalid are:\n"+
        "${validationErrors}\n\n"+
        "${encodedValidatedCriterion "+
        "? 'We have attempted to fix your AdvancedCriteria as follows:\\n' + encodedValidatedCriterion + '\\n\\n' "+
        ": ''}"+
        "Here is information about the AdvancedCriteria object:\n"+
        "<help-document topic=\""+isc.AI.advancedCriteriaAIHelpDocument.topic+"\" format=\""+isc.AI.advancedCriteriaAIHelpDocument.format+"\">\n"+
        isc.AI.advancedCriteriaAIHelpDocument.content,
        "</help-document>\n"+
        "\n"+
        "You are to generate a different AdvancedCriteria object that satisfies the user's "+
        "filter-query *and* avoids the validation errors listed above.\n"+
        "If you are unable to do this, then your response should be exactly "+
        "'{ \"result\": \"invalid\" }'"
    ];
isc.A.allowedCriterionPropertyNames=["fieldName","fieldQuery","operator","value","valuePath","valueQuery","start","end"];
isc.A._applyAIFilterResponseCallbackArgNames="applyResponse,applyRequest";
isc.A._$asyncApplyAIFilter="asyncApplyAIFilter";
isc.A.applyAIFilterPrompts=[
        "The objects in the source-array below represent data-records from a DataSource. Using "+
        "the properties on each data-record, the summary of the DataSource, and your own knowledge, "+
        "determine which data-records match the user-supplied filter-query:",
        "${userMessages}",
        "The DataSource has the following summary:\n"+
        "${dsSummary}\n\n"+
        "For example, if the query was 'amount is larger than 100', you should look for a field with a name "+
        "most related to 'amount' and compare its value to 100.\n\n"+
        "Your response should be a JSON object with a single property called 'result'.  This property should be set to "+
        "an array of integers, where each integer is the index of a matching record in the source-array below.  "+
        "For example, if the first data-record in the array below matches the user's filter-query, your response array "+
        "must include its source-array index (0) as the first entry.  Similarly, the source-array indices of any "+
        "other matching data-records must also be in your response array.\n\n"+
        "If a data-record does not match the filter-query, do not include its index in your response array.\n\n"+
        "If no data-records match, the 'result' property in your response object should be set to an empty array."
    ];
isc.A._$asyncBuildHilites="asyncBuildHilites";
isc.A.buildHilitesPrompts=[
        "This is a request for one or more hilites to apply to a DataBoundComponent "+
        "(such as a ListGrid) in a web application built with the Isomorphic SmartClient JavaScript "+
        "Framework.  For reference, consider the current date and time to be: ${referenceTime}.  A "+
        "hilite applies specific styling (such as a text color, background color, "+
        "and/or font-weight) to one or more fields of records that match a filter-query.  The user's "+
        "description of the styling to apply, the fields that should have this styling, and/or the "+
        "filter-query is:\n"+
        "<description-of-hilites>",
        "${userMessages}",
        "</description-of-hilites>\n"+
        "\n"+
        "The DataBoundComponent's DataSource has the following summary:\n"+
        "${dsSummary}\n\n"+
        "Your response should be a JSON object with a single key \"hiliteSpecs\": an array of the HiliteSpec objects. "+
        "Each HiliteSpec object has the following format:\n"+
        "{\"hiliteDescription\":The user's description for this particular Hilite, as a string.  This should be written from the same perspective/point-of-view as description-of-hilites, as if the user had written this themself,\n"+
        "\"filterDescription\":Just the description of the filter-query, as a string.  This should be written from the same perspective/point-of-view as description-of-hilites, as if the user had written this themself,\n"+
        "\"backgroundColor\":If the user requested a background color, a CSS color or color-name of the requested background color,\n"+
        "\"textColor\":If the user requested a text color, a CSS color or color-name of the requested text color,\n"+
        "\"cssText\":The CSS source code for any other styling requested by the user, if any,\n"+
        "\"fieldName\":If the user requested that the styling is applied to certain fields, an array of the field names.  This property should be omitted if the user did not specify any specific fields to have hilite styling,\n"+
        "\"replacementValue\":If the user requested that certain fields' values be replaced, the replacement value\n"+
        "}\n\n"+
        "Here are examples of CSS properties to use within \"cssText\":\n"+
        "font-weight: bold\n"+
        "font-style: italic\n"+
        "text-decoration-line: one of the following keywords: none, underline, overline, strike-through\n"+
        "text-decoration-color: a CSS color or color-name for the text decoration line\n"+
        "\n"+
        "Valid color-names are: "+
        "white, lightgray, gray, darkgray, black, "+
        "lightred, red, darkred, "+
        "lightpink, pink, darkpink, "+
        "lightpurple, purple, darkpurple, "+
        "lightorange, orange, darkorange, "+
        "lightbrown, brown, darkbrown, "+
        "lightyellow, yellow, darkyellow, "+
        "lightgreen, green, darkgreen, "+
        "lightblue, blue, darkblue, "+
        "turquoise, teal, gold, bronze, beige\n"+
        "\n"+
        "Note: If the user-request did not explicitly specify the hilite styling, assume \"make the text color red\".\n\n"+
        "For example, if the user request was \"Show a light red background on the userName for records where the payment is overdue\", a valid response might be:\n"+
        "{\"hiliteSpecs\": [{\"fieldName\":\"userName\",\n"+
        "\"backgroundColor\":\"lightred\",\n"+
        "\"filterDescription\":\"payment is overdue\",\n"+
        "\"hiliteDescription\":\"Show a light red background on the userName for records where the payment is overdue\""+
        "}]\n"+
        "}\n\n"+
        "Or, if the user request was \"Hilite every row where assetImprovement is less than 5\", a valid response might be:\n"+
        "{\"hiliteSpecs\": [{\"textColor\":\"red\",\n"+
        "\"filterDescription\":\"assetImprovement is less than 5\",\n"+
        "\"hiliteDescription\":\"Hilite every row where assetImprovement is less than 5\""+
        "}]\n"+
        "}\n\n"+
        "Or, if the user request was \"highlight population with light green background and red text where population is greater than 3000000 and highlight country with red text where continent is Africa\", a valid response might be:\n"+
        "{\"hiliteSpecs\": [{\"fieldName\":\"population\",\n"+
        "\"backgroundColor\":\"lightgreen\",\n"+
        "\"textColor\":\"red\",\n"+
        "\"filterDescription\":\"population is greater than 3000000\",\n"+
        "\"hiliteDescription\":\"highlight population with light green background and red text where population is greater than 3000000\"\n"+
        "}, {"+
        "\"fieldName\":\"country\",\n"+
        "\"textColor\":\"red\",\n"+
        "\"filterDescription\":\"continent is Africa\",\n"+
        "\"hiliteDescription\":\"highlight country with red text where continent is Africa\"\n"+
        "}]\n"+
        "}\n\n",
        "If the request is to clear/reset remove all hilites, return an object with an empty \"hiliteSpecs\" array."
    ];
isc.A._cssColorForColorName={
        "white":"#fff",
        "lightgray":"#ddd",
        "gray":"#aaa",
        "darkgray":"#555",
        "black":"#000",
        "lightred":"#f88",
        "red":"#e00",
        "darkred":"#800",
        "lightpink":"#f9c",
        "pink":"#f69",
        "darkpink":"#f06",
        "lightpurple":"#ccf",
        "purple":"#96f",
        "darkpurple":"#60c",
        "lightorange":"#fc9",
        "orange":"#f71",
        "darkorange":"#f42",
        "lightbrown":"#eb8",
        "brown":"#840",
        "darkbrown":"#320",
        "lightyellow":"#ffa",
        "yellow":"#ff5",
        "darkyellow":"#970",
        "lightgreen":"#cfc",
        "green":"#0f0",
        "darkgreen":"#060",
        "lightblue":"#cff",
        "blue":"#06f",
        "darkblue":"#00c",
        "turquoise":"#3cc",
        "teal":"#088",
        "gold":"#fd0",
        "bronze":"#775",
        "beige":"#db8"
    };
isc.A._cssColorNames=null;
isc.A._buildUIViaAIValidationResultCallbackArgNames="workingResponse,validationContext";
isc.A._buildUIViaAIValidatorArgNames="buildContext,validationContext,callback";
isc.A.uiCodeSuffixPrompts="Your response does not need to contain any explanatory text in addition to the JavaScript to execute. "+
        "Please use a single fenced code block to delineate the JavaScript code. This "+
        "should be a line of three backtick (`) characters followed by the language specifier (javascript) before the "+
        "code block, and three backtick (`) characters after the code block. For example:\n"+
        "```javascript\n"+
        "// JavaScript code to execute here\n"+
        "```";
isc.A.uiCodeValidationPrompts=[
        "This is a request for a fix to a block of JavaScript code to be executed in an Isomorphic SmartClient web application.\n"+
        "The following JavaScript code is intended to generate one or more more UI components to achieve the following goal:\n",
        "${userMessages}",
        "The code is failing validation because some specified property or properties are not valid. "+
        "The code block is as follows\n"+
        "```javascript\n${jsCode}\n```\n"+
        "The validation errors are reported as follows.\n"+
        "```JSON\n${errors}\n```\n"+
        "For each error the \"nodePath\" attribute uses an xpath-like syntax to describe which component and which field has "+
        "a problem. For example a nodePath like\n"+
        "\"root[0||className=ListGrid||ID=grid0]/initialCriteria\"\n"+
        "would indicate a problem with the \"initialCriteria\" attribute specified on the first top-level ListGrid component "+
        "defined in the code, with ID specified as \"grid0\".\n"+
        "Please return a fixed version of the code where any invalid attributes have been replaced with an appropriate "+
        "property based on the Isomorphic SmartClient web framework's documentation."
    ];
isc.A.defaultBuildUIViaAIValidationTypes=["default"];
isc.A.dataBoundUITypeInfos={
        list:{
            description:"A ListGrid displaying some data from a dataSource. "+
                "This is appropriate for any list of multiple records, including lists "+
                "that are aggregated or grouped by values, sorted, filtered, etc.",
            componentType:"ListGrid",
            codePrompt:
                "Note that for ListGrids, a user may request a simple "+
                "\"grouped\" view. This is different from a true aggregated view and may be achieved via the "+
                "\"groupByField\" property of the grid.\n"+
                "Example listGrids:\n"+
                "Given a dataSource with ID:\"myDS\", and fields "+
                " \"code\" (primary key), \"location\", \"title\", \"description\" and \"price\","+
                "the following code would satisfy a user request to view a list of records where price is less than 100, "+
                "sorted by price in ascending order:\n"+
                "```javascript\n"+
                "isc.ListGrid.create({\n"+
                "        autoFetchData:true,\n"+
                "        dataSource: \"myDS\",\n"+
                "        fields:[\n"+
                "            {name:\"location\"},\n"+
                "            {name:\"title\"},\n"+
                "            {name:\"description\"},\n"+
                "            {name:\"price\"}\n"+
                "        ],\n"+
                "        initialCriteria:{\n"+
                "            fieldName:\"price\",\n"+
                "            operator:\"lessThan\",\n"+
                "            value:100\n"+
                "        },\n"+
                "        initialSort:[\n"+
                "            {\n"+
                "                property:\"price\",\n"+
                "                direction:\"ascending\"\n"+
                "            }\n"+
                "        ]\n"+
                "    });\n"+
                "```\n"+
                "Or, for the same dataSource, the following code would satisfy a user request "+
                "to show the average price for each location. "+
                "Note that because we're inferring the 'price' field to be a currency field, we're applying "+
                "decimalPrecision:2. If the user had requested a specific precision we would respect that instead. :\n"+
                "```javascript\n"+
                "isc.ListGrid.create({\n"+
                "        autoFetchData:true,\n"+
                "        dataSource: \"myDS\",\n"+
                "        fields:[\n"+
                "            {name:\"location\"},\n"+
                "            {name:\"price\", decimalPrecision:2}\n"+
                "        ],\n"+
                "        fetchRequestProperties:{\n"+
                "            groupBy:[\"location\"],\n"+
                "            summaryFunctions:{\n"+
                "                price:\"avg\"\n"+
                "            }\n"+
                "        }\n"+
                "    });\n"+
                "```\n"+
                "\n"+
                "Setting the \"showFilterEditor\" property to true will show an editor that the "+
                "user can use to customize the filter on the data of the ListGrid. If the user requested a "+
                "filterable list, or indicated wanting to change or customize which records are displayed, "+
                "set \"showFilterEditor\" to true."+
                "\n"+"Set the \"width\" property to \"100%\", \"autoFitData\" to \"vertical\", and \"autoFitMaxHeight\" to 400."
        },
        chart:{
            description:"A FacetChart displaying some data from a dataSource. Note that as "+
                "with lists, a chart may display an aggregated or filtered set of values",
            componentType:"FacetChart",
            codePrompt:
                "Note that the FacetChart you generate should have its \"valueProperty\" set to "+
                "the numeric-typed field containing data values for records, "+
                "and facetFields should be used to define facets for the chart.\n"+
                "The \"showDataValuesMode\" property should typically be set to \"auto\", unless this conflicts with the user prompt in some way.\n"+
                "If a clear, simple title for the chart can be derived from the prompt, include the \"title\" attribute.\n"+
                "Examples:\n"+
                "Given a dataSource with ID:\"myDS\", and fields "+
                " \"code\" (primary key), \"location\", \"title\", \"description\" and \"price\","+
                "the following code would satisfy a user request to build a chart showing "+
                "items that cost more than $500 in each location:\n"+
                "```javascript\n"+
                "isc.FacetChart.create({\n"+
                "    dataSource: \"myDS\",\n"+
                "    facets: [\n"+
                "        {\n"+
                "            id: \"location\",\n"+
                "            title: \"Location\"\n"+
                "        },\n"+
                "        {\n"+
                "            id: \"title\",\n"+
                "            title: \"Title\"\n"+
                "        }\n"+
                "    ],\n"+
                "    stacked:false,\n"+
                "    // valueProperty set to numeric field price\n"+
                "    valueProperty: \"price\",\n"+
                "    showDataValuesMode:\"auto\",\n"+
                "    chartType: \"Column\",\n"+
                "    autoFetchData: true,\n"+
                "    initialCriteria:{\n"+
                "        fieldName:\"unitCost\",\n"+
                "        operator:\"greaterThan\",\n"+
                "        value:500\n"+
                "    }\n"+
                "});\n"+
                "```\n"+
                "Or, for the same dataSource, the following code would satisfy a user request "+
                "to chart the total number of items for each location:\n"+
                "```javascript\n"+
                "isc.FacetChart.create({\n"+
                "    title: \"Total Number of Items by Location\",\n"+
                "    dataSource: \"myDS\",\n"+
                "    facets: [\n"+
                "        {\n"+
                "            id: \"location\",\n"+
                "            title: \"Location\"\n"+
                "        }\n"+
                "    ],\n"+
                "    // The fetchRequestProperties block below uses groupBy and summaryFunction\n"+
                "    // to generate a count of \"code\" values per location.\n"+
                "    // Since \"code\" is the primary key for this dataSource it is unique per item,\n"+
                "    // giving us back item count per location.\n"+
                "    valueProperty: \"code\",\n"+
                "    showDataValuesMode:\"auto\",\n"+
                "    autoFetchData: true,\n"+
                "    fetchRequestProperties:{ \n"+
                "        groupBy:[\"location\"],\n"+
                "        summaryFunctions:{\n"+
                "            code:\"count\"\n"+
                "        }\n"+
                "    }\n"+
                "});\n"+
                "```\n"+
                "\n"+
                "Valid values for the \"chartType\" property are:\n"+
                "\"Column\" - (the default if not specified) a bar chart with vertical bars\n"+
                "\"Bar\" - a bar chart with horizontal bars\n"+
                "\"Line\" - a chart where values are displayed side-by-side, connected by lines\n"+
                "\"Radar\" - a chart where values are displayed around a circle, connected by lines\n"+
                "\"Pie\" - a pie chart\n"+
                "\"Doughnut\" - a pie chart with a center hole\n"+
                "\n"+"Set the \"width\" property to \"100%\" and the \"height\" to 400."
        },
        value:{
            description:"A Label displaying a single value (scalar) derived from the data in a dataSource",
            componentType:"ScalarViewer",
            codePrompt:
                "ScalarViewer is a component based on a SmartClient DynamicForm which uses the attribute \"fieldName\" "+
                "to extract a single field value from a record and the attribute \"title\" as a title for the single field value.\n"+
                "Other standard DynamicForm properties such as \"dataSource\", \"autoFetchData\" and \"initialCriteria\" may be used "+
                "to populate the item with a single record.\n"+
                "Examples:\n"+
                "Given a dataSource with ID:\"myDS\", and fields "+
                " \"code\" (primary key), \"location\", \"title\", \"description\" and \"price\","+
                "the following code would display the \"description\" for the some record where "+
                "\"code\" has the value \"abc123\":\n"+
                "```javascript\n"+
                "isc.ScalarViewer.create({\n"+
                "    autoFetchData:true,\n"+
                "    dataSource: \"myDS\",\n"+
                "    title:\"Description for item abc123\",\n"+
                "    fieldName:\"description\",\n"+
                "    initialCriteria:{\n"+
                "        fieldName:\"code\",\n"+
                "        operator:\"equals\",\n"+
                "        value:\"abc123\"\n"+
                "    }\n"+
                "});\n"+
                "```\n"+
                "Or, for the same dataSource, the following code would satisfy a user request "+
                "to show the average price for items in San Francisco:\n"+
                "```javascript\n"+
                "isc.ScalarViewer.create({\n"+
                "    autoFetchData:true,\n"+
                "    dataSource: \"myDS\",\n"+
                "    title:\"Average price of items in San Francisco\",\n"+
                "    fieldName:\"price\",\n"+
                "    initialCriteria:{\n"+
                "        fieldName:\"location\",\n"+
                "        operator:\"equals\",\n"+
                "        value:\"San Francisco\"\n"+
                "    },\n"+
                "    fetchRequestProperties:{ \n"+
                "        groupBy:[\"location\"], \n"+
                "        summaryFunctions:{\n"+
                "            price:\"avg\"\n"+
                "        }\n"+
                "    }\n"+
                "});\n"+
                "```\n\n"+
                "To control which record is retrieved, it may be necessary to sort by a field, "+
                "by adding a \"sortBy\" property to the ScalarViewer's \"fetchRequestProperties\" "+
                "object. The \"sortBy\" property is the name of the field that the data are sorted "+
                "by, prefixed with a minus sign ('-') if the data should be sorted by the field "+
                "in descending order.\n"+
                "For example, using the same \"myDS\" dataSource, the following code would "+
                "satisfy the request for the \"location with the highest price\":"+
                "```javascript\n"+
                "isc.ScalarViewer.create({\n"+
                "    autoFetchData:true,\n"+
                "    dataSource: \"myDS\",\n"+
                "    title:\"Location with the highest price\",\n"+
                "    fieldName:\"location\",\n"+
                "    fetchRequestProperties:{ \n"+
                "        sortBy: \"-price\"\n"+
                "    }\n"+
                "});\n"+
                "```\n"+
                "In this example, the first row, when sorted by the price in descending order, "+
                "is for the location with the highest price in the dataSource."
        }
    };
isc.A.dataBoundUIInitiatorPrefixPrompts=[
        "A user is interacting with an Isomorphic SmartClient web application. "+
        "They have requested a new user-interface component to display data from a dataSource "+
        "in some way. The user request is as follows:",
        "${userMessages}"
    ];
isc.A.dataBoundUIInitiatorPrompt_UIOptions="The user may request one of the following types of user interface components:\n"+
            "${uiTypeDescriptions}\n";
isc.A.dataBoundUIInitiatorPrompt_DSOptions="The following dataSources are available for this component:\n"+
            "${dsDescriptions}\n";
isc.A.dataBoundUIInitiator_UIResponseFormat="Please respond with a JSON object containing the following attribute(s):\n"+
            "\"component\": The component type name that best matches the user's request, or \"invalid\" if "+
            "you are unable to determine what kind of data view the user is asking for. This should be one of the following values:\n"+
            "${uiTypes}\n";
isc.A.dataBoundUIInitiator_DSResponseFormat="\"dataSource\": The ID of the dataSource that best matches the user's request, or \"invalid\" if "+
            "you are unable to determine which dataSource the user is attempting to view data from. This should be one of the following values:\n"+
            "${dsIDs}\n";
isc.A.dataBoundUIInitiatorSuffix="Your response should contain the JSON block and no other text.\n"+
            "An example of a valid response might be:\n${responseExample}";
isc.A.generalDataBoundUICodeNotes="Notes:\n"+
        "- The \"dataSource\" attribute of the component should be set to the ID of the dataSource.\n"+
        "- In order to fetch data to display, \"autoFetchData\" should be set to true.\n"+
        "- If criteria should be applied to the fetch, the \"initialCriteria\" attribute should be "+
            "specified as a SmartClient AdvancedCriteria object.\n"+
        "- If some form of data aggregation or summarization is required---for example a list of each unique value "+
            "for some field along with a count of records, or sum of some other numeric field value within that "+
            "group---this can be achieved by customizing the DSRequest that is used to fetch data for the component. "+
            "The \"fetchRequestProperties\" attribute for the component can be used to set appropriate "+
            "\"groupBy\" and \"summaryFunctions\" attributes for the data fetch.\n";
isc.A.dataBoundUICodePrefixPrompts=[
        "A user is interacting with an Isomorphic SmartClient web application. "+
        "They have requested a new ${componentType} component to display data from a dataSource "+
        "in some way. The user request is as follows:",
        "${userMessages}",
        "The DataSource has the following summary:\n"+
        "${dsSummary}\n"+
        "Please generate JavaScript code to create a SmartClient ${componentType} bound to this "+
        "dataSource that meets the user's request.\n"+
        "${this.generalDataBoundUICodeNotes}"+
        "${componentCodePrompt}.\n\n"
    ];
isc.A._$asyncBuildDataBoundUI="asyncBuildDataBoundUI";
isc.A.fencedCodeRegex=new RegExp("^```(?:javascript)?\\s*\\n((.|\n)*)\\n```","im");
isc.A.autoLoadDataSource=true;
isc.A.dataSourceName="serverAIDataSource";
isc.A.dataSources={};
isc.A._loadingDS={};
isc.A._loadDSFailed={};
isc.A.spoofedResponseDelay=2000;
isc.A.responseSpoofingMode="hybrid";
isc.A.captureTransactions=false;
isc.A.capturedTransactions=[];
isc.A._captureOfflineStorageKey="ai_capturedTransactions";
isc.A._spoofedResponseRegistry=[];
isc.A.initiatorPromptTemplate="This is an Isomorphic SmartClient AI Assistant Request (version 1.0).\n"+
            "*** Overview ***\n"+
            "For an Isomorphic SmartClient AI Assistant Request, you are to act as an intelligent agent assisting a user in an Isomorphic SmartClient application.\n"+
            "Details of the application and the user request text will be provided at the end after this overview.\n"+
            "You should respond to this request with a response in the following structured format. "+
            "Note that text in square brackets is descriptive. Any other text should be included verbatim:\n\n"+
            "ResponseType: [a response type, as explained below]\n"+
            "Message: [a message to be shown to the user, either explaining what you have done or asking for clarifications]\n"+
            "MessageType: [a message type, as explained below]\n"+
            "======\n"+
            "[JavaScript code to perform a requested action when executed in the context of the SmartClient application. Note that the JavaScript should contained between a delineator of 6 equal signs, as shown here. Certain response types (described below) do not require any JavaScript code - in these cases the response may omit this entire block including both sets of equal signs.]\n"+
            "======\n\n"+
            "** Response Types **\n"+
            "There are six possible response types, described in the following section. \n"+
            "Note that these are not listed in order of preference - you should choose the appropriate response type based on the prompt you received.\n"+
            "Immediately after the numeral is the text value you should use for the \"ResponseType\" when responding. Do not include the numeral.\n\n"+
            "1. Execute JavaScript\n"+
            "Produce JavaScript code to do what the user wants, along with an explanation of what you have done, to be shown to the user.\n"+
            "This ResponseType is appropriate only to perform the same set of actions that a normal user can perform via the running SmartClient application's user interface, and any changes applied to the UI should be reversable by the user, using the UI.\n"+
            "This is typically limited to interacting with existing components on the page.\n"+
            "The JavaScript you generate should be valid JavaScript and may make use of the Isomorphic SmartClient JavaScript framework APIs.\n"+
            "* Important Note *\n"+
            "Details of the currently visible UI of the application are below in the section titled \"SmartClient application and environment information\""+
            "Components listed in this summary may be accessed may be accessed directly by their \"ID\" property, or by passing this property into \"isc.Canvas.getById();\".\n"+
            "Other documented SmartClient APIs may also be used.\n"+
            "If your code either causes a JavaScript error or times out, this will be reported to you.\n"+
            "The Message should be some text to display to the user, explaining what was done.\n"+
            "The MessageType may be set to either \"Notify\" or \"Modal Message\". MessageType \"Notify\" will show the message as a notification that auto-hides. MessageType \"Modal Message\" will show the message in a modal dialog that the user must explicitly dismiss before proceeding.\n"+
            "Some examples of requested actions that would require an \"Execute JavaScript\" type response include:\n"+
            "- Applying sorting to an existing listGrid via \"listGrid.sort();\" or \"listGrid.setSort();\"\n"+
            "- Changing the filter criteria applied to an existing listGrid via \"listGrid.setFilterEditorCriteria();\" or \"listGridID.filterData();\"\n"+
            "- Switching to a different tab in a TabSet via \"tabSet.selectTab();\"\n"+
            "If the user prompt requires a new UI be created, do not use the \"Execute JavaScript\" response type - use \"Ad Hoc UI\" instead.\n\n"+
            "2. Ad Hoc UI\n"+
            "Your generated JavaScript code creates an \"ad hoc\" UI to do whatever the user needs to do.  \n"+
            "In this case, the JavaScript code you specify should create SmartClient user interface components. The code will be captured in the same way that SmartClient captures \"screens\" (as in the RPCManager.loadScreen() API) and SmartClient will automatically display the result in a Window component. \n"+
            "Your code does not need to include this Window component - just create the appropriate UI and it will be displayed to the user as appropriate.\n"+
            "When the Window is closed, the ad-hoc UI created by your code will be destroyed (as in Canvas.destroy()).\n"+
            "As with \"Execute JavaScript\":\n"+
            "The code you generate should be valid JavaScript and may make use of the Isomorphic SmartClient JavaScript framework APIs.\n"+
            "The Message should be some text to display to the user, explaining what was done.\n"+
            "The MessageType may be set to either \"Notify\" or \"Modal Message\".\n"+
            "The \"Ad Hoc UI\" response type is appropriate for situations where the underlying DataSources provide the ability to achieve the end user's goals, but the UI does not provide an easy way to do what the user wants.  \n"+
            "Some examples of requested actions that would require an \"Ad Hoc UI\" type response include:\n"+
            "- Creating an aggregated view of dataSource data when none is available in the default UI. This could be achieved by creating a new ListGrid bound to the appropriate dataSource, and setting \"groupBy\" and  \"summaryFunctions\" on the \"dsRequest\" object passed to listGrid.filterData().\n"+
            "- Displaying data from a dataSource in a chart by creating a new FacetChart bound to the dataSource, using the \"valuePrompt\" and \"facetFields\" to specify which attributes to chart, and calling fetchData() or filterData() to populate it.\n"+
            "In your other kinds of responses, if it's possible to create an ad-hoc UI to do what the user needs, be sure to mention that to the user.  And, if the user specifically requests an ad-hoc UI, take that as a suggestion to use this approach (unless another approach, such as \"Inspect\", is appropriate first).\n\n"+
            "3. Clarify\n"+
            "Ask the user for clarifying information.\n"+
            "For this type of response, the \"Message\" you specify can be used to ask the user a question. "+
            "You should not show this message to the user - the application will show it in a modal dialog where the user may type in a response. The user's response will be sent back to you, allowing you to take further action.\n"+
            "Any \"MessageType\" you specify will be ignored for \"Clarify\" type responses.\n"+
            "\"Clarify\" type responses do not need to include any JavaScript, but if you do include JavaScript it will be executed in the scope of the application. This allows you to programatically gather information about the current application by using the \"isc.AI.commandComplete()\" method.\n"+
            "If you want to make use of this capability, consider the following points when generating your JavaScript code.\n"+
            "- Your code should always include a call to the method \"isc.AI.commandComplete();\". This method takes a single argument, which can be any JavaScript object or primitive, and we will send this back to you (in addition to the user's response to your question). For example you could determine the current set of (visible) field names in a listGrid by calling \"isc.AI.commandComplete(listGrid.getFieldNames())\".\n"+
            "- Your code can make use of asynchronous APIs; when your inspection code is complete, it should call the API isc.AI.commandComplete() method, passing any object that can be serialized to JSON. For an asynchronous action, this would typically be done in a callback function.\n"+
            "For example - if you wanted to find the total number of records in a DataSource, you could invoke\n"+
            "  dataSource.fetchData(\n"+
            "    // criteria - unrestricted fetch\n"+
            "    null,\n"+
            "    // callback function\n"+
            "    function (dsResponse, data, dsRequest) {\n"+
            "        isc.AI.commandComplete(dsResponse.totalRows);\n"+
            "    },\n"+
            "    // dsRequest configuration - use startRow and endRow to avoid returning actual records\n"+
            "    { startRow:0, endRow:0 }\n"+
            "  );\n"+
            "If you want to return information gathered from multiple APIs, you can combine all necessary information into a single JSON object which your code passes to isc.AI.commandComplete().\n\n"+
            "4. Inspect\n"+
            "Generate JavaScript to gather information\n"+
            "Similar to the \"Clarify\" ResponseType explained above, you can generate JavaScript to gather information about the application environment, and have it sent back to you by calling \"isc.AI.commandComplete()\".\n"+
            "Unlike \"Clarify\" responses, \"Inspect\" responses do not prompt the user for information.\n"+
            "If you do include a \"Message\", it will be displayed to the user as either a \"Notification\" or \"Modal Message\" depending on the \"MessageType\" you specified.\n"+
            "If necessary you may generate repeated \"Inspect\" type responses to gather multiple pieces of information about the application before finally deciding upon an interactive response to the user, via one of the other ResponseTypes.\n\n"+
            "5. Send A Message\n"+
            "The \"Send A Message\" response type will cause the specified \"Message\" to be displayed to the user and take no other action.\n"+
            "This response type should not include any JavaScript to execute.\n"+
            "This is useful for cases where you simply want to display a message to the user.\n\n"+
            "6. Explain Why Not\n"+
            "Explain to the user that what they want cannot be done, and why.  \n"+
            "If possible, provide suggestions for how they might achieve their goals instead, including by contacting other people with administrative access to data.\n"+
            "The explanation you provide as the \"Message\" for this response type will appear in a modal SmartClient Window, with a text field below offering the user the ability to provide a revised or clarified command, or the ability to cancel the overall AI interaction.\n"+
            "This response type should not include any JavaScript to execute.\n"+
            "You should not show this message to the user - the application will show it, according to the MessageType you provide.\n\n"+
            "** Example **\n"+
            "An example of a validly formatted response is below.\n"+
            "This response might be appropriate for the following user prompt:\n"+
            "  \"Show the filterEditor on my listGrid and filter it to only show items that are less than $100 and customer's name contains 'Schwabb'\"\n"+
            "In this case we're assuming the application has a listGrid with the ID \"myListGrid\" with fields \"unitCost\" and \"customer\".\n"+
            "Example response:\n\n"+
            "ResponseType: Execute JavaScript\n"+
            "Message: The filter editor for your listGrid has been displayed and the listGrid has been filtered to show only items with unitCost less than $100, where the customer name contains the string \"Schwabb\".\n"+
            "MessageType: Notify\n"+
            "======\n"+
            "myListGrid.setProperties({showFilterEditor:true});\n"+
            "myListGrid.filterData({\n"+
            "    _constructor:\"AdvancedCriteria\",\n"+
            "    operator:\"and\",\n"+
            "    criteria:[\n"+
            "        {fieldName:\"unitCost\", operator:\"lessThan\", value:100},\n"+
            "        {fieldName:\"customer\", operator:\"iContains\", value:\"Schwabb\"},\n"+
            "    ]\n"+
            "});\n"+
            "======\n\n"+
            "Details about the running application, and the user request are below.\n"+
            "*** End of overview ***\n";
isc.A.suggestRecordSummaryTitlePrompts=[
        "This is a request for a suggested title for a new field of a DataSource. This new field "+
        "will contain the following information for each record:",
        "${ssMessages}",
        "The DataSource has the following summary: ${dsSummary}"
    ];
isc.A.suggestRecordSummaryTitlePrompts_visibleFields="The suggested title should be short (at most 40 characters), succinctly describe the "+
        "information that will be contained in the new field, and be similar in style to "+
        "the titles in the following map from existing field names to their titles:\n";
isc.A.suggestRecordSummaryTitlePrompts_noVisibleFields="The suggested title should be short (at most 40 characters) and succinctly describe the "+
        "information that will be contained in the new field. Each word of the suggested title should "+
        "be capitalized.";
isc.A.suggestRecordSummaryTitlePrompts_final="Your response should be a single JSON object with one "+
        "key \"suggestedTitle\" and value being a string containing the suggested title for the "+
        "new field.";
isc.A._$asyncBuildAIFieldRequest="asyncBuildAIFieldRequest";
isc.A.buildAIFieldRequestTemplatedString=isc.trimDoc`
        In the context of an Isomorphic SmartClient application, this is a request for
        information about the task of generating supplemental data for each record in the
        '\${dsName}' DataSource.

        \${dsSummary}

        The supplemental data that will be generated for each record is:
        <supplemental-data-description>\${aiFieldPrompt}</supplemental-data-description>

        Note: In the supplemental-data-description, disregard directions to "sort by", "order by",
        or similar that do not describe the supplemental data to generate.

        You must decide what class of supplemental data ("valueClass") is described by the
        supplemental-data-description. The options are:
        * "general": Any kind of data. Usually this is textual, but not necessarily always so.
          An example would be a "2-4 sentence summary".
        * "categorical": A fixed list of categories or nominal values. An example would be the
          type of customer issue (e.g. "Technical Issue", "Billing Issue", "General Inquiry").
        * "ordinal": An extension of "categorical" where the categories are also strictly
          ordered from lowest/least to highest/most. An example would be customer satisfaction
          (e.g. "Dissatisfied", "Neutral", "Satisfied", "Very Satisfied").
        * "interval": Strictly numerical data. An example would be temperature in degrees Celsius.
        * "ratio": An extension of "interval" where 0 means the absence of something, and ratios
          between values are meaningful. An example would be weight in pounds, because 0 means
          no weight and 200 pounds is twice as heavy as 100 pounds.

        Your response must be a JSON object with the following properties:
        * "fieldSummaries" (object): A map from the name of each field to a string containing
          a shortened summary of all of the following details that you infer about the
          field\${haveSampleData ? " using the given sample data and" : ""} from the field's title,
          description, and other available information:
            - Whether the field's values are possibly relevant or not at all relevant to the
              task of generating the supplemental data for each record according to the
              supplemental-data-description.
            - For numeric fields, the units of the field's values if applicable,
              or whether the units are unknown.
            - The pattern or format of the field's values.
            - Whether the field's values may be \`null\`, and if so, what the meaning or significance
              of \`null\` is.
            - Any assumptions that you are making about the field's values.
            - Any uncertainties that you have about the field's values.
        * "relevantFieldNames": An array of the names of the fields of the '\${dsName}'
          DataSource that are possibly relevant to generating the supplemental data for each
          record according to the supplemental-data-description.
        * "irrelevantFieldNames": An array of the names of the fields of the '\${dsName}'
          DataSource that appear to be irrelevant to generating the supplemental data for each
          record according to the supplemental-data-description.
        * "valueClass": The "valueClass" for the requested supplemental data, either
          "general", "categorical", "ordinal", "interval", or "ratio".
        * "dataDependentReason" (only if the "valueClass" is "categorical" or "ordinal", it
          is absolutely not possible to make any reasonable choices for the categories without
          examining all of the records in the DataSource, and the data of the records reasonably
          appears to contain the categories): A string containing an explanation of why the list
          of categories absolutely depends on the records in the DataSource.
        * "categories" (only if the "valueClass" is "categorical" or "ordinal" and reasonable
          choices can be made about the categories [i.e. not data-dependent]): An array of the
          category label strings. If the "valueClass" is "ordinal", this array must list the
          categories from lowest/least value to highest/most value. This is not the
          same as your choice for "displayDirection".
        * "categoryHints" (only if the "valueClass" is "categorical" or "ordinal"): An object
          that maps each category label string to a hint for when to use that category rather
          than the other categories.
        * "minValue" (only if the "valueClass" is "interval" or "ratio" and the supplemental-data-description
          specifies or reasonably implies a minimum value): The minimum value as a number.
        * "maxValue" (only if the "valueClass" is "interval" or "ratio" and the supplemental-data-description
          specifies or reasonably implies a maximum value): The maximum value as a number.
        * "displayDirection" (only if the "valueClass" is "ordinal", "interval", or "ratio"):
          If the highest/most values are most emotionally-positive, or most optimistic, or
          likely to be most of interest, specify "most-to-least" (so that the most positive or
          most of interest values appear first).
          Otherwise, specify "least-to-most".
        * "displayDirectionReasoning" (only if the "valueClass" is "ordinal", "interval", or "ratio"):
          A string containing a shortened summary of your reasoning behind your choice of "displayDirection".
    `;
isc.A.invalidSummaryValue="-";
isc.A._summarizeRecordsPartialResultCallbackArgNames="partialResult,context";
isc.A.summarizeRecordsPrompts_general=[
        "This is a request to supplement the data in records from a DataSource, using "+
        "relevant general knowledge and your own reasonable inferences from the data. "+
        "The supplemental information requested for each record is:",
        "${ssMessages}",
        "The records specified below are from the DataSource with the following description: ${dsSummary}\n\n"+
        "Your response should be a single JSON object with one key \"result\" and value being "+
        "an array of just the strings of supplemental information for each corresponding record. "+
        "Here are the records:"
    ]
;
isc.B.push(isc.A._asyncBuildCriterionWithSummarizedUserMessages=function isc_c_AI__asyncBuildCriterionWithSummarizedUserMessages(summarizedUserMessages,buildContext){
        if(buildContext._ownCC.canceled){
            throw buildContext._ownCC.asCanceledResult();
        }
        var aiMessagesBuilder=isc.InternalAIMessagesBuilder.create({
            userMessages:summarizedUserMessages,
            target:this,
            evalVars:{
                purpose:buildContext.buildRequest.purpose,
                referenceTime:buildContext.referenceTime,
                dsSummary:"${dsSummary}",
                dataSource:buildContext.dataSource
            }
        });
        if(buildContext.mode=="aiAssist"){
            aiMessagesBuilder.renderTemplate("buildCriterionAIAssistPrompt");
        }else if(buildContext.mode=="AIDE"){
            aiMessagesBuilder.appendPrompts(this.applyAIFilterPrompts);
        }else{
            aiMessagesBuilder.renderTemplate("buildCriterionHybridPrompt");
        }
        var partiallyProcessedAIRequest={
            messages:aiMessagesBuilder.aiMessages,
            responseType:"object"
        };
        var context=this._getContextForRequest(partiallyProcessedAIRequest);
        if(context.errorMessage)return isc.rejectWithError(context.errorMessage);
        var fields=buildContext.dataSource.getAllFields();
        var shouldUseFieldPaging=context.aiEngine.shouldUseAIFieldPaging(partiallyProcessedAIRequest,fields,buildContext._aiConfig);
        if(!shouldUseFieldPaging){
            return this._asyncBuildCriterionWithFinalFields(fields,partiallyProcessedAIRequest,buildContext);
        }
        ++buildContext._estimatedNumTotalSteps;
        this._fireAIProgressCallback(buildContext,[{category:"detail",content:isc.AI.willSubsetFieldsDetailMessage}],true);
        return context.aiEngine.asyncRetrieveFieldsForPrompt(
                partiallyProcessedAIRequest.messages,
                "Filter data-records according to the user's description of the filter criteria",
                fields,
                context,
                buildContext._aiConfig)
            .then(function(finalFields){
                ++buildContext._numStepsCompleted;
                isc.AI._fireAIProgressCallback(buildContext,[{category:"success",content:isc.AI.finishedSubsettingFieldsDetailMessage}]);
                return isc.AI._asyncBuildCriterionWithFinalFields(
                        finalFields,partiallyProcessedAIRequest,buildContext);
            });
    }
);
isc.evalBoundary;isc.B.push(isc.A._asyncBuildCriterionWithFinalFields=function isc_c_AI__asyncBuildCriterionWithFinalFields(finalFields,partiallyProcessedAIRequest,buildContext){
        if(buildContext._ownCC.canceled){
            throw buildContext._ownCC.asCanceledResult();
        }
        if(finalFields==null||(finalFields.removeEmpty(),finalFields).isEmpty()){
            const purpose=buildContext.buildRequest.purpose;
            throw isc.createErrorResult("No fields were selected for use in building the "+
                (purpose||"filter")+" criterion.");
        }
        buildContext._dsFinalFields=finalFields;
        var dsSummary=this.render("summarizeDataSource",{
            dataSource:buildContext.dataSource,
            fields:finalFields
        });
        buildContext._dsSummary=dsSummary;
        if(buildContext.mode=="AIDE"){
            return Promise.resolve(this._buildAIFilter(buildContext));
        }
        var evalVars={
            dsSummary:dsSummary
        };
        var aiRequest={
            cancellationController:buildContext._ownCC,
            messages:partiallyProcessedAIRequest.messages.map(function(message){
                if(message.source=="system"&&isc.AIEngine._isTextContentType(message.type)){
                    return{
                        source:message.source,
                        content:String(message.content).evalDynamicString(this,evalVars)
                    };
                }
                return message;
            },this),
            responseType:partiallyProcessedAIRequest.responseType
        };
        if(!buildContext._ownCC.canceled&&buildContext._progressDialog)buildContext._progressDialog.show();
        return this.asyncSendRequest(aiRequest,buildContext._aiConfig)
            .then(function(aiResponse){
                ++buildContext._numStepsCompleted;
                isc.AI._fireAIProgressCallback(buildContext);
                const responseObject=aiResponse.message.content;
                if(isc.isAn.Object(responseObject)&&responseObject.result!="invalid"){
                    if(responseObject.result=="method2"){
                        return isc.AI._buildAIFilter(buildContext);
                    }
                    var criteria;
                    if(isc.isAn.Object(responseObject.result))criteria=responseObject.result
                    else criteria=responseObject;
                    if(buildContext.dataSource.isAdvancedCriteria(criteria)){
                        var maskedCriterion=isc.AI._maskCriterion(criteria);
                        return isc.AI._asyncValidateAdvancedCriteria(maskedCriterion,buildContext);
                    }
                }
                let errorMessage=isc.AI.aiNotAbleToProcessRequestErrorMessage;
                if(responseObject&&isc.isA.String(responseObject.invalidReasoning)){
                    const invalidReasoning=responseObject.invalidReasoning.trim();
                    if(invalidReasoning.length)errorMessage=invalidReasoning.asHTML();
                }
                throw isc.createErrorResult(errorMessage);
            });
    }
,isc.A._asyncValidateAdvancedCriteria=function isc_c_AI__asyncValidateAdvancedCriteria(criterion,buildContext,alreadyRequestedFix){
        var finalFieldsByName=buildContext._dsFinalFields.makeIndex("name"),
            validationErrors=[],
            validatedCriterion=this._validateCriterion(isc.DS.copyCriteria(criterion),
                                        finalFieldsByName,
                                        buildContext.dataSource,
                                        validationErrors);
        if(validatedCriterion&&validationErrors.isEmpty()){
            return Promise.resolve(validatedCriterion);
        }
        if(alreadyRequestedFix){
            return isc.rejectWithError(isc.AI.aiNotAbleToProcessRequestErrorMessage);
        }
        ++buildContext._estimatedNumTotalSteps;
        this._fireAIProgressCallback(buildContext,[{category:"error",content:"AI generated invalid criteria. Will request a fix..."}]);
        var jsonEncoder=isc.JSONEncoder.create({
            dateFormat:"logicalDateString",
            strictQuoting:true
        });
        var aiMessagesBuilder=isc.InternalAIMessagesBuilder.create({
            userMessages:buildContext._summarizedUserMessages,
            target:this,
            evalVars:{
                dsSummary:buildContext._dsSummary,
                encodedCriterion:jsonEncoder.encode(criterion),
                validationErrors:validationErrors.join("\n"),
                encodedValidatedCriterion:validatedCriterion&&jsonEncoder.encode(validatedCriterion)
            }
        });
        aiMessagesBuilder.appendPrompts(this.fixCriterionPrompts);
        var aiRequest={
            messages:aiMessagesBuilder.aiMessages,
            responseType:"object"
        };
        return this.asyncSendRequest(aiRequest,buildContext._aiConfig)
            .then(function(aiResponse){
                ++buildContext._numStepsCompleted;
                isc.AI._fireAIProgressCallback(buildContext);
                var responseObject=aiResponse.message.content;
                if(buildContext.dataSource.isAdvancedCriteria(responseObject)){
                    var maskedCriterion=isc.AI._maskCriterion(responseObject);
                    return isc.AI._asyncValidateAdvancedCriteria(maskedCriterion,buildContext,true);
                }else{
                    return isc.rejectWithError(isc.AI.aiNotAbleToProcessRequestErrorMessage);
                }
            });
    }
,isc.A._maskCriterion=function isc_c_AI__maskCriterion(criterion,allowedCriterionPropertyNames,nested){
        if(criterion.operator=="and"||
            criterion.operator=="or"||
            criterion.operator=="not")
        {
            var subcriteria=criterion.criteria;
            criterion={
                operator:criterion.operator,
                criteria:subcriteria
            };
            if(!isc.isAn.Array(subcriteria))subcriteria=criterion.criteria=[subcriteria];
            for(var i=0;i<subcriteria.length;){
                var subcriterion=subcriteria[i];
                if(subcriterion==null){
                    subcriteria.removeAt(i);
                    continue;
                }
                if(isc.isAn.Array(subcriterion)){
                    subcriteria.addListAt(subcriterion,i);
                    subcriterion=subcriteria[i];
                }
                if(isc.isAn.Object(subcriterion))subcriteria[i]=this._maskCriterion(subcriterion,allowedCriterionPropertyNames,true);
                ++i;
            }
        }else{
            criterion=isc.applyMask(criterion,allowedCriterionPropertyNames||this.allowedCriterionPropertyNames);
        }
        if(!nested)criterion._constructor="AdvancedCriteria";
        return criterion;
    }
,isc.A._validateCriterion=function isc_c_AI__validateCriterion(criterion,finalFieldsByName,dataSource,validationErrors,nested){
        if(!criterion.operator){
            validationErrors.push("A criterion was missing the 'operator'.");
            return null;
        }
        var operatorId=criterion.operator,
            operator=dataSource.getSearchOperator(operatorId);
        if(!operator||!this._allowedOperatorIds.contains(operatorId)){
            validationErrors.push("Operator '"+operatorId+"' is not allowed.");
            return null;
        }
        if(operator.valueType=="none"){
            delete criterion.value;
        }else if(operator.valueType=="criteria"){
            var subcriteria=criterion.criteria;
            if(!isc.isAn.Array(subcriteria))subcriteria=criterion.criteria=[subcriteria];
            for(var i=0;i<subcriteria.length;){
                var subcriterion=subcriteria[i];
                if(subcriterion==null){
                    subcriteria.removeAt(i);
                    continue;
                }
                if(!isc.isAn.Object(subcriterion)){
                    validationErrors.push("A subcriterion was not an object.");
                    subcriteria.removeAt(i);
                    continue;
                }
                var validatedSubcriterion=subcriteria[i]=this._validateCriterion(
                        subcriterion,finalFieldsByName,dataSource,validationErrors,true);
                if(!validatedSubcriterion){
                    subcriteria.removeAt(i);
                    continue;
                }
                ++i;
            }
        }else if(operator.valueType&&operator.valueType!="fieldType"){
            validationErrors.push("Operator '"+operatorId+"' is not allowed because the operator valueType is '"+operator.valueType+"'.");
            return null;
        }else{
            var fieldName=criterion.fieldName;
            if(!fieldName){
                validationErrors.push("The '"+operatorId+"' criterion was missing the 'fieldName'.");
                return null;
            }
            var field=(!finalFieldsByName
                         ?dataSource.getUnderlyingField(fieldName)
                         :finalFieldsByName[fieldName]);
            if(!field){
                validationErrors.push("The '"+operatorId+"' criterion referenced field '"+fieldName+"', but that field is not allowed.");
                return null;
            }
        }
        if(!nested){
            criterion=dataSource.validateCriteria(criterion);
            criterion=this._validateCriterion2(criterion,finalFieldsByName,dataSource,validationErrors);
            criterion=isc.DS.simplifyAdvancedCriteria(criterion,true);
        }
        return criterion;
    }
,isc.A._validateCriterion2=function isc_c_AI__validateCriterion2(criterion,finalFieldsByName,dataSource,validationErrors,nested){
        var operatorId=criterion.operator,
            operator=dataSource.getSearchOperator(operatorId);
        this._assert(operator!=null);
        if(operator.valueType=="criteria"){
            var subcriteria=criterion.criteria;
            this._assert(isc.isAn.Array(subcriteria));
            for(var ri=subcriteria.length;ri>0;--ri){
                var i=ri-1,
                    subcriterion=subcriteria[i];
                var validatedSubcriterion2=subcriteria[i]=this._validateCriterion2(
                        subcriterion,finalFieldsByName,dataSource,validationErrors,true);
                if(!validatedSubcriterion2){
                    subcriteria.removeAt(i);
                }
            }
        }else if("fieldName"in criterion){
            var fieldName=criterion.fieldName,
                field=(!finalFieldsByName
                         ?dataSource.getUnderlyingField(fieldName)
                         :finalFieldsByName[fieldName]);
            var validOps=dataSource.getFieldOperators(field);
            if(!validOps||!validOps.contains(operatorId)){
                validationErrors.push("Operator '"+operatorId+"' is not allowed for field '"+fieldName+"'.");
                return null;
            }
        }
        return criterion;
    }
,isc.A._buildAIFilter=function isc_c_AI__buildAIFilter(buildContext){
        var pkFieldNames=buildContext.dataSource.getPrimaryKeyFieldNames();
        var notPickedPkValues,
            pickedPkValues;
        if(pkFieldNames.length==1){
            notPickedPkValues=isc.Set.create();
            pickedPkValues=isc.Set.create();
        }else{
            notPickedPkValues=isc.TupleSet.create();
            pickedPkValues=isc.TupleSet.create();
        }
        var aiCriterion=buildContext.buildRequest._existingAICriterion;
        if(aiCriterion)isc.AI._clearAICriterionState(aiCriterion);
        else aiCriterion={};
        isc.addProperties(aiCriterion,{
            _constructor:"AdvancedCriteria",
            operator:"aiFilter",
            userAIRequest:buildContext.buildRequest.userAIRequest,
            isTrivial:false,
            _summarizedUserMessages:buildContext._summarizedUserMessages,
            _dsName:buildContext.dataSource.getID(),
            _pkFieldNames:pkFieldNames,
            _finalFieldNames:buildContext._dsFinalFields.getProperty("name"),
            _dsSummary:buildContext._dsSummary,
            _notPickedPkValues:notPickedPkValues,
            _notPickedCriterion:null,
            _pickedPkValues:pickedPkValues,
            _clonable:true,
            clone:isc.AI._aiCriterionCloneImpl
        });
        return aiCriterion;
    }
,isc.A._createApplyAIFilterContext=function isc_c_AI__createApplyAIFilterContext(asyncMethodName,applyRequest,opContext){
        var applyContext=this._createBuildViaAIContext(asyncMethodName,applyRequest,opContext);
        this._assert(applyRequest.aiCriterion.operator=="aiFilter");
        var dsName=applyRequest.aiCriterion&&applyRequest.aiCriterion._dsName;
        applyContext.dataSource=dsName&&isc.DS.get(dsName);
        if(applyRequest.showProgressDialog==true){
            applyContext._progressDialog=isc.FilterViaAIProgressDialog.create(applyRequest.progressDialogProperties,{
                _buildContext:applyContext,
                canCancel:applyRequest.userCanCancel!=false
            });
        }
        this._fireAIProgressCallback(applyContext,[{category:"detail",content:isc.AI.startingYourRequestDetailMessage}]);
        return applyContext;
    }
,isc.A.applyAIFilter=function isc_c_AI_applyAIFilter(applyRequest,callback){
        this._wrapAsyncBuildViaAIOperation(this._$asyncApplyAIFilter,applyRequest,callback);
    }
,isc.A.asyncApplyAIFilter=function isc_c_AI_asyncApplyAIFilter(applyRequest){
        return this._asyncAIOperation("_asyncApplyAIFilter",applyRequest);
    }
,isc.A._asyncApplyAIFilter=function isc_c_AI__asyncApplyAIFilter(applyRequest,opContext){
        if(!applyRequest.aiCriterion||applyRequest.aiCriterion.operator!="aiFilter"){
            return isc.rejectWithError("The 'aiFilter' AdvancedCriteria to evaluate is required.");
        }
        if(!applyRequest.records){
            return isc.rejectWithError("The records to apply the AI filter to are required.");
        }
        var applyContext=this._createApplyAIFilterContext(this._$asyncApplyAIFilter,applyRequest,opContext),
            dataSource=applyContext.dataSource;
        if(!dataSource||!isc.AI._supportsAIComponentViews(dataSource,"AIDE")){
            applyContext._resolversObj.reject(isc.createErrorResult(isc.AI.dataSourceIsRequiredErrorMessage));
        }else{
            var aiCriterion=applyRequest.aiCriterion;
            this._assert(aiCriterion.operator=="aiFilter");
            if(!isc.AI._canUseAICriterion(aiCriterion,dataSource)){
                applyContext._resolversObj.reject(isc.createErrorResult("The 'aiFilter' criterion is not usable."));
            }else{
                this._asyncApplyUsableAICriterion(aiCriterion,applyContext)
                    .then(function(matchingRecords){
                        applyContext._resolversObj.resolve({type:"success",matchingRecords:matchingRecords});
                    },function(rejectReason){
                        applyContext._resolversObj.reject(isc.defaultAsyncOperationCatchCallback(rejectReason));
                    });
            }
        }
        return applyContext._resolversObj.promise;
    }
,isc.A._asyncApplyUsableAICriterion=function isc_c_AI__asyncApplyUsableAICriterion(aiCriterion,applyContext){
        var records=applyContext.applyRequest.records,
            partialResult=applyContext.applyRequest._partialResult||isc.AI._applyUsableAIFilterCaches(aiCriterion,records,applyContext.dataSource);
        this._assert(partialResult&&
                     isc.isAn.Array(partialResult.matchingRecords)&&
                     partialResult.matchingRecords.length+(partialResult.remainingRecords==null
                                                             ?0
                                                             :partialResult.remainingRecords.length)==records.length);
        if(!partialResult.remainingRecords||partialResult.remainingRecords.length==0){
            return Promise.resolve(partialResult.matchingRecords);
        }
        return this.__asyncApplyAIFilter(partialResult,aiCriterion,applyContext);
    }
,isc.A.__asyncApplyAIFilter=function isc_c_AI___asyncApplyAIFilter(partialResult,aiCriterion,applyContext){
        if(applyContext._ownCC.canceled){
            return Promise.reject(applyContext._ownCC.asCanceledResult());
        }
        var aiMessagesBuilder=isc.InternalAIMessagesBuilder.create({
            userMessages:aiCriterion._summarizedUserMessages,
            target:this,
            evalVars:{dsSummary:aiCriterion._dsSummary}
        });
        aiMessagesBuilder.appendPrompts(this.applyAIFilterPrompts);
        var aiMessages=aiMessagesBuilder.aiMessages;
        var data=partialResult.remainingRecords,
            dataLength=data.getLength(),
            resolversObj=Promise.withResolvers();
        var recordsPickingProgressCallback=function(){
            if(applyContext._ownCC.canceled){
                return false;
            }
            ++applyContext._numStepsCompleted;
            isc.AI._fireAIProgressCallback(applyContext,null,true);
        };
        var recordsPickingSettings={
            fieldNames:aiCriterion._finalFieldNames,
            aiPageSize:applyContext.applyRequest.aiPageSize,
            maxRetries:applyContext._aiConfig.maxRetries,
            serializationFormat:applyContext._aiConfig.serializationFormat,
            progressCallback:recordsPickingProgressCallback
        };
        var context=this._getContextForAIMessages(aiMessages);
        if(context.errorMessage)return isc.rejectWithError(context.errorMessage);
        var transaction=context.aiEngine.doPageRecordsPicking(aiMessages,data,function(pickedData,batches){
            if(applyContext._ownCC.canceled)return;
            var firstBadBatch=batches.find({_constructor:"AdvancedCriteria",fieldName:"nonSuccessfulResult",operator:"notNull"});
            if(firstBadBatch){
                resolversObj.reject(firstBadBatch.nonSuccessfulResult);
                return;
            }
            partialResult.matchingRecords.addAll(pickedData);
            var pkFieldNames=aiCriterion._pkFieldNames;
            var notPickedPkValues=aiCriterion._notPickedPkValues,
                notPickedCriteria=null,
                pickedPkValues=aiCriterion._pickedPkValues;
            if(pkFieldNames.length==1){
                var pkFieldName=pkFieldNames[0];
                for(var i=0;i<pickedData.length;++i){
                    pickedPkValues.add(pickedData[i][pkFieldName]);
                }
                for(var i=0;i<dataLength;++i){
                    var pkValue=data.get(i)[pkFieldName];
                    if(!pickedPkValues.has(pkValue)){
                        notPickedPkValues.add(pkValue);
                    }
                }
                if(!notPickedPkValues.isEmpty()){
                    notPickedCriteria={
                        _constructor:"AdvancedCriteria",
                        fieldName:pkFieldName,
                        operator:"notInSet",
                        value:notPickedPkValues.getContents()
                    };
                }
            }else{
                isc.AI._assert(false);
            }
            aiCriterion._notPickedCriterion=notPickedCriteria;
            isc.AI._fireAIProgressCallback(applyContext,null,true);
            resolversObj.resolve(partialResult.matchingRecords);
        },recordsPickingSettings);
        var numBatches=transaction.batches.length;
        applyContext._estimatedNumTotalSteps+=numBatches;
        this._fireAIProgressCallback(applyContext,[{category:"detail",content:"AI will evaluate the criteria in "+numBatches+" batch(es) of records."}],true);
        return resolversObj.promise;
    }
,isc.A.removeFromAIFilterCaches=function isc_c_AI_removeFromAIFilterCaches(aiCriterion,records){
        if(aiCriterion.operator!="aiFilter"){
            this.logWarn("The AdvancedCriteria passed to removeFromAIFilterCaches() has operator '"+
                    aiCriterion.operator+"'; expecting 'aiFilter'.","AI");
            return;
        }
        var pkFieldNames=aiCriterion._pkFieldNames,
            notPickedPkValues=aiCriterion._notPickedPkValues,
            pickedPkValues=aiCriterion._pickedPkValues;
        if(!isc.isA.Class(notPickedPkValues)){
            notPickedPkValues=aiCriterion._notPickedPkValues=null;
            aiCriterion._notPickedCriterion=null;
        }
        if(!isc.isA.Class(pickedPkValues)){
            pickedPkValues=aiCriterion._pickedPkValues=null;
        }
        if(!isc.isAn.Array(pkFieldNames))return;
        if(pkFieldNames.length==1){
            var pkFieldName=pkFieldNames[0];
            if(isc.isA.Class(notPickedPkValues)){
                var removedAnyNotPicked=false;
                for(var recordIndex=0;recordIndex<records.length;++recordIndex){
                    if(notPickedPkValues.remove(records[recordIndex][pkFieldName]))removedAnyNotPicked=true;
                }
                if(removedAnyNotPicked){
                    aiCriterion._notPickedCriterion={
                        _constructor:"AdvancedCriteria",
                        fieldName:pkFieldName,
                        operator:"notInSet",
                        value:notPickedPkValues.getContents()
                    };
                }
            }
            if(isc.isA.Class(pickedPkValues)){
                for(var recordIndex=0;recordIndex<records.length;++recordIndex){
                    pickedPkValues.remove(records[recordIndex][pkFieldName]);
                }
            }
        }else{
            this._assert(false);
        }
    }
,isc.A.clearAIFilterCaches=function isc_c_AI_clearAIFilterCaches(aiCriterion){
        if(aiCriterion.operator!="aiFilter"){
            this.logWarn("The AdvancedCriteria passed to clearAIFilterCaches() has operator '"+
                    aiCriterion.operator+"'; expecting 'aiFilter'.","AI");
            return;
        }
        if(isc.isA.Class(aiCriterion._notPickedPkValues)){
            aiCriterion._notPickedPkValues.clear();
        }
        aiCriterion._notPickedPkValues=null;
        aiCriterion._notPickedCriterion=null;
        if(isc.isA.Class(aiCriterion._pickedPkValues)){
            aiCriterion._pickedPkValues.clear();
        }
        aiCriterion._pickedPkValues=null;
    }
,isc.A.asyncReapplyAIFilter=function isc_c_AI_asyncReapplyAIFilter(reapplyRequest){
        if(!reapplyRequest.aiCriterion||reapplyRequest.aiCriterion.operator!="aiFilter"){
            return isc.rejectWithError("The 'aiFilter' AdvancedCriteria to re-apply is required.");
        }
        if(!isc.isAn.Array(reapplyRequest.updatedRecords)){
            return isc.rejectWithError("The updated records are required.");
        }
        this.removeFromAIFilterCaches(reapplyRequest.aiCriterion,reapplyRequest.updatedRecords);
        var applyRequest=isc.addProperties({},reapplyRequest,{
            showProgressDialog:reapplyRequest.showProgressDialog!=true,
            records:reapplyRequest.updatedRecords,
            updatedRecords:null
        });
        return this.asyncApplyAIFilter(applyRequest)
            .then(function(response){
                response.matchingUpdatedRecords=response.matchingRecords;
                delete response.matchingRecords;
                return response;
            });
    }
,isc.A._createBuildHilitesContext=function isc_c_AI__createBuildHilitesContext(asyncMethodName,buildRequest,dabOpContext){
        var buildContext=this._createBuildViaAIContext(asyncMethodName,buildRequest,dabOpContext);
        buildContext.dataSource=dabOpContext.dataSource;
        var mode=buildRequest.mode;
        if(mode==null)mode="hybrid";
        else if(mode!="aiAssist"&&mode!="AIDE"&&mode!="hybrid"){
            this.logWarn("unsupported AI service mode '"+mode+"'. Switching to 'hybrid'.");
            mode="hybrid";
        }
        buildContext.mode=mode;
        if(buildRequest.showProgressDialog==null||buildRequest.showProgressDialog){
            buildContext._progressDialog=isc.HiliteViaAIProgressDialog.create(buildRequest.progressDialogProperties,{
                _buildContext:buildContext,
                canCancel:buildRequest.userCanCancel!=false
            });
        }
        buildContext._estimatedNumTotalSteps=2;
        this._fireAIProgressCallback(buildContext,[{category:"detail",content:isc.AI.startingYourRequestDetailMessage}]);
        return buildContext;
    }
,isc.A.buildHilites=function isc_c_AI_buildHilites(buildRequest,callback){
        this._wrapAsyncBuildViaAIOperation(this._$asyncBuildHilites,buildRequest,callback);
    }
,isc.A.asyncBuildHilites=function isc_c_AI_asyncBuildHilites(buildRequest){
        return this._asyncDataBoundAIOperation("_asyncBuildHilites",buildRequest);
    }
,isc.A._asyncBuildHilites=function isc_c_AI__asyncBuildHilites(buildRequest,dabOpContext){
        var buildContext=this._createBuildHilitesContext(this._$asyncBuildHilites,buildRequest,dabOpContext),
            dataSource=buildContext.dataSource;
        if(!dataSource||!isc.AI._supportsAIComponentViews(dataSource,buildContext.mode)){
            buildContext._resolversObj.reject(isc.createErrorResult(isc.AI.dataSourceIsRequiredErrorMessage));
        }else{
            this._asyncSummarizeUserMessages(buildContext)
                .then(function(summarizedUserMessages){
                    return isc.AI._asyncBuildHilitesWithSummarizedUserMessages(
                            summarizedUserMessages,buildContext);
                })
                .then(function(hilites){
                    buildContext._resolversObj.resolve({type:"success",hilites:hilites});
                },function(rejectReason){
                    buildContext._resolversObj.reject(isc.defaultAsyncOperationCatchCallback(rejectReason));
                });
        }
        return buildContext._resolversObj.promise;
    }
,isc.A._extendColorMap=function isc_c_AI__extendColorMap(){
        var colorMap=this._cssColorForColorName;
        colorMap.lightgrey=colorMap.lightgray;
        colorMap.grey=colorMap.gray;
        colorMap.darkgrey=colorMap.darkgray;
        colorMap.silver=colorMap.gray;
        colorMap.platinum=colorMap.lightgray;
    }
,isc.A._asyncBuildHilitesWithSummarizedUserMessages=function isc_c_AI__asyncBuildHilitesWithSummarizedUserMessages(summarizedUserMessages,buildContext){
        if(buildContext._ownCC.canceled){
            return Promise.reject(buildContext._ownCC.asCanceledResult());
        }
        var fields=isc.getValues(buildContext.dataSource.getFields());
        var aiMessagesBuilder=isc.InternalAIMessagesBuilder.create({
            cancellationController:buildContext._ownCC,
            userMessages:summarizedUserMessages,
            target:this,
            evalVars:{
                dsSummary:"${dsSummary}",
                referenceTime:buildContext.referenceTime
            }
        });
        aiMessagesBuilder.appendPrompts(this.buildHilitesPrompts);
        var partiallyProcessedAIRequest={
            messages:aiMessagesBuilder.aiMessages,
            responseType:"object"
        };
        return this._asyncBuildHilitesWithFinalFields(buildContext,partiallyProcessedAIRequest,fields);
    }
,isc.A._asyncBuildHilitesWithFinalFields=function isc_c_AI__asyncBuildHilitesWithFinalFields(buildContext,partiallyProcessedAIRequest,finalFields){
        if(buildContext._ownCC.canceled){
            return Promise.reject(buildContext._ownCC.asCanceledResult());
        }
        if(finalFields==null||(finalFields.removeEmpty(),finalFields).isEmpty()){
            return isc.rejectWithError("No fields were selected for use in building the Hilite.");
        }
        buildContext._dsFinalFields=finalFields;
        var dsSummary=this.summarizeDataSource(buildContext.dataSource,finalFields,buildContext._aiConfig,false);
        buildContext._dsSummary=dsSummary;
        var evalVars={
            dsSummary:dsSummary
        };
        var aiRequest={
            cancellationController:buildContext._ownCC,
            messages:partiallyProcessedAIRequest.messages.map(function(message){
                if(message.source=="system"&&isc.AIEngine._isTextContentType(message.type)){
                    return{
                        source:message.source,
                        content:String(message.content).evalDynamicString(this,evalVars)
                    };
                }
                return message;
            },this),
            responseType:partiallyProcessedAIRequest.responseType
        };
        if(!buildContext._ownCC.canceled&&buildContext._progressDialog)buildContext._progressDialog.show();
        return this.asyncSendRequest(aiRequest,buildContext._aiConfig)
            .then(function(aiResponse){
                var responseArr=aiResponse.message.content&&aiResponse.message.content.hiliteSpecs;
                if(!isc.isAn.Array(responseArr)){
                    if(isc.isAn.Object(responseArr)){
                        responseArr=[responseArr];
                    }else{
                        return isc.rejectWithError(isc.AI.aiNotAbleToProcessRequestErrorMessage);
                    }
                }
                for(var ri=responseArr.length;ri>0;--ri){
                    var i=ri-1,
                        responseObject=responseArr[i];
                    if(!isc.isAn.Object(responseObject)||
                        !isc.isA.String(responseObject.filterDescription)||
                        !isc.isA.String(responseObject.hiliteDescription)||
                        !responseObject.filterDescription.trim()||
                        !responseObject.hiliteDescription.trim())
                    {
                        responseArr.removeAt(i);
                    }
                }
                if(responseArr.isEmpty()){
                }
                var numResponseObjects=responseArr.length;
                ++buildContext._numStepsCompleted;
                isc.AI._fireAIProgressCallback(buildContext,[{category:"success",content:"AI has determined the hilite styling and field(s) that should be hilited, for "+numResponseObjects+" hilite(s)."},
                                                            {category:"detail",content:"Will now validate the hilite and apply the hilite criteria\u2026"}]);
                var mapper=isc.ResolvedValuesMapper.create({
                    values:responseArr,
                    cancellationController:buildContext._ownCC,
                    maxConcurrent:3,
                    asyncMap:function(responseObject){
                        return isc.AI._asyncValidateAndFinishHilite(buildContext,responseObject);
                    }
                });
                return mapper.getPromise();
            });
    }
);
isc.evalBoundary;isc.B.push(isc.A._getCSSColorNames=function isc_c_AI__getCSSColorNames(){
        if(!this._cssColorNames&&isc.ColorUtils&&isc.ColorUtils.colorNames){
            this._cssColorNames=isc.getKeys(isc.ColorUtils.colorNames);
        }
        return this._cssColorNames||[];
    }
,isc.A._makeLikelyCSSColorRegExp=function isc_c_AI__makeLikelyCSSColorRegExp(){
        var regExpSrc="\\b(?:"+this._getCSSColorNames().map(RegExp._escape).join("|")+")\\b";
        regExpSrc+="|#[a-f\\d]{3}(?:[a-f\\d](?:[a-f\\d]{2}(?:[a-f\\d]{2})?)?)?\\b";
        var numberOrPercentageRegExpSrc="(?:[-+]?\\d+(?:\\.\\d*)?(?:[Ee][-+]?\\d+)?%?)";
        regExpSrc+="|rgba?\\(\\s*"+numberOrPercentageRegExpSrc+"\\s*,?"+
                "\\s*"+numberOrPercentageRegExpSrc+"\\s*,?"+
                "\\s*"+numberOrPercentageRegExpSrc+
                "(?:\\s*,\\s*"+numberOrPercentageRegExpSrc+")?\\)";
        this._likelyCSSColorRegExp=new RegExp(regExpSrc);
    }
,isc.A._extractLikelyCSSColor=function isc_c_AI__extractLikelyCSSColor(color){
        this._likelyCSSColorRegExp.lastIndex=0;
        var result=this._likelyCSSColorRegExp.exec(color);
        return result&&result[0];
    }
,isc.A._validateCSSColor=function isc_c_AI__validateCSSColor(responseObject,colorPropertyName){
        var colorText=responseObject[colorPropertyName];
        if(!isc.isA.String(colorText)){
            delete responseObject[colorPropertyName];
            return;
        }
        colorText=colorText.trim().toLowerCase();
        var cssColor;
        for(var namesRegExp=new RegExp("[a-z]+","g"),result=namesRegExp.exec(colorText);result;result=namesRegExp.exec(colorText)){
            cssColor=this._cssColorForColorName[result[0]];
            if(cssColor){
                break;
            }
        }
        if(!cssColor){
            cssColor=this._extractLikelyCSSColor(colorText);
        }
        if(!cssColor)delete responseObject[colorPropertyName];
        else responseObject[colorPropertyName]=cssColor;
    }
,isc.A._removeCSSComments=function isc_c_AI__removeCSSComments(cssText){
        var slashStarPos=0;
        do{
            slashStarPos=cssText.indexOf("/*",slashStarPos);
            if(slashStarPos<0)return cssText;
            var starSlashPos=cssText.indexOf("*/",slashStarPos+1);
            if(starSlashPos<0){
                return cssText.substring(0,slashStarPos);
            }
            cssText=cssText.substring(0,slashStarPos)+cssText.substring(starSlashPos+2);
        }while(slashStarPos<cssText.length);
        return cssText;
    }
,isc.A._removeCSSProperty=function isc_c_AI__removeCSSProperty(cssText,cssPropertyName,responseObject,responseObjectPropertyName){
        var value;
        var regExp=new RegExp("[\\s;]*"+RegExp._escape(cssPropertyName)+"\\s*:([^;]*)[\\s;]*","gim");
        var result;
        while(result=regExp.exec(cssText)){
            value=result[1]+" "+(value||"");
            var firstPart=cssText.substring(0,regExp.lastIndex-result[0].length),
                lastPart=cssText.substring(regExp.lastIndex),
                sep=!firstPart||!lastPart?"":";";
            cssText=firstPart+sep+lastPart;
            regExp.lastIndex-=result[0].length;
        }
        responseObject[responseObjectPropertyName]=(responseObject[responseObjectPropertyName]||"")+" "+value;
        return cssText;
    }
,isc.A._asyncValidateAndFinishHilite=function isc_c_AI__asyncValidateAndFinishHilite(buildContext,responseObject){
        if(responseObject.fieldName!=null){
            if(!isc.isAn.Array(responseObject.fieldName))responseObject.fieldName=[responseObject.fieldName];
            for(var ri=responseObject.fieldName.length;ri>0;--ri){
                var i=ri-1,
                    fieldName=responseObject.fieldName[i];
                if(!buildContext._dsFinalFields.find("name",fieldName)){
                    isc.logWarn("AI selected an invalid field '"+fieldName+"'. Deleting...","AI");
                    responseObject.fieldName.removeAt(i);
                }
            }
            if(responseObject.fieldName.isEmpty())delete responseObject.fieldName;
            else if(responseObject.fieldName.length==1)responseObject.fieldName=responseObject.fieldName[0];
        }
        if(!isc.isA.String(responseObject.cssText)){
            delete responseObject.cssText;
        }else{
            responseObject.cssText=this._removeCSSComments(responseObject.cssText);
            responseObject.cssText=this._removeCSSProperty(responseObject.cssText,"color",responseObject,"textColor");
            responseObject.cssText=this._removeCSSProperty(responseObject.cssText,"background-color",responseObject,"backgroundColor");
            responseObject.cssText=this._removeCSSProperty(responseObject.cssText,"text-decoration-color",responseObject,"_textDecorationColor");
            this._validateCSSColor(responseObject,"_textDecorationColor");
            if(responseObject._textDecorationColor){
                if(responseObject.cssText)responseObject.cssText+="; ";
                responseObject.cssText+="text-decoration-color: "+responseObject._textDecorationColor;
            }
        }
        this._validateCSSColor(responseObject,"textColor");
        this._validateCSSColor(responseObject,"backgroundColor");
        if(!responseObject.textColor){
            if(!responseObject.backgroundColor){
                responseObject.textColor=this._cssColorForColorName["red"];
            }else{
                if(isc.ColorUtils.isDark(responseObject.backgroundColor)){
                    responseObject.textColor="#fff";
                }
            }
        }
        var buildHiliteCriterionRequest={
            cancellationController:buildContext._ownCC,
            purpose:"hilite",
            userAIRequest:{prompt:responseObject.filterDescription},
            dataSource:buildContext.dataSource,
            mode:buildContext.mode,
            maxRetries:buildContext.buildRequest.maxRetries,
            showProgressDialog:false
        };
        return isc.AI.asyncBuildCriterion(buildHiliteCriterionRequest)
            .then(function(buildHiliteCriterionResponse){
                var hilite=isc.applyMask(responseObject,
                    ["backgroundColor","textColor","cssText","fieldName","replacementValue"]);
                var hiliteCriterion=buildHiliteCriterionResponse.criterion;
                hilite.criteria=hiliteCriterion;
                if(hiliteCriterion.operator!="aiFilter")return hilite;
                var applyRequest={
                    cancellationController:buildContext._ownCC,
                    aiCriterion:hiliteCriterion,
                    dataSource:buildContext.dataSource,
                    mode:buildContext.mode,
                    records:buildContext.buildRequest.records,
                    maxRetries:buildContext.buildRequest.maxRetries,
                    showProgressDialog:false
                };
                return isc.AI.asyncApplyAIFilter(applyRequest)
                    .then(Promise.resolve(hilite));
            });
    }
,isc.A._validateAIBuiltUI=function isc_c_AI__validateAIBuiltUI(buildContext){
        var buildRequest=buildContext.buildRequest;
        var validationTypes=buildContext._validationTypes,
            validationTypeIndex=buildContext._validationTypeIndex,
            currentValidationType;
        var setUpNextValidator=function(){
            buildContext.appliedValidationTypes.add(currentValidationType);
            validationTypeIndex=buildContext._validationTypeIndex=validationTypeIndex+1;
            buildContext._validationRetryIndex=0;
            buildContext._validationContext=null;
            ++buildContext._numStepsCompleted;
            isc.AI._fireAIProgressCallback(buildContext,[{category:"success",content:"Finished applying '"+currentValidationType+"' validation"}]);
        };
        for(
            ;
            validationTypeIndex<validationTypes.length;
            setUpNextValidator()
        ){
            if(buildContext._ownCC.canceled){
                buildContext._validationResolversObj.reject(buildContext._ownCC.asCanceledResult());
                return;
            }
            currentValidationType=validationTypes[validationTypeIndex];
            var validationRetryIndex=Math.max(0,+buildContext._validationRetryIndex);
            if(isNaN(validationRetryIndex))validationRetryIndex=buildContext._validationRetryIndex=0;
            var maxValidationRetries=Math.max(0,buildRequest.maxValidationRetries==null?1:buildRequest.maxValidationRetries);
            if(isNaN(maxValidationRetries))maxValidationRetries=1;
            if(validationRetryIndex>maxValidationRetries){
                buildContext._validationResolversObj.reject(isc.createErrorResult(
                    "Exceeded the maximum number of retries ("+maxValidationRetries+") for '"+currentValidationType+"' validation."
                ));
                return;
            }
            var validator;
            if(currentValidationType=="custom"){
                validator=buildRequest.customValidator;
                this._assert(validator!=null);
            }else if(currentValidationType=="default"){
                validator={target:this,methodName:"buildUIViaAIDefaultValidator"};
            }
            if(validator==null){
                this.logWarn("validateAIBuiltUI(): Unhandled validation type '"+currentValidationType+"'");
                continue;
            }
            this.fireCallback(validator,isc.AI._buildUIViaAIValidatorArgNames,[
                buildContext,
                buildContext._validationContext,
                function(workingResponse,validationContext){
                    var jsCode=String.prototype.trim.call(workingResponse.jsCode||"");
                    buildContext.jsCode=jsCode;
                    buildContext.nodes=workingResponse.nodes;
                    buildContext._validationContext=validationContext;
                    var errorMessage=workingResponse.errorMessage;
                    if(errorMessage!=null){
                        isc.AI.logDebug("validateAIBuiltUI(): validation type '"+currentValidationType+"' failed: "+errorMessage,"AI");
                        errorMessage="Validation type '"+currentValidationType+"' failed: "+errorMessage;
                        if(jsCode==""){
                            buildContext._validationResolversObj.reject(isc.createErrorResult(
                                "Validation type '"+currentValidationType+"' failed: "+errorMessage
                            ));
                            return;
                        }
                        ++buildContext._validationRetryIndex;
                        if(buildContext._validationRetryIndex<=maxValidationRetries){
                            try{
                                if(!new RegExp("\\p{P}$","u").test(errorMessage))errorMessage+=".";
                            }catch(e){}
                            if(!/\s$/.test(errorMessage))errorMessage+=" ";
                            errorMessage+="Will retry\u2026";
                        }
                        isc.AI._fireAIProgressCallback(buildContext,[{category:"recoverableError",content:errorMessage}]);
                    }else{
                        setUpNextValidator();
                    }
                    isc.AI._validateAIBuiltUI(buildContext);
                }
            ]);
            return;
        }
        buildContext._validationResolversObj.resolve({
            type:"success",
            jsCode:buildContext.jsCode,
            nodes:buildContext.nodes
        });
    }
,isc.A._getPaletteNodesAndValidationResult=function isc_c_AI__getPaletteNodesAndValidationResult(jsCode,handleErrorCallback,continueCallback){
        var callback=function(nodes,topLevelNodes){
            var validationResult;
            try{
                validationResult=isc.EditContext.validatePaletteNodeDefaults(topLevelNodes);
            }catch(e){
                handleErrorCallback(e);
                return;
            }
            continueCallback(nodes,validationResult);
        };
        isc.EditContext.createPaletteNodesFromJS2(jsCode,callback);
    }
,isc.A.buildUIViaAIDefaultValidator=function isc_c_AI_buildUIViaAIDefaultValidator(buildContext,validationContext,validationResultCallback){
        var _this=this;
        var fireValidationResultCallback=function(workingResponse){
            _this.fireCallback(validationResultCallback,isc.AI._buildUIViaAIValidationResultCallbackArgNames,[workingResponse,validationContext]);
        };
        if(isc.EditContext==null){
            return fireValidationResultCallback({
                jsCode:buildContext.jsCode,
                nodes:buildContext.nodes
            });
        }
        if(validationContext==null){
            validationContext={
                prevJsCode:[],
                prevValidationResults:[]
            };
        }
        this._getPaletteNodesAndValidationResult(
            buildContext.jsCode,
            function(e){
                _this.logWarn("buildUIViaAIDefaultValidator(): Error attempting to validate AI-built code: "+e);
                fireValidationResultCallback({
                    errorMessage:"Attempting to validate AI-generated JavaScript caused an error: "+e
                });
            },
            function(nodes,validationResult){
                validationContext.prevJsCode.add(buildContext.jsCode);
                validationContext.prevValidationResults.add(validationResult);
                if(validationResult==null||isc.isAn.emptyObject(validationResult)){
                    return fireValidationResultCallback({
                        jsCode:buildContext.jsCode,
                        nodes:nodes
                    });
                }else{
                    _this.requestUICodeValidationFix(
                        buildContext,
                        validationContext,
                        validationResult,
                        validationResultCallback
                    );
                    return;
                }
            }
        );
    }
,isc.A.requestUICodeValidationFix=function isc_c_AI_requestUICodeValidationFix(buildContext,validationContext,validationResult,validationResultCallback){
        var fireValidationResultCallback=function(workingResponse){
            isc.AI.fireCallback(validationResultCallback,isc.AI._buildUIViaAIValidationResultCallbackArgNames,[workingResponse,validationContext]);
        };
        var fireValidationResultCallbackWithError=function(error){
            fireValidationResultCallback({
                type:"error",
                errorMessage:error,
                jsCode:buildContext.jsCode
            });
        };
        var aiMessagesBuilder=isc.InternalAIMessagesBuilder.create({
            userMessages:buildContext._summarizedUserMessages,
            target:this,
            evalVars:{
                jsCode:buildContext.jsCode,
                errors:this._encodeJSON(validationResult)
            }
        });
        aiMessagesBuilder.appendPrompts(this.uiCodeValidationPrompts);
        aiMessagesBuilder.appendPrompts(this.uiCodeSuffixPrompts);
        var aiRequest={
            cancellationController:buildContext._ownCC,
            messages:aiMessagesBuilder.aiMessages
        };
        this.asyncSendRequest(aiRequest,buildContext._aiConfig)
            .then(function(aiResponse){
                var content=aiResponse.message.content||"";
                var newJsCode=String.prototype.trim.call(isc.AI.extractFencedCode(content));
                if(newJsCode==""){
                    return fireValidationResultCallbackWithError("AI returned no UI code in response to the request to generate corrected code.");
                }
                isc.AI._getPaletteNodesAndValidationResult(
                    newJsCode,
                    function(e){
                        isc.AI.logWarn("requestUICodeValidationFix(): Error attempting to validate AI-built code: "+e);
                        return fireValidationResultCallbackWithError("Attempting to validate AI-generated JavaScript caused an error: "+e);
                    },
                    function(newNodes,newValidationResult){
                        if(newValidationResult==null||isc.isAn.emptyObject(newValidationResult)){
                            return fireValidationResultCallback({
                                jsCode:newJsCode,
                                nodes:newNodes
                            });
                        }else{
                            fireValidationResultCallback({jsCode:newJsCode,errorMessage:"AI returned code that failed validation. A request was made to correct the code."});
                        }
                    }
                );
            },function(rejectReason){
                var aiResponse=isc.defaultAsyncOperationCatchCallback(rejectReason);
                if(aiResponse.type=="canceled"){
                    var cancellationReason="An AI request was canceled. ";
                    if(aiResponse.cancellationReason)cancellationReason+=aiResponse.cancellationReason;
                    fireValidationResultCallback({type:aiResponse.type,cancellationReason:cancellationReason});
                    return;
                }
                fireValidationResultCallbackWithError("An AI request failed: "+aiResponse.errorMessage);
            });
    }
,isc.A._createBuildUIViaAIContext=function isc_c_AI__createBuildUIViaAIContext(asyncMethodName,buildRequest,opContext){
        var buildContext=this._createBuildViaAIContext(asyncMethodName,buildRequest,opContext);
        var validationTypes=buildRequest._validationTypes;
        if(validationTypes==null){
            validationTypes=isc.AI.defaultBuildUIViaAIValidationTypes;
        }
        if(buildRequest.customValidator==null){
            if(validationTypes.contains("custom")){
                validationTypes=validationTypes.duplicate();
                validationTypes.remove("custom");
            }
        }else{
            if(!validationTypes.contains("custom")){
                validationTypes=validationTypes.duplicate();
                validationTypes.add("custom");
            }
        }
        buildContext._validationTypes=validationTypes;
        buildContext.appliedValidationTypes=[];
        buildContext._validationTypeIndex=0;
        buildContext._validationRetryIndex=0;
        buildContext._validationContext=null;
        buildContext._validationResolversObj=Promise.withResolvers();
        buildContext._estimatedNumTotalSteps=2+validationTypes.length;
        if(buildRequest.showProgressDialog==null||buildRequest.showProgressDialog){
            buildContext._progressDialog=isc.BuildUIViaAIProgressDialog.create({
                _buildContext:buildContext,
                canCancel:buildRequest.userCanCancel!=false
            });
            buildContext._progressDialog.show();
        }
        this._fireAIProgressCallback(buildContext,[{category:"detail",content:isc.AI.startingYourRequestDetailMessage}]);
        return buildContext;
    }
,isc.A.buildDataBoundUI=function isc_c_AI_buildDataBoundUI(buildRequest,callback){
        this._wrapAsyncBuildViaAIOperation(this._$asyncBuildDataBoundUI,buildRequest,callback);
    }
,isc.A.asyncBuildDataBoundUI=function isc_c_AI_asyncBuildDataBoundUI(buildRequest){
        return this._asyncAIOperation("_asyncBuildDataBoundUI",buildRequest);
    }
,isc.A._asyncBuildDataBoundUI=function isc_c_AI__asyncBuildDataBoundUI(buildRequest,opContext){
        var errorMessage;
        var buildContext=this._createBuildUIViaAIContext(this._$asyncBuildDataBoundUI,buildRequest,opContext);
        var dataSourceNames=buildRequest.availableDataSources||isc.AI.getDataSourceNames();
        if(dataSourceNames==null){
            errorMessage=isc.AI.noDataSourcesAvailableOrFoundErrorMessage;
        }else{
            if(!isc.isAn.Array(dataSourceNames))dataSourceNames=[dataSourceNames];
            var dataSources=dataSourceNames.map(function(dsName){
                return isc.DS.get(dsName);
            });
            dataSources.removeEmpty();
            if(dataSources.isEmpty()){
                errorMessage=isc.AI.noDataSourcesAvailableOrFoundErrorMessage;
            }else{
                buildContext._dataSources=dataSources;
            }
        }
        var uiTypeInfos,
            uiTypes;
        if(errorMessage==null){
            uiTypeInfos=this.dataBoundUITypeInfos;
            if(buildRequest.allowedUITypes!=null){
                uiTypeInfos=isc.applyMask(uiTypeInfos,buildRequest.allowedUITypes);
                uiTypes=isc.getKeys(uiTypeInfos);
                if(uiTypes.length!=buildRequest.allowedUITypes.length){
                    var unknownUITypes=buildRequest.allowedUITypes.duplicate();
                    unknownUITypes.removeList(uiTypes);
                    errorMessage="buildDataBoundUI() was passed unknown data-bound UI type(s): "+unknownUITypes;
                }
            }else{
                uiTypes=isc.getKeys(uiTypeInfos);
            }
            if(uiTypes.isEmpty()){
                errorMessage="At least one UI type must be allowed.";
            }
        }
        buildContext._uiTypes=uiTypes;
        buildContext._uiTypeInfos=uiTypeInfos;
        if(errorMessage!=null){
            buildContext._resolversObj.reject(isc.createErrorResult(errorMessage));
        }else{
            this._asyncSummarizeUserMessages(buildContext)
                .then(function(summarizedUserMessages){
                    return isc.AI._asyncBuildDataBoundUIWithSummarizedUserMessages(
                            summarizedUserMessages,buildContext);
                })
                .then(buildContext._resolversObj.resolve,function(rejectReason){
                    buildContext._resolversObj.reject(isc.defaultAsyncOperationCatchCallback(rejectReason));
                });
        }
        return buildContext._resolversObj.promise;
    }
,isc.A._asyncBuildDataBoundUIWithSummarizedUserMessages=function isc_c_AI__asyncBuildDataBoundUIWithSummarizedUserMessages(summarizedUserMessages,buildContext){
        if(buildContext._ownCC.canceled){
            return Promise.reject(buildContext._ownCC.asCanceledResult());
        }
        var dataSources=buildContext._dataSources,
            uiTypeInfos=buildContext._uiTypeInfos,
            uiTypes=buildContext._uiTypes;
        this._assert(!dataSources.isEmpty());
        this._assert(!uiTypes.isEmpty());
        var responseExample={
            component:uiTypes[0]
        };
        var mustChooseDS=(dataSources.length>1);
        if(mustChooseDS){
            responseExample.dataSource="someDataSourceID";
        }
        var uiTypeDescriptions="";
        for(var i=0;i<uiTypes.length;++i){
            var uiType=uiTypes[i];
            uiTypeDescriptions+="\n\""+uiType+"\": "+uiTypeInfos[uiType].description;
        }
        var evalVars={
            uiTypeDescriptions:uiTypeDescriptions,
            uiTypes:this._encodeJSON(uiTypes),
            responseExample:this._encodeJSON(responseExample)
        };
        if(mustChooseDS){
            var descriptions={};
            for(var i=0;i<dataSources.length;i++){
                var dataSource=dataSources[i];
                descriptions[dataSource.ID]=this.getShortDSDescription(dataSource);
            }
            evalVars.dsDescriptions=this._encodeJSON(descriptions);
            evalVars.dsIDs=this._encodeJSON(dataSources.getProperty("ID"));
        }
        var aiMessagesBuilder=isc.InternalAIMessagesBuilder.create({
            userMessages:summarizedUserMessages,
            target:this,
            evalVars:evalVars
        });
        aiMessagesBuilder.appendPrompts(this.dataBoundUIInitiatorPrefixPrompts);
        aiMessagesBuilder.appendPrompt(this.dataBoundUIInitiatorPrompt_UIOptions);
        if(mustChooseDS){
            aiMessagesBuilder.appendPrompt(this.dataBoundUIInitiatorPrompt_DSOptions);
        }
        aiMessagesBuilder.appendPrompt(this.dataBoundUIInitiator_UIResponseFormat);
        if(mustChooseDS){
            aiMessagesBuilder.appendPrompt(this.dataBoundUIInitiator_DSResponseFormat);
        }
        aiMessagesBuilder.appendPrompt(this.dataBoundUIInitiatorSuffix);
        var aiRequest={
            cancellationController:buildContext._ownCC,
            messages:aiMessagesBuilder.aiMessages,
            responseType:"object"
        };
        return this.asyncSendRequest(aiRequest,buildContext._aiConfig)
            .then(function(aiResponse){
                var initiatorResponseObject=aiResponse.message.content;
                var uiType=initiatorResponseObject.component;
                if(uiType==null||
                    uiType=="invald")
                {
                    return isc.rejectWithError("AI could not determine a data-bound UI type to use to satisfy the request.");
                }
                if(!buildContext._uiTypes.contains(uiType)){
                    return isc.rejectWithError("AI requested to use the unavailable or unknown UI type '"+uiType+"'.");
                }
                buildContext.uiType=uiType;
                if(mustChooseDS){
                    var dataSourceName=initiatorResponseObject.dataSource;
                    if(dataSourceName==null||
                        dataSourceName=="invalid")
                    {
                        return isc.rejectWithError("AI could not determine which available data source to use to satisfy the request.");
                    }
                    var dataSource=buildContext._dataSources.find("ID",dataSourceName);
                    if(dataSource==null){
                        return isc.rejectWithError("AI requested to use the unavailable or unknown data source '"+dataSourceName+"'.");
                    }
                    buildContext.dataSource=dataSource;
                }else{
                    buildContext.dataSource=dataSources[0];
                }
                ++buildContext._numStepsCompleted;
                isc.AI._fireAIProgressCallback(
                    buildContext,
                    [{
                        category:"success",
                        content:"Gathered initial information about your request"
                    },{
                        category:"detail",
                        content:"AI will build a "+uiType+
                                (mustChooseDS?" using data source '"+dataSourceName+"'.":".")
                    }]
                );
                return isc.AI._asyncRequestDataBoundUICode(buildContext);
            });
    }
,isc.A._asyncRequestDataBoundUICode=function isc_c_AI__asyncRequestDataBoundUICode(buildContext){
        var fields=isc.getValues(buildContext.dataSource.getFields());
        var uiTypeInfo=buildContext._uiTypeInfos[buildContext.uiType];
        var aiMessagesBuilder=isc.InternalAIMessagesBuilder.create({
            userMessages:buildContext._summarizedUserMessages,
            target:this,
            evalVars:{
                componentType:uiTypeInfo.componentType,
                dsSummary:"${dsSummary}",
                componentCodePrompt:uiTypeInfo.codePrompt
            }
        });
        aiMessagesBuilder.appendPrompts(this.dataBoundUICodePrefixPrompts);
        aiMessagesBuilder.appendPrompts(this.uiCodeSuffixPrompts);
        var partiallyProcessedAIRequest={
            messages:aiMessagesBuilder.aiMessages
        };
        var context=this._getContextForRequest(partiallyProcessedAIRequest);
        if(context.errorMessage)return isc.rejectWithError(context.errorMessage);
        var shouldUseFieldPaging=context.aiEngine.shouldUseAIFieldPaging(partiallyProcessedAIRequest,fields,buildContext._aiConfig);
        if(!shouldUseFieldPaging){
            return this._asyncBuildDataBoundUIWithFinalFields(fields,partiallyProcessedAIRequest,buildContext);
        }
        ++buildContext._estimatedNumTotalSteps;
        this._fireAIProgressCallback(buildContext,[{category:"detail",content:isc.AI.willSubsetFieldsDetailMessage}],true);
        return context.aiEngine.asyncRetrieveFieldsForPrompt(
                partiallyProcessedAIRequest.messages,
                "Build a component to show data from a dataSource",
                fields,
                context,
                buildContext._aiConfig)
            .then(function(finalFields){
                ++buildContext._numStepsCompleted;
                this._fireAIProgressCallback(buildContext,[{category:"success",content:isc.AI.finishedSubsettingFieldsDetailMessage}]);
                return isc.AI._asyncBuildDataBoundUIWithFinalFields(
                        finalFields,partiallyProcessedAIRequest,buildContext);
            });
    }
,isc.A._asyncBuildDataBoundUIWithFinalFields=function isc_c_AI__asyncBuildDataBoundUIWithFinalFields(finalFields,partiallyProcessedAIRequest,buildContext){
        if(buildContext._ownCC.canceled){
            return Promise.reject(buildContext._ownCC.asCanceledResult());
        }
        if(finalFields==null||(finalFields.removeEmpty(),finalFields).isEmpty()){
            return isc.rejectWithError("No fields were selected for use in building the data-bound UI.");
        }
        buildContext._dsFinalFields=finalFields;
        var dsSummary=this.summarizeDataSource(buildContext.dataSource,finalFields,buildContext._aiConfig,false);
        var evalVars={
            dsSummary:dsSummary
        };
        var aiRequest={
            cancellationController:buildContext._ownCC,
            messages:partiallyProcessedAIRequest.messages.map(function(message){
                if(message.source=="system"&&isc.AIEngine._isTextContentType(message.type)){
                    return{
                        source:message.source,
                        content:String(message.content).evalDynamicString(this,evalVars)
                    };
                }
                return message;
            },this)
        };
        return this.asyncSendRequest(aiRequest,buildContext._aiConfig)
            .then(function(aiResponse){
                if(buildContext._ownCC.canceled){
                    return Promise.reject(buildContext._ownCC.asCanceledResult());
                }
                var content=aiResponse.message.content||"";
                var jsCode=String.prototype.trim.call(isc.AI.extractFencedCode(content));
                if(jsCode==""){
                    return isc.rejectWithError("AI did not generate any UI code.");
                }
                ++buildContext._numStepsCompleted;
                isc.AI._fireAIProgressCallback(buildContext,[{category:"success",content:"AI generated UI code. Will now validate\u2026"}]);
                buildContext.jsCode=jsCode;
                isc.AI._validateAIBuiltUI(buildContext);
                return buildContext._validationResolversObj.promise;
            });
    }
,isc.A.buildDataUI=function isc_c_AI_buildDataUI(userPrompt,callback,context,aiConfig){
        var error;
        var buildRequest={
            userAIRequest:{prompt:userPrompt}
        };
        if(context==null){
            error="context is required to build a dataUI";
        }else{
            buildRequest.availableDataSources=context.dataSources;
        }
        if(error==null){
            buildRequest.allowedUITypes=context.uiTypeNames;
        }
        var callbackArgNames="status,result,context";
        if(error!=null){
            return this.fireCallback(callback,callbackArgNames,[-1,error,context]);
        }
        this.getEngine().buildDataBoundUI(buildRequest,function(buildResponse){
            error=buildResponse.errorMessage;
            if(error!=null){
                isc.AI.fireCallback(callback,callbackArgNames,[-1,error,context]);
            }else{
                isc.AI.fireCallback(callback,callbackArgNames,[0,buildResponse.jsCode,context]);
            }
        });
    }
,isc.A.extractFencedCode=function isc_c_AI_extractFencedCode(string){
        var result=string.match(this.fencedCodeRegex);
        if(result==null||result.length<2)return string;
        return result[1];
    }
,isc.A.getAIModel=function isc_c_AI_getAIModel(engineId){
        var engine=isc.AI.getEngine(engineId);
        return engine.model;
    }
,isc.A.loadDataSource=function isc_c_AI_loadDataSource(dataSourceName){
        if(isc.DS.get(dataSourceName)){
            this.dataSourceLoaded(dataSourceName);
            return;
        }
        if(!dataSourceName||this._loadingDS[dataSourceName])return;
        this._loadingDS[dataSourceName]=true;
        isc.DS.load(dataSourceName,{target:this,methodName:"dataSourceLoaded"},{loadParents:true});
    }
,isc.A.dataSourceLoaded=function isc_c_AI_dataSourceLoaded(dsID){
        delete this._loadingDS[dsID];
        var ds=this.dataSources[dsID]=isc.DataSource.get(dsID);
        if(ds==null){
            this._loadDSFailed[dsID]=true;
            isc.AI.logError("DataSource '"+dsID+"' not found or could not be loaded for AI request - cannot continue","AI");
        }else{
            var pendingRequests=this._pendingRequests;
            this._pendingRequests=[];
            for(var i=0;i<pendingRequests.length;i++){
                var pendingRequest=pendingRequests[i];
                pendingRequest.engine.handleSendRequest(
                    pendingRequest.rawRequest,
                    pendingRequest.aiRequest,
                    pendingRequest.callback,
                    pendingRequest.config
                );
            }
        }
    }
,isc.A._getDataSource=function isc_c_AI__getDataSource(engineId,aiRequest){
        var engine=isc.AI.getEngine(engineId),
            dataSourceName=engine.getDataSourceName(aiRequest),
            dataSource=this.dataSources[dataSourceName];
        var ds=this.dataSources[dataSourceName];
        if(ds&&!ds._hasSpoofedResponseTransformer){
            ds.addProperties({
                _hasSpoofedResponseTransformer:true,
                _explicitTransformRequest:ds.transformRequest,
                transformRequest:function(dsRequest){
                    if(this._explicitTransformRequest){
                        var data=this._explicitTransformRequest(dsRequest);
                    }
                    if(dsRequest.dataProtocol=="clientCustom"){
                        var context=dsRequest.clientContext;
                        if(context&&
                            (context.spoofingMode=="full"||
                             context.spoofedResponse!=null))
                        {
                            isc.AI.createSpoofedResponse(dsRequest);
                        }
                    }
                    return data;
                }
            });
        }
        return ds;
    }
,isc.A.createSpoofedResponse=function isc_c_AI_createSpoofedResponse(dsRequest){
        var context=dsRequest.clientContext;
        if(context.spoofedResponse==null||context.spoofingMode=="full"){
            this.promptForSpoofedResponse(dsRequest);
        }else{
            if(context.spoofedResponse.deferProcessSpoofedResponse){
                if(context.spoofedResponse.dsRequest){
                    this.processSpoofedResponse(context.spoofedResponse.dsRequest,context.spoofedResponse);
                }
                context.spoofedResponse.dsRequest=dsRequest;
            }else{
                var spoofedResponseSpecifiesDelay=context.spoofedResponse.getDelay||isc.isA.Number(context.spoofedResponse.delay);
                this.delayCall(
                    "processSpoofedResponse",
                    [dsRequest,context.spoofedResponse],
                    spoofedResponseSpecifiesDelay?0:this.spoofedResponseDelay
                );
            }
        }
    }
,isc.A.processSpoofedResponse=function isc_c_AI_processSpoofedResponse(dsRequest,spoofedResponse){
        if(dsRequest===spoofedResponse.dsRequest){
            delete spoofedResponse.dsRequest;
        }
        if(!spoofedResponse.deferProcessSpoofedResponse&&
            (spoofedResponse.getDelay||isc.isA.Number(spoofedResponse.delay)))
        {
            var delay;
            if(spoofedResponse.getDelay){
                var clientContext=dsRequest.clientContext;
                delay=spoofedResponse.getDelay(clientContext.aiRequest,clientContext.aiEngine);
            }else{
                delay=spoofedResponse.delay;
            }
            this.delayCall("_processSpoofedResponse",[dsRequest,spoofedResponse],delay);
        }else{
            this._processSpoofedResponse(dsRequest,spoofedResponse);
        }
    }
,isc.A._processSpoofedResponse=function isc_c_AI__processSpoofedResponse(dsRequest,spoofedResponse){
        dsRequest.clientContext.dataSource.processResponse(
            dsRequest.requestId,
            {
                _isSpoofed:true,
                status:0,
                data:spoofedResponse
            }
        );
    }
,isc.A.promptForSpoofedResponse=function isc_c_AI_promptForSpoofedResponse(dsRequest){
        var context=dsRequest.clientContext;
        var spoofedResponseForm=isc.DynamicForm.create({
            autoDraw:false,
            width:"100%",height:"*",
            numCols:1,
            titleOrientation:top,
            items:[
                {editorType:"HeaderItem",
                    value:context.aiEngine.name+" Request"
                },
                {
                    name:"prompt",
                    titleOrientation:"top",
                    value:context.aiRequest.prompt,
                    width:"*"
                },
                {name:"messages",
                    titleOrientation:"top",
                    editorType:"CanvasItem",
                    width:"*",height:"*",minHeight:400,
                    shouldSaveValue:true,
                    value:context.aiRequest.messages,
                    createCanvas:function(){
                        var messagesGrid=this._messagesGrid=isc.ListGrid.create({
                            _canvasItem:this,
                            autoDraw:false,
                            width:"100%",height:"100%",
                            canEdit:true,
                            canFilter:false,
                            canSort:false,
                            canGroupBy:false,
                            canRemoveRecords:true,
                            canReorderFields:false,
                            wrapCells:true,
                            fixedRecordHeights:false,
                            alternateRecordStyles:true,
                            bodyProperties:{
                                nativeAutoHideScrollbars:false
                            },
                            fields:[{
                                name:"source",
                                title:"Source",
                                width:100,
                                valueMap:["user","system","AI"]
                            },{
                                name:"content",
                                title:"Content",
                                width:"*",
                                editorType:"TextAreaItem",
                                editorProperties:{
                                    minHeight:100,
                                    canHover:false
                                },
                                formatCellValue:function(value,record,rowNum,colNum,grid){
                                    if(!value)return"";
                                    if(record.type=="jpegImage"||
                                        record.type=="pngImage")
                                    {
                                        var mimeType=isc.AIEngine._getMIMEType(record),
                                            contentWidth=grid.getColumnWidth(1);
                                        return"<img src='data:"+mimeType+";base64,"+value.asHTML()+"' "+
                                                    "style='width:"+contentWidth+"px'>";
                                    }else if(isc.isAn.Object(value)){
                                        return isc.JSON.encode(value,{dateFormat:"logicalDateString"});
                                    }
                                    return String(value).asHTML();
                                }
                            }],
                            getEditorType:function(field,values){
                                if(field.name=="content"&&values&&isc.AIEngine.isImageMessage(values)){
                                    return"Base64ImageDataItem";
                                }
                                return this.Super("getEditorType",arguments);
                            },
                            getEditorProperties:function(editField,editedRecord,rowNum){
                                var editorProperties=this.Super("getEditorProperties",arguments);
                                if(editField.name=="content"&&editedRecord&&isc.AIEngine.isImageMessage(editedRecord)){
                                    editorProperties.accept="image/jpeg,image/png";
                                    editorProperties.mimeType=isc.AIEngine._getMIMEType(editedRecord);
                                    editorProperties.changed=function(form,item,value){
                                        var mimeType=this.mimeType,
                                            editSession=this.grid.getEditSession(rowNum);
                                        editSession._editValues.type=mimeType=="image/jpeg"?"jpegImage":"pngImage";
                                    };
                                }
                                return editorProperties;
                            },
                            getCellVAlign:function(record,rowNum,colNum){
                                return(colNum==0?"top":"center");
                            },
                            dataChanged:function(){
                                this._canvasItem.storeValue(this.data);
                            }
                        });
                        var addMessageButton=isc.Button.create({
                            autoDraw:false,
                            title:"+",
                            autoFit:true,
                            click:function(){
                                messagesGrid.startEditingNew();
                            }
                        });
                        return isc.VLayout.create({
                            autoDraw:false,
                            width:"100%",height:"100%",
                            members:[messagesGrid,addMessageButton]
                        });
                    },
                    showValue:function(displayValue,dataValue){
                        if(this._messagesGrid==null)return;
                        this._messagesGrid.setData(dataValue);
                    }
                },
                {editorType:"HeaderItem",
                    value:"Response"
                },
                {editorType:"ButtonItem",
                    title:"Generate AI Response",
                    click:function(form){
                        var messagesItem=form.getItem("messages"),
                            messagesGrid=messagesItem._messagesGrid;
                        if(messagesGrid)messagesGrid.endEditing();
                        var processResponseButton=form.getItem("_processResponseButton");
                        if(processResponseButton)processResponseButton.disable();
                        context.aiEngine.sendRequest(
                            isc.addProperties({},context.aiRequest,{
                                prompt:form.getValue("prompt"),
                                messages:messagesItem.getValue()
                            }),
                            function(aiResponse,aiRequest){
                                if(processResponseButton)processResponseButton.enable();
                                var message=aiResponse.message&&aiResponse.message.content;
                                if(aiResponse.message&&(aiResponse.message.type=="array"||aiResponse.message.type=="object")){
                                    message=isc.JSON.encode(message);
                                }
                                form.setValue("response",message);
                            },
                            {
                                responseSpoofingMode:"none",
                                context:{doNotCapture:true}
                            }
                        );
                    }
                },
                {name:"response",
                    editorType:"TextAreaItem",showTitle:false,
                    width:"*",height:100,
                    value:(context.spoofedResponse?context.spoofedResponse.value:null)
                },
                {
                    name:"_processResponseButton",
                    editorType:"ButtonItem",
                    title:"Process Response",
                    click:function(){
                        isc.AI.delayCall("processSpoofedResponse",[dsRequest,{value:this.form.getValue("response")}]);
                        this.form.parentWindow.markForDestroy();
                    }
                }
            ]
        });
        var spoofedResponseWindow=isc.Window.create({
            title:"Create AI Response",
            width:700,height:"90%",
            canDragResize:false,
            autoCenter:true,
            showCloseButton:false,
            items:[spoofedResponseForm],
            bodyProperties:{
                alwaysShowScrollbars:true
            }
        });
        spoofedResponseForm.parentWindow=spoofedResponseWindow;
        spoofedResponseWindow.show();
    }
);
isc.evalBoundary;isc.B.push(isc.A.setDefaultSpoofedResponse=function isc_c_AI_setDefaultSpoofedResponse(responseString){
        this._defaultSpoofedResponse=responseString==null?null:{value:responseString};
    }
,isc.A.captureTransaction=function isc_c_AI_captureTransaction(transaction){
        if(!this.captureTransactions)return;
        if(this.capturedTransactions==null)this.capturedTransactions=[];
        isc.AI.capturedTransactions.push(transaction);
    }
,isc.A.clearCapturedTransactions=function isc_c_AI_clearCapturedTransactions(){
        this.captureTransactions=[];
    }
,isc.A.persistCapturesToOfflineStorage=function isc_c_AI_persistCapturesToOfflineStorage(offlineKey){
        isc.Offline.put(
            offlineKey||this._captureOfflineStorageKey,
            isc.JSON.encode(
                this.capturedTransactions.getProperties(["prompt","value"])
            )
        );
    }
,isc.A.setupSpoofInteractionFromCapturedTransactions=function isc_c_AI_setupSpoofInteractionFromCapturedTransactions(capture,matchesPromptFunction){
        if(matchesPromptFunction!=null){
            for(var i=0;i<capture.length;i++){
                capture[i].matchesPrompt=matchesPromptFunction;
            }
        }
        this.addSpoofedResponses(capture);
    }
,isc.A.setupSpoofInteractionFromOfflineStorage=function isc_c_AI_setupSpoofInteractionFromOfflineStorage(matchesPromptFunction,offlineKey){
        var capture=isc.JSON.decode(isc.Offline.get(offlineKey||this._captureOfflineStorageKey));
        if(capture==null){
            this.logWarn("Unable to retrieve AI transaction captures from previous session");
            return;
        }else{
            this.logWarn("Setting up spoofed responses for "+capture.length+" AI transaction captures from previous session");
        }
        this.setupSpoofInteractionFromCapturedTransactions(capture,matchesPromptFunction);
    }
,isc.A.addSpoofedResponses=function isc_c_AI_addSpoofedResponses(responses){
        this._spoofedResponseRegistry.addList(responses);
    }
,isc.A.addSpoofedResponse=function isc_c_AI_addSpoofedResponse(response){
        this._spoofedResponseRegistry.add(response);
    }
,isc.A.clearSpoofedResponses=function isc_c_AI_clearSpoofedResponses(){
        this._spoofedResponseRegistry=[];
    }
,isc.A.removeSpoofedResponse=function isc_c_AI_removeSpoofedResponse(response){
        var index=this._spoofedResponseRegistry.findIndex(response);
        if(index!=-1){
            this._spoofedResponseRegistry.removeAt(index);
        }
    }
,isc.A.removeSpoofedResponses=function isc_c_AI_removeSpoofedResponses(responses){
        this._spoofedResponseRegistry.removeList(responses);
    }
,isc.A.getSpoofedResponse=function isc_c_AI_getSpoofedResponse(aiRequest,aiEngine){
        var prompt=aiEngine.makePromptText(aiRequest);
        for(var registryIndex=0;registryIndex<this._spoofedResponseRegistry.length;++registryIndex){
            var response=this._spoofedResponseRegistry[registryIndex];
            var match=false;
            if(isc.isA.Number(response.numMatchesRemaining)){
                if(response.numMatchesRemaining<=0)continue;
            }else if(response.singleUse){
                response.numMatchesRemaining=1;
            }
            if(response.matchesPrompt!=null){
                match=response.matchesPrompt(prompt,response);
            }else if(response.prompt!=null){
                var textMatchStyle=response.textMatchStyle||"iContains",
                    comparePrompt=textMatchStyle.startsWith("i")?prompt.toLowerCase():prompt,
                    compareVal=textMatchStyle.startsWith("i")?response.prompt.toLowerCase():response.prompt;
                switch(textMatchStyle){
                    case"contains":
                    case"iContains":
                        match=comparePrompt.contains(compareVal);
                        break;
                    case"startsWith":
                    case"iStartsWith":
                        match=comparePrompt.startsWith(compareVal);
                        break;
                    case"endsWith":
                    case"iEndsWith":
                        match=comparePrompt.endsWith(compareVal);
                        break;
                    case"equals":
                    case"iEquals":
                    default:
                        match=(comparePrompt==compareVal);
                        break;
                }
            }
            if(match){
                if(isc.isA.Number(response.numMatchesRemaining))--response.numMatchesRemaining;
                if(isc.isAn.Object(response.value)){
                    response.value=isc.JSON.encode(response.value,{dateFormat:"logicalDateString"});
                }
                return response;
            }
        }
        if(this._defaultSpoofedResponse!=null)return this._defaultSpoofedResponse;
    }
,isc.A.getInitiatorMessage=function isc_c_AI_getInitiatorMessage(promptContext){
        var dataSourceSummary=this.getDataSourceDefinitions();
        var uiSummaryContext=this.getUISummary(true);
        var uiSummary=uiSummaryContext[0];
        if(promptContext!=null){
            promptContext.idMapping=uiSummaryContext[1];
        }
        var userAgent=navigator.userAgent;
        var systemPrompt=this.initiatorPromptTemplate.evalDynamicString();
        systemPrompt+=this.getApplicationOverviewPrompt(dataSourceSummary,uiSummary,userAgent);
        return{source:"system",content:systemPrompt,type:"text"};
    }
,isc.A.getApplicationOverviewPrompt=function isc_c_AI_getApplicationOverviewPrompt(dataSourceSummary,uiSummary,userAgent){
        var summary="** SmartClient application and environment information **\n";
        if(this.isShowcase){
            summary+="The user is interacting with a sample application user interface with the following description:\n\n";
            summary+=window["featureExplorer_exampleDescription"].getContents()+"\n\n";
        }
        summary+="Partial code for the DataSources present in this application is below, with only important properties shown:\n";
        summary+=dataSourceSummary+"\n\n";
        summary+="Partial code for the currently visible UI of the application is below, with only important properties shown.\n"+
                   "Components listed in this summary may be referenced directly by their \"ID\" property or by passing that ID to \"isc.Canvas.getById()\".\"\n\n"
        summary+=uiSummary+"\n\n";
        summary+="The SmartClient version is \""+isc.version+
                   "\" and the browser's userAgent is \""+userAgent+"\".\n";
        return summary;
    }
,isc.A.handleAITransportError=function isc_c_AI_handleAITransportError(transaction,status,httpResponseCode,httpResponseText){
        var URL=transaction.URL||"";
        if(URL.startsWith("https://api.openai.com/")){
            return true;
        }else{
            return false;
        }
    }
,isc.A.asyncSuggestRecordSummaryTitle=function isc_c_AI_asyncSuggestRecordSummaryTitle(request){
        return this._asyncDataBoundAIOperation("_asyncSuggestRecordSummaryTitle",request);
    }
,isc.A.suggestRecordSummaryTitle=function isc_c_AI_suggestRecordSummaryTitle(request,callback){
        this._wrapAsyncDataBoundAIOperation("asyncSuggestRecordSummaryTitle",request,callback);
    }
,isc.A._asyncSuggestRecordSummaryTitle=function isc_c_AI__asyncSuggestRecordSummaryTitle(request,dabOpContext){
        var ssAIRequest=request.aiRequest;
        if(!ssAIRequest){
            return isc.rejectWithError(isc.AsyncUtil.missingRequiredParameterErrorMessage.evalDynamicString(this,{paramName:"aiRequest"}));
        }
        var dataSource=dabOpContext.dataSource;
        if(!dataSource){
            return isc.rejectWithError(isc.AsyncUtil.missingRequiredParameterErrorMessage.evalDynamicString(this,{paramName:"dataSource"}));
        }
        var ssMessages=[{content:ssAIRequest.prompt,type:ssAIRequest.promptType}],
            additionalMessages=ssAIRequest.additionalMessages;
        if(additionalMessages){
            ssMessages.addList(additionalMessages);
            ssMessages.removeEmpty();
        }
        var summarizedSSMessages=ssMessages;
        var visibleFieldNames=request.visibleFieldNames,
            visibleAvailableFields;
        if(!visibleFieldNames){
            var componentVisibleFields;
            if(dabOpContext.component&&(componentVisibleFields=dabOpContext.component.getVisibleFields())){
                var componentVisibleFieldNames=componentVisibleFields.getProperty("name");
                visibleAvailableFields=isc.getValues(isc.applyMask(dabOpContext.availableFieldsIndex,componentVisibleFieldNames));
            }else{
                visibleAvailableFields=dabOpContext.availableFields.duplicate();
            }
        }else{
            var availableFieldNames=dabOpContext.availableFieldNames;
            for(var i=0;i<visibleFieldNames.length;++i){
                var visibleFieldName=visibleFieldNames[i];
                if(!availableFieldNames.contains(visibleFieldName)&&
                    !visibleFieldNames.contains(visibleFieldName,i+1))
                {
                    this.logWarn("'"+visibleFieldName+"' was specified in the list of visible field names, but there is no such available field.","AI");
                }
            }
            visibleAvailableFields=isc.getValue(isc.applyMask(dabOpContext.availableFieldsIndex,visibleFieldNames));
        }
        if(visibleAvailableFields){
            for(var ri=visibleAvailableFields.length;ri>0;--ri){
                var i=ri-1,
                    visibleField=visibleAvailableFields[i],
                    visibleFieldName=visibleField.name,
                    visibleFieldTitle=visibleField.title;
                if(!isc.isA.nonemptyString(visibleFieldName)||
                    !isc.isA.String(visibleFieldTitle)||isc.isAn.emptyString(visibleFieldTitle.trim())||
                    visibleField.canView==false||
                    visibleField.hidden==true)
                {
                    visibleAvailableFields.removeAt(i);
                }
            }
            if(visibleAvailableFields.isEmpty())visibleAvailableFields=null;
        }
        var aiMessagesBuilder=isc.InternalAIMessagesBuilder2.create({
            ssMessages:summarizedSSMessages,
            messagesSource:request.aiRequestSource,
            target:this,
            evalVars:{
                dsSummary:"${dsSummary}",
                dsName:dataSource.ID
            }
        });
        aiMessagesBuilder.appendPrompts(this.suggestRecordSummaryTitlePrompts);
        if(visibleAvailableFields){
            var titleForName={};
            for(var i=0;i<visibleAvailableFields.length;++i){
                var visibleField=visibleAvailableFields[i];
                titleForName[visibleField.name]=visibleField.title;
            }
            aiMessagesBuilder.appendPrompt(this.suggestRecordSummaryTitlePrompts_visibleFields+this._encodeJSON(titleForName));
        }else{
            aiMessagesBuilder.appendPrompt(this.suggestRecordSummaryTitlePrompts_noVisibleFields);
        }
        aiMessagesBuilder.appendPrompt(this.suggestRecordSummaryTitlePrompts_final);
        var partiallyProcessedAIRequest={
            messages:aiMessagesBuilder.aiMessages,
            responseType:"object"
        };
        var finalFields=dabOpContext.availableFields,
            finalFieldNames=dabOpContext.availableFieldNames;
        var dsSummary=this.summarizeDataSource(dataSource,finalFields,{format:"compactJSON"},false);
        var evalVars={
            dsSummary:dsSummary
        };
        var aiRequest={
            cancellationController:dabOpContext.cancellationController,
            messages:partiallyProcessedAIRequest.messages.map(function(message){
                if(message.source=="system"&&isc.AIEngine._isTextContentType(message.type)){
                    return{
                        source:message.source,
                        content:String(message.content).evalDynamicString(this,evalVars)
                    };
                }
                return message;
            },this),
            responseType:partiallyProcessedAIRequest.responseType
        };
        var context=this._getContextForRequest(partiallyProcessedAIRequest);
        if(context.errorMessage)return isc.rejectWithError(context.errorMessage);
        var aiConfig={
            maxRetries:request.maxRetries
        };
        return context.aiEngine.asyncSendRequest(aiRequest,aiConfig)
            .then(function(aiResponse){
                var responseObject=aiResponse.message.content,
                    suggestedTitle;
                if(!isc.isAn.Object(responseObject)||
                    !isc.isA.String(responseObject.suggestedTitle)||
                    !(suggestedTitle=responseObject.suggestedTitle.trim()))
                {
                    return isc.rejectWithError(isc.AI.aiNotAbleToProcessRequestErrorMessage);
                }
                return{
                    type:"success",
                    suggestedTitle:suggestedTitle,
                    relevantFieldNames:finalFieldNames
                };
            });
    }
,isc.A.isAIFieldRequestNumerical=function isc_c_AI_isAIFieldRequestNumerical(aiFieldRequest){
        var valueClass=aiFieldRequest.valueClass;
        return valueClass=="ordinal"||valueClass=="interval"||valueClass=="ratio";
    }
,isc.A._createBuildAIFieldRequestContext=function isc_c_AI__createBuildAIFieldRequestContext(asyncMethodName,buildRequest,dabOpContext){
        var buildContext=this._createBuildViaAIContext(asyncMethodName,
                                                         buildRequest,
                                                         dabOpContext);
        buildContext.dabOpContext=dabOpContext;
        if(buildRequest.showProgressDialog==true){
            buildContext._progressDialog=isc.BuildViaAIProgressDialog.create(buildRequest.progressDialogProperties,{
                _buildContext:buildContext,
                canCancel:buildRequest.userCanCancel!=false
            });
            buildContext._progressDialog.show();
        }
        buildContext._estimatedNumTotalSteps=1;
        this._fireAIProgressCallback(buildContext,[{category:"detail",content:isc.AI.startingYourRequestDetailMessage}]);
        return buildContext;
    }
,isc.A.buildAIFieldRequest=function isc_c_AI_buildAIFieldRequest(buildRequest,callback){
        this._wrapAsyncBuildViaAIOperation(this._$asyncBuildAIFieldRequest,buildRequest,callback);
    }
,isc.A.asyncBuildAIFieldRequest=function isc_c_AI_asyncBuildAIFieldRequest(buildRequest){
        return this._asyncDataBoundAIOperation("_asyncBuildAIFieldRequest",buildRequest);
    }
,isc.A._asyncBuildAIFieldRequest=function isc_c_AI__asyncBuildAIFieldRequest(buildRequest,dabOpContext){
        if(!buildRequest.userAIRequest){
            return isc.rejectWithError(isc.AsyncUtil.missingRequiredParameterErrorMessage.evalDynamicString(this,{paramName:"userAIRequest"}));
        }
        var dataSource=dabOpContext.dataSource;
        if(!dataSource){
            return isc.rejectWithError(isc.AsyncUtil.missingRequiredParameterErrorMessage.evalDynamicString(this,{paramName:"dataSource"}));
        }
        var buildContext=this._createBuildAIFieldRequestContext(this._$asyncBuildAIFieldRequest,buildRequest,dabOpContext);
        this.__asyncBuildAIFieldRequest(buildRequest,dabOpContext,buildContext)
            .then(function(aiFieldRequest){
                buildContext._resolversObj.resolve({type:"success",aiFieldRequest:aiFieldRequest});
            },function(rejectReason){
                buildContext._resolversObj.reject(isc.defaultAsyncOperationCatchCallback(rejectReason));
            });
        return buildContext._resolversObj.promise;
    }
,isc.A.__asyncBuildAIFieldRequest=function isc_c_AI___asyncBuildAIFieldRequest(buildRequest,dabOpContext,buildContext){
        var dataSource=dabOpContext.dataSource,
            dsName=dataSource.getID(),
            availableFields=dabOpContext.availableFields,
            availableFieldNames=dabOpContext.availableFieldNames,
            userAIRequest=buildRequest.userAIRequest;
        if(!isc.AIEngine._isTextContentType(userAIRequest.promptType)||
            isc.isA.nonemptyArray(userAIRequest.additionalMessages))
        {
            throw isc.createErrorResult("A non-text and/or multiple-message 'aiFieldPrompt' is not currently supported.");
        }
        var aiFieldPrompt=userAIRequest.prompt;
        var evalVars={
            dataSource:dataSource,
            dsName:dsName,
            fields:availableFields,
            aiFieldPrompt:aiFieldPrompt
        };
        evalVars.dsSummary=this.render("summarizeDataSource",evalVars);
        let dsSampleData=dataSource.sampleData;
        if(evalVars.haveSampleData=isc.isA.nonemptyArray(dsSampleData)){
            dsSampleData=isc.shallowClone(dsSampleData);
            for(let r=0;r<dsSampleData.length;++r){
                const sampleRecord=dsSampleData[r];
                for(let n=0;n<availableFieldNames.length;++n){
                    const fieldName=availableFieldNames[n];
                    if(!Object.hasOwn(sampleRecord,fieldName)){
                        sampleRecord[fieldName]=null;
                    }
                }
            }
            dsSampleData=isc.applyMask(dsSampleData,availableFieldNames);
            const numSamples=dsSampleData.length;
            evalVars.dsSummary+="\n\nHere is a sample of "+numSamples+" "+
                "record".pluralize(numSamples)+" (sample data) from the '"+dsName+"' DataSource:\n"+
                isc.JSON.encode(dsSampleData,{
                    prettyPrint:false,
                    strictQuoting:true,
                    dateFormat:"xmlSchema",
                    circularReferenceMode:"omit"
                });
        }
        var aiRequestProperties={
            cancellationController:buildContext._ownCC,
            responseType:"object"
        };
        var finalFieldNames=availableFieldNames,
            summarizedAIFieldPrompt=aiFieldPrompt;
        return this.asyncSendPrompt(this.buildAIFieldRequestTemplatedString,evalVars,buildContext._aiConfig,aiRequestProperties)
            .then(function(aiResponse){
                var responseObject=aiResponse.message.content;
                if(!isc.isAn.Object(responseObject)){
                    return isc.rejectWithError(isc.AI.aiNotAbleToProcessRequestErrorMessage);
                }
                var relevantFieldNames=responseObject.relevantFieldNames,
                    finalRelevantFieldNames;
                if(isc.isA.String(relevantFieldNames))relevantFieldNames=[relevantFieldNames];
                if(!isc.isAn.Array(relevantFieldNames)){
                    finalRelevantFieldNames=finalFieldNames;
                }else{
                    finalRelevantFieldNames=[];
                    for(var i=0;i<relevantFieldNames.length;++i){
                        var fieldName=relevantFieldNames[i];
                        if(fieldName==null||isc.isAn.Object(fieldName))continue;
                        fieldName=String(fieldName).trim();
                        if(finalFieldNames.contains(fieldName)&&
                            !finalRelevantFieldNames.contains(fieldName))
                        {
                            finalRelevantFieldNames.push(fieldName);
                        }
                    }
                    if(finalRelevantFieldNames.isEmpty()){
                        finalRelevantFieldNames=finalFieldNames;
                    }
                }
                relevantFieldNames=finalRelevantFieldNames;
                var valueClass=responseObject.valueClass;
                if(valueClass!="categorical"&&
                    valueClass!="ordinal"&&
                    valueClass!="interval"&&
                    valueClass!="ratio")
                {
                    valueClass="general";
                }
                var categories,
                    categoryHints;
                if(valueClass=="categorical"||valueClass=="ordinal"){
                    var dataDependentReason=responseObject.dataDependentReason;
                    if(dataDependentReason&&(dataDependentReason=dataDependentReason.trim())){
                        isc.AI.logWarn("AI specified a reason for data-dependence: "+dataDependentReason,"AI");
                    }
                    categories=responseObject.categories;
                    if(isc.isAn.Array(categories)){
                        var finalCategories=[];
                        for(var i=0;i<categories.length;++i){
                            var category=categories[i];
                            if(category==null||isc.isAn.Object(category))continue;
                            category=String(category);
                            if(!(category=category.trim())){
                                isc.AI.logWarn("AI generated an empty string as a category.","AI");
                                continue;
                            }
                            if(finalCategories.contains(category)){
                                isc.AI.logWarn("AI generated duplicate category '"+category+"'.","AI");
                                continue;
                            }
                            finalCategories.push(category);
                        }
                        categories=finalCategories;
                        categoryHints={};
                        if(isc.isAn.Object(responseObject.categoryHints)){
                            for(var category in responseObject.categoryHints){
                                if(!Object.hasOwn(responseObject.categoryHints,category))continue;
                                var hint=responseObject.categoryHints[category];
                                if(!(category=category.trim()))continue;
                                if(!categories.contains(category)){
                                    isc.AI.logWarn("AI generated a hint for non-existent category '"+category+"'.","AI");
                                    continue;
                                }
                                if(!isc.isA.String(hint)){
                                    isc.AI.logWarn("AI generated a non-string hint for category '"+category+"'.","AI");
                                    continue;
                                }
                                if(!(hint=hint.trim()))continue;
                                categoryHints[category]=hint;
                            }
                        }
                    }
                    if(!isc.isAn.Array(categories)||categories.isEmpty()){
                        categoryHints=categories=null;
                        valueClass="general";
                    }
                }
                var minValue,
                    maxValue;
                if(valueClass=="interval"||valueClass=="ratio"){
                    minValue=parseFloat(responseObject.minValue);
                    if(!isc.isA.Number(minValue))minValue=null;
                    maxValue=parseFloat(responseObject.maxValue);
                    if(!isc.isA.Number(maxValue))maxValue=null;
                    else if(isc.isA.Number(minValue)&&minValue>maxValue){
                        isc.AI.logWarn("AI selected minValue = "+minValue+" greater than maxValue = "+maxValue+". Ignoring...","AI");
                        maxValue=minValue=null;
                    }
                }
                const displayDirection=responseObject.displayDirection;
                if(/most-to-least/i.test(displayDirection))responseObject.sortDirection="descending";
                else if(/least-to-most/i.test(displayDirection))responseObject.sortDirection="ascending";
                else delete responseObject.sortDirection;
                var sortDirection;
                if((valueClass=="ordinal"||valueClass=="interval"||valueClass=="ratio")&&
                    (responseObject.sortDirection=="ascending"||
                     responseObject.sortDirection=="descending"))
                {
                    sortDirection=responseObject.sortDirection;
                    if(valueClass=="ordinal"&&sortDirection=="descending"){
                        categories.reverse();
                        sortDirection="ascending";
                    }
                }
                return isc.addPropertiesWithAssign({},userAIRequest,{
                    summarizedAIFieldPrompt:summarizedAIFieldPrompt,
                    relevantFieldNames:relevantFieldNames,
                    valueClass:valueClass,
                    categories:categories,
                    categoryHints:categoryHints,
                    minValue:minValue,
                    maxValue:maxValue,
                    sortDirection:sortDirection
                });
            });
    }
,isc.A.applyAIFieldRequestToFieldDefaults=function isc_c_AI_applyAIFieldRequestToFieldDefaults(aiFieldRequest,field){
        this._assert(field.aiFieldRequest==null||field.aiFieldRequest===aiFieldRequest);
        field.aiFieldRequest=aiFieldRequest;
        var valueClass=aiFieldRequest.valueClass;
        if(valueClass=="categorical"||valueClass=="ordinal"){
            field.type="enum";
            field.valueMap=aiFieldRequest.categories;
            field.editorType="SelectItem";
        }else if(this.isAIFieldRequestNumerical(aiFieldRequest)){
            field.type="float";
            if(aiFieldRequest.minValue!=null||aiFieldRequest.maxValue!=null){
                var validators=field.validators;
                if(!validators)validators=field.validators=[];
                var additionalValidator;
                if(aiFieldRequest.minValue!=null){
                    supplyMinValidator:do{
                        for(var v=0;v<validators.length;++v){
                            var validator=validators[v];
                            if(validator.applyWhen!=null||
                                validator.serverOnly)
                            {
                                continue;
                            }
                            if(validator.type=="integerRange"||
                                validator.type=="floatLimit"||
                                validator.type=="floatRange")
                            {
                                if(isc.isA.Number(validator.min)&&
                                    aiFieldRequest.minValue<=validator.min)
                                {
                                    break supplyMinValidator;
                                }
                            }
                        }
                        additionalValidator={
                            type:"floatRange",
                            min:aiFieldRequest.minValue
                        };
                        validators.push(additionalValidator);
                    }while(false);
                }
                if(aiFieldRequest.maxValue!=null){
                    supplyMaxValidator:do{
                        for(var v=0;v<validators.length;++v){
                            var validator=validators[v];
                            if(validator.applyWhen!=null||
                                validator.serverOnly)
                            {
                                continue;
                            }
                            if(validator.type=="integerRange"||
                                validator.type=="floatLimit"||
                                validator.type=="floatRange")
                            {
                                if(isc.isA.Number(validator.max)&&
                                    aiFieldRequest.maxValue>=validator.max)
                                {
                                    break supplyMaxValidator;
                                }
                            }
                        }
                        if(additionalValidator!=null){
                            additionalValidator.max=aiFieldRequest.maxValue;
                        }else{
                            additionalValidator={
                                type:"floatRange",
                                max:aiFieldRequest.maxValue
                            };
                            validators.push(additionalValidator);
                        }
                    }while(false);
                }
            }
        }else{
            field.type="text";
        }
        field.sortDirection=aiFieldRequest.sortDirection;
        return field;
    }
,isc.A.asyncSummarizeRecords=function isc_c_AI_asyncSummarizeRecords(request,partialResultCallback){
        return this._asyncDataBoundAIOperation("_asyncSummarizeRecords",request,partialResultCallback);
    }
,isc.A.summarizeRecords=function isc_c_AI_summarizeRecords(request,partialResultCallback,callback){
        this._wrapAsyncDataBoundAIOperation("asyncSummarizeRecords",request,partialResultCallback,callback);
    }
);
isc.B._maxIndex=isc.C+78;

isc.AI.registerTemplates({
    summarizeRecordsPrompt_categorical:function(state,sc,j){
        return isc.trimDoc`
            In the context of an Isomorphic SmartClient application, this is a request to
            supplement the data in \${numRecords} \${'record'.pluralize(numRecords)} (given below) from
            the '${state.dataSource.getID()}' DataSource, using relevant general knowledge and
            your own reasonable inferences from the data.

            ${sc.render("summarizeDataSource", state)}

            For \${numRecords == 1 ? 'the' : 'each'} record given below, you are to select
            exactly one of the following categories:
            ${j(state.categories, true)}

            The descriptions of each category are:
            ${j(state.categoryHints, true)}

            The rule for selecting which category to apply to \${numRecords == 1 ? 'the' : 'each'} record is:
            <category-selection-rule>\${ssMessages}</category-selection-rule>

            Your response must be a single JSON object with the following properties:
            * "result" (array of \${numRecords} \${'string'.pluralize(numRecords)}):
              \${numRecords > 1 ? 'For each record, in the same corresponding order of the records,' : 'A single-element array of'} the category
              that you selected for the record.
            * "reasoning" (array of \${numRecords} \${'string'.pluralize(numRecords)}):
              \${numRecords > 1 ? 'For each record, in the same corresponding order of the records,' : 'A single-element array of'} a string containing
              a shortened summary of the following:
                - The reason why you selected the category for the record according to the category-selection-rule.
                - Any general knowledge that you used in making your selection.
                - Any assumptions that you made in this selection.
                - Any uncertainties that you have.

            Here \${numRecords == 1 ? 'is' : 'are'} the \${numRecords} \${'record'.pluralize(numRecords)}:`;
    }
});
isc.A=isc.AI;
isc.B=isc._allFuncs;
isc.C=isc.B._maxIndex;
isc.D=isc._funcClasses;
isc.D[isc.C]=isc.A.Class;
isc.A.summarizeRecordsPrompts_interval=[
        "This is a request to calculate a number for records from a DataSource, using "+
        "relevant general knowledge and your own reasonable inferences from the data. "+
        "The number to be calculated for each record is:",
        "${ssMessages}"
    ];
isc.A.summarizeRecordsPrompts_interval_minValue="The minimum value is ${minValue}. ";
isc.A.summarizeRecordsPrompts_interval_maxValue="The maximum value is ${maxValue}. ";
isc.A.summarizeRecordsPrompts_interval_final="The records specified below are from the DataSource with the following description: ${dsSummary}\n\n"+
        "Your response should be a single JSON object with one key \"result\" and value being "+
        "an array of just the calculated numbers for each corresponding record. "+
        "Here are the records:";
isc.A.canTranslateViaAI=true;
isc.A.componentActions={
        filter:{
            methodName:"buildFilter",
            description:"Apply filter criteria to the component"
        },
        hilite:{
            methodName:"buildHilite",
            description:"Apply hiliting to the component"
        },
        sort:{
            methodName:"buildSort",
            description:"Apply a sort to the component's data-rows and/or group-rows"
        },
        groupBy:{
            methodName:"buildGroupBy",
            description:"Group the components data by some field(s) or ungroup the component"
        },
        setFields:{
            methodName:"buildSetFields",
            description:"Change the visible set of fields for the component"
        }
    };
isc.A.multiActionAIWindowDefaults={
        _constructor:"Window",
        width:500,height:300,
        autoCenter:true,
        showHeaderIcon:true,
        headerIconProperties:{src:"AIAnswerEngine:size:22,22;"},
        showMinimizeButton:false,
        title:"Waiting for AI...",
        gridDefaults:{
            _constructor:"ListGrid",
            width:"100%",height:"100%",
            fixedRecordHeights:false,
            emptyMessage:"Determining tasks...   ",
            wrapCells:true,
            border:"none",
            canEdit:false,
            canShowFilterEditor:false,
            fields:[
                {name:"type",title:"Task",width:100},
                {name:"description",title:"Description",width:"*"},
                {name:"status",width:30,title:"",type:"image",align:"center"}
            ],
            initWidget:function(){
                var src=isc.Canvas.imgHTML(this.creator.workingIconSrc);
                this.emptyMessage+=src;
                this.fields[2].valueMap=[
                    this.creator.workingIconSrc,this.creator.successIconSrc,this.creator.failureIconSrc
                ];
                var result=this.Super("initWidget",arguments);
                return result;
            }
        },
        successIconSrc:"Accept",
        failureIconSrc:"Cancel",
        workingIconSrc:"Configure:cssClass:spinElement;",
        initWidget:function(){
            var result=this.Super("initWidget",arguments);
            this.grid=this.createAutoChild("grid");
            this.addItems([this.grid]);
        },
        setFirstAction:function(actionType,description){
            if(!actionType)this.grid.setData([]);
            else this.grid.setData([{type:actionType,description:description,status:this.workingIconSrc}]);
            this.grid.redraw();
        },
        addActions:function(actions){
            for(var key in actions){
                this.grid.addData({type:key,description:actions[key],status:this.workingIconSrc});
            }
            this.grid.redraw();
        },
        updateAction:function(actionType,status){
            for(var i=0;i<this.grid.data.length;i++){
                var record=this.grid.data[i];
                if(record.type==actionType){
                    record.status=status?this.successIconSrc:this.failureIconSrc;
                    this.grid.redraw();
                    return;
                }
            }
        }
    };
isc.B.push(isc.A._asyncSummarizeRecords=function isc_c_AI__asyncSummarizeRecords(request,partialResultCallback,dabOpContext){
        var aiFieldRequest=request.aiFieldRequest;
        if(!aiFieldRequest){
            return isc.rejectWithError(isc.AsyncUtil.missingRequiredParameterErrorMessage.evalDynamicString(this,{paramName:"aiFieldRequest"}));
        }
        var dataSource=dabOpContext.dataSource;
        if(!dataSource){
            return isc.rejectWithError(isc.AsyncUtil.missingRequiredParameterErrorMessage.evalDynamicString(this,{paramName:"dataSource"}));
        }
        var records=request.records;
        if(!records){
            return isc.rejectWithError(isc.AsyncUtil.missingRequiredParameterErrorMessage.evalDynamicString(this,{paramName:"records"}));
        }
        var maxRecordsPerBatch;
        if(aiFieldRequest.maxRecordsPerBatch){
            maxRecordsPerBatch=aiFieldRequest.maxRecordsPerBatch;
            if(request.maxRecordsPerBatch){
                maxRecordsPerBatch=Math.min(maxRecordsPerBatch,request.maxRecordsPerBatch);
            }
        }else{
            maxRecordsPerBatch=request.maxRecordsPerBatch;
        }
        var ssMessages=[{content:aiFieldRequest.prompt,type:aiFieldRequest.promptType}],
            additionalMessages=aiFieldRequest.additionalMessages;
        if(additionalMessages){
            ssMessages.addList(additionalMessages);
            ssMessages.removeEmpty();
        }
        var fields;
        if(!isc.isA.nonemptyArray(aiFieldRequest.relevantFieldNames)){
            fields=dabOpContext.availableFields;
            if(!isc.isA.nonemptyArray(fields)){
                return isc.rejectWithError("There are no available fields, so no record values can be sent to AI.");
            }
        }else{
            fields=isc.getValues(isc.applyMask(dabOpContext.availableFieldsIndex,aiFieldRequest.relevantFieldNames));
            if(fields.isEmpty()){
                return isc.rejectWithError("No available field is relevant. Therefore, no record values can be sent to AI.");
            }
        }
        var fieldNames=fields.getProperty("name");
        var evalVars={
            dataSource:dataSource,
            fields:fields,
            dsSummary:this.summarizeDataSource(dataSource,fields,{format:"compactJSON"},false)
        };
        var aiMessagesBuilder=isc.InternalAIMessagesBuilder2.create({
            ssMessages:ssMessages,
            messagesSource:request.aiFieldRequestSource,
            target:this,
            evalVars:evalVars
        });
        var valueClass=aiFieldRequest.valueClass,
            categories=aiFieldRequest.categories;
        if(valueClass=="interval"||valueClass=="ratio"){
            aiMessagesBuilder.appendPrompts(this.summarizeRecordsPrompts_interval);
            if(isc.isA.Number(aiFieldRequest.minValue)){
                if(isc.isA.Number(aiFieldRequest.maxValue)&&aiFieldRequest.minValue>aiFieldRequest.maxValue){
                    return isc.rejectWithError("`aiFieldRequest.minValue` cannot be greater than `aiFieldRequest.maxValue`.");
                }
                evalVars.minValue=aiFieldRequest.minValue;
                aiMessagesBuilder.appendPrompt(this.summarizeRecordsPrompts_interval_minValue);
            }
            if(isc.isA.Number(aiFieldRequest.maxValue)){
                evalVars.maxValue=aiFieldRequest.maxValue;
                aiMessagesBuilder.appendPrompt(this.summarizeRecordsPrompts_interval_maxValue);
            }
            aiMessagesBuilder.appendPrompt(this.summarizeRecordsPrompts_interval_final);
        }else if(valueClass=="categorical"||valueClass=="ordinal"){
            for(var i=0;i<categories.length;++i){
                var category=categories[i];
                if(!isc.isA.String(category)){
                    return isc.rejectWithError("Non-string category at index "+i+" within `aiFieldRequest.categories`.");
                }
                if(categories.contains(category,i+1)){
                    return isc.rejectWithError("Duplicate category '"+category+"' in `aiFieldRequest.categories`.");
                }
            }
            if(categories.isEmpty()){
                return isc.rejectWithError("No categories are defined.");
            }
            if(categories.length<2){
                return isc.rejectWithError("There must be at least two categories.");
            }
            var categoryHints=isc.applyMask(aiFieldRequest.categoryHints,categories);
            evalVars.categories=categories;
            evalVars.categoryHints=categoryHints;
            aiMessagesBuilder.renderTemplate("summarizeRecordsPrompt_categorical");
        }else{
            aiMessagesBuilder.appendPrompts(this.summarizeRecordsPrompts_general);
        }
        var nonNumerical=!this.isAIFieldRequestNumerical(aiFieldRequest);
        var templateAIRequest={
            cancellationController:dabOpContext.cancellationController,
            messages:aiMessagesBuilder.aiMessages,
            responseType:"object"
        };
        var repeatRequestSettings={
            cancellationController:dabOpContext.cancellationController,
            maxConcurrent:request.maxConcurrent,
            maxRecordsPerBatch:maxRecordsPerBatch,
            maxRetries:request.maxRetries==null?2:request.maxRetries,
            stopOnError:false,
            recordIndexFieldName:""
        };
        var partialResults=[];
        var summarizeRecordsContext={
            cancellationController:dabOpContext.cancellationController,
            request:request,
            partialResults:partialResults
        };
        var firstNonSuccess;
        return this.asyncRepeatRequestOnBatches(templateAIRequest,request.records,fieldNames,repeatRequestSettings,function(aiResponseForBatch){
            if(dabOpContext.cancellationController&&dabOpContext.cancellationController.canceled)return;
            var partialResult,
                partialResultCopy;
            if(aiResponseForBatch.type!="success"){
                if(!firstNonSuccess)firstNonSuccess=aiResponseForBatch;
                partialResult=aiResponseForBatch;
                partialResultCopy=isc.addPropertiesWithAssign({},partialResult);
            }else{
                var arr=aiResponseForBatch.message&&
                          aiResponseForBatch.message.content&&
                          aiResponseForBatch.message.content.result;
                if(!isc.isAn.Array(arr))arr=[arr];
                if(nonNumerical){
                    for(var i=0;i<arr.length;++i){
                        if(arr[i]==null)continue;
                        arr[i]=String(arr[i]);
                    }
                }else if(valueClass=="ordinal"){
                    for(var i=0;i<arr.length;++i){
                        if(arr[i]==null)continue;
                        if(isc.isAn.Object(arr[i])){
                            arr[i]=null;
                            continue;
                        }
                        var categoryIndex=categories.indexOf(String(arr[i]));
                        arr[i]=categoryIndex<0?null:categoryIndex;
                    }
                }else{
                    for(var i=0;i<arr.length;++i){
                        if(arr[i]==null)continue;
                        if(isc.isAn.Object(arr[i])){
                            arr[i]=null;
                            continue;
                        }
                        var number=parseFloat(arr[i]);
                        if(!isc.isA.Number(number)){
                            arr[i]=null;
                        }else{
                            if(isc.isA.Number(aiFieldRequest.minValue)){
                                number=Math.max(aiFieldRequest.minValue,number);
                            }
                            if(isc.isA.Number(aiFieldRequest.maxValue)){
                                number=Math.min(number,aiFieldRequest.maxValue);
                            }
                            arr[i]=number;
                        }
                    }
                }
                var batchLength=aiResponseForBatch.length;
                arr.setLength(batchLength);
                partialResult={
                    type:"success",
                    startIndex:aiResponseForBatch.startIndex,
                    length:batchLength
                };
                partialResultCopy=isc.addPropertiesWithAssign({},partialResult);
                if(nonNumerical){
                    partialResult.recordSummaries=arr;
                    partialResultCopy.recordSummaries=arr.duplicate();
                }else{
                    partialResult.recordNumericalSummaries=arr;
                    partialResultCopy.recordNumericalSummaries=arr.duplicate();
                }
            }
            partialResults.push(partialResult);
            isc.AI.fireCallback(partialResultCallback,isc.AI._summarizeRecordsPartialResultCallbackArgNames,
                    [partialResultCopy,summarizeRecordsContext]);
            return partialResult;
        })._whenSettled(function(result){
            if(firstNonSuccess||result.type!="success"){
                return Promise.reject(isc.addPropertiesWithAssign({},firstNonSuccess||result,{partialResults:partialResults}));
            }
            isc.AI._assert(!dabOpContext.cancellationController||
                           !dabOpContext.cancellationController.canceled);
            result.aiResponsesForBatches.sortByProperty("startIndex",true);
            var sortedPartialResults=result.aiResponsesForBatches.getProperty("callbackReturnValue"),
                recordSummaries=[];
            for(var recordIndex=0,i=0;i<sortedPartialResults.length;++i){
                var partialResult=sortedPartialResults[i];
                isc.AI._assert(recordIndex==partialResult.startIndex);
                isc.AI._assert(partialResult.length>0);
                var someRecordSummaries=nonNumerical?partialResult.recordSummaries:partialResult.recordNumericalSummaries;
                isc.AI._assert(someRecordSummaries.length==partialResult.length);
                recordSummaries.addList(someRecordSummaries);
                recordIndex+=partialResult.length;
            }
            var summarizeRecordsResult={
                type:"success",
                partialResults:partialResults
            };
            if(nonNumerical)summarizeRecordsResult.recordSummaries=recordSummaries;
            else summarizeRecordsResult.recordNumericalSummaries=recordSummaries;
            return summarizeRecordsResult;
        });
    }
,isc.A.translateText=function isc_c_AI_translateText(phrase,targetLocales,callback,context){
        if(!phrase||!targetLocales){
            this.logWarn("'phrase' and 'targetLocales' parameters are required");
            return;
        }
        if(!isc.isAn.Array(targetLocales))targetLocales=[targetLocales];
        var origLocales=targetLocales.duplicate();
        if(targetLocales.contains("sr")){
            targetLocales.remove("sr");
            targetLocales.add("sr-Cyrl");
        }
        var prompt="Please translate the source phrase '"+phrase+"' to this list of "+
                "locales: "+targetLocales.join(", ")+".\n\n";
        prompt+="All punctuation, HTML markup and non-alpha characters in the source phrase "+
            "should be included in your translation and any word prefixed with a '$' character, "+
            "such as '$description' or '$titleField', must be included verbatim without "+
            "translation.\n\n ";
        prompt+="Your response should be a simple JSON object where property-names are the "+
            "list of requested locale-codes, and each value is your translation to that locale.  "+
            "Any content outside of this JSON object, such as a prefix like 'Response:' is "+
            "invalid and should not be included.\n\n";
        if(context&&context.attrName){
            prompt+="For context, the source phrase is the default value for an Isomorphic "+
                "SmartClient framework property with the approximate name '"+
                context.attrName.replace("_"," ")+"' and the following description: "+
                context.doc+"\n";
        }
        var _this=this;
        isc.AI.origSendPrompt(prompt,function(result){
            result=result.replaceAll("\"sr-Cyrl\"","\"sr\"");
            var obj=_this._extractJsonResult(result);
            _this.fireCallback(callback,"result,context",[obj,context]);
        },{showPrompt:false});
    }
,isc.A.buildFormula=function isc_c_AI_buildFormula(userPrompt,callback,context,aiConfig){
        aiConfig=isc.addProperties({},aiConfig,{showPrompt:false});
        var grid=context.grid||context.rootCanvas;
        var ds=context.dataSource;
        var allFields=ds!=null?isc.getValues(ds.getFields()):grid.getFields();
        var numericTypes=["float","integer","int","long","number","decimal","double"];
        var fields=[];
        for(var i=0;i<allFields.length;i++){
            if(numericTypes.contains(allFields[i].type||"text"))
                fields.add(allFields[i]);
        }
        var prompt="You are to generate an Isomorphic SmartClient UserFormula object based on "+
                "a user-provided description.\n\n";
        prompt+="A SmartClient UserFormula is an object with two properties - 'text', which "+
                "is a mathematical formula that can contain variable-names, and 'formulaVars' "+
                "which is an object mapping those variable-names to the names of fields on an "+
                "associated data-record.  The variable-names range from A-Z, and then onward "+
                "to a maximum of ZZZ.  You should map natural language to the most appropriate "+
                "field-names, which are listed below.  Only fields in this list are allowed.\n\n";
        prompt+="For example, a user might ask for and expect the following:\n\n"+
                "user-prompt: '(field1 plus field2) times 100'\n"+
                "response: {text:'(A+B)*100',formulaVars:{A:'field1',B:'field2'}}\n\n"+
                "or\n\n"+
                "user-prompt: 'Show the average of distance1 and distance2'\n"+
                "response: ({text:'(A+B)/2',formulaVars:{A:'distance1',B:'distance2'}})\n\n";
        prompt+="A trinary operator may be used if a user requests conditional logic. For example:\n\n"+
                  "user-prompt: 'if field1 is greater than zero, field2 * field3, otherwise -(field2 * field3)'\n"+
                  "response: ({text:'(A > 0) ? (B * C) : -(B*C)',formulaVars:{A:'field1',B:'field2',C:'field3'}})\n\n";
        prompt+="In addition to simple operators ('+','-','*','/'), the UserFormula text may make use of any of the following MathFunction(s).\n"+
                    "max(val1,val2): Maximum of two values\n"+
                    "min(val1,val2): Minimum of two values\n"+
                    "round(value,decimalDigits): Round a value up or down, optionally providing decimalDigits as the maximum number of decimal places to round to. For fixed or precision rounding, use toFixed() and toPrecision() respectively.\n"+
                    "ceil(value): Round a value up\n"+
                    "floor(value): Round a value down\n"+
                    "abs(value): Absolute value\n"+
                    "pow(value1,value2): value1 to the power of value2\n"+
                    "sqrt(value): Square root of a value\n"+
                    "dateAdd(value,interval,amount): Excel-compatible dataAdd function: adds quantities of a time interval to a date value. Also supports being passed interval names, like \"hour\" or \"week\".\n"+
                    "year(value): 4-digit integer that represents the year of a date.\n"+
                    "month(value): 1-12 integer that represents the month of a date.\n"+
                    "day(value): 1-31 integer that represents the day of month of a date.\n"+
                    "toPrecision(value,precision): Format a number to a length of precision digits, rounding or adding a decimal point and zero-padding as necessary. Note that the values 123, 12.3 and 1.23 have an equal precision of 3. Returns a formatted string and should be used as the outermost function call in a formula. For rounding, use round().\n"+
                    "toFixed(value,digits): Round or zero-pad a number to digits decimal places. Returns a formatted string and should be used as the outermost function call in a formula. To round values or restrict precision, use round() and toPrecision() respectively.\n"+
                    "sin(value): Sine of a value\n"+
                    "cos(value): Cosine of a value\n"+
                    "tan(value): Tangent of a value\n"+
                    "ln(value): natural logarithm of a value\n"+
                    "log(base,value): logarithm of a value with the specified base\n"+
                    "asin(value): Arcsine of a value\n"+
                    "acos(value): Arccosine of a value\n"+
                    "atan(value): Arctangent of a value (-PI/2 to PI/2 radians)\n"+
                    "atan2(value1,value2): Angle theta of a point (-PI to PI radians)\n"+
                    "exp(value): The value of Evalue\n"+
                    "random(): Random number between 0 and 1\n\n"+
                  "For example:\n\n"+
                  "user-prompt: 'show the maximum of region1Revenue, region2Revenue'\n"+
                  "response: ({text:'max(A,B)',formulaVars:{A:'region1Revenue',B:'region2Revenue'}})\n\n";
        prompt+="The user-prompt may indicate a name or title to use for the formula.  If not, "+
                  "please generate a short (two to four word) title.  Either way, please include it "+
                  "in the UserFormula object you generate, as the 'title' property.\n\n";
        prompt+="Here is the list of fields available for use in UserFormula objects - ";
        if(this.shouldUseAIFieldPaging(prompt,fields,aiConfig)){
            var _this=this;
            this.retrieveFieldsForPrompt(
                userPrompt,"Create a userFormula field for a ListGrid",fields,
                function(finalFields){
                    _this._buildFormulaWithFinalFields(userPrompt,prompt,callback,context,aiConfig,finalFields);
                },
                context,aiConfig
            );
        }else{
            this._buildFormulaWithFinalFields(userPrompt,prompt,callback,context,aiConfig,fields);
        }
    }
,isc.A._buildFormulaWithFinalFields=function isc_c_AI__buildFormulaWithFinalFields(userPrompt,prompt,callback,context,aiConfig,fields){
        prompt+=this.getSerializedFields(fields,aiConfig);
        prompt+="Your task is to generate a UserFormula object to satisfy this user request: '"+userPrompt+"'\n\n";
        prompt+="Please respond only with the UserFormula object - any surrounding content will cause JSON decode issues down-stream.\n"
        var _this=this;
        isc.AI.origSendPrompt(
            prompt,
            function(result){
                var obj=_this._extractJsonResult(result);
                _this.fireCallback(callback,"result,context",[obj,context]);
            },
            aiConfig
        );
    }
,isc.A.getMultiActionAIWindow=function isc_c_AI_getMultiActionAIWindow(){
        var w=this.multiActionAIWindow;
        if(!w){
            w=isc.AI.multiActionAIWindow=isc.Window.create(this.multiActionAIWindowDefaults);
        }
        return w;
    }
,isc.A.buildCompositeViewSettings=function isc_c_AI_buildCompositeViewSettings(userPrompt,callback,context,aiConfig){
        var component=context.grid||context.component;
        var className=component&&component.getScClassName();
        if(className==null)className="ListGrid";
        if(!context.grid)context.grid=component;
        var actions=context.actions||isc.getKeys(this.componentActions);
        var prompt="A user is interacting with a(n) "+className+" component in an application "+
                "built with Isomorphic SmartClient Javascript framework.  Should you need to know, "+
                "today's date is "+isc.DateUtil.format(new Date(),"MMMM dd, yyyy")+".\n"+
                "The user has issued the following request:\n\n"+
                "\""+userPrompt+"\"\n\n"+
                "This may be requesting one or more actions of the following action type(s):\n";
        for(var i=0;i<actions.length;i++){
            var actionName=actions[i];
            if(this.componentActions[actionName]==null)continue;
            prompt+=actionName+": "+this.componentActions[actionName].description+"\n";
        }
        prompt+="\n\nPlease determine which action(s) the user is requesting and return a series of rephrased queries as a JSON object "+
                  "where each attribute name is the requested action type, and the attribute value is a rephrased version of the part of the query "+
                  "that requests that action type.\n\n"+
                  "Any request for sorting is a 'sort' action.  "+
                  "If the request concerns group-sorting, that part of the request should be considered a 'sort' action and "+
                  "not a 'groupBy' action.  A 'groupBy' action should only ever request group-fields.\n\n"
        prompt+="Example 1: if the user prompt was: \n"+
                  "'Show only items where cost is greater than 1 and hilite the cost field for items that are on sale'\n"+
                  "An example response might be:\n"+
                  '{"filter":"Show only items where cost is greater than 1",'+
                  ' "hilite":"hilite the cost field for items that are on sale"}\n\n';
        prompt+="Example 2: consider the user-prompt 'Group the data by Customer ascending'\n"+
                  "This prompt requests that the data be grouped, and that the groups be sorted in ascending order. "+
                  "In cases like this, the request to group and group-fields must be provided to a 'groupBy' action, "+
                  "while the request to sort the groups must go to a 'sort' action:"
                  '{"groupBy":"Group the data by Customer",'+
                  ' "sort":"Sort the groups in ascending order"}\n\n';
        prompt+="Example 3 - consider the user-prompt 'Group the data by Customer ascending, and show the latest orders first'\n"+
                  "This prompt requests that data be grouped, that groups be sorted in ascending order, and that the non-group data "+
                  "be sorted in descending order by some kind of date field (latest orders first):\n"+
                  "In this case, an appropriate response might be:\n"+
                  "{\"groupBy\":\"Group by Customer\","+
                  " \"sort\":\"Sort groups ascending and show the latest orders first\"}\n\n";
        prompt+="Similarly - if the user prompt was: \n"+
                  "'Show my orders grouped by Customer alphabetically, and show the latest orders first'\n"+
                  "An example response might be:\n"+
                  '{"groupBy":"Group by Customer",'+
                  ' "sort":"Sort the groups alphabetically and show the latest orders first"}\n\n';
        prompt+="In most cases, the user-request is additive to the current state - so if the user "+
            "asks for a single change like 'group by order-date' or 'sort the grid by Customer', that's "+
            "all they want you to do.  You should not clear other parts of viewState for simple requests like these. "+
            "## If the request is for a new view\n"+
            "If the "+
            "prompt says something like 'clear the view and ...' or 'reset and...', "+
            "that's a new view.  In these cases, you may need to clear the existing filter, group, hilite and "+
            "sort state, depending on the current view-state, which is provided.\n\n"+
            "To do this, when the request seems to be for a new view, you should add actions to clear "+
            "various pieces of state - for example, if there is a filter in the current viewState and the "+
            "request does not also ask for a new filter, you should add a 'filter' action to 'clear the filter'."+
            "Similarly, if the current viewState has grouping but the request does not mention grouping, "+
            "you should add a 'groupBy' action to 'clear grouping'.  If hilite information "+
            "is in the current viewState but the request doesn't mention hilites, you should add "+
            "a 'hilite' action to "+
            "'clear hilites'.  If the grid is sorted and the request doesn't mention sorting, add a "+
            "'sort' action to 'clear sort'.\n\n"+
            "If the current viewState says the grid is grouped and the request mentions multiple actions "+
            "but does *not* mention grouping, add a 'groupBy' action to 'clear grouping'.\n\n"
            "If the current viewState says the grid has hilites and the request mentions multiple actions "+
            "but does *not* mention hilites, you should add a 'hilite' action to 'clear hilites'.\n\n"
            "Do not attempt to clear all fields with a 'setFields' action.\n\n";
        prompt+="If you can't determine which of the known actions are being requested, return an empty JSON object.\n\n";
        prompt+="Your response must be only the JSON object - do not include any text outside of "+
            "the object, like a description or helpful comment, as that will break code which parses your response.\n\n"
        var ds=component.getDataSource();
        if(ds){
            var dsSummary=isc.AI.summarizeDataSource(ds);
            prompt+="Here is the definition of the component's Datasource:\n"+dsSummary+"\n\n";
        }
        prompt+="Finally, here is the grid's current view-state, as an object detailing "+
                "current sort, group, hilite and filter settings:\n";
        prompt+=component.getViewState()+"\n\n";
        var _this=this;
        var categorizeCallback=function(aiResponse){
            _this.processSplitCompositeViewRequests(aiResponse,userPrompt,callback,context,aiConfig);
        }
        var w=isc.AI.getMultiActionAIWindow();
        w.setTitle("Configure via AI - Determining tasks");
        w.setFirstAction(null);
        w.show();
        this.origSendPrompt(prompt,categorizeCallback);
    }
,isc.A.processSplitCompositeViewRequests=function isc_c_AI_processSplitCompositeViewRequests(aiResponse,userPrompt,callback,context,aiConfig){
        aiResponse=aiResponse.replaceAll("```json","").replaceAll("```","");
        var actions=JSON.parse(aiResponse);
        var hasAction=false;
        context.actions=actions;
        context.actionResults={};
        context.callback=callback;
        var component=context.component;
        var w=isc.AI.getMultiActionAIWindow();
        w.setTitle("Configure via AI - Executing tasks");
        w.addActions(isc.addProperties({},actions));
        var _this=this;
        for(var actionType in actions){
            var actionPrompt=actions[actionType];
            if(this.componentActions[actionType]!=null){
                hasAction=true;
                var actionContext=isc.addProperties({
                        actionType:actionType,
                        originalContext:context
                    },context);
                var methodName=this.componentActions[actionType].methodName;
                if(methodName=="buildFilter"){
                    var buildRequest=isc.addProperties({showProgressDialog:false},{
                        userAIRequest:{prompt:actionPrompt},
                        dataSource:component.getDataSource(),
                        mode:component.filterViaAIMode=="AIDE"?"AIDE":"aiAssist"
                    });
                    var filterActionContext=isc.addProperties({},actionContext);
                    isc.AI.asyncBuildCriterion(buildRequest)
                        ._whenSettled(this.ns.EH._wrapCallback("PromiseSettled",function(buildResponse){
                            if(buildResponse.type!="canceled"){
                                if(buildResponse.type!="success"){
                                    isc.logWarn("buildCriterion() resulted in type: "+buildResponse.type+
                                                 ", errorMessage: "+buildResponse.errorMessage,"AI");
                                }
                            }
                            _this.buildCompositeViewSettingsReply(buildResponse.criterion,filterActionContext);
                        }));
                }else if(methodName=="buildHilite"){
                    var buildRequest={
                        userAIRequest:{prompt:actionPrompt},
                        records:component._getRecordsForAI(),
                        dataSource:component.getDataSource(),
                        mode:component.hiliteViaAIMode=="AIDE"?"AIDE":"aiAssist",
                        aiPageSize:component.aiPageSize,
                        showProgressDialog:false
                    };
                    var hiliteActionContext=isc.addProperties({},actionContext);
                    isc.AI.buildHilites(buildRequest,function(buildResponse){
                            if(buildResponse.type!="success"){
                                isc.warn("Hilite-via-AI failed: "+buildResponse.errorMessage);
                            }
                            _this.buildCompositeViewSettingsReply(buildResponse.hilites,hiliteActionContext);
                    });
                }else{
                    this[methodName](
                        actionPrompt,
                        function(result,actionContext){
                            _this.buildCompositeViewSettingsReply(result,actionContext);
                        },
                        actionContext,
                        aiConfig
                    );
                }
            }else{
                this.logWarn("Unrecognized action type '"+actionType+"' for AI-generated partial request:"+actions[actionType]);
                delete actions[actionType];
            }
        }
    }
,isc.A.buildCompositeViewSettingsReply=function isc_c_AI_buildCompositeViewSettingsReply(result,actionContext){
        var actionType=actionContext.actionType;
        var origContext=actionContext.originalContext;
        origContext.actionResults[actionContext.actionType]=result;
        var w=isc.AI.getMultiActionAIWindow();
        w.updateAction(actionType,true);
        delete origContext.actions[actionType];
        if(isc.isA.emptyObject(origContext.actions)){
            this.fireCallback(origContext.callback,"data,context",[origContext.actionResults,origContext]);
            w.hide();
        }
    }
);
isc.B._maxIndex=isc.C+8;

isc.A=isc.Operators;
isc.A.aiFilterTitle="matches a natural language description of a filter, as determined by AI";
isc.A.aiFilterDescriptionPrefix="Filter via AI: "
;

isc.DataSource.addSearchOperator({
    ID:"aiFilter",
    titleProperty:"aiFilterTitle",
    symbol:"\uD83E\uDD16",
    hidden:true,
    clientOnly:true,
    valueType:"custom",
    getDescription:function(aiCriterion,dataSource){
        return isc.Operators.aiFilterDescriptionPrefix+isc.AI._getPromptText(aiCriterion,dataSource).asHTML();
    },
    getCleanCriterion:function(aiCriterion,dataSource){
        return isc.AI._getCleanAICriterion(aiCriterion);
    },
    fromCleanCriterion:function(cleanCriterion,dataSource){
        return isc.AI._createFromCleanAICriterion(cleanCriterion);
    },
    condition:function(fieldName,fieldValue,criterionValues,dataSource){
        var aiCriterion=criterionValues.criterion;
        if(!isc.AI._canUseAICriterion(aiCriterion,dataSource)||
            aiCriterion.isTrivial)
        {
            return true;
        }
        var pkFieldNames=aiCriterion._pkFieldNames,
            record=criterionValues.record;
        if(pkFieldNames.length==1){
            var pkValue=record[pkFieldNames[0]];
            if(isc.isA.Class(aiCriterion._notPickedPkValues)&&aiCriterion._notPickedPkValues.has(pkValue)){
                return false;
            }
            if(isc.isA.Class(aiCriterion._pickedPkValues)&&aiCriterion._pickedPkValues.has(pkValue)){
                return true;
            }
        }else{
            this._assert(false);
        }
        if(dataSource._withinLogicalNot){
            if(!aiCriterion._narrowerCriterion)return false;
            return dataSource.evaluateCriterion(record,aiCriterion._narrowerCriterion);
        }else{
            if(!aiCriterion._broaderCriterion)return true;
            return dataSource.evaluateCriterion(record,aiCriterion._broaderCriterion);
        }
    },
    compareCriteria:function(newCriterion,oldCriterion){
        if(newCriterion._dsName!=oldCriterion._dsName){
            return-1;
        }
        var dataSource=isc.DS.getDataSource(newCriterion._dsName);
        if(dataSource==null||
            !isc.AI._canUseAICriterion(newCriterion,dataSource)||
            !isc.AI._canUseAICriterion(oldCriterion,dataSource))
        {
            return-1;
        }
        if(newCriterion.isTrivial){
            if(oldCriterion.isTrivial)return 0;
        }else{
            if(oldCriterion.isTrivial)return 1;
        }
        return-1;
    },
    getServerCriterion:function(aiCriterion,narrower,dataSource){
        var defaultServerCriterion=narrower?isc.DS._nothingCriterion:isc.DS._everythingCriterion;
        if(!isc.AI._canUseAICriterion(aiCriterion,dataSource)){
            return defaultServerCriterion;
        }
        if(aiCriterion.isTrivial){
            return isc.DS._everythingCriterion;
        }
        var combinedCriterion;
        if(narrower){
            var pickedCriterion=null,
                pkFieldNames=aiCriterion._pkFieldNames;
            if(pkFieldNames.length==1){
                var pkFieldName=pkFieldNames[0];
                if(isc.isA.Class(aiCriterion._pickedPkValues)){
                    pickedCriterion={
                        _constructor:"AdvancedCriteria",
                        fieldName:pkFieldName,
                        operator:"inSet",
                        value:aiCriterion._pickedPkValues.getContents()
                    };
                }
            }else{
                this._assert(false);
            }
            combinedCriterion=dataSource.combineCriteria(pickedCriterion,aiCriterion._narrowerCriterion);
        }else{
            combinedCriterion=dataSource.combineCriteria(aiCriterion._notPickedCriterion,aiCriterion._broaderCriterion);
        }
        return combinedCriterion==null?defaultServerCriterion:combinedCriterion;
    },
    asyncFilter:function(aiCriterion,records,asyncFilterContext){
        var dataSource=asyncFilterContext.dataSource;
        if(!isc.AI._canUseAICriterion(aiCriterion,dataSource)){
            return Promise.reject(isc.createErrorResult("The 'aiFilter' is not usable."));
        }
        if(aiCriterion.isTrivial)return null;
        var request={
            aiCriterion:aiCriterion,
            showProgressDialog:false,
            cancellationController:asyncFilterContext.cancellationController
        };
        if(asyncFilterContext.recordsWereUpdated){
            request.updatedRecords=records;
            return isc.AI.asyncReapplyAIFilter(request);
        }
        var partialResult=isc.AI._applyUsableAIFilterCaches(aiCriterion,records,dataSource);
        isc.AI._assert(isc.isAn.Array(partialResult.matchingRecords)&&
                       partialResult.matchingRecords.length+(partialResult.remainingRecords==null
                                                               ?0
                                                               :partialResult.remainingRecords.length)==records.length);
        if(!partialResult.remainingRecords||partialResult.remainingRecords.length==0){
            return null;
        }
        request.records=records;
        request._partialResult=partialResult;
        return isc.AI.asyncApplyAIFilter(request);
    },
    removeFromFilterCaches:function(aiCriterion,records){
        isc.AI.removeFromAIFilterCaches(aiCriterion,records);
    },
    clearFilterCaches:function(aiCriterion){
        isc.AI.clearAIFilterCaches(aiCriterion);
    },
    getDependencies:function(aiCriterion){
        if(aiCriterion.isTrivial)return[];
        return aiCriterion._finalFieldNames;
    }
});
isc.AI.init();
isc.defineClass("MultiStepAIOperation","PausableAsyncOperation");
isc.A=isc.MultiStepAIOperation;
isc.B=isc._allFuncs;
isc.C=isc.B._maxIndex;
isc.D=isc._funcClasses;
isc.D[isc.C]=isc.A.Class;
isc.B.push(isc.A._getNodeType=function isc_c_MultiStepAIOperation__getNodeType(node){
        return(node.defaults&&node.defaults._constructor)||node._constructor||node.type;
    }
,isc.A._isInlinedNode=function isc_c_MultiStepAIOperation__isInlinedNode(node){
        return!!node._constructor;
    }
,isc.A._augmentFetchRequestSummaryFunctions=function isc_c_MultiStepAIOperation__augmentFetchRequestSummaryFunctions(dataSource,groupBy,summaryFunctions){
        var allFields=dataSource.getAllFields();
        if(allFields){
            for(var f=0;f<allFields.length;++f){
                var field=allFields[f],
                    fieldName=field.name;
                if(!isc.isA.nonemptyString(fieldName))continue;
                if(!groupBy.contains(fieldName)&&!(fieldName in summaryFunctions)){
                    summaryFunctions[fieldName]="first";
                }
            }
        }
    }
);
isc.B._maxIndex=isc.C+3;

isc.A=isc.MultiStepAIOperation.getPrototype();
isc.B=isc._allFuncs;
isc.C=isc.B._maxIndex;
isc.D=isc._funcClasses;
isc.D[isc.C]=isc.A.Class;
isc.A.jsonEncoderDefaults={
        circularReferenceMode:"omit",
        dateFormat:"xmlSchema",
        strictQuoting:true,
        prettyPrint:false
    };
isc.A.maxRecordsPerQuery=15;
isc.A._augmentFetchRequestSummaryFunctions=isc.MultiStepAIOperation._augmentFetchRequestSummaryFunctions;
isc.A._getNodeType=isc.MultiStepAIOperation._getNodeType;
isc.A._isInlinedNode=isc.MultiStepAIOperation._isInlinedNode;
isc.B.push(isc.A.init=function isc_MultiStepAIOperation_init(){
        this.Super("init",arguments);
        if(this.paused){
            this.getUnpausePromise()["catch"](isc.noOp);
            this.timeLastUnpaused=null;
        }else if(this.timeLastUnpaused==null){
            this.timeLastUnpaused=this._getTimeStamp();
        }
        if(this.numQueriesMade==null){
            this.numQueriesMade=0;
            var prevStepResults=this.getPrevStepResults(),
                numPrevStepResults=!prevStepResults?0:prevStepResults.length;
            for(var p=0;p<numPrevStepResults;++p){
                var prevStepResult=prevStepResults[p];
                if(prevStepResult.step.type=="executeQuery")++this.numQueriesMade;
            }
        }
        if(!this.jsonEncoder){
            this.jsonEncoder=isc.JSONEncoder.create(this.jsonEncoderDefaults,this.jsonEncoderProperties);
        }
        var maxRecordsPerQuery=this.maxRecordsPerQuery;
        if(maxRecordsPerQuery==null||
            !isc.isA.Number(maxRecordsPerQuery)||
            maxRecordsPerQuery!=Math.trunc(maxRecordsPerQuery)||
            maxRecordsPerQuery<0)
        {
            maxRecordsPerQuery=this.maxRecordsPerQuery=this.getClass().getInstanceProperty("maxRecordsPerQuery");
            this.logWarn("Invalid 'maxRecordsPerQuery'. Resetting to "+maxRecordsPerQuery,"AI");
        }
        if(!this.isCanceled()){
            this.loadSystemSchemaPromise=isc.AI.asyncLoadSystemSchema();
        }
    }
,isc.A._getTimeStamp=function isc_MultiStepAIOperation__getTimeStamp(){
        return(this.ns.EH&&this.ns.EH._getThreadTimeStamp())||Date.now();
    }
,isc.A.getPrevStepResults=function isc_MultiStepAIOperation_getPrevStepResults(){
        return this.prevStepResults;
    }
,isc.A.handleCancel=function isc_MultiStepAIOperation_handleCancel(wasFirstCancel,ownCC){
        var wasPaused=this.paused;
        this.Super("handleCancel",arguments);
        if(wasFirstCancel&&wasPaused){
            this.timeLastUnpaused=this._getTimeStamp();
        }
    }
,isc.A.handlePaused=function isc_MultiStepAIOperation_handlePaused(initiator){
        this.Super("handlePaused",arguments);
        if(!this.paused)return;
        if(this.elapsedTimeMillis==null)this.elapsedTimeMillis=0;
        this.elapsedTimeMillis+=this._getTimeStamp()-this.timeLastUnpaused;
        this.timeLastUnpaused=null;
    }
,isc.A.handleUnpaused=function isc_MultiStepAIOperation_handleUnpaused(initiator){
        this.Super("handleUnpaused",arguments);
        if(this.paused)return;
        this.timeLastUnpaused=this._getTimeStamp();
    }
,isc.A.customizeQueryBeforeValidation=function isc_MultiStepAIOperation_customizeQueryBeforeValidation(dataSource,dsRequestProperties,errorMessages){
        dsRequestProperties=dataSource.normalizeFetchRequest(dsRequestProperties);
        delete dsRequestProperties.__normalized;
        if(dsRequestProperties.data)delete dsRequestProperties.data.__normalized;
        dsRequestProperties.applyCriteriaBeforeAggregation=true;
        var groupBy=dsRequestProperties.groupBy;
        if(groupBy){
            var summaryFunctions=dsRequestProperties.summaryFunctions;
        }
        return dsRequestProperties;
    }
,isc.A.customizeNodesBeforeValidation=function isc_MultiStepAIOperation_customizeNodesBeforeValidation(paletteNodes,correspondingErrorMessages,isFinalCustomization){
        var Canvas=isc.DS.get("Canvas"),
            DrawPane=isc.DS.get("DrawPane");
        for(var n=0;n<paletteNodes.length;++n){
            var paletteNode=paletteNodes[n],
                defaults=paletteNode.defaults;
            if(!defaults){
                defaults=paletteNode.defaults={};
            }
            var type=isc.MultiStepAIOperation._getNodeType(paletteNode);
            if(!type)continue;
            var componentSchema=isc.DS.get(type);
            if(!componentSchema)continue;
            var propertiesToRemove=[];
            if(componentSchema.inheritsSchema(Canvas)){
                propertiesToRemove.push(
                    "autoDraw"
                );
                if(isc.isA.Class(isc[type])&&
                    isc[type].isA("DataBoundComponent"))
                {
                    var speculatedRequestProperties=isc[type].speculateInitialFetchRequestProperties(defaults,paletteNode,componentSchema);
                    if(speculatedRequestProperties&&speculatedRequestProperties.groupBy){
                        var dataSource=isc.SchemaValidator._getDataSourceProperty("dataSource",defaults,paletteNode);
                        speculatedRequestProperties=dataSource.normalizeFetchRequest(speculatedRequestProperties);
                        if(speculatedRequestProperties.errorMessage){
                            if(!correspondingErrorMessages[n]){
                                correspondingErrorMessages[n]=[];
                            }
                            var errorMessage="The initial fetch request properties, derived from 'fetchRequestProperties', "+
                                "'implicitCriteria', 'initialCriteria', and/or 'initialSort', are "+
                                "invalid: "+speculatedRequestProperties.errorMessage;
                            correspondingErrorMessages[n].push(errorMessage);
                        }
                        if(speculatedRequestProperties.groupBy){
                            var fetchRequestProperties=defaults.fetchRequestProperties;
                            if(!fetchRequestProperties){
                                fetchRequestProperties=defaults.fetchRequestProperties={};
                            }
                            fetchRequestProperties.applyCriteriaBeforeAggregation=true;
                            var groupBy=fetchRequestProperties.groupBy=speculatedRequestProperties.groupBy;
                            var summaryFunctions=fetchRequestProperties.summaryFunctions=speculatedRequestProperties.summaryFunctions;
                            if(isFinalCustomization){
                                isc.MultiStepAIOperation._augmentFetchRequestSummaryFunctions(dataSource,groupBy,summaryFunctions);
                            }
                        }
                    }
                }
            }
            if(componentSchema.inheritsSchema(DrawPane)){
                propertiesToRemove.push("drawingType");
            }
            for(var p=0;p<propertiesToRemove.length;++p){
                var propertyName=propertiesToRemove[p];
                delete defaults[propertyName];
            }
        }
        return paletteNodes;
    }
,isc.A.asyncValidatePaletteNodes=function isc_MultiStepAIOperation_asyncValidatePaletteNodes(paletteNodes,validationContext,paletteNodeTreeValidationContext){
        var correspondingErrorMessages=new Array(paletteNodes.length);
        paletteNodes=this.customizeNodesBeforeValidation(paletteNodes,correspondingErrorMessages);
        var multiStepAIOperation=this;
        return new Promise(function(resolve){
            var callback=function(validationErrors,paletteNodeTrees){
                for(var i=0;i<correspondingErrorMessages.length;++i){
                    var paletteNode=paletteNodes[i],
                        nodePath=paletteNode._nodePath,
                        errorMessages=correspondingErrorMessages[i];
                    if(isc.isA.nonemptyArray(errorMessages)){
                        if(!validationErrors){
                            validationErrors=[];
                        }
                        validationErrors.push({
                            nodePath:nodePath,
                            errorMessages:errorMessages
                        });
                    }
                }
                multiStepAIOperation.validatePaletteNodeTrees(paletteNodeTrees,validationErrors,paletteNodeTreeValidationContext);
                delete validationContext._rejectStringMethodImplsAndFunctions;
                resolve({
                    type:"success",
                    validationContext:validationContext,
                    validationErrors:validationErrors,
                    paletteNodeTrees:paletteNodeTrees
                });
            };
            if(!validationContext)validationContext={};
            validationContext._rejectStringMethodImplsAndFunctions=true;
            isc.EditContext.createTreeAndValidatePaletteNodeDefaults(
                    paletteNodes,callback,validationContext);
        });
    }
,isc.A.validatePaletteNodeTrees=function isc_MultiStepAIOperation_validatePaletteNodeTrees(paletteNodeTrees,validationErrors,paletteNodeTreeValidationContext){
    }
,isc.A._removeValidationArtifacts=function isc_MultiStepAIOperation__removeValidationArtifacts(paletteNodes){
        var globals={};
        isc.EditContext._extractGlobals(paletteNodes,globals);
        for(var id in globals){
            var global=globals[id];
            delete global._nodePath;
        }
        return paletteNodes;
    }
,isc.A.customizePaletteNodesAfterValidation=function isc_MultiStepAIOperation_customizePaletteNodesAfterValidation(paletteNodes){
        return paletteNodes;
    }
);
isc.B._maxIndex=isc.C+12;

isc.A=isc.AI;
isc.B=isc._allFuncs;
isc.C=isc.B._maxIndex;
isc.D=isc._funcClasses;
isc.D[isc.C]=isc.A.Class;
isc.B.push(isc.A._maskAddComponentResponseObjectNodes=function isc_c_AI__maskAddComponentResponseObjectNodes(responseObject){
        if(!isc.isAn.Object(responseObject))throw isc.createErrorResult(this.aiNotAbleToProcessRequestErrorMessage);
        var nodes=responseObject.nodes||responseObject.node;
        if(!nodes&&
            (responseObject.type||responseObject._constructor||responseObject.defaults))
        {
            nodes=[responseObject];
            responseObject={
                nodes:nodes
            };
        }
        if(!isc.isAn.Array(nodes))nodes=!nodes?[]:[nodes];
        for(var rn=nodes.length;rn>0;--rn){
            var n=rn-1,
                node=nodes[n];
            if(!isc.isAn.Object(node)){
                nodes.removeAt(n);
                continue;
            }
            if(!isc.isAn.Object(node.defaults))node.defaults={};
            var type=node.defaults._constructor||node.type;
            if(!isc.isA.nonemptyString(type)){
                nodes.removeAt(n);
                continue;
            }
            delete node.defaults._constructor;
            var ID=node.defaults.ID;
            if(!isc.isA.String(ID)||!(ID=ID.trim())){
                node.defaults.ID=node.ID;
            }
            nodes[n]={
                type:type,
                defaults:node.defaults
            };
            if(node.parentComponent!=null){
                nodes[n].parentComponent=node.parentComponent;
            }
        }
        if(nodes.isEmpty()){
            throw isc.createErrorResult(this.aiNotAbleToProcessRequestErrorMessage);
        }
        for(var n=0;n<nodes.length;++n){
            var node=nodes[n],
                ID=node.defaults.ID;
            if(!isc.isA.String(ID)||
                !(ID=ID.trim())||
                !String.isValidID(ID))
            {
                node.defaults.ID="localAutoID"+n;
            }
        }
        responseObject.nodes=nodes;
        return responseObject;
    }
,isc.A.userHasAccess=function isc_c_AI_userHasAccess(callback){
        var dsName=this.dataSourceName;
        isc.DS.get(dsName,function(){
            var ds=isc.DS.get(dsName);
            ds.performCustomOperation("authorizeChat",null,function(response,data){
                isc.AI.fireCallback(callback,"authorized,extradata",[data.authorized,data]);
            });
        });
    }
);
isc.B._maxIndex=isc.C+2;
isc.defineClass("CoTProcess","Process");
isc.A=isc.CoTProcess.getPrototype();
isc.A.defaultTaskConstructor="CoTTask";
isc.A.defaultProcessConstructor="CoTProcess";
isc.A.mockMode=false;
isc.A.historyMaxItems=10;
isc.A.historyPrimer="Recent actions (most recent last):";
isc.A.goalPrimer="End-user goal:";
isc.A.transitionsPrimer="You may request a transition "+
        "by emitting {goTo,intent,stepAfter}.";
isc.A.errorsPrimer="Previous attempt failed validation; "+
        "correct the issues below and try again.";
isc.A.maxRetries=2
;

isc.A=isc.CoTProcess.getPrototype();
isc.B=isc._allFuncs;
isc.C=isc.B._maxIndex;
isc.D=isc._funcClasses;
isc.D[isc.C]=isc.A.Class;
isc.B.push(isc.A.init=function isc_CoTProcess_init(){
        this.Super("init",arguments);
        if(!this.history)this.history=[];
        if(!this.state)this.state={};
        if(!this.state.history)this.state.history=[];
    }
,isc.A.getPromptPart=function isc_CoTProcess_getPromptPart(names,omitNewlines){
        var self=this;
        function surround(s){return omitNewlines?s:("\n"+s+"\n");}
        function one(name){
            if(!name)return'';
            var raw=/Data$/.test(name);
            var key=raw?name.slice(0,-4):name;
            switch(key){
                case'goal':
                    if(raw)return(self.goal==null?'':String(self.goal));
                    return surround((self.goalPrimer||'')+(self.goal!=null?' '+self.goal:''));
                case'history':
                    if(self.noHistory)return'';
                    var hist=self.history||[];
                    if(raw)return isc.JSON.encode(hist,{serializeInstances:"skip"});
                    return surround((self.historyPrimer||'')+"\n"+isc.JSON.encode(hist,{serializeInstances:"skip"}));
                case'transitions':
                    var task=self.currentTask||null;
                    var transitions=(task&&task.transitions)||[];
                    if(raw)return isc.JSON.encode(transitions,{serializeInstances:"skip"});
                    return surround((self.transitionsPrimer||'')+"\n"+isc.JSON.encode(transitions,{serializeInstances:"skip"}));
                case'errors':
                    var errs=(self.currentTask&&self.currentTask.errors)||self.latestErrors||null;
                    if(raw){
                        if(!errs)return'';
                        return isc.JSON.encode(errs,{serializeInstances:"skip"});
                    }
                    if(!errs)return'';
                    var primer=(self.currentTask&&self.currentTask.errorsPrimer)?
                        self.currentTask.errorsPrimer:(self.errorsPrimer||'');
                    return surround(primer+"\n"+isc.JSON.encode(errs,{serializeInstances:"skip"}));
                case'taskPrompt':
                    if(self._renderingTaskPrompt){
                        self.logWarn("Prevented recursive taskPrompt rendering - taskPrompt templates should not call promptPart(['taskPrompt'])");
                        return'';
                    }
                    self._renderingTaskPrompt=true;
                    try{
                        var ctx=self._makePromptCtx(self.currentTask||null);
                        return surround((self.currentTask&&self.currentTask._resolveTaskPrompt(ctx))||'');
                    }finally{
                        self._renderingTaskPrompt=false;
                    }
                default:
                    if(self.optionalPrompts&&self.optionalPrompts.hasOwnProperty(name)){
                        return surround(String(self.optionalPrompts[name]||''));
                    }
                    return'';
            }
        }
        if(names==null)return'';
        if(isc.isA.String(names))return one(names);
        var out='';
        for(var i=0;i<names.length;i++)out+=one(names[i]);
        return out;
    }
,isc.A._makePromptCtx=function isc_CoTProcess__makePromptCtx(task){
        var self=this;
        var ctx={
            process:self,
            task:task,
            state:self.state||{},
            goal:self.goal,
            promptPart:function(names,omitNewlines){return self.getPromptPart(names,omitNewlines);},
            prt:function(names,omitNewlines){return self.getPromptPart(names,omitNewlines);}
        };
        return ctx;
    }
,isc.A.addHistory=function isc_CoTProcess_addHistory(entry){
        if(this.noHistory)return;
        if(!this.history)this.history=[];
        this.history.push(entry);
        var max=(this.historyMaxItems==null?10:this.historyMaxItems);
        while(this.history.length>max)this.history.shift();
        if(!this.state)this.state={};
        if(!this.state.history)this.state.history=[];
        this.state.history.push(entry);
        var sMax=(this.stateHistoryMaxItems==null?max:this.stateHistoryMaxItems);
        while(this.state.history.length>sMax)this.state.history.shift();
    }
,isc.A.mockOutput=function isc_CoTProcess_mockOutput(task){return null;}
);
isc.B._maxIndex=isc.C+5;

isc.defineClass("CoTTask","Task");
isc.A=isc.CoTTask.getPrototype();
isc.A.noHistory=false;
isc.A.isAsync=true
;

isc.A=isc.CoTTask.getPrototype();
isc.B=isc._allFuncs;
isc.C=isc.B._maxIndex;
isc.D=isc._funcClasses;
isc.D[isc.C]=isc.A.Class;
isc.B.push(isc.A.init=function isc_CoTTask_init(){
        this.Super("init",arguments);
    }
,isc.A.isValid=function isc_CoTTask_isValid(process){
        return true;
    }
,isc.A.getInvalidTaskMessage=function isc_CoTTask_getInvalidTaskMessage(process){
        return null;
    }
,isc.A._renderTemplate=function isc_CoTTask__renderTemplate(str,ctx){
        if(str==null)return'';
        var self=this;
        return String(str).replace(/\$\{([^}]+)\}/g,function(_,code){
            try{
                var fn=new Function('ctx','with(ctx){ return ('+code+'); }');
                var res=fn(ctx);
                return(res==null?'':''+res);
            }catch(e){
                self.logWarn('Template evaluation error in "${'+code+'}": '+e.message+(e.stack?'\n'+e.stack:''));
                return'';
            }
        });
    }
,isc.A._resolveTaskPrompt=function isc_CoTTask__resolveTaskPrompt(ctx){
        var tp=this.taskPrompt;
        if(isc.isA.Function(tp))return tp.call(this,ctx);
        return this._renderTemplate(tp||'',ctx);
    }
,isc.A.getPromptContext=function isc_CoTTask_getPromptContext(process){
        process=process||null;
        return{
            process:process,
            task:this,
            state:(process&&process.state)?process.state:{},
            goal:process?process.goal:null,
            promptPart:function(names,omitNewlines){
                return(process&&isc.isA.Function(process.getPromptPart))?
                    process.getPromptPart(names,omitNewlines):'';
            },
            prt:function(names,omitNewlines){
                return(process&&isc.isA.Function(process.getPromptPart))?
                    process.getPromptPart(names,omitNewlines):'';
            }
        };
    }
,isc.A.getAssembledPrompt=function isc_CoTTask_getAssembledPrompt(process){
        var template=this.prompt;
        if(!template){
            template="${promptPart(['goal','taskPrompt','transitions','errors','history'])}";
        }
        var ctx=this.getPromptContext(process);
        if(isc.isA.Function(template)){
            return template.call(this,ctx);
        }
        var self=this;
        var originalPromptPart=ctx.promptPart;
        var wrappedCtx={
            process:ctx.process,
            task:ctx.task,
            state:ctx.state,
            goal:ctx.goal
        };
        wrappedCtx.promptPart=function(names,omitNewlines){
            function one(n){
                if(n==='taskPrompt')return(self._resolveTaskPrompt(wrappedCtx));
                return originalPromptPart(n,omitNewlines);
            }
            if(isc.isA.String(names))return one(names);
            var out='';
            for(var i=0;i<names.length;i++)out+=one(names[i]);
            return out;
        };
        wrappedCtx.prt=function(names,omitNewlines){return this.promptPart(names,omitNewlines);};
        return this._renderTemplate(String(template),wrappedCtx);
    }
,isc.A.processOutputs=function isc_CoTTask_processOutputs(_task,_process){return null;}
,isc.A.runOnce=function isc_CoTTask_runOnce(process){
        var prompt=this.getAssembledPrompt(process);
        return{prompt:prompt};
    }
,isc.A.executeElement=function isc_CoTTask_executeElement(process){
        