/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.servlet;

import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.ValidationContext;
import com.isomorphic.io.ISCFile;
import com.isomorphic.io.SequenceReader;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.rpc.ClientMustResubmitException;
import com.isomorphic.rpc.RPCManager;
import com.isomorphic.rpc.RPCResponse;
import com.isomorphic.servlet.BaseServlet;
import com.isomorphic.servlet.RequestTimer;
import com.isomorphic.store.DataStructCache;
import com.isomorphic.util.DataTools;
import com.isomorphic.xml.XML;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class FeatureExplorerRPC
extends BaseServlet {
    String examplesDir;
    String reactSourceDir;
    String reactBuildDir;
    boolean wwwProduction = false;
    boolean devenv = false;
    private final String bounceCSSPrefix = "bounceCSS_";

    @Override
    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        if (this.examplesDir == null) {
            this.examplesDir = config.getString("FeatureExplorer.examplesDir");
        }
        if (this.reactSourceDir == null) {
            this.reactSourceDir = config.getString("FeatureExplorer.reactSourceDir");
        }
        if (this.reactBuildDir == null) {
            this.reactBuildDir = config.getString("FeatureExplorer.reactBuildDir");
        }
        this.wwwProduction = config.getBoolean((Object)"wwwProduction", false);
        this.devenv = config.getBoolean((Object)"devenv", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RequestTimer requestTimer = new RequestTimer(request);
        try {
            Map data = null;
            String method = null;
            Object result = null;
            boolean noSCServer = "true".equals(request.getParameter("noSCServer"));
            RPCManager rpc = null;
            if (noSCServer) {
                ValidationContext vc = new ValidationContext();
                vc.setRestrictedXMLMode(true);
                data = (Map)XML.toDSRecords(new StringReader(request.getParameter("data")), vc);
                vc.freeResources();
            } else {
                request.getSession();
                try {
                    rpc = new RPCManager((Servlet)this, request, response);
                }
                catch (ClientMustResubmitException cmre) {
                    requestTimer.stop();
                    try {
                        response.flushBuffer();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return;
                }
                data = (Map)rpc.getData();
            }
            switch (method = (String)data.get("method")) {
                case "loadFiles": {
                    result = this.loadFiles((List)data.get("exampleFiles"));
                    break;
                }
                case "xmlToJS": {
                    result = this.xmlToJS((List)data.get("exampleFiles"));
                    break;
                }
                case "bounceCSS": {
                    result = this.bounceCSS(request, data);
                }
            }
            if (noSCServer) {
                JSTranslater.instance().toJS(result, response.getWriter());
            } else {
                rpc.send(new RPCResponse(result));
            }
        }
        catch (Throwable e) {
            this.handleError(response, e);
        }
        finally {
            requestTimer.stop();
            try {
                response.flushBuffer();
            }
            catch (IOException iOException) {}
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String cssID = request.getParameter("cssID");
        if (cssID != null) {
            HttpSession session = request.getSession(true);
            String css = (String)session.getAttribute("bounceCSS_" + cssID);
            if (css == null) {
                throw new ServletException("invalid cssID: " + cssID);
            }
            session.removeAttribute("bounceCSS_" + cssID);
            response.setContentType("text/css");
            response.setContentLength(css.length());
            response.getWriter().write(css);
            response.flushBuffer();
        } else {
            this.doPost(request, response);
        }
    }

    private List xmlToJS(List exampleFiles) {
        Iterator i = exampleFiles.iterator();
        while (i.hasNext()) {
            DataTypeMap<String, String> exampleFile = new DataTypeMap<String, String>((Map)i.next());
            exampleFile.remove("error");
            String fileContents = exampleFile.getString("fileContents");
            try {
                exampleFile.put("xmlToJS", this.convertToJS(fileContents));
            }
            catch (Exception e) {
                exampleFile.put("error", e.toString());
                String exampleFilesAsJS = null;
                try {
                    exampleFilesAsJS = DataTools.prettyPrint(exampleFiles);
                }
                catch (Exception ee) {
                    exampleFilesAsJS = ee.toString();
                }
                this.log.error((Object)("Error during xmlToJS processing - exampleFiles: " + exampleFilesAsJS), e);
            }
        }
        return exampleFiles;
    }

    private String bounceCSS(HttpServletRequest request, Map data) {
        Map exampleFile = (Map)data.get("exampleFile");
        String fileContents = (String)exampleFile.get("fileContents");
        String fileURL = (String)exampleFile.get("url");
        request.getSession(true).setAttribute("bounceCSS_" + fileURL, (Object)fileContents);
        return "true";
    }

    private List loadFiles(List exampleFiles) {
        Iterator i = exampleFiles.iterator();
        while (i.hasNext()) {
            DataTypeMap<String, Object> exampleFile = new DataTypeMap<String, Object>((Map)i.next());
            exampleFile.remove("error");
            String url = exampleFile.getString("url");
            String dataSource = exampleFile.getString("dataSource");
            boolean eval = exampleFile.getBoolean((Object)"doEval", true);
            boolean external = exampleFile.getBoolean((Object)"external", false);
            boolean showSource = exampleFile.getBoolean((Object)"showSource", true);
            boolean isReact = exampleFile.getBoolean((Object)"isReact", false);
            if (dataSource != null || url != null && url.endsWith(".ds.xml")) {
                exampleFile.put("isDataSource", Boolean.TRUE);
            }
            if ((external || !eval) && !showSource) continue;
            try {
                String path = null;
                if (dataSource != null && dataSource.indexOf(".") != -1) {
                    url = dataSource;
                }
                if (url != null) {
                    String baseDir = isReact ? (url.endsWith(".jsx") ? this.reactSourceDir : this.reactBuildDir) : this.examplesDir;
                    path = ISCFile.canonicalizePath(baseDir + "/" + url);
                } else if (dataSource != null) {
                    path = DataStructCache.getInstanceFile(dataSource, "datasources", "DS");
                    if (path == null) {
                        throw new Exception("Couldn't find dataSource: " + dataSource);
                    }
                    String comparePath = ISCFile.canonicalizePath(path);
                    if (!comparePath.equals(webRoot + "/examples/shared/ds/" + dataSource + ".ds.xml")) {
                        if (this.devenv) {
                            String sdkWebRoot = config.getPath("sdkWebRoot");
                            Object path1 = sdkWebRoot + "/examples/shared/ds/" + dataSource + ".ds.xml";
                            path1 = new File((String)path1).getCanonicalPath();
                            Object path2 = sdkWebRoot + "/shared/ds/" + dataSource + ".ds.xml";
                            path2 = new File((String)path2).getCanonicalPath();
                            if (!(comparePath.equals(path1) || comparePath.equals(path2) || comparePath.equals(this.examplesDir))) {
                                Object partialPath = sdkWebRoot + "/examples/shared/ds";
                                if (!comparePath.startsWith((String)(partialPath = new File((String)partialPath).getCanonicalPath())) && !comparePath.startsWith((String)(partialPath = ISCFile.canonicalizePath(new File(this.examplesDir).getCanonicalPath())))) {
                                    throw new Exception("Access to datasource: " + dataSource + " denied - at path: " + comparePath + ".  You must place your datasource either directly in SDKPackage/webroot/shared/ds or in SDKPackage/webroot/examples/shared/ds or a subpath of that folder, or in a subpath of the examples directory itself,  for it to be loadable by the FeatureExplorer");
                                }
                            }
                        } else {
                            Object partialPath = webRoot + "/examples/shared/ds";
                            if (!comparePath.startsWith((String)partialPath) && !comparePath.startsWith((String)(partialPath = ISCFile.canonicalizePath(new File(this.examplesDir).getCanonicalPath())))) {
                                this.log.warn("Access to datasource: " + dataSource + " DENIED - at path: " + comparePath + " - must be in: " + webRoot + "/examples/shared/ds or  a subpath of that folder,  or in a subpath of the examples directory " + (String)partialPath + " for Feature Explorer to serve it");
                                throw new Exception("Couldn't find dataSource: " + dataSource);
                            }
                        }
                    }
                } else {
                    throw new Exception("Couldn't find url or dataSource in: " + DataTools.prettyPrint(exampleFile));
                }
                if (path.indexOf("..") != -1) {
                    throw new Exception("Derived relative path to example: " + path + " refusing to serve.");
                }
                ISCFile file = ISCFile.newInstance(path);
                String fileContents = DataTools.fileContentsAsString(file, config.defaultCharset());
                if (fileContents.indexOf("//>FEStrip") != -1) {
                    fileContents = fileContents.replaceAll("(?s)(<!--)?//>FEStrip.*?//<FEStrip(-->)?", "");
                }
                exampleFile.put("fileContents", fileContents);
                if (!eval || external || !fileContents.trim().startsWith("<")) continue;
                if (Boolean.TRUE.equals(exampleFile.getBoolean("isDataSource"))) {
                    DataSource ds = DataSource.fromXML(fileContents);
                    if (ds != null) {
                        ds.getConfig().put("isServerDS", true);
                    }
                    exampleFile.put("xmlToJS", JSTranslater.get().toJS(ds));
                } else {
                    exampleFile.put("xmlToJS", this.convertToJS(fileContents));
                }
                exampleFile.put("isXML", Boolean.TRUE);
            }
            catch (Exception e) {
                exampleFile.put("error", e.toString());
                exampleFile.put("error", e.toString());
                String exampleFilesAsJS = null;
                try {
                    exampleFilesAsJS = DataTools.prettyPrint(exampleFiles);
                }
                catch (Exception ee) {
                    exampleFilesAsJS = ee.toString();
                }
                this.log.error((Object)("Error during loadFiles processing - exampleFiles: " + exampleFilesAsJS), e);
            }
        }
        return exampleFiles;
    }

    private String convertToJS(String xml) throws Exception {
        StringWriter sw = new StringWriter();
        SequenceReader reader = new SequenceReader("<isomorphicXML xmlns:xsi=\"nativeType\">", new StringReader(xml), "</isomorphicXML>");
        XML.toJS(reader, (Writer)sw).freeResources();
        return sw.toString();
    }
}

