/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.base;

import com.isomorphic.base.Base;
import com.isomorphic.base.Config;
import com.isomorphic.log.Logger;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public abstract class Service<V>
extends Base
implements Callable<V> {
    private static Logger staticLog = new Logger(Service.class.getName());
    public String invocationType = "callable interface";
    public int interval = -1;
    public String logContext = null;
    public boolean disableLogging = false;
    public boolean ignoreLogging = false;

    public abstract Object execute() throws Exception;

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int value) {
        this.interval = value;
    }

    public void setLogContext(String value) {
        this.logContext = this.logContext;
    }

    public String getLogContext() {
        return this.logContext;
    }

    public boolean getDisableLogging() {
        return this.disableLogging;
    }

    public void setDisableLogging(boolean value) {
        this.disableLogging = value;
    }

    public boolean getIgnoreLogging() {
        return this.ignoreLogging;
    }

    public void setIgnoreLogging(boolean value) {
        this.ignoreLogging = value;
    }

    public void completeInit() throws Exception {
    }

    public static void main(String[] args) {
        DefaultParser parser = new DefaultParser();
        Options options = new Options();
        OptionBuilder.withArgName((String)"property=value");
        OptionBuilder.hasArgs((int)2);
        OptionBuilder.withValueSeparator();
        OptionBuilder.withDescription((String)"use value for given property");
        options.addOption(OptionBuilder.create((String)"D"));
        try {
            CommandLine line = parser.parse(options, args);
            Properties m = line.getOptionProperties("D");
            Config overlayConfig = m != null ? new Config((Map)m) : new Config();
            List restOfArgs = line.getArgList();
            String serviceName = (String)restOfArgs.get(0);
            if (serviceName == null) {
                throw new Exception("serviceName is required");
            }
            String configRoot = "service." + serviceName;
            overlayConfig.put("invocationType", "cli");
            Service.execute(configRoot, overlayConfig);
        }
        catch (Throwable e) {
            staticLog.error(e);
            System.exit(1);
        }
    }

    public static Object execute(String configRoot) throws Exception {
        return Service.execute(configRoot, null);
    }

    public static Object execute(Config overlayConfig) throws Exception {
        String configRoot = overlayConfig.getString("configRoot");
        if (configRoot != null) {
            overlayConfig = new Config((Map)((Object)overlayConfig));
            overlayConfig.remove("configRoot");
        }
        return Service.execute(configRoot, overlayConfig);
    }

    public static Object execute(String configRoot, Config overlayConfig) throws Exception {
        Service service = (Service)Config.getClassInstance(configRoot, overlayConfig);
        return service.call();
    }

    @Override
    public V call() throws Exception {
        if (this.disableLogging) {
            Logger.disableThread();
        }
        if (this.ignoreLogging) {
            Logger.ignoreThread();
        }
        this.completeInit();
        try {
            if (this.logContext == null) {
                this.logContext = this.getLogContext();
            }
            if (this.logContext != null) {
                Logger.pushContext(this.logContext);
            }
            Object intervalString = this.interval + "ms";
            if (this.interval == -1) {
                intervalString = "run once";
            }
            if (this.interval == 0) {
                intervalString = "nodelay loop";
            }
            this.log.debug("Entering run loop from " + this.invocationType + " - interval is: " + (String)intervalString);
            while (true) {
                Object retVal = this.execute();
                if (this.interval == -1) {
                    Object object = retVal;
                    return (V)object;
                }
                try {
                    if (this.interval <= 0) continue;
                    Thread.sleep(this.interval);
                }
                catch (InterruptedException ie) {
                    this.log.info("Caught interrupt, exiting");
                    Object object = retVal;
                    if (this.disableLogging) {
                        Logger.enableThread();
                    }
                    if (this.ignoreLogging) {
                        Logger.observeThread();
                    }
                    if (this.logContext != null) {
                        Service service = this;
                        service.log.popContext();
                    }
                    return (V)object;
                }
            }
        }
        finally {
            if (this.disableLogging) {
                Logger.enableThread();
            }
            if (this.ignoreLogging) {
                Logger.observeThread();
            }
            if (this.logContext != null) {
                Service service = this;
                service.log.popContext();
            }
        }
    }
}

