var employeeTree;

function createTreeGrid(criteria, keepParents) {
    if (!isc.isAn.emptyObject(criteria)) mainLayout.removeMember(employeeTree);

    employeeTree = isc.TreeGrid.create({
        width: 600,
        height: 400,
        dataSource: "employees",
        autoFetchData: true,
        loadDataOnDemand: true,
        showFilterEditor: true,
        filterOnKeypress: true,
        keepParentsOnFilter: keepParents,
        initialCriteria: criteria,
        autoOpenTree: "all",
        fields: [
            { name: "Name", title: "Employee" },
            { name: "Job", title: "Job Title" },
            { name: "EmployeeType", title: "Employee Type" }
        ]
    });
    mainLayout.addMember(employeeTree);
}

isc.VLayout.create({
    ID: "mainLayout",
    width: "100%",
    height: "100%",
    membersMargin: 5,
    members: [
        isc.DynamicForm.create({
            width:600,
            numCols: 8,
            fields: [
                {name:"showContract", title:"Show Contract", type:"button", startRow:false, endRow:false,
                    click:function() {employeeTree.filterData({EmployeeType:'contract'});}
                },
                {name:"showFullTime", title:"Show Full Time", type:"button", startRow:false, endRow:false,
                    click:function() {employeeTree.filterData({EmployeeType:'full time'});}
                },
                {name:"showEngineers", title:"Show Engineers", type:"button", startRow:false, endRow:false,
                    click: function () {
                        var criteria = 
                            { 
                                _constructor:"AdvancedCriteria", 
                                operator:"and", 
                                criteria:[ 
                                    { fieldName:"Job", operator:"iContains", value:"engineer" }
                                ]
                            }
                        employeeTree.filterData(criteria);
                    }
                },
                {name:"keepParents", title:"Keep parents", type:"boolean", showTitle:false, value: true,
                    startRow:false, endRow:false, 
                    changed : function (form,item,value) {
                        var criteria = employeeTree.getCriteria();
                        if (criteria != null && !isc.isAn.emptyObject(criteria)) {
                            createTreeGrid(criteria, value);
                        }
                    }
                }
            ]
        })
    ]
});

createTreeGrid({}, true);

