/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.servlet;

import com.isomorphic.servlet.RequestContext;
import com.isomorphic.servlet.ServletTools;
import com.isomorphic.servlet.URIRegexFilter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

public class NoCacheFilter
extends URIRegexFilter {
    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
    }

    @Override
    public void match(ServletRequest req, ServletResponse res, FilterChain chain) throws ServletException, IOException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        try {
            RequestContext context = RequestContext.instance(this.servletContext, (ServletRequest)request, (ServletResponse)response);
            context.setNoCacheHeaders();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Applied no-cache headers to: " + context.request.getRequestURI());
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Error setting noCache headers for URI: " + ServletTools.getCurrentRequestURI(request)), e);
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

