/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.io.file;

import com.isomorphic.datasource.DSFileSpec;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.io.ISCFile;
import com.isomorphic.log.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ISCFileSourceFile
extends ISCFile {
    private static Logger log = new Logger(ISCFileSourceFile.class.getName());
    protected DSFileSpec fileSpec;

    public ISCFileSourceFile(String path, DSRequest request) {
        super(path, request);
        this.fileSpec = new DSFileSpec(path);
    }

    public ISCFileSourceFile(String path) {
        this(path, null);
    }

    public ISCFileSourceFile(DSFileSpec fileSpec, DSRequest request) {
        super(null, request);
        if (fileSpec == null) {
            throw new IllegalArgumentException("fileSpec cannot be null");
        }
        this.fileSpec = fileSpec;
        this.filename = fileSpec.toString();
    }

    public ISCFileSourceFile(DSFileSpec fileSpec) {
        this(fileSpec, null);
    }

    @Override
    public Object getNativeHandler() {
        return this.fileSpec;
    }

    @Override
    public boolean delete() {
        return this.fileSpec.remove();
    }

    @Override
    public boolean exists() {
        return this.fileSpec.exists();
    }

    @Override
    public boolean renameTo(ISCFile destination) {
        Object handler = destination.getNativeHandler();
        if (handler instanceof DSFileSpec) {
            DSFileSpec nativeDestination = (DSFileSpec)handler;
            try {
                boolean success = this.fileSpec.renameTo(nativeDestination);
                if (success) {
                    this.fileSpec = nativeDestination;
                    if (this.filename != null) {
                        this.filename = this.fileSpec.toString();
                    }
                }
                return success;
            }
            catch (Exception ex) {
                log.warn(ex.toString());
                return false;
            }
        }
        log.warn("renameTo destination was not ISCFileSourceFile");
        return false;
    }

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public boolean canWrite() {
        return true;
    }

    @Override
    public Reader getReader(Charset charset) throws IOException {
        return this.fileSpec.getReader();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.fileSpec.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.fileSpec.getOutputStream();
    }

    @Override
    public Writer getWriter() throws IOException {
        return this.fileSpec.getWriter();
    }

    @Override
    public long length() throws IOException {
        return this.fileSpec.getSize();
    }

    @Override
    public long lastModified() throws IOException {
        return this.fileSpec.getLastModified();
    }

    @Override
    public boolean setLastModified(long time) {
        return this.fileSpec.setLastModified(time);
    }

    @Override
    public Map<String, Object> readAttributes() throws Exception {
        return this.fileSpec.readAttributes();
    }

    @Override
    public List<Map<String, Object>> findChildAttributes(Object criteria, DSRequest request) throws Exception {
        if (request == null) {
            request = this.requestContext;
        }
        return this.fileSpec.findChildAttributes(criteria, request);
    }

    @Override
    public List<ISCFile> findChildren(Object criteria, DSRequest request) throws Exception {
        if (request == null) {
            request = this.requestContext;
        }
        List<DSFileSpec> children = this.fileSpec.findChildren(criteria, request);
        ArrayList<ISCFile> result = new ArrayList<ISCFile>(children.size());
        for (DSFileSpec spec : children) {
            result.add(new ISCFileSourceFile(spec, request));
        }
        return result;
    }

    @Override
    public ISCFile getChild(String path, DSRequest request) {
        return this.getChild(ISCFileSourceFile.parseFileExtensions(path), request);
    }

    @Override
    public ISCFile getChild(Map<String, Object> primaryKeys, DSRequest request) {
        if (request == null) {
            request = this.requestContext;
        }
        DSFileSpec child = this.fileSpec.getChild(primaryKeys, request);
        return new ISCFileSourceFile(child, request);
    }
}

