/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal;

import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.internal.EmbeddedAttributeMapping;
import org.hibernate.sql.ast.tree.delete.DeleteStatement;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;

public class SqmMutationStrategyHelper {
    private SqmMutationStrategyHelper() {
    }

    public static void visitCollectionTables(EntityMappingType entityDescriptor, Consumer<PluralAttributeMapping> consumer) {
        if (!entityDescriptor.getEntityPersister().hasCollections()) {
            return;
        }
        entityDescriptor.visitSubTypeAttributeMappings(attributeMapping -> {
            if (attributeMapping instanceof PluralAttributeMapping) {
                consumer.accept((PluralAttributeMapping)attributeMapping);
            } else if (attributeMapping instanceof EmbeddedAttributeMapping) {
                SqmMutationStrategyHelper.visitCollectionTables((EmbeddedAttributeMapping)attributeMapping, consumer);
            }
        });
    }

    private static void visitCollectionTables(EmbeddedAttributeMapping attributeMapping, Consumer<PluralAttributeMapping> consumer) {
        attributeMapping.visitSubParts(modelPart -> {
            if (modelPart instanceof PluralAttributeMapping) {
                consumer.accept((PluralAttributeMapping)modelPart);
            } else if (modelPart instanceof EmbeddedAttributeMapping) {
                SqmMutationStrategyHelper.visitCollectionTables((EmbeddedAttributeMapping)modelPart, consumer);
            }
        }, null);
    }

    public static void cleanUpCollectionTables(EntityMappingType entityDescriptor, BiFunction<TableReference, PluralAttributeMapping, Predicate> restrictionProducer, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext) {
        if (!entityDescriptor.getEntityPersister().hasCollections()) {
            return;
        }
        entityDescriptor.visitSubTypeAttributeMappings(attributeMapping -> {
            if (attributeMapping instanceof PluralAttributeMapping) {
                SqmMutationStrategyHelper.cleanUpCollectionTable((PluralAttributeMapping)attributeMapping, entityDescriptor, restrictionProducer, jdbcParameterBindings, executionContext);
            } else if (attributeMapping instanceof EmbeddedAttributeMapping) {
                SqmMutationStrategyHelper.cleanUpCollectionTables((EmbeddedAttributeMapping)attributeMapping, entityDescriptor, restrictionProducer, jdbcParameterBindings, executionContext);
            }
        });
    }

    private static void cleanUpCollectionTables(EmbeddedAttributeMapping attributeMapping, EntityMappingType entityDescriptor, BiFunction<TableReference, PluralAttributeMapping, Predicate> restrictionProducer, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext) {
        attributeMapping.visitSubParts(modelPart -> {
            if (modelPart instanceof PluralAttributeMapping) {
                SqmMutationStrategyHelper.cleanUpCollectionTable((PluralAttributeMapping)modelPart, entityDescriptor, restrictionProducer, jdbcParameterBindings, executionContext);
            } else if (modelPart instanceof EmbeddedAttributeMapping) {
                SqmMutationStrategyHelper.cleanUpCollectionTables((EmbeddedAttributeMapping)modelPart, entityDescriptor, restrictionProducer, jdbcParameterBindings, executionContext);
            }
        }, null);
    }

    private static void cleanUpCollectionTable(PluralAttributeMapping attributeMapping, EntityMappingType entityDescriptor, BiFunction<TableReference, PluralAttributeMapping, Predicate> restrictionProducer, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext) {
        String separateCollectionTable = attributeMapping.getSeparateCollectionTable();
        SessionFactoryImplementor sessionFactory = executionContext.getSession().getFactory();
        JdbcServices jdbcServices = sessionFactory.getJdbcServices();
        if (separateCollectionTable != null) {
            NamedTableReference tableReference = new NamedTableReference(separateCollectionTable, "to_delete_", true);
            DeleteStatement sqlAstDelete = new DeleteStatement(tableReference, restrictionProducer.apply(tableReference, attributeMapping));
            jdbcServices.getJdbcMutationExecutor().execute(jdbcServices.getJdbcEnvironment().getSqlAstTranslatorFactory().buildMutationTranslator(sessionFactory, sqlAstDelete).translate(jdbcParameterBindings, executionContext.getQueryOptions()), jdbcParameterBindings, sql -> executionContext.getSession().getJdbcCoordinator().getStatementPreparer().prepareStatement((String)sql), (integer, preparedStatement) -> {}, executionContext);
        }
    }
}

