/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.pool;

import com.isomorphic.base.Config;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.pool.impl.GenericObjectPool;

public class ISCObjectPoolConfig
extends GenericObjectPool.Config {
    private static Logger log = new Logger(ISCObjectPoolConfig.class.getName());
    private static Config config = Config.getGlobal();

    public ISCObjectPoolConfig() {
        try {
            DataTools.setProperties((Map)((Object)config.getSubtree("pooling.default")), (Object)this);
        }
        catch (Exception e) {
            log.error("Problem initializing default pool parameters.");
        }
    }

    public static ISCObjectPoolConfig forConfigRoot(String configRoot) throws Exception {
        return ISCObjectPoolConfig.forConfigMap((Map)((Object)config.getSubtree(configRoot)));
    }

    public static ISCObjectPoolConfig forConfigMap(Map configForPool) throws Exception {
        ISCObjectPoolConfig poolConfig = new ISCObjectPoolConfig();
        String whenExhaustedAction = MapUtils.getString((Map)configForPool, (Object)"whenExhaustedAction");
        configForPool.remove("whenExhaustedAction");
        DataTools.setProperties(configForPool, (Object)poolConfig);
        if (whenExhaustedAction != null) {
            if (whenExhaustedAction.equals("WHEN_EXHAUSTED_GROW")) {
                poolConfig.whenExhaustedAction = (byte)2;
            }
            if (whenExhaustedAction.equals("WHEN_EXHAUSTED_BLOCK")) {
                poolConfig.whenExhaustedAction = 1;
            }
            if (whenExhaustedAction.equals("WHEN_EXHAUSTED_FAIL")) {
                poolConfig.whenExhaustedAction = 0;
            }
        }
        return poolConfig;
    }
}

