/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.autotest;

import com.isomorphic.autotest.TestRunner;
import com.isomorphic.autotest.TestRunnerLauncher;
import com.isomorphic.autotest.TestRunnerWebDriver;
import com.isomorphic.devenv.DevUtil;
import com.isomorphic.log.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class BuilderSpecifier {
    private static Logger log = new Logger(BuilderSpecifier.class.getName());
    static final String[] possibleBuilders;
    static final String[] builderShortcuts;
    static final String[] CAMEL_CASE_BUILDERS;
    static final String[] TEST_DIRECTORIES;
    static TestRunnerLauncher launcher;
    private BuilderSpecifierType m_type;
    private boolean autoGeneratedUser;

    private BuilderSpecifier(String builder) throws Exception {
        for (BuilderSpecifierType t : BuilderSpecifierType.values()) {
            if (!possibleBuilders[t.ordinal()].equals(builder)) continue;
            this.m_type = t;
            break;
        }
        if (this.m_type == null) {
            throw new Exception("Unrecognized builder: " + builder);
        }
        if (launcher == null) {
            launcher = (TestRunnerLauncher)TestRunner.getConfiguration();
        }
        if (this.isReifyCloud()) {
            this.autoGeneratedUser = launcher.getTargetUserName().equals("reifyTest*");
        }
    }

    public static BuilderSpecifier newInstance(String builder) {
        if (builder != null) {
            try {
                return new BuilderSpecifier(builder);
            }
            catch (Exception e) {
                log.error((Object)("unable to create specifier for builder: " + builder), (Throwable)e);
            }
        }
        return null;
    }

    static String getSubdirectoryRegEx(BuilderSpecifier builder) {
        return builder != null ? "/(" + StringUtils.join((Object[])builder.getTestDirectories(), (String)"|") + ")/" : "(?!/(" + StringUtils.join((Object[])TEST_DIRECTORIES, (String)"|") + ")/)";
    }

    String[] getTestDirectories() {
        ArrayList<String> dirs = new ArrayList<String>(Arrays.asList("ReifyCommon"));
        switch (this.m_type) {
            case bsReifySolo: {
                dirs.set(0, "ReifySolo");
                break;
            }
            case bsReifyCloud: {
                dirs.add("ReifyCloud");
                break;
            }
            case bsReifyOnSite: {
                dirs.add("ReifyOnSite");
            }
        }
        return dirs.toArray(new String[0]);
    }

    void testEnd(TestRunnerWebDriver driver, boolean removeAccount) {
        driver.getEval("isc.isA.Reify(VB)");
        String username = (String)driver.getAsyncEvalWithTry("VB.testEnd('" + (switch (this.m_type) {
            default -> "testReifySoloEnd";
            case BuilderSpecifierType.bsReifyCloud, BuilderSpecifierType.bsReifyOnSite -> "testReifyCloudEnd";
        }) + "',arguments[1],arguments[0]);", this.autoGeneratedUser && removeAccount);
        if (this.autoGeneratedUser && username != null && !launcher.getTargetUserName().equals(username)) {
            launcher.setTargetUserName(username);
            log.info((Object)("replaced wildcard Reify test account with " + username));
        }
    }

    protected static List<String> getCommitBuilders(String branch, Date batchStartTime) {
        ArrayList<String> builders = new ArrayList<String>();
        if (DevUtil.compareBranches(branch, "ISC_130_BRANCH") > 0) {
            builders.add("reifyonsite");
        }
        return builders;
    }

    protected static List<String> getScheduledBuilders(String branch, Date batchStartTime) {
        ArrayList<String> builders = new ArrayList<String>();
        if (DevUtil.branchVersion(branch) > 130) {
            builders.add("reifycloud");
        }
        return builders;
    }

    protected static List<String> getCriticalBuilders(String branch, Date batchStartTime) {
        ArrayList<String> builders = new ArrayList<String>();
        return builders;
    }

    protected static boolean isBuilderValid(String builder) {
        return Arrays.asList(possibleBuilders).contains(builder);
    }

    protected static boolean isReifyCloud(String builder) {
        int ordinal = BuilderSpecifierType.bsReifyCloud.ordinal();
        return possibleBuilders[ordinal].equals(builder);
    }

    public static String getBuilder(String builder) {
        return BuilderSpecifier.isBuilderValid(builder) ? builder : null;
    }

    protected static String getBuilderAsCamelCase(String builder) {
        for (int i = 0; i < CAMEL_CASE_BUILDERS.length; ++i) {
            if (!possibleBuilders[i].equals(builder)) continue;
            return CAMEL_CASE_BUILDERS[i];
        }
        return null;
    }

    protected static String getPrintableBuilderDescription(String builder) {
        for (int i = 0; i < CAMEL_CASE_BUILDERS.length; ++i) {
            if (!possibleBuilders[i].equals(builder)) continue;
            BuilderSpecifierType specifier = BuilderSpecifierType.values()[i];
            switch (specifier) {
                case bsReifyCloud: {
                    return "Reify.com";
                }
                case bsReifyOnSite: {
                    return "Reify OnSite";
                }
                case bsReifySolo: {
                    return "Reify Solo";
                }
            }
        }
        return null;
    }

    public boolean isReifySolo() {
        return this.m_type == BuilderSpecifierType.bsReifySolo;
    }

    public boolean isReifyCloud() {
        return this.m_type == BuilderSpecifierType.bsReifyCloud;
    }

    public boolean isReifyOnSite() {
        return this.m_type == BuilderSpecifierType.bsReifyOnSite;
    }

    public boolean requiresAuth() {
        return this.m_type != BuilderSpecifierType.bsReifySolo;
    }

    public String getBuilderName() {
        return possibleBuilders[this.m_type.ordinal()];
    }

    static {
        CAMEL_CASE_BUILDERS = new String[]{"reifySolo", "reifyCloud", "reifyOnSite"};
        int nBuilders = CAMEL_CASE_BUILDERS.length;
        possibleBuilders = new String[nBuilders];
        builderShortcuts = new String[nBuilders];
        for (int i = 0; i < nBuilders; ++i) {
            String builder = CAMEL_CASE_BUILDERS[i].toLowerCase();
            BuilderSpecifier.builderShortcuts[i] = builder.substring(5, builder.length());
            BuilderSpecifier.possibleBuilders[i] = builder;
        }
        TEST_DIRECTORIES = new String[]{"ReifyCommon", "ReifySolo", "ReifyCloud", "ReifyOnSite"};
    }

    static enum BuilderSpecifierType {
        bsReifySolo,
        bsReifyCloud,
        bsReifyOnSite;

    }
}

