/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.servlet;

import com.isomorphic.servlet.BaseServlet;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.IOUtil;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SourceViewer
extends BaseServlet {
    public String allowedExtensions;
    public Map allowedExtensionsHash = new HashMap();

    public void setAllowedExtensions(String value) {
        this.allowedExtensions = value;
        if (value != null) {
            List<String> list = DataTools.commaSeparatedStringToList(value);
            for (String extension : list) {
                if (extension.equals("") || extension.indexOf(" ") != -1) {
                    this.log.warn("Skipping invalid value for allowedExtensions parameter: ->" + extension + "<-");
                    continue;
                }
                this.allowedExtensionsHash.put(extension, new Object());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Writer out = null;
        try {
            RequestContext context = RequestContext.instance((Servlet)this, request, response);
            context.setContentType("text/plain");
            out = response.getWriter();
            String files = request.getParameter("file");
            if (files == null) {
                files = request.getParameter("files");
            }
            if (files == null) {
                out.write("I need a file name as 'file' param");
                return;
            }
            List<String> fileList = DataTools.simpleSplit(files, ",");
            boolean firstFile = true;
            Iterator<String> i = fileList.iterator();
            while (i.hasNext()) {
                String source;
                Object file = i.next().trim();
                if (!((String)file).startsWith("/")) {
                    String referer = request.getHeader("referer");
                    if (referer == null) {
                        out.write("Referer header required for relative links");
                        return;
                    }
                    if (!referer.startsWith("/")) {
                        if ((referer = referer.substring(referer.indexOf("//") + 2)).indexOf("/") != -1) {
                            if ((referer = referer.substring(referer.indexOf("/"))).indexOf("/") != -1) {
                                referer = referer.substring(0, referer.lastIndexOf("/"));
                            }
                        } else {
                            referer = "";
                        }
                    }
                    file = referer + "/" + (String)file;
                }
                if (this.allowedExtensions == null || this.allowedExtensionsHash.size() == 0) {
                    this.log.error("allowedExtensions has not been configured.  Source access to: " + (String)file + " DENIED - 404 sent to browser.");
                    context.response.sendError(404);
                    return;
                }
                String fileExtension = "";
                if (((String)file).lastIndexOf(".") != -1) {
                    fileExtension = ((String)file).substring(((String)file).lastIndexOf(".") + 1);
                }
                boolean extensionIsAllowed = false;
                if (this.allowedExtensionsHash.get(fileExtension) != null) {
                    extensionIsAllowed = true;
                }
                if (!extensionIsAllowed && this.allowedExtensionsHash.keySet().contains("*")) {
                    extensionIsAllowed = true;
                }
                if (!extensionIsAllowed) {
                    this.log.warn("Source access to: " + (String)file + " DENIED because file does not match list of allowed extensions: (" + this.allowedExtensions + ") - 404 sent to browser.");
                    context.response.sendError(404);
                    return;
                }
                try {
                    source = IOUtil.inputStreamToString(context.servletContext.getResourceAsStream((String)file));
                }
                catch (Exception e) {
                    out.write("File not found: " + (String)file);
                    try {
                        if (out != null) {
                            out.flush();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        response.flushBuffer();
                        return;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return;
                }
                out.write("<!-- **************************************************************************** -->\n");
                out.write("<!-- FILE: " + (String)file + " -->\n");
                out.write("<!-- **************************************************************************** -->\n");
                if (firstFile) {
                    for (int j = 0; j < 2049; ++j) {
                        out.write(" ");
                    }
                    firstFile = false;
                }
                out.write("\n");
                out.write(source);
            }
            return;
        }
        catch (Exception ee) {
            this.log.error((Object)"outputSource", ee);
            try {
                if (out == null) return;
                out.write(ee.toString());
                return;
            }
            catch (Exception exception) {
                // empty catch block
                return;
            }
        }
        finally {
            try {
                if (out != null) {
                    out.flush();
                }
            }
            catch (Exception exception) {}
            try {
                response.flushBuffer();
            }
            catch (Exception exception) {}
        }
    }
}

