/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.spring;

import com.isomorphic.base.Config;
import com.isomorphic.interfaces.ISpringBeanFactory;
import com.isomorphic.io.ISCFile;
import jakarta.servlet.ServletContext;
import java.util.List;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SpringBeanFactory
implements ISpringBeanFactory {
    protected static ApplicationContext ac;

    public BeanFactory getBeanFactory(ServletContext servletContext) throws Exception {
        if (servletContext != null) {
            return WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext);
        }
        if (ac == null) {
            Config config = Config.getGlobal();
            List locationList = config.getCommaSeparatedList((Object)"standalone.spring.applicationContext");
            String[] locations = new String[locationList.size()];
            for (int i = 0; i < locationList.size(); ++i) {
                Object path;
                Object object = path = locationList.get(i) == null ? null : locationList.get(i).toString();
                if (path == null) continue;
                if (!((String)path).startsWith("file:") && !((String)path).startsWith("classpath:")) {
                    if (!((String)(path = ISCFile.canonicalizePath((String)path))).startsWith("/")) {
                        path = "/" + (String)path;
                    }
                    locations[i] = "file://" + (String)path;
                    continue;
                }
                locations[i] = path;
            }
            ac = new FileSystemXmlApplicationContext(locations);
        }
        return ac;
    }

    public Object getBean(ServletContext servletContext, String bean) throws Exception {
        return this.getBeanFactory(servletContext).getBean(bean);
    }
}

