/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.util.Arrays;
import java.util.List;
import org.hibernate.query.ReturnableType;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.function.AbstractSqmFunctionDescriptor;
import org.hibernate.query.sqm.function.SelfRenderingSqmFunction;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionArgumentTypeResolvers;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.expression.SqmExpression;

public class NvlCoalesceEmulation
extends AbstractSqmFunctionDescriptor {
    public NvlCoalesceEmulation() {
        super("coalesce", StandardArgumentsValidators.min(2), StandardFunctionReturnTypeResolvers.useFirstNonNull(), StandardFunctionArgumentTypeResolvers.IMPLIED_RESULT_TYPE);
    }

    @Override
    protected <T> SelfRenderingSqmFunction<T> generateSqmFunctionExpression(List<? extends SqmTypedNode<?>> arguments, ReturnableType<T> impliedResultType, QueryEngine queryEngine) {
        SqmFunctionDescriptor nvl = queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("nvl").setExactArgumentCount(2).descriptor();
        int pos = arguments.size();
        SelfRenderingSqmFunction result = (SelfRenderingSqmFunction)arguments.get(--pos);
        ReturnableType type = (ReturnableType)result.getNodeType();
        while (pos > 0) {
            SqmExpression next = (SqmExpression)arguments.get(--pos);
            result = nvl.generateSqmExpression(Arrays.asList(next, result), type, queryEngine);
        }
        return result;
    }
}

