/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.scheduler;

import com.isomorphic.criteria.AdvancedCriteria;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.scheduler.QuartzBasicDataSource;
import com.isomorphic.util.DataTools;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.matchers.GroupMatcher;

public class QuartzTriggers
extends QuartzBasicDataSource {
    public DSResponse executeCustom(DSRequest req) throws Exception {
        DSResponse response = new DSResponse();
        response.setDataSource((DataSource)this);
        response.setSuccess();
        String op = req.getOperation();
        Map values = req.getValues();
        String triggerName = (String)values.get("name");
        String triggerGroup = (String)values.get("group");
        TriggerKey triggerKey = new TriggerKey(triggerName, triggerGroup);
        if (op.equals("pauseTrigger")) {
            QuartzTriggers.getScheduler().pauseTrigger(triggerKey);
        } else if (op.equals("resumeTrigger")) {
            QuartzTriggers.getScheduler().resumeTrigger(triggerKey);
        }
        return response;
    }

    public DSResponse executeFetch(DSRequest req) throws Exception {
        List<Trigger> triggers;
        DSResponse response = new DSResponse();
        response.setDataSource((DataSource)this);
        response.setSuccess();
        AdvancedCriteria ac = req.getAdvancedCriteria();
        String jobGroup = null;
        String jobName = null;
        if (ac != null) {
            jobGroup = (String)ac.getFieldValue("jobGroup");
            jobName = (String)ac.getFieldValue("jobName");
        }
        if (jobGroup == null && jobName == null) {
            triggers = new ArrayList();
            for (String triggerGroup : QuartzTriggers.getScheduler().getTriggerGroupNames()) {
                for (TriggerKey triggerKey : QuartzTriggers.getScheduler().getTriggerKeys(GroupMatcher.triggerGroupEquals((String)triggerGroup))) {
                    triggers.add(QuartzTriggers.getScheduler().getTrigger(triggerKey));
                }
            }
        } else {
            triggers = QuartzTriggers.getScheduler().getTriggersOfJob(new JobKey(jobName, jobGroup));
        }
        ArrayList<Map> data = new ArrayList<Map>();
        for (Trigger trigger : triggers) {
            Map record = this.convertTriggerToMap(trigger);
            data.add(record);
        }
        response.setData(data);
        return response;
    }

    public DSResponse executeAdd(DSRequest req) throws Exception {
        DSResponse response = new DSResponse();
        response.setDataSource((DataSource)this);
        response.setSuccess();
        Map record = req.getValues();
        Trigger trigger = this.convertMapToTrigger(record);
        QuartzTriggers.getScheduler().scheduleJob(trigger);
        record = this.convertTriggerToMap(QuartzTriggers.getScheduler().getTrigger(trigger.getKey()));
        response.setData((Object)record);
        return response;
    }

    public DSResponse executeUpdate(DSRequest req) throws Exception {
        DSResponse response = new DSResponse();
        response.setDataSource((DataSource)this);
        response.setSuccess();
        Map record = DataTools.mapMerge((Map)req.getOldValues(), new HashMap());
        DataTools.mapMerge((Map)req.getValues(), (Map)record);
        String jobName = (String)record.get("jobName");
        String jobGroup = (String)record.get("jobGroup");
        JobKey jobKey = new JobKey(jobName, jobGroup);
        JobDetail job = QuartzTriggers.getScheduler().getJobDetail(jobKey);
        Trigger trigger = this.convertMapToTrigger(record);
        Map oldRecord = req.getOldValues();
        String oldGroup = (String)oldRecord.get("group");
        String oldName = (String)oldRecord.get("name");
        String group = (String)record.get("group");
        String name = (String)record.get("name");
        if (oldGroup == null) {
            oldGroup = group;
        }
        if (oldName == null) {
            oldName = name;
        }
        QuartzTriggers.getScheduler().rescheduleJob(new TriggerKey(oldName, oldGroup), trigger);
        record = this.convertTriggerToMap(QuartzTriggers.getScheduler().getTrigger(trigger.getKey()));
        response.setData((Object)record);
        return response;
    }

    public DSResponse executeRemove(DSRequest req) throws Exception {
        DSResponse response = new DSResponse();
        response.setDataSource((DataSource)this);
        response.setSuccess();
        Map record = req.getValues();
        String triggerName = (String)record.get("name");
        String triggerGroup = (String)record.get("group");
        QuartzTriggers.getScheduler().unscheduleJob(new TriggerKey(triggerName, triggerGroup));
        response.setData((Object)req.getOldValues());
        return response;
    }

    private Map convertTriggerToMap(Trigger trigger) throws Exception {
        HashMap<String, Object> record = new HashMap<String, Object>();
        record.put("jobGroup", trigger.getJobKey().getGroup());
        record.put("jobName", trigger.getJobKey().getName());
        record.put("group", trigger.getKey().getGroup());
        record.put("name", trigger.getKey().getName());
        record.put("description", trigger.getDescription());
        record.put("state", QuartzTriggers.getScheduler().getTriggerState(trigger.getKey()));
        record.put("startTime", trigger.getStartTime());
        record.put("endTime", trigger.getEndTime());
        record.put("misfireInstruction", trigger.getMisfireInstruction());
        record.put("dataMap", trigger.getJobDataMap());
        if (trigger instanceof CronTrigger) {
            CronTrigger cronTrigger = (CronTrigger)trigger;
            TimeZone tz = cronTrigger.getTimeZone();
            if (tz != null) {
                record.put("timeZone", tz.getID());
            }
            record.put("cronExpression", cronTrigger.getCronExpression());
        }
        return record;
    }

    private Trigger convertMapToTrigger(Map record) throws ParseException {
        String cronExpression;
        TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger().withIdentity(new TriggerKey((String)record.get("name"), (String)record.get("group"))).forJob(new JobKey((String)record.get("jobName"), (String)record.get("jobGroup"))).withDescription((String)record.get("description"));
        if (record.get("dataMap") != null) {
            triggerBuilder.usingJobData(new JobDataMap((Map)record.get("dataMap")));
        }
        if (record.get("startTime") != null) {
            triggerBuilder.startAt((Date)record.get("startTime"));
        }
        if (record.get("endTime") != null) {
            triggerBuilder.endAt((Date)record.get("endTime"));
        }
        if ((cronExpression = (String)record.get("cronExpression")) != null) {
            String timezone;
            CronScheduleBuilder cronScheduleBuilder = CronScheduleBuilder.cronSchedule((String)cronExpression);
            Long misfireInstructionI = (Long)record.get("misfireInstruction");
            if (misfireInstructionI != null) {
                int misfireInstruction = misfireInstructionI.intValue();
                if (misfireInstruction == 2) {
                    cronScheduleBuilder.withMisfireHandlingInstructionDoNothing();
                } else if (misfireInstruction == 1) {
                    cronScheduleBuilder.withMisfireHandlingInstructionFireAndProceed();
                } else if (misfireInstruction == -1) {
                    cronScheduleBuilder.withMisfireHandlingInstructionIgnoreMisfires();
                }
            }
            if ((timezone = (String)record.get("timeZone")) != null && timezone.length() > 0) {
                cronScheduleBuilder.inTimeZone(TimeZone.getTimeZone(timezone));
            }
            triggerBuilder.withSchedule((ScheduleBuilder)cronScheduleBuilder);
        }
        return triggerBuilder.build();
    }
}

