/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.scheduler;

import com.isomorphic.base.Base;
import com.isomorphic.log.Logger;
import com.isomorphic.scheduler.QuartzBasicDataSource;
import com.isomorphic.util.DataTools;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.JobListener;
import org.quartz.Scheduler;

public class QuartzJobRunner
extends Base
implements JobListener {
    private static Logger log = new Logger(QuartzJobRunner.class.getName());
    private static Scheduler scheduler = null;
    JobExecutionContext jec;

    public static void main(String[] args) {
        try {
            scheduler = QuartzBasicDataSource.getScheduler();
            scheduler.start();
            new QuartzJobRunner().execute(args);
        }
        catch (Exception e) {
            log.fatal((Object)"Top-level exception", (Throwable)e);
            System.exit(1);
        }
        finally {
            if (scheduler != null) {
                try {
                    scheduler.shutdown();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String[] args) throws Exception {
        DefaultParser parser = new DefaultParser();
        String cmdLineSyntax = "runQuartzJob jobName [options]";
        Options options = new Options();
        OptionBuilder.withArgName((String)"property=value");
        OptionBuilder.hasArgs((int)2);
        OptionBuilder.withValueSeparator();
        OptionBuilder.withDescription((String)"use value for given property");
        Option property = OptionBuilder.create((String)"D");
        options.addOption(property);
        CommandLine line = parser.parse(options, args);
        Properties jobDataMapProperties = line.getOptionProperties("D");
        List argList = line.getArgList();
        if (argList.size() == 0 || argList.size() > 1) {
            this.outputHelp(cmdLineSyntax, options);
            System.exit(1);
        }
        String jobName = (String)argList.get(0);
        String jobGroup = "DEFAULT";
        if (jobName.indexOf(".") != -1) {
            List l = DataTools.simpleSplit((String)jobName, (String)".");
            jobGroup = (String)l.get(0);
            jobName = (String)l.get(1);
        }
        JobKey jobKey = new JobKey(jobName, jobGroup);
        JobDataMap jobDataMap = new JobDataMap((Map)jobDataMapProperties);
        scheduler.getListenerManager().addJobListener((JobListener)this);
        scheduler.triggerJob(jobKey, jobDataMap);
        while (this.jec == null) {
            QuartzJobRunner quartzJobRunner = this;
            synchronized (quartzJobRunner) {
                ((Object)((Object)this)).wait();
            }
        }
        Object result = this.jec.getResult();
        if (result != null) {
            log.info((Object)("Job result: " + DataTools.prettyPrint((Object)result)));
        }
    }

    public void outputHelp(String cmdLineSyntax, Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(cmdLineSyntax, "", options, "\nUtility to run the specified Quartz Job from the command line\n property/value supplied via -D options are placed into the JobDatMap for the job\n Examples:\n> runQuartzJob -D foo=bar MyJob\n> runQuartzJob MyGroup.MyJob");
    }

    public String getName() {
        return QuartzJobRunner.class.getName() + "Listener";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jobWasExecuted(JobExecutionContext jec, JobExecutionException jobException) {
        this.jec = jec;
        QuartzJobRunner quartzJobRunner = this;
        synchronized (quartzJobRunner) {
            ((Object)((Object)this)).notify();
        }
    }

    public void jobToBeExecuted(JobExecutionContext context) {
    }

    public void jobExecutionVetoed(JobExecutionContext jec) {
        log.info((Object)"Job execution was vetoed");
        System.exit(0);
    }
}

