/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.hibernate;

import com.isomorphic.base.Config;
import com.isomorphic.base.Reflection;
import com.isomorphic.hibernate.HBProviderInterface;
import com.isomorphic.hibernate.MetadataCache;
import com.isomorphic.io.ISCFile;
import com.isomorphic.log.Logger;
import com.isomorphic.rpc.ServerObject;
import com.isomorphic.servlet.RequestContext;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.hbm2ddl.SchemaUpdate;

public class SpringHB6Provider
implements HBProviderInterface {
    private static final String CLASS_NAME = SpringHB6Provider.class.getName();
    private static final Logger log = new Logger(CLASS_NAME);
    public static final String CONFIG_BEAN = "config.bean";
    protected String configBean;
    protected Configuration configuration;
    protected SessionFactory factory;
    protected Metadata metadata;

    public SpringHB6Provider() {
        this(Config.getGlobal().getSubtree("hibernate").asProperties());
    }

    public SpringHB6Provider(Properties config) {
        this(config.getProperty(CONFIG_BEAN));
    }

    public SpringHB6Provider(String configBean) {
        Dialect dialect;
        if (configBean == null) {
            throw new HibernateException("Configuration file is not specified.");
        }
        this.configBean = configBean;
        HashMap<String, Object> serverObjectConfig = new HashMap<String, Object>();
        serverObjectConfig.put("bean", "&" + configBean);
        serverObjectConfig.put("lookupStyle", "spring");
        RequestContext context = new RequestContext();
        context.servletContext = ISCFile.servletContext;
        try {
            ServerObject serverObject = new ServerObject(serverObjectConfig, context, "Initializing local HibernateDataSource config");
            Object factoryBean = serverObject.getInstance();
            if (factoryBean != null) {
                Class factoryBeanClassV5 = null;
                try {
                    factoryBeanClassV5 = Reflection.classForName((String)"org.springframework.orm.hibernate5.LocalSessionFactoryBean");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (factoryBeanClassV5 == null) {
                    throw new Exception("Didn't find org.springframework.orm.hibernate5.LocalSessionFactoryBean class when attempting to obtain Hibernate config from Spring - is Spring correctly installed and configured?");
                }
                if (factoryBeanClassV5 == null || !factoryBeanClassV5.isAssignableFrom(factoryBean.getClass())) {
                    throw new Exception("Factory bean is not an instance of org.springframework.orm.hibernate5.LocalSessionFactoryBean class- is Spring correctly installed and configured?");
                }
            } else {
                throw new Exception("Attempted lookup of Hibernate config at Spring bean '" + configBean + "' failed; the returned object was null.");
            }
            Method method = Reflection.findMethod((Object)factoryBean, (String)"getConfiguration");
            this.configuration = (Configuration)method.invoke(factoryBean, new Object[0]);
            method = Reflection.findMethod((Object)factoryBean, (String)"getObject");
            this.factory = (SessionFactory)method.invoke(factoryBean, new Object[0]);
            this.metadata = MetadataCache.get(this.configuration);
        }
        catch (Exception ex) {
            throw new HibernateException("Failed to initialize Spring HB4 Provider", (Throwable)ex);
        }
        if (this.configuration.getProperties().get("hibernate.dialect") == null && (dialect = this.getDialect()) != null) {
            log.info((Object)("Hibernate dialect autodection did not propagate  to hibernate env properties - pushing it manually (dialect: " + dialect.toString() + ")"));
            this.configuration.getProperties().put("hibernate.dialect", dialect.toString());
        }
    }

    @Override
    public synchronized SessionFactory get() {
        log.info((Object)"Getting factory");
        return this.factory;
    }

    @Override
    public synchronized Session getSession() throws HibernateException {
        log.info((Object)"Getting session");
        return this.factory.openSession();
    }

    @Override
    public void returnSession(Session session) {
        log.info((Object)"Returning session");
        if (session != null) {
            try {
                if (session.isOpen()) {
                    session.close();
                }
            }
            catch (HibernateException ex) {
                log.warn((Object)"Failed to close session.", (Throwable)ex);
            }
        }
    }

    @Override
    public Transaction getTransaction(Session session) throws HibernateException {
        log.info((Object)"Getting transaction");
        if (session != null) {
            Transaction tx = session.getTransaction();
            if (!tx.isActive()) {
                tx.begin();
            }
            return tx;
        }
        throw new HibernateException("Session manager not provided.");
    }

    @Override
    public void commitTransaction(Transaction tx) throws HibernateException {
        log.info((Object)"Committing transaction");
        if (tx != null && tx.isActive()) {
            tx.commit();
        }
    }

    @Override
    public void rollbackTransaction(Transaction tx) {
        log.info((Object)"Rilling back transaction");
        if (tx != null && tx.isActive()) {
            try {
                tx.rollback();
            }
            catch (Exception ex) {
                log.warn((Object)"Unexpected exception while rolling back transaction", (Throwable)ex);
            }
        }
    }

    @Override
    public synchronized Dialect getDialect() {
        log.info((Object)"Getting dialect");
        try {
            StandardServiceRegistry registry = this.factory.getSessionFactoryOptions().getServiceRegistry();
            return ((JdbcServices)registry.getService(JdbcServices.class)).getDialect();
        }
        catch (Exception ex) {
            log.warn((Object)"Failed to acquire Hibernate dialect", (Throwable)ex);
            return null;
        }
    }

    @Override
    public synchronized Metadata getMetadata() {
        log.info((Object)"Getting metadata");
        return this.metadata;
    }

    @Override
    public synchronized Iterator<PersistentClass> getMappings() {
        log.info((Object)"Getting mappings");
        return this.metadata.getEntityBindings().iterator();
    }

    @Override
    public synchronized PersistentClass getMapping(String entityName) {
        log.info((Object)("Getting mapping: " + entityName));
        return this.metadata.getEntityBinding(entityName);
    }

    @Override
    public synchronized Collection getCollectionMapping(String role) {
        log.info((Object)("Getting collection mapping: " + role));
        return this.metadata.getCollectionBinding(role);
    }

    @Override
    public synchronized void addMapping(String mapping) {
        throw new HibernateException("Can not add mapping '" + mapping + "'.  Your Hibernate configuration is being provided by Spring bean '" + this.configBean + "' - you need to ensure that this bean contains atrributes to describe your mappings, or set the 'configLocation' attribute to point it at a .cfg.xml file that defines your mappings.  Note that 'beanless mode' (where we automatically bind missing entities to a HashMap at runtime) is not supported where Hibernate is configured via Spring");
    }

    @Override
    public synchronized void addMapping(Class mapping) {
        throw new HibernateException("Can not add mapping '" + mapping.getName() + "'.  Your Hibernate configuration is being provided by Spring bean '" + this.configBean + "' - you need to ensure that this bean contains atrributes to describe your mappings, or set the 'configLocation' attribute to point it at a .cfg.xml file that defines your mappings.  Note that 'beanless mode' (where we automatically bind missing entities to a HashMap at runtime) is not supported where Hibernate is configured via Spring");
    }

    @Override
    public synchronized SchemaUpdate getSchemaUpdate() {
        log.info((Object)"Getting schema update");
        return new SchemaUpdate();
    }

    @Override
    public synchronized SchemaExport getSchemaExport() {
        log.info((Object)"Getting schema export");
        return new SchemaExport();
    }
}

