/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.hibernate;

import com.isomorphic.base.Config;
import com.isomorphic.hibernate.CastToBinaryFunction;
import com.isomorphic.hibernate.HBProviderInterface;
import com.isomorphic.io.ISCFile;
import com.isomorphic.log.Logger;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.boot.MappingNotFoundException;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.jaxb.spi.Binding;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.boot.spi.MetadataBuilderImplementor;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.hbm2ddl.SchemaUpdate;
import org.hibernate.type.spi.TypeConfiguration;

public class HB6Provider
implements HBProviderInterface {
    private static final String CLASS_NAME = HB6Provider.class.getName();
    private static final Logger log = new Logger(CLASS_NAME);
    public static final String CONFIG = "config";
    protected Configuration configuration;
    protected SessionFactory factory;
    protected ServiceRegistry serviceRegistry;
    protected MetadataSources metadataSources;
    protected Metadata metadata;
    protected TypeConfiguration typeConfiguration;

    public HB6Provider() {
        this(Config.getGlobal().getSubtree("hibernate").asProperties());
    }

    public HB6Provider(Properties config) {
        this(config.getProperty(CONFIG));
    }

    public HB6Provider(String configFileName) {
        if (configFileName == null) {
            throw new HibernateException("Configuration file is not specified.");
        }
        configFileName = ISCFile.canonicalizePath((String)configFileName);
        log.debug((Object)("Instantiating Hibernate config and session factory from file " + configFileName));
        try {
            ISCFile configFile = ISCFile.newInstance((String)configFileName);
            InputStream inputStream = configFile.getInputStream();
            Path tempFilePath = Files.createTempFile("hibernate_config_", ".xml", new FileAttribute[0]);
            try (OutputStream outputStream = Files.newOutputStream(tempFilePath, new OpenOption[0]);){
                inputStream.transferTo(outputStream);
            }
            File tempFile = tempFilePath.toFile();
            tempFile.deleteOnExit();
            this.serviceRegistry = new StandardServiceRegistryBuilder().configure(tempFile).build();
            this.metadataSources = new MetadataSources(this.serviceRegistry);
            this.configuration = new Configuration(this.metadataSources);
            MetadataBuilderImplementor metadataBuilder = (MetadataBuilderImplementor)this.metadataSources.getMetadataBuilder();
            this.typeConfiguration = metadataBuilder.getBootstrapContext().getTypeConfiguration();
            this.buildFactory();
        }
        catch (Exception ex) {
            throw new HibernateException("Failed to initialize HB6 Provider", (Throwable)ex);
        }
    }

    @Override
    public synchronized SessionFactory get() {
        log.info((Object)"Getting factory");
        return this.factory;
    }

    @Override
    public synchronized Session getSession() throws HibernateException {
        log.info((Object)"Getting session");
        return this.factory.openSession();
    }

    @Override
    public void returnSession(Session session) {
        log.info((Object)"Returning session");
        if (session != null) {
            try {
                if (session.isOpen()) {
                    session.close();
                }
            }
            catch (HibernateException ex) {
                log.warn((Object)"Failed to close session.", (Throwable)ex);
            }
        }
    }

    @Override
    public Transaction getTransaction(Session session) throws HibernateException {
        log.info((Object)"Getting transaction");
        if (session != null) {
            Transaction tx = session.getTransaction();
            if (!tx.isActive()) {
                tx.begin();
            }
            return tx;
        }
        throw new HibernateException("Session manager not provided.");
    }

    @Override
    public void commitTransaction(Transaction tx) throws HibernateException {
        log.info((Object)"Committing transaction");
        if (tx != null && tx.isActive()) {
            tx.commit();
        }
    }

    @Override
    public void rollbackTransaction(Transaction tx) {
        log.info((Object)"Rilling back transaction");
        if (tx != null && tx.isActive()) {
            try {
                tx.rollback();
            }
            catch (Exception ex) {
                log.warn((Object)"Unexpected exception while rolling back transaction", (Throwable)ex);
            }
        }
    }

    @Override
    public synchronized Dialect getDialect() {
        log.info((Object)"Getting dialect");
        try {
            StandardServiceRegistry registry = this.factory.getSessionFactoryOptions().getServiceRegistry();
            return ((JdbcServices)registry.getService(JdbcServices.class)).getDialect();
        }
        catch (Exception ex) {
            log.warn((Object)"Failed to acquire Hibernate dialect", (Throwable)ex);
            return null;
        }
    }

    @Override
    public synchronized Metadata getMetadata() {
        log.debug((Object)"Getting metadata");
        return this.metadata;
    }

    @Override
    public synchronized Iterator<PersistentClass> getMappings() {
        log.info((Object)"Getting mappings");
        return this.metadata.getEntityBindings().iterator();
    }

    @Override
    public synchronized PersistentClass getMapping(String entityName) {
        log.info((Object)("Getting mapping: " + entityName));
        return this.metadata.getEntityBinding(entityName);
    }

    @Override
    public synchronized Collection getCollectionMapping(String role) {
        log.info((Object)("Getting collection mapping: " + role));
        return this.metadata.getCollectionBinding(role);
    }

    @Override
    public synchronized void addMapping(String mapping) {
        log.info((Object)("Adding mapping: " + mapping));
        try {
            ByteArrayInputStream xmlMappingStream = new ByteArrayInputStream(mapping.getBytes(StandardCharsets.UTF_8));
            this.metadataSources.addInputStream((InputStream)xmlMappingStream);
        }
        catch (MappingException ex) {
            log.warn((Object)"Failed to add XML mapping to Hibernate configuration.", (Throwable)ex);
        }
        catch (Exception ex) {
            log.warn((Object)"Failed to parse provided XML mapping string.", (Throwable)ex);
        }
        this.buildFactory();
    }

    @Override
    public synchronized void addMapping(Class mapping) {
        log.info((Object)("Adding mapping: " + mapping.getName()));
        try {
            try {
                this.configuration.addClass(mapping);
            }
            catch (MappingNotFoundException mnfe) {
                this.configuration.addAnnotatedClass(mapping);
            }
        }
        catch (MappingException ex) {
            log.warn((Object)("Failed to add \"" + mapping.getName() + "\" mapping to Hibernate configuration."), (Throwable)ex);
        }
        this.buildFactory();
    }

    @Override
    public synchronized SchemaUpdate getSchemaUpdate() {
        log.info((Object)"Getting schema update");
        return new SchemaUpdate();
    }

    @Override
    public synchronized SchemaExport getSchemaExport() {
        log.info((Object)"Getting schema export");
        return new SchemaExport();
    }

    private void buildFactory() {
        if (this.factory != null) {
            MetadataSources newMetaDS = new MetadataSources(this.serviceRegistry);
            for (Binding b : this.metadataSources.getXmlBindings()) {
                if (b.getOrigin() != null && b.getOrigin().getName() != null) continue;
                newMetaDS.addXmlBinding(b);
            }
            for (Class cl : this.metadataSources.getAnnotatedClasses()) {
                newMetaDS.addAnnotatedClass(cl);
            }
            this.metadataSources = newMetaDS;
            this.configuration = new Configuration(this.metadataSources);
        }
        this._buildFactory();
    }

    private void _buildFactory() {
        Dialect dialect;
        this.metadata = this.metadataSources.getMetadataBuilder().applySqlFunction("isc_cast_to_binary", (SqmFunctionDescriptor)new CastToBinaryFunction(this.typeConfiguration)).build();
        this.factory = this.metadata.buildSessionFactory();
        if (this.configuration.getProperties().get("hibernate.dialect") == null && (dialect = this.getDialect()) != null) {
            log.info((Object)("Hibernate dialect autodection did not propagate  to hibernate env properties - pushing it manually (dialect: " + dialect.toString() + ")"));
            this.configuration.getProperties().put("hibernate.dialect", dialect.toString());
        }
    }
}

