/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.messaging;

import com.isomorphic.js.JSTranslater;
import com.isomorphic.js.UnconvertableException;
import com.isomorphic.log.Logger;
import com.isomorphic.messaging.ISCMessage;
import com.isomorphic.messaging.ISCMessageDispatcher;
import com.isomorphic.messaging.ISubscriber;
import com.isomorphic.naming.JNDI;
import com.isomorphic.util.DataTools;
import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.ConnectionMetaData;
import jakarta.jms.Destination;
import jakarta.jms.ExceptionListener;
import jakarta.jms.IllegalStateException;
import jakarta.jms.InvalidDestinationException;
import jakarta.jms.JMSException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageEOFException;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.ObjectMessage;
import jakarta.jms.ResourceAllocationException;
import jakarta.jms.Session;
import jakarta.jms.StreamMessage;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.naming.Context;

public class JMSMessageDispatcher
extends ISCMessageDispatcher
implements ExceptionListener {
    private static Logger log = new Logger(JMSMessageDispatcher.class.getName());
    private Map<String, Destination> dynamicDestinationForChannel = Collections.synchronizedMap(new HashMap());
    private Map<String, MessageConsumer> messageConsumerForChannel = Collections.synchronizedMap(new HashMap());
    static ConnectionFactory connectionFactory;
    Connection connection;
    String clientID;
    String jmsContext;
    String jndiPrefix;
    Context jndiContext;
    Session session;
    boolean useDurableTopics = false;
    String messageEncoding = config.getString((Object)"messaging.jms.encoding", "java");
    JSTranslater jsTrans;

    public JMSMessageDispatcher() throws Exception {
        this.jmsContext = config.getString((Object)"messaging.jms.context", "");
        this.jndiPrefix = config.getString((Object)"messaging.jms.jndiPrefix", null);
        this.jndiContext = JNDI.bindConfiguredContext((String)this.jmsContext);
        this.useDurableTopics = config.getBoolean((Object)"messaging.jms.useDurableTopics");
        if ("json".equals(this.messageEncoding)) {
            JMSMessageDispatcher jMSMessageDispatcher = this;
            this.jsTrans = jMSMessageDispatcher.jsTrans.get().enablePrettyPrinting(false).omitNullMapValues(false);
            this.jsTrans.strictJSONMode();
        }
    }

    public synchronized Destination getDestination(String channel) throws Exception {
        try {
            return (Destination)JNDI.lookup((Context)this.jndiContext, (String)this.jndiPrefix, (String)channel, Destination.class);
        }
        catch (Exception e) {
            Destination destination = this.dynamicDestinationForChannel.get(channel);
            if (destination != null) {
                return destination;
            }
            log.info((Object)("Destination for channel '" + channel + "' not available via JNDI - dynamically creating"));
            destination = this.getSession().createTopic(channel);
            this.dynamicDestinationForChannel.put(channel, destination);
            return destination;
        }
    }

    public boolean getUseDurableTopics() {
        return this.useDurableTopics;
    }

    @Override
    public void setClientID(String clientID) throws Exception {
        this.clientID = clientID;
    }

    public Session getSession() throws Exception {
        if (this.session == null) {
            this.session = this.getConnection().createSession(false, 2);
        }
        return this.session;
    }

    public Connection getConnection() throws Exception {
        try {
            if (this.connection == null) {
                this.connect();
            }
            return this.connection;
        }
        catch (JMSException e) {
            log.forceError((Object)"Failed to connect to JMS server", (Throwable)e);
            throw e;
        }
    }

    public void connect() throws Exception {
        if (this.connection != null || connectionFactory != null) {
            this.closeConnection();
        }
        connectionFactory = null;
        try {
            connectionFactory = (ConnectionFactory)JNDI.lookup((Context)this.jndiContext, (String)this.jndiPrefix, (String)config.getString((Object)"messaging.jms.connectionFactory", "ConnectionFactory"), ConnectionFactory.class);
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        if (connectionFactory == null) {
            try {
                connectionFactory = (ConnectionFactory)JNDI.lookup((Context)this.jndiContext, (String)this.jndiPrefix, (String)config.getString((Object)"messaging.jms.topicConnectionFactory", "TopicConnectionFactory"), ConnectionFactory.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (connectionFactory == null) {
            try {
                connectionFactory = (ConnectionFactory)JNDI.lookup((Context)this.jndiContext, (String)this.jndiPrefix, (String)config.getString((Object)"messaging.jms.queueConnectionFactory", "QueueConnectionFactory"), ConnectionFactory.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (connectionFactory == null) {
            throw new Exception("Unable to find any JMS factories - check your server.properties configuration. You must provide a messaging.jms.connectionFactory entry that points to a jakarta.jms.ConnectionFactory instance exposed vi JNDI");
        }
        this.connection = connectionFactory.createConnection();
        if (this.clientID != null) {
            this.connection.setClientID(this.clientID);
        }
        try {
            ConnectionMetaData cmd = this.connection.getMetaData();
            log.info((Object)("Initializing JMS connection - JMS API version: " + cmd.getJMSVersion() + " - provider: " + cmd.getJMSProviderName() + " version " + cmd.getProviderVersion() + " clientID: " + this.clientID + " message encoding: " + this.messageEncoding));
        }
        catch (Exception e) {
            log.warn((Object)"Unable to obtain JMS connection metadata", (Throwable)e);
        }
        try {
            this.connection.setExceptionListener((ExceptionListener)this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.connection.start();
    }

    public void onException(JMSException e) {
        if (e instanceof IllegalStateException || e instanceof InvalidDestinationException || e instanceof MessageEOFException || e instanceof ResourceAllocationException) {
            log.warn((Object)"caught exception, attempting to reconnect", (Throwable)e);
            try {
                this.connect();
            }
            catch (Exception ee) {
                log.forceError((Object)"Unable to reconnect to server", (Throwable)ee);
            }
        }
    }

    @Override
    public synchronized void stop() {
        log.debug((Object)("JMS Connection (clientID: " + this.clientID + ") stopping"));
        try {
            if (this.session != null) {
                log.debug((Object)"closing session");
                this.session.close();
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.session = null;
            this.messageConsumerForChannel.clear();
        }
        this.closeConnection();
    }

    @Override
    public void closeConnection() {
        log.debug((Object)("JMS Connection (clientID: " + this.clientID + ") closing JMS connection"));
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (JMSException jMSException) {
        }
        finally {
            this.connection = null;
            connectionFactory = null;
            this.dynamicDestinationForChannel.clear();
        }
    }

    public void destroy() {
        this.stop();
    }

    @Override
    public synchronized void deliver(ISCMessage iscMessage) throws Exception {
        for (String channel : iscMessage.getTargetChannels()) {
            Destination destination = this.getDestination(channel);
            Session session = this.getSession();
            Object message = null;
            Object data = iscMessage.getData();
            message = "json".equals(this.messageEncoding) ? session.createTextMessage(this.jsTrans.toJS(data)) : session.createObjectMessage((Serializable)data);
            MessageProducer producer = this.getSession().createProducer(destination);
            producer.send((Message)message);
            producer.close();
        }
    }

    @Override
    public synchronized void subscribe(final ISubscriber subscriber, final String channel, String selector) throws Exception {
        if (this.messageConsumerForChannel.get(channel) == null) {
            Destination destination = this.getDestination(channel);
            Object consumer = null;
            consumer = destination instanceof Topic && this.clientID != null && this.useDurableTopics ? this.getSession().createDurableSubscriber((Topic)destination, selector) : this.getSession().createConsumer(destination, selector);
            consumer.setMessageListener(new MessageListener(){

                public void onMessage(Message jmsMessage) {
                    try {
                        ISCMessage iscMessage = JMSMessageDispatcher.this.convertToISCMessage(jmsMessage, channel);
                        subscriber.send(iscMessage);
                        jmsMessage.acknowledge();
                    }
                    catch (Exception e) {
                        log.error((Object)"Unable to deliver/acknowldge jms message", (Throwable)e);
                    }
                }
            });
            this.messageConsumerForChannel.put(channel, (MessageConsumer)consumer);
        }
    }

    @Override
    public synchronized void unsubscribe(ISubscriber subscriber, String channel) throws Exception {
        MessageConsumer messageConsumer = this.messageConsumerForChannel.remove(channel);
        if (messageConsumer != null) {
            try {
                messageConsumer.setMessageListener(null);
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            try {
                messageConsumer.close();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ISCMessage convertToISCMessage(Message jmsMessage, String channel) throws Exception {
        Object data = null;
        if (jmsMessage instanceof BytesMessage) {
            if (!"json".equals(this.messageEncoding)) throw new Exception("You must set messaging.jms.encoding in your server.properties to specify an encoding for BytesMessages");
            long bodyLength = ((BytesMessage)jmsMessage).getBodyLength();
            if (bodyLength != 0L) {
                byte[] buf = new byte[(int)bodyLength];
                ((BytesMessage)jmsMessage).readBytes(buf);
                data = new String(buf);
                try {
                    data = this.jsTrans.fromJS((String)data);
                }
                catch (UnconvertableException ue) {
                    log.error((Object)("Unable to convert message to JSON: " + String.valueOf(data)), (Throwable)ue);
                }
            } else {
                log.debug((Object)"Null message body received");
            }
        } else if (jmsMessage instanceof MapMessage) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            Enumeration e = ((MapMessage)jmsMessage).getMapNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                map.put(key, ((MapMessage)jmsMessage).getObject(key));
            }
            data = map;
        } else if (jmsMessage instanceof ObjectMessage) {
            data = ((ObjectMessage)jmsMessage).getObject();
        } else {
            if (jmsMessage instanceof StreamMessage) {
                throw new Exception("StreamMessage encoding is not supported at this time");
            }
            if (jmsMessage instanceof TextMessage) {
                data = ((TextMessage)jmsMessage).getText();
                if ("json".equals(this.messageEncoding)) {
                    try {
                        data = this.jsTrans.fromJS((String)data);
                    }
                    catch (UnconvertableException ue) {
                        log.error((Object)("Unable to convert message to JSON: " + String.valueOf(data)), (Throwable)ue);
                    }
                }
            }
        }
        if (!log.isDebugEnabled()) return new ISCMessage(channel, (Object)((Serializable)data), jmsMessage.getJMSMessageID());
        log.debug((Object)("Decoded jmsMessage for channel: " + channel + " data: " + DataTools.prettyPrint((Object)data)));
        return new ISCMessage(channel, (Object)((Serializable)data), jmsMessage.getJMSMessageID());
    }
}

