/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.store;

import com.isomorphic.log.Logger;
import com.isomorphic.store.ExpiringValue;
import java.util.LinkedHashMap;
import java.util.Map;

public class ExpiringCache<K, V> {
    protected long maxLifeInMillis;
    protected long maxEntries;
    protected Logger log = new Logger(ExpiringCache.class);
    protected LinkedHashMap<K, ExpiringValue<V>> cache;

    public ExpiringCache(final long maxLifeInMillis, final long maxEntries) {
        this.maxLifeInMillis = maxLifeInMillis;
        this.maxEntries = maxEntries;
        this.cache = new LinkedHashMap<K, ExpiringValue<V>>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, ExpiringValue<V>> eldest) {
                boolean stale;
                boolean bl = stale = maxLifeInMillis >= 0L && eldest.getValue().isStale(maxLifeInMillis);
                if (maxEntries > 0L && (long)this.size() > maxEntries) {
                    ExpiringCache.this.log.debug("Size of cache " + this.hashCode() + " exceeds max size, entry with key '" + String.valueOf(eldest.getKey()) + "' will be booted.  Is it stale? " + stale);
                    return true;
                }
                return stale;
            }
        };
    }

    public synchronized void put(K key, V value) {
        this.cache.remove(key);
        this.cache.put(key, new ExpiringValue<V>(value));
        this.log.debug("Cache '" + this.hashCode() + "' added object for key '" + String.valueOf(key) + "'.  Value is null? " + (value == null));
    }

    public synchronized ExpiringValue<V> get(K key) {
        ExpiringValue<V> expiringValue = this.cache.get(key);
        if (expiringValue == null) {
            this.log.debug("Cache '" + this.hashCode() + "' get() called for key '" + String.valueOf(key) + "'.  The ExpiringValue was null");
            return null;
        }
        if (this.maxLifeInMillis >= 0L && expiringValue.isStale(this.maxLifeInMillis)) {
            this.cache.remove(key);
            this.log.debug("Cache '" + this.hashCode() + "' found ExpiringCache entry for '" + String.valueOf(key) + "' - it was '" + String.valueOf(expiringValue) + "' - but it has expired - discarding it");
            return null;
        }
        this.log.debug("Cache '" + this.hashCode() + "' - returning unexpired ExpiringCache entry for '" + String.valueOf(key) + "' - it was '" + String.valueOf(expiringValue) + "'");
        return expiringValue;
    }

    public synchronized void clear() {
        this.cache.clear();
    }
}

