/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.servlet;

import com.isomorphic.servlet.BaseFilter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

public class ParamMapperFilter
extends BaseFilter {
    public static final String CONFIG_PARAM_PREFIX = "param_";
    private Map parameterMap = new HashMap();

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        Enumeration e = filterConfig.getInitParameterNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith(CONFIG_PARAM_PREFIX)) continue;
            String paramName = key.substring(CONFIG_PARAM_PREFIX.length());
            this.parameterMap.put(paramName, filterConfig.getInitParameter(key));
        }
    }

    @Override
    public void _doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException, IOException {
        for (String mappedParam : this.parameterMap.keySet()) {
            String paramValue = request.getParameter(mappedParam);
            if (paramValue == null) continue;
            String attributeName = (String)this.parameterMap.get(mappedParam);
            request.setAttribute(attributeName, (Object)paramValue);
        }
        chain.doFilter(request, response);
    }
}

