/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.log;

import com.isomorphic.log.Log4j2Logger;
import java.io.Serializable;
import org.apache.commons.collections4.queue.CircularFifoQueue;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;

@Plugin(name="TransientAppender", category="Core", elementType="appender", printObject=true)
public final class TransientAppenderImpl
extends AbstractAppender {
    protected int transientBufferSize = 50;
    protected Level passthroughThreshold = Level.INFO;
    protected Level transientBufferDumpThreshold = Level.FATAL;
    protected CircularFifoQueue transientBuffer;
    private AppenderRef[] appenderRefs;
    private Appender[] actualAppenders;

    @PluginFactory
    public static TransientAppenderImpl createAppender(@PluginAttribute(value="name") String name, @PluginAttribute(value="ignoreExceptions") boolean ignoreExceptions, @PluginAttribute(value="transientBufferSize", defaultInt=50) int transientBufferSize, @PluginAttribute(value="passthroughThreshold", defaultString="INFO") String passthroughThreshold, @PluginAttribute(value="transientBufferDumpThreshold", defaultString="FATAL") String transientBufferDumpThreshold, @PluginElement(value="Layout") Layout layout, @PluginElement(value="Filters") Filter filter, @PluginElement(value="AppenderRef") AppenderRef[] appenderRefs) {
        if (name == null) {
            System.out.println("No name provided for Log4j2 appender: TransientAppender");
            return null;
        }
        if (appenderRefs == null || appenderRefs.length < 1) {
            System.out.println("No AppenderRef provided for Log4j2 appender: TransientAppender");
        }
        if (layout == null) {
            layout = PatternLayout.createDefaultLayout();
        }
        return new TransientAppenderImpl(name, ignoreExceptions, transientBufferSize, passthroughThreshold, transientBufferDumpThreshold, (Layout<? extends Serializable>)layout, filter, appenderRefs);
    }

    private TransientAppenderImpl(String name, boolean ignoreExceptions, int transientBufferSize, String passthroughThreshold, String transientBufferDumpThreshold, Layout<? extends Serializable> layout, Filter filter, AppenderRef[] appenderRefs) {
        super(name, filter, layout, ignoreExceptions, null);
        this.setTransientBufferSize(transientBufferSize);
        this.setPassthroughThreshold(passthroughThreshold);
        this.setTransientBufferDumpThreshold(transientBufferDumpThreshold);
        this.setAppenderRefs(appenderRefs);
    }

    public void appendActual(LogEvent event) {
        if (this.actualAppenders == null && this.appenderRefs != null) {
            this.actualAppenders = new Appender[this.appenderRefs.length];
            int l = this.appenderRefs.length;
            for (int i = 0; i < l; ++i) {
                this.actualAppenders[i] = Log4j2Logger.getLoggerContext().getConfiguration().getAppender(this.appenderRefs[i].getRef());
            }
        }
        if (this.actualAppenders != null) {
            for (Appender appender : this.actualAppenders) {
                if (appender == null) continue;
                appender.append(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransientBufferSize(int size) {
        Class<TransientAppenderImpl> clazz = TransientAppenderImpl.class;
        synchronized (TransientAppenderImpl.class) {
            if (this.transientBuffer != null) {
                while (this.transientBuffer.size() > size) {
                    this.transientBuffer.remove();
                }
                CircularFifoQueue newBuffer = new CircularFifoQueue(size);
                while (this.transientBuffer.size() > 0) {
                    newBuffer.add(this.transientBuffer.remove());
                }
                this.transientBuffer = newBuffer;
            } else {
                this.transientBuffer = new CircularFifoQueue(size);
            }
            this.transientBufferSize = size;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void setPassthroughThreshold(String level) {
        this.passthroughThreshold = Level.toLevel((String)level);
    }

    public void setTransientBufferDumpThreshold(String level) {
        this.transientBufferDumpThreshold = Level.toLevel((String)level);
    }

    public void setAppenderRefs(AppenderRef[] appenderRefs) {
        this.appenderRefs = appenderRefs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpBuffer() {
        Class<TransientAppenderImpl> clazz = TransientAppenderImpl.class;
        synchronized (TransientAppenderImpl.class) {
            if (this.transientBuffer.size() > 0) {
                this.appendActual((LogEvent)Log4jLogEvent.newBuilder().setLoggerName(((Object)((Object)this)).getClass().getName()).setLevel(this.transientBufferDumpThreshold).setMessage((Message)new SimpleMessage("------TRANSIENT BUFFER DUMP FOLLOWS------")).build());
                while (this.transientBuffer.size() > 0) {
                    this.appendActual((LogEvent)this.transientBuffer.remove());
                }
                this.appendActual((LogEvent)Log4jLogEvent.newBuilder().setLoggerName(((Object)((Object)this)).getClass().getName()).setLevel(this.transientBufferDumpThreshold).setMessage((Message)new SimpleMessage("------END TRANSIENT BUFFER DUMP------")).build());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void append(LogEvent event) {
        Level eventLevel = event.getLevel();
        if (eventLevel.isMoreSpecificThan(this.transientBufferDumpThreshold)) {
            this.dumpBuffer();
        } else {
            Class<TransientAppenderImpl> clazz = TransientAppenderImpl.class;
            // MONITORENTER : com.isomorphic.log.TransientAppenderImpl.class
            this.transientBuffer.add((Object)event);
            // MONITOREXIT : clazz
        }
        if (!eventLevel.isMoreSpecificThan(this.passthroughThreshold)) return;
        this.appendActual(event);
    }
}

