/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.base.Reflection;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.datasource.BMPRReaderDataSource;
import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.io.ISCFile;
import com.isomorphic.log.Logger;
import com.isomorphic.rpc.BuiltinRPC;
import com.isomorphic.rpc.RPCDMI;
import com.isomorphic.util.BMPRContents;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.IOUtil;
import java.io.InputStream;
import java.util.Date;

public class SCUploadSaveFileDataSource
extends BasicDataSource {
    private static final long serialVersionUID = -4704649403493285140L;
    private static Logger log = new Logger(SCUploadSaveFileDataSource.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DSResponse executeAdd(DSRequest req) throws Exception {
        DataTypeMap data;
        DSResponse dsResponse;
        block13: {
            RPCDMI.verifyMethodEnabled("saveFile", req);
            Object fileContents = req.getCriteria().get("file");
            String fileName = (String)req.getCriteria().get("file_filename");
            String fileDir = (String)req.getCriteria().get("file_dir");
            String filePath = fileDir + "/" + fileName;
            boolean bmpr = fileDir.startsWith("[BMPR]");
            String bmprFullPath = null;
            String fileContentsAsString = null;
            InputStream fileInputStream = null;
            if (fileContents instanceof String) {
                fileContentsAsString = (String)fileContents;
            } else {
                fileInputStream = (InputStream)req.getCriteria().get("file");
                if (!bmpr) {
                    fileContentsAsString = IOUtil.inputStreamToString(fileInputStream);
                }
            }
            String serverFilePath = null;
            serverFilePath = bmpr ? IOUtil.threadSafeTmpFileName("/tmp/bmpr") : BuiltinRPC.validateFilePath(filePath, "saveFile");
            dsResponse = new DSResponse(this);
            long lastModified = new Date().getTime();
            data = null;
            try {
                if (!filePath.startsWith("[READ_ONLY]")) {
                    if (bmpr) {
                        BuiltinRPC.saveFileStream(serverFilePath, fileInputStream);
                    } else {
                        BuiltinRPC.saveFile(serverFilePath, fileContentsAsString);
                    }
                    ISCFile f = ISCFile.newInstance(serverFilePath);
                    lastModified = f.lastModified();
                }
                data = DataTools.buildMap("file_filename", fileName, "file", fileContentsAsString, "path", filePath, "file_date_created", lastModified);
                if (bmpr) {
                    bmprFullPath = BuiltinRPC.validateFilePath(serverFilePath, "BMPRUpload");
                    BMPRContents contents = null;
                    try {
                        contents = (BMPRContents)Reflection.invokeStaticMethod("com.isomorphic.tools.ReifyTools", "createBMPRContents", bmprFullPath);
                    }
                    catch (ClassNotFoundException ex) {
                        throw new Exception("Cannot import Balsamiq mockup. Server support files are missing.");
                    }
                    if (contents != null) {
                        String id = BMPRReaderDataSource.cacheBMPRContents(contents);
                        data.put("id", id);
                    }
                }
                if (bmprFullPath == null) break block13;
            }
            catch (Throwable throwable) {
                if (bmprFullPath != null) {
                    BuiltinRPC.deleteFile(bmprFullPath);
                }
                throw throwable;
            }
            BuiltinRPC.deleteFile(bmprFullPath);
        }
        dsResponse.setData((Object)data);
        dsResponse.setStatus(0);
        return dsResponse;
    }

    @Override
    public DSResponse executeCustom(DSRequest req) throws Exception {
        if ("checkUploadFeature".equals(req.getOperationId())) {
            DSResponse dsResponse = new DSResponse(this);
            boolean allowed = false;
            try {
                RPCDMI.verifyMethodEnabled("saveFile", req);
                BuiltinRPC.validateFileDir("[READ_ONLY]", "saveFile");
                allowed = true;
            }
            catch (Exception e) {
                log.warn("Caught exception running operation checkUploadFeature: " + e.getMessage());
            }
            dsResponse.setStatus(allowed ? 0 : -1);
            return dsResponse;
        }
        return super.executeCustom(req);
    }

    @Override
    public DSResponse executeFetch(DSRequest req) throws Exception {
        RPCDMI.verifyMethodEnabled("loadFile", req);
        String filePath = (String)req.getCriteria().get("path");
        String serverFilePath = BuiltinRPC.validateFilePath(filePath, "loadFile");
        DSResponse dsResponse = new DSResponse(this);
        ISCFile f = ISCFile.newInstance(serverFilePath);
        if (!f.exists()) {
            dsResponse.setStatus(-1);
            return dsResponse;
        }
        String fileName = filePath;
        if (fileName.indexOf("/") != -1) {
            fileName = fileName.substring(fileName.lastIndexOf("/"), fileName.length());
        }
        String fileContentsAsString = f.getAsString();
        DataTypeMap data = DataTools.buildMap("file_filename", fileName, "file", fileContentsAsString, "path", filePath, "file_date_created", f.lastModified());
        dsResponse.setData((Object)data);
        dsResponse.setStatus(0);
        return dsResponse;
    }
}

