/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.examples;

import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import java.util.List;
import java.util.Map;

public class EmployeesOpenNodesDMI {
    private final Logger log = new Logger(EmployeesOpenNodesDMI.class.getName());
    private static final String ID_PROPERTY = "EmployeeId";
    private static final String PARENT_ID_PROPERTY = "ReportsTo";
    private static final String CHILDREN_PROPERTY = "DirectReports";
    private static final String OPEN_PROPERTY = "IsOpen";

    public DSResponse execute(DSRequest dsRequest) throws Exception {
        DSResponse dsResponse = dsRequest.execute();
        if (dsResponse.statusIsSuccess() && "fetch".equals(dsResponse.getOperationType())) {
            this.addChildrenToRecords(dsRequest, dsResponse.getDataList());
        }
        return dsResponse;
    }

    private void addChildrenToRecords(DSRequest dsRequest, List records) throws Exception {
        if (records != null) {
            DataSource dataSource = dsRequest.getDataSource();
            for (Object record : records) {
                if (!Boolean.TRUE.equals(dataSource.getProperties(record).get(OPEN_PROPERTY))) continue;
                this.addChildrenToRecord(dsRequest, record);
            }
        }
    }

    private void addChildrenToRecord(DSRequest dsRequest, Object record) throws Exception {
        DataSource dataSource = dsRequest.getDataSource();
        Object recordId = dataSource.getProperties(record).get(ID_PROPERTY);
        DataTypeMap criteria = DataTools.buildMap((Object[])new Object[]{PARENT_ID_PROPERTY, recordId});
        dsRequest.setCriteria((Object)criteria);
        DSResponse dsResponse = dsRequest.execute();
        List children = dsResponse.getDataList();
        this.setProperties(dataSource, (Map)DataTools.buildMap((Object[])new Object[]{CHILDREN_PROPERTY, children}), record);
        this.addChildrenToRecords(dsRequest, children);
    }

    private void setProperties(DataSource dataSource, Map properties, Object target) {
        if (target instanceof Map) {
            DataTools.mapMerge((Map)properties, (Map)((Map)target));
        } else {
            dataSource.setProperties(properties, target);
        }
    }
}

