/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.sql.DBDataSource;
import java.util.HashMap;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

public class DBDataSourceFactory
implements ObjectFactory {
    private static final String[] ALL_PROPERTIES = new String[]{"dbName"};

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
        if (obj == null || !(obj instanceof Reference)) {
            return null;
        }
        Reference ref = (Reference)obj;
        if (!"javax.sql.DataSource".equals(ref.getClassName())) {
            return null;
        }
        HashMap<String, String> props = new HashMap<String, String>();
        for (int i = 0; i < ALL_PROPERTIES.length; ++i) {
            String propertyName = ALL_PROPERTIES[i];
            RefAddr ra = ref.get(propertyName);
            if (ra == null) continue;
            String propertyValue = ra.getContent().toString();
            props.put(propertyName, propertyValue);
        }
        return new DBDataSource(props);
    }
}

