/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.servlet;

import com.isomorphic.util.DataTools;
import com.isomorphic.util.RegexRule;
import java.util.List;

public class URIRegexRule
extends RegexRule {
    private MatchType matchType;
    private List<String> metaData;

    public URIRegexRule(String rule, String location) throws Exception {
        super(rule);
        if (!this.action.contains(";")) {
            return;
        }
        this.metaData = DataTools.simpleSplit(this.action, ";");
        int length = this.metaData.size();
        this.action = this.metaData.get(0);
        if (this.metaData.size() > 2) {
            String matchType;
            switch (matchType = this.metaData.get(this.metaData.size() - 1)) {
                case "": {
                    break;
                }
                case "i": {
                    this.matchType = MatchType.INITIAL;
                    break;
                }
                case "c": {
                    this.matchType = MatchType.CURRENT;
                    break;
                }
                default: {
                    throw new Exception("Malformed rule: " + this.toString() + " - match type '" + matchType + "' is not supported - valid match types are 'i', 'c', or ''.");
                }
            }
            --length;
        }
        this.metaData = this.metaData.subList(1, length);
    }

    public boolean hasMetaData() {
        return this.metaData != null;
    }

    public List<String> getMetaData() {
        return this.metaData;
    }

    public boolean hasMatchType() {
        return this.matchType != null;
    }

    public MatchType getMatchType() {
        return this.matchType;
    }

    public static enum MatchType {
        INITIAL,
        CURRENT;

    }
}

