var grid = isc.ListGrid.create({
    width: "100%", height: "100%",
    dataSource: "worldDS", dataFetchMode: "local", autoFetchData: true,
    fields: [
        {name:"countryCode", title:"Flag", width:70, type: "image", imageURLPrefix: "flags/24/", imageURLSuffix: ".png"},
        {name:"countryName", width:235},
        {name:"continent", width:125},
        {name:"government", width:235},
        {
            name: "pressFreedom",
            title: "Press Freedom",
            width: 175,
                        aiFieldPrompt: "category of press freedom in the named country",
            canEditAISummary: false,
            showHover: true
        }
    ],
    implicitCriteria: { // exclude territories
        _constructor: "AdvancedCriteria",
        fieldName: "independence",
        operator: "notNull"
    },
    initialCriteria: {
        continent: "Europe"
    },
    //showFilterEditor: true,
    initialSort: [{
        property: "pressFreedom",
        direction: "ascending"
    }, {
        property: "countryName",
        direction: "ascending"
    }],
    sortViaAIMode: "hybrid",
    aiSortFieldMaxRecords: 50,
    canAddAISummaryFields: true
});

