var grid = isc.ListGrid.create({
    width: "100%", height: "100%",
    dataSource: "worldDS", dataFetchMode: "local", autoFetchData: true,
    sortField: "countryName",
    implicitCriteria: {
        _constructor: "AdvancedCriteria",
        fieldName: "continent",
        operator: "inSet",
        value: ["North America", "Australia/Oceania"]
    },

    filterViaAIMode: "AIDE"
});

var exampleFilterDescriptions = [
    "in the Northern Hemisphere",
    "Spanish is one of the official languages",
    "in the Caribbean"
];

isc.VLayout.create({
    width: "100%",
    height: "100%",
    members: [
        isc.HLayout.create({
            width: "100%",
            height: "*",
            members: [isc.Label.create({height: "30", contents: "Examples: ", autoFit: true})].concat(exampleFilterDescriptions.map(function (exampleFilterDescription) {
                return isc.IButton.create({
                    title: "\"" + exampleFilterDescription + "\"",
                    autoFit: true,
                    click : function () {
                        grid.filterViaAI(exampleFilterDescription);
                    }
                });
            })),
            membersMargin: 6
        }),
        grid
    ],
    membersMargin: 12
});

