/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.util;

import com.isomorphic.log.Logger;
import com.isomorphic.util.AutoConfigurableExecutable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Rsync
extends AutoConfigurableExecutable {
    private static Logger log = new Logger(Rsync.class.getName());
    protected String pathToRsync;
    protected List options = new ArrayList();
    protected String optionString = null;
    protected String source;
    protected String target;
    protected String passwordFile = null;
    protected String command = null;

    public Rsync() {
    }

    public Rsync(Map rsyncConfig) {
        this.pathToRsync = (String)rsyncConfig.get("pathToRsync");
        if (this.pathToRsync == null) {
            log.warning("Unable to determine location of the rsync binary - rsync services will not be available.");
        }
        this.passwordFile = (String)rsyncConfig.get("passwordFile");
        if (this.passwordFile == null) {
            log.warning("passwordFile is not set in the config - this may not be what you want.");
        }
    }

    @Override
    public String getCommand() {
        if (this.command != null) {
            return this.command;
        }
        String result = this.pathToRsync + " " + this.getOptionString();
        if (this.passwordFile != null) {
            result = result + " --password-file=" + this.passwordFile;
        }
        return result + " " + this.source + " " + this.target;
    }

    public String getOptionString() {
        if (this.optionString != null) {
            return this.optionString;
        }
        if (this.options.size() == 0) {
            return "";
        }
        String result = "";
        for (String option : this.options) {
            result = result + " " + option;
        }
        return result;
    }

    public void setOptionString(String optionString) {
        this.optionString = optionString;
    }

    public void resetOptions() {
        this.options = new ArrayList();
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setOption(String option) {
        if (!this.options.contains(option)) {
            this.options.add(option);
        }
    }

    public void unsetOption(String option) {
        this.options.remove(option);
    }

    public void usePasswordFile(String passwordFile) {
        this.passwordFile = passwordFile;
    }
}

