/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache;

import java.util.HashMap;
import java.util.Map;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.Timestamper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EhCache
implements Cache {
    private static final Logger log = LoggerFactory.getLogger(EhCache.class);
    private static final int SIXTY_THOUSAND_MS = 60000;
    private Ehcache cache;

    public EhCache(Ehcache cache) {
        this.cache = cache;
    }

    public Object get(Object key) throws CacheException {
        try {
            if (log.isDebugEnabled()) {
                log.debug("key: " + key);
            }
            if (key == null) {
                return null;
            }
            Element element = this.cache.get(key);
            if (element == null) {
                if (log.isDebugEnabled()) {
                    log.debug("Element for " + key + " is null");
                }
                return null;
            }
            return element.getObjectValue();
        }
        catch (net.sf.ehcache.CacheException e) {
            throw new CacheException(e);
        }
    }

    public Object read(Object key) throws CacheException {
        return this.get(key);
    }

    public void update(Object key, Object value) throws CacheException {
        this.put(key, value);
    }

    public void put(Object key, Object value) throws CacheException {
        try {
            Element element = new Element(key, value);
            this.cache.put(element);
        }
        catch (IllegalArgumentException e) {
            throw new CacheException(e);
        }
        catch (IllegalStateException e) {
            throw new CacheException(e);
        }
        catch (net.sf.ehcache.CacheException e) {
            throw new CacheException(e);
        }
    }

    public void remove(Object key) throws CacheException {
        try {
            this.cache.remove(key);
        }
        catch (ClassCastException e) {
            throw new CacheException(e);
        }
        catch (IllegalStateException e) {
            throw new CacheException(e);
        }
        catch (net.sf.ehcache.CacheException e) {
            throw new CacheException(e);
        }
    }

    public void clear() throws CacheException {
        try {
            this.cache.removeAll();
        }
        catch (IllegalStateException e) {
            throw new CacheException(e);
        }
        catch (net.sf.ehcache.CacheException e) {
            throw new CacheException(e);
        }
    }

    public void destroy() throws CacheException {
        try {
            this.cache.getCacheManager().removeCache(this.cache.getName());
        }
        catch (IllegalStateException e) {
            throw new CacheException(e);
        }
        catch (net.sf.ehcache.CacheException e) {
            throw new CacheException(e);
        }
    }

    public void lock(Object key) throws CacheException {
    }

    public void unlock(Object key) throws CacheException {
    }

    public long nextTimestamp() {
        return Timestamper.next();
    }

    public int getTimeout() {
        return 245760000;
    }

    public String getRegionName() {
        return this.cache.getName();
    }

    public long getSizeInMemory() {
        try {
            return this.cache.calculateInMemorySize();
        }
        catch (Throwable t) {
            return -1L;
        }
    }

    public long getElementCountInMemory() {
        try {
            return this.cache.getMemoryStoreSize();
        }
        catch (net.sf.ehcache.CacheException ce) {
            throw new CacheException(ce);
        }
    }

    public long getElementCountOnDisk() {
        return this.cache.getDiskStoreSize();
    }

    public Map toMap() {
        try {
            HashMap result = new HashMap();
            for (Object key : this.cache.getKeys()) {
                result.put(key, this.cache.get(key).getObjectValue());
            }
            return result;
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
    }

    public String toString() {
        return "EHCache(" + this.getRegionName() + ')';
    }
}

