/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.examples.server.transactions;

import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Timestamp;

public class JDBCOperations {
    public DSResponse goodJDBCUpdate(DSRequest req) throws Exception {
        return this.update(req, "UPDATE lastUpdated SET lastUpdatedTime = ? WHERE pk = ?");
    }

    public DSResponse badJDBCUpdate(DSRequest req) throws Exception {
        return this.update(req, "UPDATE lastUpdated SET lastUpatedTime = ? WHERE pk = ?");
    }

    public DSResponse update(DSRequest req, String sql) throws Exception {
        DSResponse resp = new DSResponse();
        req.setPartOfTransaction(true);
        Connection conn = (Connection)((BasicDataSource)req.getDataSource()).getTransactionObject(req);
        if (conn == null) {
            resp.setStatus(-1);
            resp.setData((Object)"No transaction to join.  Please make some changes before clicking the Save buttons");
            return resp;
        }
        PreparedStatement stmt = conn.prepareStatement(sql);
        stmt.setTimestamp(1, new Timestamp(System.currentTimeMillis()));
        Object pk = req.getValues().get("pk");
        stmt.setInt(2, Integer.parseInt(pk.toString()));
        stmt.executeUpdate();
        stmt.close();
        resp.setStatus(0);
        return resp;
    }
}

