/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.xml;

import com.isomorphic.base.Config;
import com.isomorphic.base.Reflection;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.criteria.AdvancedCriteria;
import com.isomorphic.criteria.DefaultOperators;
import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSFileSpec;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.datasource.ValidationContext;
import com.isomorphic.io.ISCFile;
import com.isomorphic.io.SequenceReader;
import com.isomorphic.js.IToJSON;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.js.UnconvertableException;
import com.isomorphic.log.Logger;
import com.isomorphic.store.DataStructCache;
import com.isomorphic.util.DataTools;
import com.isomorphic.xml.XML;
import com.isomorphic.xml.XMLParsingException;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class Screen
implements IToJSON {
    private static Config config = Config.getGlobal();
    private static Logger log = new Logger(Screen.class.getName());
    private static String storageDS = config.getString("project.vbScreensDS");
    private static String fileType = "ui";
    private static String fileFormat = "xml";
    DataTypeMap data;
    String xml;
    DataTypeMap metadata;

    public Screen(String xml, Map metadata) throws Exception {
        this(Screen.dataFromXML(xml, null), metadata);
        this.xml = xml;
    }

    public Screen(String xml, Map metadata, boolean mockMode) throws Exception {
        this(Screen.dataFromXML(xml, null), metadata, mockMode);
        this.xml = xml;
    }

    public Screen(String xml, Map metadata, boolean mockMode, ValidationContext vc) throws Exception {
        this(Screen.dataFromXML(xml, vc), metadata, mockMode);
        this.xml = xml;
    }

    public Screen(Map data, Map metadata) {
        this(data, metadata, false);
    }

    public Screen(Map data, Map metadata, boolean mockMode) {
        this.data = new DataTypeMap(data);
        if (mockMode) {
            this.applyMockMode();
        }
        this.metadata = metadata == null ? new DataTypeMap() : new DataTypeMap(metadata);
        this.addWorkflowReferencedDataSources();
    }

    private void applyMockMode() {
        List<Map> components = this.getComponents();
        ArrayList<Map> newComponents = new ArrayList<Map>();
        for (Map component : components) {
            String constructor = (String)component.get("__autoConstruct");
            if (constructor != null) {
                HashMap<String, Boolean> componentCopy = new HashMap<String, Boolean>(component);
                componentCopy.put("mockMode", true);
                newComponents.add(componentCopy);
                continue;
            }
            newComponents.add(component);
        }
        this.setComponents(newComponents);
    }

    private void addWorkflowReferencedDataSources() {
        ArrayList<String> referencedComponents = new ArrayList<String>();
        ArrayList<String> impliedDataSources = new ArrayList<String>();
        List<Map> components = this.getComponents();
        if (components == null) {
            return;
        }
        for (Map map : components) {
            ArrayList<Map> subComponents = null;
            if (map instanceof List) {
                subComponents = (ArrayList<Map>)((Object)map);
            } else {
                subComponents = new ArrayList<Map>();
                subComponents.add(map);
            }
            for (Object e : subComponents) {
                Map component = (Map)e;
                String ID = (String)component.get("ID");
                if (ID != null) {
                    referencedComponents.add(ID);
                }
                List<String> dataSources = this.getWorkflowDataSources(component);
                impliedDataSources.addAll(dataSources);
            }
        }
        if (impliedDataSources.size() > 0) {
            String string;
            Map component;
            ArrayList<String> dsList = new ArrayList<String>();
            for (String ds : impliedDataSources) {
                if (referencedComponents.contains(ds)) continue;
                dsList.add(ds);
            }
            if (dsList.size() > 0 && (component = this.createLoadDSComponent(string = StringUtils.join(dsList, (String)","))) != null) {
                components.add(component);
            }
        }
    }

    private Map createLoadDSComponent(String dataSource) {
        Map component = null;
        String xml = "<DataSource loadParents=\"true\"><loadID>" + dataSource + "</loadID></DataSource>";
        try {
            component = (Map)XML.toDSRecords(new StringReader(xml));
        }
        catch (Exception ex) {
            log.warn(ex);
        }
        return component;
    }

    private List<String> getWorkflowDataSources(Map component) {
        ArrayList<Map> processes = new ArrayList<Map>();
        this.getProcesses(component, processes);
        ArrayList<String> dataSources = new ArrayList<String>();
        for (Map process : processes) {
            this.getProcessDataSources(process, dataSources);
        }
        return dataSources;
    }

    private void getProcesses(Map component, List<Map> processes) {
        if (component.containsKey("_constructor") && "Process".equals(component.get("_constructor"))) {
            processes.add(component);
            return;
        }
        for (Object key : component.keySet()) {
            Object value = component.get(key);
            if (value instanceof Map) {
                this.getProcesses((Map)value, processes);
                continue;
            }
            if (!(value instanceof ArrayList)) continue;
            ArrayList a = (ArrayList)value;
            for (Object ao : a) {
                if (!(ao instanceof Map)) continue;
                this.getProcesses((Map)ao, processes);
            }
        }
    }

    private void getProcessDataSources(Map component, List<String> dataSources) {
        for (Object key : component.keySet()) {
            Object value = component.get(key);
            if (value instanceof Map) {
                this.getProcessDataSources((Map)value, dataSources);
                continue;
            }
            if (value instanceof ArrayList) {
                ArrayList a = (ArrayList)value;
                for (Object ao : a) {
                    if (!(ao instanceof Map)) continue;
                    this.getProcessDataSources((Map)ao, dataSources);
                }
                continue;
            }
            if (!"dataSource".equals(key)) continue;
            dataSources.add((String)value);
        }
    }

    private static Map dataFromXML(String xml, ValidationContext vc) throws Exception {
        boolean createVC;
        log.debug("dataFromXML data: " + xml);
        boolean bl = createVC = vc == null;
        if (createVC) {
            vc = new ValidationContext();
        }
        try {
            Object obj = XML.toDSRecords(new StringReader(xml), vc);
            if (obj instanceof Map) {
                Map map = (Map)XML.toDSRecords(new StringReader(xml), vc);
                return map;
            }
            DataTypeMap dataTypeMap = DataTools.buildMap("data", obj);
            return dataTypeMap;
        }
        catch (XMLParsingException e) {
            log.warn("dataFromXML(): invalid XML - trying again with top-level element added");
            Map map = (Map)XML.toDSRecords(new SequenceReader("<Object><components xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"xsd:List\">", xml, "</components></Object>"), vc);
            return map;
        }
        catch (ClassCastException cce) {
            Object o = XML.toDSRecords(new StringReader(xml), vc);
            log.error("ClassCastException (Expected Map, got: " + o.getClass().getName() + ") while converting XML:\n" + xml + "\nRecords as converted:\n" + JSTranslater.instance().enablePrettyPrinting().toJS(o));
            throw cce;
        }
        finally {
            if (createVC) {
                vc.freeResources();
            }
        }
    }

    public static Screen load(String name) throws Exception {
        log.warn("Looking for screen: " + name);
        return Screen.load(name, false);
    }

    public static Screen load(String name, boolean mockMode) throws Exception {
        return Screen.load((Object)DataTools.buildMap("fileName", name), mockMode);
    }

    public static Screen load(String name, boolean mockMode, ValidationContext vc) throws Exception {
        return Screen.load((Object)DataTools.buildMap("fileName", name), mockMode, vc);
    }

    public static Screen load(String name, String ownerId) throws Exception {
        log.warn("Looking for screen: " + name + ", with owner: " + ownerId);
        return Screen.load(name, ownerId, false);
    }

    public static Screen load(String name, String ownerId, boolean mockMode) throws Exception {
        return Screen.load(name, ownerId, mockMode, null);
    }

    public static Screen load(Object criteria, boolean mockMode) throws Exception {
        return Screen.load(criteria, mockMode, null);
    }

    public static Screen load(String name, String ownerId, boolean mockMode, ValidationContext vc) throws Exception {
        return Screen.load((Object)DataTools.buildMap("fileName", name, "ownerId", ownerId), mockMode, vc);
    }

    private static Screen load(Object criteria, boolean mockMode, ValidationContext vc) throws Exception {
        List<Screen> resultsMatchingCriteria = Screen.list(criteria, mockMode, vc);
        if (resultsMatchingCriteria.size() == 0) {
            return null;
        }
        if (resultsMatchingCriteria.size() > 1) {
            log.warn("Multiple Screens (" + resultsMatchingCriteria.size() + ") matched criteria for load() - using the latest one.  Criteria: " + DataTools.prettyPrint(criteria));
        }
        return resultsMatchingCriteria.get(0);
    }

    public static List<Screen> list(Object criteria, boolean mockMode) throws Exception {
        return Screen.list(criteria, mockMode, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Screen> list(Object criteria, boolean mockMode, ValidationContext vc) throws Exception {
        if (criteria == null) {
            criteria = new HashMap();
        }
        if (criteria instanceof Map) {
            Map m = criteria;
            if (m.get("fileType") == null) {
                m.put("fileType", fileType);
            }
            if (m.get("fileFormat") == null) {
                m.put("fileFormat", fileFormat);
            }
        } else {
            AdvancedCriteria c = (AdvancedCriteria)((Object)criteria);
            if (c.getFieldValue("fileType") == null) {
                c.addCriteria("fileType", DefaultOperators.Equals, fileType);
            }
            if (c.getFieldValue("fileFormat") == null) {
                c.addCriteria("fileFormat", DefaultOperators.Equals, fileFormat);
            }
        }
        ArrayList<Screen> results = new ArrayList<Screen>();
        DataSource ds = null;
        try {
            ds = DataSourceManager.get(storageDS);
            List<Map<String, Object>> files = ds.listFiles(criteria, (Map)((Object)DataTools.buildMap("sortBy", "-fileLastModified")));
            if (files == null) {
                ArrayList<Screen> arrayList = results;
                return arrayList;
            }
            for (Map<String, Object> metadata : files) {
                String xml = ds.getFileAsString(new DSFileSpec(metadata));
                results.add(new Screen(xml, metadata, mockMode, vc));
            }
        }
        finally {
            DataSourceManager.free(ds);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Screen persist() throws Exception {
        StringWriter sw = new StringWriter();
        List<Map> components = this.getComponents();
        for (Map component : components) {
            String tagName = (String)component.get("__autoConstruct");
            if (tagName == null) {
                tagName = "Object";
            }
            DataSource transformDS = null;
            try {
                transformDS = DataSourceManager.get(tagName);
            }
            finally {
                DataSourceManager.free(transformDS);
            }
            XML.recordToXML(tagName, component, sw, false, false, transformDS, null);
        }
        DataSource ds = null;
        try {
            ds = DataSourceManager.get(storageDS);
            Map<String, Object> metadataAsSaved = ds.saveFile(new DSFileSpec((Map)((Object)this.metadata)), sw.toString());
            Screen screen = Screen.load(metadataAsSaved, false);
            return screen;
        }
        finally {
            DataSourceManager.free(ds);
        }
    }

    public void _persistXML() throws Exception {
        ValidationContext vc = new ValidationContext();
        this._persistXML(vc);
        vc.freeResources();
    }

    public void _persistXML(ValidationContext vc) throws Exception {
        BasicDataSource ds = vc.getType(storageDS);
        ds.saveFile(new DSFileSpec((Map)((Object)this.metadata)), this.xml);
    }

    public long _persistMetadata() throws Exception {
        Date fileLastModified = (Date)this.metadata.get("fileLastModified");
        return (Long)Reflection.invokeStaticMethod("com.isomorphic.site.SandboxFilter", "setHostedRecordMetadata", storageDS, this.getName(), fileType, this.getOwner(), fileLastModified);
    }

    public void remove() throws Exception {
        if (this.getName() == null) {
            throw new Exception("Cannot remove a Screen that has not yet been persisted");
        }
        DataSource ds = null;
        try {
            ds = DataSourceManager.get(storageDS);
            ds.removeFile(new DSFileSpec((Map)((Object)this.metadata)));
        }
        finally {
            DataSourceManager.free(ds);
        }
    }

    @Override
    public void toJSON(Writer out, JSTranslater jsTrans) throws UnconvertableException, IOException {
        jsTrans.toJS((Object)this.data, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Screen rename(String newName) throws Exception {
        if (this.getName() == null) {
            throw new Exception("Cannot rename a Screen that has not yet been persisted");
        }
        DataSource ds = null;
        try {
            ds = DataSourceManager.get(storageDS);
            List<Map<String, Object>> renamedFiles = ds.renameFile(new DSFileSpec((Map)((Object)this.metadata)), new DSFileSpec((Map)((Object)DataTools.buildMap("fileName", newName))));
            Map<String, Object> metadataAsSaved = renamedFiles.get(0);
            Screen screen = Screen.load(metadataAsSaved, false);
            return screen;
        }
        finally {
            DataSourceManager.free(ds);
        }
    }

    public String getName() {
        return this.metadata.getString("fileName");
    }

    public DataTypeMap getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map metadata) {
        this.metadata = new DataTypeMap(metadata);
    }

    public String getOwner() {
        return this.metadata.getString("ownerId");
    }

    public void setOwner(String owner) {
        this.metadata.put("ownerId", owner);
    }

    public List<Map> getComponents() {
        return this.data.getList("components");
    }

    public void setComponents(Collection components) {
        this.data.put("components", new ArrayList(components));
    }

    static Screen _load(String name, String ownerId) throws Exception {
        return Screen._load(name, ownerId, false, null);
    }

    static Screen _load(String name, String ownerId, boolean mockMode, ValidationContext vc) throws Exception {
        Screen screen = null;
        String screenFile = DataStructCache.getInstanceFile(name, "ui", "ui");
        if (screenFile != null) {
            String xml = ISCFile.newInstance(screenFile).getAsString();
            HashMap<String, String> metadata = new HashMap<String, String>();
            metadata.put("fileName", name);
            metadata.put("fileFormat", "xml");
            metadata.put("fileType", "ui");
            screen = new Screen(xml, metadata, mockMode, vc);
        }
        if (screen == null) {
            screen = Screen.load(name, ownerId, mockMode, vc);
        }
        return screen;
    }

    public static String getLoadScript(String screenName) throws Exception {
        return Screen.getLoadScript(screenName, null);
    }

    public static String getLoadScript(String screenName, String ownerId) throws Exception {
        boolean allowNonOwnerFetch = config.getBoolean((Object)"security.allowNonOwnerFetch", false);
        Screen screen = Screen._load(screenName, allowNonOwnerFetch ? null : ownerId);
        if (screen == null) {
            throw new Exception("Unable to find screen: " + screenName);
        }
        JSTranslater jsTrans = JSTranslater.instance();
        jsTrans.setObfuscation(false);
        StringWriter out = new StringWriter();
        jsTrans.toJS(screen, out);
        return ((Object)out).toString();
    }
}

