/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.servlet;

public class CachePolicy {
    public static CachePolicy NO_CACHE = new CachePolicy("no-cache");
    public static CachePolicy NO_STORE = new CachePolicy("no-store");
    public static CachePolicy NO_TRANSFORM = new CachePolicy("no-transform");
    public static CachePolicy MUST_REVALIDATE = new CachePolicy("must-revalidate");
    public static CachePolicy PROXY_REVALIDATE = new CachePolicy("proxy-revalidate");
    public static CachePolicy MUST_UNDERSTAND = new CachePolicy("must-understand");
    public static CachePolicy PRIVATE = new CachePolicy("private");
    public static CachePolicy PUBLIC = new CachePolicy("public");
    public static CachePolicy IMMUTABLE = new CachePolicy("immutable");
    public static CachePolicy STALE_WHILE_REVALIDATE = new CachePolicy("stale-while-revalidate");
    public static CachePolicy STALE_IF_ERROR = new CachePolicy("stale-if-error");
    public static CachePolicy ISC_DISABLE_CACHE = new CachePolicy("no-cache, max-age=0");
    public static CachePolicy ISC_DISABLE_SHARED_CACHE = new CachePolicy("private");
    public static CachePolicy ISC_PERMANENT_CACHE = new CachePolicy("max-age", 31536000);
    private String directive;
    private Integer value;

    public static CachePolicy MAX_AGE(int value) {
        return new CachePolicy("max-age", value);
    }

    public static CachePolicy S_MAXAGE(int value) {
        return new CachePolicy("s-maxage", value);
    }

    private CachePolicy(String directive) {
        this(directive, null);
    }

    private CachePolicy(String directive, Integer value) {
        this.directive = directive;
        this.value = value;
    }

    public String getDirective() {
        return this.directive;
    }

    public Integer getValue() {
        return this.value;
    }

    public boolean hasValue() {
        return this.value != null;
    }
}

